# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['LicenseArgs', 'License']

@pulumi.input_type
class LicenseArgs:
    def __init__(__self__, *,
                 license: pulumi.Input[_builtins.str],
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a License resource.
        :param pulumi.Input[_builtins.str] license: The Consul license to use.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        """
        pulumi.set(__self__, "license", license)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)

    @_builtins.property
    @pulumi.getter
    def license(self) -> pulumi.Input[_builtins.str]:
        """
        The Consul license to use.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)


@pulumi.input_type
class _LicenseState:
    def __init__(__self__, *,
                 customer_id: Optional[pulumi.Input[_builtins.str]] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 expiration_time: Optional[pulumi.Input[_builtins.str]] = None,
                 features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
                 installation_id: Optional[pulumi.Input[_builtins.str]] = None,
                 issue_time: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 license_id: Optional[pulumi.Input[_builtins.str]] = None,
                 product: Optional[pulumi.Input[_builtins.str]] = None,
                 start_time: Optional[pulumi.Input[_builtins.str]] = None,
                 valid: Optional[pulumi.Input[_builtins.bool]] = None,
                 warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None):
        """
        Input properties used for looking up and filtering License resources.
        :param pulumi.Input[_builtins.str] customer_id: The ID of the customer the license is attached to.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.str] expiration_time: The expiration time of the license.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] features: The features for which the license is valid.
        :param pulumi.Input[_builtins.str] installation_id: The ID of the current installation.
        :param pulumi.Input[_builtins.str] issue_time: The date the license was issued.
        :param pulumi.Input[_builtins.str] license: The Consul license to use.
        :param pulumi.Input[_builtins.str] license_id: The ID of the license used.
        :param pulumi.Input[_builtins.str] product: The product for which the license is valid.
        :param pulumi.Input[_builtins.str] start_time: The start time of the license.
        :param pulumi.Input[_builtins.bool] valid: Whether the license is valid.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] warnings: A list of warning messages regarding the license validity.
        """
        if customer_id is not None:
            pulumi.set(__self__, "customer_id", customer_id)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if expiration_time is not None:
            pulumi.set(__self__, "expiration_time", expiration_time)
        if features is not None:
            pulumi.set(__self__, "features", features)
        if installation_id is not None:
            pulumi.set(__self__, "installation_id", installation_id)
        if issue_time is not None:
            pulumi.set(__self__, "issue_time", issue_time)
        if license is not None:
            pulumi.set(__self__, "license", license)
        if license_id is not None:
            pulumi.set(__self__, "license_id", license_id)
        if product is not None:
            pulumi.set(__self__, "product", product)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if valid is not None:
            pulumi.set(__self__, "valid", valid)
        if warnings is not None:
            pulumi.set(__self__, "warnings", warnings)

    @_builtins.property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the customer the license is attached to.
        """
        return pulumi.get(self, "customer_id")

    @customer_id.setter
    def customer_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "customer_id", value)

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "datacenter", value)

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The expiration time of the license.
        """
        return pulumi.get(self, "expiration_time")

    @expiration_time.setter
    def expiration_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "expiration_time", value)

    @_builtins.property
    @pulumi.getter
    def features(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        The features for which the license is valid.
        """
        return pulumi.get(self, "features")

    @features.setter
    def features(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "features", value)

    @_builtins.property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the current installation.
        """
        return pulumi.get(self, "installation_id")

    @installation_id.setter
    def installation_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "installation_id", value)

    @_builtins.property
    @pulumi.getter(name="issueTime")
    def issue_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The date the license was issued.
        """
        return pulumi.get(self, "issue_time")

    @issue_time.setter
    def issue_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "issue_time", value)

    @_builtins.property
    @pulumi.getter
    def license(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The Consul license to use.
        """
        return pulumi.get(self, "license")

    @license.setter
    def license(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license", value)

    @_builtins.property
    @pulumi.getter(name="licenseId")
    def license_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the license used.
        """
        return pulumi.get(self, "license_id")

    @license_id.setter
    def license_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "license_id", value)

    @_builtins.property
    @pulumi.getter
    def product(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The product for which the license is valid.
        """
        return pulumi.get(self, "product")

    @product.setter
    def product(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "product", value)

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The start time of the license.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "start_time", value)

    @_builtins.property
    @pulumi.getter
    def valid(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Whether the license is valid.
        """
        return pulumi.get(self, "valid")

    @valid.setter
    def valid(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "valid", value)

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]:
        """
        A list of warning messages regarding the license validity.
        """
        return pulumi.get(self, "warnings")

    @warnings.setter
    def warnings(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "warnings", value)


@pulumi.type_token("consul:index/license:License")
class License(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        > **NOTE:** This feature requires [Consul Enterprise](https://www.consul.io/docs/enterprise/index.html).

        The `License` resource provides datacenter-level management of
        the Consul Enterprise license. If ACLs are enabled then a token with operator
        privileges may be required in order to use this command.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul
        import pulumi_std as std

        license = consul.License("license", license=std.file(input="license.hclic").result)
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.str] license: The Consul license to use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: LicenseArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        > **NOTE:** This feature requires [Consul Enterprise](https://www.consul.io/docs/enterprise/index.html).

        The `License` resource provides datacenter-level management of
        the Consul Enterprise license. If ACLs are enabled then a token with operator
        privileges may be required in order to use this command.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul
        import pulumi_std as std

        license = consul.License("license", license=std.file(input="license.hclic").result)
        ```

        :param str resource_name: The name of the resource.
        :param LicenseArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(LicenseArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 datacenter: Optional[pulumi.Input[_builtins.str]] = None,
                 license: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = LicenseArgs.__new__(LicenseArgs)

            __props__.__dict__["datacenter"] = datacenter
            if license is None and not opts.urn:
                raise TypeError("Missing required property 'license'")
            __props__.__dict__["license"] = None if license is None else pulumi.Output.secret(license)
            __props__.__dict__["customer_id"] = None
            __props__.__dict__["expiration_time"] = None
            __props__.__dict__["features"] = None
            __props__.__dict__["installation_id"] = None
            __props__.__dict__["issue_time"] = None
            __props__.__dict__["license_id"] = None
            __props__.__dict__["product"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["valid"] = None
            __props__.__dict__["warnings"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["license"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(License, __self__).__init__(
            'consul:index/license:License',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            customer_id: Optional[pulumi.Input[_builtins.str]] = None,
            datacenter: Optional[pulumi.Input[_builtins.str]] = None,
            expiration_time: Optional[pulumi.Input[_builtins.str]] = None,
            features: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None,
            installation_id: Optional[pulumi.Input[_builtins.str]] = None,
            issue_time: Optional[pulumi.Input[_builtins.str]] = None,
            license: Optional[pulumi.Input[_builtins.str]] = None,
            license_id: Optional[pulumi.Input[_builtins.str]] = None,
            product: Optional[pulumi.Input[_builtins.str]] = None,
            start_time: Optional[pulumi.Input[_builtins.str]] = None,
            valid: Optional[pulumi.Input[_builtins.bool]] = None,
            warnings: Optional[pulumi.Input[Sequence[pulumi.Input[_builtins.str]]]] = None) -> 'License':
        """
        Get an existing License resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] customer_id: The ID of the customer the license is attached to.
        :param pulumi.Input[_builtins.str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[_builtins.str] expiration_time: The expiration time of the license.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] features: The features for which the license is valid.
        :param pulumi.Input[_builtins.str] installation_id: The ID of the current installation.
        :param pulumi.Input[_builtins.str] issue_time: The date the license was issued.
        :param pulumi.Input[_builtins.str] license: The Consul license to use.
        :param pulumi.Input[_builtins.str] license_id: The ID of the license used.
        :param pulumi.Input[_builtins.str] product: The product for which the license is valid.
        :param pulumi.Input[_builtins.str] start_time: The start time of the license.
        :param pulumi.Input[_builtins.bool] valid: Whether the license is valid.
        :param pulumi.Input[Sequence[pulumi.Input[_builtins.str]]] warnings: A list of warning messages regarding the license validity.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _LicenseState.__new__(_LicenseState)

        __props__.__dict__["customer_id"] = customer_id
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["expiration_time"] = expiration_time
        __props__.__dict__["features"] = features
        __props__.__dict__["installation_id"] = installation_id
        __props__.__dict__["issue_time"] = issue_time
        __props__.__dict__["license"] = license
        __props__.__dict__["license_id"] = license_id
        __props__.__dict__["product"] = product
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["valid"] = valid
        __props__.__dict__["warnings"] = warnings
        return License(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="customerId")
    def customer_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the customer the license is attached to.
        """
        return pulumi.get(self, "customer_id")

    @_builtins.property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @_builtins.property
    @pulumi.getter(name="expirationTime")
    def expiration_time(self) -> pulumi.Output[_builtins.str]:
        """
        The expiration time of the license.
        """
        return pulumi.get(self, "expiration_time")

    @_builtins.property
    @pulumi.getter
    def features(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        The features for which the license is valid.
        """
        return pulumi.get(self, "features")

    @_builtins.property
    @pulumi.getter(name="installationId")
    def installation_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the current installation.
        """
        return pulumi.get(self, "installation_id")

    @_builtins.property
    @pulumi.getter(name="issueTime")
    def issue_time(self) -> pulumi.Output[_builtins.str]:
        """
        The date the license was issued.
        """
        return pulumi.get(self, "issue_time")

    @_builtins.property
    @pulumi.getter
    def license(self) -> pulumi.Output[_builtins.str]:
        """
        The Consul license to use.
        """
        return pulumi.get(self, "license")

    @_builtins.property
    @pulumi.getter(name="licenseId")
    def license_id(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the license used.
        """
        return pulumi.get(self, "license_id")

    @_builtins.property
    @pulumi.getter
    def product(self) -> pulumi.Output[_builtins.str]:
        """
        The product for which the license is valid.
        """
        return pulumi.get(self, "product")

    @_builtins.property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[_builtins.str]:
        """
        The start time of the license.
        """
        return pulumi.get(self, "start_time")

    @_builtins.property
    @pulumi.getter
    def valid(self) -> pulumi.Output[_builtins.bool]:
        """
        Whether the license is valid.
        """
        return pulumi.get(self, "valid")

    @_builtins.property
    @pulumi.getter
    def warnings(self) -> pulumi.Output[Sequence[_builtins.str]]:
        """
        A list of warning messages regarding the license validity.
        """
        return pulumi.get(self, "warnings")

