"""TennisAbstract team model."""

# pylint: disable=duplicate-code,too-many-locals,too-many-arguments
import datetime

import pytest_is_running
from scrapesession.scrapesession import ScrapeSession  # type: ignore

from ....cache import MEMORY
from ...delimiter import DELIMITER
from ...google.google_news_model import create_google_news_models
from ...league import League
from ...team_model import VERSION, TeamModel
from ...x.x_social_model import create_x_social_model
from .atp_tennisabstract_player_model import create_tennisabstract_player_model


def _create_tennisabstract_team_model(
    session: ScrapeSession,
    dt: datetime.datetime,
    league: League,
    player_urls: list[str],
    ace_percentages: list[float],
    double_fault_percentages: list[float],
    first_serves_ins: list[float],
    first_serve_percentages: list[float],
    second_serve_percentages: list[float],
    break_points_saveds: list[float],
    return_points_won_percentages: list[float],
    winners: list[int],
    winners_fronthands: list[int],
    winners_backhands: list[int],
    unforced_errors: list[int],
    unforced_errors_fronthand: list[int],
    unforced_errors_backhand: list[int],
    serve_points: list[int],
    serves_won: list[float],
    serves_aces: list[float],
    serves_unreturned: list[float],
    serves_forced_error_percentage: list[float],
    serves_won_in_three_shots_or_less: list[float],
    serves_wide_percentage: list[float],
    serves_body_percentage: list[float],
    serves_t_percentage: list[float],
    serves_wide_deuce_percentage: list[float],
    serves_body_deuce_percentage: list[float],
    serves_t_deuce_percentage: list[float],
    serves_wide_ad_percentage: list[float],
    serves_body_ad_percentage: list[float],
    serves_t_ad_percentage: list[float],
    serves_net_percentage: list[float],
    serves_wide_direction_percentage: list[float],
    shots_deep_percentage: list[float],
    shots_deep_wide_percentage: list[float],
    shots_foot_errors_percentage: list[float],
    shots_unknown_percentage: list[float],
    points_won_percentage: list[float],
    version: str,
    points: float,
) -> TeamModel:
    players = [
        create_tennisabstract_player_model(
            session=session,
            dt=dt,
            league=league,
            url=x,
            ace_percentages=ace_percentages,
            team_idx=count,
            double_fault_percentages=double_fault_percentages,
            first_serves_ins=first_serves_ins,
            first_serve_percentages=first_serve_percentages,
            second_serve_percentages=second_serve_percentages,
            break_points_saveds=break_points_saveds,
            return_points_won_percentages=return_points_won_percentages,
            winners=winners,
            winners_fronthands=winners_fronthands,
            winners_backhands=winners_backhands,
            unforced_errors=unforced_errors,
            unforced_errors_fronthand=unforced_errors_fronthand,
            unforced_errors_backhand=unforced_errors_backhand,
            serve_points=serve_points,
            serves_won=serves_won,
            serves_aces=serves_aces,
            serves_unreturned=serves_unreturned,
            serves_forced_error_percentage=serves_forced_error_percentage,
            serves_won_in_three_shots_or_less=serves_won_in_three_shots_or_less,
            serves_wide_percentage=serves_wide_percentage,
            serves_body_percentage=serves_body_percentage,
            serves_t_percentage=serves_t_percentage,
            serves_wide_deuce_percentage=serves_wide_deuce_percentage,
            serves_body_deuce_percentage=serves_body_deuce_percentage,
            serves_t_deuce_percentage=serves_t_deuce_percentage,
            serves_wide_ad_percentage=serves_wide_ad_percentage,
            serves_body_ad_percentage=serves_body_ad_percentage,
            serves_t_ad_percentage=serves_t_ad_percentage,
            serves_net_percentage=serves_net_percentage,
            serves_wide_direction_percentage=serves_wide_direction_percentage,
            shots_deep_percentage=shots_deep_percentage,
            shots_deep_wide_percentage=shots_deep_wide_percentage,
            shots_foot_errors_percentage=shots_foot_errors_percentage,
            shots_unknown_percentage=shots_unknown_percentage,
            points_won_percentage=points_won_percentage,
        )
        for count, x in enumerate(player_urls)
    ]
    identifier = DELIMITER.join([x.identifier for x in players])
    name = DELIMITER.join([x.name for x in players])
    return TeamModel(
        identifier=identifier,
        name=name,
        players=players,
        odds=[],
        points=points,
        ladder_rank=None,
        location=None,
        news=create_google_news_models(name, session, dt, league),
        social=create_x_social_model(name, session, dt),
        coaches=[],
        lbw=None,
        end_dt=None,
        runs=None,
        wickets=None,
        overs=None,
        balls=None,
        byes=None,
        leg_byes=None,
        wides=None,
        no_balls=None,
        penalties=None,
        balls_per_over=None,
        fours=None,
        sixes=None,
        catches=None,
        catches_dropped=None,
        version=version,
    )


@MEMORY.cache(ignore=["session"])
def _cached_create_tennisabstract_team_model(
    session: ScrapeSession,
    dt: datetime.datetime,
    league: League,
    player_urls: list[str],
    ace_percentages: list[float],
    double_fault_percentages: list[float],
    first_serves_ins: list[float],
    first_serve_percentages: list[float],
    second_serve_percentages: list[float],
    break_points_saveds: list[float],
    return_points_won_percentages: list[float],
    winners: list[int],
    winners_fronthands: list[int],
    winners_backhands: list[int],
    unforced_errors: list[int],
    unforced_errors_fronthand: list[int],
    unforced_errors_backhand: list[int],
    serve_points: list[int],
    serves_won: list[float],
    serves_aces: list[float],
    serves_unreturned: list[float],
    serves_forced_error_percentage: list[float],
    serves_won_in_three_shots_or_less: list[float],
    serves_wide_percentage: list[float],
    serves_body_percentage: list[float],
    serves_t_percentage: list[float],
    serves_wide_deuce_percentage: list[float],
    serves_body_deuce_percentage: list[float],
    serves_t_deuce_percentage: list[float],
    serves_wide_ad_percentage: list[float],
    serves_body_ad_percentage: list[float],
    serves_t_ad_percentage: list[float],
    serves_net_percentage: list[float],
    serves_wide_direction_percentage: list[float],
    shots_deep_percentage: list[float],
    shots_deep_wide_percentage: list[float],
    shots_foot_errors_percentage: list[float],
    shots_unknown_percentage: list[float],
    points_won_percentage: list[float],
    points: float,
    version: str,
) -> TeamModel:
    return _create_tennisabstract_team_model(
        session=session,
        dt=dt,
        league=league,
        player_urls=player_urls,
        ace_percentages=ace_percentages,
        double_fault_percentages=double_fault_percentages,
        first_serves_ins=first_serves_ins,
        first_serve_percentages=first_serve_percentages,
        second_serve_percentages=second_serve_percentages,
        break_points_saveds=break_points_saveds,
        return_points_won_percentages=return_points_won_percentages,
        winners=winners,
        winners_fronthands=winners_fronthands,
        winners_backhands=winners_backhands,
        unforced_errors=unforced_errors,
        unforced_errors_fronthand=unforced_errors_fronthand,
        unforced_errors_backhand=unforced_errors_backhand,
        serve_points=serve_points,
        serves_won=serves_won,
        serves_aces=serves_aces,
        serves_unreturned=serves_unreturned,
        serves_forced_error_percentage=serves_forced_error_percentage,
        serves_won_in_three_shots_or_less=serves_won_in_three_shots_or_less,
        serves_wide_percentage=serves_wide_percentage,
        serves_body_percentage=serves_body_percentage,
        serves_t_percentage=serves_t_percentage,
        serves_wide_deuce_percentage=serves_wide_deuce_percentage,
        serves_body_deuce_percentage=serves_body_deuce_percentage,
        serves_t_deuce_percentage=serves_t_deuce_percentage,
        serves_wide_ad_percentage=serves_wide_ad_percentage,
        serves_body_ad_percentage=serves_body_ad_percentage,
        serves_t_ad_percentage=serves_t_ad_percentage,
        serves_net_percentage=serves_net_percentage,
        serves_wide_direction_percentage=serves_wide_direction_percentage,
        shots_deep_percentage=shots_deep_percentage,
        shots_deep_wide_percentage=shots_deep_wide_percentage,
        shots_foot_errors_percentage=shots_foot_errors_percentage,
        shots_unknown_percentage=shots_unknown_percentage,
        points_won_percentage=points_won_percentage,
        points=points,
        version=version,
    )


def create_tennisabstract_team_model(
    session: ScrapeSession,
    dt: datetime.datetime,
    league: League,
    player_urls: list[str],
    ace_percentages: list[float],
    double_fault_percentages: list[float],
    first_serves_ins: list[float],
    first_serve_percentages: list[float],
    second_serve_percentages: list[float],
    break_points_saveds: list[float],
    return_points_won_percentages: list[float],
    winners: list[int],
    winners_fronthands: list[int],
    winners_backhands: list[int],
    unforced_errors: list[int],
    unforced_errors_fronthand: list[int],
    unforced_errors_backhand: list[int],
    serve_points: list[int],
    serves_won: list[float],
    serves_aces: list[float],
    serves_unreturned: list[float],
    serves_forced_error_percentage: list[float],
    serves_won_in_three_shots_or_less: list[float],
    serves_wide_percentage: list[float],
    serves_body_percentage: list[float],
    serves_t_percentage: list[float],
    serves_wide_deuce_percentage: list[float],
    serves_body_deuce_percentage: list[float],
    serves_t_deuce_percentage: list[float],
    serves_wide_ad_percentage: list[float],
    serves_body_ad_percentage: list[float],
    serves_t_ad_percentage: list[float],
    serves_net_percentage: list[float],
    serves_wide_direction_percentage: list[float],
    shots_deep_percentage: list[float],
    shots_deep_wide_percentage: list[float],
    shots_foot_errors_percentage: list[float],
    shots_unknown_percentage: list[float],
    points_won_percentage: list[float],
    points: float,
) -> TeamModel:
    """Create a team model from TennisAbstract."""
    if not pytest_is_running.is_running():
        return _cached_create_tennisabstract_team_model(
            session=session,
            dt=dt,
            league=league,
            player_urls=player_urls,
            ace_percentages=ace_percentages,
            double_fault_percentages=double_fault_percentages,
            first_serves_ins=first_serves_ins,
            first_serve_percentages=first_serve_percentages,
            second_serve_percentages=second_serve_percentages,
            break_points_saveds=break_points_saveds,
            return_points_won_percentages=return_points_won_percentages,
            winners=winners,
            winners_fronthands=winners_fronthands,
            winners_backhands=winners_backhands,
            unforced_errors=unforced_errors,
            unforced_errors_fronthand=unforced_errors_fronthand,
            unforced_errors_backhand=unforced_errors_backhand,
            serve_points=serve_points,
            serves_won=serves_won,
            serves_aces=serves_aces,
            serves_unreturned=serves_unreturned,
            serves_forced_error_percentage=serves_forced_error_percentage,
            serves_won_in_three_shots_or_less=serves_won_in_three_shots_or_less,
            serves_wide_percentage=serves_wide_percentage,
            serves_body_percentage=serves_body_percentage,
            serves_t_percentage=serves_t_percentage,
            serves_wide_deuce_percentage=serves_wide_deuce_percentage,
            serves_body_deuce_percentage=serves_body_deuce_percentage,
            serves_t_deuce_percentage=serves_t_deuce_percentage,
            serves_wide_ad_percentage=serves_wide_ad_percentage,
            serves_body_ad_percentage=serves_body_ad_percentage,
            serves_t_ad_percentage=serves_t_ad_percentage,
            serves_net_percentage=serves_net_percentage,
            serves_wide_direction_percentage=serves_wide_direction_percentage,
            shots_deep_percentage=shots_deep_percentage,
            shots_deep_wide_percentage=shots_deep_wide_percentage,
            shots_foot_errors_percentage=shots_foot_errors_percentage,
            shots_unknown_percentage=shots_unknown_percentage,
            points_won_percentage=points_won_percentage,
            points=points,
            version=VERSION,
        )
    with session.cache_disabled():
        return _create_tennisabstract_team_model(
            session=session,
            dt=dt,
            league=league,
            player_urls=player_urls,
            ace_percentages=ace_percentages,
            double_fault_percentages=double_fault_percentages,
            first_serves_ins=first_serves_ins,
            first_serve_percentages=first_serve_percentages,
            second_serve_percentages=second_serve_percentages,
            break_points_saveds=break_points_saveds,
            return_points_won_percentages=return_points_won_percentages,
            winners=winners,
            winners_fronthands=winners_fronthands,
            winners_backhands=winners_backhands,
            unforced_errors=unforced_errors,
            unforced_errors_fronthand=unforced_errors_fronthand,
            unforced_errors_backhand=unforced_errors_backhand,
            serve_points=serve_points,
            serves_won=serves_won,
            serves_aces=serves_aces,
            serves_unreturned=serves_unreturned,
            serves_forced_error_percentage=serves_forced_error_percentage,
            serves_won_in_three_shots_or_less=serves_won_in_three_shots_or_less,
            serves_wide_percentage=serves_wide_percentage,
            serves_body_percentage=serves_body_percentage,
            serves_t_percentage=serves_t_percentage,
            serves_wide_deuce_percentage=serves_wide_deuce_percentage,
            serves_body_deuce_percentage=serves_body_deuce_percentage,
            serves_t_deuce_percentage=serves_t_deuce_percentage,
            serves_wide_ad_percentage=serves_wide_ad_percentage,
            serves_body_ad_percentage=serves_body_ad_percentage,
            serves_t_ad_percentage=serves_t_ad_percentage,
            serves_net_percentage=serves_net_percentage,
            serves_wide_direction_percentage=serves_wide_direction_percentage,
            shots_deep_percentage=shots_deep_percentage,
            shots_deep_wide_percentage=shots_deep_wide_percentage,
            shots_foot_errors_percentage=shots_foot_errors_percentage,
            shots_unknown_percentage=shots_unknown_percentage,
            points_won_percentage=points_won_percentage,
            points=points,
            version=VERSION,
        )
