"""NFL combined league model."""

from scrapesession.scrapesession import ScrapeSession  # type: ignore

from ...combined.combined_league_model import CombinedLeagueModel
from ...league import League
from ..aussportsbetting.nfl_aussportsbetting_league_model import \
    NFLAusSportsBettingLeagueModel
from ..espn.nfl_espn_league_model import NFLESPNLeagueModel
from ..oddsportal.nfl_oddsportal_league_model import NFLOddsPortalLeagueModel

LOS_ANGELES_RAMS = "135907"
CHICAGO_BEARS = "134938"
HOUSTAN_TEXANS = "134926"
NEW_YORK_GIANTS = "134935"
DETROIT_LIONS = "134939"
NEW_ENGLAND_PATRIOTS = "134920"
CAROLINA_PANTHERS = "134943"
PITTSBURGH_STEALERS = "134925"
MIAMI_DOLPHINS = "134919"
ATLANTA_FALCONS = "134942"
BALTIMORE_RAVENS = "134922"
PHILADELPHIA_EAGLES = "134936"
NEW_YORK_JETS = "134921"
WASHINGTON_COMMANDERS = "134937"
BUFFALO_BILLS = "134918"
MINNESOTA_VIKINGS = "134941"
LAS_VEGAS_RAIDERS = "134932"
CLEVELAND_BROWNS = "134924"
GREEN_BAY_PACKERS = "134940"
JACKSONVILLE_JAGUARS = "134928"
KANSAS_CITY_CHIEFS = "134931"
TENNESSEE_TITANS = "134929"
SAN_FRANCISCO_49ERS = "134948"
CINCINATTI_BENGALS = "134923"
TAMPA_BAY_BUCCANEERS = "134945"
LOS_ANGELES_CHARGERS = "135908"
SEATTLE_SEAHAWKS = "134949"
ARIZONA_CARDINALS = "134946"
NEW_ORLEANS_SAINTS = "134944"
INDIANAPOLIS_COLTS = "134927"
DENVER_BRONCOS = "134930"
DALLAS_COWBOYS = "134934"
AMERICAN_FOOTBALL_CONFERENCE = "31"
NATIONAL_FOOTBALL_CONFERENCE = "32"
NFL_TEAM_IDENTITY_MAP = {
    "135907": LOS_ANGELES_RAMS,
    "134938": CHICAGO_BEARS,
    "134926": HOUSTAN_TEXANS,
    "134935": NEW_YORK_GIANTS,
    "134939": DETROIT_LIONS,
    "134920": NEW_ENGLAND_PATRIOTS,
    "134943": CAROLINA_PANTHERS,
    "134925": PITTSBURGH_STEALERS,
    "134919": MIAMI_DOLPHINS,
    "134942": ATLANTA_FALCONS,
    "134922": BALTIMORE_RAVENS,
    "134936": PHILADELPHIA_EAGLES,
    "134921": NEW_YORK_JETS,
    "134937": WASHINGTON_COMMANDERS,
    "134918": BUFFALO_BILLS,
    "134941": MINNESOTA_VIKINGS,
    "134932": LAS_VEGAS_RAIDERS,
    "134924": CLEVELAND_BROWNS,
    "134940": GREEN_BAY_PACKERS,
    "134928": JACKSONVILLE_JAGUARS,
    "134931": KANSAS_CITY_CHIEFS,
    "134929": TENNESSEE_TITANS,
    "134948": SAN_FRANCISCO_49ERS,
    "134923": CINCINATTI_BENGALS,
    "134945": TAMPA_BAY_BUCCANEERS,
    "135908": LOS_ANGELES_CHARGERS,
    "134949": SEATTLE_SEAHAWKS,
    "134946": ARIZONA_CARDINALS,
    "134944": NEW_ORLEANS_SAINTS,
    "134927": INDIANAPOLIS_COLTS,
    "134930": DENVER_BRONCOS,
    "134934": DALLAS_COWBOYS,
    "5": CLEVELAND_BROWNS,
    "20": NEW_YORK_JETS,
    "17": NEW_ENGLAND_PATRIOTS,
    "34": HOUSTAN_TEXANS,
    "26": SEATTLE_SEAHAWKS,
    "16": MINNESOTA_VIKINGS,
    "4": CINCINATTI_BENGALS,
    "9": GREEN_BAY_PACKERS,
    "8": DETROIT_LIONS,
    "19": NEW_YORK_GIANTS,
    "15": MIAMI_DOLPHINS,
    "1": ATLANTA_FALCONS,
    "27": TAMPA_BAY_BUCCANEERS,
    "23": PITTSBURGH_STEALERS,
    "28": WASHINGTON_COMMANDERS,
    "22": ARIZONA_CARDINALS,
    "7": DENVER_BRONCOS,
    "2": BUFFALO_BILLS,
    "11": INDIANAPOLIS_COLTS,
    "3": CHICAGO_BEARS,
    "10": TENNESSEE_TITANS,
    "29": CAROLINA_PANTHERS,
    "6": DALLAS_COWBOYS,
    "30": JACKSONVILLE_JAGUARS,
    "33": BALTIMORE_RAVENS,
    "21": PHILADELPHIA_EAGLES,
    "14": LOS_ANGELES_RAMS,
    "24": LOS_ANGELES_CHARGERS,
    "18": NEW_ORLEANS_SAINTS,
    "12": KANSAS_CITY_CHIEFS,
    "13": LAS_VEGAS_RAIDERS,
    "25": SAN_FRANCISCO_49ERS,
    "31": AMERICAN_FOOTBALL_CONFERENCE,
    "32": NATIONAL_FOOTBALL_CONFERENCE,
    "134933": LOS_ANGELES_CHARGERS,
    "134947": LOS_ANGELES_RAMS,
    "135834": LOS_ANGELES_RAMS,
    "Miami Dolphins": MIAMI_DOLPHINS,
    "Pittsburgh Steelers": PITTSBURGH_STEALERS,
    "San Francisco 49ers": SAN_FRANCISCO_49ERS,
    "Arizona Cardinals": ARIZONA_CARDINALS,
    "Atlanta Falcons": ATLANTA_FALCONS,
    "Carolina Panthers": CAROLINA_PANTHERS,
    "New Orleans Saints": NEW_ORLEANS_SAINTS,
    "Cleveland Browns": CLEVELAND_BROWNS,
    "Seattle Seahawks": SEATTLE_SEAHAWKS,
    "Detroit Lions": DETROIT_LIONS,
    "Chicago Bears": CHICAGO_BEARS,
    "Green Bay Packers": GREEN_BAY_PACKERS,
    "Philadelphia Eagles": PHILADELPHIA_EAGLES,
    "Houston Texans": HOUSTAN_TEXANS,
    "Dallas Cowboys": DALLAS_COWBOYS,
    "Jacksonville Jaguars": JACKSONVILLE_JAGUARS,
    "Cincinnati Bengals": CINCINATTI_BENGALS,
    "Kansas City Chiefs": KANSAS_CITY_CHIEFS,
    "Buffalo Bills": BUFFALO_BILLS,
    "New England Patriots": NEW_ENGLAND_PATRIOTS,
    "Indianapolis Colts": INDIANAPOLIS_COLTS,
    "New York Giants": NEW_YORK_GIANTS,
    "Denver Broncos": DENVER_BRONCOS,
    "St. Louis Rams": LOS_ANGELES_RAMS,
    "Baltimore Ravens": BALTIMORE_RAVENS,
    "Tampa Bay Buccaneers": TAMPA_BAY_BUCCANEERS,
    "New York Jets": NEW_YORK_JETS,
    "Tennessee Titans": TENNESSEE_TITANS,
    "San Diego Chargers": LOS_ANGELES_CHARGERS,
    "Oakland Raiders": LAS_VEGAS_RAIDERS,
    "Minnesota Vikings": MINNESOTA_VIKINGS,
    "Washington Redskins": WASHINGTON_COMMANDERS,
    "Los Angeles Rams": LOS_ANGELES_RAMS,
    "Los Angeles Chargers": LOS_ANGELES_CHARGERS,
    "Washington Football Team": WASHINGTON_COMMANDERS,
    "Las Vegas Raiders": LAS_VEGAS_RAIDERS,
    "Washington Commanders": WASHINGTON_COMMANDERS,
}
EMPOWER_FIELD = "18784"
TOM_BENSOM_HALL_OF_FAME_STADIUM = "28739"
METLIFE_STADIUM = "15812"
GILETTE_STADIUM = "15816"
ACRISURE_STADIUM = "29572"
HARD_ROCK_STADIUM = "20373"
MTT_BANK_STADIUM = "21598"
HIGHMARK_STADIUM = "30812"
US_BANK_STADIUM = "15803"
CLEVELAND_BROWNS_STADIUM = "29570"
EVERBANK_STADIUM = "29576"
NISSAN_STADIUM = "30912"
PAYCOR_STADIUM = "29569"
SOFI_STADIUM = "23720"
STATE_FARM_STADIUM = "16027"
LUCAS_OIL_STADIUM = "15807"
NRG_STADIUM = "15873"
SOLDIER_FIELD = "16092"
ARROWHEAD_STADIUM = "29575"
BANK_OF_AMERICA_STADIUM = "18776"
ALLEGIANT_STADIUM = "21293"
LEVIS_STADIUM = "16090"
MERCEDEZ_BENZ_STADIUM = "16029"
RAYMOND_JAMES_STADIUM = "15874"
LAMBEAU_FIELD = "17146"
LINCOLN_FINANCIAL_FIELD = "16094"
FORD_FIELD = "15808"
ATT_STADIUM = "15802"
LUMEN_FIELD = "19833"
CAESARS_SUPERDOME = "29571"
NEO_QUIMICA_ARENA = "16461"
FEDEX_FIELD = "29574"
TOTTENHAM_HOTSPUR_STADIUM = "16118"
WEMBLEY_STADIUM = "16163"
ALLIANZ_ARENA = "15537"
DEUTSCHE_BANK_PARK = "17590"
CAMPING_WORLD_STADIUM = "4013"
ESTADIO_AZTECA = "1850"
DIGNITY_HEALTH_SPORTS_PARK = "538"
OAKLAND_COLISEUM = "3867"
LOS_ANGELES_MEMORIAL_COLISEUM = "477"
TWICKENHAM_STADIUM = "5128"
GEORGIA_DOME = "3495"
SDCCU_STADIUM = "3932"
TRANS_WORLD_DOME = "3494"
CANDLESTICK_PARK = "3669"
ROGERS_CENTRE = "1822"
ALOHA_STADIUM = "3610"
TEXAS_STADIUM = "3954"
MOUNTAIN_AMERICA_STADIUM = "3947"
SILVERDOME = "3929"
LIBERTY_BOWL_MEMORIAL_STADIUM = "21515"
RFK_STADIUM = "18381"
VANDERBILT_STADIUM = "21572"
ROSE_BOWL = "16093"
MIAMI_ORANGE_BOWL = "20447"
STANFORD_STADIUM = "18382"
MILWAUKEE_COUNTY_STADIUM = "30850"
SHEA_STADIUM = "21813"
YALE_BOWL = "21608"
TIGER_STADIUM = "21532"
WAR_MEMORIAL_STADIUM = "21581"
YANKEE_STADIUM = "19474"
MUNICIPAL_STADIUM = "21642"
COTTON_BOWL = "18378"
KEZAR_STADIUM = "25773"
FRANKLIN_FIELD = "21659"
WRIGLEY_FIELD = "30763"
CITY_STADIUM = "19533"
IG_FIELD = "4461"
RICE_STADIUM = "21557"
INDEPENDENCE_STADIUM = "3766"
MEMORIAL_STADIUM = "16280"
HUNTINGTON_BANK_FIELD = "19480"
NFL_VENUE_IDENTITY_MAP = {
    # SportsDB
    "18784": EMPOWER_FIELD,
    "28739": TOM_BENSOM_HALL_OF_FAME_STADIUM,
    "15812": METLIFE_STADIUM,
    "15816": GILETTE_STADIUM,
    "29572": ACRISURE_STADIUM,
    "20373": HARD_ROCK_STADIUM,
    "21598": MTT_BANK_STADIUM,
    "30812": HIGHMARK_STADIUM,
    "15803": US_BANK_STADIUM,
    "29570": CLEVELAND_BROWNS_STADIUM,
    "29576": EVERBANK_STADIUM,
    "30912": NISSAN_STADIUM,
    "29569": PAYCOR_STADIUM,
    "23720": SOFI_STADIUM,
    "16027": STATE_FARM_STADIUM,
    "15807": LUCAS_OIL_STADIUM,
    "15873": NRG_STADIUM,
    "16092": SOLDIER_FIELD,
    "29575": ARROWHEAD_STADIUM,
    "18776": BANK_OF_AMERICA_STADIUM,
    "21293": ALLEGIANT_STADIUM,
    "16090": LEVIS_STADIUM,
    "16029": MERCEDEZ_BENZ_STADIUM,
    "15874": RAYMOND_JAMES_STADIUM,
    "17146": LAMBEAU_FIELD,
    "16094": LINCOLN_FINANCIAL_FIELD,
    "15808": FORD_FIELD,
    "15802": ATT_STADIUM,
    "19833": LUMEN_FIELD,
    "29571": CAESARS_SUPERDOME,
    "16461": NEO_QUIMICA_ARENA,
    "29574": FEDEX_FIELD,
    "16118": TOTTENHAM_HOTSPUR_STADIUM,
    "16163": WEMBLEY_STADIUM,
    "15537": ALLIANZ_ARENA,
    "29573": LEVIS_STADIUM,
    "3718": TOM_BENSOM_HALL_OF_FAME_STADIUM,
    "3738": GILETTE_STADIUM,
    "3673": LUMEN_FIELD,
    "3874": PAYCOR_STADIUM,
    "3727": FORD_FIELD,
    "3948": HARD_ROCK_STADIUM,
    "3886": RAYMOND_JAMES_STADIUM,
    "3679": CLEVELAND_BROWNS_STADIUM,
    "3970": STATE_FARM_STADIUM,
    "3883": HIGHMARK_STADIUM,
    "3933": SOLDIER_FIELD,
    "3628": BANK_OF_AMERICA_STADIUM,
    "3687": ATT_STADIUM,
    "3814": MTT_BANK_STADIUM,
    "7065": SOFI_STADIUM,
    "3493": CAESARS_SUPERDOME,
    "6501": ALLEGIANT_STADIUM,
    "3806": LINCOLN_FINANCIAL_FIELD,
    "3839": METLIFE_STADIUM,
    "5348": MERCEDEZ_BENZ_STADIUM,
    "3891": NRG_STADIUM,
    "3752": ACRISURE_STADIUM,
    "3812": LUCAS_OIL_STADIUM,
    "3798": LAMBEAU_FIELD,
    "5239": US_BANK_STADIUM,
    "4738": LEVIS_STADIUM,
    "3719": FEDEX_FIELD,
    "3810": NISSAN_STADIUM,
    "3622": ARROWHEAD_STADIUM,
    "3712": EVERBANK_STADIUM,
    "3937": EMPOWER_FIELD,
    "15814": LEVIS_STADIUM,
    "17590": DEUTSCHE_BANK_PARK,
    "2455": WEMBLEY_STADIUM,
    "5534": TOTTENHAM_HOTSPUR_STADIUM,
    "1875": DEUTSCHE_BANK_PARK,
    "4013": CAMPING_WORLD_STADIUM,
    "1775": ALLIANZ_ARENA,
    "1850": ESTADIO_AZTECA,
    "21629": ARROWHEAD_STADIUM,
    "21607": PAYCOR_STADIUM,
    "538": DIGNITY_HEALTH_SPORTS_PARK,
    "3867": OAKLAND_COLISEUM,
    "477": LOS_ANGELES_MEMORIAL_COLISEUM,
    "5128": TWICKENHAM_STADIUM,
    "3495": GEORGIA_DOME,
    "3932": SDCCU_STADIUM,
    "3494": TRANS_WORLD_DOME,
    "3953": US_BANK_STADIUM,
    "3669": CANDLESTICK_PARK,
    "16": US_BANK_STADIUM,
    "1822": ROGERS_CENTRE,
    "3610": ALOHA_STADIUM,
    "3736": METLIFE_STADIUM,
    "3840": US_BANK_STADIUM,
    "3954": TEXAS_STADIUM,
    "50": EMPOWER_FIELD,
    "24": CANDLESTICK_PARK,
    "3888": LUCAS_OIL_STADIUM,
    "3947": MOUNTAIN_AMERICA_STADIUM,
    "3977": LINCOLN_FINANCIAL_FIELD,
    "3929": SILVERDOME,
    "28229": TRANS_WORLD_DOME,
    "30854": LUMEN_FIELD,
    "15804": GEORGIA_DOME,
    "28181": CAESARS_SUPERDOME,
    "18214": METLIFE_STADIUM,
    "23380": EMPOWER_FIELD,
    "18379": SILVERDOME,
    "18383": GILETTE_STADIUM,
    "25758": LINCOLN_FINANCIAL_FIELD,
    "20450": TEXAS_STADIUM,
    "20449": ACRISURE_STADIUM,
    "21559": SDCCU_STADIUM,
    "21501": MOUNTAIN_AMERICA_STADIUM,
    "3955": ACRISURE_STADIUM,
    "21515": LIBERTY_BOWL_MEMORIAL_STADIUM,
    "28192": NRG_STADIUM,
    "18381": RFK_STADIUM,
    "30845": PAYCOR_STADIUM,
    "30853": CANDLESTICK_PARK,
    "30846": PAYCOR_STADIUM,
    "20451": LOS_ANGELES_MEMORIAL_COLISEUM,
    "21572": VANDERBILT_STADIUM,
    "16093": ROSE_BOWL,
    "20447": MIAMI_ORANGE_BOWL,
    "18382": STANFORD_STADIUM,
    "30850": MILWAUKEE_COUNTY_STADIUM,
    "21813": SHEA_STADIUM,
    "20448": GILETTE_STADIUM,
    "21608": YALE_BOWL,
    "21532": TIGER_STADIUM,
    "21581": WAR_MEMORIAL_STADIUM,
    "19474": YANKEE_STADIUM,
    "21642": MUNICIPAL_STADIUM,
    "18378": COTTON_BOWL,
    "25773": KEZAR_STADIUM,
    "21659": FRANKLIN_FIELD,
    "30763": WRIGLEY_FIELD,
    "19533": CITY_STADIUM,
    "4461": IG_FIELD,
    "21557": RICE_STADIUM,
    "3766": INDEPENDENCE_STADIUM,
    "16280": MEMORIAL_STADIUM,
    "23848": SHEA_STADIUM,
    "17145": EMPOWER_FIELD,
    "30856": ATT_STADIUM,
    "19480": HUNTINGTON_BANK_FIELD,
    # OddsPortal
    "Lincoln Financial Field": LINCOLN_FINANCIAL_FIELD,
    "Lucas Oil Stadium": LUCAS_OIL_STADIUM,
    # ESPN
    "8748": NEO_QUIMICA_ARENA,
}
NFL_PLAYER_IDENTITY_MAP: dict[str, str] = {}


class NFLCombinedLeagueModel(CombinedLeagueModel):
    """NFL combined implementation of the league model."""

    def __init__(self, session: ScrapeSession, league_filter: str | None) -> None:
        super().__init__(
            session,
            League.NFL,
            [
                NFLESPNLeagueModel(session, position=0),
                NFLAusSportsBettingLeagueModel(session, position=1),
                NFLOddsPortalLeagueModel(session, position=2),
                # NFLSportsDBLeagueModel(session, position=3),
                # NFLSportsReferenceLeagueModel(session, position=4),
            ],
            league_filter,
        )

    @classmethod
    def name(cls) -> str:
        return "nfl-combined-league-model"

    @classmethod
    def team_identity_map(cls) -> dict[str, str]:
        return NFL_TEAM_IDENTITY_MAP

    @classmethod
    def venue_identity_map(cls) -> dict[str, str]:
        return NFL_VENUE_IDENTITY_MAP

    @classmethod
    def player_identity_map(cls) -> dict[str, str]:
        return NFL_PLAYER_IDENTITY_MAP
