"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SigningProfile = exports.Platform = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const signer_generated_1 = require("./signer.generated");
/**
 * Platforms that are allowed with signing config.
 * @see https://docs.aws.amazon.com/signer/latest/developerguide/gs-platform.html
 */
class Platform {
    constructor(platformId) {
        this.platformId = platformId;
    }
}
exports.Platform = Platform;
_a = JSII_RTTI_SYMBOL_1;
Platform[_a] = { fqn: "@aws-cdk/aws-signer.Platform", version: "1.158.0" };
/**
 * Specification of signature format and signing algorithms for AWS IoT Device.
 */
Platform.AWS_IOT_DEVICE_MANAGEMENT_SHA256_ECDSA = new Platform('AWSIoTDeviceManagement-SHA256-ECDSA');
/**
 * Specification of signature format and signing algorithms for AWS Lambda.
 */
Platform.AWS_LAMBDA_SHA384_ECDSA = new Platform('AWSLambda-SHA384-ECDSA');
/**
 * Specification of signature format and signing algorithms with
 * SHA1 hash and RSA encryption for Amazon FreeRTOS.
 */
Platform.AMAZON_FREE_RTOS_TI_CC3220SF = new Platform('AmazonFreeRTOS-TI-CC3220SF');
/**
 * Specification of signature format and signing algorithms with
 * SHA256 hash and ECDSA encryption for Amazon FreeRTOS.
 */
Platform.AMAZON_FREE_RTOS_DEFAULT = new Platform('AmazonFreeRTOS-Default');
/**
 * Defines a Signing Profile.
 *
 * @resource AWS::Signer::SigningProfile
 */
class SigningProfile extends core_1.Resource {
    constructor(scope, id, props) {
        var _c;
        super(scope, id, {
            physicalName: props.signingProfileName,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_signer_SigningProfileProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        const resource = new signer_generated_1.CfnSigningProfile(this, 'Resource', {
            platformId: props.platform.platformId,
            signatureValidityPeriod: props.signatureValidity ? {
                type: 'DAYS',
                value: (_c = props.signatureValidity) === null || _c === void 0 ? void 0 : _c.toDays(),
            } : {
                type: 'MONTHS',
                value: 135,
            },
        });
        this.signingProfileArn = resource.attrArn;
        this.signingProfileName = resource.attrProfileName;
        this.signingProfileVersion = resource.attrProfileVersion;
        this.signingProfileVersionArn = resource.attrProfileVersionArn;
    }
    /**
     * Creates a Signing Profile construct that represents an external Signing Profile.
     *
     * @param scope The parent creating construct (usually `this`).
     * @param id The construct's name.
     * @param attrs A `SigningProfileAttributes` object.
     */
    static fromSigningProfileAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_signer_SigningProfileAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSigningProfileAttributes);
            }
            throw error;
        }
        class Import extends core_1.Resource {
            constructor(signingProfileArn, signingProfileProfileVersionArn) {
                super(scope, id);
                this.signingProfileName = attrs.signingProfileName;
                this.signingProfileVersion = attrs.signingProfileVersion;
                this.signingProfileArn = signingProfileArn;
                this.signingProfileVersionArn = signingProfileProfileVersionArn;
            }
        }
        const signingProfileArn = core_1.Stack.of(scope).formatArn({
            service: 'signer',
            resource: '',
            resourceName: `/signing-profiles/${attrs.signingProfileName}`,
        });
        const SigningProfileVersionArn = core_1.Stack.of(scope).formatArn({
            service: 'signer',
            resource: '',
            resourceName: `/signing-profiles/${attrs.signingProfileName}/${attrs.signingProfileVersion}`,
        });
        return new Import(signingProfileArn, SigningProfileVersionArn);
    }
}
exports.SigningProfile = SigningProfile;
_b = JSII_RTTI_SYMBOL_1;
SigningProfile[_b] = { fqn: "@aws-cdk/aws-signer.SigningProfile", version: "1.158.0" };
//# sourceMappingURL=data:application/json;base64,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