# noqa: INP001
r"""Script to create or update the package versions."""

from __future__ import annotations

import logging
from pathlib import Path

from ghflowgen.utils.export import save_json
from ghflowgen.version import (
    get_latest_major_versions,
    get_latest_minor_versions,
    get_versions,
)

logger = logging.getLogger(__name__)


def get_package_versions() -> dict[str, list[str]]:
    r"""Get the versions for each package.

    Returns:
        A dictionary with the versions for each package.
    """
    return {
        "coola": list(get_versions("coola", lower="0.9.1", upper="1.0.0")),
        "packaging": list(get_latest_major_versions("packaging", lower="23.0")),
        "requests": list(get_latest_minor_versions("requests", lower="2.30.0", upper="3.0.0")),
    }


def main() -> None:
    r"""Generate the package versions and save them in a JSON file."""
    versions = get_package_versions()
    logger.info(f"{versions=}")
    path = Path(__file__).parent.parent.joinpath("assets").joinpath("package_versions.json")
    logger.info(f"Saving package versions to {path}")
    save_json(versions, path, exist_ok=True)


if __name__ == "__main__":
    logging.basicConfig(level=logging.INFO)
    main()
