# Generated by Django 4.1.7 on 2023-04-19 05:26

import django.db.models.deletion
import django.utils.timezone
import django_fsm
from django.db import migrations, models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
        ("tags", "0001_initial"),
        ("directory", "0001_initial"),
        ("wbcore", "0001_initial_squashed_squashed_0010_preset_appliedpreset"),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Style",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255, unique=True)),
                ("style", models.TextField(default="")),
            ],
        ),
        migrations.CreateModel(
            name="Template",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=255, unique=True)),
                ("template", models.TextField(default="")),
                ("styles", models.ManyToManyField(blank=True, related_name="templates", to="wbwriter.style")),
                (
                    "footer_template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="footer_templates",
                        to="wbwriter.template",
                    ),
                ),
                (
                    "header_template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="header_templates",
                        to="wbwriter.template",
                    ),
                ),
                ("extra_vertical_margin", models.FloatField(default=10)),
                ("side_margin", models.FloatField(default=2.5)),
            ],
        ),
        migrations.CreateModel(
            name="Block",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=512)),
                ("html", models.TextField(default="")),
                ("key", models.CharField(blank=True, max_length=512, null=True)),
            ],
        ),
        migrations.CreateModel(
            name="BlockParameter",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("order", models.PositiveIntegerField()),
                ("title", models.CharField(max_length=255)),
                ("many", models.BooleanField(default=False)),
                (
                    "block",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, related_name="parameters", to="wbwriter.block"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="InEditorTemplate",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("uuid", models.CharField(max_length=255, unique=True)),
                (
                    "title",
                    models.CharField(
                        help_text="The title should be unique but doesn't need to be.",
                        max_length=255,
                        verbose_name="Title",
                    ),
                ),
                (
                    "description",
                    models.TextField(
                        default="",
                        help_text="A brief text that describes the use case for this template.",
                        verbose_name="Description",
                    ),
                ),
                (
                    "style",
                    models.TextField(
                        blank=True,
                        default="",
                        help_text="The CSS that styles the templates HTML.",
                        null=True,
                        verbose_name="Template CSS",
                    ),
                ),
                (
                    "template",
                    models.TextField(
                        default="", help_text="The HTML code of the template.", verbose_name="Template HTML"
                    ),
                ),
                ("is_stand_alone_template", models.BooleanField(default=True)),
                (
                    "modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="The last time this template has been edited.",
                        verbose_name="Last modification date and time",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PublicationParser",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=1024, unique=True)),
                ("slug", models.CharField(blank=True, max_length=1024)),
                ("parser_path", models.CharField(max_length=1024, unique=True)),
            ],
            options={
                "verbose_name": "PublicationParser",
                "verbose_name_plural": "PublicationParsers",
            },
        ),
        migrations.CreateModel(
            name="ArticleType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("label", models.CharField(max_length=255, unique=True)),
                ("slug", models.SlugField(blank=True, max_length=255, null=True, unique=True)),
                (
                    "parsers",
                    models.ManyToManyField(
                        blank=True, related_name="publication_parsers", to="wbwriter.publicationparser"
                    ),
                ),
            ],
            options={
                "verbose_name": "Article Type",
                "verbose_name_plural": "Article Types",
            },
        ),
        migrations.CreateModel(
            name="Article",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="The title of the article that is going to be used when imported into other articles. Defaults to the name of the article when not set.",
                        max_length=1024,
                        null=True,
                    ),
                ),
                ("slug", models.CharField(blank=True, max_length=1024, null=True)),
                ("content", models.TextField(default="")),
                (
                    "status",
                    django_fsm.FSMField(
                        choices=[
                            ("draft", "Draft"),
                            ("feedback", "Feedback"),
                            ("peer_review", "Peer Review"),
                            ("qa_review", "QA Review"),
                            ("approved", "Approved"),
                        ],
                        default="draft",
                        max_length=50,
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="articles",
                        to="wbwriter.template",
                    ),
                ),
                (
                    "name",
                    models.CharField(
                        help_text="A unique name to reference this article.", max_length=1024, unique=True
                    ),
                ),
                ("tag_detail_endpoint", models.CharField(blank=True, max_length=255, null=True)),
                ("tag_representation", models.CharField(blank=True, max_length=255, null=True)),
                (
                    "access_level",
                    models.TextField(
                        choices=[("All", "All"), ("Employee", "Employee")], default="Employee", max_length=16
                    ),
                ),
                ("article_structure", models.JSONField(blank=True, null=True)),
                (
                    "created",
                    models.DateField(
                        auto_now_add=True,
                        default=django.utils.timezone.now,
                        help_text="The date on which this article has been created.",
                        verbose_name="Creation Date",
                    ),
                ),
                (
                    "modified",
                    models.DateTimeField(
                        auto_now=True,
                        help_text="The last time this article has been edited.",
                        verbose_name="Last modification date and time",
                    ),
                ),
                (
                    "published",
                    models.DateTimeField(
                        blank=True,
                        help_text="The date and time on which this article has been/will be published.",
                        null=True,
                        verbose_name="Publication Date and Time",
                    ),
                ),
                (
                    "type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="article",
                        to="wbwriter.articletype",
                    ),
                ),
                (
                    "raw_content",
                    models.JSONField(
                        default=dict,
                        help_text="Maps content IDs to content and configurations to sections.",
                        verbose_name="Raw Content",
                    ),
                ),
                (
                    "in_editor_templates",
                    models.ManyToManyField(
                        blank=True, related_name="templated_articles", to="wbwriter.ineditortemplate"
                    ),
                ),
                ("peer_reviewer_approved", models.BooleanField(default=False)),
                ("qa_reviewer_approved", models.BooleanField(default=False)),
                ("teaser_image", models.ImageField(blank=True, null=True, upload_to="wbwriter/teaser_images")),
            ],
            options={
                "permissions": [("administrate_article", "Can administrate Articles.")],
                "verbose_name": "Article",
                "verbose_name_plural": "Articles",
            },
        ),
        migrations.CreateModel(
            name="Publication",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("title", models.CharField(max_length=1024)),
                ("slug", models.CharField(blank=True, max_length=1024)),
                (
                    "created",
                    models.DateField(
                        auto_now_add=True,
                        help_text="The date on which this has been created.",
                        verbose_name="Creation Date",
                    ),
                ),
                ("content", models.TextField(default="")),
                ("content_file", models.FileField(blank=True, null=True, upload_to="")),
                (
                    "parser",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="parsed_publication",
                        to="wbwriter.publicationparser",
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to="contenttypes.contenttype"),
                ),
                ("object_id", models.PositiveIntegerField()),
                ("tag_detail_endpoint", models.CharField(blank=True, max_length=255, null=True)),
                ("tag_representation", models.CharField(blank=True, max_length=255, null=True)),
                ("teaser_image", models.ImageField(blank=True, null=True, upload_to="wbwriter/publication/assets")),
            ],
            options={
                "verbose_name": "Publication",
                "verbose_name_plural": "Publications",
            },
        ),
        migrations.CreateModel(
            name="MetaInformation",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(max_length=255)),
                (
                    "meta_information_type",
                    models.CharField(choices=[("BOOLEAN", "Boolean")], default="BOOLEAN", max_length=24),
                ),
                ("boolean_default", models.BooleanField(blank=True, null=True)),
                ("article_type", models.ManyToManyField(related_name="meta_information", to="wbwriter.articletype")),
            ],
            options={
                "verbose_name": "Meta Information",
                "verbose_name_plural": "MetaInformation",
            },
        ),
        migrations.CreateModel(
            name="MetaInformationInstance",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("boolean_value", models.BooleanField(blank=True, null=True)),
                (
                    "article",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="meta_information",
                        to="wbwriter.article",
                    ),
                ),
                (
                    "meta_information",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="instances",
                        to="wbwriter.metainformation",
                    ),
                ),
            ],
            options={
                "verbose_name": "Meta Information Instance",
                "verbose_name_plural": "Meta Information Instances",
            },
        ),
        migrations.AddConstraint(
            model_name="metainformationinstance",
            constraint=models.UniqueConstraint(
                fields=("meta_information", "article"), name="unique_meta_information_article"
            ),
        ),
        migrations.AlterModelOptions(
            name="metainformation",
            options={"verbose_name": "Meta Information", "verbose_name_plural": "Meta Information"},
        ),
        migrations.AddField(
            model_name="metainformation",
            name="key",
            field=models.CharField(default=None, max_length=255, unique=True),
            preserve_default=False,
        ),
        migrations.AlterField(
            model_name="metainformation",
            name="name",
            field=models.CharField(max_length=255, unique=True),
        ),
        migrations.AddField(
            model_name="publication",
            name="additional_information",
            field=models.JSONField(blank=True, default=dict, null=True),
        ),
        migrations.AlterModelOptions(
            name="article",
            options={
                "permissions": [
                    ("administrate_article", "Can administrate Articles."),
                    ("publish_article", "Can publish Articles."),
                    ("peer_review_article", "Can peer review Articles."),
                    ("qa_review_article", "Can QA review Articles."),
                ],
                "verbose_name": "Article",
                "verbose_name_plural": "Articles",
            },
        ),
        migrations.AlterField(
            model_name="article",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("draft", "Draft"),
                    ("feedback", "Feedback"),
                    ("peer_review", "Peer Review"),
                    ("qa_review", "QA Review"),
                    ("approved", "Approved"),
                    ("published", "Published"),
                ],
                default="draft",
                max_length=50,
            ),
        ),
        migrations.AlterField(
            model_name="article",
            name="status",
            field=django_fsm.FSMField(
                choices=[
                    ("draft", "Draft"),
                    ("feedback", "Feedback"),
                    ("peer_review", "Peer Review"),
                    ("qa_review", "QA Review"),
                    ("author_approval", "Author approval"),
                    ("approved", "Approved"),
                    ("published", "Published"),
                ],
                default="draft",
                max_length=50,
            ),
        ),
        migrations.RemoveField(
            model_name="article",
            name="template",
        ),
        migrations.AddField(
            model_name="publication",
            name="target",
            field=models.CharField(default="website", max_length=256),
            preserve_default=False,
        ),
        migrations.RemoveField(
            model_name="article",
            name="qa_reviewer_approved",
        ),
        migrations.AlterField(
            model_name="article",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT, related_name="article", to="wbwriter.articletype"
            ),
        ),
        migrations.AddField(
            model_name="article",
            name="template",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="articles",
                to="wbwriter.template",
            ),
        ),
        migrations.RemoveField(
            model_name="article",
            name="access_level",
        ),
        migrations.AddField(
            model_name="article",
            name="is_private",
            field=models.BooleanField(
                default=False, help_text="Signifies whether this article can be seen by all customers on the homepage."
            ),
        ),
        migrations.RemoveField(
            model_name="article",
            name="in_editor_templates",
        ),
        migrations.RemoveField(
            model_name="article",
            name="content",
        ),
        migrations.RenameField(
            model_name="article",
            old_name="raw_content",
            new_name="content",
        ),
        migrations.AlterField(
            model_name="article",
            name="content",
            field=models.JSONField(default=dict, verbose_name="Content"),
        ),
        migrations.AddField(
            model_name="publication",
            name="modified",
            field=models.DateTimeField(
                auto_now=True,
                help_text="The date and time on which this has been modified last.",
                verbose_name="Last Modification Datetime",
            ),
        ),
        migrations.RemoveField(
            model_name="article",
            name="published",
        ),
        migrations.AddField(
            model_name="publication",
            name="description",
            field=models.TextField(blank=True, default=""),
        ),
        migrations.AlterField(
            model_name="article",
            name="teaser_image",
            field=models.ImageField(blank=True, null=True, upload_to="writer/article/teasers"),
        ),
        migrations.AlterField(
            model_name="publication",
            name="content_file",
            field=models.FileField(
                blank=True, max_length=256, null=True, upload_to="writer/publication/content_files"
            ),
        ),
        migrations.AlterField(
            model_name="publication",
            name="teaser_image",
            field=models.ImageField(blank=True, null=True, upload_to="writer/publication/teasers"),
        ),
        migrations.AddField(
            model_name="publication",
            name="thumbnail_image",
            field=models.ImageField(blank=True, null=True, upload_to="writer/publication/thumbnails"),
        ),
        migrations.AlterField(
            model_name="article",
            name="tag_representation",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AlterField(
            model_name="publication",
            name="tag_representation",
            field=models.CharField(blank=True, max_length=512, null=True),
        ),
        migrations.AlterModelOptions(
            name="article",
            options={
                "permissions": [
                    ("administrate_article", "Can administrate Articles."),
                    ("assign_article_reviewers", "Can assign Articles' peer and QA reviewers."),
                    ("publish_article", "Can publish Articles."),
                    ("peer_review_article", "Can peer review Articles."),
                    ("qa_review_article", "Can QA review Articles."),
                ],
                "verbose_name": "Article",
                "verbose_name_plural": "Articles",
            },
        ),
        migrations.AddField(
            model_name="article",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="%(app_label)s_%(class)s_items", to="tags.tag"),
        ),
        migrations.AddField(
            model_name="publication",
            name="tags",
            field=models.ManyToManyField(blank=True, related_name="%(app_label)s_%(class)s_items", to="tags.tag"),
        ),
        migrations.AddField(
            model_name="article",
            name="author",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="author_articles",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="article",
            name="feedback_contact",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="feedback_contact_articles",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="article",
            name="peer_reviewer",
            field=models.ForeignKey(
                blank=True,
                help_text="The peer reviewer who reviewed this article.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="peer_review_articles",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="article",
            name="qa_reviewer",
            field=models.ForeignKey(
                blank=True,
                help_text="The quality assurance (QA) reviewer who reviewed this article.",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="qa_review_articles",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="article",
            name="reviewer",
            field=models.ForeignKey(
                blank=True,
                help_text="The contact that is currently working on feedback.",
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="review_articles",
                to="directory.person",
            ),
        ),
        migrations.AddField(
            model_name="articletype",
            name="peer_reviewers",
            field=models.ManyToManyField(related_name="article_type_peer_reviewers", to="directory.person"),
        ),
        migrations.AddField(
            model_name="articletype",
            name="qa_reviewers",
            field=models.ManyToManyField(related_name="article_type_qa_reviewers", to="directory.person"),
        ),
        migrations.AddField(
            model_name="publication",
            name="author",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="publication",
                to="directory.person",
            ),
        ),
        migrations.AlterField(
            model_name="article",
            name="created",
            field=models.DateField(
                auto_now_add=True,
                help_text="The date on which this article has been created.",
                verbose_name="Creation Date",
            ),
        ),
    ]
