# Security Policy

## Supported Versions

qBraid is committed to the security of our software and actively supports security updates for the following qBraid-SDK versions:

| Version | Supported          |
| ------- | ------------------ |
| 0.7.x   | :white_check_mark: |
| < 0.7   | :x:                |

## Reporting a Vulnerability

The qBraid team takes the security of our software products and services seriously, which includes all source code repositories managed through our GitHub organization. We encourage the responsible disclosure of any security vulnerabilities.

### How to Report a Vulnerability

To report a security vulnerability, please use the GitHub security advisories feature for the qBraid-SDK:

[Report a security vulnerability](https://github.com/qBraid/qBraid/security/advisories)

Please **do not** report security vulnerabilities through public GitHub issues.

If your report is specifically related to `qbraid-core`, please specify this in your report and use the same [security vulnerability reporting link](https://github.com/qBraid/qBraid/security/advisories) provided above.

### What to Expect

After submitting a vulnerability, you can expect the following:

- Acknowledgment of your report within 24 hours.
- Communication from our security team about the next steps and any additional information we might require to verify or investigate the issue.
- Updates on the progress of addressing the reported issue.
- Notification when the issue is resolved, along with details of the fix and the release in which the fix will appear.

### Information to Include

Please provide as much of the following information as possible to help us better understand the nature and scope of the vulnerability:

- Type of issue (e.g., buffer overflow, SQL injection, cross-site scripting).
- Full paths of source file(s) related to the issue, if applicable.
- The location of the affected source code (tag/branch/commit or direct URL).
- Any special configuration required to reproduce the issue.
- Step-by-step instructions to reproduce the issue.
- Proof-of-concept or exploit code, if possible.
- Impact of the issue, including how an attacker might exploit it.

This information will help us triage your report more quickly and accurately.
