# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'IntegrationCustomNamespaceSyncRule',
    'IntegrationMetricStatsToSync',
    'IntegrationNamespaceSyncRule',
]

@pulumi.output_type
class IntegrationCustomNamespaceSyncRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "filterAction":
            suggest = "filter_action"
        elif key == "filterSource":
            suggest = "filter_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationCustomNamespaceSyncRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationCustomNamespaceSyncRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationCustomNamespaceSyncRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 default_action: Optional[_builtins.str] = None,
                 filter_action: Optional[_builtins.str] = None,
                 filter_source: Optional[_builtins.str] = None):
        """
        :param _builtins.str namespace: An AWS custom namespace having custom AWS metrics that you want to sync with Splunk Observability Cloud. See the AWS documentation on publishing metrics for more information.
        :param _builtins.str default_action: Controls the Splunk Observability Cloud default behavior for processing data from an AWS namespace. Splunk Observability Cloud ignores this property unless you specify the `filter_action` and `filter_source` properties. If you do specify them, use this property to control how Splunk Observability Cloud treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
        :param _builtins.str filter_action: Controls how Splunk Observability Cloud processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
        :param _builtins.str filter_source: Expression that selects the data that Splunk Observability Cloud should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
        """
        pulumi.set(__self__, "namespace", namespace)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if filter_action is not None:
            pulumi.set(__self__, "filter_action", filter_action)
        if filter_source is not None:
            pulumi.set(__self__, "filter_source", filter_source)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        An AWS custom namespace having custom AWS metrics that you want to sync with Splunk Observability Cloud. See the AWS documentation on publishing metrics for more information.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[_builtins.str]:
        """
        Controls the Splunk Observability Cloud default behavior for processing data from an AWS namespace. Splunk Observability Cloud ignores this property unless you specify the `filter_action` and `filter_source` properties. If you do specify them, use this property to control how Splunk Observability Cloud treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> Optional[_builtins.str]:
        """
        Controls how Splunk Observability Cloud processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
        """
        return pulumi.get(self, "filter_action")

    @_builtins.property
    @pulumi.getter(name="filterSource")
    def filter_source(self) -> Optional[_builtins.str]:
        """
        Expression that selects the data that Splunk Observability Cloud should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
        """
        return pulumi.get(self, "filter_source")


@pulumi.output_type
class IntegrationMetricStatsToSync(dict):
    def __init__(__self__, *,
                 metric: _builtins.str,
                 namespace: _builtins.str,
                 stats: Sequence[_builtins.str]):
        """
        :param _builtins.str metric: AWS metric that you want to pick statistics for
        :param _builtins.str namespace: An AWS namespace having AWS metric that you want to pick statistics for
        :param Sequence[_builtins.str] stats: AWS statistics you want to collect
        """
        pulumi.set(__self__, "metric", metric)
        pulumi.set(__self__, "namespace", namespace)
        pulumi.set(__self__, "stats", stats)

    @_builtins.property
    @pulumi.getter
    def metric(self) -> _builtins.str:
        """
        AWS metric that you want to pick statistics for
        """
        return pulumi.get(self, "metric")

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        An AWS namespace having AWS metric that you want to pick statistics for
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter
    def stats(self) -> Sequence[_builtins.str]:
        """
        AWS statistics you want to collect
        """
        return pulumi.get(self, "stats")


@pulumi.output_type
class IntegrationNamespaceSyncRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "defaultAction":
            suggest = "default_action"
        elif key == "filterAction":
            suggest = "filter_action"
        elif key == "filterSource":
            suggest = "filter_source"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IntegrationNamespaceSyncRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IntegrationNamespaceSyncRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IntegrationNamespaceSyncRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespace: _builtins.str,
                 default_action: Optional[_builtins.str] = None,
                 filter_action: Optional[_builtins.str] = None,
                 filter_source: Optional[_builtins.str] = None):
        """
        :param _builtins.str namespace: An AWS custom namespace having custom AWS metrics that you want to sync with Splunk Observability Cloud. See `services` field description below for additional information.
        :param _builtins.str default_action: Controls the Splunk Observability Cloud default behavior for processing data from an AWS namespace. Splunk Observability Cloud ignores this property unless you specify the `filter_action` and `filter_source` properties. If you do specify them, use this property to control how Splunk Observability Cloud treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
        :param _builtins.str filter_action: Controls how Splunk Observability Cloud processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
        :param _builtins.str filter_source: Expression that selects the data that Splunk Observability Cloud should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
        """
        pulumi.set(__self__, "namespace", namespace)
        if default_action is not None:
            pulumi.set(__self__, "default_action", default_action)
        if filter_action is not None:
            pulumi.set(__self__, "filter_action", filter_action)
        if filter_source is not None:
            pulumi.set(__self__, "filter_source", filter_source)

    @_builtins.property
    @pulumi.getter
    def namespace(self) -> _builtins.str:
        """
        An AWS custom namespace having custom AWS metrics that you want to sync with Splunk Observability Cloud. See `services` field description below for additional information.
        """
        return pulumi.get(self, "namespace")

    @_builtins.property
    @pulumi.getter(name="defaultAction")
    def default_action(self) -> Optional[_builtins.str]:
        """
        Controls the Splunk Observability Cloud default behavior for processing data from an AWS namespace. Splunk Observability Cloud ignores this property unless you specify the `filter_action` and `filter_source` properties. If you do specify them, use this property to control how Splunk Observability Cloud treats data that doesn't match the filter. The available actions are one of `"Include"` or `"Exclude"`.
        """
        return pulumi.get(self, "default_action")

    @_builtins.property
    @pulumi.getter(name="filterAction")
    def filter_action(self) -> Optional[_builtins.str]:
        """
        Controls how Splunk Observability Cloud processes data from a custom AWS namespace. The available actions are one of `"Include"` or `"Exclude"`.
        """
        return pulumi.get(self, "filter_action")

    @_builtins.property
    @pulumi.getter(name="filterSource")
    def filter_source(self) -> Optional[_builtins.str]:
        """
        Expression that selects the data that Splunk Observability Cloud should sync for the custom namespace associated with this sync rule. The expression uses the syntax defined for the SignalFlow `filter()` function; it can be any valid SignalFlow filter expression.
        """
        return pulumi.get(self, "filter_source")


