"""Module for managing Qt resource data."""

from qtpy import QtCore

qt_resource_data = b"\
\x00\x00\x06\xd0\
\x3c\
\x73\x76\x67\x20\x68\x65\x69\x67\x68\x74\x3d\x22\x38\x30\x30\x22\
\x20\x76\x69\x65\x77\x42\x6f\x78\x3d\x22\x30\x20\x30\x20\x31\x36\
\x20\x31\x36\x22\x20\x77\x69\x64\x74\x68\x3d\x22\x38\x30\x30\x22\
\x20\x78\x6d\x6c\x6e\x73\x3d\x22\x68\x74\x74\x70\x3a\x2f\x2f\x77\
\x77\x77\x2e\x77\x33\x2e\x6f\x72\x67\x2f\x32\x30\x30\x30\x2f\x73\
\x76\x67\x22\x3e\x3c\x70\x61\x74\x68\x20\x64\x3d\x22\x6d\x31\x36\
\x20\x37\x2e\x33\x33\x38\x39\x38\x31\x38\x61\x37\x2e\x38\x32\x20\
\x38\x2e\x33\x33\x37\x33\x36\x35\x31\x20\x30\x20\x30\x20\x30\x20\
\x2d\x38\x2d\x37\x2e\x33\x33\x35\x31\x37\x35\x34\x39\x20\x37\x2e\
\x38\x32\x20\x38\x2e\x33\x33\x37\x33\x36\x35\x31\x20\x30\x20\x30\
\x20\x30\x20\x2d\x38\x20\x37\x2e\x33\x33\x35\x31\x37\x35\x34\x39\
\x76\x31\x2e\x33\x32\x32\x30\x33\x37\x34\x61\x37\x2e\x38\x32\x20\
\x38\x2e\x33\x33\x37\x33\x36\x35\x31\x20\x30\x20\x30\x20\x30\x20\
\x38\x20\x37\x2e\x33\x33\x35\x31\x37\x34\x38\x20\x37\x2e\x38\x32\
\x20\x38\x2e\x33\x33\x37\x33\x36\x35\x31\x20\x30\x20\x30\x20\x30\
\x20\x38\x2d\x37\x2e\x33\x33\x35\x31\x37\x34\x38\x7a\x6d\x2d\x31\
\x2e\x32\x35\x20\x30\x68\x2d\x33\x61\x31\x31\x2e\x33\x34\x20\x31\
\x32\x2e\x30\x39\x30\x32\x34\x36\x20\x30\x20\x30\x20\x30\x20\x2d\
\x2e\x34\x33\x2d\x32\x2e\x37\x30\x38\x30\x34\x34\x34\x20\x37\x2e\
\x36\x20\x38\x2e\x31\x30\x32\x38\x31\x30\x31\x20\x30\x20\x30\x20\
\x30\x20\x31\x2e\x37\x35\x2d\x31\x2e\x30\x36\x36\x31\x35\x39\x33\
\x20\x36\x20\x36\x2e\x33\x39\x36\x39\x35\x35\x33\x20\x30\x20\x30\
\x20\x31\x20\x31\x2e\x36\x35\x20\x33\x2e\x37\x37\x34\x32\x30\x33\
\x37\x7a\x6d\x2d\x39\x2e\x31\x38\x20\x30\x61\x39\x2e\x36\x39\x20\
\x31\x30\x2e\x33\x33\x31\x30\x38\x33\x20\x30\x20\x30\x20\x31\x20\
\x2e\x33\x37\x2d\x32\x2e\x32\x38\x31\x35\x38\x30\x38\x20\x38\x2e\
\x34\x33\x20\x38\x2e\x39\x38\x37\x37\x32\x32\x32\x20\x30\x20\x30\
\x20\x30\x20\x32\x2e\x30\x36\x2e\x32\x37\x37\x32\x30\x31\x34\x20\
\x38\x2e\x34\x39\x20\x39\x2e\x30\x35\x31\x36\x39\x31\x38\x20\x30\
\x20\x30\x20\x30\x20\x32\x2e\x30\x39\x2d\x2e\x32\x37\x37\x32\x30\
\x31\x34\x20\x31\x30\x2e\x32\x20\x31\x30\x2e\x38\x37\x34\x38\x32\
\x34\x20\x30\x20\x30\x20\x31\x20\x2e\x33\x37\x20\x32\x2e\x32\x38\
\x31\x35\x38\x30\x38\x7a\x6d\x34\x2e\x39\x32\x20\x31\x2e\x33\x32\
\x32\x30\x33\x37\x34\x61\x39\x2e\x35\x39\x20\x31\x30\x2e\x32\x32\
\x34\x34\x36\x37\x20\x30\x20\x30\x20\x31\x20\x2d\x2e\x33\x37\x20\
\x32\x2e\x32\x38\x31\x35\x38\x30\x38\x20\x38\x2e\x35\x33\x20\x39\
\x2e\x30\x39\x34\x33\x33\x38\x32\x20\x30\x20\x30\x20\x30\x20\x2d\
\x34\x2e\x31\x38\x20\x30\x20\x39\x2e\x36\x39\x20\x31\x30\x2e\x33\
\x33\x31\x30\x38\x33\x20\x30\x20\x30\x20\x31\x20\x2d\x2e\x33\x37\
\x2d\x32\x2e\x32\x38\x31\x35\x38\x30\x38\x7a\x6d\x2e\x34\x2d\x35\
\x2e\x33\x33\x30\x37\x39\x36\x31\x61\x31\x31\x2e\x38\x32\x20\x31\
\x32\x2e\x36\x30\x32\x30\x30\x32\x20\x30\x20\x30\x20\x30\x20\x2d\
\x2e\x38\x39\x2d\x31\x2e\x37\x32\x37\x31\x37\x38\x20\x36\x2e\x38\
\x39\x20\x37\x2e\x33\x34\x35\x38\x33\x37\x20\x30\x20\x30\x20\x31\
\x20\x32\x20\x31\x2e\x30\x36\x36\x31\x35\x39\x33\x20\x36\x2e\x35\
\x37\x20\x37\x2e\x30\x30\x34\x36\x36\x36\x31\x20\x30\x20\x30\x20\
\x31\x20\x2d\x31\x2e\x31\x34\x2e\x37\x30\x33\x36\x36\x35\x7a\x6d\
\x2d\x32\x2e\x36\x2d\x31\x2e\x39\x38\x33\x30\x35\x36\x32\x61\x31\
\x30\x20\x31\x30\x2e\x36\x36\x31\x35\x39\x32\x20\x30\x20\x30\x20\
\x31\x20\x31\x2e\x33\x38\x20\x32\x2e\x34\x35\x32\x31\x36\x36\x33\
\x20\x37\x2e\x36\x33\x20\x38\x2e\x31\x33\x34\x37\x39\x34\x38\x20\
\x30\x20\x30\x20\x31\x20\x2d\x31\x2e\x36\x37\x2e\x32\x30\x32\x35\
\x37\x30\x32\x20\x37\x2e\x35\x36\x20\x38\x2e\x30\x36\x30\x31\x36\
\x33\x37\x20\x30\x20\x30\x20\x31\x20\x2d\x31\x2e\x36\x37\x2d\x2e\
\x32\x30\x32\x35\x37\x30\x32\x20\x39\x2e\x38\x32\x20\x31\x30\x2e\
\x34\x36\x39\x36\x38\x34\x20\x30\x20\x30\x20\x31\x20\x31\x2e\x33\
\x38\x2d\x32\x2e\x34\x35\x32\x31\x36\x36\x33\x7a\x6d\x2d\x33\x2e\
\x31\x35\x20\x32\x2e\x30\x32\x35\x37\x30\x32\x35\x61\x36\x2e\x35\
\x37\x20\x37\x2e\x30\x30\x34\x36\x36\x36\x31\x20\x30\x20\x30\x20\
\x31\x20\x2d\x31\x2e\x31\x34\x2d\x2e\x37\x30\x33\x36\x36\x35\x20\
\x36\x2e\x38\x39\x20\x37\x2e\x33\x34\x35\x38\x33\x37\x20\x30\x20\
\x30\x20\x31\x20\x32\x2d\x31\x2e\x30\x36\x36\x31\x35\x39\x33\x20\
\x31\x30\x2e\x33\x38\x20\x31\x31\x2e\x30\x36\x36\x37\x33\x32\x20\
\x30\x20\x30\x20\x30\x20\x2d\x2e\x38\x36\x20\x31\x2e\x37\x36\x39\
\x38\x32\x34\x33\x7a\x6d\x2d\x32\x2e\x31\x34\x2e\x31\x38\x31\x32\
\x34\x37\x31\x61\x37\x2e\x36\x20\x38\x2e\x31\x30\x32\x38\x31\x30\
\x31\x20\x30\x20\x30\x20\x30\x20\x31\x2e\x37\x35\x20\x31\x2e\x30\
\x36\x36\x31\x35\x39\x33\x20\x31\x31\x20\x31\x31\x2e\x37\x32\x37\
\x37\x35\x32\x20\x30\x20\x30\x20\x30\x20\x2d\x2e\x34\x33\x20\x32\
\x2e\x37\x30\x38\x30\x34\x34\x34\x68\x2d\x33\x61\x36\x20\x36\x2e\
\x33\x39\x36\x39\x35\x35\x33\x20\x30\x20\x30\x20\x31\x20\x31\x2e\
\x36\x38\x2d\x33\x2e\x37\x37\x34\x32\x30\x33\x37\x7a\x6d\x2d\x31\
\x2e\x37\x32\x20\x35\x2e\x31\x30\x36\x39\x30\x32\x37\x68\x33\x61\
\x31\x31\x20\x31\x31\x2e\x37\x32\x37\x37\x35\x32\x20\x30\x20\x30\
\x20\x30\x20\x2e\x34\x33\x20\x32\x2e\x37\x30\x38\x30\x34\x34\x38\
\x20\x37\x2e\x36\x20\x38\x2e\x31\x30\x32\x38\x31\x30\x31\x20\x30\
\x20\x30\x20\x30\x20\x2d\x31\x2e\x37\x35\x20\x31\x2e\x30\x36\x36\
\x31\x35\x38\x20\x36\x20\x36\x2e\x33\x39\x36\x39\x35\x35\x33\x20\
\x30\x20\x30\x20\x31\x20\x2d\x31\x2e\x36\x38\x2d\x33\x2e\x37\x37\
\x34\x32\x30\x32\x38\x7a\x6d\x33\x2e\x38\x36\x20\x33\x2e\x39\x36\
\x36\x31\x31\x32\x38\x61\x31\x30\x2e\x33\x38\x20\x31\x31\x2e\x30\
\x36\x36\x37\x33\x32\x20\x30\x20\x30\x20\x30\x20\x2e\x38\x36\x20\
\x31\x2e\x37\x36\x39\x38\x32\x34\x20\x36\x2e\x38\x39\x20\x37\x2e\
\x33\x34\x35\x38\x33\x37\x20\x30\x20\x30\x20\x31\x20\x2d\x32\x2d\
\x31\x2e\x30\x36\x36\x31\x36\x20\x36\x2e\x35\x37\x20\x37\x2e\x30\
\x30\x34\x36\x36\x36\x31\x20\x30\x20\x30\x20\x31\x20\x31\x2e\x31\
\x34\x2d\x2e\x37\x30\x33\x36\x36\x34\x7a\x6d\x32\x2e\x35\x37\x20\
\x32\x2e\x30\x32\x35\x37\x30\x32\x61\x39\x2e\x38\x32\x20\x31\x30\
\x2e\x34\x36\x39\x36\x38\x34\x20\x30\x20\x30\x20\x31\x20\x2d\x31\
\x2e\x33\x38\x2d\x32\x2e\x34\x35\x32\x31\x36\x36\x20\x37\x2e\x34\
\x33\x20\x37\x2e\x39\x32\x31\x35\x36\x33\x20\x30\x20\x30\x20\x31\
\x20\x33\x2e\x33\x34\x20\x30\x20\x39\x2e\x37\x36\x20\x31\x30\x2e\
\x34\x30\x35\x37\x31\x34\x20\x30\x20\x30\x20\x31\x20\x2d\x31\x2e\
\x33\x38\x20\x32\x2e\x34\x35\x32\x31\x36\x36\x7a\x6d\x33\x2e\x31\
\x35\x2d\x32\x2e\x30\x32\x35\x37\x30\x32\x61\x36\x2e\x35\x37\x20\
\x37\x2e\x30\x30\x34\x36\x36\x36\x31\x20\x30\x20\x30\x20\x31\x20\
\x31\x2e\x31\x39\x2e\x37\x30\x33\x36\x36\x34\x20\x37\x2e\x32\x34\
\x20\x37\x2e\x37\x31\x38\x39\x39\x32\x38\x20\x30\x20\x30\x20\x31\
\x20\x2d\x32\x20\x31\x2e\x30\x36\x36\x31\x36\x20\x31\x31\x2e\x34\
\x38\x20\x31\x32\x2e\x32\x33\x39\x35\x30\x38\x20\x30\x20\x30\x20\
\x30\x20\x2e\x38\x31\x2d\x31\x2e\x37\x36\x39\x38\x32\x34\x7a\x6d\
\x32\x2e\x31\x34\x2d\x2e\x31\x38\x31\x32\x34\x38\x61\x37\x2e\x36\
\x20\x38\x2e\x31\x30\x32\x38\x31\x30\x31\x20\x30\x20\x30\x20\x30\
\x20\x2d\x31\x2e\x37\x35\x2d\x31\x2e\x30\x36\x36\x31\x35\x38\x20\
\x31\x30\x2e\x38\x20\x31\x31\x2e\x35\x31\x34\x35\x32\x20\x30\x20\
\x30\x20\x30\x20\x2e\x34\x33\x2d\x32\x2e\x37\x30\x38\x30\x34\x35\
\x32\x68\x33\x61\x36\x20\x36\x2e\x33\x39\x36\x39\x35\x35\x33\x20\
\x30\x20\x30\x20\x31\x20\x2d\x31\x2e\x36\x38\x20\x33\x2e\x37\x37\
\x34\x32\x30\x33\x32\x7a\x22\x2f\x3e\x3c\x2f\x73\x76\x67\x3e\
\x00\x00\x01\x14\
\x3c\
\x73\x76\x67\x20\x68\x65\x69\x67\x68\x74\x3d\x22\x38\x30\x30\x22\
\x20\x76\x69\x65\x77\x42\x6f\x78\x3d\x22\x30\x20\x30\x20\x35\x31\
\x32\x20\x35\x31\x32\x22\x20\x77\x69\x64\x74\x68\x3d\x22\x38\x30\
\x30\x22\x20\x78\x6d\x6c\x6e\x73\x3d\x22\x68\x74\x74\x70\x3a\x2f\
\x2f\x77\x77\x77\x2e\x77\x33\x2e\x6f\x72\x67\x2f\x32\x30\x30\x30\
\x2f\x73\x76\x67\x22\x3e\x3c\x70\x61\x74\x68\x20\x64\x3d\x22\x6d\
\x33\x31\x30\x2e\x33\x39\x31\x20\x35\x30\x34\x2e\x36\x32\x35\x68\
\x32\x30\x31\x2e\x36\x30\x39\x76\x2d\x33\x31\x34\x2e\x33\x31\x32\
\x6c\x2d\x32\x35\x35\x2e\x39\x36\x39\x2d\x31\x38\x32\x2e\x39\x33\
\x38\x2d\x32\x35\x36\x2e\x30\x33\x31\x20\x31\x38\x32\x2e\x39\x33\
\x38\x76\x33\x31\x34\x2e\x33\x31\x32\x68\x32\x30\x31\x2e\x36\x30\
\x39\x76\x2d\x31\x36\x37\x2e\x39\x35\x33\x68\x31\x30\x38\x2e\x37\
\x38\x32\x7a\x22\x20\x73\x74\x72\x6f\x6b\x65\x2d\x77\x69\x64\x74\
\x68\x3d\x22\x2e\x39\x38\x35\x34\x39\x31\x22\x20\x74\x72\x61\x6e\
\x73\x66\x6f\x72\x6d\x3d\x22\x6d\x61\x74\x72\x69\x78\x28\x31\x20\
\x30\x20\x30\x20\x31\x2e\x30\x32\x39\x36\x36\x33\x32\x20\x30\x20\
\x2d\x37\x2e\x35\x39\x33\x37\x36\x36\x29\x22\x2f\x3e\x3c\x2f\x73\
\x76\x67\x3e\
\x00\x00\x01\x29\
\x3c\
\x73\x76\x67\x20\x66\x69\x6c\x6c\x3d\x22\x6e\x6f\x6e\x65\x22\x20\
\x68\x65\x69\x67\x68\x74\x3d\x22\x38\x30\x30\x22\x20\x76\x69\x65\
\x77\x42\x6f\x78\x3d\x22\x30\x20\x30\x20\x32\x34\x20\x32\x34\x22\
\x20\x77\x69\x64\x74\x68\x3d\x22\x38\x30\x30\x22\x20\x78\x6d\x6c\
\x6e\x73\x3d\x22\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x77\
\x33\x2e\x6f\x72\x67\x2f\x32\x30\x30\x30\x2f\x73\x76\x67\x22\x3e\
\x3c\x70\x61\x74\x68\x20\x64\x3d\x22\x6d\x31\x2e\x30\x30\x30\x30\
\x30\x35\x35\x20\x31\x32\x68\x32\x31\x2e\x39\x39\x39\x39\x38\x39\
\x35\x6d\x2d\x32\x31\x2e\x39\x39\x39\x39\x38\x39\x35\x20\x30\x20\
\x39\x2e\x34\x32\x38\x35\x36\x36\x35\x2d\x39\x2e\x34\x39\x39\x39\
\x39\x35\x34\x6d\x2d\x39\x2e\x34\x32\x38\x35\x36\x36\x35\x20\x39\
\x2e\x34\x39\x39\x39\x39\x35\x34\x20\x39\x2e\x34\x32\x38\x35\x36\
\x36\x35\x20\x39\x2e\x34\x39\x39\x39\x39\x35\x22\x20\x73\x74\x72\
\x6f\x6b\x65\x3d\x22\x23\x30\x30\x30\x22\x20\x73\x74\x72\x6f\x6b\
\x65\x2d\x6c\x69\x6e\x65\x63\x61\x70\x3d\x22\x72\x6f\x75\x6e\x64\
\x22\x20\x73\x74\x72\x6f\x6b\x65\x2d\x6c\x69\x6e\x65\x6a\x6f\x69\
\x6e\x3d\x22\x72\x6f\x75\x6e\x64\x22\x20\x73\x74\x72\x6f\x6b\x65\
\x2d\x77\x69\x64\x74\x68\x3d\x22\x32\x2e\x30\x30\x30\x30\x31\x22\
\x2f\x3e\x3c\x2f\x73\x76\x67\x3e\
\x00\x00\x02\x0e\
\x3c\
\x73\x76\x67\x20\x66\x69\x6c\x6c\x3d\x22\x6e\x6f\x6e\x65\x22\x20\
\x68\x65\x69\x67\x68\x74\x3d\x22\x31\x36\x22\x20\x76\x69\x65\x77\
\x42\x6f\x78\x3d\x22\x30\x20\x30\x20\x2e\x34\x38\x20\x2e\x34\x38\
\x22\x20\x77\x69\x64\x74\x68\x3d\x22\x31\x36\x22\x20\x78\x6d\x6c\
\x6e\x73\x3d\x22\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x77\
\x33\x2e\x6f\x72\x67\x2f\x32\x30\x30\x30\x2f\x73\x76\x67\x22\x3e\
\x3c\x70\x61\x74\x68\x20\x64\x3d\x22\x6d\x2e\x34\x35\x33\x34\x31\
\x35\x30\x35\x2e\x30\x36\x36\x35\x30\x34\x32\x33\x61\x2e\x30\x32\
\x36\x36\x39\x34\x31\x32\x2e\x30\x32\x36\x36\x39\x34\x31\x32\x20\
\x30\x20\x30\x20\x30\x20\x2d\x2e\x30\x31\x38\x39\x32\x36\x37\x2e\
\x30\x30\x37\x37\x36\x37\x6c\x2d\x2e\x32\x37\x36\x38\x34\x37\x32\
\x37\x2e\x32\x37\x34\x39\x31\x38\x34\x32\x2d\x2e\x31\x31\x32\x36\
\x31\x36\x30\x34\x2d\x2e\x31\x31\x31\x37\x38\x31\x35\x61\x2e\x30\
\x32\x36\x36\x39\x34\x31\x32\x2e\x30\x32\x36\x36\x39\x34\x31\x32\
\x20\x30\x20\x30\x20\x30\x20\x2d\x2e\x30\x33\x37\x37\x34\x37\x30\
\x36\x2e\x30\x30\x30\x31\x30\x33\x39\x32\x2e\x30\x32\x36\x36\x39\
\x34\x31\x32\x2e\x30\x32\x36\x36\x39\x34\x31\x32\x20\x30\x20\x30\
\x20\x30\x20\x2e\x30\x30\x30\x31\x30\x34\x33\x36\x2e\x30\x33\x37\
\x37\x34\x37\x34\x6c\x2e\x31\x33\x31\x34\x33\x37\x33\x2e\x31\x33\
\x30\x34\x39\x38\x39\x32\x61\x2e\x30\x32\x36\x36\x39\x36\x37\x39\
\x2e\x30\x32\x36\x36\x39\x36\x37\x39\x20\x30\x20\x30\x20\x30\x20\
\x2e\x30\x33\x37\x35\x39\x30\x38\x20\x30\x6c\x2e\x32\x39\x35\x37\
\x32\x30\x37\x35\x2d\x2e\x32\x39\x33\x36\x33\x35\x33\x39\x61\x2e\
\x30\x32\x36\x36\x39\x34\x31\x32\x2e\x30\x32\x36\x36\x39\x34\x31\
\x32\x20\x30\x20\x30\x20\x30\x20\x2e\x30\x30\x30\x31\x30\x34\x33\
\x36\x2d\x2e\x30\x33\x37\x37\x34\x37\x31\x2e\x30\x32\x36\x36\x39\
\x34\x31\x32\x2e\x30\x32\x36\x36\x39\x34\x31\x32\x20\x30\x20\x30\
\x20\x30\x20\x2d\x2e\x30\x31\x38\x38\x32\x30\x35\x2d\x2e\x30\x30\
\x37\x38\x37\x31\x37\x7a\x22\x20\x66\x69\x6c\x6c\x3d\x22\x23\x30\
\x30\x38\x30\x30\x30\x22\x20\x73\x74\x72\x6f\x6b\x65\x2d\x6c\x69\
\x6e\x65\x63\x61\x70\x3d\x22\x72\x6f\x75\x6e\x64\x22\x20\x73\x74\
\x72\x6f\x6b\x65\x2d\x6c\x69\x6e\x65\x6a\x6f\x69\x6e\x3d\x22\x72\
\x6f\x75\x6e\x64\x22\x2f\x3e\x3c\x2f\x73\x76\x67\x3e\
\x00\x00\x01\x1b\
\x3c\
\x73\x76\x67\x20\x66\x69\x6c\x6c\x3d\x22\x6e\x6f\x6e\x65\x22\x20\
\x68\x65\x69\x67\x68\x74\x3d\x22\x38\x30\x30\x22\x20\x76\x69\x65\
\x77\x42\x6f\x78\x3d\x22\x30\x20\x30\x20\x32\x34\x20\x32\x34\x22\
\x20\x77\x69\x64\x74\x68\x3d\x22\x38\x30\x30\x22\x20\x78\x6d\x6c\
\x6e\x73\x3d\x22\x68\x74\x74\x70\x3a\x2f\x2f\x77\x77\x77\x2e\x77\
\x33\x2e\x6f\x72\x67\x2f\x32\x30\x30\x30\x2f\x73\x76\x67\x22\x3e\
\x3c\x70\x61\x74\x68\x20\x64\x3d\x22\x6d\x31\x2e\x30\x30\x30\x30\
\x30\x30\x31\x20\x31\x32\x68\x32\x31\x2e\x39\x39\x39\x39\x39\x39\
\x39\x6d\x30\x20\x30\x2d\x39\x2e\x34\x32\x38\x35\x37\x31\x2d\x39\
\x2e\x35\x30\x30\x30\x30\x30\x32\x6d\x39\x2e\x34\x32\x38\x35\x37\
\x31\x20\x39\x2e\x35\x30\x30\x30\x30\x30\x32\x2d\x39\x2e\x34\x32\
\x38\x35\x37\x31\x20\x39\x2e\x34\x39\x39\x39\x39\x39\x22\x20\x73\
\x74\x72\x6f\x6b\x65\x3d\x22\x23\x30\x30\x30\x22\x20\x73\x74\x72\
\x6f\x6b\x65\x2d\x6c\x69\x6e\x65\x63\x61\x70\x3d\x22\x72\x6f\x75\
\x6e\x64\x22\x20\x73\x74\x72\x6f\x6b\x65\x2d\x6c\x69\x6e\x65\x6a\
\x6f\x69\x6e\x3d\x22\x72\x6f\x75\x6e\x64\x22\x20\x73\x74\x72\x6f\
\x6b\x65\x2d\x77\x69\x64\x74\x68\x3d\x22\x31\x2e\x39\x39\x39\x39\
\x39\x22\x2f\x3e\x3c\x2f\x73\x76\x67\x3e\
"

qt_resource_name = b"\
\x00\x04\
\x00\x06\xfa\x5e\
\x00\x69\
\x00\x63\x00\x6f\x00\x6e\
\x00\x09\
\x05\x88\x86\xa7\
\x00\x67\
\x00\x6c\x00\x6f\x00\x62\x00\x65\x00\x2e\x00\x73\x00\x76\x00\x67\
\x00\x08\
\x06\x38\x57\x27\
\x00\x68\
\x00\x6f\x00\x6d\x00\x65\x00\x2e\x00\x73\x00\x76\x00\x67\
\x00\x0c\
\x08\x37\xc0\xc7\
\x00\x70\
\x00\x72\x00\x65\x00\x76\x00\x69\x00\x6f\x00\x75\x00\x73\x00\x2e\x00\x73\x00\x76\x00\x67\
\x00\x09\
\x0b\x9e\x89\x07\
\x00\x63\
\x00\x68\x00\x65\x00\x63\x00\x6b\x00\x2e\x00\x73\x00\x76\x00\x67\
\x00\x08\
\x0c\xf7\x54\x47\
\x00\x6e\
\x00\x65\x00\x78\x00\x74\x00\x2e\x00\x73\x00\x76\x00\x67\
"

qt_resource_struct_v1 = b"\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x01\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x05\x00\x00\x00\x02\
\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\
\x00\x00\x00\x26\x00\x00\x00\x00\x00\x01\x00\x00\x06\xd4\
\x00\x00\x00\x3c\x00\x00\x00\x00\x00\x01\x00\x00\x07\xec\
\x00\x00\x00\x5a\x00\x00\x00\x00\x00\x01\x00\x00\x09\x19\
\x00\x00\x00\x72\x00\x00\x00\x00\x00\x01\x00\x00\x0b\x2b\
"

qt_resource_struct_v2 = b"\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x01\x00\x00\x00\x01\
\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x00\x00\x02\x00\x00\x00\x05\x00\x00\x00\x02\
\x00\x00\x00\x00\x00\x00\x00\x00\
\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x01\x00\x00\x00\x00\
\x00\x00\x01\x92\xae\x5a\x49\x66\
\x00\x00\x00\x26\x00\x00\x00\x00\x00\x01\x00\x00\x06\xd4\
\x00\x00\x01\x92\xae\x5a\x49\x66\
\x00\x00\x00\x3c\x00\x00\x00\x00\x00\x01\x00\x00\x07\xec\
\x00\x00\x01\x92\xae\x5a\x49\x66\
\x00\x00\x00\x5a\x00\x00\x00\x00\x00\x01\x00\x00\x09\x19\
\x00\x00\x01\x94\x75\x86\x88\x16\
\x00\x00\x00\x72\x00\x00\x00\x00\x00\x01\x00\x00\x0b\x2b\
\x00\x00\x01\x92\xae\x5a\x49\x66\
"

qt_version = [int(v) for v in QtCore.qVersion().split('.')]
if qt_version < [5, 8, 0]:
    rcc_version = 1
    qt_resource_struct = qt_resource_struct_v1
else:
    rcc_version = 2
    qt_resource_struct = qt_resource_struct_v2

def qInitResources():
    """
    Registers embedded resource data with Qt, making resources available for use.
    """
    QtCore.qRegisterResourceData(rcc_version, qt_resource_struct, qt_resource_name, qt_resource_data)

def qCleanupResources():
    """
    Unregisters previously registered resource data, freeing up resources.
    """
    QtCore.qUnregisterResourceData(rcc_version, qt_resource_struct, qt_resource_name, qt_resource_data)

qInitResources()
