find_package(Git)

if(GIT_EXECUTABLE)
  execute_process(
    COMMAND ${GIT_EXECUTABLE} fetch --all
    WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_DESCRIBE_VERSION
    RESULT_VARIABLE GIT_DESCRIBE_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
  execute_process(
      COMMAND ${GIT_EXECUTABLE} rev-parse --short=10 HEAD
      RESULT_VARIABLE result_GIT_HASH
      OUTPUT_VARIABLE GIT_HASH
      OUTPUT_STRIP_TRAILING_WHITESPACE
   )
  execute_process(
    COMMAND ${GIT_EXECUTABLE} describe --tags --dirty --match "v*"
    WORKING_DIRECTORY ${CMAKE_CURRENT_SOURCE_DIR}
    OUTPUT_VARIABLE GIT_DESCRIBE_VERSION
    RESULT_VARIABLE GIT_DESCRIBE_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
    )
  execute_process(
    COMMAND ${GIT_EXECUTABLE} ls-files --others --exclude-standard
    OUTPUT_FILE git_untracked.log
    RESULT_VARIABLE GIT_VERSION_UNTRACKED_LIST_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
  execute_process(
    COMMAND wc -l
    INPUT_FILE git_untracked.log
    OUTPUT_VARIABLE GIT_VERSION_UNTRACKED
    RESULT_VARIABLE GIT_VERSION_UNTRACKED_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
  execute_process(COMMAND rm git_untracked.log)
  execute_process(
    COMMAND ${GIT_EXECUTABLE} show -s --format=%ct
    OUTPUT_VARIABLE VERSION_TIMESTAMP
    RESULT_VARIABLE VERSION_TIMESTAMP_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )

  if(NOT GIT_DESCRIBE_ERROR_CODE)
    string(REGEX REPLACE "^v" "" GIT_VERSION "${GIT_DESCRIBE_VERSION}")
  endif()
endif()

if(NOT DEFINED GIT_VERSION)
  set(GIT_VERSION 0.0.0-unknown-dirty)
  message(WARNING "Failed to determine GIT_VERSION from Git tags. Using default version \"${GIT_VERSION}\".")
  execute_process(
    COMMAND ./timestamp
    OUTPUT_VARIABLE VERSION_TIMESTAMP
    RESULT_VARIABLE VERSION_TIMESTAMP_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
endif()

string(REGEX MATCH "^([0-9]+)\\.([0-9]+)\\.([0-9]+)(-[a-z0-9]+)?(.*-dirty)?" GIT_VERSION_MATCH ${GIT_VERSION})
set(GIT_VERSION_MAJOR ${CMAKE_MATCH_1})
set(GIT_VERSION_MINOR ${CMAKE_MATCH_2})
set(GIT_VERSION_PATCH ${CMAKE_MATCH_3})
set(GIT_VERSION_PRE_RELEASE ${CMAKE_MATCH_4})
set(GIT_VERSION_DIRTY ${CMAKE_MATCH_5})

if(${GIT_VERSION_UNTRACKED})
  set(GIT_VERSION ${GIT_VERSION}-untracked)
endif()
string(STRIP "${GIT_VERSION_DIRTY}" GIT_VERSION_DIRTY)
if (GIT_VERSION_DIRTY STREQUAL "")
  message("GIT clean (not dirty)")
else()
  message("GIT DIRTY!")
  execute_process(
    COMMAND ./timestamp
    OUTPUT_VARIABLE VERSION_TIMESTAMP
    RESULT_VARIABLE VERSION_TIMESTAMP_ERROR_CODE
    OUTPUT_STRIP_TRAILING_WHITESPACE
  )
endif()
message("GIT_VERSION: " ${GIT_VERSION})
message("GIT_VERSION_MAJOR: " ${GIT_VERSION_MAJOR})
message("GIT_VERSION_MINOR: " ${GIT_VERSION_MINOR})
message("GIT_VERSION_PATCH: " ${GIT_VERSION_PATCH})
message("GIT_VERSION_PRE_RELEASE: " ${GIT_VERSION_PRE_RELEASE})
message("GIT_VERSION_DIRTY: " ${GIT_VERSION_DIRTY})
message("GIT_VERSION_UNTRACKED: " ${GIT_VERSION_UNTRACKED})
message("VERSION_TIMESTAMP: ${VERSION_TIMESTAMP}")