# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.async_support.base.exchange import Exchange
from ccxt.abstract.bitir import ImplicitAPI
from ccxt.base.types import Any, Int, Market, OrderBook, Strings, Ticker, Tickers
from typing import List


class bitir(Exchange, ImplicitAPI):

    def describe(self) -> Any:
        return self.deep_extend(super(bitir, self).describe(), {
            'id': 'bitir',
            'name': 'Bit.ir',
            'countries': ['IR'],
            'rateLimit': 1000,
            'version': '1',
            'certified': False,
            'pro': False,
            'has': {
                'CORS': None,
                'spot': True,
                'margin': False,
                'swap': False,
                'future': False,
                'option': False,
                'addMargin': False,
                'cancelAllOrders': False,
                'cancelOrder': False,
                'cancelOrders': False,
                'createDepositAddress': False,
                'createOrder': False,
                'createStopLimitOrder': False,
                'createStopMarketOrder': False,
                'createStopOrder': False,
                'editOrder': False,
                'fetchBalance': False,
                'fetchBorrowInterest': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchClosedOrders': False,
                'fetchCrossBorrowRate': False,
                'fetchCrossBorrowRates': False,
                'fetchCurrencies': False,
                'fetchDepositAddress': False,
                'fetchDeposits': False,
                'fetchFundingHistory': False,
                'fetchFundingRate': False,
                'fetchFundingRateHistory': False,
                'fetchFundingRates': False,
                'fetchIndexOHLCV': False,
                'fetchIsolatedBorrowRate': False,
                'fetchIsolatedBorrowRates': False,
                'fetchL2OrderBook': False,
                'fetchLedger': False,
                'fetchLedgerEntry': False,
                'fetchLeverageTiers': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': False,
                'fetchOHLCV': True,
                'fetchOpenInterestHistory': False,
                'fetchOpenOrders': False,
                'fetchOrder': False,
                'fetchOrderBook': True,
                'fetchOrders': False,
                'fetchOrderTrades': 'emulated',
                'fetchPositions': False,
                'fetchPremiumIndexOHLCV': False,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTime': False,
                'fetchTrades': False,
                'fetchTradingFee': False,
                'fetchTradingFees': False,
                'fetchWithdrawals': False,
                'setLeverage': False,
                'setMarginMode': False,
                'transfer': False,
                'withdraw': False,
            },
            'comment': 'This comment is optional',
            'urls': {
                'logo': 'https://iranbroker.net/wp-content/uploads/2023/05/bit.ir-logo-png.png',
                'api': {
                    'public': 'https://api.bit.ir',
                },
                'www': 'https://www.bit.ir',
                'doc': [
                    'https://www.bit.ir',
                ],
            },
            'timeframes': {
                '1h': '60',
                '3h': '180',
                '6h': '360',
                '12h': '720',
                '1d': '1D',
                '2d': '2D',
                '3d': '3D',
                '1w': '1W',
                '1M': '1M',
            },
            'api': {
                'public': {
                    'get': {
                        'v1/market': 1,
                        'v2/udf/real/history': 1,
                        'v1/market/{id}/order': 1,
                    },
                },
            },
            'commonCurrencies': {
                'IRR': 'IRT',
            },
            'fees': {
                'trading': {
                    'tierBased': False,
                    'percentage': True,
                    'maker': self.parse_number('0.001'),
                    'taker': self.parse_number('0.001'),
                },
            },
        })

    async def fetch_markets(self, params={}) -> List[Market]:
        """
        retrieves data on all markets for bitir
        https://www.bit.ir/fa
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: an array of objects representing market data
        """
        response = await self.publicGetV1Market()
        markets = self.safe_list(response, 'data')
        result = []
        for i in range(0, len(markets)):
            market = self.parse_market(markets[i])
            result.append(market)
        return result

    def parse_market(self, market) -> Market:
        # {
        #     'id': 1,
        #     'uid': 'ec00b2c906039253d62f0f1cf03f0c3c992a3262',
        #     'base_currency': {
        #         'id': 'BTC',
        #         'icon_path': 'https://coins-ir-bit.bit.ir/front-pngs/btc.png',
        #         'name': 'بیت کوین',
        #         'decimal_precision': 8,
        #     },
        #     'quote_currency': {
        #         'id': 'IRR',
        #         'icon_path': 'https://coins-ir-bit.bit.ir/front-pngs/irt.png',
        #         'name': 'تومان',
        #         'decimal_precision': 0,
        #     },
        #     'name': 'بیت کوین - تومان',
        #     'quote_currency_precision': 0,
        #     'base_currency_precision': 8,
        #     'history': [
        #         '39720036590',
        #         '39554414710',
        #         '39749295670',
        #         '39928938500',
        #         '39640942650',
        #         '39658390120',
        #         '39610761890',
        #         '39993818410',
        #         '39864571220',
        #         '39896337660',
        #         '39940417440',
        #         '39886829510',
        #         '39852060060',
        #         '39831320470',
        #         '40060533430',
        #         '40162665220',
        #         '40077517070',
        #         '39867289240',
        #         '39827433250',
        #         '39667574820',
        #         '39699242910',
        #         '39547099850',
        #         '39643401200',
        #         '39619745360',
        #     ],
        #     'min_price': '39351207320',
        #     'max_price': '40209135030',
        #     'last_price': '39619745360',
        #     'last_volume': '12146697437',
        #     'day_change_percent': -0.25,
        #     'week_change_percent': -0.8,
        #     'tradingview_symbol': 'BINANCE:BTCUSDT',
        #     'liked_by_user': False,
        # },
        baseCurrency = self.safe_dict(market, 'base_currency')
        quoteCurrency = self.safe_dict(market, 'quote_currency')
        id = self.safe_string(market, 'id')
        baseId = self.safe_string(baseCurrency, 'id')
        quoteId = self.safe_string(quoteCurrency, 'id')
        base = self.safe_currency_code(baseId)
        quote = self.safe_currency_code(quoteId)
        baseId = baseId.lower()
        quoteId = quoteId.lower()
        return {
            'id': id,
            'symbol': base + '/' + quote,
            'base': base,
            'quote': quote,
            'settle': None,
            'baseId': baseId,
            'quoteId': quoteId,
            'settleId': None,
            'type': 'spot',
            'spot': True,
            'margin': False,
            'swap': False,
            'future': False,
            'option': False,
            'active': True,
            'contract': False,
            'linear': None,
            'inverse': None,
            'contractSize': None,
            'expiry': None,
            'expiryDatetime': None,
            'strike': None,
            'optionType': None,
            'precision': {
                'amount': None,
                'price': None,
            },
            'limits': {
                'leverage': {
                    'min': None,
                    'max': None,
                },
                'amount': {
                    'min': None,
                    'max': None,
                },
                'price': {
                    'min': None,
                    'max': None,
                },
                'cost': {
                    'min': None,
                    'max': None,
                },
            },
            'created': None,
            'info': market,
        }

    async def fetch_tickers(self, symbols: Strings = None, params={}) -> Tickers:
        """
        fetches price tickers for multiple markets, statistical information calculated over the past 24 hours for each market
        https://www.bit.ir/fa
        :param str[]|None symbols: unified symbols of the markets to fetch the ticker for, all market tickers are returned if not assigned
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `ticker structures <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        if symbols is not None:
            symbols = self.market_symbols(symbols)
        response = await self.publicGetV1Market()
        markets = self.safe_list(response, 'data')
        result = []
        for i in range(0, len(markets)):
            ticker = self.parse_ticker(markets[i])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return self.filter_by_array_tickers(result, 'symbol', symbols)

    async def fetch_ticker(self, symbol: str, params={}) -> Ticker:
        """
        fetches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market
        https://www.bit.ir/fa
        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'id': market['id'],
        }
        response = await self.publicGetV1Market(request)
        markets = self.safe_dict(response, 'data')
        ticker = self.parse_ticker(markets)
        return ticker

    def parse_ticker(self, ticker, market: Market = None) -> Ticker:
        # {
        #     'id': 1,
        #     'uid': 'ec00b2c906039253d62f0f1cf03f0c3c992a3262',
        #     'base_currency': {
        #         'id': 'BTC',
        #         'icon_path': 'https://coins-ir-bit.bit.ir/front-pngs/btc.png',
        #         'name': 'بیت کوین',
        #         'decimal_precision': 8,
        #     },
        #     'quote_currency': {
        #         'id': 'IRR',
        #         'icon_path': 'https://coins-ir-bit.bit.ir/front-pngs/irt.png',
        #         'name': 'تومان',
        #         'decimal_precision': 0,
        #     },
        #     'name': 'بیت کوین - تومان',
        #     'quote_currency_precision': 0,
        #     'base_currency_precision': 8,
        #     'history': [
        #         '39720036590',
        #         '39554414710',
        #         '39749295670',
        #         '39928938500',
        #         '39640942650',
        #         '39658390120',
        #         '39610761890',
        #         '39993818410',
        #         '39864571220',
        #         '39896337660',
        #         '39940417440',
        #         '39886829510',
        #         '39852060060',
        #         '39831320470',
        #         '40060533430',
        #         '40162665220',
        #         '40077517070',
        #         '39867289240',
        #         '39827433250',
        #         '39667574820',
        #         '39699242910',
        #         '39547099850',
        #         '39643401200',
        #         '39619745360',
        #     ],
        #     'min_price': '39351207320',
        #     'max_price': '40209135030',
        #     'last_price': '39619745360',
        #     'last_volume': '12146697437',
        #     'day_change_percent': -0.25,
        #     'week_change_percent': -0.8,
        #     'tradingview_symbol': 'BINANCE:BTCUSDT',
        #     'liked_by_user': False,
        # },
        marketType = 'spot'
        marketId = self.safe_string(ticker, 'id')
        marketinfo = self.market(marketId)
        symbol = self.safe_symbol(marketId, market, None, marketType)
        high = self.safe_float(ticker, 'max_price', 0)
        low = self.safe_float(ticker, 'min_price', 0)
        bid = self.safe_float(ticker, 'min_price', 0)
        ask = self.safe_float(ticker, 'max_price', 0)
        open = self.safe_float(ticker, 'last_price', 0)
        close = self.safe_float(ticker, 'last_price', 0)
        change = self.safe_float(ticker, 'day_change_percent', 0)
        last = self.safe_float(ticker, 'last_price', 0)
        quoteVolume = self.safe_float(ticker, 'last_volume', 0)
        if marketinfo['quote'] == 'IRT':
            high = high / 10 if high else 0
            low = low / 10 if low else 0
            bid = bid / 10 if bid else 0
            ask = ask / 10 if ask else 0
            open = open / 10 if open else 0
            close = close / 10 if close else 0
            last = last / 10 if last else 0
            quoteVolume = quoteVolume / 10 if quoteVolume else 0
        return self.safe_ticker({
            'symbol': symbol,
            'timestamp': None,
            'datetime': None,
            'high': high,
            'low': low,
            'bid': bid,
            'bidVolume': None,
            'ask': ask,
            'askVolume': None,
            'vwap': None,
            'open': open,
            'close': close,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': None,
            'average': None,
            'baseVolume': None,
            'quoteVolume': quoteVolume,
            'info': ticker,
        }, market)

    async def fetch_ohlcv(self, symbol: str, timeframe='1h', since: Int = None, limit: Int = None, params={}) -> List[list]:
        """
        fetches historical candlestick data containing the open, high, low, and close price, and the volume of a market
        https://www.bit.ir/fa
        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        await self.load_markets()
        market = self.market(symbol)
        symbol = market['base'] + market['quote']
        if market['quote'] == 'IRT':
            symbol = market['base'] + 'IRR'
        endTime = Date.now()
        request = {
            'symbol': symbol,
            'from': (endTime / 1000) - (24 * 60 * 60),
            'to': endTime / 1000,
            'resolution': self.safe_string(self.timeframes, timeframe, timeframe),
        }
        if since is not None:
            request['from'] = since / 1000
        request['from'] = self.safe_integer(request, 'from')
        request['to'] = self.safe_integer(request, 'to')
        if timeframe is not None:
            request['resolution'] = self.safe_string(self.timeframes, timeframe, timeframe)
        response = await self.publicGetV2UdfRealHistory(request)
        openList = self.safe_value(response, 'o', [])
        highList = self.safe_list(response, 'h', [])
        lowList = self.safe_list(response, 'l', [])
        closeList = self.safe_list(response, 'c', [])
        volumeList = self.safe_list(response, 'v', [])
        timestampList = self.safe_list(response, 't', [])
        ohlcvs = []
        for i in range(0, len(openList)):
            if market['quote'] == 'IRT':
                openList[i] = openList[i] / 10 if openList[i] else 0
                highList[i] = highList[i] / 10 if highList[i] else 0
                lowList[i] = lowList[i] / 10 if lowList[i] else 0
                closeList[i] = closeList[i] / 10 if closeList[i] else 0
                volumeList[i] = volumeList[i] / 10 if volumeList[i] else 0
            ohlcvs.append([
                timestampList[i],
                openList[i],
                highList[i],
                lowList[i],
                closeList[i],
                volumeList[i],
            ])
        return self.parse_ohlcvs(ohlcvs, market, timeframe, since, limit)

    async def fetch_order_book(self, symbol: str, limit: Int = None, params={}) -> OrderBook:
        """
        fetches information on open orders with bid(buy) and ask(sell) prices, volumes and other data for multiple markets
        https://www.bit.ir/fa
        :param str[]|None symbols: list of unified market symbols, all symbols fetched if None, default is None
        :param int [limit]: max number of entries per orderbook to return, default is None
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbol
        """
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'id': market['id'],
        }
        response = await self.publicGetV1MarketIdOrder(request)
        orderbookList = self.safe_list(response, 'data')
        orberbook = {'asks': [], 'bids': []}
        for i in range(0, len(orderbookList)):
            orderType = self.safe_string(orderbookList[i], 'type')
            price = self.safe_float(orderbookList[i], 'price', 0)
            amount = self.safe_float(orderbookList[i], 'amount', 0)
            if orderType == 'sell':
                if market['quote'] == 'IRT':
                    price = price / 10
                orberbook['asks'].append([price, amount])
            if orderType == 'buy':
                if market['quote'] == 'IRT':
                    price = price / 10
                orberbook['bids'].append([price, amount])
        timestamp = Date.now()
        return self.parse_order_book(orberbook, symbol, timestamp)

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        url = self.urls['api']['public'] + '/' + path
        if path == 'v1/market' and params['id'] is not None:
            url = url + '/' + params['id']
        if path == 'v2/udf/real/history':
            url = url + '?' + self.urlencode(query)
        if path == 'v1/market/{id}/order':
            url = self.urls['api']['public'] + '/v1/market/' + params['id'] + '/order'
        headers = {'Content-Type': 'application/json'}
        return {'url': url, 'method': method, 'body': body, 'headers': headers}
