# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.async_support.base.exchange import Exchange
from ccxt.abstract.sarrafex import ImplicitAPI
from ccxt.base.types import Any, Int, Market, OrderBook, Strings, Ticker, Tickers
from typing import List


class sarrafex(Exchange, ImplicitAPI):

    def describe(self) -> Any:
        return self.deep_extend(super(sarrafex, self).describe(), {
            'id': 'sarrafex',
            'name': 'Sarrafex',
            'countries': ['IR'],
            'rateLimit': 1000,
            'version': '1',
            'certified': False,
            'pro': False,
            'has': {
                'CORS': None,
                'spot': True,
                'margin': False,
                'swap': False,
                'future': False,
                'option': False,
                'addMargin': False,
                'cancelAllOrders': False,
                'cancelOrder': False,
                'cancelOrders': False,
                'createDepositAddress': False,
                'createOrder': False,
                'createStopLimitOrder': False,
                'createStopMarketOrder': False,
                'createStopOrder': False,
                'editOrder': False,
                'fetchBalance': False,
                'fetchBorrowInterest': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchClosedOrders': False,
                'fetchCrossBorrowRate': False,
                'fetchCrossBorrowRates': False,
                'fetchCurrencies': False,
                'fetchDepositAddress': False,
                'fetchDeposits': False,
                'fetchFundingHistory': False,
                'fetchFundingRate': False,
                'fetchFundingRateHistory': False,
                'fetchFundingRates': False,
                'fetchIndexOHLCV': False,
                'fetchIsolatedBorrowRate': False,
                'fetchIsolatedBorrowRates': False,
                'fetchL2OrderBook': False,
                'fetchLedger': False,
                'fetchLedgerEntry': False,
                'fetchLeverageTiers': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': False,
                'fetchOHLCV': True,
                'fetchOpenInterestHistory': False,
                'fetchOpenOrders': False,
                'fetchOrder': False,
                'fetchOrderBook': True,
                'fetchOrders': False,
                'fetchOrderTrades': 'emulated',
                'fetchPositions': False,
                'fetchPremiumIndexOHLCV': False,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTime': False,
                'fetchTrades': False,
                'fetchTradingFee': False,
                'fetchTradingFees': False,
                'fetchWithdrawals': False,
                'setLeverage': False,
                'setMarginMode': False,
                'transfer': False,
                'withdraw': False,
            },
            'comment': 'This comment is optional',
            'urls': {
                'logo': 'https://iranbroker.net/wp-content/uploads/2023/05/sarrafex-logo-png.png',
                'api': {
                    'public': 'https://sarrafex.com',
                    'ohlcv': 'https://api.sarrafex.com',
                },
                'www': 'https://sarrafex.com',
                'doc': [
                    'https://sarrafex.com',
                ],
            },
            'timeframes': {
                '1m': '1',
                '3m': '3',
                '5m': '5',
                '15m': '15',
                '30m': '30',
                '1h': '60',
                '2h': '120',
                '4h': '240',
                '6h': '360',
                '8h': '480',
                '12h': '720',
                '1d': '1D',
                '3d': '3D',
                '1w': '1W',
                '1M': '1M',
            },
            'api': {
                'public': {
                    'get': {
                        'api/gateway/exchanger/query/market': 1,
                        'exchanger/tradingview/history': 1,
                        'api/gateway/exchanger/orderbook': 1,
                    },
                },
            },
            'fees': {
                'trading': {
                    'tierBased': False,
                    'percentage': True,
                    'maker': self.parse_number('0.001'),
                    'taker': self.parse_number('0.001'),
                },
            },
        })

    async def fetch_markets(self, params={}) -> List[Market]:
        """
        retrieves data on all markets for sarrafex
        https://sarrafex.io/
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: an array of objects representing market data
        """
        response = await self.publicGetApiGatewayExchangerQueryMarket(params)
        markets = self.safe_list(response, 'value')
        result = []
        for i in range(0, len(markets)):
            market = self.parse_market(markets[i])
            result.append(market)
        return result

    def parse_market(self, market) -> Market:
        # {
        #     'assetPairId': 201,
        #     'pair': 'BAL/IRT',
        #     'symbol': 'BALIRT',
        #     'name': 'بالانسر',
        #     'enName': 'Balancer',
        #     'faName': 'بالانسر',
        #     'order': 0,
        #     'canSell': True,
        #     'canConvert': True,
        #     'convertBaseMinAmount': 500000,
        #     'convertCounterMinAmount': 2,
        #     'convertBaseMaxAmount': 500000000,
        #     'convertCounterMaxAmount': 2000,
        #     'canBuy': True,
        #     'iconUrl': 'coins/bal.png',
        #     'assetCategoryId': 1,
        #     'baseAssetId': 'IRT',
        #     'counterAssetId': 'BAL',
        #     'close': 234533.352,
        #     'high': 238562.277,
        #     'low': 232049.832,
        #     'open': 232780.632,
        #     'volume': 381744.504000004,
        #     'value': 89857376296.1089,
        #     'latestRate': 234838.604,
        #     'baseEnName': 'Toman',
        #     'baseFaName': 'تومان',
        #     'baseIconUrl': 'coins/irr.png',
        #     'secondLatestRate': 235483.765,
        #     'yesterdayLatestRate': 232780.632,
        #     'timestamp': '2024-05-29T08:30:28.7386055+00:00',
        #     'previewsPriceChangeValue': -645.161,
        #     'previewsPriceChangePercent': -0.27,
        #     'yesterdayPriceChangeValue': 2057.972,
        #     'yesterdayPriceChangePercent': 0.88,
        #     'baseAssetDecimals': 4,
        #     'counterAssetDecimals': 8,
        #     'minAmount': 2,
        #     'maxAmount': 0,
        #     'blockExplorer': 'https://etherscan.io',
        #     'socialNetworks': '{"Telegram":"https://t.me/","Twitter":"https://twitter.com/Balancer","Website":"https://balancer.finance/"}',
        #     'acceptedOrderTypes': [
        #         'Limit',
        #         'Market',
        #         'Stop-Market',
        #         'Stop-Limit',
        #         'IOC',
        #     ],
        #     'acceptedDecimals': [
        #         0.1,
        #         0.001,
        #         0.0001,
        #         1,
        #         10,
        #     ],
        #     'rank': 0,
        #     'profitRatio': 0.01,
        #     'obBaseAssetDecimals': 0,
        #     'obCounterAssetDecimals': 0,
        #     'hasRiskDisclosure': False,
        # }
        id = self.safe_string(market, 'assetPairId')
        baseId = self.safe_string(market, 'counterAssetId')
        quoteId = self.safe_string(market, 'baseAssetId')
        base = self.safe_currency_code(baseId)
        quote = self.safe_currency_code(quoteId)
        baseId = baseId.lower()
        quoteId = quoteId.lower()
        return {
            'id': id,
            'symbol': base + '/' + quote,
            'base': base,
            'quote': quote,
            'settle': None,
            'baseId': baseId,
            'quoteId': quoteId,
            'settleId': None,
            'type': 'spot',
            'spot': True,
            'margin': False,
            'swap': False,
            'future': False,
            'option': False,
            'active': True,
            'contract': False,
            'linear': None,
            'inverse': None,
            'contractSize': None,
            'expiry': None,
            'expiryDatetime': None,
            'strike': None,
            'optionType': None,
            'precision': {
                'amount': None,
                'price': None,
            },
            'limits': {
                'leverage': {
                    'min': None,
                    'max': None,
                },
                'amount': {
                    'min': None,
                    'max': None,
                },
                'price': {
                    'min': None,
                    'max': None,
                },
                'cost': {
                    'min': None,
                    'max': None,
                },
            },
            'created': None,
            'info': market,
        }

    async def fetch_tickers(self, symbols: Strings = None, params={}) -> Tickers:
        """
        fetches price tickers for multiple markets, statistical information calculated over the past 24 hours for each market
        https://sarrafex.io/
        :param str[]|None symbols: unified symbols of the markets to fetch the ticker for, all market tickers are returned if not assigned
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `ticker structures <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        if symbols is not None:
            symbols = self.market_symbols(symbols)
        response = await self.publicGetApiGatewayExchangerQueryMarket(params)
        markets = self.safe_list(response, 'value')
        result = {}
        for i in range(0, len(markets)):
            ticker = self.parse_ticker(markets[i])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return self.filter_by_array_tickers(result, 'symbol', symbols)

    async def fetch_ticker(self, symbol: str, params={}) -> Ticker:
        """
        fetches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market
        https://sarrafex.io/
        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'filter': 'assetPairId eq ' + market['id'],
        }
        response = await self.publicGetApiGatewayExchangerQueryMarket(request)
        pair = self.safe_list(response, 'value')
        ticker = self.parse_ticker(pair[0])
        return ticker

    def parse_ticker(self, ticker, market: Market = None) -> Ticker:
        # {
        #     'assetPairId': 201,
        #     'pair': 'BAL/IRT',
        #     'symbol': 'BALIRT',
        #     'name': 'بالانسر',
        #     'enName': 'Balancer',
        #     'faName': 'بالانسر',
        #     'order': 0,
        #     'canSell': True,
        #     'canConvert': True,
        #     'convertBaseMinAmount': 500000,
        #     'convertCounterMinAmount': 2,
        #     'convertBaseMaxAmount': 500000000,
        #     'convertCounterMaxAmount': 2000,
        #     'canBuy': True,
        #     'iconUrl': 'coins/bal.png',
        #     'assetCategoryId': 1,
        #     'baseAssetId': 'IRT',
        #     'counterAssetId': 'BAL',
        #     'close': 234533.352,
        #     'high': 238562.277,
        #     'low': 232049.832,
        #     'open': 232780.632,
        #     'volume': 381744.504000004,
        #     'value': 89857376296.1089,
        #     'latestRate': 234838.604,
        #     'baseEnName': 'Toman',
        #     'baseFaName': 'تومان',
        #     'baseIconUrl': 'coins/irr.png',
        #     'secondLatestRate': 235483.765,
        #     'yesterdayLatestRate': 232780.632,
        #     'timestamp': '2024-05-29T08:30:28.7386055+00:00',
        #     'previewsPriceChangeValue': -645.161,
        #     'previewsPriceChangePercent': -0.27,
        #     'yesterdayPriceChangeValue': 2057.972,
        #     'yesterdayPriceChangePercent': 0.88,
        #     'baseAssetDecimals': 4,
        #     'counterAssetDecimals': 8,
        #     'minAmount': 2,
        #     'maxAmount': 0,
        #     'blockExplorer': 'https://etherscan.io',
        #     'socialNetworks': '{"Telegram":"https://t.me/","Twitter":"https://twitter.com/Balancer","Website":"https://balancer.finance/"}',
        #     'acceptedOrderTypes': [
        #         'Limit',
        #         'Market',
        #         'Stop-Market',
        #         'Stop-Limit',
        #         'IOC',
        #     ],
        #     'acceptedDecimals': [
        #         0.1,
        #         0.001,
        #         0.0001,
        #         1,
        #         10,
        #     ],
        #     'rank': 0,
        #     'profitRatio': 0.01,
        #     'obBaseAssetDecimals': 0,
        #     'obCounterAssetDecimals': 0,
        #     'hasRiskDisclosure': False,
        # }
        marketType = 'spot'
        marketId = self.safe_string(ticker, 'assetPairId')
        symbol = self.safe_symbol(marketId, market, None, marketType)
        high = self.safe_float(ticker, 'high', 0)
        low = self.safe_float(ticker, 'low', 0)
        bid = self.safe_float(ticker, 'latestRate', 0)
        ask = self.safe_float(ticker, 'latestRate', 0)
        last = self.safe_float(ticker, 'latestRate', 0)
        change = self.safe_float(ticker, 'yesterdayPriceChangePercent', 0)
        baseVolume = self.safe_float(ticker, 'volume', 0)
        quoteVolume = self.safe_float(ticker, 'value', 0)
        datetime = self.safe_string(ticker, 'timestamp')
        return self.safe_ticker({
            'symbol': symbol,
            'timestamp': self.safe_timestamp(ticker, 'timestamp'),
            'datetime': datetime,
            'high': high,
            'low': low,
            'bid': bid,
            'bidVolume': None,
            'ask': ask,
            'askVolume': None,
            'vwap': None,
            'open': last,
            'close': last,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': None,
            'average': None,
            'baseVolume': baseVolume,
            'quoteVolume': quoteVolume,
            'info': ticker,
        }, market)

    async def fetch_ohlcv(self, symbol: str, timeframe='1m', since: Int = None, limit: Int = None, params={}) -> List[list]:
        """
        fetches historical candlestick data containing the open, high, low, and close price, and the volume of a market
        https://sarrafex.io/
        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        await self.load_markets()
        market = self.market(symbol)
        endTime = Date.now()
        request = {
            'symbol': market['base'] + market['quote'],
            'from': (endTime / 1000) - (24 * 60 * 60),
            'to': endTime / 1000,
            'resolution': self.safe_string(self.timeframes, timeframe, timeframe),
        }
        if market['quote'] == 'IRT':
            request['symbol'] = market['base'] + 'TMN'
        if since is not None:
            request['from'] = since / 1000
        request['from'] = self.safe_integer(request, 'from')
        request['to'] = self.safe_integer(request, 'to')
        if timeframe is not None:
            request['resolution'] = self.safe_string(self.timeframes, timeframe, timeframe)
        response = await self.publicGetExchangerTradingviewHistory(request)
        openList = self.safe_value(response, 'o', [])
        highList = self.safe_list(response, 'h', [])
        lastList = self.safe_list(response, 'l', [])
        closeList = self.safe_list(response, 'c', [])
        volumeList = self.safe_list(response, 'v', [])
        timestampList = self.safe_list(response, 't', [])
        ohlcvs = []
        for i in range(0, len(openList)):
            ohlcvs.append([
                timestampList[i],
                openList[i],
                highList[i],
                lastList[i],
                closeList[i],
                volumeList[i],
            ])
        return self.parse_ohlcvs(ohlcvs, market, timeframe, since, limit)

    async def fetch_order_book(self, symbol: str, limit: Int = None, params={}) -> OrderBook:
        """
        fetches information on open orders with bid(buy) and ask(sell) prices, volumes and other data for multiple markets
        https://sarrafex.io/
        :param str[]|None symbols: list of unified market symbols, all symbols fetched if None, default is None
        :param int [limit]: max number of entries per orderbook to return, default is None
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbol
        """
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'filter': 'assetPairId eq ' + market['id'],
        }
        orderBook = await self.publicGetApiGatewayExchangerOrderbook(request)
        orderBook = self.safe_dict(orderBook, 0)
        timestamp = Date.now()
        return self.parse_order_book(orderBook, symbol, timestamp, 'bids', 'asks', 'price', 'quantity')

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        url = self.urls['api']['public'] + '/' + path
        if params['filter'] is not None:
            url = url + '?' + self.urlencode(query)
        if path == 'exchanger/tradingview/history':
            url = self.urls['api']['ohlcv'] + '/' + path + '?' + self.urlencode(query)
        headers = {'Content-Type': 'application/json'}
        return {'url': url, 'method': method, 'body': body, 'headers': headers}
