# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.async_support.base.exchange import Exchange
from ccxt.abstract.ubitex import ImplicitAPI
from ccxt.base.types import Any, Int, Market, OrderBook, Strings, Ticker, Tickers
from typing import List


class ubitex(Exchange, ImplicitAPI):

    def describe(self) -> Any:
        return self.deep_extend(super(ubitex, self).describe(), {
            'id': 'ubitex',
            'name': 'Ubitex',
            'countries': ['IR'],
            'rateLimit': 1000,
            'version': '1',
            'certified': False,
            'pro': False,
            'has': {
                'CORS': None,
                'spot': True,
                'margin': False,
                'swap': False,
                'future': False,
                'option': False,
                'addMargin': False,
                'cancelAllOrders': False,
                'cancelOrder': False,
                'cancelOrders': False,
                'createDepositAddress': False,
                'createOrder': False,
                'createStopLimitOrder': False,
                'createStopMarketOrder': False,
                'createStopOrder': False,
                'editOrder': False,
                'fetchBalance': False,
                'fetchBorrowInterest': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchClosedOrders': False,
                'fetchCrossBorrowRate': False,
                'fetchCrossBorrowRates': False,
                'fetchCurrencies': False,
                'fetchDepositAddress': False,
                'fetchDeposits': False,
                'fetchFundingHistory': False,
                'fetchFundingRate': False,
                'fetchFundingRateHistory': False,
                'fetchFundingRates': False,
                'fetchIndexOHLCV': False,
                'fetchIsolatedBorrowRate': False,
                'fetchIsolatedBorrowRates': False,
                'fetchL2OrderBook': False,
                'fetchLedger': False,
                'fetchLedgerEntry': False,
                'fetchLeverageTiers': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': False,
                'fetchOHLCV': True,
                'fetchOpenInterestHistory': False,
                'fetchOpenOrders': False,
                'fetchOrder': False,
                'fetchOrderBook': True,
                'fetchOrders': False,
                'fetchOrderTrades': 'emulated',
                'fetchPositions': False,
                'fetchPremiumIndexOHLCV': False,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTime': False,
                'fetchTrades': False,
                'fetchTradingFee': False,
                'fetchTradingFees': False,
                'fetchWithdrawals': False,
                'setLeverage': False,
                'setMarginMode': False,
                'transfer': False,
                'withdraw': False,
            },
            'comment': 'This comment is optional',
            'urls': {
                'logo': 'https://ubitex.io/_next/image?url=https%3A%2F%2Fipfs.ubitex.io%2Fipfs%2FQmNqYsDFS1GoEeVYsPHkp8lFkodFeKo5cXLQlt1suO3T&w=256&q=75',
                'api': {
                    'public': 'https://appapi.ubitex.io',
                },
                'www': 'https://ubitex.io/',
                'doc': [
                    'https://ubitex.io/',
                ],
            },
            'timeframes': {
                '1m': '1',
                '1h': '60',
                '1d': '1D',
            },
            'api': {
                'public': {
                    'get': {
                        'api/dashboard/PairList': 1,
                        'api/chart/history': 1,
                        'api/dashboard': 1,
                    },
                },
            },
            'commonCurrencies': {
                'TMN': 'IRT',
            },
            'fees': {
                'trading': {
                    'tierBased': False,
                    'percentage': True,
                    'maker': self.parse_number('0.001'),
                    'taker': self.parse_number('0.001'),
                },
            },
        })

    async def fetch_markets(self, params={}) -> List[Market]:
        """
        retrieves data on all markets for ubitex
        https://ubitex.io/
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: an array of objects representing market data
        """
        response = await self.publicGetApiDashboardPairList(params)
        result = []
        for i in range(0, len(response)):
            market = self.parse_market(response[i])
            result.append(market)
        return result

    def parse_market(self, market) -> Market:
        # {
        # id: "4c0f8205-e8af-42ec-8399-f8fcef4d3dfc",
        # selected: False,
        # destinationCoinSymbol: "SLP",
        # destinationCoinName: "SLP",
        # destinationCoinNameFa: "اس ال پی",
        # sourceCoinSymbol: "TMN",
        # sourceCoinName: "TMN",
        # sourceCoinNameFa: "تومان",
        # bestBuy: 221.82,
        # bestSell: 230.8,
        # isFavorite: False,
        # increased: True,
        # change: -1.48,
        # decimalLength: 2,
        # sourceCoinIcon: "https://cdn.ubitex.io/static/uploads/2022/1/4f96a35c-c234-454b-9e9c-d32f98149bdb.svg",
        # destinationIcon: "https://cdn.ubitex.io/static/uploads/2022/1/fe92b313-766c-4ca6-8c80-2a9101b89767.svg",
        # destinationCategoryName: "NFT",
        # destinationCategorySymbol: "NFT",
        # destinationCategoryId: "5afbccd9-cdb1-470c-84e3-57e8917a925a",
        # isLeverageToken: False,
        # active: False,
        # lowestRecentOrder: 219.5985,
        # highestRecentOrder: 232.274,
        # todayTradeAmount: 2015932.1165,
        # todayTradeTotal: 0,
        # lastOrderPrice: 229.47,
        # buyersDepth: 0,
        # sellersDepth: 0,
        # coinDecimalLength: 4,
        # globalPrice: 0.003916,
        # platform: "Kucoin"
        # },
        id = self.safe_string(market, 'id')
        baseId = self.safe_string(market, 'destinationCoinSymbol')
        quoteId = self.safe_string(market, 'sourceCoinSymbol')
        base = self.safe_currency_code(baseId)
        quote = self.safe_currency_code(quoteId)
        baseId = baseId.lower()
        quoteId = quoteId.lower()
        return {
            'id': id,
            'symbol': base + '/' + quote,
            'base': base,
            'quote': quote,
            'settle': None,
            'baseId': baseId,
            'quoteId': quoteId,
            'settleId': None,
            'type': 'spot',
            'spot': True,
            'margin': False,
            'swap': False,
            'future': False,
            'option': False,
            'active': True,
            'contract': False,
            'linear': None,
            'inverse': None,
            'contractSize': None,
            'expiry': None,
            'expiryDatetime': None,
            'strike': None,
            'optionType': None,
            'precision': {
                'amount': None,
                'price': None,
            },
            'limits': {
                'leverage': {
                    'min': None,
                    'max': None,
                },
                'amount': {
                    'min': None,
                    'max': None,
                },
                'price': {
                    'min': None,
                    'max': None,
                },
                'cost': {
                    'min': None,
                    'max': None,
                },
            },
            'created': None,
            'info': market,
        }

    async def fetch_tickers(self, symbols: Strings = None, params={}) -> Tickers:
        """
        fetches price tickers for multiple markets, statistical information calculated over the past 24 hours for each market
        https://ubitex.io/
        :param str[]|None symbols: unified symbols of the markets to fetch the ticker for, all market tickers are returned if not assigned
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `ticker structures <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        if symbols is not None:
            symbols = self.market_symbols(symbols)
        response = await self.publicGetApiDashboardPairList(params)
        result = {}
        for i in range(0, len(response)):
            ticker = self.parse_ticker(response[i])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return self.filter_by_array_tickers(result, 'symbol', symbols)

    async def fetch_ticker(self, symbol: str, params={}) -> Ticker:
        """
        fetches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market
        https://ubitex.io/
        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'src': self.safe_string_upper(market, 'quoteId'),
            'dest': self.safe_string_upper(market, 'baseId'),
        }
        response = await self.publicGetApiDashboardPairList(request)
        pair = self.safe_dict(response, 0)
        ticker = self.parse_ticker(pair)
        return ticker

    def parse_ticker(self, ticker, market: Market = None) -> Ticker:
        # {
        # id: "4c0f8205-e8af-42ec-8399-f8fcef4d3dfc",
        # selected: False,
        # destinationCoinSymbol: "SLP",
        # destinationCoinName: "SLP",
        # destinationCoinNameFa: "اس ال پی",
        # sourceCoinSymbol: "TMN",
        # sourceCoinName: "TMN",
        # sourceCoinNameFa: "تومان",
        # bestBuy: 221.82,
        # bestSell: 230.8,
        # isFavorite: False,
        # increased: True,
        # change: -1.48,
        # decimalLength: 2,
        # sourceCoinIcon: "https://cdn.ubitex.io/static/uploads/2022/1/4f96a35c-c234-454b-9e9c-d32f98149bdb.svg",
        # destinationIcon: "https://cdn.ubitex.io/static/uploads/2022/1/fe92b313-766c-4ca6-8c80-2a9101b89767.svg",
        # destinationCategoryName: "NFT",
        # destinationCategorySymbol: "NFT",
        # destinationCategoryId: "5afbccd9-cdb1-470c-84e3-57e8917a925a",
        # isLeverageToken: False,
        # active: False,
        # lowestRecentOrder: 219.5985,
        # highestRecentOrder: 232.274,
        # todayTradeAmount: 2015932.1165,
        # todayTradeTotal: 0,
        # lastOrderPrice: 229.47,
        # buyersDepth: 0,
        # sellersDepth: 0,
        # coinDecimalLength: 4,
        # globalPrice: 0.003916,
        # platform: "Kucoin"
        # },
        marketType = 'spot'
        marketId = self.safe_string(ticker, 'id')
        symbol = self.safe_symbol(marketId, market, None, marketType)
        high = self.safe_float(ticker, 'highestRecentOrder', 0)
        low = self.safe_float(ticker, 'lowestRecentOrder', 0)
        bid = self.safe_float(ticker, 'bestBuy', 0)
        ask = self.safe_float(ticker, 'bestSell', 0)
        last = self.safe_float(ticker, 'lastOrderPrice', 0)
        change = self.safe_float(ticker, 'change', 0)
        baseVolume = self.safe_float(ticker, 'todayTradeAmount', 0)
        return self.safe_ticker({
            'symbol': symbol,
            'timestamp': None,
            'datetime': None,
            'high': high,
            'low': low,
            'bid': bid,
            'bidVolume': None,
            'ask': ask,
            'askVolume': None,
            'vwap': None,
            'open': last,
            'close': last,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': None,
            'average': None,
            'baseVolume': baseVolume,
            'quoteVolume': None,
            'info': ticker,
        }, market)

    async def fetch_ohlcv(self, symbol: str, timeframe='1m', since: Int = None, limit: Int = 100, params={}) -> List[list]:
        """
        fetches historical candlestick data containing the open, high, low, and close price, and the volume of a market
        https://ubitex.io/
        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        await self.load_markets()
        market = self.market(symbol)
        endTime = Date.now()
        request = {
            'symbol': market['base'] + market['quote'],
            'from': (endTime / 1000) - (24 * 60 * 60),
            'to': endTime / 1000,
            'resolution': self.safe_string(self.timeframes, timeframe, timeframe),
            'countback': limit,
        }
        if market['quote'] == 'IRT':
            request['symbol'] = market['base'] + 'TMN'
        if since is not None:
            request['from'] = since / 1000
        request['from'] = self.safe_integer(request, 'from')
        request['to'] = self.safe_integer(request, 'to')
        if timeframe is not None:
            request['resolution'] = self.safe_string(self.timeframes, timeframe, timeframe)
        response = await self.publicGetApiChartHistory(request)
        openList = self.safe_value(response, 'o', [])
        highList = self.safe_list(response, 'h', [])
        lastList = self.safe_list(response, 'l', [])
        closeList = self.safe_list(response, 'c', [])
        volumeList = self.safe_list(response, 'v', [])
        timestampList = self.safe_list(response, 't', [])
        ohlcvs = []
        for i in range(0, len(openList)):
            ohlcvs.append([
                timestampList[i],
                openList[i],
                highList[i],
                lastList[i],
                closeList[i],
                volumeList[i],
            ])
        return self.parse_ohlcvs(ohlcvs, market, timeframe, since, limit)

    async def fetch_order_book(self, symbol: str, limit: Int = None, params={}) -> OrderBook:
        """
        fetches information on open orders with bid(buy) and ask(sell) prices, volumes and other data for multiple markets
        https://ubitex.io/
        :param str[]|None symbols: list of unified market symbols, all symbols fetched if None, default is None
        :param int [limit]: max number of entries per orderbook to return, default is None
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbol
        """
        await self.load_markets()
        market = self.market(symbol)
        request = {
            'id': market['id'],
        }
        orderBook = await self.publicGetApiDashboard(request)
        timestamp = Date.now()
        return self.parse_order_book(orderBook, symbol, timestamp, 'buyers', 'sellers', 'price', 'totalAmount')

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        url = self.urls['api']['public'] + '/' + path
        if params['src'] is not None and params['dest'] is not None:
            url = url + '?' + self.urlencode(query)
        if path == 'api/dashboard':
            url = url + '/' + params['id'] + '/market'
        if path == 'api/chart/history':
            url = url + '?' + self.urlencode(query)
        headers = {'Content-Type': 'application/json'}
        return {'url': url, 'method': method, 'body': body, 'headers': headers}
