# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
from ccxt.abstract.excoino import ImplicitAPI
from ccxt.base.types import Any, Int, Market, OrderBook, Strings, Ticker, Tickers
from typing import List


class excoino(Exchange, ImplicitAPI):

    def describe(self) -> Any:
        return self.deep_extend(super(excoino, self).describe(), {
            'id': 'excoino',
            'name': 'Excoino',
            'countries': ['IR'],
            'rateLimit': 1000,
            'version': '1',
            'certified': False,
            'pro': False,
            'has': {
                'CORS': None,
                'spot': True,
                'margin': False,
                'swap': False,
                'future': False,
                'option': False,
                'addMargin': False,
                'cancelAllOrders': False,
                'cancelOrder': False,
                'cancelOrders': False,
                'createDepositAddress': False,
                'createOrder': False,
                'createStopLimitOrder': False,
                'createStopMarketOrder': False,
                'createStopOrder': False,
                'editOrder': False,
                'fetchBalance': False,
                'fetchBorrowInterest': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchClosedOrders': False,
                'fetchCrossBorrowRate': False,
                'fetchCrossBorrowRates': False,
                'fetchCurrencies': False,
                'fetchDepositAddress': False,
                'fetchDeposits': False,
                'fetchFundingHistory': False,
                'fetchFundingRate': False,
                'fetchFundingRateHistory': False,
                'fetchFundingRates': False,
                'fetchIndexOHLCV': False,
                'fetchIsolatedBorrowRate': False,
                'fetchIsolatedBorrowRates': False,
                'fetchL2OrderBook': False,
                'fetchLedger': False,
                'fetchLedgerEntry': False,
                'fetchLeverageTiers': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': False,
                'fetchOHLCV': True,
                'fetchOpenInterestHistory': False,
                'fetchOpenOrders': False,
                'fetchOrder': False,
                'fetchOrderBook': True,
                'fetchOrders': False,
                'fetchOrderTrades': 'emulated',
                'fetchPositions': False,
                'fetchPremiumIndexOHLCV': False,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTime': False,
                'fetchTrades': False,
                'fetchTradingFee': False,
                'fetchTradingFees': False,
                'fetchWithdrawals': False,
                'setLeverage': False,
                'setMarginMode': False,
                'transfer': False,
                'withdraw': False,
            },
            'comment': 'This comment is optional',
            'urls': {
                'logo': 'https://cdn.arz.digital/cr-odin/img/exchanges/excoino/64x64.png',
                'api': {
                    'public': 'https://market-api.excoino.com',
                },
                'www': 'https://www.excoino.com/',
                'doc': [
                    'https://market-api.excoino.com',
                ],
            },
            'timeframes': {
                '1m': '1',
                '5m': '5',
                '15m': '15',
                '30m': '30',
                '1h': '60',
                '4h': '240',
                '1d': '1D',
                '1W': '1W',
                '1M': '3M',
            },
            'api': {
                'public': {
                    'get': {
                        'market/symbol-thumb-trend': 1,
                        'market/history': 1,
                        'market/exchange-plate-full': 1,
                    },
                },
            },
            'commonCurrencies': {
                'BTCB': 'BTC',
                'IRR': 'IRT',
            },
            'fees': {
                'trading': {
                    'tierBased': False,
                    'percentage': True,
                    'maker': self.parse_number('0.001'),
                    'taker': self.parse_number('0.001'),
                },
            },
        })

    def fetch_markets(self, params={}) -> List[Market]:
        """
        retrieves data on all markets for excoino
        https://apidocs.excoino.ir/#6ae2dae4a2
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: an array of objects representing market data
        """
        response = self.publicGetMarketSymbolThumbTrend()
        result = []
        for i in range(0, len(response)):
            market = self.parse_market(response[i])
            result.append(market)
        return result

    def parse_market(self, market) -> Market:
        # {
        # coinType: "ORDINARY",
        # symbol: "USDT/IRR",
        # chg: -0.0065,
        # coinScale: 2,
        # displayName: "Tether",
        # change: -3807,
        # twentyFourHourVolume: 364506.8462,
        # oneHourTurnover: -3689066797218.638,
        # volume: 6455037.5749,
        # lastDayClose: 588715,
        # high: 590885,
        # coinUrl: "https://market-api.excoino.com/market/icons/currencies/USDT.png",
        # low: 584015,
        # zone: 0,
        # baseCoinScale: 0,
        # oneHourVolume: -6371368.6146,
        # usdRate: 1,
        # close: 584914,
        # turnover: 3738577518315.463,
        # baseUsdRate: 0.000001709653,
        # open: 588721,
        # twentyFourHourTurnover: 214737798378.2562
        # },
        baseId, quoteId = self.safe_string(market, 'symbol').split('/')
        id = self.safe_value(market, 'symbol')
        base = self.safe_currency_code(baseId)
        quote = self.safe_currency_code(quoteId)
        baseId = baseId.lower()
        quoteId = quoteId.lower()
        return {
            'id': id,
            'symbol': base + '/' + quote,
            'base': base,
            'quote': quote,
            'settle': None,
            'baseId': baseId,
            'quoteId': quoteId,
            'settleId': None,
            'type': 'spot',
            'spot': True,
            'margin': False,
            'swap': False,
            'future': False,
            'option': False,
            'active': True,
            'contract': False,
            'linear': None,
            'inverse': None,
            'contractSize': None,
            'expiry': None,
            'expiryDatetime': None,
            'strike': None,
            'optionType': None,
            'precision': {
                'amount': None,
                'price': None,
            },
            'limits': {
                'leverage': {
                    'min': None,
                    'max': None,
                },
                'amount': {
                    'min': None,
                    'max': None,
                },
                'price': {
                    'min': None,
                    'max': None,
                },
                'cost': {
                    'min': None,
                    'max': None,
                },
            },
            'created': None,
            'info': market,
        }

    def fetch_tickers(self, symbols: Strings = None, params={}) -> Tickers:
        """
        fetches price tickers for multiple markets, statistical information calculated over the past 24 hours for each market
        https://market-api.excoino.com
        :param str[]|None symbols: unified symbols of the markets to fetch the ticker for, all market tickers are returned if not assigned
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `ticker structures <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        self.load_markets()
        if symbols is not None:
            symbols = self.market_symbols(symbols)
        response = self.publicGetMarketSymbolThumbTrend()
        result = []
        for i in range(0, len(response)):
            ticker = self.parse_ticker(response[i])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return self.filter_by_array_tickers(result, 'symbol', symbols)

    def fetch_ticker(self, symbol: str, params={}) -> Ticker:
        """
        fetches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market
        https://market-api.excoino.com
        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        ticker = self.fetch_tickers([symbol])
        return ticker[symbol]

    def parse_ticker(self, ticker, market: Market = None) -> Ticker:
        # {
        # coinType: "ORDINARY",
        # symbol: "USDT/IRR",
        # chg: -0.0065,
        # coinScale: 2,
        # displayName: "Tether",
        # change: -3807,
        # twentyFourHourVolume: 364506.8462,
        # oneHourTurnover: -3689066797218.638,
        # volume: 6455037.5749,
        # lastDayClose: 588715,
        # high: 590885,
        # coinUrl: "https://market-api.excoino.com/market/icons/currencies/USDT.png",
        # low: 584015,
        # zone: 0,
        # baseCoinScale: 0,
        # oneHourVolume: -6371368.6146,
        # usdRate: 1,
        # close: 584914,
        # turnover: 3738577518315.463,
        # baseUsdRate: 0.000001709653,
        # open: 588721,
        # twentyFourHourTurnover: 214737798378.2562
        # },
        marketType = 'spot'
        marketId = self.safe_value(ticker, 'symbol')
        marketinfo = self.market(marketId)
        symbol = self.safe_symbol(marketId, market, None, marketType)
        high = self.safe_float(ticker, 'high', 0)
        low = self.safe_float(ticker, 'low', 0)
        open = self.safe_float(ticker, 'open', 0)
        close = self.safe_float(ticker, 'close', 0)
        change = self.safe_float(ticker, 'chg', 0)
        last = self.safe_float(ticker, 'close', 0)
        quoteVolume = self.safe_float(ticker, 'twentyFourHourTurnover', 0)
        if marketinfo['quote'] == 'IRT':
            high = high / 10 if high else 0
            low = low / 10 if low else 0
            open = open / 10 if open else 0
            close = close / 10 if close else 0
            last = last / 10 if last else 0
            quoteVolume = quoteVolume / 10 if quoteVolume else 0
        return self.safe_ticker({
            'symbol': symbol,
            'timestamp': None,
            'datetime': None,
            'high': high,
            'low': low,
            'bid': None,
            'bidVolume': None,
            'ask': None,
            'askVolume': None,
            'vwap': None,
            'open': open,
            'close': close,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': None,
            'average': None,
            'baseVolume': None,
            'quoteVolume': quoteVolume,
            'info': ticker,
        }, market)

    def fetch_ohlcv(self, symbol: str, timeframe='1h', since: Int = None, limit: Int = 200, params={}) -> List[list]:
        """
        fetches historical candlestick data containing the open, high, low, and close price, and the volume of a market
        https://market-api.excoino.com
        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        self.load_markets()
        market = self.market(symbol)
        endTime = Date.now()
        request = {
            'symbol': market['id'],
            'from': endTime - (24 * 60 * 60 * 1000),
            'to': endTime,
            'resolution': self.safe_string(self.timeframes, timeframe, timeframe),
            'size': limit,
        }
        if since is not None:
            request['from'] = since
        request['from'] = self.safe_integer(request, 'from')
        request['to'] = self.safe_integer(request, 'to')
        if timeframe is not None:
            request['resolution'] = self.safe_string(self.timeframes, timeframe, timeframe)
        response = self.publicGetMarketHistory(request)
        for i in range(0, len(response)):
            if market['quote'] == 'IRT':
                response[i][1] = (response[i][1] or 0) / 10
                response[i][2] = (response[i][2] or 0) / 10
                response[i][3] = (response[i][3] or 0) / 10
                response[i][4] = (response[i][4] or 0) / 10
                response[i][5] = (response[i][5] or 0) / 10
        return self.parse_ohlcvs(response, market, timeframe, since, limit)

    def fetch_order_book(self, symbol: str, limit: Int = None, params={}) -> OrderBook:
        """
        fetches information on open orders with bid(buy) and ask(sell) prices, volumes and other data for multiple markets
        https://market-api.excoino.com
        :param str[]|None symbols: list of unified market symbols, all symbols fetched if None, default is None
        :param int [limit]: max number of entries per orderbook to return, default is None
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbol
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'symbol': market['id'],
        }
        response = self.publicGetMarketExchangePlateFull(request)
        orderBook = {}
        bids = self.safe_dict(response, 'bid')
        asks = self.safe_dict(response, 'ask')
        if market['quote'] == 'IRT':
            bids = self.safe_dict(bids, 'items')
            asks = self.safe_dict(asks, 'items')
            for i in range(0, len(bids)):
                bids[i]['price'] = (bids[i]['price'] or 0) / 10
            for i in range(0, len(asks)):
                asks[i]['price'] = (asks[i]['price'] or 0) / 10
            orderBook['bids'] = bids
            orderBook['asks'] = asks
        else:
            bids = self.safe_dict(bids, 'items')
            asks = self.safe_dict(asks, 'items')
            orderBook['bids'] = bids
            orderBook['asks'] = asks
        timestamp = Date.now()
        return self.parse_order_book(orderBook, symbol, timestamp, 'bids', 'asks', 'price', 'amount')

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        url = self.urls['api']['public'] + '/' + path
        if path == 'market/history' or path == 'market/exchange-plate-full':
            url = url + '?' + self.urlencode(query)
        headers = {'Content-Type': 'application/json'}
        return {'url': url, 'method': method, 'body': body, 'headers': headers}
