# -*- coding: utf-8 -*-

# PLEASE DO NOT EDIT THIS FILE, IT IS GENERATED AND WILL BE OVERWRITTEN:
# https://github.com/ccxt/ccxt/blob/master/CONTRIBUTING.md#how-to-contribute-code

from ccxt.base.exchange import Exchange
from ccxt.abstract.jibitex import ImplicitAPI
from ccxt.base.types import Any, Int, Market, OrderBook, Strings, Ticker, Tickers
from typing import List


class jibitex(Exchange, ImplicitAPI):

    def describe(self) -> Any:
        return self.deep_extend(super(jibitex, self).describe(), {
            'id': 'jibitex',
            'name': 'Jibitex',
            'countries': ['IR'],
            'rateLimit': 1000,
            'version': '1',
            'certified': False,
            'pro': False,
            'has': {
                'CORS': None,
                'spot': True,
                'margin': False,
                'swap': False,
                'future': False,
                'option': False,
                'addMargin': False,
                'cancelAllOrders': False,
                'cancelOrder': False,
                'cancelOrders': False,
                'createDepositAddress': False,
                'createOrder': False,
                'createStopLimitOrder': False,
                'createStopMarketOrder': False,
                'createStopOrder': False,
                'editOrder': False,
                'fetchBalance': False,
                'fetchBorrowInterest': False,
                'fetchBorrowRateHistories': False,
                'fetchBorrowRateHistory': False,
                'fetchClosedOrders': False,
                'fetchCrossBorrowRate': False,
                'fetchCrossBorrowRates': False,
                'fetchCurrencies': False,
                'fetchDepositAddress': False,
                'fetchDeposits': False,
                'fetchFundingHistory': False,
                'fetchFundingRate': False,
                'fetchFundingRateHistory': False,
                'fetchFundingRates': False,
                'fetchIndexOHLCV': False,
                'fetchIsolatedBorrowRate': False,
                'fetchIsolatedBorrowRates': False,
                'fetchL2OrderBook': False,
                'fetchLedger': False,
                'fetchLedgerEntry': False,
                'fetchLeverageTiers': False,
                'fetchMarkets': True,
                'fetchMarkOHLCV': False,
                'fetchMyTrades': False,
                'fetchOHLCV': True,
                'fetchOpenInterestHistory': False,
                'fetchOpenOrders': False,
                'fetchOrder': False,
                'fetchOrderBook': True,
                'fetchOrders': False,
                'fetchOrderTrades': 'emulated',
                'fetchPositions': False,
                'fetchPremiumIndexOHLCV': False,
                'fetchTicker': True,
                'fetchTickers': True,
                'fetchTime': False,
                'fetchTrades': False,
                'fetchTradingFee': False,
                'fetchTradingFees': False,
                'fetchWithdrawals': False,
                'setLeverage': False,
                'setMarginMode': False,
                'transfer': False,
                'withdraw': False,
            },
            'comment': 'This comment is optional',
            'urls': {
                'logo': 'https://cdn.arz.digital/cr-odin/img/exchanges/jibitex/64x64.png',
                'api': {
                    'public': 'https://jibitex.co',
                },
                'www': 'https://jibitex.net',
                'doc': [
                    'https://jibitex.net',
                ],
            },
            'timeframes': {
                '1h': '60',
                '2h': '120',
                '1d': '1D',
                '1w': '1W',
            },
            'api': {
                'public': {
                    'get': {
                        'api/1/markets': 1,
                        'api/1/ohlcvs/tradingView': 1,
                        'api/1/orders/orderBook/market': 1,
                    },
                },
            },
            'fees': {
                'trading': {
                    'tierBased': False,
                    'percentage': True,
                    'maker': self.parse_number('0.001'),
                    'taker': self.parse_number('0.001'),
                },
            },
        })

    def fetch_markets(self, params={}) -> List[Market]:
        """
        retrieves data on all markets for jibitex
        https://jibitex.co/
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict[]: an array of objects representing market data
        """
        response = self.publicGetApi1Markets()
        markets = self.safe_list(response, 'content')
        result = []
        for i in range(0, len(markets)):
            market = self.parse_market(markets[i])
            result.append(market)
        return result

    def parse_market(self, market) -> Market:
        # {
        #     "id": "BTC_IRT",
        #     "symbol": "بیت کوین-تومان",
        #     "base": "BTC",
        #     "quote": "IRT",
        #     "buyPrice": "4033165000",
        #     "sellPrice": "4150000000",
        #     "userOrderPricePrecision": 0,
        #     "minimumOrder": 100000.00000000,
        #     "maximumOrder": 300000000.00000000,
        #     "last7DayGraph": "https://jibitex.co/api/1/markets/BTC_IRT/7d-price-graph",
        #     "changePrice": "-4298000",
        #     "changeRate": "-0.11",
        #     "changePrice7d": "-47147000",
        #     "lastTradedPrice": "4025872000",
        #     "lowestPrice": "4004218000",
        #     "highestPrice": "4149839000",
        #     "sourceVolume": "0.002",
        #     "destinationVolume": "115146752",
        #     "rank": 1,
        #     "baseTags": {
        #         "en": [
        #             "POW"
        #         ]
        #     },
        #     "quoteTags": {},
        #     "tradingEnabled": True,
        #     "swappingEnabled": False
        # },
        id = self.safe_string(market, 'id')
        baseId = self.safe_string(market, 'base')
        quoteId = self.safe_string(market, 'quote')
        base = self.safe_currency_code(baseId)
        quote = self.safe_currency_code(quoteId)
        baseId = baseId.lower()
        quoteId = quoteId.lower()
        return {
            'id': id,
            'symbol': base + '/' + quote,
            'base': base,
            'quote': quote,
            'settle': None,
            'baseId': baseId,
            'quoteId': quoteId,
            'settleId': None,
            'type': 'spot',
            'spot': True,
            'margin': False,
            'swap': False,
            'future': False,
            'option': False,
            'active': True,
            'contract': False,
            'linear': None,
            'inverse': None,
            'contractSize': None,
            'expiry': None,
            'expiryDatetime': None,
            'strike': None,
            'optionType': None,
            'precision': {
                'amount': None,
                'price': None,
            },
            'limits': {
                'leverage': {
                    'min': None,
                    'max': None,
                },
                'amount': {
                    'min': None,
                    'max': None,
                },
                'price': {
                    'min': None,
                    'max': None,
                },
                'cost': {
                    'min': None,
                    'max': None,
                },
            },
            'created': None,
            'info': market,
        }

    def fetch_tickers(self, symbols: Strings = None, params={}) -> Tickers:
        """
        fetches price tickers for multiple markets, statistical information calculated over the past 24 hours for each market
        https://jibitex.co/
        :param str[]|None symbols: unified symbols of the markets to fetch the ticker for, all market tickers are returned if not assigned
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `ticker structures <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        self.load_markets()
        if symbols is not None:
            symbols = self.market_symbols(symbols)
        request = {
            'with_price': 'true',
        }
        response = self.publicGetApi1Markets(request)
        markets = self.safe_list(response, 'content')
        result = {}
        for i in range(0, len(markets)):
            ticker = self.parse_ticker(markets[i])
            symbol = ticker['symbol']
            result[symbol] = ticker
        return self.filter_by_array_tickers(result, 'symbol', symbols)

    def fetch_ticker(self, symbol: str, params={}) -> Ticker:
        """
        fetches a price ticker, a statistical calculation with the information calculated over the past 24 hours for a specific market
        https://jibitex.co/
        :param str symbol: unified symbol of the market to fetch the ticker for
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a `ticker structure <https://docs.ccxt.com/#/?id=ticker-structure>`
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'with_price': 'true',
            'quote': market['quote'],
            'base': market['base'],
        }
        response = self.publicGetApi1Markets(request)
        marketData = self.safe_list(response, 'content')
        ticker = self.parse_ticker(marketData[0])
        return ticker

    def parse_ticker(self, ticker, market: Market = None) -> Ticker:
        # {
        #     "id": "BTC_IRT",
        #     "symbol": "بیت کوین-تومان",
        #     "base": "BTC",
        #     "quote": "IRT",
        #     "buyPrice": "4033165000",
        #     "sellPrice": "4150000000",
        #     "userOrderPricePrecision": 0,
        #     "minimumOrder": 100000.00000000,
        #     "maximumOrder": 300000000.00000000,
        #     "last7DayGraph": "https://jibitex.co/api/1/markets/BTC_IRT/7d-price-graph",
        #     "changePrice": "-4298000",
        #     "changeRate": "-0.11",
        #     "changePrice7d": "-47147000",
        #     "lastTradedPrice": "4025872000",
        #     "lowestPrice": "4004218000",
        #     "highestPrice": "4149839000",
        #     "sourceVolume": "0.002",
        #     "destinationVolume": "115146752",
        #     "rank": 1,
        #     "baseTags": {
        #         "en": [
        #             "POW"
        #         ]
        #     },
        #     "quoteTags": {},
        #     "tradingEnabled": True,
        #     "swappingEnabled": False
        # },
        marketType = 'spot'
        marketId = self.safe_string(ticker, 'id')
        symbol = self.safe_symbol(marketId, market, None, marketType)
        high = self.safe_float(ticker, 'highestPrice', 0)
        low = self.safe_float(ticker, 'lowestPrice', 0)
        bid = self.safe_float(ticker, 'buyPrice', 0)
        ask = self.safe_float(ticker, 'sellPrice', 0)
        last = self.safe_float(ticker, 'lastTradedPrice', 0)
        change = self.safe_float(ticker, 'changeRate', 0)
        baseVolume = self.safe_float(ticker, 'sourceVolume', 0)
        quoteVolume = self.safe_float(ticker, 'destinationVolume', 0)
        return self.safe_ticker({
            'symbol': symbol,
            'timestamp': None,
            'datetime': None,
            'high': high,
            'low': low,
            'bid': bid,
            'bidVolume': None,
            'ask': ask,
            'askVolume': None,
            'vwap': None,
            'open': last,
            'close': last,
            'last': last,
            'previousClose': None,
            'change': change,
            'percentage': None,
            'average': None,
            'baseVolume': baseVolume,
            'quoteVolume': quoteVolume,
            'info': ticker,
        }, market)

    def fetch_ohlcv(self, symbol: str, timeframe='1h', since: Int = None, limit: Int = None, params={}) -> List[list]:
        """
        fetches historical candlestick data containing the open, high, low, and close price, and the volume of a market
        https://jibitex.co/
        :param str symbol: unified symbol of the market to fetch OHLCV data for
        :param str timeframe: the length of time each candle represents
        :param int [since]: timestamp in ms of the earliest candle to fetch
        :param int [limit]: the maximum amount of candles to fetch
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns int[][]: A list of candles ordered, open, high, low, close, volume
        """
        self.load_markets()
        market = self.market(symbol)
        endTime = Date.now()
        request = {
            'market': market['id'],
            'from': (endTime / 1000) - (24 * 60 * 60),
            'to': endTime / 1000,
            'resolution': self.safe_string(self.timeframes, timeframe, timeframe),
        }
        if since is not None:
            request['from'] = since / 1000
        if timeframe is not None:
            request['resolution'] = self.safe_string(self.timeframes, timeframe, timeframe)
        request['from'] = self.safe_integer(request, 'from')
        request['to'] = self.safe_integer(request, 'to')
        response = self.publicGetApi1OhlcvsTradingView(request)
        ohlcvList = self.safe_list(response, 'content')
        ohlcvs = []
        for i in range(0, len(ohlcvList)):
            ohlcvs.append([
                self.safe_value(ohlcvList[i], 'time'),
                self.safe_value(ohlcvList[i], 'open'),
                self.safe_value(ohlcvList[i], 'high'),
                self.safe_value(ohlcvList[i], 'low'),
                self.safe_value(ohlcvList[i], 'close'),
                self.safe_value(ohlcvList[i], 'volumeTo'),
            ])
        return self.parse_ohlcvs(ohlcvs, market, timeframe, since, limit)

    def fetch_order_book(self, symbol: str, limit: Int = None, params={}) -> OrderBook:
        """
        fetches information on open orders with bid(buy) and ask(sell) prices, volumes and other data for multiple markets
        https://jibitex.co/
        :param str[]|None symbols: list of unified market symbols, all symbols fetched if None, default is None
        :param int [limit]: max number of entries per orderbook to return, default is None
        :param dict [params]: extra parameters specific to the exchange API endpoint
        :returns dict: a dictionary of `order book structures <https://docs.ccxt.com/#/?id=order-book-structure>` indexed by market symbol
        """
        self.load_markets()
        market = self.market(symbol)
        request = {
            'id': market['id'],
        }
        response = self.publicGetApi1OrdersOrderBookMarket(request)
        orderBook = self.safe_dict(response, 'content')
        timestamp = Date.now()
        return self.parse_order_book(orderBook, symbol, timestamp, 'buys', 'sells', 'unitPrice', 'size')

    def sign(self, path, api='public', method='GET', params={}, headers=None, body=None):
        query = self.omit(params, self.extract_params(path))
        url = self.urls['api']['public'] + '/' + path + '?' + self.urlencode(query)
        if params['id'] is not None:
            url = self.urls['api']['public'] + '/' + path + '/' + params['id']
        headers = {'Content-Type': 'application/json'}
        return {'url': url, 'method': method, 'body': body, 'headers': headers}
