# API Reference <a name="API Reference" id="api-reference"></a>

## Constructs <a name="Constructs" id="Constructs"></a>

### ApiGatewayToLambda <a name="ApiGatewayToLambda" id="must-cdk.ApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.ApiGatewayToLambda.Initializer"></a>

```typescript
import { ApiGatewayToLambda } from 'must-cdk'

new ApiGatewayToLambda(scope: Construct, id: string, props: ApiGatewayToLambdaProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.ApiGatewayToLambdaProps">ApiGatewayToLambdaProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.ApiGatewayToLambda.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.ApiGatewayToLambdaProps">ApiGatewayToLambdaProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.ApiGatewayToLambda.addRoute">addRoute</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `toString` <a name="toString" id="must-cdk.ApiGatewayToLambda.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addRoute` <a name="addRoute" id="must-cdk.ApiGatewayToLambda.addRoute"></a>

```typescript
public addRoute(route: CustomRoute): Method
```

Add a custom route after construction (for dynamic route addition).

###### `route`<sup>Required</sup> <a name="route" id="must-cdk.ApiGatewayToLambda.addRoute.parameter.route"></a>

- *Type:* <a href="#must-cdk.CustomRoute">CustomRoute</a>

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.ApiGatewayToLambda.isConstruct"></a>

```typescript
import { ApiGatewayToLambda } from 'must-cdk'

ApiGatewayToLambda.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.ApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGateway">apiGateway</a></code> | <code>aws-cdk-lib.aws_apigateway.RestApi</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiUrl">apiUrl</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup">apiGatewayLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.aRecord">aRecord</a></code> | <code>aws-cdk-lib.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.domain">domain</a></code> | <code>aws-cdk-lib.aws_apigateway.DomainName</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambda.property.usagePlan">usagePlan</a></code> | <code>aws-cdk-lib.aws_apigateway.UsagePlan</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.ApiGatewayToLambda.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `apiGateway`<sup>Required</sup> <a name="apiGateway" id="must-cdk.ApiGatewayToLambda.property.apiGateway"></a>

```typescript
public readonly apiGateway: RestApi;
```

- *Type:* aws-cdk-lib.aws_apigateway.RestApi

---

##### `apiUrl`<sup>Required</sup> <a name="apiUrl" id="must-cdk.ApiGatewayToLambda.property.apiUrl"></a>

```typescript
public readonly apiUrl: string;
```

- *Type:* string

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.ApiGatewayToLambda.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `apiGatewayLogGroup`<sup>Optional</sup> <a name="apiGatewayLogGroup" id="must-cdk.ApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```typescript
public readonly apiGatewayLogGroup: LogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroup

---

##### `aRecord`<sup>Optional</sup> <a name="aRecord" id="must-cdk.ApiGatewayToLambda.property.aRecord"></a>

```typescript
public readonly aRecord: ARecord;
```

- *Type:* aws-cdk-lib.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.ApiGatewayToLambda.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.ApiGatewayToLambda.property.domain"></a>

```typescript
public readonly domain: DomainName;
```

- *Type:* aws-cdk-lib.aws_apigateway.DomainName

---

##### `usagePlan`<sup>Optional</sup> <a name="usagePlan" id="must-cdk.ApiGatewayToLambda.property.usagePlan"></a>

```typescript
public readonly usagePlan: UsagePlan;
```

- *Type:* aws-cdk-lib.aws_apigateway.UsagePlan

---


### CloudFrontToOrigins <a name="CloudFrontToOrigins" id="must-cdk.CloudFrontToOrigins"></a>

#### Initializers <a name="Initializers" id="must-cdk.CloudFrontToOrigins.Initializer"></a>

```typescript
import { CloudFrontToOrigins } from 'must-cdk'

new CloudFrontToOrigins(scope: Construct, id: string, props: CloudFrontToOriginsProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.CloudFrontToOriginsProps">CloudFrontToOriginsProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.CloudFrontToOrigins.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.CloudFrontToOriginsProps">CloudFrontToOriginsProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getHttpOrigin">getHttpOrigin</a></code> | Get HTTP origin by origin ID. |
| <code><a href="#must-cdk.CloudFrontToOrigins.getS3Bucket">getS3Bucket</a></code> | Get S3 bucket by origin ID. |

---

##### `toString` <a name="toString" id="must-cdk.CloudFrontToOrigins.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `getHttpOrigin` <a name="getHttpOrigin" id="must-cdk.CloudFrontToOrigins.getHttpOrigin"></a>

```typescript
public getHttpOrigin(originId: string): HttpOrigin
```

Get HTTP origin by origin ID.

###### `originId`<sup>Required</sup> <a name="originId" id="must-cdk.CloudFrontToOrigins.getHttpOrigin.parameter.originId"></a>

- *Type:* string

---

##### `getS3Bucket` <a name="getS3Bucket" id="must-cdk.CloudFrontToOrigins.getS3Bucket"></a>

```typescript
public getS3Bucket(originId: string): IBucket
```

Get S3 bucket by origin ID.

###### `originId`<sup>Required</sup> <a name="originId" id="must-cdk.CloudFrontToOrigins.getS3Bucket.parameter.originId"></a>

- *Type:* string

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.CloudFrontToOrigins.isConstruct"></a>

```typescript
import { CloudFrontToOrigins } from 'must-cdk'

CloudFrontToOrigins.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.CloudFrontToOrigins.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.aRecords">aRecords</a></code> | <code>aws-cdk-lib.aws_route53.ARecord[]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distribution">distribution</a></code> | <code>aws-cdk-lib.aws_cloudfront.Distribution</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionDomainName">distributionDomainName</a></code> | <code>string</code> | Get the CloudFront distribution domain name. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.distributionUrl">distributionUrl</a></code> | <code>string</code> | Get the CloudFront distribution URL with protocol. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOriginIds">httpOriginIds</a></code> | <code>string[]</code> | Get all HTTP origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.httpOrigins">httpOrigins</a></code> | <code><a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>[]</code> | Get all HTTP origins as an array of objects with ID and origin. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3OriginIds">s3OriginIds</a></code> | <code>string[]</code> | Get all S3 bucket origin IDs. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.s3Origins">s3Origins</a></code> | <code><a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>[]</code> | Get all S3 buckets as an array of objects with ID and bucket. |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.customDomainUrl">customDomainUrl</a></code> | <code>string</code> | Get the custom domain URL (if configured). |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.domainNames">domainNames</a></code> | <code>string[]</code> | *No description.* |
| <code><a href="#must-cdk.CloudFrontToOrigins.property.logBucket">logBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.CloudFrontToOrigins.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `aRecords`<sup>Required</sup> <a name="aRecords" id="must-cdk.CloudFrontToOrigins.property.aRecords"></a>

```typescript
public readonly aRecords: ARecord[];
```

- *Type:* aws-cdk-lib.aws_route53.ARecord[]

---

##### `distribution`<sup>Required</sup> <a name="distribution" id="must-cdk.CloudFrontToOrigins.property.distribution"></a>

```typescript
public readonly distribution: Distribution;
```

- *Type:* aws-cdk-lib.aws_cloudfront.Distribution

---

##### `distributionDomainName`<sup>Required</sup> <a name="distributionDomainName" id="must-cdk.CloudFrontToOrigins.property.distributionDomainName"></a>

```typescript
public readonly distributionDomainName: string;
```

- *Type:* string

Get the CloudFront distribution domain name.

---

##### `distributionUrl`<sup>Required</sup> <a name="distributionUrl" id="must-cdk.CloudFrontToOrigins.property.distributionUrl"></a>

```typescript
public readonly distributionUrl: string;
```

- *Type:* string

Get the CloudFront distribution URL with protocol.

---

##### `httpOriginIds`<sup>Required</sup> <a name="httpOriginIds" id="must-cdk.CloudFrontToOrigins.property.httpOriginIds"></a>

```typescript
public readonly httpOriginIds: string[];
```

- *Type:* string[]

Get all HTTP origin IDs.

---

##### `httpOrigins`<sup>Required</sup> <a name="httpOrigins" id="must-cdk.CloudFrontToOrigins.property.httpOrigins"></a>

```typescript
public readonly httpOrigins: HttpOriginInfo[];
```

- *Type:* <a href="#must-cdk.HttpOriginInfo">HttpOriginInfo</a>[]

Get all HTTP origins as an array of objects with ID and origin.

---

##### `s3OriginIds`<sup>Required</sup> <a name="s3OriginIds" id="must-cdk.CloudFrontToOrigins.property.s3OriginIds"></a>

```typescript
public readonly s3OriginIds: string[];
```

- *Type:* string[]

Get all S3 bucket origin IDs.

---

##### `s3Origins`<sup>Required</sup> <a name="s3Origins" id="must-cdk.CloudFrontToOrigins.property.s3Origins"></a>

```typescript
public readonly s3Origins: S3OriginInfo[];
```

- *Type:* <a href="#must-cdk.S3OriginInfo">S3OriginInfo</a>[]

Get all S3 buckets as an array of objects with ID and bucket.

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.CloudFrontToOrigins.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

##### `customDomainUrl`<sup>Optional</sup> <a name="customDomainUrl" id="must-cdk.CloudFrontToOrigins.property.customDomainUrl"></a>

```typescript
public readonly customDomainUrl: string;
```

- *Type:* string

Get the custom domain URL (if configured).

---

##### `domainNames`<sup>Optional</sup> <a name="domainNames" id="must-cdk.CloudFrontToOrigins.property.domainNames"></a>

```typescript
public readonly domainNames: string[];
```

- *Type:* string[]

---

##### `logBucket`<sup>Optional</sup> <a name="logBucket" id="must-cdk.CloudFrontToOrigins.property.logBucket"></a>

```typescript
public readonly logBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---


### EcsCodeDeploy <a name="EcsCodeDeploy" id="must-cdk.EcsCodeDeploy"></a>

#### Initializers <a name="Initializers" id="must-cdk.EcsCodeDeploy.Initializer"></a>

```typescript
import { EcsCodeDeploy } from 'must-cdk'

new EcsCodeDeploy(scope: Construct, id: string, props: EcsCodeDeployProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.EcsCodeDeployProps">EcsCodeDeployProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.EcsCodeDeploy.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.EcsCodeDeploy.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.EcsCodeDeploy.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.EcsCodeDeployProps">EcsCodeDeployProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.EcsCodeDeploy.allListeners">allListeners</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.blueListener">blueListener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.greenListener">greenListener</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.loadBalancerDnsName">loadBalancerDnsName</a></code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.serviceArn">serviceArn</a></code> | *No description.* |

---

##### `toString` <a name="toString" id="must-cdk.EcsCodeDeploy.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `allListeners` <a name="allListeners" id="must-cdk.EcsCodeDeploy.allListeners"></a>

```typescript
public allListeners(): ApplicationListener[]
```

##### `blueListener` <a name="blueListener" id="must-cdk.EcsCodeDeploy.blueListener"></a>

```typescript
public blueListener(): ApplicationListener
```

##### `greenListener` <a name="greenListener" id="must-cdk.EcsCodeDeploy.greenListener"></a>

```typescript
public greenListener(): ApplicationListener
```

##### `loadBalancerDnsName` <a name="loadBalancerDnsName" id="must-cdk.EcsCodeDeploy.loadBalancerDnsName"></a>

```typescript
public loadBalancerDnsName(): string
```

##### `serviceArn` <a name="serviceArn" id="must-cdk.EcsCodeDeploy.serviceArn"></a>

```typescript
public serviceArn(): string
```

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.EcsCodeDeploy.isConstruct"></a>

```typescript
import { EcsCodeDeploy } from 'must-cdk'

EcsCodeDeploy.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.EcsCodeDeploy.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeploy.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.EcsCodeDeploy.property.blueTargetGroup">blueTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.codeDeployApp">codeDeployApp</a></code> | <code>aws-cdk-lib.aws_codedeploy.EcsApplication</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.greenTargetGroup">greenTargetGroup</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.loadBalancer">loadBalancer</a></code> | <code>aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.service">service</a></code> | <code>aws-cdk-lib.aws_ecs.FargateService</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskDef">taskDef</a></code> | <code>aws-cdk-lib.aws_ecs.TaskDefinition</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskExecutionRole">taskExecutionRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeploy.property.taskRole">taskRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.EcsCodeDeploy.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `blueTargetGroup`<sup>Required</sup> <a name="blueTargetGroup" id="must-cdk.EcsCodeDeploy.property.blueTargetGroup"></a>

```typescript
public readonly blueTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `codeDeployApp`<sup>Required</sup> <a name="codeDeployApp" id="must-cdk.EcsCodeDeploy.property.codeDeployApp"></a>

```typescript
public readonly codeDeployApp: EcsApplication;
```

- *Type:* aws-cdk-lib.aws_codedeploy.EcsApplication

---

##### `greenTargetGroup`<sup>Required</sup> <a name="greenTargetGroup" id="must-cdk.EcsCodeDeploy.property.greenTargetGroup"></a>

```typescript
public readonly greenTargetGroup: ApplicationTargetGroup;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationTargetGroup

---

##### `loadBalancer`<sup>Required</sup> <a name="loadBalancer" id="must-cdk.EcsCodeDeploy.property.loadBalancer"></a>

```typescript
public readonly loadBalancer: ApplicationLoadBalancer;
```

- *Type:* aws-cdk-lib.aws_elasticloadbalancingv2.ApplicationLoadBalancer

---

##### `service`<sup>Required</sup> <a name="service" id="must-cdk.EcsCodeDeploy.property.service"></a>

```typescript
public readonly service: FargateService;
```

- *Type:* aws-cdk-lib.aws_ecs.FargateService

---

##### `taskDef`<sup>Required</sup> <a name="taskDef" id="must-cdk.EcsCodeDeploy.property.taskDef"></a>

```typescript
public readonly taskDef: TaskDefinition;
```

- *Type:* aws-cdk-lib.aws_ecs.TaskDefinition

---

##### `taskExecutionRole`<sup>Required</sup> <a name="taskExecutionRole" id="must-cdk.EcsCodeDeploy.property.taskExecutionRole"></a>

```typescript
public readonly taskExecutionRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---

##### `taskRole`<sup>Required</sup> <a name="taskRole" id="must-cdk.EcsCodeDeploy.property.taskRole"></a>

```typescript
public readonly taskRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

---


### WebSocketApiGatewayToLambda <a name="WebSocketApiGatewayToLambda" id="must-cdk.WebSocketApiGatewayToLambda"></a>

#### Initializers <a name="Initializers" id="must-cdk.WebSocketApiGatewayToLambda.Initializer"></a>

```typescript
import { WebSocketApiGatewayToLambda } from 'must-cdk'

new WebSocketApiGatewayToLambda(scope: Construct, id: string, props: WebSocketApiGatewayToLambdaProps)
```

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope">scope</a></code> | <code>constructs.Construct</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.props">props</a></code> | <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps">WebSocketApiGatewayToLambdaProps</a></code> | *No description.* |

---

##### `scope`<sup>Required</sup> <a name="scope" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.scope"></a>

- *Type:* constructs.Construct

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.id"></a>

- *Type:* string

---

##### `props`<sup>Required</sup> <a name="props" id="must-cdk.WebSocketApiGatewayToLambda.Initializer.parameter.props"></a>

- *Type:* <a href="#must-cdk.WebSocketApiGatewayToLambdaProps">WebSocketApiGatewayToLambdaProps</a>

---

#### Methods <a name="Methods" id="Methods"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.toString">toString</a></code> | Returns a string representation of this construct. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.addRoute">addRoute</a></code> | Add a custom route after construction (for dynamic route addition). |

---

##### `toString` <a name="toString" id="must-cdk.WebSocketApiGatewayToLambda.toString"></a>

```typescript
public toString(): string
```

Returns a string representation of this construct.

##### `addRoute` <a name="addRoute" id="must-cdk.WebSocketApiGatewayToLambda.addRoute"></a>

```typescript
public addRoute(route: WebSocketRoute): WebSocketRoute
```

Add a custom route after construction (for dynamic route addition).

###### `route`<sup>Required</sup> <a name="route" id="must-cdk.WebSocketApiGatewayToLambda.addRoute.parameter.route"></a>

- *Type:* <a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>

---

#### Static Functions <a name="Static Functions" id="Static Functions"></a>

| **Name** | **Description** |
| --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.isConstruct">isConstruct</a></code> | Checks if `x` is a construct. |

---

##### ~~`isConstruct`~~ <a name="isConstruct" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct"></a>

```typescript
import { WebSocketApiGatewayToLambda } from 'must-cdk'

WebSocketApiGatewayToLambda.isConstruct(x: any)
```

Checks if `x` is a construct.

###### `x`<sup>Required</sup> <a name="x" id="must-cdk.WebSocketApiGatewayToLambda.isConstruct.parameter.x"></a>

- *Type:* any

Any object.

---

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.node">node</a></code> | <code>constructs.Node</code> | The tree node. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi">webSocketApi</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.WebSocketApi</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage">webSocketStage</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.WebSocketStage</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl">webSocketUrl</a></code> | <code>string</code> | Get the WebSocket API URL (useful for outputs). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup">apiGatewayLogGroup</a></code> | <code>aws-cdk-lib.aws_logs.LogGroup</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.aRecord">aRecord</a></code> | <code>aws-cdk-lib.aws_route53.ARecord</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.certificate">certificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambda.property.domain">domain</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.DomainName</code> | *No description.* |

---

##### `node`<sup>Required</sup> <a name="node" id="must-cdk.WebSocketApiGatewayToLambda.property.node"></a>

```typescript
public readonly node: Node;
```

- *Type:* constructs.Node

The tree node.

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.WebSocketApiGatewayToLambda.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `webSocketApi`<sup>Required</sup> <a name="webSocketApi" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketApi"></a>

```typescript
public readonly webSocketApi: WebSocketApi;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.WebSocketApi

---

##### `webSocketStage`<sup>Required</sup> <a name="webSocketStage" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketStage"></a>

```typescript
public readonly webSocketStage: WebSocketStage;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.WebSocketStage

---

##### `webSocketUrl`<sup>Required</sup> <a name="webSocketUrl" id="must-cdk.WebSocketApiGatewayToLambda.property.webSocketUrl"></a>

```typescript
public readonly webSocketUrl: string;
```

- *Type:* string

Get the WebSocket API URL (useful for outputs).

---

##### `apiGatewayLogGroup`<sup>Optional</sup> <a name="apiGatewayLogGroup" id="must-cdk.WebSocketApiGatewayToLambda.property.apiGatewayLogGroup"></a>

```typescript
public readonly apiGatewayLogGroup: LogGroup;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroup

---

##### `aRecord`<sup>Optional</sup> <a name="aRecord" id="must-cdk.WebSocketApiGatewayToLambda.property.aRecord"></a>

```typescript
public readonly aRecord: ARecord;
```

- *Type:* aws-cdk-lib.aws_route53.ARecord

---

##### `certificate`<sup>Optional</sup> <a name="certificate" id="must-cdk.WebSocketApiGatewayToLambda.property.certificate"></a>

```typescript
public readonly certificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

---

##### `domain`<sup>Optional</sup> <a name="domain" id="must-cdk.WebSocketApiGatewayToLambda.property.domain"></a>

```typescript
public readonly domain: DomainName;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.DomainName

---


## Structs <a name="Structs" id="Structs"></a>

### ApiGatewayToLambdaProps <a name="ApiGatewayToLambdaProps" id="must-cdk.ApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.ApiGatewayToLambdaProps.Initializer"></a>

```typescript
import { ApiGatewayToLambdaProps } from 'must-cdk'

const apiGatewayToLambdaProps: ApiGatewayToLambdaProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.apiName">apiName</a></code> | <code>string</code> | API configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | Primary Lambda function for the API. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan">createUsagePlan</a></code> | <code>boolean</code> | Whether to create a Usage Plan. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customDomainName">customDomainName</a></code> | <code>string</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.customRoutes">customRoutes</a></code> | <code><a href="#must-cdk.CustomRoute">CustomRoute</a>[]</code> | Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.enableLogging">enableLogging</a></code> | <code>boolean</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.existingCertificate">existingCertificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.hostedZone">hostedZone</a></code> | <code>aws-cdk-lib.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps">lambdaApiProps</a></code> | <code>aws-cdk-lib.aws_apigateway.LambdaRestApiProps</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.logGroupProps">logGroupProps</a></code> | <code>aws-cdk-lib.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.proxy">proxy</a></code> | <code>boolean</code> | *No description.* |
| <code><a href="#must-cdk.ApiGatewayToLambdaProps.property.restApiProps">restApiProps</a></code> | <code>aws-cdk-lib.aws_apigateway.RestApiProps</code> | *No description.* |

---

##### `apiName`<sup>Required</sup> <a name="apiName" id="must-cdk.ApiGatewayToLambdaProps.property.apiName"></a>

```typescript
public readonly apiName: string;
```

- *Type:* string

API configuration.

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

Primary Lambda function for the API.

---

##### `createUsagePlan`<sup>Optional</sup> <a name="createUsagePlan" id="must-cdk.ApiGatewayToLambdaProps.property.createUsagePlan"></a>

```typescript
public readonly createUsagePlan: boolean;
```

- *Type:* boolean

Whether to create a Usage Plan.

---

##### `customDomainName`<sup>Optional</sup> <a name="customDomainName" id="must-cdk.ApiGatewayToLambdaProps.property.customDomainName"></a>

```typescript
public readonly customDomainName: string;
```

- *Type:* string

Optional custom domain name for API Gateway.

---

##### `customRoutes`<sup>Optional</sup> <a name="customRoutes" id="must-cdk.ApiGatewayToLambdaProps.property.customRoutes"></a>

```typescript
public readonly customRoutes: CustomRoute[];
```

- *Type:* <a href="#must-cdk.CustomRoute">CustomRoute</a>[]

Custom routes for manual API setup (when proxy is false) If provided, will use RestApi instead of LambdaRestApi.

---

##### `enableLogging`<sup>Optional</sup> <a name="enableLogging" id="must-cdk.ApiGatewayToLambdaProps.property.enableLogging"></a>

```typescript
public readonly enableLogging: boolean;
```

- *Type:* boolean

Enable CloudWatch logging for API Gateway.

---

##### `existingCertificate`<sup>Optional</sup> <a name="existingCertificate" id="must-cdk.ApiGatewayToLambdaProps.property.existingCertificate"></a>

```typescript
public readonly existingCertificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hostedZone`<sup>Optional</sup> <a name="hostedZone" id="must-cdk.ApiGatewayToLambdaProps.property.hostedZone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `lambdaApiProps`<sup>Optional</sup> <a name="lambdaApiProps" id="must-cdk.ApiGatewayToLambdaProps.property.lambdaApiProps"></a>

```typescript
public readonly lambdaApiProps: LambdaRestApiProps;
```

- *Type:* aws-cdk-lib.aws_apigateway.LambdaRestApiProps

---

##### `logGroupProps`<sup>Optional</sup> <a name="logGroupProps" id="must-cdk.ApiGatewayToLambdaProps.property.logGroupProps"></a>

```typescript
public readonly logGroupProps: LogGroupProps;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `proxy`<sup>Optional</sup> <a name="proxy" id="must-cdk.ApiGatewayToLambdaProps.property.proxy"></a>

```typescript
public readonly proxy: boolean;
```

- *Type:* boolean

---

##### `restApiProps`<sup>Optional</sup> <a name="restApiProps" id="must-cdk.ApiGatewayToLambdaProps.property.restApiProps"></a>

```typescript
public readonly restApiProps: RestApiProps;
```

- *Type:* aws-cdk-lib.aws_apigateway.RestApiProps

---

### AutoScalingProps <a name="AutoScalingProps" id="must-cdk.AutoScalingProps"></a>

Configuration for ECS service auto-scaling.

#### Initializer <a name="Initializer" id="must-cdk.AutoScalingProps.Initializer"></a>

```typescript
import { AutoScalingProps } from 'must-cdk'

const autoScalingProps: AutoScalingProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.AutoScalingProps.property.maxCapacity">maxCapacity</a></code> | <code>number</code> | Maximum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.minCapacity">minCapacity</a></code> | <code>number</code> | Minimum number of tasks to run. |
| <code><a href="#must-cdk.AutoScalingProps.property.cpuScale">cpuScale</a></code> | <code>aws-cdk-lib.aws_ecs.CpuUtilizationScalingProps</code> | Scale task based on CPU utilization. |
| <code><a href="#must-cdk.AutoScalingProps.property.memoryScale">memoryScale</a></code> | <code>aws-cdk-lib.aws_ecs.MemoryUtilizationScalingProps</code> | Scale task based on memory utilization. |

---

##### `maxCapacity`<sup>Required</sup> <a name="maxCapacity" id="must-cdk.AutoScalingProps.property.maxCapacity"></a>

```typescript
public readonly maxCapacity: number;
```

- *Type:* number

Maximum number of tasks to run.

---

##### `minCapacity`<sup>Required</sup> <a name="minCapacity" id="must-cdk.AutoScalingProps.property.minCapacity"></a>

```typescript
public readonly minCapacity: number;
```

- *Type:* number

Minimum number of tasks to run.

---

##### `cpuScale`<sup>Optional</sup> <a name="cpuScale" id="must-cdk.AutoScalingProps.property.cpuScale"></a>

```typescript
public readonly cpuScale: CpuUtilizationScalingProps;
```

- *Type:* aws-cdk-lib.aws_ecs.CpuUtilizationScalingProps

Scale task based on CPU utilization.

---

##### `memoryScale`<sup>Optional</sup> <a name="memoryScale" id="must-cdk.AutoScalingProps.property.memoryScale"></a>

```typescript
public readonly memoryScale: MemoryUtilizationScalingProps;
```

- *Type:* aws-cdk-lib.aws_ecs.MemoryUtilizationScalingProps

Scale task based on memory utilization.

---

### CacheBehaviorConfig <a name="CacheBehaviorConfig" id="must-cdk.CacheBehaviorConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.CacheBehaviorConfig.Initializer"></a>

```typescript
import { CacheBehaviorConfig } from 'must-cdk'

const cacheBehaviorConfig: CacheBehaviorConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originId">originId</a></code> | <code>string</code> | Origin ID to route this pattern to. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.pathPattern">pathPattern</a></code> | <code>string</code> | Path pattern for this behavior (e.g., "/api/*", "*.jpg"). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.allowedMethods">allowedMethods</a></code> | <code>aws-cdk-lib.aws_cloudfront.AllowedMethods</code> | Allowed HTTP methods. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachedMethods">cachedMethods</a></code> | <code>aws-cdk-lib.aws_cloudfront.CachedMethods</code> | Methods to cache. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicy">cachePolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.ICachePolicy</code> | Cache policy (alternative to cachePolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.cachePolicyId">cachePolicyId</a></code> | <code>string</code> | Cache policy ID (use AWS managed policies). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.compress">compress</a></code> | <code>boolean</code> | Enable compression. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicy">originRequestPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.IOriginRequestPolicy</code> | Origin request policy (alternative to originRequestPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.originRequestPolicyId">originRequestPolicyId</a></code> | <code>string</code> | Origin request policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy">responseHeadersPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.IResponseHeadersPolicy</code> | Response headers policy (alternative to responseHeadersPolicyId). |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId">responseHeadersPolicyId</a></code> | <code>string</code> | Response headers policy ID. |
| <code><a href="#must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy">viewerProtocolPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.ViewerProtocolPolicy</code> | Viewer protocol policy. |

---

##### `originId`<sup>Required</sup> <a name="originId" id="must-cdk.CacheBehaviorConfig.property.originId"></a>

```typescript
public readonly originId: string;
```

- *Type:* string

Origin ID to route this pattern to.

---

##### `pathPattern`<sup>Required</sup> <a name="pathPattern" id="must-cdk.CacheBehaviorConfig.property.pathPattern"></a>

```typescript
public readonly pathPattern: string;
```

- *Type:* string

Path pattern for this behavior (e.g., "/api/*", "*.jpg").

---

##### `allowedMethods`<sup>Optional</sup> <a name="allowedMethods" id="must-cdk.CacheBehaviorConfig.property.allowedMethods"></a>

```typescript
public readonly allowedMethods: AllowedMethods;
```

- *Type:* aws-cdk-lib.aws_cloudfront.AllowedMethods
- *Default:* ALLOW_GET_HEAD for S3, ALLOW_ALL for HTTP

Allowed HTTP methods.

---

##### `cachedMethods`<sup>Optional</sup> <a name="cachedMethods" id="must-cdk.CacheBehaviorConfig.property.cachedMethods"></a>

```typescript
public readonly cachedMethods: CachedMethods;
```

- *Type:* aws-cdk-lib.aws_cloudfront.CachedMethods
- *Default:* CACHE_GET_HEAD_OPTIONS

Methods to cache.

---

##### `cachePolicy`<sup>Optional</sup> <a name="cachePolicy" id="must-cdk.CacheBehaviorConfig.property.cachePolicy"></a>

```typescript
public readonly cachePolicy: ICachePolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.ICachePolicy

Cache policy (alternative to cachePolicyId).

---

##### `cachePolicyId`<sup>Optional</sup> <a name="cachePolicyId" id="must-cdk.CacheBehaviorConfig.property.cachePolicyId"></a>

```typescript
public readonly cachePolicyId: string;
```

- *Type:* string

Cache policy ID (use AWS managed policies).

---

##### `compress`<sup>Optional</sup> <a name="compress" id="must-cdk.CacheBehaviorConfig.property.compress"></a>

```typescript
public readonly compress: boolean;
```

- *Type:* boolean
- *Default:* true

Enable compression.

---

##### `originRequestPolicy`<sup>Optional</sup> <a name="originRequestPolicy" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicy"></a>

```typescript
public readonly originRequestPolicy: IOriginRequestPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IOriginRequestPolicy

Origin request policy (alternative to originRequestPolicyId).

---

##### `originRequestPolicyId`<sup>Optional</sup> <a name="originRequestPolicyId" id="must-cdk.CacheBehaviorConfig.property.originRequestPolicyId"></a>

```typescript
public readonly originRequestPolicyId: string;
```

- *Type:* string

Origin request policy ID.

---

##### `responseHeadersPolicy`<sup>Optional</sup> <a name="responseHeadersPolicy" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicy"></a>

```typescript
public readonly responseHeadersPolicy: IResponseHeadersPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.IResponseHeadersPolicy

Response headers policy (alternative to responseHeadersPolicyId).

---

##### `responseHeadersPolicyId`<sup>Optional</sup> <a name="responseHeadersPolicyId" id="must-cdk.CacheBehaviorConfig.property.responseHeadersPolicyId"></a>

```typescript
public readonly responseHeadersPolicyId: string;
```

- *Type:* string

Response headers policy ID.

---

##### `viewerProtocolPolicy`<sup>Optional</sup> <a name="viewerProtocolPolicy" id="must-cdk.CacheBehaviorConfig.property.viewerProtocolPolicy"></a>

```typescript
public readonly viewerProtocolPolicy: ViewerProtocolPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.ViewerProtocolPolicy
- *Default:* REDIRECT_TO_HTTPS

Viewer protocol policy.

---

### CloudFrontToOriginsProps <a name="CloudFrontToOriginsProps" id="must-cdk.CloudFrontToOriginsProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.CloudFrontToOriginsProps.Initializer"></a>

```typescript
import { CloudFrontToOriginsProps } from 'must-cdk'

const cloudFrontToOriginsProps: CloudFrontToOriginsProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames">additionalDomainNames</a></code> | <code>string[]</code> | Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors">cacheBehaviors</a></code> | <code><a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>[]</code> | Cache behaviors for specific path patterns. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.certificateArn">certificateArn</a></code> | <code>string</code> | ARN of existing ACM certificate from us-east-1 region. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.comment">comment</a></code> | <code>string</code> | Comment for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.createRoute53Records">createRoute53Records</a></code> | <code>boolean</code> | Create Route53 records for all domain names. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.customDomainName">customDomainName</a></code> | <code>string</code> | Primary custom domain name for the CloudFront distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultOriginId">defaultOriginId</a></code> | <code>string</code> | ID of the origin to use as default behavior If not specified, will use the first S3 origin, then first HTTP origin. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.defaultRootObject">defaultRootObject</a></code> | <code>string</code> | Default root object for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.disableDefaultErrorPages">disableDefaultErrorPages</a></code> | <code>boolean</code> | Disable intelligent defaults for error pages. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.disableIntelligentDefaults">disableIntelligentDefaults</a></code> | <code>boolean</code> | Disable intelligent defaults completely When true, only user-provided configuration will be applied. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enabled">enabled</a></code> | <code>boolean</code> | Whether the distribution is enabled. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableIpv6">enableIpv6</a></code> | <code>boolean</code> | Enable IPv6 for the distribution. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.enableLogging">enableLogging</a></code> | <code>boolean</code> | Enable CloudFront access logging. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.env">env</a></code> | <code>any</code> | Environment configuration for the certificate stack Only used when auto-creating certificate (certificateArn not provided). |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.errorPages">errorPages</a></code> | <code>aws-cdk-lib.aws_cloudfront.ErrorResponse[]</code> | Custom error page configurations If not provided, intelligent defaults will be applied based on origin types. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.geoRestriction">geoRestriction</a></code> | <code>aws-cdk-lib.aws_cloudfront.GeoRestriction</code> | Geographic restriction configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.hostedZone">hostedZone</a></code> | <code>aws-cdk-lib.aws_route53.IHostedZone</code> | Route53 hosted zone for the custom domain Required for creating Route53 records. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpOrigins">httpOrigins</a></code> | <code><a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>[]</code> | HTTP origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.httpVersion">httpVersion</a></code> | <code>aws-cdk-lib.aws_cloudfront.HttpVersion</code> | HTTP version to support. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logBucket">logBucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies">logIncludeCookies</a></code> | <code>boolean</code> | Include cookies in access logs. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.logPrefix">logPrefix</a></code> | <code>string</code> | Prefix for log files. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.priceClass">priceClass</a></code> | <code>aws-cdk-lib.aws_cloudfront.PriceClass</code> | CloudFront distribution price class. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.s3Origins">s3Origins</a></code> | <code><a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>[]</code> | S3 origins configuration. |
| <code><a href="#must-cdk.CloudFrontToOriginsProps.property.webAclId">webAclId</a></code> | <code>string</code> | Web Application Firewall (WAF) web ACL ID. |

---

##### `additionalDomainNames`<sup>Optional</sup> <a name="additionalDomainNames" id="must-cdk.CloudFrontToOriginsProps.property.additionalDomainNames"></a>

```typescript
public readonly additionalDomainNames: string[];
```

- *Type:* string[]

Additional domain names (aliases) for the distribution Note: All domains must be covered by the same certificate.

---

##### `cacheBehaviors`<sup>Optional</sup> <a name="cacheBehaviors" id="must-cdk.CloudFrontToOriginsProps.property.cacheBehaviors"></a>

```typescript
public readonly cacheBehaviors: CacheBehaviorConfig[];
```

- *Type:* <a href="#must-cdk.CacheBehaviorConfig">CacheBehaviorConfig</a>[]

Cache behaviors for specific path patterns.

---

##### `certificateArn`<sup>Optional</sup> <a name="certificateArn" id="must-cdk.CloudFrontToOriginsProps.property.certificateArn"></a>

```typescript
public readonly certificateArn: string;
```

- *Type:* string

ARN of existing ACM certificate from us-east-1 region.

If provided, this certificate will be used for the CloudFront distribution.
If not provided and customDomainName is set, a new certificate will be
automatically created in us-east-1 region using the provided hostedZone.

---

##### `comment`<sup>Optional</sup> <a name="comment" id="must-cdk.CloudFrontToOriginsProps.property.comment"></a>

```typescript
public readonly comment: string;
```

- *Type:* string

Comment for the distribution.

---

##### `createRoute53Records`<sup>Optional</sup> <a name="createRoute53Records" id="must-cdk.CloudFrontToOriginsProps.property.createRoute53Records"></a>

```typescript
public readonly createRoute53Records: boolean;
```

- *Type:* boolean
- *Default:* true if hostedZone is provided

Create Route53 records for all domain names.

---

##### `customDomainName`<sup>Optional</sup> <a name="customDomainName" id="must-cdk.CloudFrontToOriginsProps.property.customDomainName"></a>

```typescript
public readonly customDomainName: string;
```

- *Type:* string

Primary custom domain name for the CloudFront distribution.

---

##### `defaultOriginId`<sup>Optional</sup> <a name="defaultOriginId" id="must-cdk.CloudFrontToOriginsProps.property.defaultOriginId"></a>

```typescript
public readonly defaultOriginId: string;
```

- *Type:* string

ID of the origin to use as default behavior If not specified, will use the first S3 origin, then first HTTP origin.

---

##### `defaultRootObject`<sup>Optional</sup> <a name="defaultRootObject" id="must-cdk.CloudFrontToOriginsProps.property.defaultRootObject"></a>

```typescript
public readonly defaultRootObject: string;
```

- *Type:* string
- *Default:* "index.html"

Default root object for the distribution.

---

##### `disableDefaultErrorPages`<sup>Optional</sup> <a name="disableDefaultErrorPages" id="must-cdk.CloudFrontToOriginsProps.property.disableDefaultErrorPages"></a>

```typescript
public readonly disableDefaultErrorPages: boolean;
```

- *Type:* boolean
- *Default:* false

Disable intelligent defaults for error pages.

---

##### `disableIntelligentDefaults`<sup>Optional</sup> <a name="disableIntelligentDefaults" id="must-cdk.CloudFrontToOriginsProps.property.disableIntelligentDefaults"></a>

```typescript
public readonly disableIntelligentDefaults: boolean;
```

- *Type:* boolean
- *Default:* false

Disable intelligent defaults completely When true, only user-provided configuration will be applied.

---

##### `enabled`<sup>Optional</sup> <a name="enabled" id="must-cdk.CloudFrontToOriginsProps.property.enabled"></a>

```typescript
public readonly enabled: boolean;
```

- *Type:* boolean
- *Default:* true

Whether the distribution is enabled.

---

##### `enableIpv6`<sup>Optional</sup> <a name="enableIpv6" id="must-cdk.CloudFrontToOriginsProps.property.enableIpv6"></a>

```typescript
public readonly enableIpv6: boolean;
```

- *Type:* boolean
- *Default:* false

Enable IPv6 for the distribution.

---

##### `enableLogging`<sup>Optional</sup> <a name="enableLogging" id="must-cdk.CloudFrontToOriginsProps.property.enableLogging"></a>

```typescript
public readonly enableLogging: boolean;
```

- *Type:* boolean
- *Default:* true

Enable CloudFront access logging.

---

##### `env`<sup>Optional</sup> <a name="env" id="must-cdk.CloudFrontToOriginsProps.property.env"></a>

```typescript
public readonly env: any;
```

- *Type:* any

Environment configuration for the certificate stack Only used when auto-creating certificate (certificateArn not provided).

---

##### `errorPages`<sup>Optional</sup> <a name="errorPages" id="must-cdk.CloudFrontToOriginsProps.property.errorPages"></a>

```typescript
public readonly errorPages: ErrorResponse[];
```

- *Type:* aws-cdk-lib.aws_cloudfront.ErrorResponse[]

Custom error page configurations If not provided, intelligent defaults will be applied based on origin types.

---

##### `geoRestriction`<sup>Optional</sup> <a name="geoRestriction" id="must-cdk.CloudFrontToOriginsProps.property.geoRestriction"></a>

```typescript
public readonly geoRestriction: GeoRestriction;
```

- *Type:* aws-cdk-lib.aws_cloudfront.GeoRestriction

Geographic restriction configuration.

---

##### `hostedZone`<sup>Optional</sup> <a name="hostedZone" id="must-cdk.CloudFrontToOriginsProps.property.hostedZone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.IHostedZone

Route53 hosted zone for the custom domain Required for creating Route53 records.

---

##### `httpOrigins`<sup>Optional</sup> <a name="httpOrigins" id="must-cdk.CloudFrontToOriginsProps.property.httpOrigins"></a>

```typescript
public readonly httpOrigins: HttpOriginConfig[];
```

- *Type:* <a href="#must-cdk.HttpOriginConfig">HttpOriginConfig</a>[]

HTTP origins configuration.

---

##### `httpVersion`<sup>Optional</sup> <a name="httpVersion" id="must-cdk.CloudFrontToOriginsProps.property.httpVersion"></a>

```typescript
public readonly httpVersion: HttpVersion;
```

- *Type:* aws-cdk-lib.aws_cloudfront.HttpVersion
- *Default:* HttpVersion.HTTP2

HTTP version to support.

---

##### `logBucket`<sup>Optional</sup> <a name="logBucket" id="must-cdk.CloudFrontToOriginsProps.property.logBucket"></a>

```typescript
public readonly logBucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

Existing S3 bucket for logs If not provided and logging is enabled, a new bucket will be created.

---

##### `logIncludeCookies`<sup>Optional</sup> <a name="logIncludeCookies" id="must-cdk.CloudFrontToOriginsProps.property.logIncludeCookies"></a>

```typescript
public readonly logIncludeCookies: boolean;
```

- *Type:* boolean
- *Default:* false

Include cookies in access logs.

---

##### `logPrefix`<sup>Optional</sup> <a name="logPrefix" id="must-cdk.CloudFrontToOriginsProps.property.logPrefix"></a>

```typescript
public readonly logPrefix: string;
```

- *Type:* string
- *Default:* "cloudfront-logs/"

Prefix for log files.

---

##### `priceClass`<sup>Optional</sup> <a name="priceClass" id="must-cdk.CloudFrontToOriginsProps.property.priceClass"></a>

```typescript
public readonly priceClass: PriceClass;
```

- *Type:* aws-cdk-lib.aws_cloudfront.PriceClass
- *Default:* PRICE_CLASS_100

CloudFront distribution price class.

---

##### `s3Origins`<sup>Optional</sup> <a name="s3Origins" id="must-cdk.CloudFrontToOriginsProps.property.s3Origins"></a>

```typescript
public readonly s3Origins: S3OriginConfig[];
```

- *Type:* <a href="#must-cdk.S3OriginConfig">S3OriginConfig</a>[]

S3 origins configuration.

---

##### `webAclId`<sup>Optional</sup> <a name="webAclId" id="must-cdk.CloudFrontToOriginsProps.property.webAclId"></a>

```typescript
public readonly webAclId: string;
```

- *Type:* string

Web Application Firewall (WAF) web ACL ID.

---

### ContainerProps <a name="ContainerProps" id="must-cdk.ContainerProps"></a>

Configuration for the ECS Fargate task definition and container.

#### Initializer <a name="Initializer" id="must-cdk.ContainerProps.Initializer"></a>

```typescript
import { ContainerProps } from 'must-cdk'

const containerProps: ContainerProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.ContainerProps.property.containerPort">containerPort</a></code> | <code>number</code> | The port number the container listens on. |
| <code><a href="#must-cdk.ContainerProps.property.image">image</a></code> | <code>aws-cdk-lib.aws_ecs.ContainerImage</code> | Container image to deploy. |
| <code><a href="#must-cdk.ContainerProps.property.healthCheck">healthCheck</a></code> | <code>aws-cdk-lib.aws_ecs.HealthCheck</code> | Optional container health check configuration. |
| <code><a href="#must-cdk.ContainerProps.property.memoryLimit">memoryLimit</a></code> | <code>number</code> | Hard memory limit in MiB for the task (default: 2048). |
| <code><a href="#must-cdk.ContainerProps.property.memoryReservation">memoryReservation</a></code> | <code>number</code> | Soft memory reservation in MiB for the container (default: 1024). |

---

##### `containerPort`<sup>Required</sup> <a name="containerPort" id="must-cdk.ContainerProps.property.containerPort"></a>

```typescript
public readonly containerPort: number;
```

- *Type:* number

The port number the container listens on.

---

##### `image`<sup>Required</sup> <a name="image" id="must-cdk.ContainerProps.property.image"></a>

```typescript
public readonly image: ContainerImage;
```

- *Type:* aws-cdk-lib.aws_ecs.ContainerImage

Container image to deploy.

---

##### `healthCheck`<sup>Optional</sup> <a name="healthCheck" id="must-cdk.ContainerProps.property.healthCheck"></a>

```typescript
public readonly healthCheck: HealthCheck;
```

- *Type:* aws-cdk-lib.aws_ecs.HealthCheck

Optional container health check configuration.

---

##### `memoryLimit`<sup>Optional</sup> <a name="memoryLimit" id="must-cdk.ContainerProps.property.memoryLimit"></a>

```typescript
public readonly memoryLimit: number;
```

- *Type:* number

Hard memory limit in MiB for the task (default: 2048).

---

##### `memoryReservation`<sup>Optional</sup> <a name="memoryReservation" id="must-cdk.ContainerProps.property.memoryReservation"></a>

```typescript
public readonly memoryReservation: number;
```

- *Type:* number

Soft memory reservation in MiB for the container (default: 1024).

---

### CustomRoute <a name="CustomRoute" id="must-cdk.CustomRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.CustomRoute.Initializer"></a>

```typescript
import { CustomRoute } from 'must-cdk'

const customRoute: CustomRoute = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.CustomRoute.property.handler">handler</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.method">method</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.path">path</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.CustomRoute.property.methodOptions">methodOptions</a></code> | <code>aws-cdk-lib.aws_apigateway.MethodOptions</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.CustomRoute.property.handler"></a>

```typescript
public readonly handler: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `method`<sup>Required</sup> <a name="method" id="must-cdk.CustomRoute.property.method"></a>

```typescript
public readonly method: string;
```

- *Type:* string

---

##### `path`<sup>Required</sup> <a name="path" id="must-cdk.CustomRoute.property.path"></a>

```typescript
public readonly path: string;
```

- *Type:* string

---

##### `methodOptions`<sup>Optional</sup> <a name="methodOptions" id="must-cdk.CustomRoute.property.methodOptions"></a>

```typescript
public readonly methodOptions: MethodOptions;
```

- *Type:* aws-cdk-lib.aws_apigateway.MethodOptions

---

### EcsCodeDeployProps <a name="EcsCodeDeployProps" id="must-cdk.EcsCodeDeployProps"></a>

Properties for the EcsCodeDeploy construct.

#### Initializer <a name="Initializer" id="must-cdk.EcsCodeDeployProps.Initializer"></a>

```typescript
import { EcsCodeDeployProps } from 'must-cdk'

const ecsCodeDeployProps: EcsCodeDeployProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.certificates">certificates</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate[]</code> | Optional ACM certificates for HTTPS termination. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.cluster">cluster</a></code> | <code>aws-cdk-lib.aws_ecs.ICluster</code> | ECS Cluster where the service will run. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.containers">containers</a></code> | <code><a href="#must-cdk.ContainerProps">ContainerProps</a>[]</code> | Configuration related to the task definition and container. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.securityGroups">securityGroups</a></code> | <code>aws-cdk-lib.aws_ec2.ISecurityGroup[]</code> | Security group config. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.serviceName">serviceName</a></code> | <code>string</code> | Base name used for resources like log groups, roles, services, etc. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.subnets">subnets</a></code> | <code>aws-cdk-lib.aws_ec2.SubnetSelection</code> | Select which subnets the Service and ALB will placed on. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.vpc">vpc</a></code> | <code>aws-cdk-lib.aws_ec2.IVpc</code> | VPC in which to deploy ECS and ALB resources. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.albTargetPort">albTargetPort</a></code> | <code>number</code> | The ALB target port. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.autoScaling">autoScaling</a></code> | <code><a href="#must-cdk.AutoScalingProps">AutoScalingProps</a></code> | Optional auto-scaling configuration. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.enablePublicLoadBalancer">enablePublicLoadBalancer</a></code> | <code>boolean</code> | Whether the load balancer should be internet-facing (default: false). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.memoryLimit">memoryLimit</a></code> | <code>number</code> | *No description.* |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskCPU">taskCPU</a></code> | <code>number</code> | CPU units for the task (default: 1024). |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskExecRole">taskExecRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | Task execution role for the ECS task. |
| <code><a href="#must-cdk.EcsCodeDeployProps.property.taskRole">taskRole</a></code> | <code>aws-cdk-lib.aws_iam.IRole</code> | Task role for the ECS task. |

---

##### `certificates`<sup>Required</sup> <a name="certificates" id="must-cdk.EcsCodeDeployProps.property.certificates"></a>

```typescript
public readonly certificates: ICertificate[];
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate[]

Optional ACM certificates for HTTPS termination.

---

##### `cluster`<sup>Required</sup> <a name="cluster" id="must-cdk.EcsCodeDeployProps.property.cluster"></a>

```typescript
public readonly cluster: ICluster;
```

- *Type:* aws-cdk-lib.aws_ecs.ICluster

ECS Cluster where the service will run.

---

##### `containers`<sup>Required</sup> <a name="containers" id="must-cdk.EcsCodeDeployProps.property.containers"></a>

```typescript
public readonly containers: ContainerProps[];
```

- *Type:* <a href="#must-cdk.ContainerProps">ContainerProps</a>[]

Configuration related to the task definition and container.

---

##### `securityGroups`<sup>Required</sup> <a name="securityGroups" id="must-cdk.EcsCodeDeployProps.property.securityGroups"></a>

```typescript
public readonly securityGroups: ISecurityGroup[];
```

- *Type:* aws-cdk-lib.aws_ec2.ISecurityGroup[]

Security group config.

---

##### `serviceName`<sup>Required</sup> <a name="serviceName" id="must-cdk.EcsCodeDeployProps.property.serviceName"></a>

```typescript
public readonly serviceName: string;
```

- *Type:* string

Base name used for resources like log groups, roles, services, etc.

---

##### `subnets`<sup>Required</sup> <a name="subnets" id="must-cdk.EcsCodeDeployProps.property.subnets"></a>

```typescript
public readonly subnets: SubnetSelection;
```

- *Type:* aws-cdk-lib.aws_ec2.SubnetSelection

Select which subnets the Service and ALB will placed on.

---

##### `vpc`<sup>Required</sup> <a name="vpc" id="must-cdk.EcsCodeDeployProps.property.vpc"></a>

```typescript
public readonly vpc: IVpc;
```

- *Type:* aws-cdk-lib.aws_ec2.IVpc

VPC in which to deploy ECS and ALB resources.

---

##### `albTargetPort`<sup>Optional</sup> <a name="albTargetPort" id="must-cdk.EcsCodeDeployProps.property.albTargetPort"></a>

```typescript
public readonly albTargetPort: number;
```

- *Type:* number

The ALB target port.

---

##### `autoScaling`<sup>Optional</sup> <a name="autoScaling" id="must-cdk.EcsCodeDeployProps.property.autoScaling"></a>

```typescript
public readonly autoScaling: AutoScalingProps;
```

- *Type:* <a href="#must-cdk.AutoScalingProps">AutoScalingProps</a>

Optional auto-scaling configuration.

---

##### `enablePublicLoadBalancer`<sup>Optional</sup> <a name="enablePublicLoadBalancer" id="must-cdk.EcsCodeDeployProps.property.enablePublicLoadBalancer"></a>

```typescript
public readonly enablePublicLoadBalancer: boolean;
```

- *Type:* boolean

Whether the load balancer should be internet-facing (default: false).

---

##### `memoryLimit`<sup>Optional</sup> <a name="memoryLimit" id="must-cdk.EcsCodeDeployProps.property.memoryLimit"></a>

```typescript
public readonly memoryLimit: number;
```

- *Type:* number

---

##### `taskCPU`<sup>Optional</sup> <a name="taskCPU" id="must-cdk.EcsCodeDeployProps.property.taskCPU"></a>

```typescript
public readonly taskCPU: number;
```

- *Type:* number

CPU units for the task (default: 1024).

---

##### `taskExecRole`<sup>Optional</sup> <a name="taskExecRole" id="must-cdk.EcsCodeDeployProps.property.taskExecRole"></a>

```typescript
public readonly taskExecRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

Task execution role for the ECS task.

---

##### `taskRole`<sup>Optional</sup> <a name="taskRole" id="must-cdk.EcsCodeDeployProps.property.taskRole"></a>

```typescript
public readonly taskRole: IRole;
```

- *Type:* aws-cdk-lib.aws_iam.IRole

Task role for the ECS task.

---

### HttpOriginConfig <a name="HttpOriginConfig" id="must-cdk.HttpOriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginConfig.Initializer"></a>

```typescript
import { HttpOriginConfig } from 'must-cdk'

const httpOriginConfig: HttpOriginConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginConfig.property.domainName">domainName</a></code> | <code>string</code> | Domain name of the HTTP origin (required). |
| <code><a href="#must-cdk.HttpOriginConfig.property.id">id</a></code> | <code>string</code> | Unique identifier for this HTTP origin. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpOriginProps">httpOriginProps</a></code> | <code>aws-cdk-lib.aws_cloudfront_origins.HttpOriginProps</code> | Additional HTTP origin properties. |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpPort">httpPort</a></code> | <code>number</code> | HTTP port (for HTTP protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.httpsPort">httpsPort</a></code> | <code>number</code> | HTTPS port (for HTTPS protocol). |
| <code><a href="#must-cdk.HttpOriginConfig.property.originPath">originPath</a></code> | <code>string</code> | Origin path for HTTP requests (e.g., "/api/v1"). |
| <code><a href="#must-cdk.HttpOriginConfig.property.protocolPolicy">protocolPolicy</a></code> | <code>aws-cdk-lib.aws_cloudfront.OriginProtocolPolicy</code> | Protocol policy for the origin. |

---

##### `domainName`<sup>Required</sup> <a name="domainName" id="must-cdk.HttpOriginConfig.property.domainName"></a>

```typescript
public readonly domainName: string;
```

- *Type:* string

Domain name of the HTTP origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginConfig.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Unique identifier for this HTTP origin.

---

##### `httpOriginProps`<sup>Optional</sup> <a name="httpOriginProps" id="must-cdk.HttpOriginConfig.property.httpOriginProps"></a>

```typescript
public readonly httpOriginProps: HttpOriginProps;
```

- *Type:* aws-cdk-lib.aws_cloudfront_origins.HttpOriginProps

Additional HTTP origin properties.

---

##### `httpPort`<sup>Optional</sup> <a name="httpPort" id="must-cdk.HttpOriginConfig.property.httpPort"></a>

```typescript
public readonly httpPort: number;
```

- *Type:* number
- *Default:* 80

HTTP port (for HTTP protocol).

---

##### `httpsPort`<sup>Optional</sup> <a name="httpsPort" id="must-cdk.HttpOriginConfig.property.httpsPort"></a>

```typescript
public readonly httpsPort: number;
```

- *Type:* number
- *Default:* 443

HTTPS port (for HTTPS protocol).

---

##### `originPath`<sup>Optional</sup> <a name="originPath" id="must-cdk.HttpOriginConfig.property.originPath"></a>

```typescript
public readonly originPath: string;
```

- *Type:* string

Origin path for HTTP requests (e.g., "/api/v1").

---

##### `protocolPolicy`<sup>Optional</sup> <a name="protocolPolicy" id="must-cdk.HttpOriginConfig.property.protocolPolicy"></a>

```typescript
public readonly protocolPolicy: OriginProtocolPolicy;
```

- *Type:* aws-cdk-lib.aws_cloudfront.OriginProtocolPolicy
- *Default:* HTTPS_ONLY

Protocol policy for the origin.

---

### HttpOriginInfo <a name="HttpOriginInfo" id="must-cdk.HttpOriginInfo"></a>

HTTP origin information.

#### Initializer <a name="Initializer" id="must-cdk.HttpOriginInfo.Initializer"></a>

```typescript
import { HttpOriginInfo } from 'must-cdk'

const httpOriginInfo: HttpOriginInfo = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.HttpOriginInfo.property.id">id</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.HttpOriginInfo.property.origin">origin</a></code> | <code>aws-cdk-lib.aws_cloudfront_origins.HttpOrigin</code> | *No description.* |

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.HttpOriginInfo.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

##### `origin`<sup>Required</sup> <a name="origin" id="must-cdk.HttpOriginInfo.property.origin"></a>

```typescript
public readonly origin: HttpOrigin;
```

- *Type:* aws-cdk-lib.aws_cloudfront_origins.HttpOrigin

---

### S3OriginConfig <a name="S3OriginConfig" id="must-cdk.S3OriginConfig"></a>

#### Initializer <a name="Initializer" id="must-cdk.S3OriginConfig.Initializer"></a>

```typescript
import { S3OriginConfig } from 'must-cdk'

const s3OriginConfig: S3OriginConfig = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginConfig.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | Existing S3 bucket to use as origin (required). |
| <code><a href="#must-cdk.S3OriginConfig.property.id">id</a></code> | <code>string</code> | Unique identifier for this S3 origin. |
| <code><a href="#must-cdk.S3OriginConfig.property.originAccessIdentity">originAccessIdentity</a></code> | <code>aws-cdk-lib.aws_cloudfront.OriginAccessIdentity</code> | Existing Origin Access Identity (only used if useLegacyOAI is true). |
| <code><a href="#must-cdk.S3OriginConfig.property.originPath">originPath</a></code> | <code>string</code> | Origin path for S3 requests (e.g., "/static"). |
| <code><a href="#must-cdk.S3OriginConfig.property.s3OriginProps">s3OriginProps</a></code> | <code>aws-cdk-lib.aws_cloudfront_origins.S3OriginProps</code> | Additional S3 origin properties. |
| <code><a href="#must-cdk.S3OriginConfig.property.useLegacyOAI">useLegacyOAI</a></code> | <code>boolean</code> | Use legacy Origin Access Identity instead of modern Origin Access Control. |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginConfig.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

Existing S3 bucket to use as origin (required).

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginConfig.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

Unique identifier for this S3 origin.

---

##### `originAccessIdentity`<sup>Optional</sup> <a name="originAccessIdentity" id="must-cdk.S3OriginConfig.property.originAccessIdentity"></a>

```typescript
public readonly originAccessIdentity: OriginAccessIdentity;
```

- *Type:* aws-cdk-lib.aws_cloudfront.OriginAccessIdentity

Existing Origin Access Identity (only used if useLegacyOAI is true).

---

##### `originPath`<sup>Optional</sup> <a name="originPath" id="must-cdk.S3OriginConfig.property.originPath"></a>

```typescript
public readonly originPath: string;
```

- *Type:* string

Origin path for S3 requests (e.g., "/static").

---

##### `s3OriginProps`<sup>Optional</sup> <a name="s3OriginProps" id="must-cdk.S3OriginConfig.property.s3OriginProps"></a>

```typescript
public readonly s3OriginProps: S3OriginProps;
```

- *Type:* aws-cdk-lib.aws_cloudfront_origins.S3OriginProps

Additional S3 origin properties.

---

##### `useLegacyOAI`<sup>Optional</sup> <a name="useLegacyOAI" id="must-cdk.S3OriginConfig.property.useLegacyOAI"></a>

```typescript
public readonly useLegacyOAI: boolean;
```

- *Type:* boolean
- *Default:* false - uses OAC for better security

Use legacy Origin Access Identity instead of modern Origin Access Control.

---

### S3OriginInfo <a name="S3OriginInfo" id="must-cdk.S3OriginInfo"></a>

S3 origin information.

#### Initializer <a name="Initializer" id="must-cdk.S3OriginInfo.Initializer"></a>

```typescript
import { S3OriginInfo } from 'must-cdk'

const s3OriginInfo: S3OriginInfo = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.S3OriginInfo.property.bucket">bucket</a></code> | <code>aws-cdk-lib.aws_s3.IBucket</code> | *No description.* |
| <code><a href="#must-cdk.S3OriginInfo.property.id">id</a></code> | <code>string</code> | *No description.* |

---

##### `bucket`<sup>Required</sup> <a name="bucket" id="must-cdk.S3OriginInfo.property.bucket"></a>

```typescript
public readonly bucket: IBucket;
```

- *Type:* aws-cdk-lib.aws_s3.IBucket

---

##### `id`<sup>Required</sup> <a name="id" id="must-cdk.S3OriginInfo.property.id"></a>

```typescript
public readonly id: string;
```

- *Type:* string

---

### WebSocketApiGatewayToLambdaProps <a name="WebSocketApiGatewayToLambdaProps" id="must-cdk.WebSocketApiGatewayToLambdaProps"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketApiGatewayToLambdaProps.Initializer"></a>

```typescript
import { WebSocketApiGatewayToLambdaProps } from 'must-cdk'

const webSocketApiGatewayToLambdaProps: WebSocketApiGatewayToLambdaProps = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName">apiName</a></code> | <code>string</code> | WebSocket API configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction">lambdaFunction</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | Primary Lambda function for the API (usually handles $default route). |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps">apiProps</a></code> | <code>aws-cdk-lib.aws_apigatewayv2.WebSocketApiProps</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName">customDomainName</a></code> | <code>string</code> | Optional custom domain name for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes">customRoutes</a></code> | <code><a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>[]</code> | Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging">enableLogging</a></code> | <code>boolean</code> | Enable CloudWatch logging for API Gateway. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate">existingCertificate</a></code> | <code>aws-cdk-lib.aws_certificatemanager.ICertificate</code> | Optional ACM certificate to use instead of creating a new one. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone">hostedZone</a></code> | <code>aws-cdk-lib.aws_route53.IHostedZone</code> | Optional Route53 hosted zone for custom domain. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps">logGroupProps</a></code> | <code>aws-cdk-lib.aws_logs.LogGroupProps</code> | CloudWatch Logs configuration. |
| <code><a href="#must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName">stageName</a></code> | <code>string</code> | Stage name for the WebSocket API. |

---

##### `apiName`<sup>Required</sup> <a name="apiName" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiName"></a>

```typescript
public readonly apiName: string;
```

- *Type:* string

WebSocket API configuration.

---

##### `lambdaFunction`<sup>Required</sup> <a name="lambdaFunction" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.lambdaFunction"></a>

```typescript
public readonly lambdaFunction: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

Primary Lambda function for the API (usually handles $default route).

---

##### `apiProps`<sup>Optional</sup> <a name="apiProps" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.apiProps"></a>

```typescript
public readonly apiProps: WebSocketApiProps;
```

- *Type:* aws-cdk-lib.aws_apigatewayv2.WebSocketApiProps

---

##### `customDomainName`<sup>Optional</sup> <a name="customDomainName" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customDomainName"></a>

```typescript
public readonly customDomainName: string;
```

- *Type:* string

Optional custom domain name for API Gateway.

---

##### `customRoutes`<sup>Optional</sup> <a name="customRoutes" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.customRoutes"></a>

```typescript
public readonly customRoutes: WebSocketRoute[];
```

- *Type:* <a href="#must-cdk.WebSocketRoute">WebSocketRoute</a>[]

Custom routes for WebSocket API Common routes: $connect, $disconnect, $default, or custom route keys.

---

##### `enableLogging`<sup>Optional</sup> <a name="enableLogging" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.enableLogging"></a>

```typescript
public readonly enableLogging: boolean;
```

- *Type:* boolean

Enable CloudWatch logging for API Gateway.

---

##### `existingCertificate`<sup>Optional</sup> <a name="existingCertificate" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.existingCertificate"></a>

```typescript
public readonly existingCertificate: ICertificate;
```

- *Type:* aws-cdk-lib.aws_certificatemanager.ICertificate

Optional ACM certificate to use instead of creating a new one.

---

##### `hostedZone`<sup>Optional</sup> <a name="hostedZone" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.hostedZone"></a>

```typescript
public readonly hostedZone: IHostedZone;
```

- *Type:* aws-cdk-lib.aws_route53.IHostedZone

Optional Route53 hosted zone for custom domain.

---

##### `logGroupProps`<sup>Optional</sup> <a name="logGroupProps" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.logGroupProps"></a>

```typescript
public readonly logGroupProps: LogGroupProps;
```

- *Type:* aws-cdk-lib.aws_logs.LogGroupProps

CloudWatch Logs configuration.

---

##### `stageName`<sup>Optional</sup> <a name="stageName" id="must-cdk.WebSocketApiGatewayToLambdaProps.property.stageName"></a>

```typescript
public readonly stageName: string;
```

- *Type:* string
- *Default:* 'dev'

Stage name for the WebSocket API.

---

### WebSocketRoute <a name="WebSocketRoute" id="must-cdk.WebSocketRoute"></a>

#### Initializer <a name="Initializer" id="must-cdk.WebSocketRoute.Initializer"></a>

```typescript
import { WebSocketRoute } from 'must-cdk'

const webSocketRoute: WebSocketRoute = { ... }
```

#### Properties <a name="Properties" id="Properties"></a>

| **Name** | **Type** | **Description** |
| --- | --- | --- |
| <code><a href="#must-cdk.WebSocketRoute.property.handler">handler</a></code> | <code>aws-cdk-lib.aws_lambda.IFunction</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeKey">routeKey</a></code> | <code>string</code> | *No description.* |
| <code><a href="#must-cdk.WebSocketRoute.property.routeResponseSelectionExpression">routeResponseSelectionExpression</a></code> | <code>string</code> | *No description.* |

---

##### `handler`<sup>Required</sup> <a name="handler" id="must-cdk.WebSocketRoute.property.handler"></a>

```typescript
public readonly handler: IFunction;
```

- *Type:* aws-cdk-lib.aws_lambda.IFunction

---

##### `routeKey`<sup>Required</sup> <a name="routeKey" id="must-cdk.WebSocketRoute.property.routeKey"></a>

```typescript
public readonly routeKey: string;
```

- *Type:* string

---

##### `routeResponseSelectionExpression`<sup>Optional</sup> <a name="routeResponseSelectionExpression" id="must-cdk.WebSocketRoute.property.routeResponseSelectionExpression"></a>

```typescript
public readonly routeResponseSelectionExpression: string;
```

- *Type:* string

---



