# Generated by Django 2.2.14 on 2020-08-03 17:24

from django.db import migrations
from django.db.models import Q


def copy_primary_secondary_colors(apps, schema_editor):
    EnterpriseCustomerBrandingConfiguration = apps.get_model('enterprise', 'EnterpriseCustomerBrandingConfiguration')
    for branding_config in EnterpriseCustomerBrandingConfiguration.objects.filter(
        Q(banner_background_color__isnull=False) | Q(banner_border_color__isnull=False)
    ):
        branding_config.primary_color = branding_config.banner_background_color
        branding_config.secondary_color = branding_config.banner_border_color
        branding_config.save()


def clear_primary_secondary_colors(apps, schema_editor):
    EnterpriseCustomerBrandingConfiguration = apps.get_model('enterprise', 'EnterpriseCustomerBrandingConfiguration')
    for branding_config in EnterpriseCustomerBrandingConfiguration.objects.filter(
        Q(primary_color__isnull=False) | Q(secondary_color__isnull=False)
    ):
        branding_config.primary_color = None
        branding_config.secondary_color = None
        branding_config.save()



class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0105_add_branding_config_color_fields'),
    ]

    operations = [
        migrations.RunPython(copy_primary_secondary_colors, clear_primary_secondary_colors)
    ]
