# Generated by Django 2.2.19 on 2021-06-14 15:02

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0134_enterprisecustomerreportingconfiguration_enable_compression'),
    ]

    operations = [
        migrations.CreateModel(
            name='AdminNotificationFilter',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('filter', models.CharField(help_text='Filters to show banner notifications conditionally.', max_length=50, unique=True)),
            ],
            options={
                'verbose_name': 'Admin Notification Filter',
                'verbose_name_plural': 'Admin Notification Filters',
                'ordering': ('filter',),
            },
        ),
        migrations.CreateModel(
            name='AdminNotification',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('text', models.CharField(help_text='Notification banner which will appear to enterprise admin on admin portal.', max_length=255)),
                ('is_active', models.BooleanField(default=True)),
                ('start_date', models.DateField(default=django.utils.timezone.now)),
                ('expiration_date', models.DateField(default=django.utils.timezone.now)),
                ('admin_notification_filter', models.ManyToManyField(blank=True, related_name='notification_filter', to='enterprise.AdminNotificationFilter')),
            ],
            options={
                'verbose_name': 'Enterprise Customer Admin Notification',
                'verbose_name_plural': 'Enterprise Customer Admin Notifications',
                'ordering': ('start_date',),
            },
        ),
        migrations.CreateModel(
            name='AdminNotificationRead',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_read', models.BooleanField(default=False)),
                ('admin_notification', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='enterprise.AdminNotification')),
                ('enterprise_customer_user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='enterprise.EnterpriseCustomerUser')),
            ],
            options={
                'verbose_name': 'Admin Notification Read',
                'verbose_name_plural': 'Admin Notifications Read',
                'ordering': ('is_read',),
                'unique_together': {('enterprise_customer_user', 'admin_notification')},
            },
        ),
    ]
