# Generated by Django 2.2.24 on 2021-11-19 22:25

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import simple_history.models
import uuid


class Migration(migrations.Migration):

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('enterprise', '0145_auto_20211013_1018'),
    ]

    operations = [
        migrations.CreateModel(
            name='HistoricalEnterpriseCustomerInviteKey',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('uuid', models.UUIDField(db_index=True, default=uuid.uuid4, editable=False)),
                ('usage_limit', models.PositiveIntegerField(default=10000, help_text='The number of times this key can be used to link a learner.')),
                ('expiration_date', models.DateTimeField(blank=True, help_text='The key will no longer be valid after this date.', null=True)),
                ('history_id', models.AutoField(primary_key=True, serialize=False)),
                ('history_date', models.DateTimeField()),
                ('history_change_reason', models.CharField(max_length=100, null=True)),
                ('history_type', models.CharField(choices=[('+', 'Created'), ('~', 'Changed'), ('-', 'Deleted')], max_length=1)),
                ('enterprise_customer', models.ForeignKey(blank=True, db_constraint=False, help_text='The enterprise that can be linked using this key.', null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomer')),
                ('history_user', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='+', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'verbose_name': 'historical enterprise customer invite key',
                'ordering': ('-history_date', '-history_id'),
                'get_latest_by': 'history_date',
            },
            bases=(simple_history.models.HistoricalChanges, models.Model),
        ),
        migrations.CreateModel(
            name='EnterpriseCustomerInviteKey',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('usage_limit', models.PositiveIntegerField(default=10000, help_text='The number of times this key can be used to link a learner.')),
                ('expiration_date', models.DateTimeField(blank=True, help_text='The key will no longer be valid after this date.', null=True)),
                ('enterprise_customer', models.ForeignKey(help_text='The enterprise that can be linked using this key.', on_delete=django.db.models.deletion.CASCADE, related_name='invite_keys', to='enterprise.EnterpriseCustomer')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='enterprisecustomeruser',
            name='invite_key',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='linked_enterprise_customer_users', to='enterprise.EnterpriseCustomerInviteKey'),
        ),
        migrations.AddField(
            model_name='historicalenterprisecustomeruser',
            name='invite_key',
            field=models.ForeignKey(blank=True, db_constraint=False, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.EnterpriseCustomerInviteKey'),
        ),
    ]
