# Generated by Django 3.2.12 on 2022-07-22 12:54

from django.db import migrations, models


def move_progress_v2_to_v3(apps, schema_editor):
    """
    Moves all the 'progress' and 'progress_v2' data types in config to 'progress_v3'
    """
    ReportingConfig = apps.get_model('enterprise', 'EnterpriseCustomerReportingConfiguration')
    ReportingConfig.objects.filter(data_type__in=['progress_v2', 'progress']).update(data_type='progress_v3')

class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0160_add_enable_portal_learner_credit_management_screen'),
    ]

    operations = [
        migrations.RunPython(move_progress_v2_to_v3, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='enterprisecustomerreportingconfiguration',
            name='data_type',
            field=models.CharField(choices=[('progress_v3', 'progress_v3'), ('catalog', 'catalog'), ('engagement', 'engagement'), ('grade', 'grade'), ('completion', 'completion'), ('course_structure', 'course_structure')], default='progress_v3', help_text='The type of data this report should contain.', max_length=20, verbose_name='Data Type'),
        ),
    ]
