# Generated by Django 3.2.17 on 2023-02-21 18:35

from django.db import migrations, models
import uuid


def create_license_enrollment_uuid(apps, schema_editor):
    licensed_enrollments = apps.get_model('enterprise', 'LicensedEnterpriseCourseEnrollment')
    for licensed_enrollment in licensed_enrollments.objects.all():
        licensed_enrollment.uuid = uuid.uuid4()
        licensed_enrollment.save()


def create_learner_credit_enrollment_uuid(apps, schema_editor):
    learner_credit_enrollments = apps.get_model('enterprise', 'learnercreditenterprisecourseenrollment')
    for learner_credit_enrollment in learner_credit_enrollments.objects.all():
        learner_credit_enrollment.uuid = uuid.uuid4()
        learner_credit_enrollment.save()


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0167_auto_20230209_2108'),
    ]

    operations = [
        migrations.RunPython(create_license_enrollment_uuid, reverse_code=migrations.RunPython.noop),
        migrations.RunPython(create_learner_credit_enrollment_uuid, reverse_code=migrations.RunPython.noop),
    ]
