# Generated by Django 3.2.19 on 2023-06-29 23:30

from django.db import migrations, models
import django.db.models.deletion
import enterprise.models


class Migration(migrations.Migration):

    dependencies = [
        ('sites', '0002_alter_domain_unique'),
        ('enterprise', '0174_auto_20230608_2041'),
    ]

    operations = [
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='active',
            field=models.BooleanField(default=True, verbose_name='Active admin portal'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='auth_org_id',
            field=models.CharField(blank=True, help_text="Enterprise customer's authentication ID if leveraging a third party platform such as Auth0 for authentication.", max_length=80, null=True, verbose_name='Third Party Auth Org ID:'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='contact_email',
            field=models.EmailField(blank=True, help_text='Email address presented on learner portal as public point of contact from customer organization.', max_length=254, null=True, verbose_name='Customer admin contact email:'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='customer_type',
            field=models.ForeignKey(default=enterprise.models.get_default_customer_type, on_delete=django.db.models.deletion.CASCADE, to='enterprise.enterprisecustomertype', verbose_name='Customer Type'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='default_language',
            field=models.CharField(blank=True, choices=[('en', 'English'), ('es-419', 'Español (Latinoamérica)')], default=None, help_text='Specifies the default language for learners of the organization.', max_length=25, null=True, verbose_name='Learner default language'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_analytics_screen',
            field=models.BooleanField(default=True, help_text='Automatically enabled. Displays advanced analytics page on the administrator portal, which includes skill and labor market data.', verbose_name='Display analytics page'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_audit_data_reporting',
            field=models.BooleanField(default=False, help_text='Enables transmission of audit enrollment data from learning platform learners.', verbose_name='Enable audit enrollment data reporting for learning platform learners'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_audit_enrollment',
            field=models.BooleanField(default=False, help_text='Allows learners enrolling through learning platforms to select the audit track.', verbose_name='Enable audit enrollment for learning platform learners'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_browse_and_request',
            field=models.BooleanField(default=False, verbose_name='Display browse and request management settings'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_data_sharing_consent',
            field=models.BooleanField(default=False, help_text='Enables data sharing consent prompt for learners each time they enroll in a course. If left unchecked, the prompt will not appear and relevant data will not be shared.', verbose_name='Activate data sharing consent prompt'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_integrated_customer_learner_portal_search',
            field=models.BooleanField(default=True, help_text="Automatically enabled. If unchecked, the learners won't be able to search for a course on the learner portal.", verbose_name='Allow course discovery within the learner portal'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_learner_portal',
            field=models.BooleanField(default=True, help_text="Automatically enabled. If unchecked, learners won't have access to the learner portal."),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_learner_portal_offers',
            field=models.BooleanField(default=False, help_text='Specifies whether enterprise offers will be made known to learners in the learner portal This only applies to customers with “offers”, the old version of learner credit.', verbose_name='Enable learner credit in the learner portal'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_portal_code_management_screen',
            field=models.BooleanField(default=False, verbose_name='Display code management screen'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_portal_learner_credit_management_screen',
            field=models.BooleanField(default=False, verbose_name='Display learner credit management screen'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_portal_lms_configurations_screen',
            field=models.BooleanField(default=False, help_text='Enables the learning platform configuration screen on the administrator portal.', verbose_name='Display learning platform configuration screen'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_portal_reporting_config_screen',
            field=models.BooleanField(default=False, help_text='Enables the scheduled reporting configurations screen on the administrator portal.', verbose_name='Display enterprise reporting page'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_portal_saml_configuration_screen',
            field=models.BooleanField(default=False, help_text='Enables the Single Sign On (SSO) configuration screen on the administrator portal. ', verbose_name='Display SSO configuration screen'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_portal_subscription_management_screen',
            field=models.BooleanField(default=False, verbose_name='Display subscription management screen'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_slug_login',
            field=models.BooleanField(default=False, help_text='Allows a learner to input customer slug to identify their org in the SSO process. Should be enabled for customers that leverage SSO.', verbose_name='Allow slug login for SSO'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enable_universal_link',
            field=models.BooleanField(default=False, verbose_name='Display universal link settings'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='enforce_data_sharing_consent',
            field=models.CharField(choices=[('at_enrollment', 'At Enrollment'), ('externally_managed', 'Managed externally')], default='at_enrollment', help_text='Setting to either require learners to accept data sharing consent at course enrollment, or through an external process.', max_length=25, verbose_name='Data sharing consent enforcement:'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='hide_course_original_price',
            field=models.BooleanField(default=False, help_text='Hides course price on learning platform course confirmation screen.', verbose_name='Hide course price on learning platform'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='hide_labor_market_data',
            field=models.BooleanField(default=False, help_text='Hides labor market data from learners (populated by features using Lightcast integration). ', verbose_name='Hide labor market data on skill features'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='replace_sensitive_sso_username',
            field=models.BooleanField(default=False, help_text='Specifies whether to replace the display of potentially sensitive SSO usernames with a more generic name, e.g. EnterpriseLearner.', verbose_name='Replace sensitive SSO username'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='reply_to',
            field=models.EmailField(blank=True, help_text='Email address that will receive learner replies to automated edX emails.', max_length=254, null=True, verbose_name='Customer “reply to” email:'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='sender_alias',
            field=models.CharField(blank=True, help_text='Specifies the sender alias for automated emails from the edX system.', max_length=255, null=True, verbose_name='Automated email sender alias'),
        ),
        migrations.AlterField(
            model_name='enterprisecustomer',
            name='site',
            field=models.ForeignKey(default=enterprise.models.get_default_site, on_delete=django.db.models.deletion.CASCADE, related_name='enterprise_customers', to='sites.site'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='active',
            field=models.BooleanField(default=True, verbose_name='Active admin portal'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='auth_org_id',
            field=models.CharField(blank=True, help_text="Enterprise customer's authentication ID if leveraging a third party platform such as Auth0 for authentication.", max_length=80, null=True, verbose_name='Third Party Auth Org ID:'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='contact_email',
            field=models.EmailField(blank=True, help_text='Email address presented on learner portal as public point of contact from customer organization.', max_length=254, null=True, verbose_name='Customer admin contact email:'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='customer_type',
            field=models.ForeignKey(blank=True, db_constraint=False, default=enterprise.models.get_default_customer_type, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='enterprise.enterprisecustomertype', verbose_name='Customer Type'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='default_language',
            field=models.CharField(blank=True, choices=[('en', 'English'), ('es-419', 'Español (Latinoamérica)')], default=None, help_text='Specifies the default language for learners of the organization.', max_length=25, null=True, verbose_name='Learner default language'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_analytics_screen',
            field=models.BooleanField(default=True, help_text='Automatically enabled. Displays advanced analytics page on the administrator portal, which includes skill and labor market data.', verbose_name='Display analytics page'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_audit_data_reporting',
            field=models.BooleanField(default=False, help_text='Enables transmission of audit enrollment data from learning platform learners.', verbose_name='Enable audit enrollment data reporting for learning platform learners'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_audit_enrollment',
            field=models.BooleanField(default=False, help_text='Allows learners enrolling through learning platforms to select the audit track.', verbose_name='Enable audit enrollment for learning platform learners'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_browse_and_request',
            field=models.BooleanField(default=False, verbose_name='Display browse and request management settings'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_data_sharing_consent',
            field=models.BooleanField(default=False, help_text='Enables data sharing consent prompt for learners each time they enroll in a course. If left unchecked, the prompt will not appear and relevant data will not be shared.', verbose_name='Activate data sharing consent prompt'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_integrated_customer_learner_portal_search',
            field=models.BooleanField(default=True, help_text="Automatically enabled. If unchecked, the learners won't be able to search for a course on the learner portal.", verbose_name='Allow course discovery within the learner portal'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_learner_portal',
            field=models.BooleanField(default=True, help_text="Automatically enabled. If unchecked, learners won't have access to the learner portal."),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_learner_portal_offers',
            field=models.BooleanField(default=False, help_text='Specifies whether enterprise offers will be made known to learners in the learner portal This only applies to customers with “offers”, the old version of learner credit.', verbose_name='Enable learner credit in the learner portal'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_portal_code_management_screen',
            field=models.BooleanField(default=False, verbose_name='Display code management screen'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_portal_learner_credit_management_screen',
            field=models.BooleanField(default=False, verbose_name='Display learner credit management screen'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_portal_lms_configurations_screen',
            field=models.BooleanField(default=False, help_text='Enables the learning platform configuration screen on the administrator portal.', verbose_name='Display learning platform configuration screen'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_portal_reporting_config_screen',
            field=models.BooleanField(default=False, help_text='Enables the scheduled reporting configurations screen on the administrator portal.', verbose_name='Display enterprise reporting page'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_portal_saml_configuration_screen',
            field=models.BooleanField(default=False, help_text='Enables the Single Sign On (SSO) configuration screen on the administrator portal. ', verbose_name='Display SSO configuration screen'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_portal_subscription_management_screen',
            field=models.BooleanField(default=False, verbose_name='Display subscription management screen'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_slug_login',
            field=models.BooleanField(default=False, help_text='Allows a learner to input customer slug to identify their org in the SSO process. Should be enabled for customers that leverage SSO.', verbose_name='Allow slug login for SSO'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enable_universal_link',
            field=models.BooleanField(default=False, verbose_name='Display universal link settings'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='enforce_data_sharing_consent',
            field=models.CharField(choices=[('at_enrollment', 'At Enrollment'), ('externally_managed', 'Managed externally')], default='at_enrollment', help_text='Setting to either require learners to accept data sharing consent at course enrollment, or through an external process.', max_length=25, verbose_name='Data sharing consent enforcement:'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='hide_course_original_price',
            field=models.BooleanField(default=False, help_text='Hides course price on learning platform course confirmation screen.', verbose_name='Hide course price on learning platform'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='hide_labor_market_data',
            field=models.BooleanField(default=False, help_text='Hides labor market data from learners (populated by features using Lightcast integration). ', verbose_name='Hide labor market data on skill features'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='replace_sensitive_sso_username',
            field=models.BooleanField(default=False, help_text='Specifies whether to replace the display of potentially sensitive SSO usernames with a more generic name, e.g. EnterpriseLearner.', verbose_name='Replace sensitive SSO username'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='reply_to',
            field=models.EmailField(blank=True, help_text='Email address that will receive learner replies to automated edX emails.', max_length=254, null=True, verbose_name='Customer “reply to” email:'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='sender_alias',
            field=models.CharField(blank=True, help_text='Specifies the sender alias for automated emails from the edX system.', max_length=255, null=True, verbose_name='Automated email sender alias'),
        ),
        migrations.AlterField(
            model_name='historicalenterprisecustomer',
            name='site',
            field=models.ForeignKey(blank=True, db_constraint=False, default=enterprise.models.get_default_site, null=True, on_delete=django.db.models.deletion.DO_NOTHING, related_name='+', to='sites.site'),
        ),
    ]
