# Generated by Django 3.2.23 on 2023-11-30 19:01

from django.db import migrations, models


def backfill_sso_marked_authorized(apps, app_schema):
    """
    Sets all Enterprise Customer SSO Configuration records 'marked_authorized' to False, in anticipation
    of making it the default value
    """
    EnterpriseCustomerSsoConfiguration = apps.get_model('enterprise', 'EnterpriseCustomerSsoConfiguration')
    queryset = EnterpriseCustomerSsoConfiguration.all_objects.all()
    for sso_config in queryset:
        sso_config.marked_authorized = False
    EnterpriseCustomerSsoConfiguration.all_objects.bulk_update(queryset, ['marked_authorized'])


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0195_auto_20231130_1837'),
    ]

    operations = [
        migrations.RunPython(
            code=backfill_sso_marked_authorized,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
