# Generated by Django 4.2.10 on 2024-06-12 11:25

from django.db import migrations


def copy_career_engagement_network_message_to_learner_portal_sidebar_content(apps, schema_editor):  # pragma: no cover
    """
    Copies the Career Engagement Network message field to the Learner Portal Sidebar
    field in the Enterprise Customer model.
    """
    EnterpriseCustomer = apps.get_model('enterprise', 'EnterpriseCustomer')

    for row in EnterpriseCustomer.objects.all():
        row.learner_portal_sidebar_content = row.career_engagement_network_message
        row.enable_learner_portal_sidebar_message = row.enable_career_engagement_network_on_learner_portal
        row.save()


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0212_alter_enterprisecustomer_career_engagement_network_message_and_more'),
    ]

    operations = [
        migrations.RunPython(
            code=copy_career_engagement_network_message_to_learner_portal_sidebar_content,
            reverse_code=migrations.RunPython.noop,
        ),
    ]
