# Generated by Django 4.2.13 on 2024-07-24 13:03

from django.db import migrations


from enterprise.constants import SYSTEM_ENTERPRISE_PROVISIONING_ADMIN_ROLE


def create_enterprise_provisioning_admin_role(apps, schema_editor):  # pylint: disable=unused-argument
    """Create the `enterprise_provisioining_admin` system-wide role if it does not already exist"""
    SystemWideEnterpriseRole = apps.get_model(
        'enterprise', 'SystemWideEnterpriseRole')
    SystemWideEnterpriseRole.objects.update_or_create(
        name=SYSTEM_ENTERPRISE_PROVISIONING_ADMIN_ROLE,
        description='Role for provisioning admins',
    )


def delete_enterprise_provisioning_admin_role(apps, schema_editor):  # pylint: disable=unused-argument
    """Delete the `enterprise_provisioining_admin` system-wide role"""
    SystemWideEnterpriseRole = apps.get_model(  # pragma: no cover
        'enterprise', 'SystemWideEnterpriseRole')
    SystemWideEnterpriseRole.objects.filter(  # pragma: no cover
        name=SYSTEM_ENTERPRISE_PROVISIONING_ADMIN_ROLE).delete()


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0217_alter_enterprisecustomer_disable_expiry_messaging_for_learner_credit_and_more'),
    ]

    operations = [
        migrations.RunPython(
            code=create_enterprise_provisioning_admin_role,
            reverse_code=delete_enterprise_provisioning_admin_role,
        ),
    ]
