# Generated by Django 4.2.16 on 2025-02-19 20:20

from django.db import migrations, connection


class Migration(migrations.Migration):
    dependencies = [
        ('enterprise', '0229_enterprisecustomeruser_user_fk_and_more'),
    ]

    db_engine = connection.settings_dict['ENGINE']
    if 'mysql' in db_engine:
        operations = [
            # Custom SQL to add indexes with zero-downtime options
            migrations.RunSQL(
                sql="""
                    ALTER TABLE enterprise_enterprisecustomeruser
                        ADD INDEX idx_enterprise_user_fk (user_fk),
                        ALGORITHM = INPLACE,
                        LOCK = NONE;

                    ALTER TABLE enterprise_historicalenterprisecustomeruser
                        ADD INDEX idx_historical_enterprise_user_fk (user_fk),
                        ALGORITHM = INPLACE,
                        LOCK = NONE;
                    """,
                reverse_sql="""
                            ALTER TABLE enterprise_enterprisecustomeruser
                                DROP INDEX idx_enterprise_user_fk;
                            ALTER TABLE enterprise_historicalenterprisecustomeruser
                                DROP INDEX idx_historical_enterprise_user_fk;
                            """
            ),
        ]
    if 'postgres' in db_engine:
        operations = [
            # Custom SQL to add indexes with zero-downtime options
            migrations.RunSQL(
                sql="""
                    CREATE INDEX idx_enterprise_user_fk ON enterprise_enterprisecustomeruser (user_fk);
                    CREATE INDEX idx_historical_enterprise_user_fk ON enterprise_historicalenterprisecustomeruser (user_fk);
                    """,
                reverse_sql="""
                            DROP INDEX idx_enterprise_user_fk;
                            DROP INDEX idx_historical_enterprise_user_fk;
                            """
            ),
        ]
    else:
        operations = []
