# Generated by Django 4.2.19 on 2025-03-19 22:12
import logging

from django.db import migrations
from django.core.management import call_command


logger = logging.getLogger(__name__)


def run_backfill_command(apps, schema_editor):
    """Runs the backfill management command automatically."""
    try:
        logger.info('Running backfill_ecu_table_user_foreign_key...')
        call_command('backfill_ecu_table_user_foreign_key')
        logger.info('Backfill completed successfully.')
    except Exception as e:  # pylint: disable=broad-except
        logger.warning(f'Warning: The command "backfill_ecu_table_user_foreign_key" failed: {e}')


class Migration(migrations.Migration):
    dependencies = [
        ('enterprise', '0231_alter_enterprisecustomeruser_user_fk_and_more'),
    ]

    operations = [
        migrations.RunPython(run_backfill_command, reverse_code=migrations.RunPython.noop)
    ]
