# Generated by Django 4.2.19 on 2025-04-29 20:55

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('enterprise', '0234_fake_enterprisecustomeruser_user_fk_state'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnterpriseCustomerAdmin',
            fields=[
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('last_login', models.DateTimeField(blank=True, help_text='The last time the admin logged into the admin portal.', null=True)),
                ('onboarding_tour_dismissed', models.BooleanField(default=False, help_text='Whether the admin has dismissed the onboarding tour.')),
                ('onboarding_tour_completed', models.BooleanField(default=False, help_text='Whether the admin has completed the onboarding tour.')),
                ('completed_tour_flows', models.ManyToManyField(blank=True, help_text='The onboarding flows that this admin has completed.', to='enterprise.onboardingflow')),
                ('enterprise_customer_user', models.OneToOneField(help_text='The enterprise customer user who is an admin.', on_delete=django.db.models.deletion.CASCADE, related_name='admin_record', to='enterprise.enterprisecustomeruser')),
            ],
            options={
                'verbose_name': 'Enterprise Customer Admin',
                'verbose_name_plural': 'Enterprise Customer Admins',
                'ordering': ['-modified'],
            },
        ),
    ]
