# Generated by Django 3.2.10 on 2021-12-21 15:35

from django.db import migrations, models
import uuid


def create_uuid(apps, schema_editor):
    CanvasEnterpriseCustomerConfiguration = apps.get_model('canvas', 'CanvasEnterpriseCustomerConfiguration')
    for config in CanvasEnterpriseCustomerConfiguration.objects.all():
        config.uuid = uuid.uuid4()
        config.save()


class Migration(migrations.Migration):

    dependencies = [
        ('canvas', '0012_alter_canvasenterprisecustomerconfiguration_enterprise_customer'),
    ]

    operations = [
        migrations.AddField(
            model_name='canvasenterprisecustomerconfiguration',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, editable=False, help_text='A UUID for use in public-facing urls such as oauth state variables.', null=True),
        ),
        migrations.AddField(
            model_name='historicalcanvasenterprisecustomerconfiguration',
            name='uuid',
            field=models.UUIDField(db_index=True, default=uuid.uuid4, editable=False, help_text='A UUID for use in public-facing urls such as oauth state variables.'),
        ),
        migrations.RunPython(create_uuid, reverse_code=migrations.RunPython.noop),
        migrations.AlterField(
            model_name='canvasenterprisecustomerconfiguration',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, editable=False, help_text='A UUID for use in public-facing urls such as oauth state variables.', unique=True),
        ),
    ]
