# Generated by Django 3.2.23 on 2024-03-29 15:37

from django.db import migrations


def populate_decrypted_fields(apps, schema_editor):
    """
    Populates the encryption fields with the data previously stored in database.
    """
    Degreed2EnterpriseCustomerConfiguration = apps.get_model('degreed2', 'Degreed2EnterpriseCustomerConfiguration')

    for degreed2_enterprise_configuration in Degreed2EnterpriseCustomerConfiguration.objects.all():
        degreed2_enterprise_configuration.decrypted_client_id = degreed2_enterprise_configuration.client_id
        degreed2_enterprise_configuration.decrypted_client_secret = degreed2_enterprise_configuration.client_secret
        degreed2_enterprise_configuration.save()


class Migration(migrations.Migration):

    dependencies = [
        ('degreed2', '0026_auto_20240329_1537'),
    ]

    operations = [
        migrations.RunPython(populate_decrypted_fields, reverse_code=migrations.RunPython.noop),
    ]
