# Generated by Django 3.2.20 on 2023-11-06 12:33

from django.db import migrations


def populate_decrypted_fields(apps, schema_editor):
    """
    Populates the encryption fields with the data previously stored in database.
    """
    MoodleEnterpriseCustomerConfiguration = apps.get_model('moodle', 'MoodleEnterpriseCustomerConfiguration')

    for moodle_enterprise_configuration in MoodleEnterpriseCustomerConfiguration.objects.all():
        moodle_enterprise_configuration.decrypted_username = moodle_enterprise_configuration.username
        moodle_enterprise_configuration.decrypted_password = moodle_enterprise_configuration.password
        moodle_enterprise_configuration.decrypted_token = moodle_enterprise_configuration.token
        moodle_enterprise_configuration.save()


class Migration(migrations.Migration):

    dependencies = [
        ('moodle', '0028_auto_20230928_1530'),
    ]

    operations = [
        migrations.RunPython(populate_decrypted_fields, reverse_code=migrations.RunPython.noop),
    ]
