"""
update schema changes - renamed index and column

Revision ID: 3fa4e62e787b
Revises: 9f2dac16ce3b
Create Date: 2025-09-15 21:07:07.613710

"""

from collections.abc import Sequence

import sqlalchemy as sa

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "3fa4e62e787b"
down_revision: str | Sequence[str] | None = "9f2dac16ce3b"
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("feature_levels", sa.Column("sort_order", sa.Integer(), nullable=False))
    op.drop_constraint(op.f("uq_feature_levels_company_feature_order"), "feature_levels", type_="unique")
    op.create_unique_constraint(
        "uq_feature_levels_company_feature_order", "feature_levels", ["company_id", "feature_id", "sort_order"]
    )
    op.create_index("ix_feature_levels_company_feature", "feature_levels", ["company_id", "feature_id"], unique=False)
    op.drop_column("feature_levels", "order")
    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("feature_levels", sa.Column("order", sa.TEXT(), autoincrement=False, nullable=False))
    op.drop_index("ix_feature_levels_company_feature", table_name="feature_levels")
    op.drop_constraint("uq_feature_levels_company_feature_order", "feature_levels", type_="unique")
    op.create_unique_constraint(
        op.f("uq_feature_levels_company_feature_order"),
        "feature_levels",
        ["company_id", "feature_id", "order"],
        postgresql_nulls_not_distinct=False,
    )
    op.drop_column("feature_levels", "sort_order")
    # ### end Alembic commands ###
