"""
init schema

Revision ID: 136d2c0ff764
Revises:
Create Date: 2025-09-15 13:42:19.292853

"""

from collections.abc import Sequence

import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from alembic import op

# revision identifiers, used by Alembic.
revision: str = "136d2c0ff764"
down_revision: str | Sequence[str] | None = None
branch_labels: str | Sequence[str] | None = None
depends_on: str | Sequence[str] | None = None


def upgrade() -> None:
    """Upgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "companies",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("frequency", sa.Integer(), nullable=False),
        sa.Column("dataset_type", sa.Text(), nullable=False),
        sa.Column("min_date", sa.Date(), nullable=False),
        sa.Column("max_date", sa.Date(), nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("company_id"),
        sa.UniqueConstraint("name"),
    )
    op.create_table(
        "regions",
        sa.Column("region_id", sa.Integer(), nullable=False),
        sa.Column("abbreviation", sa.Text(), nullable=False),
        sa.Column("type", sa.Text(), nullable=False),
        sa.Column("country", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("parent_region_id", sa.Integer(), nullable=True),
        sa.ForeignKeyConstraint(
            ["parent_region_id"],
            ["regions.region_id"],
            name="link_to_parent_regions",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("region_id"),
        sa.UniqueConstraint("abbreviation", "type", "country"),
    )
    op.create_index("unique_region_index", "regions", ["parent_region_id", "name", "abbreviation", "type"], unique=True)
    op.create_index("unique_top_level_regions", "regions", ["name", "abbreviation", "type"], unique=True)
    op.create_table(
        "categories",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("category_id", sa.Integer(), sa.Identity(always=True), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id"],
            ["companies.company_id"],
            name="fk_categories_companies",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "category_id", name="pk_categories"),
        sa.UniqueConstraint("company_id", "name", name="uq_categories_company_name"),
    )
    op.create_index("ix_categories_company_id", "categories", ["company_id"], unique=False)
    op.create_table(
        "category_level_descriptions",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("level_id", sa.Integer(), sa.Identity(always=True), nullable=False),
        sa.Column("level", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id"],
            ["companies.company_id"],
            name="fk_catleveldesc_companies",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "level_id", name="pk_category_level_descriptions"),
        sa.UniqueConstraint("company_id", "level", "name", name="uq_catleveldesc_company_level_name"),
    )
    op.create_index("ix_catleveldesc_company_id", "category_level_descriptions", ["company_id"], unique=False)
    op.create_table(
        "feature_descriptions",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), sa.Identity(always=True), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.Column("description", sa.Text(), nullable=True),
        sa.Column("var_type", sa.Text(), nullable=False),
        sa.Column("feature_type", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id"],
            ["companies.company_id"],
            name="fk_feature_descriptions_companies",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "feature_id", name="pk_feature_descriptions"),
        sa.UniqueConstraint("company_id", "name", name="uq_feature_descriptions_company_name"),
    )
    op.create_index("ix_feature_descriptions_company_id", "feature_descriptions", ["company_id"], unique=False)
    op.create_table(
        "products",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("product_id", sa.Integer(), sa.Identity(always=True), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id"],
            ["companies.company_id"],
            name="fk_products_companies",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "product_id", name="pk_products"),
        sa.UniqueConstraint("company_id", "name", name="uq_products_company_name"),
    )
    op.create_index("ix_products_company_id", "products", ["company_id"], unique=False)
    op.create_table(
        "stores",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("store_id", sa.Integer(), sa.Identity(always=True), nullable=False),
        sa.Column("region_id", sa.Integer(), nullable=False),
        sa.Column("name", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id"], ["companies.company_id"], name="link_to_companies", onupdate="RESTRICT", ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["region_id"], ["regions.region_id"], name="link_to_regions", onupdate="RESTRICT", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("company_id", "store_id", name="pk_stores"),
        sa.UniqueConstraint("company_id", "name"),
    )
    op.create_index("ix_stores_company_id", "stores", ["company_id"], unique=False)
    op.create_index("ix_stores_region_id", "stores", ["region_id"], unique=False)
    op.create_table(
        "category_relations",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sub_category_id", sa.Integer(), nullable=False),
        sa.Column("parent_category_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id", "parent_category_id"],
            ["categories.company_id", "categories.category_id"],
            name="fk_category_relations_parent",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sub_category_id"],
            ["categories.company_id", "categories.category_id"],
            name="fk_category_relations_sub",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id"],
            ["companies.company_id"],
            name="fk_category_relations_companies",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sub_category_id", "parent_category_id", name="pk_category_relations"),
        sa.UniqueConstraint("company_id", "sub_category_id", "parent_category_id"),
    )
    op.create_index("ix_category_relations_company_id", "category_relations", ["company_id"], unique=False)
    op.create_table(
        "feature_levels",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("level", sa.Text(), nullable=False),
        sa.Column("order", sa.Text(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_feature_levels_feature_descriptions",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "feature_id", "level", name="pk_feature_levels"),
        sa.UniqueConstraint("company_id", "feature_id", "order", name="uq_feature_levels_company_feature_order"),
    )
    op.create_index("ix_feature_levels_company_id", "feature_levels", ["company_id"], unique=False)
    op.create_table(
        "product_categories",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("product_id", sa.Integer(), nullable=False),
        sa.Column("category_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id", "category_id"],
            ["categories.company_id", "categories.category_id"],
            name="fk_product_categories_categories",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "product_id"],
            ["products.company_id", "products.product_id"],
            name="fk_product_categories_products",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "product_id", "category_id", name="pk_product_categories"),
        sa.UniqueConstraint("company_id", "product_id", "category_id"),
    )
    op.create_index("ix_product_categories_company_id", "product_categories", ["company_id"], unique=False)
    op.create_index(
        "ix_product_categories_product_id", "product_categories", ["company_id", "product_id"], unique=False
    )
    op.create_table(
        "product_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("product_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_product_features_feat",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "product_id"],
            ["products.company_id", "products.product_id"],
            name="fk_product_features_products",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "product_id", "feature_id", name="pk_product_features"),
    )
    op.create_index(
        "ix_product_features_company_feature", "product_features", ["company_id", "feature_id"], unique=False
    )
    op.create_index(
        "ix_product_features_company_product", "product_features", ["company_id", "product_id"], unique=False
    )
    op.create_table(
        "product_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("product_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_product_features_text_feat",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "product_id"],
            ["products.company_id", "products.product_id"],
            name="fk_product_features_text_products",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "product_id", "feature_id", name="pk_product_features_text"),
    )
    op.create_index(
        "ix_product_features_text_company_feature", "product_features_text", ["company_id", "feature_id"], unique=False
    )
    op.create_index(
        "ix_product_features_text_company_product", "product_features_text", ["company_id", "product_id"], unique=False
    )
    op.create_table(
        "sku_table",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), sa.Identity(always=True), nullable=False),
        sa.Column("product_id", sa.Integer(), nullable=False),
        sa.Column("store_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["company_id", "product_id"],
            ["products.company_id", "products.product_id"],
            name="fk_sku_table_products",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "store_id"],
            ["stores.company_id", "stores.store_id"],
            name="fk_sku_table_stores",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", name="pk_sku_table"),
        sa.UniqueConstraint("company_id", "product_id", "store_id"),
    )
    op.create_index("ix_sku_table_company_id", "sku_table", ["company_id"], unique=False)
    op.create_index("ix_sku_table_sku_id", "sku_table", ["company_id", "sku_id"], unique=False)
    op.create_table(
        "store_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("store_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_store_features_feat",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "store_id"],
            ["stores.company_id", "stores.store_id"],
            name="fk_store_features_stores",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "store_id", "feature_id", name="pk_store_features"),
    )
    op.create_index("ix_store_features_company_feature", "store_features", ["company_id", "feature_id"], unique=False)
    op.create_index("ix_store_features_company_store", "store_features", ["company_id", "store_id"], unique=False)
    op.create_table(
        "store_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("store_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_store_features_text_feat",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "store_id"],
            ["stores.company_id", "stores.store_id"],
            name="fk_store_features_text_stores",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "store_id", "feature_id", name="pk_store_features_text"),
    )
    op.create_index(
        "ix_store_features_text_company_feature", "store_features_text", ["company_id", "feature_id"], unique=False
    )
    op.create_index(
        "ix_store_features_text_company_store", "store_features_text", ["company_id", "store_id"], unique=False
    )
    op.create_table(
        "time_product_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("product_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tpf_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "product_id"],
            ["products.company_id", "products.product_id"],
            name="fk_tpf_products",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "product_id", "feature_id", "ts", name="pk_time_product_features"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "product_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "product_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_tpf_company_feature_ts", "time_product_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        "ix_tpf_company_product_ts", "time_product_features", ["company_id", "product_id", "ts"], unique=False
    )
    op.create_table(
        "time_product_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("product_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tpf_text_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "product_id"],
            ["products.company_id", "products.product_id"],
            name="fk_tpf_text_products",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "product_id", "feature_id", "ts", name="pk_time_product_features_text"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "product_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "product_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_tpf_text_company_feature_ts", "time_product_features_text", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        "ix_tpf_text_company_product_ts", "time_product_features_text", ["company_id", "product_id", "ts"], unique=False
    )
    op.create_table(
        "time_region_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("region_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_trf_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["region_id"], ["regions.region_id"], name="fk_trf_regions", onupdate="RESTRICT", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("company_id", "region_id", "feature_id", "ts", name="pk_time_region_features"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "region_id",
                "number_partitions": 16,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "region_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_trf_company_feature_ts", "time_region_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index("ix_trf_company_region_ts", "time_region_features", ["company_id", "region_id", "ts"], unique=False)
    op.create_table(
        "time_region_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("region_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_trf_text_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["region_id"], ["regions.region_id"], name="fk_trf_text_regions", onupdate="RESTRICT", ondelete="CASCADE"
        ),
        sa.PrimaryKeyConstraint("company_id", "region_id", "feature_id", "ts", name="pk_time_region_features_text"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "region_id",
                "number_partitions": 16,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "region_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_trf_text_company_feature_ts", "time_region_features_text", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        "ix_trf_text_company_region_ts", "time_region_features_text", ["company_id", "region_id", "ts"], unique=False
    )
    op.create_table(
        "time_store_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("store_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tsf_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "store_id"],
            ["stores.company_id", "stores.store_id"],
            name="fk_tsf_stores",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "store_id", "feature_id", "ts", name="pk_time_store_features"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "store_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "store_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_tsf_company_feature_ts", "time_store_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index("ix_tsf_company_store_ts", "time_store_features", ["company_id", "store_id", "ts"], unique=False)
    op.create_table(
        "time_store_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("store_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tsf_text_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "store_id"],
            ["stores.company_id", "stores.store_id"],
            name="fk_tsf_text_stores",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "store_id", "feature_id", "ts", name="pk_time_store_features_text"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "store_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "store_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_tsf_text_company_feature_ts", "time_store_features_text", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        "ix_tsf_text_company_store_ts", "time_store_features_text", ["company_id", "store_id", "ts"], unique=False
    )
    op.create_table(
        "sku_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_sku_features_feat",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sku_id"],
            ["sku_table.company_id", "sku_table.sku_id"],
            name="fk_sku_features_sku",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", "feature_id", name="pk_sku_features"),
    )
    op.create_index("ix_sku_features_company_feature", "sku_features", ["company_id", "feature_id"], unique=False)
    op.create_index("ix_sku_features_company_sku", "sku_features", ["company_id", "sku_id"], unique=False)
    op.create_table(
        "sku_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_sku_features_text_feat",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sku_id"],
            ["sku_table.company_id", "sku_table.sku_id"],
            name="fk_sku_features_text_sku",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", "feature_id", name="pk_sku_features_text"),
    )
    op.create_index(
        "ix_sku_features_text_company_feature", "sku_features_text", ["company_id", "feature_id"], unique=False
    )
    op.create_index("ix_sku_features_text_company_sku", "sku_features_text", ["company_id", "sku_id"], unique=False)
    op.create_table(
        "time_sku_features",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.DOUBLE_PRECISION(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tskuf_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sku_id"],
            ["sku_table.company_id", "sku_table.sku_id"],
            name="fk_tskuf_sku",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", "feature_id", "ts", name="pk_time_sku_features"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "sku_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "sku_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_tskuf_company_feature_ts", "time_sku_features", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index("ix_tskuf_company_sku_ts", "time_sku_features", ["company_id", "sku_id", "ts"], unique=False)
    op.create_table(
        "time_sku_features_text",
        sa.Column("company_id", sa.Integer(), nullable=False),
        sa.Column("sku_id", sa.Integer(), nullable=False),
        sa.Column("feature_id", sa.Integer(), nullable=False),
        sa.Column("ts", postgresql.TIMESTAMP(timezone=True), nullable=False),
        sa.Column("value", sa.Text(), nullable=True),
        sa.ForeignKeyConstraint(
            ["company_id", "feature_id"],
            ["feature_descriptions.company_id", "feature_descriptions.feature_id"],
            name="fk_tskuf_text_features",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["company_id", "sku_id"],
            ["sku_table.company_id", "sku_table.sku_id"],
            name="fk_tskuf_text_sku",
            onupdate="RESTRICT",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("company_id", "sku_id", "feature_id", "ts", name="pk_time_sku_features_text"),
        info={
            "timescale": {
                "time_column": "ts",
                "space_column": "sku_id",
                "number_partitions": 32,
                "chunk_interval": "14 days",
                "compression": {
                    "enabled": True,
                    "segmentby": ["company_id", "sku_id", "feature_id"],
                    "orderby": "ts DESC",
                    "compress_after": "30 days",
                },
                "caggs": [],
            }
        },
    )
    op.create_index(
        "ix_tskuf_text_company_feature_ts", "time_sku_features_text", ["company_id", "feature_id", "ts"], unique=False
    )
    op.create_index(
        "ix_tskuf_text_company_sku_ts", "time_sku_features_text", ["company_id", "sku_id", "ts"], unique=False
    )

    # TimescaleDB setup
    bind = op.get_bind()
    bind.execute(sa.text("CREATE EXTENSION IF NOT EXISTS timescaledb;"))

    # time_product_features
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_product_features', 'ts',
        partitioning_column => 'product_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_product_features', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_product_features"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,product_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_product_features', INTERVAL '30 days');"))

    # time_product_features_text
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_product_features_text', 'ts',
        partitioning_column => 'product_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_product_features_text', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_product_features_text"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,product_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_product_features_text', INTERVAL '30 days');"))

    # time_region_features
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_region_features', 'ts',
        partitioning_column => 'region_id',
        number_partitions   => 16,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_region_features', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_region_features"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,region_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_region_features', INTERVAL '30 days');"))

    # time_region_features_text
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_region_features_text', 'ts',
        partitioning_column => 'region_id',
        number_partitions   => 16,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_region_features_text', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_region_features_text"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,region_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_region_features_text', INTERVAL '30 days');"))

    # time_store_features
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_store_features', 'ts',
        partitioning_column => 'store_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_store_features', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_store_features"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,store_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_store_features', INTERVAL '30 days');"))

    # time_store_features_text
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_store_features_text', 'ts',
        partitioning_column => 'store_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_store_features_text', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_store_features_text"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,store_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_store_features_text', INTERVAL '30 days');"))

    # time_sku_features
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_sku_features', 'ts',
        partitioning_column => 'sku_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_sku_features', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_sku_features"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,sku_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_sku_features', INTERVAL '30 days');"))

    # time_sku_features_text
    bind.execute(
        sa.text("""
      SELECT create_hypertable(
        'time_sku_features_text', 'ts',
        partitioning_column => 'sku_id',
        number_partitions   => 32,
        create_default_indexes => FALSE,
        if_not_exists => TRUE
      );
    """)
    )
    bind.execute(sa.text("SELECT set_chunk_time_interval('time_sku_features_text', INTERVAL '14 days');"))
    bind.execute(
        sa.text("""
      ALTER TABLE "time_sku_features_text"
      SET (timescaledb.compress = 'on',
           timescaledb.compress_orderby  = 'ts DESC',
           timescaledb.compress_segmentby = 'company_id,sku_id,feature_id');
    """)
    )
    bind.execute(sa.text("SELECT add_compression_policy('time_sku_features_text', INTERVAL '30 days');"))

    # ### end Alembic commands ###


def downgrade() -> None:
    """Downgrade schema."""
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index("ix_tskuf_text_company_sku_ts", table_name="time_sku_features_text")
    op.drop_index("ix_tskuf_text_company_feature_ts", table_name="time_sku_features_text")
    op.drop_table("time_sku_features_text")
    op.drop_index("ix_tskuf_company_sku_ts", table_name="time_sku_features")
    op.drop_index("ix_tskuf_company_feature_ts", table_name="time_sku_features")
    op.drop_table("time_sku_features")
    op.drop_index("ix_sku_features_text_company_sku", table_name="sku_features_text")
    op.drop_index("ix_sku_features_text_company_feature", table_name="sku_features_text")
    op.drop_table("sku_features_text")
    op.drop_index("ix_sku_features_company_sku", table_name="sku_features")
    op.drop_index("ix_sku_features_company_feature", table_name="sku_features")
    op.drop_table("sku_features")
    op.drop_index("ix_tsf_text_company_store_ts", table_name="time_store_features_text")
    op.drop_index("ix_tsf_text_company_feature_ts", table_name="time_store_features_text")
    op.drop_table("time_store_features_text")
    op.drop_index("ix_tsf_company_store_ts", table_name="time_store_features")
    op.drop_index("ix_tsf_company_feature_ts", table_name="time_store_features")
    op.drop_table("time_store_features")
    op.drop_index("ix_trf_text_company_region_ts", table_name="time_region_features_text")
    op.drop_index("ix_trf_text_company_feature_ts", table_name="time_region_features_text")
    op.drop_table("time_region_features_text")
    op.drop_index("ix_trf_company_region_ts", table_name="time_region_features")
    op.drop_index("ix_trf_company_feature_ts", table_name="time_region_features")
    op.drop_table("time_region_features")
    op.drop_index("ix_tpf_text_company_product_ts", table_name="time_product_features_text")
    op.drop_index("ix_tpf_text_company_feature_ts", table_name="time_product_features_text")
    op.drop_table("time_product_features_text")
    op.drop_index("ix_tpf_company_product_ts", table_name="time_product_features")
    op.drop_index("ix_tpf_company_feature_ts", table_name="time_product_features")
    op.drop_table("time_product_features")
    op.drop_index("ix_store_features_text_company_store", table_name="store_features_text")
    op.drop_index("ix_store_features_text_company_feature", table_name="store_features_text")
    op.drop_table("store_features_text")
    op.drop_index("ix_store_features_company_store", table_name="store_features")
    op.drop_index("ix_store_features_company_feature", table_name="store_features")
    op.drop_table("store_features")
    op.drop_index("ix_sku_table_sku_id", table_name="sku_table")
    op.drop_index("ix_sku_table_company_id", table_name="sku_table")
    op.drop_table("sku_table")
    op.drop_index("ix_product_features_text_company_product", table_name="product_features_text")
    op.drop_index("ix_product_features_text_company_feature", table_name="product_features_text")
    op.drop_table("product_features_text")
    op.drop_index("ix_product_features_company_product", table_name="product_features")
    op.drop_index("ix_product_features_company_feature", table_name="product_features")
    op.drop_table("product_features")
    op.drop_index("ix_product_categories_product_id", table_name="product_categories")
    op.drop_index("ix_product_categories_company_id", table_name="product_categories")
    op.drop_table("product_categories")
    op.drop_index("ix_feature_levels_company_id", table_name="feature_levels")
    op.drop_table("feature_levels")
    op.drop_index("ix_category_relations_company_id", table_name="category_relations")
    op.drop_table("category_relations")
    op.drop_index("ix_stores_region_id", table_name="stores")
    op.drop_index("ix_stores_company_id", table_name="stores")
    op.drop_table("stores")
    op.drop_index("ix_products_company_id", table_name="products")
    op.drop_table("products")
    op.drop_index("ix_feature_descriptions_company_id", table_name="feature_descriptions")
    op.drop_table("feature_descriptions")
    op.drop_index("ix_catleveldesc_company_id", table_name="category_level_descriptions")
    op.drop_table("category_level_descriptions")
    op.drop_index("ix_categories_company_id", table_name="categories")
    op.drop_table("categories")
    op.drop_index("unique_top_level_regions", table_name="regions")
    op.drop_index("unique_region_index", table_name="regions")
    op.drop_table("regions")
    op.drop_table("companies")
    # ### end Alembic commands ###
