# Compliance Control Mappings

This document provides detailed mappings between Riveter rule packs and compliance framework controls.

## Table of Contents

- [CIS Benchmarks](#cis-benchmarks)
- [HIPAA Controls](#hipaa-controls)
- [PCI-DSS Requirements](#pci-dss-requirements)
- [SOC 2 Trust Service Criteria](#soc-2-trust-service-criteria)
- [Well-Architected Framework Mappings](#well-architected-framework-mappings)

## CIS Benchmarks

### CIS AWS Foundations Benchmark v1.4.0

The `cis-aws` rule pack implements the following CIS controls:

#### Section 1: Identity and Access Management
- **1.1** - Maintain current contact details
- **1.2** - Ensure security contact information is registered
- **1.3** - Ensure security questions are registered in the AWS account
- **1.4** - Ensure no 'root' user account access key exists
- **1.5** - Ensure MFA is enabled for the 'root' user account
- **1.6** - Ensure hardware MFA is enabled for the 'root' user account
- **1.7** - Eliminate use of the 'root' user for administrative and daily tasks
- **1.8** - Ensure IAM password policy requires minimum length of 14 or greater
- **1.9** - Ensure IAM password policy prevents password reuse
- **1.10** - Ensure multi-factor authentication (MFA) is enabled for all IAM users

#### Section 2: Storage
- **2.1.1** - Ensure all S3 buckets employ encryption-at-rest
- **2.1.2** - Ensure S3 Bucket Policy is set to deny HTTP requests
- **2.1.3** - Ensure MFA Delete is enable on S3 buckets
- **2.1.4** - Ensure all data in Amazon S3 has been discovered, classified and secured
- **2.1.5** - Ensure that S3 Buckets are configured with 'Block public access'

#### Section 3: Logging
- **3.1** - Ensure CloudTrail is enabled in all regions
- **3.2** - Ensure CloudTrail log file validation is enabled
- **3.3** - Ensure the S3 bucket used to store CloudTrail logs is not publicly accessible
- **3.4** - Ensure CloudTrail trails are integrated with CloudWatch Logs
- **3.5** - Ensure AWS Config is enabled in all regions
- **3.6** - Ensure S3 bucket access logging is enabled on the CloudTrail S3 bucket
- **3.7** - Ensure CloudTrail logs are encrypted at rest using KMS CMKs
- **3.8** - Ensure rotation for customer created CMKs is enabled
- **3.9** - Ensure VPC flow logging is enabled in all VPCs

### CIS Azure Foundations Benchmark v1.3.0

The `cis-azure` rule pack implements controls across 8 sections:

#### Section 1: Identity and Access Management
- **1.1** - Ensure that multi-factor authentication is enabled for all privileged users
- **1.2** - Ensure that multi-factor authentication is enabled for all non-privileged users
- **1.3** - Ensure that there are no guest users
- **1.4** - Ensure that 'Allow users to remember multi-factor authentication on devices they trust' is 'Disabled'

#### Section 2: Security Center
- **2.1** - Ensure that standard pricing tier is selected
- **2.2** - Ensure that 'Automatic provisioning of monitoring agent' is set to 'On'
- **2.3** - Ensure ASC Default policy setting is set to 'On'
- **2.4** - Ensure that 'System updates' is set to 'On'

### CIS GCP Foundations Benchmark v1.3.0

The `cis-gcp` rule pack implements 43 controls across 6 sections:

#### Section 1: Identity and Access Management (10-12 rules)
- **1.1** - Ensure that corporate login credentials are used
- **1.2** - Ensure that multi-factor authentication is enabled for all non-service accounts
- **1.3** - Ensure that Service Account has no Admin privileges
- **1.4** - Ensure that there are only GCP-managed service account keys for each service account
- **1.5** - Ensure that Service Account User managed keys are rotated every 90 days or less

## HIPAA Controls

### Administrative Safeguards

#### 164.308(a)(1)(i) - Security Officer
- Mapped to IAM rules requiring designated security roles
- Implemented in `aws-hipaa` and `azure-hipaa` rule packs

#### 164.308(a)(3)(i) - Assigned Security Responsibilities
- Mapped to IAM policies and role-based access controls
- Rules: `hipaa_iam_least_privilege`, `hipaa_rbac_assignments`

#### 164.308(a)(4)(i) - Information Access Management
- Mapped to access control and authentication rules
- Rules: `hipaa_mfa_required`, `hipaa_access_reviews`

### Physical Safeguards

#### 164.310(a)(1) - Facility Access Controls
- Mapped to cloud provider physical security (inherited)
- Documented in rule pack metadata

#### 164.310(d)(1) - Device and Media Controls
- Mapped to encryption and backup rules
- Rules: `hipaa_storage_encryption`, `hipaa_backup_encryption`

### Technical Safeguards

#### 164.312(a)(1) - Access Control
- **164.312(a)(2)(i)** - Unique User Identification: IAM user management rules
- **164.312(a)(2)(ii)** - Emergency Access Procedure: Break-glass access rules
- **164.312(a)(2)(iii)** - Automatic Logoff: Session management rules
- **164.312(a)(2)(iv)** - Encryption and Decryption: Encryption at rest rules

#### 164.312(b) - Audit Controls
- Mapped to logging and monitoring rules
- Rules: `hipaa_cloudtrail_enabled`, `hipaa_activity_logs`, `hipaa_audit_logging`

#### 164.312(c)(1) - Integrity
- Mapped to data integrity and validation rules
- Rules: `hipaa_log_file_validation`, `hipaa_backup_integrity`

#### 164.312(d) - Person or Entity Authentication
- Mapped to authentication and MFA rules
- Rules: `hipaa_mfa_enforcement`, `hipaa_strong_authentication`

#### 164.312(e)(1) - Transmission Security
- **164.312(e)(2)(i)** - Integrity Controls: SSL/TLS enforcement rules
- **164.312(e)(2)(ii)** - Encryption: Data in transit encryption rules

## PCI-DSS Requirements

### Requirement 1: Install and maintain a firewall configuration

#### 1.1 - Firewall and router configuration standards
- Rules: `pci_security_group_restrictions`, `pci_nacl_configuration`
- Validates security group and NACL configurations

#### 1.2 - Build firewall and router configurations
- **1.2.1** - Restrict connections between untrusted networks and cardholder data environment
- Rules: `pci_vpc_cardholder_data_segmentation`, `pci_network_segmentation`

#### 1.3 - Prohibit direct public access between Internet and cardholder data environment
- **1.3.1** - Implement a DMZ to limit inbound traffic to IP addresses within the DMZ
- Rules: `pci_security_group_no_ssh_from_internet`, `pci_rds_no_public_access`

### Requirement 2: Do not use vendor-supplied defaults

#### 2.1 - Always change vendor-supplied defaults before installing a system on the network
- Rules: `pci_default_passwords_changed`, `pci_secure_configurations`

### Requirement 3: Protect stored cardholder data

#### 3.4 - Render Primary Account Number (PAN) unreadable anywhere it is stored
- Rules: `pci_encryption_cardholder_data`, `pci_s3_encryption_phi`, `pci_rds_encryption`

### Requirement 4: Encrypt transmission of cardholder data across open, public networks

#### 4.1 - Use strong cryptography and security protocols to safeguard sensitive cardholder data
- Rules: `pci_ssl_tls_enforcement`, `pci_https_only`, `pci_secure_protocols`

### Requirement 6: Develop and maintain secure systems and applications

#### 6.1 - Establish a process to identify security vulnerabilities
- Rules: `pci_vulnerability_scanning`, `pci_patch_management`

### Requirement 7: Restrict access to cardholder data by business need to know

#### 7.1 - Limit access to system components and cardholder data to only those individuals whose job requires such access
- Rules: `pci_least_privilege_access`, `pci_role_based_access`

### Requirement 8: Identify and authenticate access to system components

#### 8.1 - Define and implement policies and procedures to ensure proper user identification management
- Rules: `pci_unique_user_ids`, `pci_user_identification`

#### 8.2 - In addition to assigning a unique ID, ensure proper user-authentication management
- **8.2.3** - Passwords/passphrases must meet minimum complexity requirements
- Rules: `pci_password_complexity`, `pci_mfa_enforcement`

### Requirement 10: Track and monitor all access to network resources and cardholder data

#### 10.1 - Implement audit trails to link all access to system components to each individual user
- Rules: `pci_audit_trails`, `pci_user_activity_logging`

#### 10.2 - Implement automated audit trails for all system components
- **10.2.1** - All individual user accesses to cardholder data
- Rules: `pci_vpc_flow_logs_enabled`, `pci_cloudtrail_enabled`

## SOC 2 Trust Service Criteria

### Security (CC6)

#### CC6.1 - Logical and Physical Access Controls
- **CC6.1.1** - Access Control Policies: IAM policies and role management
- **CC6.1.2** - Physical Access: Cloud provider inherited controls
- **CC6.1.3** - Logical Access: Authentication and authorization rules

#### CC6.2 - Authentication and Authorization
- Rules: `soc2_mfa_required`, `soc2_strong_authentication`, `soc2_least_privilege`

#### CC6.3 - Network Security
- Rules: `soc2_network_segmentation`, `soc2_firewall_rules`, `soc2_secure_protocols`

#### CC6.6 - Data Classification and Handling
- Rules: `soc2_data_encryption`, `soc2_data_classification_tags`

#### CC6.7 - System Monitoring
- Rules: `soc2_logging_enabled`, `soc2_monitoring_alerts`, `soc2_audit_trails`

#### CC6.8 - Data Transmission and Disposal
- Rules: `soc2_encryption_in_transit`, `soc2_secure_disposal`

## Well-Architected Framework Mappings

### AWS Well-Architected Framework

#### Operational Excellence Pillar
- **OPS 01** - How do you determine what your priorities are?
  - Rules: `aws_wa_opex_resource_tagging`, `aws_wa_opex_change_management`
- **OPS 02** - How do you structure your organization to support your business outcomes?
  - Rules: `aws_wa_opex_organizational_structure`
- **OPS 03** - How does your organizational culture support your business outcomes?
  - Rules: `aws_wa_opex_culture_automation`

#### Security Pillar
- **SEC 01** - How do you securely operate your workload?
  - Rules: `aws_wa_security_config_rules`, `aws_wa_security_guardduty`
- **SEC 02** - How do you manage identities for people and machines?
  - Rules: `aws_wa_security_iam_policies`, `aws_wa_security_mfa`

#### Reliability Pillar
- **REL 01** - How do you manage service quotas and constraints?
  - Rules: `aws_wa_reliability_service_limits`
- **REL 02** - How do you plan your network topology?
  - Rules: `aws_wa_reliability_multi_az_rds`, `aws_wa_reliability_multi_az_deployments`

#### Performance Efficiency Pillar
- **PERF 01** - How do you select the best performing architecture?
  - Rules: `aws_wa_performance_cloudfront`, `aws_wa_performance_elasticache`
- **PERF 02** - How do you select your compute solution?
  - Rules: `aws_wa_performance_instance_types`, `aws_wa_performance_lambda_memory`

#### Cost Optimization Pillar
- **COST 01** - How do you implement cloud financial management?
  - Rules: `aws_wa_cost_tagging`, `aws_wa_cost_allocation`
- **COST 02** - How do you govern usage?
  - Rules: `aws_wa_cost_lifecycle_policies`, `aws_wa_cost_right_sizing`

#### Sustainability Pillar
- **SUS 01** - How do you select Regions for your workload?
  - Rules: `aws_wa_sustainability_region_selection`
- **SUS 02** - How do you take advantage of user behavior patterns?
  - Rules: `aws_wa_sustainability_serverless_adoption`

### Azure Well-Architected Framework

#### Cost Optimization Pillar
- **CO-01** - Develop cost-conscious culture
  - Rules: `azure_wa_cost_resource_tagging`, `azure_wa_cost_budgets`
- **CO-02** - Design with a cost-efficiency mindset
  - Rules: `azure_wa_cost_vm_sizing`, `azure_wa_cost_storage_tiers`

#### Operational Excellence Pillar
- **OE-01** - Embrace DevOps culture
  - Rules: `azure_wa_opex_automation_accounts`, `azure_wa_opex_update_management`
- **OE-02** - Establish development standards
  - Rules: `azure_wa_opex_naming_conventions`, `azure_wa_opex_resource_standards`

#### Performance Efficiency Pillar
- **PE-01** - Negotiate realistic performance targets
  - Rules: `azure_wa_performance_cdn_usage`, `azure_wa_performance_redis_cache`
- **PE-02** - Design to meet capacity requirements
  - Rules: `azure_wa_performance_autoscaling`, `azure_wa_performance_premium_storage`

#### Reliability Pillar
- **RE-01** - Design for business requirements
  - Rules: `azure_wa_reliability_availability_zones`, `azure_wa_reliability_backup_policies`
- **RE-02** - Design for resilience
  - Rules: `azure_wa_reliability_geo_replication`, `azure_wa_reliability_health_probes`

#### Security Pillar
- **SE-01** - Plan your security readiness
  - Rules: `azure_wa_security_center_enabled`, `azure_wa_security_defender_cloud`
- **SE-02** - Design to protect confidentiality
  - Rules: `azure_wa_security_private_endpoints`, `azure_wa_security_encryption`

### GCP Architecture Framework

#### Operational Excellence Pillar
- **OE-1** - Design for DevOps
  - Rules: `gcp_wa_opex_monitoring_enabled`, `gcp_wa_opex_logging_enabled`
- **OE-2** - Make informed decisions
  - Rules: `gcp_wa_opex_error_reporting`, `gcp_wa_opex_alert_policies`

#### Security Pillar
- **SE-1** - Build security foundations
  - Rules: `gcp_wa_security_command_center`, `gcp_wa_security_vpc_service_controls`
- **SE-2** - Secure your data
  - Rules: `gcp_wa_security_kms_rotation`, `gcp_wa_security_binary_authorization`

#### Reliability Pillar
- **RE-1** - Design for scale and high availability
  - Rules: `gcp_wa_reliability_regional_resources`, `gcp_wa_reliability_health_checks`
- **RE-2** - Design for recovery
  - Rules: `gcp_wa_reliability_sql_ha`, `gcp_wa_reliability_backup_configuration`

#### Performance Pillar
- **PE-1** - Design for performance
  - Rules: `gcp_wa_performance_cdn_enabled`, `gcp_wa_performance_memorystore`
- **PE-2** - Optimize for cost and performance
  - Rules: `gcp_wa_performance_ssd_disks`, `gcp_wa_performance_machine_types`

#### Cost Optimization Pillar
- **CO-1** - Plan to optimize costs
  - Rules: `gcp_wa_cost_resource_labels`, `gcp_wa_cost_committed_use`
- **CO-2** - Optimize your costs
  - Rules: `gcp_wa_cost_preemptible_vms`, `gcp_wa_cost_storage_class`

## Cross-Framework Mappings

### Security Controls Across Frameworks

| Security Area | CIS | HIPAA | PCI-DSS | SOC 2 | Well-Architected |
|---------------|-----|-------|---------|-------|------------------|
| **Encryption at Rest** | 2.1.1 (AWS) | 164.312(a)(2)(iv) | 3.4 | CC6.6 | SEC 08 (AWS) |
| **Encryption in Transit** | 2.1.2 (AWS) | 164.312(e)(2)(ii) | 4.1 | CC6.8 | SEC 09 (AWS) |
| **Multi-Factor Authentication** | 1.5, 1.6 (AWS) | 164.312(d) | 8.2.3 | CC6.2 | SEC 02 (AWS) |
| **Network Segmentation** | 4.1, 4.2 (AWS) | 164.308(a)(4)(i) | 1.2.1 | CC6.3 | SEC 05 (AWS) |
| **Audit Logging** | 3.1-3.9 (AWS) | 164.312(b) | 10.1, 10.2 | CC6.7 | SEC 04 (AWS) |
| **Access Control** | 1.8-1.10 (AWS) | 164.312(a)(1) | 7.1, 8.1 | CC6.1 | SEC 02 (AWS) |

### Compliance Framework Overlap

Many rules satisfy multiple compliance requirements:

- **Encryption Rules**: Often satisfy CIS, HIPAA, PCI-DSS, and SOC 2 requirements simultaneously
- **IAM Rules**: Cover CIS identity controls, HIPAA access controls, PCI-DSS authentication, and SOC 2 access management
- **Logging Rules**: Address CIS monitoring, HIPAA audit controls, PCI-DSS tracking, and SOC 2 system monitoring

## Using Compliance Mappings

### Compliance Reporting
```bash
# Generate compliance report with control mappings
riveter scan -p cis-aws -t main.tf --output-format json | jq '.results[] | select(.metadata.cis_control)'

# Filter by specific compliance area
riveter scan -p aws-hipaa -t main.tf --output-format json | jq '.results[] | select(.metadata.hipaa_control | contains("164.312"))'
```

### Audit Preparation
Use the mappings to:
1. Identify which rules address specific compliance controls
2. Generate evidence for auditors showing control implementation
3. Map remediation efforts to specific compliance requirements
4. Demonstrate coverage across multiple frameworks

### Gap Analysis
Compare rule pack coverage against compliance requirements to identify gaps in your infrastructure validation strategy.
