(core-concepts)=
# 📚 Core Concepts
:::{toctree}
:caption: Concepts
:hidden:

dataset.md
model.md
metrics/index.md
:::

HintEval enables users to generate and evaluate hints for their questions, helping detect better and more meaningful hints. With HintEval, you can:

1. Restructure your own datasets or question/answer pairs into a standardized format, making it easier to ensure reproducibility.
2. Generate synthetic hints for your questions using large language models.
3. Evaluate your hints using a variety of metrics that assess different aspects of hint quality from multiple angles.

:::{dropdown} What is a Hint?
Hints are clues that guide individuals toward a solution without explicitly providing the answer. They encourage critical thinking, reasoning, and memorization skills, as individuals engage in active problem-solving rather than passively receiving answers.
:::

:::{card} Dataset
:link: core-concepts-dataset
:link-type: ref
Learn how to convert your dataset into a structured format.
:::

:::{card} Model
:link: core-concepts-model
:link-type: ref
Discover how to generate more hints for testing and evaluation.
:::

:::{card} Metrics
:link: core-concepts-metric
:link-type: ref
Explore the available metrics and understand how they work.
:::