# Generated by Django 4.1.4 on 2023-01-26 08:17

import NearBeach.private_media
from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("auth", "0012_alter_user_first_name_max_length"),
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name="ChangeTask",
            fields=[
                (
                    "change_task_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("change_task_title", models.CharField(max_length=255)),
                (
                    "change_task_description",
                    models.TextField(blank=True, default="", null=True),
                ),
                ("change_task_start_date", models.DateTimeField()),
                ("change_task_end_date", models.DateTimeField()),
                ("change_task_seconds", models.BigIntegerField(default=0)),
                (
                    "change_task_required_by",
                    models.CharField(default="Stakeholder(s)", max_length=255),
                ),
                (
                    "change_task_status",
                    models.IntegerField(
                        choices=[
                            (1, "Draft"),
                            (2, "Waiting for approval"),
                            (3, "Approved"),
                            (4, "Started"),
                            (5, "Finished"),
                            (6, "Rejected"),
                            (7, "Paused"),
                        ]
                    ),
                ),
                ("is_downtime", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_task_assigned_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="change_assigned_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "change_task_qa_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="change_qa_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Customer",
            fields=[
                ("customer_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("customer_first_name", models.CharField(max_length=50)),
                ("customer_last_name", models.CharField(max_length=50)),
                ("customer_email", models.CharField(max_length=200)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Document",
            fields=[
                (
                    "document_key",
                    models.UUIDField(
                        default=uuid.uuid4,
                        editable=False,
                        primary_key=True,
                        serialize=False,
                    ),
                ),
                ("document_description", models.CharField(max_length=255)),
                (
                    "document_url_location",
                    models.TextField(blank=True, default="", null=True),
                ),
                (
                    "document",
                    models.FileField(
                        blank=True,
                        null=True,
                        storage=NearBeach.private_media.FileStorage(),
                        upload_to="",
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Group",
            fields=[
                ("group_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("group_name", models.CharField(max_length=50)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "parent_group",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.group",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="KanbanBoard",
            fields=[
                (
                    "kanban_board_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("kanban_board_name", models.CharField(max_length=255)),
                (
                    "kanban_board_status",
                    models.CharField(
                        choices=[("Open", "Open"), ("Closed", "Closed")],
                        default="Open",
                        max_length=10,
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="KanbanCard",
            fields=[
                (
                    "kanban_card_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("kanban_card_text", models.CharField(max_length=255)),
                ("kanban_card_description", models.TextField(blank=True, default="")),
                ("kanban_card_sort_number", models.IntegerField()),
                ("is_archived", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "kanban_board",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.kanbanboard",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfRequirementItemStatus",
            fields=[
                (
                    "requirement_item_status_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("requirement_item_status", models.CharField(max_length=100)),
                ("status_is_closed", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfRequirementItemType",
            fields=[
                (
                    "requirement_item_type_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("requirement_item_type", models.CharField(max_length=100)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfRequirementStatus",
            fields=[
                (
                    "requirement_status_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("requirement_status", models.CharField(max_length=50)),
                ("requirement_status_is_closed", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfRequirementType",
            fields=[
                (
                    "requirement_type_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("requirement_type", models.CharField(max_length=100)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfRFCStatus",
            fields=[
                (
                    "rfc_status_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("rfc_status", models.CharField(max_length=100)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Organisation",
            fields=[
                (
                    "organisation_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("organisation_name", models.CharField(max_length=255)),
                ("organisation_website", models.CharField(max_length=50)),
                ("organisation_email", models.CharField(max_length=100)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organisation_profile_picture",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.document",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="PermissionSet",
            fields=[
                (
                    "permission_set_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("permission_set_name", models.CharField(max_length=255)),
                (
                    "administration_assign_user_to_group",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "administration_create_group",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "administration_create_permission_set",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "administration_create_user",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "bug_client",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "customer",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "kanban_board",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "kanban_card",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "organisation",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "project",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "request_for_change",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "requirement",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "task",
                    models.IntegerField(
                        choices=[
                            (0, "No Permission"),
                            (1, "Read Only"),
                            (2, "Edit Only"),
                            (3, "Add and Edit"),
                            (4, "Full Permission"),
                        ],
                        default=0,
                    ),
                ),
                (
                    "document",
                    models.IntegerField(
                        choices=[(0, "No Permission"), (1, "Has Permission")], default=0
                    ),
                ),
                (
                    "kanban_comment",
                    models.IntegerField(
                        choices=[(0, "No Permission"), (1, "Has Permission")], default=0
                    ),
                ),
                (
                    "project_history",
                    models.IntegerField(
                        choices=[(0, "No Permission"), (1, "Has Permission")], default=0
                    ),
                ),
                (
                    "task_history",
                    models.IntegerField(
                        choices=[(0, "No Permission"), (1, "Has Permission")], default=0
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RequestForChange",
            fields=[
                ("rfc_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("rfc_title", models.CharField(max_length=255)),
                ("rfc_summary", models.TextField(verbose_name="rfc_summary")),
                (
                    "rfc_type",
                    models.IntegerField(
                        choices=[
                            (4, "Emergency"),
                            (3, "High"),
                            (2, "Medium"),
                            (1, "Low"),
                        ]
                    ),
                ),
                ("rfc_implementation_start_date", models.DateTimeField()),
                ("rfc_implementation_end_date", models.DateTimeField()),
                ("rfc_implementation_release_date", models.DateTimeField()),
                (
                    "rfc_version_number",
                    models.CharField(blank=True, max_length=25, null=True),
                ),
                (
                    "rfc_priority",
                    models.IntegerField(
                        choices=[
                            (4, "Critical"),
                            (3, "High"),
                            (2, "Medium"),
                            (1, "Low"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "rfc_risk",
                    models.IntegerField(
                        choices=[
                            (5, "Very High"),
                            (4, "High"),
                            (3, "Moderate"),
                            (2, "Low"),
                            (1, "None"),
                        ],
                        default=1,
                    ),
                ),
                (
                    "rfc_impact",
                    models.IntegerField(
                        choices=[(3, "High"), (2, "Medium"), (1, "Low")], default=1
                    ),
                ),
                (
                    "rfc_risk_and_impact_analysis",
                    models.TextField(verbose_name="rfc_risk_and_impact_analysis"),
                ),
                (
                    "rfc_implementation_plan",
                    models.TextField(verbose_name="rfc_implementation_plan"),
                ),
                ("rfc_backout_plan", models.TextField(verbose_name="rfc_backout_plan")),
                ("rfc_test_plan", models.TextField(verbose_name="rfc_test_plan")),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "rfc_lead",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="RfcLead",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "rfc_status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.listofrfcstatus",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Requirement",
            fields=[
                (
                    "requirement_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("requirement_title", models.CharField(max_length=255)),
                ("requirement_scope", models.TextField(blank=True, default="")),
                ("requirement_story_point_min", models.IntegerField(default=1)),
                ("requirement_story_point_max", models.IntegerField(default=4)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
                (
                    "requirement_status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.listofrequirementstatus",
                    ),
                ),
                (
                    "requirement_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.listofrequirementtype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Tag",
            fields=[
                ("tag_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("tag_name", models.CharField(max_length=50)),
                ("tag_colour", models.CharField(default="#651794", max_length=7)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Task",
            fields=[
                ("task_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("task_short_description", models.CharField(max_length=255)),
                ("task_long_description", models.TextField()),
                ("task_start_date", models.DateTimeField()),
                ("task_end_date", models.DateTimeField()),
                (
                    "task_status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("Backlog", "Backlog"),
                            ("Blocked", "Blocked"),
                            ("In Progress", "In Progress"),
                            ("Test/Review", "Test/Review"),
                            ("Closed", "Closed"),
                        ],
                        default="New",
                        max_length=15,
                    ),
                ),
                ("task_story_point_min", models.IntegerField(default=4)),
                ("task_story_point_max", models.IntegerField(default=10)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
                (
                    "task_assigned_to",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="UserProfilePicture",
            fields=[
                (
                    "username",
                    models.OneToOneField(
                        on_delete=django.db.models.deletion.CASCADE,
                        primary_key=True,
                        serialize=False,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "document",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.document",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="UserGroup",
            fields=[
                (
                    "user_group_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("group_leader", models.BooleanField(default=False)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.group",
                    ),
                ),
                (
                    "permission_set",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.permissionset",
                    ),
                ),
                (
                    "report_to",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="report_to",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "username",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TagAssignment",
            fields=[
                (
                    "tag_assignment_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                (
                    "object_enum",
                    models.CharField(
                        choices=[
                            ("requirement", "Requirement"),
                            ("RequirementItem", "Requirement Item"),
                            ("project", "Project"),
                            ("task", "Task"),
                            ("KanbanBoard", "Kanban Board"),
                            ("KanbanCard", "Kanban Card"),
                            ("RequestForChange", "Request for Change"),
                            ("customer", "Customer"),
                            ("organisation", "Organisation"),
                        ],
                        default="requirement",
                        max_length=40,
                    ),
                ),
                ("object_id", models.IntegerField(default=0)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="NearBeach.tag"
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RequirementItem",
            fields=[
                (
                    "requirement_item_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("requirement_item_title", models.CharField(max_length=255)),
                ("requirement_item_scope", models.TextField(blank=True, default="")),
                ("ri_story_point_min", models.IntegerField(default=4)),
                ("ri_story_point_max", models.IntegerField(default=10)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "requirement",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirement",
                    ),
                ),
                (
                    "requirement_item_status",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.listofrequirementitemstatus",
                    ),
                ),
                (
                    "requirement_item_type",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.listofrequirementitemtype",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="RequestForChangeGroupApproval",
            fields=[
                (
                    "rfc_group_approval_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                (
                    "approval",
                    models.IntegerField(
                        choices=[
                            (1, "Waiting"),
                            (2, "Approved"),
                            (3, "Rejected"),
                            (4, "Cancel"),
                        ],
                        default=1,
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.group",
                    ),
                ),
                (
                    "rfc",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requestforchange",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Project",
            fields=[
                ("project_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("project_name", models.CharField(max_length=255)),
                (
                    "project_description",
                    models.TextField(verbose_name="project_description"),
                ),
                ("project_start_date", models.DateTimeField()),
                ("project_end_date", models.DateTimeField()),
                (
                    "project_status",
                    models.CharField(
                        choices=[
                            ("New", "New"),
                            ("Backlog", "Backlog"),
                            ("Blocked", "Blocked"),
                            ("In Progress", "In Progress"),
                            ("Test/Review", "Test/Review"),
                            ("Closed", "Closed"),
                        ],
                        default="New",
                        max_length=15,
                    ),
                ),
                ("project_story_point_min", models.IntegerField(default=1)),
                ("project_story_point_max", models.IntegerField(default=4)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.customer",
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ObjectNote",
            fields=[
                (
                    "object_note_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("object_note", models.TextField(default="")),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "kanban_card",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.kanbancard",
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.project",
                    ),
                ),
                (
                    "request_for_change",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requestforchange",
                    ),
                ),
                (
                    "requirement",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirement",
                    ),
                ),
                (
                    "requirement_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirementitem",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.task",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ObjectAssignment",
            fields=[
                (
                    "object_assignment_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("meta_object", models.BigIntegerField(blank=True, null=True)),
                (
                    "meta_object_title",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "meta_object_status",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "assigned_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_assigned_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.customer",
                    ),
                ),
                (
                    "group_id",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.group",
                    ),
                ),
                (
                    "kanban_board",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.kanbanboard",
                    ),
                ),
                (
                    "kanban_card",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.kanbancard",
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.project",
                    ),
                ),
                (
                    "request_for_change",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requestforchange",
                    ),
                ),
                (
                    "requirement",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirement",
                    ),
                ),
                (
                    "requirement_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirementitem",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.task",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "notification_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("notification_header", models.CharField(max_length=255)),
                ("notification_message", models.TextField(blank=True, default="")),
                ("notification_start_date", models.DateTimeField()),
                ("notification_end_date", models.DateTimeField()),
                (
                    "notification_location",
                    models.CharField(
                        choices=[
                            ("All", "All"),
                            ("Login", "Login"),
                            ("Dashboard", "Dashboard"),
                        ],
                        default="All",
                        max_length=20,
                    ),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfTitle",
            fields=[
                ("title_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("title", models.CharField(max_length=10)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="ListOfBugClient",
            fields=[
                (
                    "list_of_bug_client_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("bug_client_name", models.CharField(max_length=50)),
                ("bug_client_api_url", models.CharField(max_length=255)),
                ("api_open_bugs", models.CharField(max_length=255)),
                ("api_search_bugs", models.CharField(max_length=255)),
                ("api_bug", models.CharField(max_length=255)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="KanbanLevel",
            fields=[
                (
                    "kanban_level_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("kanban_level_name", models.CharField(max_length=255)),
                ("kanban_level_sort_number", models.IntegerField()),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "kanban_board",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.kanbanboard",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="KanbanColumn",
            fields=[
                (
                    "kanban_column_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("kanban_column_name", models.CharField(max_length=255)),
                ("kanban_column_sort_number", models.IntegerField()),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "kanban_board",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.kanbanboard",
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="kanbancard",
            name="kanban_column",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="NearBeach.kanbancolumn"
            ),
        ),
        migrations.AddField(
            model_name="kanbancard",
            name="kanban_level",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="NearBeach.kanbanlevel"
            ),
        ),
        migrations.AddField(
            model_name="kanbancard",
            name="project",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.project",
            ),
        ),
        migrations.AddField(
            model_name="kanbancard",
            name="requirement",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.requirement",
            ),
        ),
        migrations.AddField(
            model_name="kanbancard",
            name="task",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.task",
            ),
        ),
        migrations.AddField(
            model_name="kanbanboard",
            name="requirement",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.requirement",
            ),
        ),
        migrations.CreateModel(
            name="GroupPermission",
            fields=[
                (
                    "group_permission_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "group",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.group",
                    ),
                ),
                (
                    "permission_set",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.permissionset",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Folder",
            fields=[
                ("folder_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("folder_description", models.CharField(max_length=255)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.customer",
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
                (
                    "parent_folder",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.folder",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.project",
                    ),
                ),
                (
                    "request_for_change",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requestforchange",
                    ),
                ),
                (
                    "requirement",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirement",
                    ),
                ),
                (
                    "requirement_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirementitem",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.task",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="DocumentPermission",
            fields=[
                (
                    "document_permisssion_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "customer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.customer",
                    ),
                ),
                (
                    "document_key",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.document",
                    ),
                ),
                (
                    "folder",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.folder",
                    ),
                ),
                (
                    "organisation",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.organisation",
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.project",
                    ),
                ),
                (
                    "request_for_change",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requestforchange",
                    ),
                ),
                (
                    "requirement",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirement",
                    ),
                ),
                (
                    "requirement_item",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirementitem",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.task",
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="customer",
            name="customer_profile_picture",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.document",
            ),
        ),
        migrations.AddField(
            model_name="customer",
            name="customer_title",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="NearBeach.listoftitle"
            ),
        ),
        migrations.AddField(
            model_name="customer",
            name="organisation",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.organisation",
            ),
        ),
        migrations.CreateModel(
            name="ChangeTaskBlock",
            fields=[
                (
                    "change_task_block_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "blocked_change_task",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="blocked_change_task",
                        to="NearBeach.changetask",
                    ),
                ),
                (
                    "change_task_blocks",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="change_task_blocks",
                        to="NearBeach.changetask",
                    ),
                ),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "creation_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_creation_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
        ),
        migrations.AddField(
            model_name="changetask",
            name="request_for_change",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.requestforchange",
            ),
        ),
        migrations.CreateModel(
            name="BugClient",
            fields=[
                (
                    "bug_client_id",
                    models.BigAutoField(primary_key=True, serialize=False),
                ),
                ("bug_client_name", models.CharField(max_length=50)),
                ("bug_client_url", models.URLField()),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "list_of_bug_client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.listofbugclient",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Bug",
            fields=[
                ("bug_id", models.BigAutoField(primary_key=True, serialize=False)),
                ("bug_code", models.CharField(max_length=255)),
                ("bug_description", models.TextField()),
                ("bug_status", models.CharField(max_length=50)),
                ("date_created", models.DateTimeField(auto_now_add=True)),
                ("date_modified", models.DateTimeField(auto_now=True)),
                ("is_deleted", models.BooleanField(default=False)),
                (
                    "bug_client",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.bugclient",
                    ),
                ),
                (
                    "change_user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="%(class)s_change_user",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "project",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.project",
                    ),
                ),
                (
                    "requirement",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.requirement",
                    ),
                ),
                (
                    "task",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="NearBeach.task",
                    ),
                ),
            ],
        ),
    ]
