# -*- coding: utf-8 -*-
# Generated by Django 1.10.2 on 2017-01-26 08:32
from __future__ import unicode_literals

from django.db import migrations


def initialise_data(apps, schema_editor):
    """
    The initial setup of the database should populate certain fields with
    the correct data. Otherwise certain features of the database will
    not function correctly.
    """
    db_alias = schema_editor.connection.alias

    # List of bug clients
    list_of_bug_client = apps.get_model("NearBeach", "ListOfBugClient")
    list_of_bug_client.objects.using(db_alias).bulk_create(
        [
            list_of_bug_client(
                bug_client_name="Bugzilla",
                bug_client_api_url="/rest/",
                api_open_bugs="?open_status=True",
                api_search_bugs="bug?quicksearch=",
                api_bug="/show_bug.cgi?id=",
            )
        ]
    )

    # List of requirement items status
    list_of_requirement_item_status = apps.get_model(
        "NearBeach", "ListOfRequirementItemStatus"
    )
    list_of_requirement_item_status.objects.using(db_alias).bulk_create(
        [
            list_of_requirement_item_status(requirement_item_status="Draft"),
            list_of_requirement_item_status(requirement_item_status="Review"),
            list_of_requirement_item_status(
                requirement_item_status="Developing/Working"
            ),
            list_of_requirement_item_status(requirement_item_status="Testing"),
            list_of_requirement_item_status(
                requirement_item_status="User Acceptance Testing"
            ),
            list_of_requirement_item_status(requirement_item_status="Rework"),
            list_of_requirement_item_status(requirement_item_status="Implemented"),
            list_of_requirement_item_status(requirement_item_status="Finish"),
            list_of_requirement_item_status(requirement_item_status="Not Tested"),
            list_of_requirement_item_status(requirement_item_status="Obsolete"),
        ]
    )

    # List of requirement items type
    list_of_requirement_item_type = apps.get_model(
        "NearBeach", "ListOfRequirementItemType"
    )
    list_of_requirement_item_type.objects.using(db_alias).bulk_create(
        [
            list_of_requirement_item_type(requirement_item_type="Informational"),
            list_of_requirement_item_type(requirement_item_type="Feature"),
            list_of_requirement_item_type(requirement_item_type="User Case"),
            list_of_requirement_item_type(requirement_item_type="User Interface"),
            list_of_requirement_item_type(requirement_item_type="Non Functional"),
            list_of_requirement_item_type(requirement_item_type="Constraint"),
            list_of_requirement_item_type(requirement_item_type="System Function"),
        ]
    )

    # List of requirement  status
    list_of_requirement_status = apps.get_model("NearBeach", "ListOfRequirementStatus")
    list_of_requirement_status.objects.using(db_alias).bulk_create(
        [
            list_of_requirement_status(requirement_status="Backlog"),
            list_of_requirement_status(requirement_status="Blocked"),
            list_of_requirement_status(requirement_status="In Progress"),
            list_of_requirement_status(requirement_status="Testing/Review"),
            list_of_requirement_status(
                requirement_status="Closed", requirement_status_is_closed=True
            ),
        ]
    )

    # List of requirement type
    list_of_requirement_type = apps.get_model("NearBeach", "ListOfRequirementType")
    list_of_requirement_type.objects.using(db_alias).bulk_create(
        [
            list_of_requirement_type(requirement_type="Non Specific"),
            list_of_requirement_type(requirement_type="Customer Requirements"),
            list_of_requirement_type(requirement_type="System Requirements"),
        ]
    )

    # List of titles
    list_of_titles = apps.get_model("NearBeach", "ListOfTitle")
    list_of_titles.objects.using(db_alias).bulk_create(
        [
            list_of_titles(title="Mr"),
            list_of_titles(title="Ms"),
            list_of_titles(title="Mrs"),
            list_of_titles(title="Mx"),
        ]
    )

    # List of RFC Status
    list_of_rfc_status = apps.get_model("NearBeach", "ListOfRFCStatus")
    list_of_rfc_status.objects.using(db_alias).bulk_create(
        [
            list_of_rfc_status(rfc_status_id=1, rfc_status="Draft"),
            list_of_rfc_status(rfc_status_id=2, rfc_status="Waiting for approval"),
            list_of_rfc_status(rfc_status_id=3, rfc_status="Approved"),
            list_of_rfc_status(rfc_status_id=4, rfc_status="Started"),
            list_of_rfc_status(rfc_status_id=5, rfc_status="Finished"),
            list_of_rfc_status(rfc_status_id=6, rfc_status="Rejected"),
            list_of_rfc_status(rfc_status_id=7, rfc_status="Paused"),
        ]
    )


class Migration(migrations.Migration):

    dependencies = [
        ("NearBeach", "0001_initial"),
    ]

    operations = [
        migrations.RunPython(initialise_data, reverse_code=migrations.RunPython.noop),
    ]
