# Generated by Django 5.0 on 2023-12-27 06:28

import django.db.models.deletion
from django.db import migrations, models


def update_foreign_key_status(app, schema_editor):
    """
    All foreign key status' have defaulted to the value 1. We will NEED to update them to the
    correct status. This will be applied for BOTH tasks and Projects
    """
    db_alias = schema_editor.connection.alias

    # Projects
    project = app.get_model("NearBeach", "Project")
    project.objects.filter(project_status="Backlog").update(status=2)
    project.objects.filter(project_status="Blocked").update(status=3)
    project.objects.filter(project_status="In Progress").update(status=4)
    project.objects.filter(project_status="Test/Review").update(status=5)
    project.objects.filter(project_status="Closed").update(status=6)

    # Tasks
    task = app.get_model("NearBeach", "Task")
    task.objects.filter(task_status="Backlog").update(status=2)
    task.objects.filter(task_status="Blocked").update(status=3)
    task.objects.filter(task_status="In Progress").update(status=4)
    task.objects.filter(task_status="Test/Review").update(status=5)
    task.objects.filter(task_status="Closed").update(status=6)

    # Requirement Item
    requirement_item = app.get_model("NearBeach", "ListOfRequirementItemStatus")
    requirement_item.objects.filter(pk=1).update(
        requirement_item_higher_order_status="Backlog",
        requirement_item_status_sort_order=1
    )
    requirement_item.objects.filter(pk=2).update(
        requirement_item_higher_order_status="Backlog",
        requirement_item_status_sort_order=2
    )
    requirement_item.objects.filter(pk=3).update(
        requirement_item_higher_order_status="Normal",
        requirement_item_status_sort_order=3
    )
    requirement_item.objects.filter(pk=4).update(
        requirement_item_higher_order_status="Normal",
        requirement_item_status_sort_order=4
    )
    requirement_item.objects.filter(pk=5).update(
        requirement_item_higher_order_status="Normal",
        requirement_item_status_sort_order=5
    )
    requirement_item.objects.filter(pk=6).update(
        requirement_item_higher_order_status="Normal",
        requirement_item_status_sort_order=6
    )
    requirement_item.objects.filter(pk=7).update(
        requirement_item_higher_order_status="Closed",
        requirement_item_status_sort_order=7
    )
    requirement_item.objects.filter(pk=8).update(
        requirement_item_higher_order_status="Closed",
        requirement_item_status_sort_order=8
    )
    requirement_item.objects.filter(pk=9).update(
        requirement_item_higher_order_status="Normal",
        requirement_item_status_sort_order=9
    )
    requirement_item.objects.filter(pk=10).update(
        requirement_item_higher_order_status="Closed",
        requirement_item_status_sort_order=10
    )

    # Requirement Item - User edited data
    requirement_item.objects.filter(status_is_closed=True).update(
        requirement_item_higher_order_status="Closed",
    )

    # Requirement
    requirement = app.get_model("NearBeach", "ListOfRequirementStatus")
    requirement.objects.filter(pk=1).update(
        requirement_higher_order_status="Backlog",
        requirement_status_sort_order=1,
    )
    requirement.objects.filter(pk=2).update(
        requirement_higher_order_status="Blocked",
        requirement_status_sort_order=2,
    )
    requirement.objects.filter(pk=3).update(
        requirement_higher_order_status="Normal",
        requirement_status_sort_order=3,
    )
    requirement.objects.filter(pk=4).update(
        requirement_higher_order_status="Normal",
        requirement_status_sort_order=4,
    )
    requirement.objects.filter(pk=5).update(
        requirement_higher_order_status="Closed",
        requirement_status_sort_order=5,
    )

    # Requirement - User edited data
    requirement.objects.filter(requirement_status_is_closed=True).update(
        requirement_higher_order_status="Closed",
    )


class Migration(migrations.Migration):
    dependencies = [
        ("NearBeach", "0020_alter_kanbancolumn_kanban_column_property_and_more"),
    ]

    operations = [
        migrations.AddField(
            model_name="project",
            name="status",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.listofprojectstatus",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="task",
            name="status",
            field=models.ForeignKey(
                default=1,
                on_delete=django.db.models.deletion.CASCADE,
                to="NearBeach.listoftaskstatus",
            ),
            preserve_default=False,
        ),
        migrations.AddField(
            model_name="listofrequirementitemstatus",
            name="requirement_item_higher_order_status",
            field=models.CharField(
                choices=[
                    ("Backlog", "Backlog"),
                    ("Normal", "Normal"),
                    ("Blocked", "Blocked"),
                    ("Closed", "Closed"),
                ],
                default="Normal",
                max_length=10,
            ),
        ),
        migrations.AddField(
            model_name="listofrequirementstatus",
            name="requirement_higher_order_status",
            field=models.CharField(
                choices=[
                    ("Backlog", "Backlog"),
                    ("Normal", "Normal"),
                    ("Blocked", "Blocked"),
                    ("Closed", "Closed"),
                ],
                default="Normal",
                max_length=10,
            ),
        ),
        migrations.AddField(
            model_name="listofrequirementitemstatus",
            name="requirement_item_status_sort_order",
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name="listofrequirementstatus",
            name="requirement_status_sort_order",
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.RunPython(update_foreign_key_status, reverse_code=migrations.RunPython.noop),
    ]
