# Generated by Django 5.0.7 on 2024-07-22 11:08

from django.db import migrations


def update_data(apps, schema_editor):
    """
    We have to update the administration permissions, so they are correct.
    The new permissions inside NearBeach will cause the user to check the
    permission table, and these fields have the default of 0.
    """
    db_alias = schema_editor.connection.alias

    # Permission Set
    permission_set = apps.get_model("NearBeach", "PermissionSet")
    permission_set.objects.using(db_alias).filter(
        permission_set_id=1,
    ).update(
        kanban_board=4,
        request_for_change=4,
        tag=4,
    )


class Migration(migrations.Migration):

    dependencies = [
        ("NearBeach", "0030_scheduledobject_schedule_object_title"),
    ]

    operations = [
        migrations.RunPython(update_data, reverse_code=migrations.RunPython.noop)
    ]
