# Generated by Django 5.2.4 on 2025-08-18 08:55

from django.db import migrations, models

def initialise_data(apps, schema_editor):
    """
    The administration permission set should have the "Scheduled Object" permissions set at 4
    """
    db_alias = schema_editor.connection.alias

    # Permission sets
    permission_set = apps.get_model("NearBeach", "PermissionSet")
    permission_set.objects.using(db_alias).filter(
        permission_set_id=1,
    ).update(
        schedule_object=4,
    )


class Migration(migrations.Migration):

    dependencies = [
        ("NearBeach", "0042_extendsauthtoken_delete_listofrfcstatus"),
    ]

    operations = [
        migrations.AddField(
            model_name="permissionset",
            name="schedule_object",
            field=models.IntegerField(
                choices=[
                    (0, "No Permission"),
                    (1, "Read Only"),
                    (2, "Edit Only"),
                    (3, "Add and Edit"),
                    (4, "Full Permission"),
                ],
                default=0,
            ),
        ),
        migrations.RunPython(initialise_data, reverse_code=migrations.RunPython.noop),
    ]
