"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["src_js_components_kanban_KanbanRow_vue-src_js_mixins_getThemeMixin_js"],{

/***/ "./src/js/components/kanban/KanbanColumn.vue":
/*!***************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumn.vue ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanColumn.vue?vue&type=template&id=158d34e9 */ "./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9");
/* harmony import */ var _KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanColumn.vue?vue&type=script&lang=js */ "./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/kanban/KanbanColumn.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuedraggable */ "./node_modules/vuedraggable/dist/vuedraggable.umd.js");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(vuedraggable__WEBPACK_IMPORTED_MODULE_3__);




//Mixins


//VUEX MAP GETTERS



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "KanbanColumn",
	components: {
		draggable: (vuedraggable__WEBPACK_IMPORTED_MODULE_3___default()),
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_1__.Icon,
	},
	props: {
		columnId: {
			type: Number,
			default: 0,
		},
		levelId: {
			type: Number,
			default: 0,
		},
		newCardInfo: {
			type: Array,
			default: () => {
				return [];
			},
		},
	},
	data() {
		return {
			//masterList: [],
			drag: false,
			priorityList: [
				'highest',
				'high',
				'normal',
				'low',
				'lowest',
			],
		};
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_4__.mapGetters)({
			allCards: "getCards",
			kanbanStatus: "getKanbanStatus",
			openCardOnLoad: "getOpenCardOnLoad",
			rootUrl: "getRootUrl",
		}),
		masterList() {
			//Filter the data
			let return_array = this.allCards.filter((card) => {
				return (
					parseInt(card.fields.kanban_column) === this.columnId &&
					parseInt(card.fields.kanban_level) === this.levelId
				);
			});

			//Make sure it is sorted
			return_array = return_array.sort((a, b) => {
				return (
					a.fields.kanban_card_sort_number -
					b.fields.kanban_card_sort_number
				);
			});

			return return_array;
		},
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_2__["default"]],
	methods: {
		checkCardOrder() {
			/* Due to an issue - sometimes some of the cards will contain a -1 for the sort order. This sadly
			throws a spanner into the dragging and dropping functionality. When the board boots up, we will check to
			make sure the cards are in order. If they are not - we adjust them and upload the changes.

			Checks
			~~~~~~
			1. Make sure there are no values under 0
			2. Make sure the lowest value is 0
			3. Make sure the highest value is length of the set minus 1.
			 */

			//Don't worry about it when masterList is empty
			if (this.masterList.length === 0) {
				//Escape
				return;
			}

			//Get the list of values for sort array
			const sort_array = this.masterList.map((row) => {
				return row.fields.kanban_card_sort_number;
			});

			//Get the min and max
			const min_value = Math.min.apply(null, sort_array),
				max_value = Math.max.apply(null, sort_array);

			if (
				min_value === 0 &&
				max_value === this.masterList.length - 1
			) {
				//Nothing to do :) YAY
				return;
			}

			//Show error screen
			document.getElementById("sort_error").style.display = "flex";

			//There is an issue - we need to fix all the variables and send that information upstream to the
			//backend AND the VueX
			//Loop through the data
			this.masterList.forEach((row, index) => {
				//Setup data_to_send
				const data_to_send = new FormData();
				data_to_send.set(
					"new_card_column",
					this.columnId.toString()
				);
				data_to_send.set("new_card_level", this.levelId.toString());
				data_to_send.set("new_card_sort_number", index.toString());
				data_to_send.set(
					"old_card_column",
					row.fields.kanban_column
				);
				data_to_send.set("old_card_level", row.fields.kanban_level);
				data_to_send.set(
					"old_card_sort_number",
					row.fields.kanban_card_sort_number
				);
				data_to_send.set("card_id", row.pk);

				//Update kanban card
				this.$store.commit({
					type: "updateKanbanCard",
					card_id: row.pk,
					kanban_column: this.columnId,
					kanban_level: this.levelId,
					kanban_card_sort_number: index,
				});

				//Use axios to send the data to the database
				this.axios.post(
					`${this.rootUrl}kanban_information/${row.pk}/move_card/`,
					data_to_send
				);
			});

			//Done - hide the error screen
			document.getElementById("sort_error").style.display = "";
		},
		doubleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return row.pk === data.target.dataset.cardId;
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
		isLinkedObject(object) {
			let results = "";

			if (object.fields.project !== null) results = "project";
			if (object.fields.requirement !== null) results = "requirement";
			if (object.fields.task !== null) results = "task";

			return results;
		},
		sendDataUpstream(filtered_data) {
			// Check to make sure this is a linked object
			const is_link = this.isLinkedObject(filtered_data);
			if (is_link.length > 0) {
				//Open a new tab with that linked object
				const url = `${this.rootUrl}${is_link}_information/${filtered_data.fields[is_link]}/`;

				window.open(
					url,
					'_blank'
				).focus();

				//Just return - nothing else to do
				return;
			}

			// Update VueX ACTION
			this.$store.dispatch({
				type: "updateCard",
				cardId: filtered_data.pk,
				cardTitle: filtered_data.fields.kanban_card_text,
				cardDescription:
				filtered_data.fields.kanban_card_description,
				cardColumn: filtered_data.fields.kanban_column,
				cardLevel: filtered_data.fields.kanban_level,
				cardLink: {},
				cardPriority: filtered_data.fields.kanban_card_priority,
			});

			//Show the modal
			const cardInformationModal = new bootstrap__WEBPACK_IMPORTED_MODULE_0__.Modal(
				document.getElementById("cardInformationModal")
			);
			cardInformationModal.show();
		},
		singleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return row.pk === data;
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
	},
	watch: {
		newCardInfo() {
			//Only add the card if the column and the level match
			if (
				this.columnId === this.newCardInfo[0].fields.kanban_column &&
				this.levelId === this.newCardInfo[0].fields.kanban_level
			) {
				//The new card is for this level and column. Add it to the masterList
				this.masterList.push(this.newCardInfo[0]);
			}
		},
	},
	mounted() {
		// this.checkCardOrder();

		//Check to see if the "openCardOnLoad" card ID exists on in this section
		const count = this.masterList.filter((row) => {
			//Conditions
			// 1 row primary key is the same as openCardOnLoad value
			// 2 row is not a linked object, i.e. not value under project, task, or requirement field
			const condition_1 = row.pk === this.openCardOnLoad;
			const condition_2 = this.isLinkedObject(row).length === 0;

			return condition_1 && condition_2;
		}).length;

		if (count > 0) {
			//Card exists here. Run function to open the card
			this.singleClickCard(this.openCardOnLoad);
		}
	},
});


/***/ }),

/***/ "./src/js/components/kanban/KanbanColumnDraggable.vue":
/*!************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumnDraggable.vue ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 */ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58");
/* harmony import */ var _KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanColumnDraggable.vue?vue&type=script&lang=js */ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/kanban/KanbanColumnDraggable.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vuedraggable */ "./node_modules/vuedraggable/dist/vuedraggable.umd.js");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(vuedraggable__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");






//Mixins


//VUEX MAP GETTERS


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "kanbanColumnDraggable",
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
		draggable: (vuedraggable__WEBPACK_IMPORTED_MODULE_1___default()),
	},
	props: {
		columnId: {
			type: Number,
			default: 0,
		},
		columnProperty: {
			type: String,
			default: "Normal",
		},
		levelId: {
			type: Number,
			default: 0,
		},
		newCardInfo: {
			type: Array,
			default: () => {
				return [];
			},
		},
	},
	data() {
		return {
			//masterList: [],
			drag: false,
			priorityList: [
				'highest',
				'high',
				'normal',
				'low',
				'lowest',
			],
		};
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_4__.mapGetters)({
			allCards: "getCards",
			canDragCards: "getCanDragCards",
			kanbanStatus: "getKanbanStatus",
			levelCollapseStatus: "getLevelCollapseStatus",
			openCardOnLoad: "getOpenCardOnLoad",
			rootUrl: "getRootUrl",
		}),
		dragOptions() {
			return {
				animation: 200,
				group: "description",
				disabled: false,
				ghostClass: "ghost"
			};
		},
		masterList() {
			return this.$store.getters.getCardsOrder(this.columnId, this.levelId);
		},
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_3__["default"]],
	methods: {
		addNewKanbanCard() {
			//Update the modal's data-attributes to reflect the column ID and Level ID
			const addKanbanCardModal =
				document.getElementById("addKanbanCardModal");
			addKanbanCardModal.dataset.kanbanLevel = this.levelId;
			addKanbanCardModal.dataset.kanbanColumn = this.columnId;

			//Get the Modal from the above modal
			const modalInstance = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(addKanbanCardModal);
			modalInstance.show();
		},
		addNewLink() {
			//Update the modal's data-attributes to reflect the column ID and Level ID
			const newLinkModal = document.getElementById("newLinkModal");
			newLinkModal.dataset.kanbanLevel = this.levelId;
			newLinkModal.dataset.kanbanColumn = this.columnId;

			//Get the Modal from the above modal
			const modalInstance = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(newLinkModal);
			modalInstance.show();
		},
		archiveCards() {
			//Send the archive destination to state - it will trigger the modal
			this.$store.commit({
				type: "updateArchiveDestination",
				column: this.columnId,
				level: this.levelId,
			});
		},
		checkCardOrder() {
			/* Due to an issue - sometimes some of the cards will contain a -1 for the sort order. This sadly
			throws a spanner into the dragging and dropping functionality. When the board boots up, we will check to
			make sure the cards are in order. If they are not - we adjust them and upload the changes.

			Checks
			~~~~~~
			1. Make sure there are no values under 0
			2. Make sure the lowest value is 0
			3. Make sure the highest value is length of the set minus 1.
			 */

			//Don't worry about it when masterList is empty
			if (this.masterList.length === 0) {
				//Escape
				return;
			}

			//Get the list of values for sort array
			const sort_array = this.masterList.map((row) => {
				return row.fields.kanban_card_sort_number;
			});

			//Get the min and max
			const min_value = Math.min.apply(null, sort_array),
				max_value = Math.max.apply(null, sort_array);

			if (
				min_value === 0 &&
				max_value === this.masterList.length - 1
			) {
				//Nothing to do :) YAY
				return;
			}

			//Show error screen
			document.getElementById("sort_error").style.display = "flex";

			//Send the new order to the backend
			const data_to_send = new FormData();

			this.masterList.forEach((row, index) => {
				//Set the form data
				data_to_send.append("kanban_cards", row.pk);

				//Update the VueX with the new sort ordering
				this.$store.commit({
					type: "updateKanbanCard",
					card_id: row.pk,
					kanban_card_sort_number: index,
				});
			});

			this.axios.post(
				`${this.rootUrl}kanban_information/fix_card_ordering/`,
				data_to_send,
			).catch((error) => {});

			//Done - hide the error screen
			document.getElementById("sort_error").style.display = "";
		},
		doubleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return parseInt(row.pk) === parseInt(data.target.dataset.cardId);
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
		isLinkedObject(object) {
			let results = "";

			if (object.fields.project !== null) results = "project";
			if (object.fields.requirement !== null) results = "requirement";
			if (object.fields.task !== null) results = "task";

			return results;
		},
		async onEnd(event) {
			//Tell VueX we have moved the card - VueX will handle the logistic. Wait for vuex
			await this.$store.dispatch("kanbanCardMoved", {
				event: event,
			});

			//Get the y=data
			const new_elem = event.to,
				old_elem = event.from,
				card_id = event.item.dataset.cardId;

			//Setup variables (for shorthand)
			let new_card_column = new_elem.dataset.column,
				new_card_level = new_elem.dataset.level,
				new_card_sort_number = event.newIndex,
				old_card_column = old_elem.dataset.column,
				old_card_level = old_elem.dataset.level,
				old_card_sort_number = event.oldIndex,
				column_property = new_elem.dataset.columnProperty;

			//Data to send
			const data_to_send = new FormData();
			data_to_send.set("new_card_column", new_card_column);
			data_to_send.set("new_card_level", new_card_level);

			//Set the new destination
			this.$store.getters.getCardsOrder(
				new_card_column,
				new_card_level
			).forEach((row) => {
				data_to_send.append("new_destination", row.pk);
			});

			//Set the old destination
			this.$store.getters.getCardsOrder(
				old_card_column,
				old_card_level
			).forEach((row) => {
				data_to_send.append("old_destination", row.pk);
			});

			//Use axios to send the data to the database
			this.axios.post(
				`${this.rootUrl}kanban_information/${card_id}/move_card/`,
				data_to_send
			).catch((error) => {});
		},
		sendDataUpstream(filtered_data) {
			// Check to make sure this is a linked object
			const is_link = this.isLinkedObject(filtered_data);
			if (is_link.length > 0) {
				//Open a new tab with that linked object
				const url = `${this.rootUrl}${is_link}_information/${filtered_data.fields[is_link]}/`;

				window.open(
					url,
					'_blank'
				).focus();

				//Just return - nothing else to do
				return;
			}


			// Update VueX ACTION
			this.$store.dispatch({
				type: "updateCard",
				cardId: filtered_data.pk,
				cardTitle: filtered_data.fields.kanban_card_text,
				cardDescription:
				filtered_data.fields.kanban_card_description,
				cardColumn: filtered_data.fields.kanban_column,
				cardLevel: filtered_data.fields.kanban_level,
				cardLink: {},
				cardPriority: filtered_data.fields.kanban_card_priority,
			});

			//Show the modal
			const cardInformationModal = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(
				document.getElementById("cardInformationModal")
			);
			cardInformationModal.show();
		},
		singleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return row.pk === data;
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
	},
	watch: {
		newCardInfo() {
			//Only add the card if the column and the level match
			if (
				this.columnId === this.newCardInfo[0].fields.kanban_column &&
				this.levelId === this.newCardInfo[0].fields.kanban_level
			) {
				//The new card is for this level and column. Add it to the masterList
				this.masterList.push(this.newCardInfo[0]);
			}
		},
	},
	mounted() {
		this.checkCardOrder();

		//Check to see if the "openCardOnLoad" card ID exists on in this section
		const count = this.masterList.filter((row) => {
			//Conditions
			// 1 row primary key is the same as openCardOnLoad value
			// 2 row is not a linked object, i.e. not value under project, task, or requirement field
			const condition_1 = row.pk === this.openCardOnLoad;
			const condition_2 = this.isLinkedObject(row).length === 0;

			return condition_1 && condition_2;
		}).length;

		if (count > 0) {
			//Card exists here. Run function to open the card
			this.singleClickCard(this.openCardOnLoad);
		}
	},
});


/***/ }),

/***/ "./src/js/components/kanban/KanbanRow.vue":
/*!************************************************!*\
  !*** ./src/js/components/kanban/KanbanRow.vue ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanRow.vue?vue&type=template&id=4b574152 */ "./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152");
/* harmony import */ var _KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanRow.vue?vue&type=script&lang=js */ "./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/kanban/KanbanRow.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _KanbanColumn_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanColumn.vue */ "./src/js/components/kanban/KanbanColumn.vue");
/* harmony import */ var _KanbanColumnDraggable_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanColumnDraggable.vue */ "./src/js/components/kanban/KanbanColumnDraggable.vue");





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "KanbanRow",
	components: {
		KanbanColumn: _KanbanColumn_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
		KanbanColumnDraggable: _KanbanColumnDraggable_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
	},
	props: {
		levelId: {
			type: Number,
			default: 0,
		},
		newCardInfo: {
			type: Array,
			default: () => {
				return [];
			},
		},
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_2__.mapGetters)({
			columnResults: "getColumnResults",
			userLevel: "getUserLevel",
		}),
	},
	methods: {
		doubleClickedCard(data) {
			//Emit the card id up stream
			this.$emit("double_clicked_card", data);
		},
	},
});


/***/ }),

/***/ "./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js":
/*!***************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumn.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js":
/*!************************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumnDraggable.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js":
/*!************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanRow.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9":
/*!*********************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9 ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumn.vue?vue&type=template&id=158d34e9 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9");


/***/ }),

/***/ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58":
/*!******************************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58");


/***/ }),

/***/ "./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152":
/*!******************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152 ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanRow.vue?vue&type=template&id=4b574152 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152");


/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9 ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = ["id", "data-level", "data-column"]
const _hoisted_2 = ["id", "data-sort-number", "data-card-id"]
const _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
    class: "list-group kanban-cell",
    id: `kanban_cell_${$props.levelId}_${$props.columnId}`,
    "data-level": $props.levelId,
    "data-column": $props.columnId
  }, [
    ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($options.masterList, (element) => {
      return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
        class: "list-group-item",
        key: element.pk,
        id: element.pk,
        "data-sort-number": element.fields.kanban_card_sort_number,
        "data-card-id": element.pk,
        onDblclick: _cache[0] || (_cache[0] = $event => ($options.doubleClickCard($event)))
      }, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
          class: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(`card-priority-line priority-${$data.priorityList[element.fields.kanban_card_priority]}`)
        }, null, 2 /* CLASS */),
        ($options.isLinkedObject(element))
          ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_Icon, {
              key: 0,
              icon: _ctx.icons.linkOut,
              "data-sort-number": element.fields.kanban_card_sort_number,
              "data-card-id": element.pk,
              class: "card-external-link"
            }, null, 8 /* PROPS */, ["icon", "data-sort-number", "data-card-id"]))
          : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, "#" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.pk), 1 /* TEXT */),
        _hoisted_3,
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.fields.kanban_card_text) + " ", 1 /* TEXT */),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
          class: "kanban-card-info-icon",
          icon: _ctx.icons.infoCircle,
          onClick: $event => ($options.singleClickCard(element.pk)),
          onDblclick: $event => ($options.singleClickCard(element.pk))
        }, null, 8 /* PROPS */, ["icon", "onClick", "onDblclick"])
      ], 40 /* PROPS, HYDRATE_EVENTS */, _hoisted_2))
    }), 128 /* KEYED_FRAGMENT */))
  ], 8 /* PROPS */, _hoisted_1))
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58":
/*!************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 ***!
  \************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = ["id", "data-sort-number", "data-card-id", "data-card-priority"]
const _hoisted_2 = ["data-card-id", "data-sort-number", "data-card-priority"]
const _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)
const _hoisted_4 = { class: "kanban-add-new-cards" }

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")
  const _component_draggable = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("draggable")

  return (!_ctx.levelCollapseStatus($props.levelId))
    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_draggable, {
        key: 0,
        class: "list-group kanban-cell",
        id: `kanban_cell_${$props.levelId}_${$props.columnId}`,
        "data-level": $props.levelId,
        "data-column": $props.columnId,
        "data-column-property": $props.columnProperty,
        animation: 200,
        disabled: _ctx.kanbanStatus === 'Closed' || !_ctx.canDragCards,
        group: "tasks",
        "ghost-class": "ghost",
        onEnd: _cache[4] || (_cache[4] = $event => ($options.onEnd($event))),
        modelValue: $options.masterList,
        "onUpdate:modelValue": _cache[5] || (_cache[5] = $event => (($options.masterList) = $event)),
        "item-key": "pk"
      }, {
        item: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(({ element }) => [
          ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
            class: "list-group-item",
            key: element.pk,
            id: element.pk,
            "data-sort-number": element.fields.kanban_card_sort_number,
            "data-card-id": element.pk,
            "data-card-priority": element.fields.kanban_card_priority,
            onDblclick: _cache[0] || (_cache[0] = $event => ($options.doubleClickCard($event)))
          }, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
              class: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(`card-priority-line priority-${$data.priorityList[element.fields.kanban_card_priority]}`),
              "data-card-id": element.pk,
              "data-sort-number": element.fields.kanban_card_sort_number,
              "data-card-priority": element.fields.kanban_card_priority
            }, null, 10 /* CLASS, PROPS */, _hoisted_2),
            ($options.isLinkedObject(element).length > 0)
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_Icon, {
                  key: 0,
                  icon: _ctx.icons.linkOut,
                  "data-card-id": element.pk,
                  "data-sort-number": element.fields.kanban_card_sort_number,
                  "data-card-priority": element.fields.kanban_card_priority,
                  class: "card-external-link"
                }, null, 8 /* PROPS */, ["icon", "data-card-id", "data-sort-number", "data-card-priority"]))
              : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, "#" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.pk), 1 /* TEXT */),
            _hoisted_3,
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.fields.kanban_card_text) + " ", 1 /* TEXT */),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
              class: "kanban-card-info-icon",
              icon: _ctx.icons.infoCircle,
              onClick: $event => ($options.singleClickCard(element.pk)),
              onDblclick: $event => ($options.singleClickCard(element.pk))
            }, null, 8 /* PROPS */, ["icon", "onClick", "onDblclick"])
          ], 40 /* PROPS, HYDRATE_EVENTS */, _hoisted_1))
        ]),
        footer: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(() => [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [
            ($props.columnProperty !== 'Closed')
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
                  key: 0,
                  class: "kanban-link btn btn-primary",
                  href: "javascript:void(0)",
                  onClick: _cache[1] || (_cache[1] = (...args) => ($options.addNewKanbanCard && $options.addNewKanbanCard(...args)))
                }, " New Card "))
              : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
            ($props.columnProperty !== 'Closed')
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
                  key: 1,
                  class: "kanban-link btn btn-warning",
                  href: "javascript:void(0)",
                  onClick: _cache[2] || (_cache[2] = (...args) => ($options.addNewLink && $options.addNewLink(...args)))
                }, " Link Object "))
              : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
            ($options.masterList.length > 0)
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
                  key: 2,
                  class: "kanban-link btn btn-danger",
                  href: "javascript:void(0)",
                  onClick: _cache[3] || (_cache[3] = (...args) => ($options.archiveCards && $options.archiveCards(...args)))
                }, " Archive Cards "))
              : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
          ])
        ]),
        _: 1 /* STABLE */
      }, 8 /* PROPS */, ["id", "data-level", "data-column", "data-column-property", "disabled", "modelValue"]))
    : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152":
/*!************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152 ***!
  \************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  key: 0,
  class: "kanban-row"
}
const _hoisted_2 = {
  key: 1,
  class: "kanban-row"
}

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_kanban_column_draggable = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("kanban-column-draggable")
  const _component_kanban_column = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("kanban-column")

  return (_ctx.userLevel > 1)
    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Users can edit kanban board - can drag "),
        ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(_ctx.columnResults, (column) => {
          return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_kanban_column_draggable, {
            key: column.pk,
            "level-id": $props.levelId,
            "column-id": column.pk,
            "column-property": column.fields.kanban_column_property,
            "new-card-info": $props.newCardInfo,
            onDouble_clicked_card: _cache[0] || (_cache[0] = $event => ($options.doubleClickedCard($event)))
          }, null, 8 /* PROPS */, ["level-id", "column-id", "column-property", "new-card-info"]))
        }), 128 /* KEYED_FRAGMENT */))
      ]))
    : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_2, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Read Only Users "),
        ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(_ctx.columnResults, (column) => {
          return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_kanban_column, {
            key: column.pk,
            "level-id": $props.levelId,
            "column-id": column.pk,
            "new-card-info": $props.newCardInfo,
            onDouble_clicked_card: _cache[1] || (_cache[1] = $event => ($options.doubleClickedCard($event)))
          }, null, 8 /* PROPS */, ["level-id", "column-id", "new-card-info"]))
        }), 128 /* KEYED_FRAGMENT */))
      ]))
}

/***/ }),

/***/ "./src/js/mixins/getThemeMixin.js":
/*!****************************************!*\
  !*** ./src/js/mixins/getThemeMixin.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var naive_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! naive-ui */ "./node_modules/naive-ui/es/themes/dark.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    data() {
        return {
            darkTheme: naive_ui__WEBPACK_IMPORTED_MODULE_0__.darkTheme,
        }
    },
    methods: {
        getTheme(theme) {
            //Depending on the theme depends what we send back
            switch (theme) {
                case "dark":
                    return naive_ui__WEBPACK_IMPORTED_MODULE_0__.darkTheme;
                default:
                    return null;
            }
        }
    }
});

/***/ }),

/***/ "./src/js/mixins/iconMixin.js":
/*!************************************!*\
  !*** ./src/js/mixins/iconMixin.js ***!
  \************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _iconify_icons_akar_icons_arrow_up__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify-icons/akar-icons/arrow-up */ "./node_modules/@iconify-icons/akar-icons/arrow-up.js");
/* harmony import */ var _iconify_icons_akar_icons_bug__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iconify/icons-akar-icons/bug */ "./node_modules/@iconify/icons-akar-icons/bug.js");
/* harmony import */ var _iconify_icons_bx_bx_briefcase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @iconify-icons/bx/bx-briefcase */ "./node_modules/@iconify-icons/bx/bx-briefcase.js");
/* harmony import */ var _iconify_icons_bi_card_checklist__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @iconify/icons-bi/card-checklist */ "./node_modules/@iconify/icons-bi/card-checklist.js");
/* harmony import */ var _iconify_icons_feather_clipboard__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @iconify/icons-feather/clipboard */ "./node_modules/@iconify/icons-feather/clipboard.js");
/* harmony import */ var _iconify_icons_carbon_document_pdf__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @iconify-icons/carbon/document-pdf */ "./node_modules/@iconify-icons/carbon/document-pdf.js");
/* harmony import */ var _iconify_icons_typcn_document_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @iconify-icons/typcn/document-text */ "./node_modules/@iconify-icons/typcn/document-text.js");
/* harmony import */ var _iconify_icons_akar_icons_folder__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @iconify-icons/akar-icons/folder */ "./node_modules/@iconify-icons/akar-icons/folder.js");
/* harmony import */ var _iconify_icons_carbon_group_presentation__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @iconify/icons-carbon/group-presentation */ "./node_modules/@iconify/icons-carbon/group-presentation.js");
/* harmony import */ var _iconify_icons_akar_icons_image__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @iconify-icons/akar-icons/image */ "./node_modules/@iconify-icons/akar-icons/image.js");
/* harmony import */ var _iconify_icons_bi_info_circle__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @iconify-icons/bi/info-circle */ "./node_modules/@iconify-icons/bi/info-circle.js");
/* harmony import */ var _iconify_icons_feather_link__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @iconify/icons-feather/link */ "./node_modules/@iconify/icons-feather/link.js");
/* harmony import */ var _iconify_icons_feather_link_2__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! @iconify/icons-feather/link-2 */ "./node_modules/@iconify/icons-feather/link-2.js");
/* harmony import */ var _iconify_icons_akar_icons_link_out__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! @iconify-icons/akar-icons/link-out */ "./node_modules/@iconify-icons/akar-icons/link-out.js");
/* harmony import */ var _iconify_icons_fe_mail__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! @iconify-icons/fe/mail */ "./node_modules/@iconify-icons/fe/mail.js");
/* harmony import */ var _iconify_icons_mdi_microsoft_excel__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! @iconify-icons/mdi/microsoft-excel */ "./node_modules/@iconify-icons/mdi/microsoft-excel.js");
/* harmony import */ var _iconify_icons_mdi_microsoft_powerpoint__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! @iconify-icons/mdi/microsoft-powerpoint */ "./node_modules/@iconify-icons/mdi/microsoft-powerpoint.js");
/* harmony import */ var _iconify_icons_mdi_microsoft_word__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @iconify-icons/mdi/microsoft-word */ "./node_modules/@iconify-icons/mdi/microsoft-word.js");
/* harmony import */ var _iconify_icons_cil_note_add__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! @iconify/icons-cil/note-add */ "./node_modules/@iconify/icons-cil/note-add.js");
/* harmony import */ var _iconify_icons_carbon_object_storage__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! @iconify/icons-carbon/object-storage */ "./node_modules/@iconify/icons-carbon/object-storage.js");
/* harmony import */ var _iconify_icons_carbon_password__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @iconify-icons/carbon/password */ "./node_modules/@iconify-icons/carbon/password.js");
/* harmony import */ var _iconify_icons_akar_icons_trash_can__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @iconify/icons-akar-icons/trash-can */ "./node_modules/@iconify/icons-akar-icons/trash-can.js");
/* harmony import */ var _iconify_icons_feather_user__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @iconify/icons-feather/user */ "./node_modules/@iconify/icons-feather/user.js");
/* harmony import */ var _iconify_icons_feather_users__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @iconify/icons-feather/users */ "./node_modules/@iconify/icons-feather/users.js");
/* harmony import */ var _iconify_icons_feather_x_circle__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @iconify-icons/feather/x-circle */ "./node_modules/@iconify-icons/feather/x-circle.js");
//Icons


























/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    data() {
        return {
            icons: {
                arrowUp: _iconify_icons_akar_icons_arrow_up__WEBPACK_IMPORTED_MODULE_0__["default"],
                bugIcon: _iconify_icons_akar_icons_bug__WEBPACK_IMPORTED_MODULE_1__["default"],
                bxBriefcase: _iconify_icons_bx_bx_briefcase__WEBPACK_IMPORTED_MODULE_2__["default"],
                cardChecklist: _iconify_icons_bi_card_checklist__WEBPACK_IMPORTED_MODULE_3__["default"],
                clipboardIcon: _iconify_icons_feather_clipboard__WEBPACK_IMPORTED_MODULE_4__["default"],
                documentPdf: _iconify_icons_carbon_document_pdf__WEBPACK_IMPORTED_MODULE_5__["default"],
                documentText: _iconify_icons_typcn_document_text__WEBPACK_IMPORTED_MODULE_6__["default"],
                folderIcon: _iconify_icons_akar_icons_folder__WEBPACK_IMPORTED_MODULE_7__["default"],
                groupPresentation: _iconify_icons_carbon_group_presentation__WEBPACK_IMPORTED_MODULE_8__["default"],
                imageIcon: _iconify_icons_akar_icons_image__WEBPACK_IMPORTED_MODULE_9__["default"],
                infoCircle: _iconify_icons_bi_info_circle__WEBPACK_IMPORTED_MODULE_10__["default"],
                linkIcon: _iconify_icons_feather_link__WEBPACK_IMPORTED_MODULE_11__["default"],
                linkIcon2: _iconify_icons_feather_link_2__WEBPACK_IMPORTED_MODULE_12__["default"],
                linkOut: _iconify_icons_akar_icons_link_out__WEBPACK_IMPORTED_MODULE_13__["default"],
                mailIcon: _iconify_icons_fe_mail__WEBPACK_IMPORTED_MODULE_14__["default"],
                microsoftExcel: _iconify_icons_mdi_microsoft_excel__WEBPACK_IMPORTED_MODULE_15__["default"],
                microsoftPowerpoint: _iconify_icons_mdi_microsoft_powerpoint__WEBPACK_IMPORTED_MODULE_16__["default"],
                microsoftWord: _iconify_icons_mdi_microsoft_word__WEBPACK_IMPORTED_MODULE_17__["default"],
                noteAdd: _iconify_icons_cil_note_add__WEBPACK_IMPORTED_MODULE_18__["default"],
                objectStorage: _iconify_icons_carbon_object_storage__WEBPACK_IMPORTED_MODULE_19__["default"],
                passwordIcon: _iconify_icons_carbon_password__WEBPACK_IMPORTED_MODULE_20__["default"],
                trashCan: _iconify_icons_akar_icons_trash_can__WEBPACK_IMPORTED_MODULE_21__["default"],
                userIcon: _iconify_icons_feather_user__WEBPACK_IMPORTED_MODULE_22__["default"],
                usersIcon: _iconify_icons_feather_users__WEBPACK_IMPORTED_MODULE_23__["default"],
                xCircle: _iconify_icons_feather_x_circle__WEBPACK_IMPORTED_MODULE_24__["default"],
            },
        };
    },
});


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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