"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["src_js_components_kanban_KanbanRow_vue"],{

/***/ "./src/js/components/kanban/KanbanColumn.vue":
/*!***************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumn.vue ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanColumn.vue?vue&type=template&id=158d34e9 */ "./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9");
/* harmony import */ var _KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanColumn.vue?vue&type=script&lang=js */ "./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/kanban/KanbanColumn.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuedraggable */ "./node_modules/vuedraggable/dist/vuedraggable.umd.js");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(vuedraggable__WEBPACK_IMPORTED_MODULE_3__);




//Mixins


//VUEX MAP GETTERS



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "KanbanColumn",
	components: {
		draggable: (vuedraggable__WEBPACK_IMPORTED_MODULE_3___default()),
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_1__.Icon,
	},
	props: {
		columnId: {
			type: Number,
			default: 0,
		},
		levelId: {
			type: Number,
			default: 0,
		},
		newCardInfo: {
			type: Array,
			default: () => {
				return [];
			},
		},
	},
	data() {
		return {
			//masterList: [],
			drag: false,
			priorityList: [
				'highest',
				'high',
				'normal',
				'low',
				'lowest',
			],
		};
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_4__.mapGetters)({
			allCards: "getCards",
			kanbanStatus: "getKanbanStatus",
			openCardOnLoad: "getOpenCardOnLoad",
			rootUrl: "getRootUrl",
		}),
		masterList() {
			//Filter the data
			let return_array = this.allCards.filter((card) => {
				return (
					parseInt(card.fields.kanban_column) === this.columnId &&
					parseInt(card.fields.kanban_level) === this.levelId
				);
			});

			//Make sure it is sorted
			return_array = return_array.sort((a, b) => {
				return (
					a.fields.kanban_card_sort_number -
					b.fields.kanban_card_sort_number
				);
			});

			return return_array;
		},
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_2__["default"]],
	methods: {
		checkCardOrder() {
			/* Due to an issue - sometimes some of the cards will contain a -1 for the sort order. This sadly
			throws a spanner into the dragging and dropping functionality. When the board boots up, we will check to
			make sure the cards are in order. If they are not - we adjust them and upload the changes.

			Checks
			~~~~~~
			1. Make sure there are no values under 0
			2. Make sure the lowest value is 0
			3. Make sure the highest value is length of the set minus 1.
			 */

			//Don't worry about it when masterList is empty
			if (this.masterList.length === 0) {
				//Escape
				return;
			}

			//Get the list of values for sort array
			const sort_array = this.masterList.map((row) => {
				return row.fields.kanban_card_sort_number;
			});

			//Get the min and max
			const min_value = Math.min.apply(null, sort_array),
				max_value = Math.max.apply(null, sort_array);

			if (
				min_value === 0 &&
				max_value === this.masterList.length - 1
			) {
				//Nothing to do :) YAY
				return;
			}

			//Show error screen
			document.getElementById("sort_error").style.display = "flex";

			//There is an issue - we need to fix all the variables and send that information upstream to the
			//backend AND the VueX
			//Loop through the data
			this.masterList.forEach((row, index) => {
				//Setup data_to_send
				const data_to_send = new FormData();
				data_to_send.set(
					"new_card_column",
					this.columnId.toString()
				);
				data_to_send.set("new_card_level", this.levelId.toString());
				data_to_send.set("new_card_sort_number", index.toString());
				data_to_send.set(
					"old_card_column",
					row.fields.kanban_column
				);
				data_to_send.set("old_card_level", row.fields.kanban_level);
				data_to_send.set(
					"old_card_sort_number",
					row.fields.kanban_card_sort_number
				);
				data_to_send.set("card_id", row.pk);

				//Update kanban card
				this.$store.commit({
					type: "updateKanbanCard",
					card_id: row.pk,
					kanban_column: this.columnId,
					kanban_level: this.levelId,
					kanban_card_sort_number: index,
				});

				//Use axios to send the data to the database
				this.axios.post(
					`${this.rootUrl}kanban_information/${row.pk}/move_card/`,
					data_to_send
				);
			});

			//Done - hide the error screen
			document.getElementById("sort_error").style.display = "";
		},
		doubleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return row.pk === data.target.dataset.cardId;
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
		isLinkedObject(object) {
			let results = "";

			if (object.fields.project !== null) results = "project";
			if (object.fields.requirement !== null) results = "requirement";
			if (object.fields.task !== null) results = "task";

			return results;
		},
		sendDataUpstream(filtered_data) {
			// Check to make sure this is a linked object
			const is_link = this.isLinkedObject(filtered_data);
			if (is_link.length > 0) {
				//Open a new tab with that linked object
				const url = `${this.rootUrl}${is_link}_information/${filtered_data.fields[is_link]}/`;

				window.open(
					url,
					'_blank'
				).focus();

				//Just return - nothing else to do
				return;
			}

			// Update VueX ACTION
			this.$store.dispatch({
				type: "updateCard",
				cardId: filtered_data.pk,
				cardTitle: filtered_data.fields.kanban_card_text,
				cardDescription:
				filtered_data.fields.kanban_card_description,
				cardColumn: filtered_data.fields.kanban_column,
				cardLevel: filtered_data.fields.kanban_level,
				cardLink: {},
				cardPriority: filtered_data.fields.kanban_card_priority,
			});

			//Show the modal
			const cardInformationModal = new bootstrap__WEBPACK_IMPORTED_MODULE_0__.Modal(
				document.getElementById("cardInformationModal")
			);
			cardInformationModal.show();
		},
		singleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return row.pk === data;
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
	},
	watch: {
		newCardInfo() {
			//Only add the card if the column and the level match
			if (
				this.columnId === this.newCardInfo[0].fields.kanban_column &&
				this.levelId === this.newCardInfo[0].fields.kanban_level
			) {
				//The new card is for this level and column. Add it to the masterList
				this.masterList.push(this.newCardInfo[0]);
			}
		},
	},
	mounted() {
		// this.checkCardOrder();

		//Check to see if the "openCardOnLoad" card ID exists on in this section
		const count = this.masterList.filter((row) => {
			//Conditions
			// 1 row primary key is the same as openCardOnLoad value
			// 2 row is not a linked object, i.e. not value under project, task, or requirement field
			const condition_1 = row.pk === this.openCardOnLoad;
			const condition_2 = this.isLinkedObject(row).length === 0;

			return condition_1 && condition_2;
		}).length;

		if (count > 0) {
			//Card exists here. Run function to open the card
			this.singleClickCard(this.openCardOnLoad);
		}
	},
});


/***/ }),

/***/ "./src/js/components/kanban/KanbanColumnDraggable.vue":
/*!************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumnDraggable.vue ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 */ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58");
/* harmony import */ var _KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanColumnDraggable.vue?vue&type=script&lang=js */ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/kanban/KanbanColumnDraggable.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vuedraggable */ "./node_modules/vuedraggable/dist/vuedraggable.umd.js");
/* harmony import */ var vuedraggable__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(vuedraggable__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");






//Mixins


//VUEX MAP GETTERS


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "kanbanColumnDraggable",
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
		draggable: (vuedraggable__WEBPACK_IMPORTED_MODULE_1___default()),
	},
	props: {
		columnId: {
			type: Number,
			default: 0,
		},
		columnProperty: {
			type: String,
			default: "Normal",
		},
		levelId: {
			type: Number,
			default: 0,
		},
		newCardInfo: {
			type: Array,
			default: () => {
				return [];
			},
		},
	},
	data() {
		return {
			//masterList: [],
			drag: false,
			priorityList: [
				'highest',
				'high',
				'normal',
				'low',
				'lowest',
			],
		};
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_4__.mapGetters)({
			allCards: "getCards",
			canDragCards: "getCanDragCards",
			kanbanStatus: "getKanbanStatus",
			levelCollapseStatus: "getLevelCollapseStatus",
			openCardOnLoad: "getOpenCardOnLoad",
			rootUrl: "getRootUrl",
		}),
		dragOptions() {
			return {
				animation: 200,
				group: "description",
				disabled: false,
				ghostClass: "ghost"
			};
		},
		masterList() {
			return this.$store.getters.getCardsOrder(this.columnId, this.levelId);
		},
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_3__["default"]],
	methods: {
		addNewKanbanCard() {
			//Update New Card VueX to use this location
			this.$store.commit({
				type: "updateNewCardLocation",
				columnId: this.columnId,
				levelId: this.levelId,
				userCanSelectLocation: false,
			});

			//Get the Modal from the above modal
			const modalInstance = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(document.getElementById("addKanbanCardModal"));
			modalInstance.show();
		},
		addNewLink() {
			//Update New Card VueX to use this location
			this.$store.commit({
				type: "updateNewCardLocation",
				columnId: this.columnId,
				levelId: this.levelId,
				userCanSelectLocation: false,
			});

			//Get the Modal from the above modal
			const modalInstance = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(document.getElementById("newLinkModal"));
			modalInstance.show();
		},
		archiveCards() {
			//Send the archive destination to state - it will trigger the modal
			this.$store.commit({
				type: "updateArchiveDestination",
				column: this.columnId,
				level: this.levelId,
			});
		},
		checkCardOrder() {
			/* Due to an issue - sometimes some of the cards will contain a -1 for the sort order. This sadly
			throws a spanner into the dragging and dropping functionality. When the board boots up, we will check to
			make sure the cards are in order. If they are not - we adjust them and upload the changes.

			Checks
			~~~~~~
			1. Make sure there are no values under 0
			2. Make sure the lowest value is 0
			3. Make sure the highest value is length of the set minus 1.
			 */

			//Don't worry about it when masterList is empty
			if (this.masterList.length === 0) {
				//Escape
				return;
			}

			//Get the list of values for sort array
			const sort_array = this.masterList.map((row) => {
				return row.fields.kanban_card_sort_number;
			});

			//Get the min and max
			const min_value = Math.min.apply(null, sort_array),
				max_value = Math.max.apply(null, sort_array);

			if (
				min_value === 0 &&
				max_value === this.masterList.length - 1
			) {
				//Nothing to do :) YAY
				return;
			}

			//Show error screen
			document.getElementById("sort_error").style.display = "flex";

			//Send the new order to the backend
			const data_to_send = new FormData();

			this.masterList.forEach((row, index) => {
				//Set the form data
				data_to_send.append("kanban_cards", row.pk);

				//Update the VueX with the new sort ordering
				this.$store.commit({
					type: "updateKanbanCard",
					card_id: row.pk,
					kanban_card_sort_number: index,
				});
			});

			this.axios.post(
				`${this.rootUrl}kanban_information/fix_card_ordering/`,
				data_to_send,
			).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Failed to move card",
					message: `Sorry, we could not move your card. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});

			//Done - hide the error screen
			document.getElementById("sort_error").style.display = "";
		},
		doubleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return parseInt(row.pk) === parseInt(data.target.dataset.cardId);
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
		isLinkedObject(object) {
			let results = "";

			if (object.fields.project !== null) results = "project";
			if (object.fields.requirement !== null) results = "requirement";
			if (object.fields.task !== null) results = "task";

			return results;
		},
		async onEnd(event) {
			//Tell VueX we have moved the card - VueX will handle the logistic. Wait for vuex
			await this.$store.dispatch("kanbanCardMoved", {
				event: event,
			});

			//Get the y=data
			const new_elem = event.to,
				old_elem = event.from,
				card_id = event.item.dataset.cardId;

			//Setup variables (for shorthand)
			let new_card_column = new_elem.dataset.column,
				new_card_level = new_elem.dataset.level,
				new_card_sort_number = event.newIndex,
				old_card_column = old_elem.dataset.column,
				old_card_level = old_elem.dataset.level,
				old_card_sort_number = event.oldIndex,
				column_property = new_elem.dataset.columnProperty;

			//Data to send
			const data_to_send = new FormData();
			data_to_send.set("new_card_column", new_card_column);
			data_to_send.set("new_card_level", new_card_level);

			//Set the new destination
			this.$store.getters.getCardsOrder(
				new_card_column,
				new_card_level
			).forEach((row) => {
				data_to_send.append("new_destination", row.pk);
			});

			//Set the old destination
			this.$store.getters.getCardsOrder(
				old_card_column,
				old_card_level
			).forEach((row) => {
				data_to_send.append("old_destination", row.pk);
			});

			//Use axios to send the data to the database
			this.axios.post(
				`${this.rootUrl}kanban_information/${card_id}/move_card/`,
				data_to_send
			).then(() => {
				if (column_property === "Blocked") {
					//Tell Axios about the card id
					this.$store.commit({
						type: "updateValue",
						field: "cardId",
						value: parseInt(card_id),
					});

					//Open the required modal
					const modal = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(document.getElementById("blockedNotesModal"));
					modal.show();
				}
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Can not update Card",
					message: `Sorry, moving the card had an error. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});
		},
		sendDataUpstream(filtered_data) {
			// Check to make sure this is a linked object
			const is_link = this.isLinkedObject(filtered_data);
			if (is_link.length > 0) {
				//Open a new tab with that linked object
				const url = `${this.rootUrl}${is_link}_information/${filtered_data.fields[is_link]}/`;

				window.open(
					url,
					'_blank'
				).focus();

				//Just return - nothing else to do
				return;
			}


			// Update VueX ACTION
			this.$store.dispatch({
				type: "updateCard",
				cardId: filtered_data.pk,
				cardTitle: filtered_data.fields.kanban_card_text,
				cardDescription:
				filtered_data.fields.kanban_card_description,
				cardColumn: filtered_data.fields.kanban_column,
				cardLevel: filtered_data.fields.kanban_level,
				cardLink: {},
				cardPriority: filtered_data.fields.kanban_card_priority,
			});

			//Show the modal
			const cardInformationModal = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(
				document.getElementById("cardInformationModal")
			);
			cardInformationModal.show();
		},
		singleClickCard(data) {
			//Filter out the data we want to send up stream
			const filtered_data = this.masterList.filter((row) => {
				return row.pk === data;
			})[0];

			//Setup data to send upstream
			this.sendDataUpstream(filtered_data);
		},
	},
	watch: {
		newCardInfo() {
			//Only add the card if the column and the level match
			if (
				this.columnId === this.newCardInfo[0].fields.kanban_column &&
				this.levelId === this.newCardInfo[0].fields.kanban_level
			) {
				//The new card is for this level and column. Add it to the masterList
				this.masterList.push(this.newCardInfo[0]);
			}
		},
	},
	mounted() {
		this.checkCardOrder();

		//Check to see if the "openCardOnLoad" card ID exists on in this section
		const count = this.masterList.filter((row) => {
			//Conditions
			// 1 row primary key is the same as openCardOnLoad value
			// 2 row is not a linked object, i.e. not value under project, task, or requirement field
			const condition_1 = row.pk === this.openCardOnLoad;
			const condition_2 = this.isLinkedObject(row).length === 0;

			return condition_1 && condition_2;
		}).length;

		if (count > 0) {
			//Card exists here. Run function to open the card
			this.singleClickCard(this.openCardOnLoad);
		}
	},
});


/***/ }),

/***/ "./src/js/components/kanban/KanbanRow.vue":
/*!************************************************!*\
  !*** ./src/js/components/kanban/KanbanRow.vue ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanRow.vue?vue&type=template&id=4b574152 */ "./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152");
/* harmony import */ var _KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanRow.vue?vue&type=script&lang=js */ "./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/kanban/KanbanRow.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js":
/*!********************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js ***!
  \********************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _KanbanColumn_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./KanbanColumn.vue */ "./src/js/components/kanban/KanbanColumn.vue");
/* harmony import */ var _KanbanColumnDraggable_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./KanbanColumnDraggable.vue */ "./src/js/components/kanban/KanbanColumnDraggable.vue");





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "KanbanRow",
	components: {
		KanbanColumn: _KanbanColumn_vue__WEBPACK_IMPORTED_MODULE_0__["default"],
		KanbanColumnDraggable: _KanbanColumnDraggable_vue__WEBPACK_IMPORTED_MODULE_1__["default"],
	},
	props: {
		levelId: {
			type: Number,
			default: 0,
		},
		newCardInfo: {
			type: Array,
			default: () => {
				return [];
			},
		},
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_2__.mapGetters)({
			columnResults: "getColumnResults",
			userLevel: "getUserLevel",
		}),
	},
	methods: {
		doubleClickedCard(data) {
			//Emit the card id up stream
			this.$emit("double_clicked_card", data);
		},
	},
});


/***/ }),

/***/ "./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js":
/*!***************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumn.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js":
/*!************************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumnDraggable.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js":
/*!************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanRow.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9":
/*!*********************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9 ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumn_vue_vue_type_template_id_158d34e9__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumn.vue?vue&type=template&id=158d34e9 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9");


/***/ }),

/***/ "./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58":
/*!******************************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 ***!
  \******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanColumnDraggable_vue_vue_type_template_id_77f64b58__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58");


/***/ }),

/***/ "./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152":
/*!******************************************************************************!*\
  !*** ./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152 ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_KanbanRow_vue_vue_type_template_id_4b574152__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./KanbanRow.vue?vue&type=template&id=4b574152 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152");


/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumn.vue?vue&type=template&id=158d34e9 ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = ["id", "data-level", "data-column"]
const _hoisted_2 = ["id", "data-sort-number", "data-card-id"]
const _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
    class: "list-group kanban-cell",
    id: `kanban_cell_${$props.levelId}_${$props.columnId}`,
    "data-level": $props.levelId,
    "data-column": $props.columnId
  }, [
    ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($options.masterList, (element) => {
      return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
        class: "list-group-item",
        key: element.pk,
        id: element.pk,
        "data-sort-number": element.fields.kanban_card_sort_number,
        "data-card-id": element.pk,
        onDblclick: _cache[0] || (_cache[0] = $event => ($options.doubleClickCard($event)))
      }, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
          class: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(`card-priority-line priority-${$data.priorityList[element.fields.kanban_card_priority]}`)
        }, null, 2 /* CLASS */),
        ($options.isLinkedObject(element))
          ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_Icon, {
              key: 0,
              icon: _ctx.icons.linkOut,
              "data-sort-number": element.fields.kanban_card_sort_number,
              "data-card-id": element.pk,
              class: "card-external-link"
            }, null, 8 /* PROPS */, ["icon", "data-sort-number", "data-card-id"]))
          : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, "#" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.pk), 1 /* TEXT */),
        _hoisted_3,
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.fields.kanban_card_text) + " ", 1 /* TEXT */),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
          class: "kanban-card-info-icon",
          icon: _ctx.icons.infoCircle,
          onClick: $event => ($options.singleClickCard(element.pk)),
          onDblclick: $event => ($options.singleClickCard(element.pk))
        }, null, 8 /* PROPS */, ["icon", "onClick", "onDblclick"])
      ], 40 /* PROPS, NEED_HYDRATION */, _hoisted_2))
    }), 128 /* KEYED_FRAGMENT */))
  ], 8 /* PROPS */, _hoisted_1))
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58":
/*!************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanColumnDraggable.vue?vue&type=template&id=77f64b58 ***!
  \************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = ["id", "data-sort-number", "data-card-id", "data-card-priority"]
const _hoisted_2 = ["data-card-id", "data-sort-number", "data-card-priority"]
const _hoisted_3 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)
const _hoisted_4 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)
const _hoisted_5 = {
  key: 1,
  style: {"font-weight":"lighter"}
}
const _hoisted_6 = {
  key: 2,
  style: {"font-weight":"lighter"}
}
const _hoisted_7 = { class: "kanban-add-new-cards" }

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")
  const _component_draggable = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("draggable")

  return (!_ctx.levelCollapseStatus($props.levelId))
    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_draggable, {
        key: 0,
        class: "list-group kanban-cell",
        id: `kanban_cell_${$props.levelId}_${$props.columnId}`,
        "data-level": $props.levelId,
        "data-column": $props.columnId,
        "data-column-property": $props.columnProperty,
        animation: 200,
        disabled: _ctx.kanbanStatus === 'Closed' || !_ctx.canDragCards,
        group: "tasks",
        "ghost-class": "ghost",
        onEnd: _cache[4] || (_cache[4] = $event => ($options.onEnd($event))),
        modelValue: $options.masterList,
        "onUpdate:modelValue": _cache[5] || (_cache[5] = $event => (($options.masterList) = $event)),
        "item-key": "pk"
      }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.createSlots)({
        item: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(({ element }) => [
          ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", {
            class: "list-group-item",
            key: element.pk,
            id: element.pk,
            "data-sort-number": element.fields.kanban_card_sort_number,
            "data-card-id": element.pk,
            "data-card-priority": element.fields.kanban_card_priority,
            onDblclick: _cache[0] || (_cache[0] = $event => ($options.doubleClickCard($event)))
          }, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
              class: (0,vue__WEBPACK_IMPORTED_MODULE_0__.normalizeClass)(`card-priority-line priority-${$data.priorityList[element.fields.kanban_card_priority]}`),
              "data-card-id": element.pk,
              "data-sort-number": element.fields.kanban_card_sort_number,
              "data-card-priority": element.fields.kanban_card_priority
            }, null, 10 /* CLASS, PROPS */, _hoisted_2),
            ($options.isLinkedObject(element).length > 0)
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_Icon, {
                  key: 0,
                  icon: _ctx.icons.linkOut,
                  "data-card-id": element.pk,
                  "data-sort-number": element.fields.kanban_card_sort_number,
                  "data-card-priority": element.fields.kanban_card_priority,
                  class: "card-external-link"
                }, null, 8 /* PROPS */, ["icon", "data-card-id", "data-sort-number", "data-card-priority"]))
              : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("b", null, "#" + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.pk), 1 /* TEXT */),
            _hoisted_3,
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(element.fields.kanban_card_text) + " ", 1 /* TEXT */),
            _hoisted_4,
            (!_ctx.canDragCards)
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_5, "- Movement Locked!"))
              : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_6, "   ")),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
              class: "kanban-card-info-icon",
              icon: _ctx.icons.infoCircle,
              onClick: $event => ($options.singleClickCard(element.pk)),
              onDblclick: $event => ($options.singleClickCard(element.pk))
            }, null, 8 /* PROPS */, ["icon", "onClick", "onDblclick"])
          ], 40 /* PROPS, NEED_HYDRATION */, _hoisted_1))
        ]),
        _: 2 /* DYNAMIC */
      }, [
        (_ctx.kanbanStatus !== 'Closed')
          ? {
              name: "footer",
              fn: (0,vue__WEBPACK_IMPORTED_MODULE_0__.withCtx)(() => [
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [
                  ($props.columnProperty !== 'Closed')
                    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
                        key: 0,
                        class: "kanban-link btn btn-primary",
                        href: "javascript:void(0)",
                        onClick: _cache[1] || (_cache[1] = (...args) => ($options.addNewKanbanCard && $options.addNewKanbanCard(...args)))
                      }, " New Card "))
                    : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
                  ($props.columnProperty !== 'Closed')
                    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
                        key: 1,
                        class: "kanban-link btn btn-warning",
                        href: "javascript:void(0)",
                        onClick: _cache[2] || (_cache[2] = (...args) => ($options.addNewLink && $options.addNewLink(...args)))
                      }, " Link Object "))
                    : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
                  ($options.masterList.length > 0)
                    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("a", {
                        key: 2,
                        class: "kanban-link btn btn-danger",
                        href: "javascript:void(0)",
                        onClick: _cache[3] || (_cache[3] = (...args) => ($options.archiveCards && $options.archiveCards(...args)))
                      }, " Archive Cards "))
                    : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
                ])
              ]),
              key: "0"
            }
          : undefined
      ]), 1032 /* PROPS, DYNAMIC_SLOTS */, ["id", "data-level", "data-column", "data-column-property", "disabled", "modelValue"]))
    : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152":
/*!************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/kanban/KanbanRow.vue?vue&type=template&id=4b574152 ***!
  \************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  key: 0,
  class: "kanban-row"
}
const _hoisted_2 = {
  key: 1,
  class: "kanban-row"
}

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_kanban_column_draggable = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("kanban-column-draggable")
  const _component_kanban_column = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("kanban-column")

  return (_ctx.userLevel > 1)
    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Users can edit kanban board - can drag "),
        ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(_ctx.columnResults, (column) => {
          return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_kanban_column_draggable, {
            key: column.pk,
            "level-id": $props.levelId,
            "column-id": column.pk,
            "column-property": column.fields.kanban_column_property,
            "new-card-info": $props.newCardInfo,
            onDouble_clicked_card: _cache[0] || (_cache[0] = $event => ($options.doubleClickedCard($event)))
          }, null, 8 /* PROPS */, ["level-id", "column-id", "column-property", "new-card-info"]))
        }), 128 /* KEYED_FRAGMENT */))
      ]))
    : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_2, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Read Only Users "),
        ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)(_ctx.columnResults, (column) => {
          return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createBlock)(_component_kanban_column, {
            key: column.pk,
            "level-id": $props.levelId,
            "column-id": column.pk,
            "new-card-info": $props.newCardInfo,
            onDouble_clicked_card: _cache[1] || (_cache[1] = $event => ($options.doubleClickedCard($event)))
          }, null, 8 /* PROPS */, ["level-id", "column-id", "new-card-info"]))
        }), 128 /* KEYED_FRAGMENT */))
      ]))
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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