"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["src_js_components_modules_sub_modules_ListPublicLinks_vue-src_js_components_modules_wizards_A-a8fa7b"],{

/***/ "./src/js/components/modules/sub_modules/ListPublicLinks.vue":
/*!*******************************************************************!*\
  !*** ./src/js/components/modules/sub_modules/ListPublicLinks.vue ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ListPublicLinks.vue?vue&type=template&id=35be5da7 */ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7");
/* harmony import */ var _ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ListPublicLinks.vue?vue&type=script&lang=js */ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/modules/sub_modules/ListPublicLinks.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");

//VueX


//Icon



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "ListPublicLinks",
	props: {
		overrideDestination: {
			type: String,
			default: "",
		},
		overrideLocationId: {
			type: Number,
			default: 0,
		},
	},
	data() {
		return {
			isFetchingData: true,
			publicLinkResults: [],
		};
	},
	watch: {
		overrideLocationId() {
			this.getPublicLinks();
		},
	},
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_2__.mapGetters)({
			destination: "getDestination",
			locationId: "getLocationId",
			rootUrl: "getRootUrl",
			userLevel: "getUserLevel",
		})
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__["default"]],
	methods: {
		async copyPublicLink(public_link_id) {
			//Get the URL
			const url = `${window.location.origin}${this.rootUrl}public/${this.getDestination()}/${this.getLocationId()}/${public_link_id}/`

			//Copy to the clipboard
			try {
				await navigator.clipboard.writeText(url);

				//Notify the user
				this.$store.dispatch("newToast", {
					header: "Public Link Copied",
					message: "Public Link has successfully copied to the clipboard",
					extra_classes: "bg-success",
				});
			} catch(error) {
				this.$store.dispatch("newToast", {
					header: "Can not copy public link",
					message: "Sorry, we failed to copy the public link",
					extra_classes: "bg-danger",
					delay: 0,
				});
			}
		},
		createPublicLink() {
			//Inform user of creating new link
			this.$store.dispatch("newToast", {
				header: "Creating New Toast",
				message: "Please wait whilst we create the toast",
				extra_classes: "bg-warning",
				delay: 0,
				unique_type: "create_public_link",
			});

			//Contact backend - get public link
			this.axios.post(
				`${this.rootUrl}public_data/${this.getDestination()}/${this.getLocationId()}/create/`,
			).then((response) => {
				//Inform user of success
				this.$store.dispatch("newToast", {
					header: "Successful new Public Link",
					message: "We have been able to create a new public link",
					extra_classes: "bg-success",
					unique_type: "create_public_link",
				});

				//Replace everything
				this.publicLinkResults = response.data;
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Can not create new public link",
					message: `Sorry, we failed to create the new public link. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
					unique_type: "create_public_link",
				});
			})
		},
		deletePublicLink(public_link_id) {
			//Construct data to send
			const data_to_send = new FormData();
			data_to_send.set("public_link_id", public_link_id);

			//Notify user we are deleting the data
			this.$store.dispatch("newToast", {
				header: "Deleting Public Link",
				message: "Deleting Public Link",
				extra_classes: "bg-warning",
				delay: 0,
				unique_type: "public_link_delete",
			})

			//Use axios
			this.axios.post(
				`${this.rootUrl}public_data/${this.getDestination()}/${this.getLocationId()}/delete/`,
				data_to_send,
			).then(() => {
				//Remove the row
				this.publicLinkResults = this.publicLinkResults.filter((row) => {
					return row.public_link_id !== public_link_id;
				});

				this.$store.dispatch("newToast", {
					header: "Successfully Deleted Public Link",
					message: "Successfully Deleted Public Link",
					extra_classes: "bg-success",
					unique_type: "public_link_delete",
				});
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error Deleting Public Link",
					message: `Error - could not delete link. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
					unique_type: "public_link_delete",
				});
			});
		},
		formatUrl(public_link_id) {
			//Double check we are getting the correct URL
			if (public_link_id === "" || public_link_id === undefined) {
				return "Data error!";
			}

			//Trucate the UUID - so if someone is viewing the screen they don't get the key
			const trunc_link_id = public_link_id.slice(0,7);

			return `${window.location.origin}${this.rootUrl}public/${this.getDestination()}/${this.getLocationId()}/${trunc_link_id}...`
		},
		getDestination() {
			return this.overrideDestination !== "" ? this.overrideDestination : this.destination;
		},
		getLocationId() {
			//If there is an overrideDestination - we want to use the overrideLocationId
			return this.overrideDestination !== "" ? this.overrideLocationId : this.locationId;
		},
		getPublicLinks() {
			this.axios(
				`${this.rootUrl}public_data/${this.getDestination()}/${this.getLocationId()}/get_links/`,
			).then((response) => {
				//Set the data
				this.publicLinkResults = response.data;

				//Set the fetch status to false
				this.isFetchingData = false;
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error fetching Public Links",
					message: `We had an issue fetching the public links for this object. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});
		},
		updateIsActive(event) {
			//Get the uuid
			const uuid = event.target.dataset.publicLinkId;

			//Tell the user we are updating the stats
			this.$store.dispatch("newToast", {
				header: "Updating Active Status for Private Link",
				message: "Please wait - we are updating the status",
				extra_classes: "bg-warning",
				delay: 0,
				unique_type: `is_active-${uuid}`,
			});

			//Translate the checked box
			let is_active = "False";
			if (event.target.checked) {
				is_active = "True";
			}

			//Setup data to send
			const data_to_send = new FormData();
			data_to_send.set("public_link_id", uuid);
			data_to_send.set("public_link_is_active", is_active);

			this.axios.post(
				`${this.rootUrl}public_data/update_link/`,
				data_to_send,
			).then(() => {
				//Update user
				this.$store.dispatch("newToast", {
					header: "Successfully Updated",
					message: "We have updated the is active status for the link",
					extra_classes: "bg-success",
					unique_type: `is_active-${uuid}`,
				});
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error Updating Active Status for Private Link",
					message: `We are sorry, something went wrong. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
					unique_type: `is_active-${uuid}`,
				});
			})
		},
	},
	mounted() {
		this.$nextTick(() => {
			this.getPublicLinks();
		})
	},
});


/***/ }),

/***/ "./src/js/components/modules/wizards/AddFolderWizard.vue":
/*!***************************************************************!*\
  !*** ./src/js/components/modules/wizards/AddFolderWizard.vue ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AddFolderWizard_vue_vue_type_template_id_0b928222__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AddFolderWizard.vue?vue&type=template&id=0b928222 */ "./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=template&id=0b928222");
/* harmony import */ var _AddFolderWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AddFolderWizard.vue?vue&type=script&lang=js */ "./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_AddFolderWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_AddFolderWizard_vue_vue_type_template_id_0b928222__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/modules/wizards/AddFolderWizard.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=script&lang=js":
/*!***********************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=script&lang=js ***!
  \***********************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _mixins_errorModalMixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../mixins/errorModalMixin */ "./src/js/mixins/errorModalMixin.js");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");



//VueX


//Mixins




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "AddFolderWizard",
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
	},
	props: {
		destination: {
			type: String,
			default: "/",
		},
		locationId: {
			type: Number,
			default: 0,
		},
	},
	mixins: [_mixins_errorModalMixin__WEBPACK_IMPORTED_MODULE_1__["default"], _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_2__["default"]],
	data() {
		return {
			disableAddFolderButton: true,
			folderDescriptionModel: "",
		};
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_4__.mapGetters)({
			existingFolders: "getFolderFilteredList",
			currentFolder: "getCurrentFolder",
			rootUrl: "getRootUrl",
		}),
	},
	methods: {
		addFolder() {
			//Construct the data to send
			const data_to_send = new FormData();
			data_to_send.set(
				"folder_description",
				this.folderDescriptionModel
			);

			if (this.currentFolder > 0) {
				data_to_send.set("parent_folder", this.currentFolder);
			}

			//Send the data in POST
			this.axios
				.post(
					`${this.rootUrl}documentation/${this.destination}/${this.locationId}/add_folder/`,
					data_to_send
				)
				.then((response) => {
					//Update the Folder List in VueX
					this.$store.dispatch("appendFolderList", {
						folderList: response.data[0],
					});

					//Clear the model
					this.folderDescriptionModel = "";

					//Close the modal
					document.getElementById("addFolderCloseButton").click();

					//Reshow the card information modal if exists
					let cardModal = document.getElementById("cardInformationModal");
					if (cardModal !== null)
					{
						cardModal = new bootstrap__WEBPACK_IMPORTED_MODULE_3__.Modal(cardModal);
						cardModal.show();
					}
				})
				.catch((error) => {
					this.showErrorModal(error, this.destination);
				});
		},
	},
	updated() {
		/*If there is no folder description OR the folder description already exists - we want to disable the add
		button.*/
		const match = this.existingFolders.filter((row) => {
			return (
				row.fields.folder_description === this.folderDescriptionModel
			);
		});

		this.disableAddFolderButton =
			match.length > 0 || this.folderDescriptionModel === "" || this.folderDescriptionModel === null;
	},
});


/***/ }),

/***/ "./src/js/components/modules/wizards/AddLinkWizard.vue":
/*!*************************************************************!*\
  !*** ./src/js/components/modules/wizards/AddLinkWizard.vue ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _AddLinkWizard_vue_vue_type_template_id_0cea12fb__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./AddLinkWizard.vue?vue&type=template&id=0cea12fb */ "./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=template&id=0cea12fb");
/* harmony import */ var _AddLinkWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./AddLinkWizard.vue?vue&type=script&lang=js */ "./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_AddLinkWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_AddLinkWizard_vue_vue_type_template_id_0cea12fb__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/modules/wizards/AddLinkWizard.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=script&lang=js":
/*!*********************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=script&lang=js ***!
  \*********************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var _vuelidate_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @vuelidate/core */ "./node_modules/@vuelidate/core/dist/index.mjs");
/* harmony import */ var _vuelidate_validators__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @vuelidate/validators */ "./node_modules/@vuelidate/validators/dist/index.mjs");
/* harmony import */ var _validation_ValidationRendering_vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../validation/ValidationRendering.vue */ "./src/js/components/validation/ValidationRendering.vue");
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");



//VueX


//Mixins


//Validation





/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "AddLinkWizard",
	setup() {
		return {v$: (0,_vuelidate_core__WEBPACK_IMPORTED_MODULE_2__["default"])()};
	},
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
		ValidationRendering: _validation_ValidationRendering_vue__WEBPACK_IMPORTED_MODULE_3__["default"],
	},
	props: {
		destination: {
			type: String,
			default: "/",
		},
		locationId: {
			type: Number,
			default: 0,
		},
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__["default"]],
	data() {
		return {
			linkModel: "",
			disableAddButton: true,
			documentDescriptionModel: "",
			documentUrlLocationModel: "",
			duplicateDescription: false,
		};
	},
	validations: {
		documentDescriptionModel: {
			required: _vuelidate_validators__WEBPACK_IMPORTED_MODULE_5__.required,
		},
		documentUrlLocationModel: {
			required: _vuelidate_validators__WEBPACK_IMPORTED_MODULE_5__.required,
			url: _vuelidate_validators__WEBPACK_IMPORTED_MODULE_5__.url,
		},
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_6__.mapGetters)({
			currentFolder: "getCurrentFolder",
			excludeDocuments: "getDocumentFilteredList",
			rootUrl: "getRootUrl",
		}),
	},
	methods: {
		addLink() {
			const data_to_send = new FormData();
			data_to_send.set(
				"document_description",
				this.documentDescriptionModel
			);
			data_to_send.set(
				"document_url_location",
				this.documentUrlLocationModel
			);

			//Only set the parent folder variable if there exists a variable in current folder
			if (this.currentFolder > 0) {
				data_to_send.set("parent_folder", this.currentFolder);
			}

			this.axios.post(
				`${this.rootUrl}documentation/${this.destination}/${this.locationId}/add_link/`,
				data_to_send
			).then((response) => {
				//Append something to document List
				this.$store.dispatch("appendDocumentList", {
					documentList: response.data[0],
				});

				//Clear the data
				this.documentDescriptionModel = "";
				this.documentUrlLocationModel = "";

				//Close the modal
				document.getElementById("addLinkCloseButton").click();

				//Reshow the card information modal if exists
				let cardModal = document.getElementById("cardInformationModal");
				if (cardModal !== null)
				{
					cardModal = new bootstrap__WEBPACK_IMPORTED_MODULE_4__.Modal(cardModal);
					cardModal.show();
				}
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error Adding Link",
					message: `Sorry, could not add the link for you. Error - ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});
		},
	},
	updated() {
		//We need to make sure both fields are not blank & to make sure the description is not duplicated
		const match = this.excludeDocuments.filter((row) => {
			return (
				row.document_key__document_description ===
				this.documentDescriptionModel
			);
		});

		//Notify the user of duplicate descriptions (if there is any)
		this.duplicateDescription = match.length > 0;

		// Check the validation
		this.v$.$touch();

		//Disable the button (if it does not meet our standards)
		this.disableAddButton = this.v$.$invalid || match.length > 0;
	},
});


/***/ }),

/***/ "./src/js/components/modules/wizards/ConfirmFileDelete.vue":
/*!*****************************************************************!*\
  !*** ./src/js/components/modules/wizards/ConfirmFileDelete.vue ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ConfirmFileDelete_vue_vue_type_template_id_14d3939c__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ConfirmFileDelete.vue?vue&type=template&id=14d3939c */ "./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=template&id=14d3939c");
/* harmony import */ var _ConfirmFileDelete_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ConfirmFileDelete.vue?vue&type=script&lang=js */ "./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ConfirmFileDelete_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ConfirmFileDelete_vue_vue_type_template_id_14d3939c__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/modules/wizards/ConfirmFileDelete.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=script&lang=js":
/*!*************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=script&lang=js ***!
  \*************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "ConfirmFileDelete",
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_1__.mapGetters)({
			destination: "getDestination",
			documentRemoveKey: "getDocumentRemoveKey",
			locationId: "getLocationId",
			rootUrl: "getRootUrl",
		})
	},
	methods: {
		deleteFile() {
			//Check to make sure it isn't blank
			if (this.documentRemoveKey === "") {
				//We don't want to remove a blank file
				return;
			}

			//Axios is a promise. It is not guaranteed that the documentRemoveKey will not be blanked out by the time
			//it has finished it's web query. Hence we cache this here. :)
			const cached_document_remove_key = this.documentRemoveKey;

			//Create data_to_send
			const data_to_send = new FormData();
			data_to_send.set("document_key", this.documentRemoveKey);

			this.axios.post(
				`${this.rootUrl}documentation/${this.destination}/${this.locationId}/remove/`,
				data_to_send,
			).then(() => {
				//Update VueX - remove that document from the list
				this.$store.dispatch("removeDocument", {
					document_key: cached_document_remove_key,
				});

				//Close the modal
				this.closeModal();
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error removing file",
					message: `We could not remove your file. Error - ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});

			this.closeModal();
		},
		closeModal() {
			//Zero out the document key (just in case)
			this.$store.commit({
				type: "updateDocumentRemoveKey",
				documentRemoveKey: "",
			});

			//Close the modal
			document.getElementById("confirmFileDeleteButton").click();

			//Reshow the card information modal if exists
			let cardModal = document.getElementById("cardInformationModal");
			if (cardModal !== null)
			{
				cardModal = new bootstrap__WEBPACK_IMPORTED_MODULE_0__.Modal(cardModal);
				cardModal.show();


			}

			//Due to a bug with bootstrap, we have two divs with classes "modal-backdrop fade show"
			//Lets remove one of them
			setTimeout(() => {
				const div_modal = document.getElementsByClassName("modal-backdrop fade show");
				if (div_modal.length > 1) {
					div_modal[0].remove();
				}
			}, 200);
		}
	},
});


/***/ }),

/***/ "./src/js/components/modules/wizards/UploadDocumentWizard.vue":
/*!********************************************************************!*\
  !*** ./src/js/components/modules/wizards/UploadDocumentWizard.vue ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _UploadDocumentWizard_vue_vue_type_template_id_4cebf53c__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./UploadDocumentWizard.vue?vue&type=template&id=4cebf53c */ "./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=template&id=4cebf53c");
/* harmony import */ var _UploadDocumentWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./UploadDocumentWizard.vue?vue&type=script&lang=js */ "./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_UploadDocumentWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_UploadDocumentWizard_vue_vue_type_template_id_4cebf53c__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/modules/wizards/UploadDocumentWizard.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=script&lang=js":
/*!****************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=script&lang=js ***!
  \****************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");
/* harmony import */ var bootstrap__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! bootstrap */ "./node_modules/bootstrap/dist/js/bootstrap.esm.js");



//VueX


//Mixins



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "UploadDocumentWizard",
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
	},
	props: {
		overrideDestination: {
			type: String,
			default: "",
		},
		overrideLocationId: {
			type: Number,
			default: 0,
		},
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__["default"]],
	data() {
		return {
			disableUploadButton: true,
			documentModel: [],
			documentDescriptionModel: "",
			uploadPercentage: "",
			maxUploadSize: 0,
			maxUploadString: "No Upload Limit",
			maxUploadWarning: false,
		};
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_3__.mapGetters)({
			acceptedDocuments: "getAcceptedDocuments",
			currentFolder: "getCurrentFolder",
			destination: "getDestination",
			excludeDocuments: "getDocumentFilteredList",
			locationId: "getLocationId",
			staticUrl: "getStaticUrl",
			rootUrl: "getRootUrl",
		}),
	},
	methods: {
		getDestination() {
			return this.overrideDestination !== "" ? this.overrideDestination : this.destination;
		},
		getLocationId() {
			//If there is an overrideDestination - we want to use the overrideLocationId
			return this.overrideDestination !== "" ? this.overrideLocationId : this.locationId;
		},
		handleFileUploads(fileList) {
			/*Check that the size of the fileList is not too big
			  The boolean (0!=this.maxUploadSize) will product a 0 result when maxUploadSize is 0. Thus negating
			  the need for an extra if statement*/
			if (
				fileList[0].size * (this.maxUploadSize !== 0) >
				this.maxUploadSize
			) {
				this.maxUploadWarning = true;

				//Just return
				return;
			}

			//Remove maxUploadWarning
			this.maxUploadWarning = false;

			//Update the document modal
			this.documentModel = fileList[0];

			//Extract the file name and place into the document description for the user
			this.documentDescriptionModel = fileList[0].name;
		},
		resetForm() {
			//Blank out all the models
			this.documentModel = "";
			this.documentDescriptionModel = "";
			this.uploadPercentage = "";
		},
		uploadFile() {
			//Create the data to send
			const data_to_send = new FormData();
			data_to_send.set(
				"document",
				this.documentModel,
				this.documentDescriptionModel
			);
			data_to_send.set(
				"document_description",
				this.documentDescriptionModel
			);

			//If there is a current/partent folder - then add it to the data to send
			if (this.currentFolder > 0) {
				data_to_send.set("parent_folder", this.currentFolder);
			}

			//Configuration for axios
			const config = {
				onUploadProgress: (progressEvent) => {
					//As the document gets uploaded - we want to update the upload Percentage
					this.uploadPercentage =
						parseFloat(progressEvent.loaded) /
						parseFloat(progressEvent.total);
				},
			};

			//Use axios to send it to the backend
			this.axios.post(
				`${this.rootUrl}documentation/${this.getDestination()}/${this.getLocationId()}/upload/`,
				data_to_send,
				config
			).then((response) => {
				//Append the new document to the existing document list
				this.$store.dispatch("appendDocumentList", {
					documentList: response.data[0],
				});

				//Close the modal
				document.getElementById("uploadDocumentCloseButton").click();

				//Reset the document
				this.resetForm();

				//Reshow the card information modal if exists
				let cardModal = document.getElementById("cardInformationModal");
				if (cardModal !== null)
				{
					cardModal = new bootstrap__WEBPACK_IMPORTED_MODULE_2__.Modal(cardModal);
					cardModal.show();
				}
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Failed to upload documentation",
					message: `Can not upload the documentation. ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});
		},
	},
	watch: {
		maxUploadSize() {
			//If the user has set 0 -> just say "No Upload Limit"
			if (this.maxUploadSize === 0) {
				return "No Upload Limit";
			}

			//Define the constants we wish to use
			const k = 1024;
			const sizes = [
				"Bytes",
				"KB",
				"MB",
				"GB",
				"TB",
				"PB",
				"EB",
				"ZB",
				"YB",
			];

			//Use math to find out which array section we are going to use from sizes
			const i = Math.floor(
				Math.log(this.maxUploadSize) / Math.log(k)
			);

			this.maxUploadString = `Max Upload Size: ${parseFloat(
				(this.maxUploadSize / Math.pow(k, i)).toFixed(2)
			)} ${sizes[i]}`;
		},
	},
	updated() {
		const match = this.excludeDocuments.filter((row) => {
			return (
				row.document_key__document_description ===
				this.documentDescriptionModel
			);
		});

		this.disableUploadButton =
			this.documentModel === "" ||
			this.documentDescriptionModel.length === 0 ||
			match.length > 0;
	},
	mounted() {
		//Wait a few seconds before getting the max file upload size
		this.$nextTick(() => {
			//Get the max file upload size
			this.axios.post(
				`${this.rootUrl}documentation/get/max_upload/`
			).then((response) => {
				//Set the value
				this.maxUploadSize = response.data.max_upload_size;
			}).catch(() => {
				this.$store.dispatch("newToast", {
					header: "Failed to get the max upload size",
					message: `Had an issue getting data from backend. ${this.maxUploadString}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});
		});
	},
});


/***/ }),

/***/ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js":
/*!*******************************************************************************************!*\
  !*** ./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./ListPublicLinks.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=script&lang=js":
/*!***************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=script&lang=js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddFolderWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddFolderWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./AddFolderWizard.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=script&lang=js":
/*!*************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=script&lang=js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddLinkWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddLinkWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./AddLinkWizard.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=script&lang=js":
/*!*****************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=script&lang=js ***!
  \*****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ConfirmFileDelete_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ConfirmFileDelete_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./ConfirmFileDelete.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=script&lang=js":
/*!********************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=script&lang=js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_UploadDocumentWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_UploadDocumentWizard_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./UploadDocumentWizard.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7":
/*!*************************************************************************************************!*\
  !*** ./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7 ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./ListPublicLinks.vue?vue&type=template&id=35be5da7 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7");


/***/ }),

/***/ "./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=template&id=0b928222":
/*!*********************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=template&id=0b928222 ***!
  \*********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddFolderWizard_vue_vue_type_template_id_0b928222__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddFolderWizard_vue_vue_type_template_id_0b928222__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./AddFolderWizard.vue?vue&type=template&id=0b928222 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=template&id=0b928222");


/***/ }),

/***/ "./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=template&id=0cea12fb":
/*!*******************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=template&id=0cea12fb ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddLinkWizard_vue_vue_type_template_id_0cea12fb__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_AddLinkWizard_vue_vue_type_template_id_0cea12fb__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./AddLinkWizard.vue?vue&type=template&id=0cea12fb */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=template&id=0cea12fb");


/***/ }),

/***/ "./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=template&id=14d3939c":
/*!***********************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=template&id=14d3939c ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ConfirmFileDelete_vue_vue_type_template_id_14d3939c__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ConfirmFileDelete_vue_vue_type_template_id_14d3939c__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./ConfirmFileDelete.vue?vue&type=template&id=14d3939c */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=template&id=14d3939c");


/***/ }),

/***/ "./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=template&id=4cebf53c":
/*!**************************************************************************************************!*\
  !*** ./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=template&id=4cebf53c ***!
  \**************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_UploadDocumentWizard_vue_vue_type_template_id_4cebf53c__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_UploadDocumentWizard_vue_vue_type_template_id_4cebf53c__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./UploadDocumentWizard.vue?vue&type=template&id=4cebf53c */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=template&id=4cebf53c");


/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7":
/*!*******************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7 ***!
  \*******************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  key: 0,
  class: "alert alert-info"
}
const _hoisted_2 = {
  key: 1,
  class: "alert alert-info"
}
const _hoisted_3 = {
  key: 2,
  class: "table table-striped"
}
const _hoisted_4 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Public Link", -1 /* HOISTED */)
const _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", { style: {"text-align":"center","width":"100px"} }, "Is Active", -1 /* HOISTED */)
const _hoisted_6 = {
  key: 0,
  style: {"width":"10px"}
}
const _hoisted_7 = ["onClick"]
const _hoisted_8 = { style: {"text-align":"center"} }
const _hoisted_9 = ["checked", "data-public-link-id"]
const _hoisted_10 = { key: 0 }
const _hoisted_11 = { class: "remove-link" }
const _hoisted_12 = { class: "row submit-row" }
const _hoisted_13 = { class: "col-md-12" }

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [
    ($data.isFetchingData)
      ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, "Currently loading data..."))
      : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
    ($data.isFetchingData === false && $data.publicLinkResults.length === 0)
      ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_2, " Sorry. There are no public links setup for this object. "))
      : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_3, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [
              _hoisted_4,
              _hoisted_5,
              (_ctx.userLevel > 1)
                ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", _hoisted_6))
                : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
            ])
          ]),
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [
            ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($data.publicLinkResults, (link) => {
              return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
                key: link.public_link_id
              }, [
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
                    type: "button",
                    class: "btn btn-link",
                    onClick: $event => ($options.copyPublicLink(link.public_link_id))
                  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($options.formatUrl(link.public_link_id)), 9 /* TEXT, PROPS */, _hoisted_7)
                ]),
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_8, [
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                    class: "form-check-input",
                    type: "checkbox",
                    checked: link.public_link_is_active,
                    "data-public-link-id": link.public_link_id,
                    onChange: _cache[0] || (_cache[0] = (...args) => ($options.updateIsActive && $options.updateIsActive(...args)))
                  }, null, 40 /* PROPS, HYDRATE_EVENTS */, _hoisted_9)
                ]),
                (_ctx.userLevel > 1)
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", _hoisted_10, [
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_11, [
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
                          icon: _ctx.icons.trashCan,
                          onClick: $event => ($options.deletePublicLink(link.public_link_id))
                        }, null, 8 /* PROPS */, ["icon", "onClick"])
                      ])
                    ]))
                  : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
              ]))
            }), 128 /* KEYED_FRAGMENT */))
          ])
        ])),
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_13, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
          class: "btn btn-primary save-changes",
          onClick: _cache[1] || (_cache[1] = (...args) => ($options.createPublicLink && $options.createPublicLink(...args)))
        }, " Create Public Link ")
      ])
    ])
  ], 64 /* STABLE_FRAGMENT */))
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=template&id=0b928222":
/*!***************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddFolderWizard.vue?vue&type=template&id=0b928222 ***!
  \***************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  class: "modal fade",
  id: "addFolderModal",
  tabindex: "-1",
  "aria-labelledby": "exampleModalLabel",
  "aria-hidden": "true"
}
const _hoisted_2 = { class: "modal-dialog modal-lg" }
const _hoisted_3 = { class: "modal-content" }
const _hoisted_4 = { class: "modal-header" }
const _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  type: "button",
  class: "btn-close",
  "data-bs-dismiss": "modal",
  "aria-label": "Close",
  id: "addFolderCloseButton"
}, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", { "aria-hidden": "true" })
], -1 /* HOISTED */)
const _hoisted_6 = { class: "modal-body" }
const _hoisted_7 = { class: "row" }
const _hoisted_8 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", { class: "col-md-4" }, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, "Creating a folder"),
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", { class: "text-instructions" }, " Give the folder an appropriate name. When done, click on the \"Save\" button. It will be added to the current folder. ")
], -1 /* HOISTED */)
const _hoisted_9 = { class: "col-md-8" }
const _hoisted_10 = { class: "form-group" }
const _hoisted_11 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", { for: "folder_description" }, "Folder Name", -1 /* HOISTED */)
const _hoisted_12 = { class: "modal-footer" }
const _hoisted_13 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  type: "button",
  class: "btn btn-secondary",
  "data-bs-dismiss": "modal"
}, " Close ", -1 /* HOISTED */)
const _hoisted_14 = ["disabled"]

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
              icon: _ctx.icons.userIcon
            }, null, 8 /* PROPS */, ["icon"]),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add Folder Wizard ")
          ]),
          _hoisted_5
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [
            _hoisted_8,
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [
                _hoisted_11,
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                  type: "text",
                  "onUpdate:modelValue": _cache[0] || (_cache[0] = $event => (($data.folderDescriptionModel) = $event)),
                  class: "form-control",
                  id: "folder_description",
                  maxlength: "50"
                }, null, 512 /* NEED_PATCH */), [
                  [vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $data.folderDescriptionModel]
                ])
              ])
            ])
          ])
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_12, [
          _hoisted_13,
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
            type: "button",
            class: "btn btn-primary",
            disabled: $data.disableAddFolderButton,
            onClick: _cache[1] || (_cache[1] = (...args) => ($options.addFolder && $options.addFolder(...args)))
          }, " Add Folder ", 8 /* PROPS */, _hoisted_14)
        ])
      ])
    ])
  ]))
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=template&id=0cea12fb":
/*!*************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/AddLinkWizard.vue?vue&type=template&id=0cea12fb ***!
  \*************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  class: "modal fade",
  id: "addLinkModal",
  tabindex: "-1",
  "aria-labelledby": "exampleModalLabel",
  "aria-hidden": "true"
}
const _hoisted_2 = { class: "modal-dialog modal-lg" }
const _hoisted_3 = { class: "modal-content" }
const _hoisted_4 = { class: "modal-header" }
const _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  type: "button",
  class: "btn-close",
  "data-bs-dismiss": "modal",
  "aria-label": "Close",
  id: "addLinkCloseButton"
}, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", { "aria-hidden": "true" })
], -1 /* HOISTED */)
const _hoisted_6 = { class: "modal-body" }
const _hoisted_7 = { class: "row" }
const _hoisted_8 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", { class: "col-md-4" }, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, "Add Link"),
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", { class: "text-instruction" }, " Add hyperlinks to other documents and sources located in on the internet/cloud. ")
], -1 /* HOISTED */)
const _hoisted_9 = { class: "col-md-8" }
const _hoisted_10 = { class: "form-group" }
const _hoisted_11 = { for: "document_description" }
const _hoisted_12 = {
  key: 0,
  class: "error"
}
const _hoisted_13 = { class: "form-group" }
const _hoisted_14 = { for: "document_url_location" }
const _hoisted_15 = { class: "modal-footer" }
const _hoisted_16 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  type: "button",
  class: "btn btn-secondary",
  "data-bs-dismiss": "modal"
}, " Close ", -1 /* HOISTED */)
const _hoisted_17 = ["disabled"]

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")
  const _component_validation_rendering = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("validation-rendering")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
              icon: _ctx.icons.userIcon
            }, null, 8 /* PROPS */, ["icon"]),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Add Link Wizard ")
          ]),
          _hoisted_5
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [
            _hoisted_8,
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_9, [
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_10, [
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_11, [
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Document Description "),
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_validation_rendering, {
                    "error-list": $setup.v$.documentDescriptionModel.$errors
                  }, null, 8 /* PROPS */, ["error-list"]),
                  ($data.duplicateDescription)
                    ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_12, " Sorry - but this is a duplicated description."))
                    : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
                ]),
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                  id: "document_description",
                  "onUpdate:modelValue": _cache[0] || (_cache[0] = $event => (($data.documentDescriptionModel) = $event)),
                  class: "form-control",
                  maxlength: "50",
                  placeholder: "NearBeach Homepage"
                }, null, 512 /* NEED_PATCH */), [
                  [vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $data.documentDescriptionModel]
                ])
              ]),
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_13, [
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_14, [
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Document URL "),
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_validation_rendering, {
                    "error-list": $setup.v$.documentUrlLocationModel.$errors
                  }, null, 8 /* PROPS */, ["error-list"])
                ]),
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                  id: "document_url_location",
                  "onUpdate:modelValue": _cache[1] || (_cache[1] = $event => (($data.documentUrlLocationModel) = $event)),
                  class: "form-control",
                  placeholder: "https://nearbeach.org"
                }, null, 512 /* NEED_PATCH */), [
                  [vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $data.documentUrlLocationModel]
                ])
              ])
            ])
          ])
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_15, [
          _hoisted_16,
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
            type: "button",
            class: "btn btn-primary",
            onClick: _cache[2] || (_cache[2] = (...args) => ($options.addLink && $options.addLink(...args))),
            disabled: $data.disableAddButton
          }, " Add Link ", 8 /* PROPS */, _hoisted_17)
        ])
      ])
    ])
  ]))
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=template&id=14d3939c":
/*!*****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/ConfirmFileDelete.vue?vue&type=template&id=14d3939c ***!
  \*****************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  class: "modal fade",
  id: "confirmFileDeleteModal",
  tabindex: "-1",
  "data-bs-backdrop": "static",
  "data-bs-keyboard": "false",
  "aria-labelledby": "confirmFileDelete",
  "aria-hidden": "true"
}
const _hoisted_2 = { class: "modal-dialog" }
const _hoisted_3 = { class: "modal-content" }
const _hoisted_4 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", { class: "modal-header" }, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h5", {
    class: "modal-title",
    id: "confirmFileDelete"
  }, " Please confirm File Deletion "),
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" TASK INFORMATION "),
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
    type: "button",
    class: "btn-close",
    "data-bs-dismiss": "modal",
    "aria-label": "Close",
    id: "confirmFileDeleteButton"
  })
], -1 /* HOISTED */)
const _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", { class: "modal-body" }, " Are you sure you want to delete the file? ", -1 /* HOISTED */)
const _hoisted_6 = { class: "modal-footer" }

function render(_ctx, _cache, $props, $setup, $data, $options) {
  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [
        _hoisted_4,
        _hoisted_5,
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
            type: "button",
            class: "btn btn-secondary",
            onClick: _cache[0] || (_cache[0] = (...args) => ($options.closeModal && $options.closeModal(...args)))
          }, " No "),
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
            type: "button",
            class: "btn btn-primary",
            onClick: _cache[1] || (_cache[1] = (...args) => ($options.deleteFile && $options.deleteFile(...args)))
          }, " Yes ")
        ])
      ])
    ])
  ]))
}

/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=template&id=4cebf53c":
/*!********************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/wizards/UploadDocumentWizard.vue?vue&type=template&id=4cebf53c ***!
  \********************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  class: "modal fade",
  id: "uploadDocumentModal",
  "data-bs-backdrop": "static",
  "data-bs-keyboard": "false",
  tabindex: "-1",
  "aria-labelledby": "exampleModalLabel",
  "aria-hidden": "true"
}
const _hoisted_2 = { class: "modal-dialog modal-lg" }
const _hoisted_3 = { class: "modal-content" }
const _hoisted_4 = { class: "modal-header" }
const _hoisted_5 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  type: "button",
  class: "btn-close",
  "data-bs-dismiss": "modal",
  "aria-label": "Close",
  id: "uploadDocumentCloseButton"
}, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", { "aria-hidden": "true" })
], -1 /* HOISTED */)
const _hoisted_6 = { class: "modal-body" }
const _hoisted_7 = { class: "row" }
const _hoisted_8 = { class: "col-md-4" }
const _hoisted_9 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("strong", null, "Uploading File", -1 /* HOISTED */)
const _hoisted_10 = { class: "text-instructions" }
const _hoisted_11 = { key: 0 }
const _hoisted_12 = { key: 1 }
const _hoisted_13 = { key: 2 }
const _hoisted_14 = { class: "col-md-8" }
const _hoisted_15 = {
  key: 0,
  class: "form-file"
}
const _hoisted_16 = { class: "mb-3" }
const _hoisted_17 = {
  for: "document",
  class: "form-label"
}
const _hoisted_18 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)
const _hoisted_19 = {
  key: 0,
  class: "alert alert-warning"
}
const _hoisted_20 = ["accept"]
const _hoisted_21 = {
  key: 1,
  class: "form-group"
}
const _hoisted_22 = { class: "form-group" }
const _hoisted_23 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", { for: "documentDescription" }, "Document Description", -1 /* HOISTED */)
const _hoisted_24 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("br", null, null, -1 /* HOISTED */)
const _hoisted_25 = { class: "form-row" }
const _hoisted_26 = { key: 2 }
const _hoisted_27 = {
  key: 0,
  class: "alert alert-warning"
}
const _hoisted_28 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", {
  class: "spinner-border text-primary",
  role: "status"
}, [
  /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", { class: "sr-only" }, "Loading...")
], -1 /* HOISTED */)
const _hoisted_29 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", { class: "alert alert-success" }, " The document has been uploaded. The server is currently writing the file to disk. Please be patient - this modal will close automatically. Thank you ", -1 /* HOISTED */)
const _hoisted_30 = { class: "modal-footer" }
const _hoisted_31 = /*#__PURE__*/(0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
  type: "button",
  class: "btn btn-secondary",
  "data-bs-dismiss": "modal"
}, " Close ", -1 /* HOISTED */)
const _hoisted_32 = ["disabled"]

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
              icon: _ctx.icons.userIcon
            }, null, 8 /* PROPS */, ["icon"]),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Upload Document Wizard ")
          ]),
          _hoisted_5
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_7, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [
              _hoisted_9,
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", _hoisted_10, " You will be able to upload a file against this " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($options.getDestination) + ". It will appear in the current folder. ", 1 /* TEXT */),
              ($data.documentModel.length === 0)
                ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_11, " 1. Please click on \"Upload File\" button to upload a file "))
                : ($data.uploadPercentage === '')
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_12, " 2. Please modify the document descript to be more human readable. Or click the \"Reset\" button to remove the uploaded file. "))
                  : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("p", _hoisted_13, " 3. Document is currently uploading. Please be patient. "))
            ]),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_14, [
              ($data.documentModel.length === 0)
                ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_15, [
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_16, [
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", _hoisted_17, [
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Please upload a file"),
                        _hoisted_18,
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($data.maxUploadString) + " ", 1 /* TEXT */),
                        ($data.maxUploadWarning)
                          ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_19, " Sorry - file too large "))
                          : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
                      ]),
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                        type: "file",
                        class: "form-control",
                        id: "document",
                        accept: _ctx.acceptedDocuments,
                        onChange: _cache[0] || (_cache[0] = $event => (
											$options.handleFileUploads(
												$event.target.files
											)
										))
                      }, null, 40 /* PROPS, HYDRATE_EVENTS */, _hoisted_20)
                    ])
                  ]))
                : ($data.uploadPercentage == '')
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_21, [
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" DOCUMENT DESCRIPTION "),
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_22, [
                        _hoisted_23,
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                          id: "documentDescription",
                          "onUpdate:modelValue": _cache[1] || (_cache[1] = $event => (($data.documentDescriptionModel) = $event)),
                          type: "text",
                          class: "form-control"
                        }, null, 512 /* NEED_PATCH */), [
                          [vue__WEBPACK_IMPORTED_MODULE_0__.vModelText, $data.documentDescriptionModel]
                        ])
                      ]),
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" RESET FORM BUTTON "),
                      _hoisted_24,
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_25, [
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
                          onClick: _cache[2] || (_cache[2] = (...args) => ($options.resetForm && $options.resetForm(...args))),
                          class: "btn btn-warning"
                        }, " Reset Form ")
                      ])
                    ]))
                  : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_26, [
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" THE UPLOAD SPINNER "),
                      (
										parseFloat($data.uploadPercentage).toFixed(
											0
										) < 1
									)
                        ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_27, [
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Uploading " + (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)((
											parseFloat($data.uploadPercentage) * 100
										).toFixed(2)) + "% ", 1 /* TEXT */),
                            _hoisted_28
                          ]))
                        : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, { key: 1 }, [
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" THE FINAL WRITING "),
                            _hoisted_29
                          ], 2112 /* STABLE_FRAGMENT, DEV_ROOT_FRAGMENT */))
                    ]))
            ])
          ])
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_30, [
          _hoisted_31,
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
            type: "button",
            class: "btn btn-primary",
            disabled: $data.disableUploadButton,
            onClick: _cache[3] || (_cache[3] = (...args) => ($options.uploadFile && $options.uploadFile(...args)))
          }, " Upload File ", 8 /* PROPS */, _hoisted_32)
        ])
      ])
    ])
  ]))
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3JjX2pzX2NvbXBvbmVudHNfbW9kdWxlc19zdWJfbW9kdWxlc19MaXN0UHVibGljTGlua3NfdnVlLXNyY19qc19jb21wb25lbnRzX21vZHVsZXNfd2l6YXJkc19BLWE4ZmE3Yi5taW4uanMiLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7OztBQUE0RTtBQUNWO0FBQ0w7O0FBRTdELENBQXlGO0FBQ3pGLGlDQUFpQyx5RkFBZSxDQUFDLG9GQUFNLGFBQWEsc0ZBQU07QUFDMUU7QUFDQSxJQUFJLEtBQVUsRUFBRSxFQVlmOzs7QUFHRCxpRUFBZTs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDeUNmLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUM2Qjs7QUFFbEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzZCO0FBQ2dCOztBQUVsRCxpRUFBZTtDQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7Q0FDdkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDTixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDcEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztFQUNaLENBQUM7RUFDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0VBQ1gsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7RUFDdEIsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUN0QixDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNYLENBQUMsQ0FBQyxDQUFDLENBQUM7Q0FDTCxDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDVCxDQUFDLENBQUMsQ0FBQyxnREFBVSxDQUFDO0dBQ2IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUM3QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3JCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQzFCLENBQUM7Q0FDRixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLHlEQUFTLENBQUM7Q0FDbkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ3BDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDWixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztHQUUvSCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3RCLENBQUMsQ0FBQyxFQUFFO0lBQ0gsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0lBRXhDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUM1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9ELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUM1QixDQUFDLENBQUM7R0FDSCxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ25ELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDMUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztJQUNULENBQUMsQ0FBQztHQUNIO0VBQ0QsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2xCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDakMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbEMsQ0FBQyxDQUFDOztHQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUNsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDdEYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDdkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNwQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3hELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMzQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsQ0FBQyxDQUFDOztJQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3ZDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDNUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMxQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0tBQ1IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2xDLENBQUMsQ0FBQztHQUNILENBQUM7RUFDRixDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUN2QixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ25DLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRWxELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDckMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzlCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbEMsQ0FBQzs7R0FFRCxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNWLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNyRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7SUFDZixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtLQUMvRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDN0MsQ0FBQyxDQUFDOztJQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDMUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDM0MsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNsQyxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3BDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMzRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7S0FDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsQ0FBQyxDQUFDO0dBQ0gsQ0FBQyxDQUFDO0VBQ0gsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDekIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUM1QyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtJQUMxRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNyQjs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUM5RSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRS9DLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUM1SCxDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDckYsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2YsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUMzRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUNuRixDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ1QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN6RixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ3BCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztJQUV0QyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzlCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDNUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUU7SUFDbkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3JDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDdkYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMxQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0lBQ1QsQ0FBQyxDQUFDO0dBQ0gsQ0FBQyxDQUFDO0VBQ0gsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ3JCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRTlDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtJQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbkQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2pDLENBQUMsQ0FBQzs7R0FFRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDMUIsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3ZCLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ3pCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbkI7O0dBRUEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ25DLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztHQUVwRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN6QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzlCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUM1RCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNqQyxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDdkQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNoRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7S0FDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pDLENBQUMsQ0FBQztHQUNILENBQUM7RUFDRixDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtHQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUN0QixDQUFDO0NBQ0YsQ0FBQztBQUNGLENBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2xTMkU7QUFDVjtBQUNMOztBQUU3RCxDQUF5RjtBQUN6RixpQ0FBaUMseUZBQWUsQ0FBQyxvRkFBTSxhQUFhLHNGQUFNO0FBQzFFO0FBQ0EsSUFBSSxLQUFVLEVBQUUsRUFZZjs7O0FBR0QsaUVBQWU7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDcURtQjs7QUFFbEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzJCOztBQUVoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQ3VEO0FBQ1o7QUFDbEI7O0FBRWhDLGlFQUFlO0NBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztDQUN2QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDWCxDQUFDLENBQUMsQ0FBQyxDQUFDO0NBQ0wsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDWixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDWixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7RUFDYixDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ1gsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7RUFDWCxDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQywrREFBZSxFQUFFLHlEQUFTLENBQUM7Q0FDcEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDTixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzVCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7RUFDM0IsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNULENBQUMsQ0FBQyxDQUFDLGdEQUFVLENBQUM7R0FDYixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN4QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDakMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ3RCLENBQUMsQ0FBQztDQUNILENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDWCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNuQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2YsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3BCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUMzQixDQUFDOztHQUVELENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFO0lBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDdEQ7O0dBRUEsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDdEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDSixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNqRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDWjtJQUNBLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0tBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztLQUMvQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO01BQ3hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzdCLENBQUMsQ0FBQzs7S0FFRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDaEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7O0tBRWhDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztLQUV2RCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDNUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDL0QsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUN0QjtNQUNDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsNENBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO01BQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDakI7SUFDRCxDQUFDO0lBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtLQUNqQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzdDLENBQUMsQ0FBQztFQUNKLENBQUM7Q0FDRixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDVCxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7RUFDeEcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ1IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtHQUNsRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtJQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDN0QsQ0FBQztFQUNGLENBQUMsQ0FBQzs7RUFFRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUMzQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztDQUNoRyxDQUFDO0FBQ0YsQ0FBQyxFQUFDOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUMxS3dFO0FBQ1Y7QUFDTDs7QUFFM0QsQ0FBeUY7QUFDekYsaUNBQWlDLHlGQUFlLENBQUMsa0ZBQU0sYUFBYSxvRkFBTTtBQUMxRTtBQUNBLElBQUksS0FBVSxFQUFFLEVBWWY7OztBQUdELGlFQUFlOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDNEVtQjs7QUFFbEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzJCOztBQUVoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzJDOztBQUVsRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDZ0M7QUFDUztBQUN1QjtBQUMzQzs7QUFFaEMsaUVBQWU7Q0FDZCxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7Q0FDckIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNQLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsMkRBQVksQ0FBQyxDQUFDLENBQUM7Q0FDNUIsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNYLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDSixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0NBQ3BCLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0VBQ2IsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNYLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0VBQ1gsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMseURBQVMsQ0FBQztDQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDYixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN0QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUM1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUM1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDNUIsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDekIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ1QsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDekIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ1IsQ0FBQyxDQUFDLENBQUM7RUFDSixDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1QsQ0FBQyxDQUFDLENBQUMsZ0RBQVUsQ0FBQztHQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNqQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUMzQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDdEIsQ0FBQyxDQUFDO0NBQ0gsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNSLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ1QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNuQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2YsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzdCLENBQUM7R0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2YsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3ZCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDN0IsQ0FBQzs7R0FFRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDakYsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUU7SUFDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN0RDs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0UsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUMxQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0IsQ0FBQyxDQUFDOztJQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDZixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7SUFDbEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDOztJQUVsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDaEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztJQUVyRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0QsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0QjtLQUNDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsNENBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakI7R0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNsRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDVCxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUM7RUFDSCxDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1QsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDaEcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0dBQ25ELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUN6QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzdCLENBQUM7RUFDRixDQUFDLENBQUM7O0VBRUYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7RUFDNUQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQzs7RUFFNUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUN0QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztFQUVoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ3ZELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDO0NBQzdELENBQUM7QUFDRixDQUFDLEVBQUM7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ2pPNEU7QUFDVjtBQUNMOztBQUUvRCxDQUF5RjtBQUN6RixpQ0FBaUMseUZBQWUsQ0FBQyxzRkFBTSxhQUFhLHdGQUFNO0FBQzFFO0FBQ0EsSUFBSSxLQUFVLEVBQUUsRUFZZjs7O0FBR0QsaUVBQWU7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDK0JpQjtBQUNBOztBQUVoQyxpRUFBZTtDQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0NBQ3pCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1QsQ0FBQyxDQUFDLENBQUMsZ0RBQVUsQ0FBQztHQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDN0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN6QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ3RCLENBQUM7Q0FDRixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDWixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2xDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUU7SUFDbEMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDckMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDUDs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDeEcsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0dBQzdELENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztHQUV6RCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3BCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbkMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzs7R0FFeEQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDZCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDN0UsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDYixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUU7SUFDWixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7SUFDakQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ3RDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3pDLENBQUMsQ0FBQzs7SUFFRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDaEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2xCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDN0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMxRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDVCxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUM7O0dBRUYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ2xCLENBQUM7RUFDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDekMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNsQixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUMvQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDdEIsQ0FBQyxDQUFDOztHQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztHQUUxRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDNUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDL0QsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN0QjtJQUNDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsNENBQUssQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7OztHQUdqQjs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN0RixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDeEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUU7SUFDaEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDN0UsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsRUFBRTtLQUN6QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0QjtHQUNELENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ1I7Q0FDRCxDQUFDO0FBQ0YsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FDdElnRjtBQUNWO0FBQ0w7O0FBRWxFLENBQXlGO0FBQ3pGLGlDQUFpQyx5RkFBZSxDQUFDLHlGQUFNLGFBQWEsMkZBQU07QUFDMUU7QUFDQSxJQUFJLEtBQVUsRUFBRSxFQVlmOzs7QUFHRCxpRUFBZTs7Ozs7Ozs7Ozs7Ozs7Ozs7OztBQ3NKbUI7O0FBRWxDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUMyQjs7QUFFaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztBQUMyQztBQUNsQjs7QUFFaEMsaUVBQWU7Q0FDZCxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztDQUM1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDWCxDQUFDLENBQUMsQ0FBQyxDQUFDO0NBQ0wsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ3BCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7RUFDWixDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDWixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztFQUNYLENBQUM7Q0FDRixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLHlEQUFTLENBQUM7Q0FDbkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDTixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3pCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDakIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDNUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztHQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2xDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDeEIsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNULENBQUMsQ0FBQyxDQUFDLGdEQUFVLENBQUM7R0FDYixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3pDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNqQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzdCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzNDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUMzQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN6QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDdEIsQ0FBQyxDQUFDO0NBQ0gsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNSLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDaEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ3JGLENBQUM7RUFDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNmLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDM0UsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDbkYsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztLQUNqRCxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNqRyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDckMsQ0FBQyxFQUFFO0lBQ0YsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQzlDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNsQixFQUFFO0lBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDOztJQUU1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDWixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNQOztHQUVBLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN4QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzs7R0FFN0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztHQUVoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUMzRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ2pELENBQUM7RUFDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDWCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN6QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztHQUN2QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7R0FDbEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUM7RUFDM0IsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0dBQ3hCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbkMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNmLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDVixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNsQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzdCLENBQUM7R0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2YsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN0QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzdCLENBQUM7O0dBRUQsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDdkUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUU7SUFDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN0RDs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3hCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtLQUNwQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUN4RSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtNQUNyQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7TUFDakMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNqQyxDQUFDO0dBQ0YsQ0FBQzs7R0FFRCxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDcEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDZCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUN2RixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUU7SUFDcEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUN0RCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUMxQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0IsQ0FBQyxDQUFDOztJQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzs7SUFFNUQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0lBRWhCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUM1QyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUMvRCxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3RCO0tBQ0MsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSw0Q0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNqQjtHQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUN4QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDckQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMxQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0lBQ1QsQ0FBQyxDQUFDO0dBQ0gsQ0FBQyxDQUFDO0VBQ0gsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2YsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3BELENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUM3QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUN6Qjs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUNwQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDZCxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUU7SUFDYixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ1AsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNKLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDSixDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ0osQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNKLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDSixDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ0osQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNKLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDTCxDQUFDOztHQUVELENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDeEUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzFDLENBQUM7O0dBRUQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDcEQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2hELENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUNoQixDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0dBQ25ELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztJQUN6QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQzdCLENBQUM7RUFDRixDQUFDLENBQUM7O0VBRUYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDeEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUM7R0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDO0dBQzVDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQztDQUNsQixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDVCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0VBQzNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUU7R0FDcEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDN0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDZCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUM5QyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ3BCLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbkQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMzQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMxRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDVCxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUM7RUFDSCxDQUFDLENBQUM7Q0FDSCxDQUFDO0FBQ0YsQ0FBQyxFQUFDOzs7Ozs7Ozs7Ozs7Ozs7O0FDN1h5Sjs7Ozs7Ozs7Ozs7Ozs7O0FDQUE7Ozs7Ozs7Ozs7Ozs7OztBQ0FGOzs7Ozs7Ozs7Ozs7Ozs7QUNBSTs7Ozs7Ozs7Ozs7Ozs7O0FDQUc7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RWJFN0osS0FBSyxFQUFDLGtCQUFrQjs7OztFQUd4QixLQUFLLEVBQUMsa0JBQWtCOzs7O0VBS3RCLEtBQUssRUFBQyxxQkFBcUI7O2dDQUk1Qix3REFBb0IsWUFBaEIsYUFBVztnQ0FDZix3REFBeUQsUUFBckQsS0FBc0MsRUFBdEMsdUNBQXNDLElBQUMsV0FBUzs7O0VBQzNCLEtBQW1CLEVBQW5CLGdCQUFtQjs7O3FCQWV4QyxLQUEwQixFQUExQix1QkFBMEI7OztzQkFVdkIsS0FBSyxFQUFDLGFBQWE7c0JBVXhCLEtBQUssRUFBQyxnQkFBZ0I7c0JBQ3JCLEtBQUssRUFBQyxXQUFXOzs7Ozs7S0FuRFosb0JBQWM7MkRBQXpCLHdEQUVnQyxPQUZoQyxVQUVnQyxFQUEvQiwyQkFBeUI7O0tBQ2Ysb0JBQWMsY0FBYyx1QkFBaUIsQ0FBQyxNQUFNOzJEQUEvRCx3REFJTSxPQUpOLFVBSU0sRUFGTCwyREFFRDsyREFDQSx3REF5Q1EsU0F6Q1IsVUF5Q1E7VUF0Q1Asd0RBTVE7WUFMUCx3REFJSztjQUhKLFVBQW9CO2NBQ3BCLFVBQXlEO2VBQy9DLGNBQVM7cUVBQW5CLHdEQUFrRCxNQUFsRCxVQUFrRDs7OztVQUdwRCx3REE4QlE7bUVBN0JQLHdEQTRCSyxpR0E1QmMsdUJBQWlCLEdBQXpCLElBQUk7d0VBQWYsd0RBNEJLO2dCQTNCSCxHQUFHLEVBQUUsSUFBSSxDQUFDLGNBQWM7O2dCQUV6Qix3REFPSztrQkFOSix3REFLUztvQkFMRCxJQUFJLEVBQUMsUUFBUTtvQkFDbkIsS0FBSyxFQUFDLGNBQWM7b0JBQ2YsT0FBSyxhQUFFLHVCQUFjLENBQUMsSUFBSSxDQUFDLGNBQWM7MEVBRTdDLGtCQUFTLENBQUMsSUFBSSxDQUFDLGNBQWM7O2dCQUdqQyx3REFRSyxNQVJMLFVBUUs7a0JBUEosd0RBTUU7b0JBTEQsS0FBSyxFQUFDLGtCQUFrQjtvQkFDeEIsSUFBSSxFQUFDLFVBQVU7b0JBQ1IsT0FBTyxFQUFFLElBQUksQ0FBQyxxQkFBcUI7b0JBQ25DLHFCQUFtQixFQUFFLElBQUksQ0FBQyxjQUFjO29CQUMxQyxRQUFNLDBDQUFFLDJEQUFjOzs7aUJBR25CLGNBQVM7dUVBQW5CLHdEQU9LO3NCQU5KLHdEQUtPLFFBTFAsV0FLTzt3QkFKTixpREFHRTswQkFGTSxJQUFJLEVBQUUsVUFBSyxDQUFDLFFBQVE7MEJBQ3RCLE9BQUssYUFBRSx5QkFBZ0IsQ0FBQyxJQUFJLENBQUMsY0FBYzs7Ozs7Ozs7O0lBT3RELHdEQVFNLE9BUk4sV0FRTTtNQVBMLHdEQU1NLE9BTk4sV0FNTTtRQUxMLHdEQUlTO1VBSkQsS0FBSyxFQUFDLDhCQUE4QjtVQUNyQyxPQUFLLDBDQUFFLCtEQUFnQjtXQUM3QixzQkFFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztFRXZERCxLQUFLLEVBQUMsWUFBWTtFQUNsQixFQUFFLEVBQUMsZ0JBQWdCO0VBQ25CLFFBQVEsRUFBQyxJQUFJO0VBQ2IsaUJBQWUsRUFBQyxtQkFBbUI7RUFDbkMsYUFBVyxFQUFDLE1BQU07O3FCQUViLEtBQUssRUFBQyx1QkFBdUI7cUJBQzVCLEtBQUssRUFBQyxlQUFlO3FCQUNwQixLQUFLLEVBQUMsY0FBYztnQ0FNeEIsd0RBUVM7RUFQUixJQUFJLEVBQUMsUUFBUTtFQUNiLEtBQUssRUFBQyxXQUFXO0VBQ2pCLGlCQUFlLEVBQUMsT0FBTztFQUN2QixZQUFVLEVBQUMsT0FBTztFQUNsQixFQUFFLEVBQUMsc0JBQXNCOztlQUV6Qix3REFBZ0MsVUFBMUIsYUFBVyxFQUFDLE1BQU07O3FCQUdyQixLQUFLLEVBQUMsWUFBWTtxQkFDakIsS0FBSyxFQUFDLEtBQUs7Z0NBQ2Ysd0RBT00sU0FQRCxLQUFLLEVBQUMsVUFBVTtlQUNwQix3REFBa0MsZ0JBQTFCLG1CQUFpQjtlQUN6Qix3REFJSSxPQUpELEtBQUssRUFBQyxtQkFBbUIsSUFBQyx5SEFJN0I7O3FCQUVJLEtBQUssRUFBQyxVQUFVO3NCQUNmLEtBQUssRUFBQyxZQUFZO2lDQUN0Qix3REFFQyxXQUZNLEdBQUcsRUFBQyxvQkFBb0IsSUFDOUIsYUFBVztzQkFhWCxLQUFLLEVBQUMsY0FBYztpQ0FDeEIsd0RBTVM7RUFMUixJQUFJLEVBQUMsUUFBUTtFQUNiLEtBQUssRUFBQyxtQkFBbUI7RUFDekIsaUJBQWUsRUFBQyxPQUFPO0dBQ3ZCLFNBRUQ7Ozs7Ozs0REExREosd0RBc0VNLE9BdEVOLFVBc0VNO0lBL0RMLHdEQThETSxPQTlETixVQThETTtNQTdETCx3REE0RE0sT0E1RE4sVUE0RE07UUEzREwsd0RBZU0sT0FmTixVQWVNO1VBZEwsd0RBSUs7WUFISixpREFBMEM7Y0FBN0IsSUFBSSxFQUFFLFVBQUssQ0FBQyxRQUFROztpRUFBUyxxQkFHM0M7O1VBQ0EsVUFRUzs7UUFFVix3REF5Qk0sT0F6Qk4sVUF5Qk07VUF4Qkwsd0RBdUJNLE9BdkJOLFVBdUJNO1lBdEJMLFVBT007WUFDTix3REFhTSxPQWJOLFVBYU07Y0FaTCx3REFXTSxPQVhOLFdBV007Z0JBVkwsV0FFQztvRUFDRCx3REFNRTtrQkFMRCxJQUFJLEVBQUMsTUFBTTsrRUFDRiw0QkFBc0I7a0JBQy9CLEtBQUssRUFBQyxjQUFjO2tCQUNwQixFQUFFLEVBQUMsb0JBQW9CO2tCQUN2QixTQUFTLEVBQUMsSUFBSTs7Z0VBSEwsNEJBQXNCOzs7Ozs7UUFTcEMsd0RBZ0JNLE9BaEJOLFdBZ0JNO1VBZkwsV0FNUztVQUNULHdEQU9TO1lBTlIsSUFBSSxFQUFDLFFBQVE7WUFDYixLQUFLLEVBQUMsaUJBQWlCO1lBQ2hCLFFBQVEsRUFBRSw0QkFBc0I7WUFDbEMsT0FBSywwQ0FBRSxpREFBUzthQUNyQixjQUVEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztFRWpFSCxLQUFLLEVBQUMsWUFBWTtFQUNsQixFQUFFLEVBQUMsY0FBYztFQUNqQixRQUFRLEVBQUMsSUFBSTtFQUNiLGlCQUFlLEVBQUMsbUJBQW1CO0VBQ25DLGFBQVcsRUFBQyxNQUFNOztxQkFFYixLQUFLLEVBQUMsdUJBQXVCO3FCQUM1QixLQUFLLEVBQUMsZUFBZTtxQkFDcEIsS0FBSyxFQUFDLGNBQWM7Z0NBTXhCLHdEQVFTO0VBUFIsSUFBSSxFQUFDLFFBQVE7RUFDYixLQUFLLEVBQUMsV0FBVztFQUNqQixpQkFBZSxFQUFDLE9BQU87RUFDdkIsWUFBVSxFQUFDLE9BQU87RUFDbEIsRUFBRSxFQUFDLG9CQUFvQjs7ZUFFdkIsd0RBQWdDLFVBQTFCLGFBQVcsRUFBQyxNQUFNOztxQkFHckIsS0FBSyxFQUFDLFlBQVk7cUJBQ2pCLEtBQUssRUFBQyxLQUFLO2dDQUNmLHdEQU1NLFNBTkQsS0FBSyxFQUFDLFVBQVU7ZUFDcEIsd0RBQXlCLGdCQUFqQixVQUFRO2VBQ2hCLHdEQUdJLE9BSEQsS0FBSyxFQUFDLGtCQUFrQixJQUFDLG1GQUc1Qjs7cUJBRUksS0FBSyxFQUFDLFVBQVU7c0JBQ2YsS0FBSyxFQUFDLFlBQVk7c0JBQ2YsR0FBRyxFQUFDLHNCQUFzQjs7O0VBTS9CLEtBQUssRUFBQyxPQUFPOztzQkFlWCxLQUFLLEVBQUMsWUFBWTtzQkFDZixHQUFHLEVBQUMsdUJBQXVCO3NCQWdCakMsS0FBSyxFQUFDLGNBQWM7aUNBQ3hCLHdEQU1TO0VBTFIsSUFBSSxFQUFDLFFBQVE7RUFDYixLQUFLLEVBQUMsbUJBQW1CO0VBQ3pCLGlCQUFlLEVBQUMsT0FBTztHQUN2QixTQUVEOzs7Ozs7OzREQWpGSix3REE2Rk0sT0E3Rk4sVUE2Rk07SUF0Rkwsd0RBcUZNLE9BckZOLFVBcUZNO01BcEZMLHdEQW1GTSxPQW5GTixVQW1GTTtRQWxGTCx3REFlTSxPQWZOLFVBZU07VUFkTCx3REFJSztZQUhKLGlEQUEwQztjQUE3QixJQUFJLEVBQUUsVUFBSyxDQUFDLFFBQVE7O2lFQUFTLG1CQUczQzs7VUFDQSxVQVFTOztRQUVWLHdEQWdETSxPQWhETixVQWdETTtVQS9DTCx3REE4Q00sT0E5Q04sVUE4Q007WUE3Q0wsVUFNTTtZQUNOLHdEQXFDTSxPQXJDTixVQXFDTTtjQXBDTCx3REFxQk0sT0FyQk4sV0FxQk07Z0JBcEJMLHdEQVlRLFNBWlIsV0FZUTt1RUFaMEIsd0JBRWpDO2tCQUFBLGlEQUV3QjtvQkFEaEIsWUFBVSxFQUFFLFNBQUUsQ0FBQyx3QkFBd0IsQ0FBQyxPQUFPOzttQkFJaEQsMEJBQW9CO3lFQUYzQix3REFNQyxRQU5ELFdBTUMsRUFIQSxnREFFWTs7O29FQUdkLHdEQU1FO2tCQUxELEVBQUUsRUFBQyxzQkFBc0I7K0VBQ2hCLDhCQUF3QjtrQkFDakMsS0FBSyxFQUFDLGNBQWM7a0JBQ3BCLFNBQVMsRUFBQyxJQUFJO2tCQUNkLFdBQVcsRUFBQyxvQkFBb0I7O2dFQUh2Qiw4QkFBd0I7OztjQU1uQyx3REFhTSxPQWJOLFdBYU07Z0JBWkwsd0RBS1EsU0FMUixXQUtRO3VFQUwyQixnQkFFbEM7a0JBQUEsaURBRXdCO29CQURoQixZQUFVLEVBQUUsU0FBRSxDQUFDLHdCQUF3QixDQUFDLE9BQU87OztvRUFHeEQsd0RBS0U7a0JBSkQsRUFBRSxFQUFDLHVCQUF1QjsrRUFDakIsOEJBQXdCO2tCQUNqQyxLQUFLLEVBQUMsY0FBYztrQkFDcEIsV0FBVyxFQUFDLHVCQUF1Qjs7Z0VBRjFCLDhCQUF3Qjs7Ozs7O1FBUXRDLHdEQWdCTSxPQWhCTixXQWdCTTtVQWZMLFdBTVM7VUFDVCx3REFPUztZQU5SLElBQUksRUFBQyxRQUFRO1lBQ2IsS0FBSyxFQUFDLGlCQUFpQjtZQUNsQixPQUFLLDBDQUFFLDZDQUFPO1lBQ1osUUFBUSxFQUFFLHNCQUFnQjthQUNqQyxZQUVEOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztFRXhGSCxLQUFLLEVBQUMsWUFBWTtFQUNsQixFQUFFLEVBQUMsd0JBQXdCO0VBQzNCLFFBQVEsRUFBQyxJQUFJO0VBQ2Isa0JBQWdCLEVBQUMsUUFBUTtFQUN6QixrQkFBZ0IsRUFBQyxPQUFPO0VBQ3hCLGlCQUFlLEVBQUMsbUJBQW1CO0VBQ25DLGFBQVcsRUFBQyxNQUFNOztxQkFFYixLQUFLLEVBQUMsY0FBYztxQkFDbkIsS0FBSyxFQUFDLGVBQWU7Z0NBQ3pCLHdEQWVNLFNBZkQsS0FBSyxFQUFDLGNBQWM7ZUFDeEIsd0RBS0s7SUFKSixLQUFLLEVBQUMsYUFBYTtJQUNuQixFQUFFLEVBQUMsbUJBQW1CO0tBQ3RCLGdDQUVEO2VBQ0EsNkVBQXlCO2VBQ3pCLHdEQU1VO0lBTFQsSUFBSSxFQUFDLFFBQVE7SUFDYixLQUFLLEVBQUMsV0FBVztJQUNqQixpQkFBZSxFQUFDLE9BQU87SUFDdkIsWUFBVSxFQUFDLE9BQU87SUFDbEIsRUFBRSxFQUFDLHlCQUF5Qjs7O2dDQUc5Qix3REFFTSxTQUZELEtBQUssRUFBQyxZQUFZLElBQUMsNkNBRXhCO3FCQUNLLEtBQUssRUFBQyxjQUFjOzs7NERBOUI1Qix3REFnRE0sT0FoRE4sVUFnRE07SUF2Q0wsd0RBc0NNLE9BdENOLFVBc0NNO01BckNMLHdEQW9DTSxPQXBDTixVQW9DTTtRQW5DTCxVQWVNO1FBQ04sVUFFTTtRQUNOLHdEQWVNLE9BZk4sVUFlTTtVQWRMLHdEQU1TO1lBTFIsSUFBSSxFQUFDLFFBQVE7WUFDYixLQUFLLEVBQUMsbUJBQW1CO1lBQ3BCLE9BQUssMENBQUUsbURBQVU7YUFDdEIsTUFFRDtVQUNBLHdEQU1TO1lBTFIsSUFBSSxFQUFDLFFBQVE7WUFDYixLQUFLLEVBQUMsaUJBQWlCO1lBQ2xCLE9BQUssMENBQUUsbURBQVU7YUFDdEIsT0FFRDs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7RUUzQ0gsS0FBSyxFQUFDLFlBQVk7RUFDbEIsRUFBRSxFQUFDLHFCQUFxQjtFQUN4QixrQkFBZ0IsRUFBQyxRQUFRO0VBQ3pCLGtCQUFnQixFQUFDLE9BQU87RUFDeEIsUUFBUSxFQUFDLElBQUk7RUFDYixpQkFBZSxFQUFDLG1CQUFtQjtFQUNuQyxhQUFXLEVBQUMsTUFBTTs7cUJBRWIsS0FBSyxFQUFDLHVCQUF1QjtxQkFDNUIsS0FBSyxFQUFDLGVBQWU7cUJBQ3BCLEtBQUssRUFBQyxjQUFjO2dDQU14Qix3REFRUztFQVBSLElBQUksRUFBQyxRQUFRO0VBQ2IsS0FBSyxFQUFDLFdBQVc7RUFDakIsaUJBQWUsRUFBQyxPQUFPO0VBQ3ZCLFlBQVUsRUFBQyxPQUFPO0VBQ2xCLEVBQUUsRUFBQywyQkFBMkI7O2VBRTlCLHdEQUFnQyxVQUExQixhQUFXLEVBQUMsTUFBTTs7cUJBR3JCLEtBQUssRUFBQyxZQUFZO3FCQUNqQixLQUFLLEVBQUMsS0FBSztxQkFDVixLQUFLLEVBQUMsVUFBVTtnQ0FDcEIsd0RBQStCLGdCQUF2QixnQkFBYztzQkFDbkIsS0FBSyxFQUFDLG1CQUFtQjs7OztzQkFtQnhCLEtBQUssRUFBQyxVQUFVOzs7RUFFbkIsS0FBSyxFQUFDLFdBQVc7O3NCQUdaLEtBQUssRUFBQyxNQUFNOztFQUVmLEdBQUcsRUFBQyxVQUFVO0VBQ2QsS0FBSyxFQUFDLFlBQVk7O2lDQUVFLHdEQUFLOzs7RUFHeEIsS0FBSyxFQUFDLHFCQUFxQjs7Ozs7RUFvQjlCLEtBQUssRUFBQyxZQUFZOztzQkFJYixLQUFLLEVBQUMsWUFBWTtpQ0FDdEIsd0RBRUMsV0FGTSxHQUFHLEVBQUMscUJBQXFCLElBQy9CLHNCQUFvQjtpQ0FXdEIsd0RBQUs7c0JBQ0EsS0FBSyxFQUFDLFVBQVU7Ozs7RUFpQnBCLEtBQUssRUFBQyxxQkFBcUI7O2lDQVEzQix3REFLTTtFQUpMLEtBQUssRUFBQyw2QkFBNkI7RUFDbkMsSUFBSSxFQUFDLFFBQVE7O2VBRWIsd0RBQXVDLFVBQWpDLEtBQUssRUFBQyxTQUFTLElBQUMsWUFBVTs7aUNBS2xDLHdEQVFNLFNBTkwsS0FBSyxFQUFDLHFCQUFxQixJQUMzQix3SkFLRDtzQkFLQyxLQUFLLEVBQUMsY0FBYztpQ0FDeEIsd0RBTVM7RUFMUixJQUFJLEVBQUMsUUFBUTtFQUNiLEtBQUssRUFBQyxtQkFBbUI7RUFDekIsaUJBQWUsRUFBQyxPQUFPO0dBQ3ZCLFNBRUQ7Ozs7Ozs0REEzSkosd0RBdUtNLE9BdktOLFVBdUtNO0lBOUpMLHdEQTZKTSxPQTdKTixVQTZKTTtNQTVKTCx3REEySk0sT0EzSk4sVUEySk07UUExSkwsd0RBZU0sT0FmTixVQWVNO1VBZEwsd0RBSUs7WUFISixpREFBMEM7Y0FBN0IsSUFBSSxFQUFFLFVBQUssQ0FBQyxRQUFROztpRUFBUywwQkFHM0M7O1VBQ0EsVUFRUzs7UUFFVix3REF3SE0sT0F4SE4sVUF3SE07VUF2SEwsd0RBc0hNLE9BdEhOLFVBc0hNO1lBckhMLHdEQW9CTSxPQXBCTixVQW9CTTtjQW5CTCxVQUErQjtjQUMvQix3REFJSSxLQUpKLFdBSUksRUFKeUIsa0RBRTVCLHdEQUFHLHVCQUFjLElBQUcsMENBRXJCO2VBQ1MsbUJBQWEsQ0FBQyxNQUFNO3FFQUE3Qix3REFHSSxrQkFIaUMsOERBR3JDO21CQUNjLHNCQUFnQjt1RUFBOUIsd0RBSUksa0JBSm1DLGdJQUl2Qzt1RUFDQSx3REFHSSxrQkFITSwwREFHVjs7WUFFRCx3REErRk0sT0EvRk4sV0ErRk07ZUE1RkUsbUJBQWEsQ0FBQyxNQUFNO3FFQUYzQix3REE4Qk0sT0E5Qk4sV0E4Qk07b0JBMUJMLHdEQXlCTSxPQXpCTixXQXlCTTtzQkF4Qkwsd0RBWVEsU0FaUixXQVlROzZFQVRQLHVCQUNvQjt3QkFBQSxXQUFLOzZFQUFBLEdBQ3pCLHdEQUFHLHFCQUFlLElBQUcsR0FDckI7eUJBRU8sc0JBQWdCOytFQUZ2Qix3REFLTSxPQUxOLFdBS00sRUFGTCwwQkFFRDs7O3NCQUVELHdEQVVFO3dCQVRELElBQUksRUFBQyxNQUFNO3dCQUNYLEtBQUssRUFBQyxjQUFjO3dCQUNwQixFQUFFLEVBQUMsVUFBVTt3QkFDTixNQUFNLEVBQUUsc0JBQWlCO3dCQUMzQixRQUFNO1dBQWMsMEJBQWlCO1lBQWMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxLQUFLOzs7Ozs7bUJBVWxFLHNCQUFnQjt1RUFGNUIsd0RBMkJNLE9BM0JOLFdBMkJNO3NCQXZCTCxpRkFBNkI7c0JBQzdCLHdEQVVNLE9BVk4sV0FVTTt3QkFUTCxXQUVDOzRFQUNELHdEQUtFOzBCQUpELEVBQUUsRUFBQyxxQkFBcUI7dUZBQ2YsOEJBQXdCOzBCQUNqQyxJQUFJLEVBQUMsTUFBTTswQkFDWCxLQUFLLEVBQUMsY0FBYzs7d0VBRlgsOEJBQXdCOzs7c0JBTW5DLDhFQUEwQjtzQkFDMUIsV0FBSztzQkFDTCx3REFPTSxPQVBOLFdBT007d0JBTkwsd0RBS1M7MEJBSkgsT0FBSywwQ0FBRSxpREFBUzswQkFDckIsS0FBSyxFQUFDLGlCQUFpQjsyQkFDdkIsY0FFRDs7O3VFQUdGLHdEQWtDTTtzQkFqQ0wsK0VBQTJCOztVQUVULFVBQVUsQ0FBQyxzQkFBZ0IsRUFBRSxPQUFPOzs7OzZFQUR0RCx3REFvQk0sT0FwQk4sV0FvQk07aUZBYkwsYUFFQTtXQUNjLFVBQVUsQ0FBQyxzQkFBZ0I7WUFBb0IsT0FBTyxPQUdsRSxJQUNGOzRCQUFBLFdBS007OzZFQUlQLHdEQVFNOzRCQVROLDhFQUEwQjs0QkFDMUIsV0FRTTs7Ozs7O1FBS1Ysd0RBZ0JNLE9BaEJOLFdBZ0JNO1VBZkwsV0FNUztVQUNULHdEQU9TO1lBTlIsSUFBSSxFQUFDLFFBQVE7WUFDYixLQUFLLEVBQUMsaUJBQWlCO1lBQ2hCLFFBQVEsRUFBRSx5QkFBbUI7WUFDL0IsT0FBSywwQ0FBRSxtREFBVTthQUN0QixlQUVEIiwic291cmNlcyI6WyJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy9zdWJfbW9kdWxlcy9MaXN0UHVibGljTGlua3MudnVlP2E5ZDciLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy9zdWJfbW9kdWxlcy9MaXN0UHVibGljTGlua3MudnVlIiwid2VicGFjazovL25lYXJiZWFjaC8uL3NyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvd2l6YXJkcy9BZGRGb2xkZXJXaXphcmQudnVlP2ZjZWEiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0FkZEZvbGRlcldpemFyZC52dWUiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0FkZExpbmtXaXphcmQudnVlP2I4NmIiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0FkZExpbmtXaXphcmQudnVlIiwid2VicGFjazovL25lYXJiZWFjaC8uL3NyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvd2l6YXJkcy9Db25maXJtRmlsZURlbGV0ZS52dWU/NTI0ZCIsIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9zcmMvanMvY29tcG9uZW50cy9tb2R1bGVzL3dpemFyZHMvQ29uZmlybUZpbGVEZWxldGUudnVlIiwid2VicGFjazovL25lYXJiZWFjaC8uL3NyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvd2l6YXJkcy9VcGxvYWREb2N1bWVudFdpemFyZC52dWU/YjQyYSIsIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9zcmMvanMvY29tcG9uZW50cy9tb2R1bGVzL3dpemFyZHMvVXBsb2FkRG9jdW1lbnRXaXphcmQudnVlIiwid2VicGFjazovL25lYXJiZWFjaC8uL3NyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvc3ViX21vZHVsZXMvTGlzdFB1YmxpY0xpbmtzLnZ1ZT85YmJlIiwid2VicGFjazovL25lYXJiZWFjaC8uL3NyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvd2l6YXJkcy9BZGRGb2xkZXJXaXphcmQudnVlP2JkMjUiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0FkZExpbmtXaXphcmQudnVlPzJjOWIiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0NvbmZpcm1GaWxlRGVsZXRlLnZ1ZT8zOTBhIiwid2VicGFjazovL25lYXJiZWFjaC8uL3NyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvd2l6YXJkcy9VcGxvYWREb2N1bWVudFdpemFyZC52dWU/OWYwZSJdLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyByZW5kZXIgfSBmcm9tIFwiLi9MaXN0UHVibGljTGlua3MudnVlP3Z1ZSZ0eXBlPXRlbXBsYXRlJmlkPTM1YmU1ZGE3XCJcbmltcG9ydCBzY3JpcHQgZnJvbSBcIi4vTGlzdFB1YmxpY0xpbmtzLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiXG5leHBvcnQgKiBmcm9tIFwiLi9MaXN0UHVibGljTGlua3MudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCJcblxuaW1wb3J0IGV4cG9ydENvbXBvbmVudCBmcm9tIFwiLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9leHBvcnRIZWxwZXIuanNcIlxuY29uc3QgX19leHBvcnRzX18gPSAvKiNfX1BVUkVfXyovZXhwb3J0Q29tcG9uZW50KHNjcmlwdCwgW1sncmVuZGVyJyxyZW5kZXJdLFsnX19maWxlJyxcInNyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvc3ViX21vZHVsZXMvTGlzdFB1YmxpY0xpbmtzLnZ1ZVwiXV0pXG4vKiBob3QgcmVsb2FkICovXG5pZiAobW9kdWxlLmhvdCkge1xuICBfX2V4cG9ydHNfXy5fX2htcklkID0gXCIzNWJlNWRhN1wiXG4gIGNvbnN0IGFwaSA9IF9fVlVFX0hNUl9SVU5USU1FX19cbiAgbW9kdWxlLmhvdC5hY2NlcHQoKVxuICBpZiAoIWFwaS5jcmVhdGVSZWNvcmQoJzM1YmU1ZGE3JywgX19leHBvcnRzX18pKSB7XG4gICAgYXBpLnJlbG9hZCgnMzViZTVkYTcnLCBfX2V4cG9ydHNfXylcbiAgfVxuICBcbiAgbW9kdWxlLmhvdC5hY2NlcHQoXCIuL0xpc3RQdWJsaWNMaW5rcy52dWU/dnVlJnR5cGU9dGVtcGxhdGUmaWQ9MzViZTVkYTdcIiwgKCkgPT4ge1xuICAgIGFwaS5yZXJlbmRlcignMzViZTVkYTcnLCByZW5kZXIpXG4gIH0pXG5cbn1cblxuXG5leHBvcnQgZGVmYXVsdCBfX2V4cG9ydHNfXyIsIjx0ZW1wbGF0ZT5cblx0PGRpdiB2LWlmPVwiaXNGZXRjaGluZ0RhdGFcIlxuXHRcdCBjbGFzcz1cImFsZXJ0IGFsZXJ0LWluZm9cIlxuXHQ+Q3VycmVudGx5IGxvYWRpbmcgZGF0YS4uLjwvZGl2PlxuXHQ8ZGl2IHYtaWY9XCJpc0ZldGNoaW5nRGF0YSA9PT0gZmFsc2UgJiYgcHVibGljTGlua1Jlc3VsdHMubGVuZ3RoID09PSAwXCJcblx0XHQgY2xhc3M9XCJhbGVydCBhbGVydC1pbmZvXCJcblx0PlxuXHRcdFNvcnJ5LiBUaGVyZSBhcmUgbm8gcHVibGljIGxpbmtzIHNldHVwIGZvciB0aGlzIG9iamVjdC5cblx0PC9kaXY+XG5cdDx0YWJsZSB2LWVsc2Vcblx0XHQgICBjbGFzcz1cInRhYmxlIHRhYmxlLXN0cmlwZWRcIlxuXHQ+XG5cdFx0PHRoZWFkPlxuXHRcdFx0PHRyPlxuXHRcdFx0XHQ8dGQ+UHVibGljIExpbms8L3RkPlxuXHRcdFx0XHQ8dGQgc3R5bGU9XCJ0ZXh0LWFsaWduOmNlbnRlcjt3aWR0aDoxMDBweDtcIj5JcyBBY3RpdmU8L3RkPlxuXHRcdFx0XHQ8dGQgdi1pZj1cInVzZXJMZXZlbCA+IDFcIiBzdHlsZT1cIndpZHRoOjEwcHg7XCI+PC90ZD5cblx0XHRcdDwvdHI+XG5cdFx0PC90aGVhZD5cblx0XHQ8dGJvZHk+XG5cdFx0XHQ8dHIgdi1mb3I9XCJsaW5rIGluIHB1YmxpY0xpbmtSZXN1bHRzXCJcblx0XHRcdFx0OmtleT1cImxpbmsucHVibGljX2xpbmtfaWRcIlxuXHRcdFx0PlxuXHRcdFx0XHQ8dGQ+XG5cdFx0XHRcdFx0PGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCJcblx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4gYnRuLWxpbmtcIlxuXHRcdFx0XHRcdFx0XHR2LW9uOmNsaWNrPVwiY29weVB1YmxpY0xpbmsobGluay5wdWJsaWNfbGlua19pZClcIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdHt7Zm9ybWF0VXJsKGxpbmsucHVibGljX2xpbmtfaWQpfX1cblx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0PC90ZD5cblx0XHRcdFx0PHRkIHN0eWxlPVwidGV4dC1hbGlnbjogY2VudGVyXCI+XG5cdFx0XHRcdFx0PGlucHV0XG5cdFx0XHRcdFx0XHRjbGFzcz1cImZvcm0tY2hlY2staW5wdXRcIlxuXHRcdFx0XHRcdFx0dHlwZT1cImNoZWNrYm94XCJcblx0XHRcdFx0XHRcdHYtYmluZDpjaGVja2VkPVwibGluay5wdWJsaWNfbGlua19pc19hY3RpdmVcIlxuXHRcdFx0XHRcdFx0di1iaW5kOmRhdGEtcHVibGljLWxpbmstaWQ9XCJsaW5rLnB1YmxpY19saW5rX2lkXCJcblx0XHRcdFx0XHRcdHYtb246Y2hhbmdlPVwidXBkYXRlSXNBY3RpdmVcIlxuXHRcdFx0XHRcdC8+XG5cdFx0XHRcdDwvdGQ+XG5cdFx0XHRcdDx0ZCB2LWlmPVwidXNlckxldmVsID4gMVwiPlxuXHRcdFx0XHRcdDxzcGFuIGNsYXNzPVwicmVtb3ZlLWxpbmtcIj5cblx0XHRcdFx0XHRcdDxJY29uXG5cdFx0XHRcdFx0XHRcdHYtYmluZDppY29uPVwiaWNvbnMudHJhc2hDYW5cIlxuXHRcdFx0XHRcdFx0XHR2LW9uOmNsaWNrPVwiZGVsZXRlUHVibGljTGluayhsaW5rLnB1YmxpY19saW5rX2lkKVwiXG5cdFx0XHRcdFx0XHQvPlxuXHRcdFx0XHRcdDwvc3Bhbj5cblx0XHRcdFx0PC90ZD5cblx0XHRcdDwvdHI+XG5cdFx0PC90Ym9keT5cblx0PC90YWJsZT5cblx0PGRpdiBjbGFzcz1cInJvdyBzdWJtaXQtcm93XCI+XG5cdFx0PGRpdiBjbGFzcz1cImNvbC1tZC0xMlwiPlxuXHRcdFx0PGJ1dHRvbiBjbGFzcz1cImJ0biBidG4tcHJpbWFyeSBzYXZlLWNoYW5nZXNcIlxuXHRcdFx0XHRcdHYtb246Y2xpY2s9XCJjcmVhdGVQdWJsaWNMaW5rXCJcblx0XHRcdD5cblx0XHRcdFx0Q3JlYXRlIFB1YmxpYyBMaW5rXG5cdFx0XHQ8L2J1dHRvbj5cblx0XHQ8L2Rpdj5cblx0PC9kaXY+XG48L3RlbXBsYXRlPlxuXG48c2NyaXB0PlxuLy9WdWVYXG5pbXBvcnQgeyBtYXBHZXR0ZXJzIH0gZnJvbSBcInZ1ZXhcIjtcblxuLy9JY29uXG5pbXBvcnQge0ljb259IGZyb20gXCJAaWNvbmlmeS92dWVcIjtcbmltcG9ydCBpY29uTWl4aW4gZnJvbSBcIi4uLy4uLy4uL21peGlucy9pY29uTWl4aW5cIjtcblxuZXhwb3J0IGRlZmF1bHQge1xuXHRuYW1lOiBcIkxpc3RQdWJsaWNMaW5rc1wiLFxuXHRwcm9wczoge1xuXHRcdG92ZXJyaWRlRGVzdGluYXRpb246IHtcblx0XHRcdHR5cGU6IFN0cmluZyxcblx0XHRcdGRlZmF1bHQ6IFwiXCIsXG5cdFx0fSxcblx0XHRvdmVycmlkZUxvY2F0aW9uSWQ6IHtcblx0XHRcdHR5cGU6IE51bWJlcixcblx0XHRcdGRlZmF1bHQ6IDAsXG5cdFx0fSxcblx0fSxcblx0ZGF0YSgpIHtcblx0XHRyZXR1cm4ge1xuXHRcdFx0aXNGZXRjaGluZ0RhdGE6IHRydWUsXG5cdFx0XHRwdWJsaWNMaW5rUmVzdWx0czogW10sXG5cdFx0fTtcblx0fSxcblx0d2F0Y2g6IHtcblx0XHRvdmVycmlkZUxvY2F0aW9uSWQoKSB7XG5cdFx0XHR0aGlzLmdldFB1YmxpY0xpbmtzKCk7XG5cdFx0fSxcblx0fSxcblx0Y29tcG9uZW50czoge1xuXHRcdEljb24sXG5cdH0sXG5cdGNvbXB1dGVkOiB7XG5cdFx0Li4ubWFwR2V0dGVycyh7XG5cdFx0XHRkZXN0aW5hdGlvbjogXCJnZXREZXN0aW5hdGlvblwiLFxuXHRcdFx0bG9jYXRpb25JZDogXCJnZXRMb2NhdGlvbklkXCIsXG5cdFx0XHRyb290VXJsOiBcImdldFJvb3RVcmxcIixcblx0XHRcdHVzZXJMZXZlbDogXCJnZXRVc2VyTGV2ZWxcIixcblx0XHR9KVxuXHR9LFxuXHRtaXhpbnM6IFtpY29uTWl4aW5dLFxuXHRtZXRob2RzOiB7XG5cdFx0YXN5bmMgY29weVB1YmxpY0xpbmsocHVibGljX2xpbmtfaWQpIHtcblx0XHRcdC8vR2V0IHRoZSBVUkxcblx0XHRcdGNvbnN0IHVybCA9IGAke3dpbmRvdy5sb2NhdGlvbi5vcmlnaW59JHt0aGlzLnJvb3RVcmx9cHVibGljLyR7dGhpcy5nZXREZXN0aW5hdGlvbigpfS8ke3RoaXMuZ2V0TG9jYXRpb25JZCgpfS8ke3B1YmxpY19saW5rX2lkfS9gXG5cblx0XHRcdC8vQ29weSB0byB0aGUgY2xpcGJvYXJkXG5cdFx0XHR0cnkge1xuXHRcdFx0XHRhd2FpdCBuYXZpZ2F0b3IuY2xpcGJvYXJkLndyaXRlVGV4dCh1cmwpO1xuXG5cdFx0XHRcdC8vTm90aWZ5IHRoZSB1c2VyXG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJQdWJsaWMgTGluayBDb3BpZWRcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBcIlB1YmxpYyBMaW5rIGhhcyBzdWNjZXNzZnVsbHkgY29waWVkIHRvIHRoZSBjbGlwYm9hcmRcIixcblx0XHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLXN1Y2Nlc3NcIixcblx0XHRcdFx0fSk7XG5cdFx0XHR9IGNhdGNoKGVycm9yKSB7XG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJDYW4gbm90IGNvcHkgcHVibGljIGxpbmtcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBcIlNvcnJ5LCB3ZSBmYWlsZWQgdG8gY29weSB0aGUgcHVibGljIGxpbmtcIixcblx0XHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLWRhbmdlclwiLFxuXHRcdFx0XHRcdGRlbGF5OiAwLFxuXHRcdFx0XHR9KTtcblx0XHRcdH1cblx0XHR9LFxuXHRcdGNyZWF0ZVB1YmxpY0xpbmsoKSB7XG5cdFx0XHQvL0luZm9ybSB1c2VyIG9mIGNyZWF0aW5nIG5ldyBsaW5rXG5cdFx0XHR0aGlzLiRzdG9yZS5kaXNwYXRjaChcIm5ld1RvYXN0XCIsIHtcblx0XHRcdFx0aGVhZGVyOiBcIkNyZWF0aW5nIE5ldyBUb2FzdFwiLFxuXHRcdFx0XHRtZXNzYWdlOiBcIlBsZWFzZSB3YWl0IHdoaWxzdCB3ZSBjcmVhdGUgdGhlIHRvYXN0XCIsXG5cdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctd2FybmluZ1wiLFxuXHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0dW5pcXVlX3R5cGU6IFwiY3JlYXRlX3B1YmxpY19saW5rXCIsXG5cdFx0XHR9KTtcblxuXHRcdFx0Ly9Db250YWN0IGJhY2tlbmQgLSBnZXQgcHVibGljIGxpbmtcblx0XHRcdHRoaXMuYXhpb3MucG9zdChcblx0XHRcdFx0YCR7dGhpcy5yb290VXJsfXB1YmxpY19kYXRhLyR7dGhpcy5nZXREZXN0aW5hdGlvbigpfS8ke3RoaXMuZ2V0TG9jYXRpb25JZCgpfS9jcmVhdGUvYCxcblx0XHRcdCkudGhlbigocmVzcG9uc2UpID0+IHtcblx0XHRcdFx0Ly9JbmZvcm0gdXNlciBvZiBzdWNjZXNzXG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJTdWNjZXNzZnVsIG5ldyBQdWJsaWMgTGlua1wiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IFwiV2UgaGF2ZSBiZWVuIGFibGUgdG8gY3JlYXRlIGEgbmV3IHB1YmxpYyBsaW5rXCIsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1zdWNjZXNzXCIsXG5cdFx0XHRcdFx0dW5pcXVlX3R5cGU6IFwiY3JlYXRlX3B1YmxpY19saW5rXCIsXG5cdFx0XHRcdH0pO1xuXG5cdFx0XHRcdC8vUmVwbGFjZSBldmVyeXRoaW5nXG5cdFx0XHRcdHRoaXMucHVibGljTGlua1Jlc3VsdHMgPSByZXNwb25zZS5kYXRhO1xuXHRcdFx0fSkuY2F0Y2goKGVycm9yKSA9PiB7XG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJDYW4gbm90IGNyZWF0ZSBuZXcgcHVibGljIGxpbmtcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBgU29ycnksIHdlIGZhaWxlZCB0byBjcmVhdGUgdGhlIG5ldyBwdWJsaWMgbGluay4gRXJyb3IgLT4gJHtlcnJvcn1gLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctZGFuZ2VyXCIsXG5cdFx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdFx0dW5pcXVlX3R5cGU6IFwiY3JlYXRlX3B1YmxpY19saW5rXCIsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fSlcblx0XHR9LFxuXHRcdGRlbGV0ZVB1YmxpY0xpbmsocHVibGljX2xpbmtfaWQpIHtcblx0XHRcdC8vQ29uc3RydWN0IGRhdGEgdG8gc2VuZFxuXHRcdFx0Y29uc3QgZGF0YV90b19zZW5kID0gbmV3IEZvcm1EYXRhKCk7XG5cdFx0XHRkYXRhX3RvX3NlbmQuc2V0KFwicHVibGljX2xpbmtfaWRcIiwgcHVibGljX2xpbmtfaWQpO1xuXG5cdFx0XHQvL05vdGlmeSB1c2VyIHdlIGFyZSBkZWxldGluZyB0aGUgZGF0YVxuXHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdGhlYWRlcjogXCJEZWxldGluZyBQdWJsaWMgTGlua1wiLFxuXHRcdFx0XHRtZXNzYWdlOiBcIkRlbGV0aW5nIFB1YmxpYyBMaW5rXCIsXG5cdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctd2FybmluZ1wiLFxuXHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0dW5pcXVlX3R5cGU6IFwicHVibGljX2xpbmtfZGVsZXRlXCIsXG5cdFx0XHR9KVxuXG5cdFx0XHQvL1VzZSBheGlvc1xuXHRcdFx0dGhpcy5heGlvcy5wb3N0KFxuXHRcdFx0XHRgJHt0aGlzLnJvb3RVcmx9cHVibGljX2RhdGEvJHt0aGlzLmdldERlc3RpbmF0aW9uKCl9LyR7dGhpcy5nZXRMb2NhdGlvbklkKCl9L2RlbGV0ZS9gLFxuXHRcdFx0XHRkYXRhX3RvX3NlbmQsXG5cdFx0XHQpLnRoZW4oKCkgPT4ge1xuXHRcdFx0XHQvL1JlbW92ZSB0aGUgcm93XG5cdFx0XHRcdHRoaXMucHVibGljTGlua1Jlc3VsdHMgPSB0aGlzLnB1YmxpY0xpbmtSZXN1bHRzLmZpbHRlcigocm93KSA9PiB7XG5cdFx0XHRcdFx0cmV0dXJuIHJvdy5wdWJsaWNfbGlua19pZCAhPT0gcHVibGljX2xpbmtfaWQ7XG5cdFx0XHRcdH0pO1xuXG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJTdWNjZXNzZnVsbHkgRGVsZXRlZCBQdWJsaWMgTGlua1wiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IFwiU3VjY2Vzc2Z1bGx5IERlbGV0ZWQgUHVibGljIExpbmtcIixcblx0XHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLXN1Y2Nlc3NcIixcblx0XHRcdFx0XHR1bmlxdWVfdHlwZTogXCJwdWJsaWNfbGlua19kZWxldGVcIixcblx0XHRcdFx0fSk7XG5cdFx0XHR9KS5jYXRjaCgoZXJyb3IpID0+IHtcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdFx0aGVhZGVyOiBcIkVycm9yIERlbGV0aW5nIFB1YmxpYyBMaW5rXCIsXG5cdFx0XHRcdFx0bWVzc2FnZTogYEVycm9yIC0gY291bGQgbm90IGRlbGV0ZSBsaW5rLiBFcnJvciAtPiAke2Vycm9yfWAsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1kYW5nZXJcIixcblx0XHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0XHR1bmlxdWVfdHlwZTogXCJwdWJsaWNfbGlua19kZWxldGVcIixcblx0XHRcdFx0fSk7XG5cdFx0XHR9KTtcblx0XHR9LFxuXHRcdGZvcm1hdFVybChwdWJsaWNfbGlua19pZCkge1xuXHRcdFx0Ly9Eb3VibGUgY2hlY2sgd2UgYXJlIGdldHRpbmcgdGhlIGNvcnJlY3QgVVJMXG5cdFx0XHRpZiAocHVibGljX2xpbmtfaWQgPT09IFwiXCIgfHwgcHVibGljX2xpbmtfaWQgPT09IHVuZGVmaW5lZCkge1xuXHRcdFx0XHRyZXR1cm4gXCJEYXRhIGVycm9yIVwiO1xuXHRcdFx0fVxuXG5cdFx0XHQvL1RydWNhdGUgdGhlIFVVSUQgLSBzbyBpZiBzb21lb25lIGlzIHZpZXdpbmcgdGhlIHNjcmVlbiB0aGV5IGRvbid0IGdldCB0aGUga2V5XG5cdFx0XHRjb25zdCB0cnVuY19saW5rX2lkID0gcHVibGljX2xpbmtfaWQuc2xpY2UoMCw3KTtcblxuXHRcdFx0cmV0dXJuIGAke3dpbmRvdy5sb2NhdGlvbi5vcmlnaW59JHt0aGlzLnJvb3RVcmx9cHVibGljLyR7dGhpcy5nZXREZXN0aW5hdGlvbigpfS8ke3RoaXMuZ2V0TG9jYXRpb25JZCgpfS8ke3RydW5jX2xpbmtfaWR9Li4uYFxuXHRcdH0sXG5cdFx0Z2V0RGVzdGluYXRpb24oKSB7XG5cdFx0XHRyZXR1cm4gdGhpcy5vdmVycmlkZURlc3RpbmF0aW9uICE9PSBcIlwiID8gdGhpcy5vdmVycmlkZURlc3RpbmF0aW9uIDogdGhpcy5kZXN0aW5hdGlvbjtcblx0XHR9LFxuXHRcdGdldExvY2F0aW9uSWQoKSB7XG5cdFx0XHQvL0lmIHRoZXJlIGlzIGFuIG92ZXJyaWRlRGVzdGluYXRpb24gLSB3ZSB3YW50IHRvIHVzZSB0aGUgb3ZlcnJpZGVMb2NhdGlvbklkXG5cdFx0XHRyZXR1cm4gdGhpcy5vdmVycmlkZURlc3RpbmF0aW9uICE9PSBcIlwiID8gdGhpcy5vdmVycmlkZUxvY2F0aW9uSWQgOiB0aGlzLmxvY2F0aW9uSWQ7XG5cdFx0fSxcblx0XHRnZXRQdWJsaWNMaW5rcygpIHtcblx0XHRcdHRoaXMuYXhpb3MoXG5cdFx0XHRcdGAke3RoaXMucm9vdFVybH1wdWJsaWNfZGF0YS8ke3RoaXMuZ2V0RGVzdGluYXRpb24oKX0vJHt0aGlzLmdldExvY2F0aW9uSWQoKX0vZ2V0X2xpbmtzL2AsXG5cdFx0XHQpLnRoZW4oKHJlc3BvbnNlKSA9PiB7XG5cdFx0XHRcdC8vU2V0IHRoZSBkYXRhXG5cdFx0XHRcdHRoaXMucHVibGljTGlua1Jlc3VsdHMgPSByZXNwb25zZS5kYXRhO1xuXG5cdFx0XHRcdC8vU2V0IHRoZSBmZXRjaCBzdGF0dXMgdG8gZmFsc2Vcblx0XHRcdFx0dGhpcy5pc0ZldGNoaW5nRGF0YSA9IGZhbHNlO1xuXHRcdFx0fSkuY2F0Y2goKGVycm9yKSA9PiB7XG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJFcnJvciBmZXRjaGluZyBQdWJsaWMgTGlua3NcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBgV2UgaGFkIGFuIGlzc3VlIGZldGNoaW5nIHRoZSBwdWJsaWMgbGlua3MgZm9yIHRoaXMgb2JqZWN0LiBFcnJvciAtPiAke2Vycm9yfWAsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1kYW5nZXJcIixcblx0XHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0fSk7XG5cdFx0XHR9KTtcblx0XHR9LFxuXHRcdHVwZGF0ZUlzQWN0aXZlKGV2ZW50KSB7XG5cdFx0XHQvL0dldCB0aGUgdXVpZFxuXHRcdFx0Y29uc3QgdXVpZCA9IGV2ZW50LnRhcmdldC5kYXRhc2V0LnB1YmxpY0xpbmtJZDtcblxuXHRcdFx0Ly9UZWxsIHRoZSB1c2VyIHdlIGFyZSB1cGRhdGluZyB0aGUgc3RhdHNcblx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRoZWFkZXI6IFwiVXBkYXRpbmcgQWN0aXZlIFN0YXR1cyBmb3IgUHJpdmF0ZSBMaW5rXCIsXG5cdFx0XHRcdG1lc3NhZ2U6IFwiUGxlYXNlIHdhaXQgLSB3ZSBhcmUgdXBkYXRpbmcgdGhlIHN0YXR1c1wiLFxuXHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLXdhcm5pbmdcIixcblx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdHVuaXF1ZV90eXBlOiBgaXNfYWN0aXZlLSR7dXVpZH1gLFxuXHRcdFx0fSk7XG5cblx0XHRcdC8vVHJhbnNsYXRlIHRoZSBjaGVja2VkIGJveFxuXHRcdFx0bGV0IGlzX2FjdGl2ZSA9IFwiRmFsc2VcIjtcblx0XHRcdGlmIChldmVudC50YXJnZXQuY2hlY2tlZCkge1xuXHRcdFx0XHRpc19hY3RpdmUgPSBcIlRydWVcIjtcblx0XHRcdH1cblxuXHRcdFx0Ly9TZXR1cCBkYXRhIHRvIHNlbmRcblx0XHRcdGNvbnN0IGRhdGFfdG9fc2VuZCA9IG5ldyBGb3JtRGF0YSgpO1xuXHRcdFx0ZGF0YV90b19zZW5kLnNldChcInB1YmxpY19saW5rX2lkXCIsIHV1aWQpO1xuXHRcdFx0ZGF0YV90b19zZW5kLnNldChcInB1YmxpY19saW5rX2lzX2FjdGl2ZVwiLCBpc19hY3RpdmUpO1xuXG5cdFx0XHR0aGlzLmF4aW9zLnBvc3QoXG5cdFx0XHRcdGAke3RoaXMucm9vdFVybH1wdWJsaWNfZGF0YS91cGRhdGVfbGluay9gLFxuXHRcdFx0XHRkYXRhX3RvX3NlbmQsXG5cdFx0XHQpLnRoZW4oKCkgPT4ge1xuXHRcdFx0XHQvL1VwZGF0ZSB1c2VyXG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJTdWNjZXNzZnVsbHkgVXBkYXRlZFwiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IFwiV2UgaGF2ZSB1cGRhdGVkIHRoZSBpcyBhY3RpdmUgc3RhdHVzIGZvciB0aGUgbGlua1wiLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctc3VjY2Vzc1wiLFxuXHRcdFx0XHRcdHVuaXF1ZV90eXBlOiBgaXNfYWN0aXZlLSR7dXVpZH1gLFxuXHRcdFx0XHR9KTtcblx0XHRcdH0pLmNhdGNoKChlcnJvcikgPT4ge1xuXHRcdFx0XHR0aGlzLiRzdG9yZS5kaXNwYXRjaChcIm5ld1RvYXN0XCIsIHtcblx0XHRcdFx0XHRoZWFkZXI6IFwiRXJyb3IgVXBkYXRpbmcgQWN0aXZlIFN0YXR1cyBmb3IgUHJpdmF0ZSBMaW5rXCIsXG5cdFx0XHRcdFx0bWVzc2FnZTogYFdlIGFyZSBzb3JyeSwgc29tZXRoaW5nIHdlbnQgd3JvbmcuIEVycm9yIC0+ICR7ZXJyb3J9YCxcblx0XHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLWRhbmdlclwiLFxuXHRcdFx0XHRcdGRlbGF5OiAwLFxuXHRcdFx0XHRcdHVuaXF1ZV90eXBlOiBgaXNfYWN0aXZlLSR7dXVpZH1gLFxuXHRcdFx0XHR9KTtcblx0XHRcdH0pXG5cdFx0fSxcblx0fSxcblx0bW91bnRlZCgpIHtcblx0XHR0aGlzLiRuZXh0VGljaygoKSA9PiB7XG5cdFx0XHR0aGlzLmdldFB1YmxpY0xpbmtzKCk7XG5cdFx0fSlcblx0fSxcbn1cbjwvc2NyaXB0PiIsImltcG9ydCB7IHJlbmRlciB9IGZyb20gXCIuL0FkZEZvbGRlcldpemFyZC52dWU/dnVlJnR5cGU9dGVtcGxhdGUmaWQ9MGI5MjgyMjJcIlxuaW1wb3J0IHNjcmlwdCBmcm9tIFwiLi9BZGRGb2xkZXJXaXphcmQudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCJcbmV4cG9ydCAqIGZyb20gXCIuL0FkZEZvbGRlcldpemFyZC52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIlxuXG5pbXBvcnQgZXhwb3J0Q29tcG9uZW50IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2V4cG9ydEhlbHBlci5qc1wiXG5jb25zdCBfX2V4cG9ydHNfXyA9IC8qI19fUFVSRV9fKi9leHBvcnRDb21wb25lbnQoc2NyaXB0LCBbWydyZW5kZXInLHJlbmRlcl0sWydfX2ZpbGUnLFwic3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0FkZEZvbGRlcldpemFyZC52dWVcIl1dKVxuLyogaG90IHJlbG9hZCAqL1xuaWYgKG1vZHVsZS5ob3QpIHtcbiAgX19leHBvcnRzX18uX19obXJJZCA9IFwiMGI5MjgyMjJcIlxuICBjb25zdCBhcGkgPSBfX1ZVRV9ITVJfUlVOVElNRV9fXG4gIG1vZHVsZS5ob3QuYWNjZXB0KClcbiAgaWYgKCFhcGkuY3JlYXRlUmVjb3JkKCcwYjkyODIyMicsIF9fZXhwb3J0c19fKSkge1xuICAgIGFwaS5yZWxvYWQoJzBiOTI4MjIyJywgX19leHBvcnRzX18pXG4gIH1cbiAgXG4gIG1vZHVsZS5ob3QuYWNjZXB0KFwiLi9BZGRGb2xkZXJXaXphcmQudnVlP3Z1ZSZ0eXBlPXRlbXBsYXRlJmlkPTBiOTI4MjIyXCIsICgpID0+IHtcbiAgICBhcGkucmVyZW5kZXIoJzBiOTI4MjIyJywgcmVuZGVyKVxuICB9KVxuXG59XG5cblxuZXhwb3J0IGRlZmF1bHQgX19leHBvcnRzX18iLCI8dGVtcGxhdGU+XG5cdDxkaXZcblx0XHRjbGFzcz1cIm1vZGFsIGZhZGVcIlxuXHRcdGlkPVwiYWRkRm9sZGVyTW9kYWxcIlxuXHRcdHRhYmluZGV4PVwiLTFcIlxuXHRcdGFyaWEtbGFiZWxsZWRieT1cImV4YW1wbGVNb2RhbExhYmVsXCJcblx0XHRhcmlhLWhpZGRlbj1cInRydWVcIlxuXHQ+XG5cdFx0PGRpdiBjbGFzcz1cIm1vZGFsLWRpYWxvZyBtb2RhbC1sZ1wiPlxuXHRcdFx0PGRpdiBjbGFzcz1cIm1vZGFsLWNvbnRlbnRcIj5cblx0XHRcdFx0PGRpdiBjbGFzcz1cIm1vZGFsLWhlYWRlclwiPlxuXHRcdFx0XHRcdDxoMj5cblx0XHRcdFx0XHRcdDxJY29uIHYtYmluZDppY29uPVwiaWNvbnMudXNlckljb25cIj48L0ljb24+XG5cdFx0XHRcdFx0XHRBZGQgRm9sZGVyXG5cdFx0XHRcdFx0XHRXaXphcmRcblx0XHRcdFx0XHQ8L2gyPlxuXHRcdFx0XHRcdDxidXR0b25cblx0XHRcdFx0XHRcdHR5cGU9XCJidXR0b25cIlxuXHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4tY2xvc2VcIlxuXHRcdFx0XHRcdFx0ZGF0YS1icy1kaXNtaXNzPVwibW9kYWxcIlxuXHRcdFx0XHRcdFx0YXJpYS1sYWJlbD1cIkNsb3NlXCJcblx0XHRcdFx0XHRcdGlkPVwiYWRkRm9sZGVyQ2xvc2VCdXR0b25cIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdDxzcGFuIGFyaWEtaGlkZGVuPVwidHJ1ZVwiPjwvc3Bhbj5cblx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1ib2R5XCI+XG5cdFx0XHRcdFx0PGRpdiBjbGFzcz1cInJvd1wiPlxuXHRcdFx0XHRcdFx0PGRpdiBjbGFzcz1cImNvbC1tZC00XCI+XG5cdFx0XHRcdFx0XHRcdDxzdHJvbmc+Q3JlYXRpbmcgYSBmb2xkZXI8L3N0cm9uZz5cblx0XHRcdFx0XHRcdFx0PHAgY2xhc3M9XCJ0ZXh0LWluc3RydWN0aW9uc1wiPlxuXHRcdFx0XHRcdFx0XHRcdEdpdmUgdGhlIGZvbGRlciBhbiBhcHByb3ByaWF0ZSBuYW1lLiBXaGVuIGRvbmUsXG5cdFx0XHRcdFx0XHRcdFx0Y2xpY2sgb24gdGhlIFwiU2F2ZVwiIGJ1dHRvbi4gSXQgd2lsbCBiZSBhZGRlZCB0b1xuXHRcdFx0XHRcdFx0XHRcdHRoZSBjdXJyZW50IGZvbGRlci5cblx0XHRcdFx0XHRcdFx0PC9wPlxuXHRcdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdFx0XHQ8ZGl2IGNsYXNzPVwiY29sLW1kLThcIj5cblx0XHRcdFx0XHRcdFx0PGRpdiBjbGFzcz1cImZvcm0tZ3JvdXBcIj5cblx0XHRcdFx0XHRcdFx0XHQ8bGFiZWwgZm9yPVwiZm9sZGVyX2Rlc2NyaXB0aW9uXCJcblx0XHRcdFx0XHRcdFx0XHQ+Rm9sZGVyIE5hbWU8L2xhYmVsXG5cdFx0XHRcdFx0XHRcdFx0PlxuXHRcdFx0XHRcdFx0XHRcdDxpbnB1dFxuXHRcdFx0XHRcdFx0XHRcdFx0dHlwZT1cInRleHRcIlxuXHRcdFx0XHRcdFx0XHRcdFx0di1tb2RlbD1cImZvbGRlckRlc2NyaXB0aW9uTW9kZWxcIlxuXHRcdFx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJmb3JtLWNvbnRyb2xcIlxuXHRcdFx0XHRcdFx0XHRcdFx0aWQ9XCJmb2xkZXJfZGVzY3JpcHRpb25cIlxuXHRcdFx0XHRcdFx0XHRcdFx0bWF4bGVuZ3RoPVwiNTBcIlxuXHRcdFx0XHRcdFx0XHRcdC8+XG5cdFx0XHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtZm9vdGVyXCI+XG5cdFx0XHRcdFx0PGJ1dHRvblxuXHRcdFx0XHRcdFx0dHlwZT1cImJ1dHRvblwiXG5cdFx0XHRcdFx0XHRjbGFzcz1cImJ0biBidG4tc2Vjb25kYXJ5XCJcblx0XHRcdFx0XHRcdGRhdGEtYnMtZGlzbWlzcz1cIm1vZGFsXCJcblx0XHRcdFx0XHQ+XG5cdFx0XHRcdFx0XHRDbG9zZVxuXHRcdFx0XHRcdDwvYnV0dG9uPlxuXHRcdFx0XHRcdDxidXR0b25cblx0XHRcdFx0XHRcdHR5cGU9XCJidXR0b25cIlxuXHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4gYnRuLXByaW1hcnlcIlxuXHRcdFx0XHRcdFx0di1iaW5kOmRpc2FibGVkPVwiZGlzYWJsZUFkZEZvbGRlckJ1dHRvblwiXG5cdFx0XHRcdFx0XHR2LW9uOmNsaWNrPVwiYWRkRm9sZGVyXCJcblx0XHRcdFx0XHQ+XG5cdFx0XHRcdFx0XHRBZGQgRm9sZGVyXG5cdFx0XHRcdFx0PC9idXR0b24+XG5cdFx0XHRcdDwvZGl2PlxuXHRcdFx0PC9kaXY+XG5cdFx0PC9kaXY+XG5cdDwvZGl2PlxuPC90ZW1wbGF0ZT5cblxuPHNjcmlwdD5cbmltcG9ydCB7SWNvbn0gZnJvbSBcIkBpY29uaWZ5L3Z1ZVwiO1xuXG4vL1Z1ZVhcbmltcG9ydCB7bWFwR2V0dGVyc30gZnJvbSBcInZ1ZXhcIjtcblxuLy9NaXhpbnNcbmltcG9ydCBlcnJvck1vZGFsTWl4aW4gZnJvbSBcIi4uLy4uLy4uL21peGlucy9lcnJvck1vZGFsTWl4aW5cIjtcbmltcG9ydCBpY29uTWl4aW4gZnJvbSBcIi4uLy4uLy4uL21peGlucy9pY29uTWl4aW5cIjtcbmltcG9ydCB7TW9kYWx9IGZyb20gXCJib290c3RyYXBcIjtcblxuZXhwb3J0IGRlZmF1bHQge1xuXHRuYW1lOiBcIkFkZEZvbGRlcldpemFyZFwiLFxuXHRjb21wb25lbnRzOiB7XG5cdFx0SWNvbixcblx0fSxcblx0cHJvcHM6IHtcblx0XHRkZXN0aW5hdGlvbjoge1xuXHRcdFx0dHlwZTogU3RyaW5nLFxuXHRcdFx0ZGVmYXVsdDogXCIvXCIsXG5cdFx0fSxcblx0XHRsb2NhdGlvbklkOiB7XG5cdFx0XHR0eXBlOiBOdW1iZXIsXG5cdFx0XHRkZWZhdWx0OiAwLFxuXHRcdH0sXG5cdH0sXG5cdG1peGluczogW2Vycm9yTW9kYWxNaXhpbiwgaWNvbk1peGluXSxcblx0ZGF0YSgpIHtcblx0XHRyZXR1cm4ge1xuXHRcdFx0ZGlzYWJsZUFkZEZvbGRlckJ1dHRvbjogdHJ1ZSxcblx0XHRcdGZvbGRlckRlc2NyaXB0aW9uTW9kZWw6IFwiXCIsXG5cdFx0fTtcblx0fSxcblx0Y29tcHV0ZWQ6IHtcblx0XHQuLi5tYXBHZXR0ZXJzKHtcblx0XHRcdGV4aXN0aW5nRm9sZGVyczogXCJnZXRGb2xkZXJGaWx0ZXJlZExpc3RcIixcblx0XHRcdGN1cnJlbnRGb2xkZXI6IFwiZ2V0Q3VycmVudEZvbGRlclwiLFxuXHRcdFx0cm9vdFVybDogXCJnZXRSb290VXJsXCIsXG5cdFx0fSksXG5cdH0sXG5cdG1ldGhvZHM6IHtcblx0XHRhZGRGb2xkZXIoKSB7XG5cdFx0XHQvL0NvbnN0cnVjdCB0aGUgZGF0YSB0byBzZW5kXG5cdFx0XHRjb25zdCBkYXRhX3RvX3NlbmQgPSBuZXcgRm9ybURhdGEoKTtcblx0XHRcdGRhdGFfdG9fc2VuZC5zZXQoXG5cdFx0XHRcdFwiZm9sZGVyX2Rlc2NyaXB0aW9uXCIsXG5cdFx0XHRcdHRoaXMuZm9sZGVyRGVzY3JpcHRpb25Nb2RlbFxuXHRcdFx0KTtcblxuXHRcdFx0aWYgKHRoaXMuY3VycmVudEZvbGRlciA+IDApIHtcblx0XHRcdFx0ZGF0YV90b19zZW5kLnNldChcInBhcmVudF9mb2xkZXJcIiwgdGhpcy5jdXJyZW50Rm9sZGVyKTtcblx0XHRcdH1cblxuXHRcdFx0Ly9TZW5kIHRoZSBkYXRhIGluIFBPU1Rcblx0XHRcdHRoaXMuYXhpb3Ncblx0XHRcdFx0LnBvc3QoXG5cdFx0XHRcdFx0YCR7dGhpcy5yb290VXJsfWRvY3VtZW50YXRpb24vJHt0aGlzLmRlc3RpbmF0aW9ufS8ke3RoaXMubG9jYXRpb25JZH0vYWRkX2ZvbGRlci9gLFxuXHRcdFx0XHRcdGRhdGFfdG9fc2VuZFxuXHRcdFx0XHQpXG5cdFx0XHRcdC50aGVuKChyZXNwb25zZSkgPT4ge1xuXHRcdFx0XHRcdC8vVXBkYXRlIHRoZSBGb2xkZXIgTGlzdCBpbiBWdWVYXG5cdFx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJhcHBlbmRGb2xkZXJMaXN0XCIsIHtcblx0XHRcdFx0XHRcdGZvbGRlckxpc3Q6IHJlc3BvbnNlLmRhdGFbMF0sXG5cdFx0XHRcdFx0fSk7XG5cblx0XHRcdFx0XHQvL0NsZWFyIHRoZSBtb2RlbFxuXHRcdFx0XHRcdHRoaXMuZm9sZGVyRGVzY3JpcHRpb25Nb2RlbCA9IFwiXCI7XG5cblx0XHRcdFx0XHQvL0Nsb3NlIHRoZSBtb2RhbFxuXHRcdFx0XHRcdGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKFwiYWRkRm9sZGVyQ2xvc2VCdXR0b25cIikuY2xpY2soKTtcblxuXHRcdFx0XHRcdC8vUmVzaG93IHRoZSBjYXJkIGluZm9ybWF0aW9uIG1vZGFsIGlmIGV4aXN0c1xuXHRcdFx0XHRcdGxldCBjYXJkTW9kYWwgPSBkb2N1bWVudC5nZXRFbGVtZW50QnlJZChcImNhcmRJbmZvcm1hdGlvbk1vZGFsXCIpO1xuXHRcdFx0XHRcdGlmIChjYXJkTW9kYWwgIT09IG51bGwpXG5cdFx0XHRcdFx0e1xuXHRcdFx0XHRcdFx0Y2FyZE1vZGFsID0gbmV3IE1vZGFsKGNhcmRNb2RhbCk7XG5cdFx0XHRcdFx0XHRjYXJkTW9kYWwuc2hvdygpO1xuXHRcdFx0XHRcdH1cblx0XHRcdFx0fSlcblx0XHRcdFx0LmNhdGNoKChlcnJvcikgPT4ge1xuXHRcdFx0XHRcdHRoaXMuc2hvd0Vycm9yTW9kYWwoZXJyb3IsIHRoaXMuZGVzdGluYXRpb24pO1xuXHRcdFx0XHR9KTtcblx0XHR9LFxuXHR9LFxuXHR1cGRhdGVkKCkge1xuXHRcdC8qSWYgdGhlcmUgaXMgbm8gZm9sZGVyIGRlc2NyaXB0aW9uIE9SIHRoZSBmb2xkZXIgZGVzY3JpcHRpb24gYWxyZWFkeSBleGlzdHMgLSB3ZSB3YW50IHRvIGRpc2FibGUgdGhlIGFkZFxuXHRcdGJ1dHRvbi4qL1xuXHRcdGNvbnN0IG1hdGNoID0gdGhpcy5leGlzdGluZ0ZvbGRlcnMuZmlsdGVyKChyb3cpID0+IHtcblx0XHRcdHJldHVybiAoXG5cdFx0XHRcdHJvdy5maWVsZHMuZm9sZGVyX2Rlc2NyaXB0aW9uID09PSB0aGlzLmZvbGRlckRlc2NyaXB0aW9uTW9kZWxcblx0XHRcdCk7XG5cdFx0fSk7XG5cblx0XHR0aGlzLmRpc2FibGVBZGRGb2xkZXJCdXR0b24gPVxuXHRcdFx0bWF0Y2gubGVuZ3RoID4gMCB8fCB0aGlzLmZvbGRlckRlc2NyaXB0aW9uTW9kZWwgPT09IFwiXCIgfHwgdGhpcy5mb2xkZXJEZXNjcmlwdGlvbk1vZGVsID09PSBudWxsO1xuXHR9LFxufTtcbjwvc2NyaXB0PlxuXG48c3R5bGUgc2NvcGVkPjwvc3R5bGU+XG4iLCJpbXBvcnQgeyByZW5kZXIgfSBmcm9tIFwiLi9BZGRMaW5rV2l6YXJkLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD0wY2VhMTJmYlwiXG5pbXBvcnQgc2NyaXB0IGZyb20gXCIuL0FkZExpbmtXaXphcmQudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCJcbmV4cG9ydCAqIGZyb20gXCIuL0FkZExpbmtXaXphcmQudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCJcblxuaW1wb3J0IGV4cG9ydENvbXBvbmVudCBmcm9tIFwiLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9leHBvcnRIZWxwZXIuanNcIlxuY29uc3QgX19leHBvcnRzX18gPSAvKiNfX1BVUkVfXyovZXhwb3J0Q29tcG9uZW50KHNjcmlwdCwgW1sncmVuZGVyJyxyZW5kZXJdLFsnX19maWxlJyxcInNyYy9qcy9jb21wb25lbnRzL21vZHVsZXMvd2l6YXJkcy9BZGRMaW5rV2l6YXJkLnZ1ZVwiXV0pXG4vKiBob3QgcmVsb2FkICovXG5pZiAobW9kdWxlLmhvdCkge1xuICBfX2V4cG9ydHNfXy5fX2htcklkID0gXCIwY2VhMTJmYlwiXG4gIGNvbnN0IGFwaSA9IF9fVlVFX0hNUl9SVU5USU1FX19cbiAgbW9kdWxlLmhvdC5hY2NlcHQoKVxuICBpZiAoIWFwaS5jcmVhdGVSZWNvcmQoJzBjZWExMmZiJywgX19leHBvcnRzX18pKSB7XG4gICAgYXBpLnJlbG9hZCgnMGNlYTEyZmInLCBfX2V4cG9ydHNfXylcbiAgfVxuICBcbiAgbW9kdWxlLmhvdC5hY2NlcHQoXCIuL0FkZExpbmtXaXphcmQudnVlP3Z1ZSZ0eXBlPXRlbXBsYXRlJmlkPTBjZWExMmZiXCIsICgpID0+IHtcbiAgICBhcGkucmVyZW5kZXIoJzBjZWExMmZiJywgcmVuZGVyKVxuICB9KVxuXG59XG5cblxuZXhwb3J0IGRlZmF1bHQgX19leHBvcnRzX18iLCI8dGVtcGxhdGU+XG5cdDxkaXZcblx0XHRjbGFzcz1cIm1vZGFsIGZhZGVcIlxuXHRcdGlkPVwiYWRkTGlua01vZGFsXCJcblx0XHR0YWJpbmRleD1cIi0xXCJcblx0XHRhcmlhLWxhYmVsbGVkYnk9XCJleGFtcGxlTW9kYWxMYWJlbFwiXG5cdFx0YXJpYS1oaWRkZW49XCJ0cnVlXCJcblx0PlxuXHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1kaWFsb2cgbW9kYWwtbGdcIj5cblx0XHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1jb250ZW50XCI+XG5cdFx0XHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1oZWFkZXJcIj5cblx0XHRcdFx0XHQ8aDI+XG5cdFx0XHRcdFx0XHQ8SWNvbiB2LWJpbmQ6aWNvbj1cImljb25zLnVzZXJJY29uXCI+PC9JY29uPlxuXHRcdFx0XHRcdFx0QWRkIExpbmtcblx0XHRcdFx0XHRcdFdpemFyZFxuXHRcdFx0XHRcdDwvaDI+XG5cdFx0XHRcdFx0PGJ1dHRvblxuXHRcdFx0XHRcdFx0dHlwZT1cImJ1dHRvblwiXG5cdFx0XHRcdFx0XHRjbGFzcz1cImJ0bi1jbG9zZVwiXG5cdFx0XHRcdFx0XHRkYXRhLWJzLWRpc21pc3M9XCJtb2RhbFwiXG5cdFx0XHRcdFx0XHRhcmlhLWxhYmVsPVwiQ2xvc2VcIlxuXHRcdFx0XHRcdFx0aWQ9XCJhZGRMaW5rQ2xvc2VCdXR0b25cIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdDxzcGFuIGFyaWEtaGlkZGVuPVwidHJ1ZVwiPjwvc3Bhbj5cblx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1ib2R5XCI+XG5cdFx0XHRcdFx0PGRpdiBjbGFzcz1cInJvd1wiPlxuXHRcdFx0XHRcdFx0PGRpdiBjbGFzcz1cImNvbC1tZC00XCI+XG5cdFx0XHRcdFx0XHRcdDxzdHJvbmc+QWRkIExpbms8L3N0cm9uZz5cblx0XHRcdFx0XHRcdFx0PHAgY2xhc3M9XCJ0ZXh0LWluc3RydWN0aW9uXCI+XG5cdFx0XHRcdFx0XHRcdFx0QWRkIGh5cGVybGlua3MgdG8gb3RoZXIgZG9jdW1lbnRzIGFuZCBzb3VyY2VzXG5cdFx0XHRcdFx0XHRcdFx0bG9jYXRlZCBpbiBvbiB0aGUgaW50ZXJuZXQvY2xvdWQuXG5cdFx0XHRcdFx0XHRcdDwvcD5cblx0XHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHRcdFx0PGRpdiBjbGFzcz1cImNvbC1tZC04XCI+XG5cdFx0XHRcdFx0XHRcdDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCI+XG5cdFx0XHRcdFx0XHRcdFx0PGxhYmVsIGZvcj1cImRvY3VtZW50X2Rlc2NyaXB0aW9uXCI+XG5cdFx0XHRcdFx0XHRcdFx0XHREb2N1bWVudCBEZXNjcmlwdGlvblxuXHRcdFx0XHRcdFx0XHRcdFx0PHZhbGlkYXRpb24tcmVuZGVyaW5nXG5cdFx0XHRcdFx0XHRcdFx0XHRcdHYtYmluZDplcnJvci1saXN0PVwidiQuZG9jdW1lbnREZXNjcmlwdGlvbk1vZGVsLiRlcnJvcnNcIlxuXHRcdFx0XHRcdFx0XHRcdFx0PjwvdmFsaWRhdGlvbi1yZW5kZXJpbmc+XG5cdFx0XHRcdFx0XHRcdFx0XHQ8c3BhblxuXHRcdFx0XHRcdFx0XHRcdFx0XHRjbGFzcz1cImVycm9yXCJcblx0XHRcdFx0XHRcdFx0XHRcdFx0di1pZj1cImR1cGxpY2F0ZURlc2NyaXB0aW9uXCJcblx0XHRcdFx0XHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFx0XHRcdFx0U29ycnkgLSBidXQgdGhpcyBpcyBhIGR1cGxpY2F0ZWRcblx0XHRcdFx0XHRcdFx0XHRcdFx0ZGVzY3JpcHRpb24uPC9zcGFuXG5cdFx0XHRcdFx0XHRcdFx0XHQ+XG5cdFx0XHRcdFx0XHRcdFx0PC9sYWJlbD5cblx0XHRcdFx0XHRcdFx0XHQ8aW5wdXRcblx0XHRcdFx0XHRcdFx0XHRcdGlkPVwiZG9jdW1lbnRfZGVzY3JpcHRpb25cIlxuXHRcdFx0XHRcdFx0XHRcdFx0di1tb2RlbD1cImRvY3VtZW50RGVzY3JpcHRpb25Nb2RlbFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRjbGFzcz1cImZvcm0tY29udHJvbFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRtYXhsZW5ndGg9XCI1MFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRwbGFjZWhvbGRlcj1cIk5lYXJCZWFjaCBIb21lcGFnZVwiXG5cdFx0XHRcdFx0XHRcdFx0Lz5cblx0XHRcdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdFx0XHRcdDxkaXYgY2xhc3M9XCJmb3JtLWdyb3VwXCI+XG5cdFx0XHRcdFx0XHRcdFx0PGxhYmVsIGZvcj1cImRvY3VtZW50X3VybF9sb2NhdGlvblwiPlxuXHRcdFx0XHRcdFx0XHRcdFx0RG9jdW1lbnQgVVJMXG5cdFx0XHRcdFx0XHRcdFx0XHQ8dmFsaWRhdGlvbi1yZW5kZXJpbmdcblx0XHRcdFx0XHRcdFx0XHRcdFx0di1iaW5kOmVycm9yLWxpc3Q9XCJ2JC5kb2N1bWVudFVybExvY2F0aW9uTW9kZWwuJGVycm9yc1wiXG5cdFx0XHRcdFx0XHRcdFx0XHQ+PC92YWxpZGF0aW9uLXJlbmRlcmluZz5cblx0XHRcdFx0XHRcdFx0XHQ8L2xhYmVsPlxuXHRcdFx0XHRcdFx0XHRcdDxpbnB1dFxuXHRcdFx0XHRcdFx0XHRcdFx0aWQ9XCJkb2N1bWVudF91cmxfbG9jYXRpb25cIlxuXHRcdFx0XHRcdFx0XHRcdFx0di1tb2RlbD1cImRvY3VtZW50VXJsTG9jYXRpb25Nb2RlbFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRjbGFzcz1cImZvcm0tY29udHJvbFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRwbGFjZWhvbGRlcj1cImh0dHBzOi8vbmVhcmJlYWNoLm9yZ1wiXG5cdFx0XHRcdFx0XHRcdFx0Lz5cblx0XHRcdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1mb290ZXJcIj5cblx0XHRcdFx0XHQ8YnV0dG9uXG5cdFx0XHRcdFx0XHR0eXBlPVwiYnV0dG9uXCJcblx0XHRcdFx0XHRcdGNsYXNzPVwiYnRuIGJ0bi1zZWNvbmRhcnlcIlxuXHRcdFx0XHRcdFx0ZGF0YS1icy1kaXNtaXNzPVwibW9kYWxcIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdENsb3NlXG5cdFx0XHRcdFx0PC9idXR0b24+XG5cdFx0XHRcdFx0PGJ1dHRvblxuXHRcdFx0XHRcdFx0dHlwZT1cImJ1dHRvblwiXG5cdFx0XHRcdFx0XHRjbGFzcz1cImJ0biBidG4tcHJpbWFyeVwiXG5cdFx0XHRcdFx0XHR2LW9uOmNsaWNrPVwiYWRkTGlua1wiXG5cdFx0XHRcdFx0XHR2LWJpbmQ6ZGlzYWJsZWQ9XCJkaXNhYmxlQWRkQnV0dG9uXCJcblx0XHRcdFx0XHQ+XG5cdFx0XHRcdFx0XHRBZGQgTGlua1xuXHRcdFx0XHRcdDwvYnV0dG9uPlxuXHRcdFx0XHQ8L2Rpdj5cblx0XHRcdDwvZGl2PlxuXHRcdDwvZGl2PlxuXHQ8L2Rpdj5cbjwvdGVtcGxhdGU+XG5cbjxzY3JpcHQ+XG5pbXBvcnQge0ljb259IGZyb20gXCJAaWNvbmlmeS92dWVcIjtcblxuLy9WdWVYXG5pbXBvcnQge21hcEdldHRlcnN9IGZyb20gXCJ2dWV4XCI7XG5cbi8vTWl4aW5zXG5pbXBvcnQgaWNvbk1peGluIGZyb20gXCIuLi8uLi8uLi9taXhpbnMvaWNvbk1peGluXCI7XG5cbi8vVmFsaWRhdGlvblxuaW1wb3J0IHVzZVZ1ZWxpZGF0ZSBmcm9tIFwiQHZ1ZWxpZGF0ZS9jb3JlXCI7XG5pbXBvcnQge3JlcXVpcmVkLCB1cmx9IGZyb20gXCJAdnVlbGlkYXRlL3ZhbGlkYXRvcnNcIjtcbmltcG9ydCBWYWxpZGF0aW9uUmVuZGVyaW5nIGZyb20gXCIuLi8uLi92YWxpZGF0aW9uL1ZhbGlkYXRpb25SZW5kZXJpbmcudnVlXCI7XG5pbXBvcnQge01vZGFsfSBmcm9tIFwiYm9vdHN0cmFwXCI7XG5cbmV4cG9ydCBkZWZhdWx0IHtcblx0bmFtZTogXCJBZGRMaW5rV2l6YXJkXCIsXG5cdHNldHVwKCkge1xuXHRcdHJldHVybiB7diQ6IHVzZVZ1ZWxpZGF0ZSgpfTtcblx0fSxcblx0Y29tcG9uZW50czoge1xuXHRcdEljb24sXG5cdFx0VmFsaWRhdGlvblJlbmRlcmluZyxcblx0fSxcblx0cHJvcHM6IHtcblx0XHRkZXN0aW5hdGlvbjoge1xuXHRcdFx0dHlwZTogU3RyaW5nLFxuXHRcdFx0ZGVmYXVsdDogXCIvXCIsXG5cdFx0fSxcblx0XHRsb2NhdGlvbklkOiB7XG5cdFx0XHR0eXBlOiBOdW1iZXIsXG5cdFx0XHRkZWZhdWx0OiAwLFxuXHRcdH0sXG5cdH0sXG5cdG1peGluczogW2ljb25NaXhpbl0sXG5cdGRhdGEoKSB7XG5cdFx0cmV0dXJuIHtcblx0XHRcdGxpbmtNb2RlbDogXCJcIixcblx0XHRcdGRpc2FibGVBZGRCdXR0b246IHRydWUsXG5cdFx0XHRkb2N1bWVudERlc2NyaXB0aW9uTW9kZWw6IFwiXCIsXG5cdFx0XHRkb2N1bWVudFVybExvY2F0aW9uTW9kZWw6IFwiXCIsXG5cdFx0XHRkdXBsaWNhdGVEZXNjcmlwdGlvbjogZmFsc2UsXG5cdFx0fTtcblx0fSxcblx0dmFsaWRhdGlvbnM6IHtcblx0XHRkb2N1bWVudERlc2NyaXB0aW9uTW9kZWw6IHtcblx0XHRcdHJlcXVpcmVkLFxuXHRcdH0sXG5cdFx0ZG9jdW1lbnRVcmxMb2NhdGlvbk1vZGVsOiB7XG5cdFx0XHRyZXF1aXJlZCxcblx0XHRcdHVybCxcblx0XHR9LFxuXHR9LFxuXHRjb21wdXRlZDoge1xuXHRcdC4uLm1hcEdldHRlcnMoe1xuXHRcdFx0Y3VycmVudEZvbGRlcjogXCJnZXRDdXJyZW50Rm9sZGVyXCIsXG5cdFx0XHRleGNsdWRlRG9jdW1lbnRzOiBcImdldERvY3VtZW50RmlsdGVyZWRMaXN0XCIsXG5cdFx0XHRyb290VXJsOiBcImdldFJvb3RVcmxcIixcblx0XHR9KSxcblx0fSxcblx0bWV0aG9kczoge1xuXHRcdGFkZExpbmsoKSB7XG5cdFx0XHRjb25zdCBkYXRhX3RvX3NlbmQgPSBuZXcgRm9ybURhdGEoKTtcblx0XHRcdGRhdGFfdG9fc2VuZC5zZXQoXG5cdFx0XHRcdFwiZG9jdW1lbnRfZGVzY3JpcHRpb25cIixcblx0XHRcdFx0dGhpcy5kb2N1bWVudERlc2NyaXB0aW9uTW9kZWxcblx0XHRcdCk7XG5cdFx0XHRkYXRhX3RvX3NlbmQuc2V0KFxuXHRcdFx0XHRcImRvY3VtZW50X3VybF9sb2NhdGlvblwiLFxuXHRcdFx0XHR0aGlzLmRvY3VtZW50VXJsTG9jYXRpb25Nb2RlbFxuXHRcdFx0KTtcblxuXHRcdFx0Ly9Pbmx5IHNldCB0aGUgcGFyZW50IGZvbGRlciB2YXJpYWJsZSBpZiB0aGVyZSBleGlzdHMgYSB2YXJpYWJsZSBpbiBjdXJyZW50IGZvbGRlclxuXHRcdFx0aWYgKHRoaXMuY3VycmVudEZvbGRlciA+IDApIHtcblx0XHRcdFx0ZGF0YV90b19zZW5kLnNldChcInBhcmVudF9mb2xkZXJcIiwgdGhpcy5jdXJyZW50Rm9sZGVyKTtcblx0XHRcdH1cblxuXHRcdFx0dGhpcy5heGlvcy5wb3N0KFxuXHRcdFx0XHRgJHt0aGlzLnJvb3RVcmx9ZG9jdW1lbnRhdGlvbi8ke3RoaXMuZGVzdGluYXRpb259LyR7dGhpcy5sb2NhdGlvbklkfS9hZGRfbGluay9gLFxuXHRcdFx0XHRkYXRhX3RvX3NlbmRcblx0XHRcdCkudGhlbigocmVzcG9uc2UpID0+IHtcblx0XHRcdFx0Ly9BcHBlbmQgc29tZXRoaW5nIHRvIGRvY3VtZW50IExpc3Rcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJhcHBlbmREb2N1bWVudExpc3RcIiwge1xuXHRcdFx0XHRcdGRvY3VtZW50TGlzdDogcmVzcG9uc2UuZGF0YVswXSxcblx0XHRcdFx0fSk7XG5cblx0XHRcdFx0Ly9DbGVhciB0aGUgZGF0YVxuXHRcdFx0XHR0aGlzLmRvY3VtZW50RGVzY3JpcHRpb25Nb2RlbCA9IFwiXCI7XG5cdFx0XHRcdHRoaXMuZG9jdW1lbnRVcmxMb2NhdGlvbk1vZGVsID0gXCJcIjtcblxuXHRcdFx0XHQvL0Nsb3NlIHRoZSBtb2RhbFxuXHRcdFx0XHRkb2N1bWVudC5nZXRFbGVtZW50QnlJZChcImFkZExpbmtDbG9zZUJ1dHRvblwiKS5jbGljaygpO1xuXG5cdFx0XHRcdC8vUmVzaG93IHRoZSBjYXJkIGluZm9ybWF0aW9uIG1vZGFsIGlmIGV4aXN0c1xuXHRcdFx0XHRsZXQgY2FyZE1vZGFsID0gZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoXCJjYXJkSW5mb3JtYXRpb25Nb2RhbFwiKTtcblx0XHRcdFx0aWYgKGNhcmRNb2RhbCAhPT0gbnVsbClcblx0XHRcdFx0e1xuXHRcdFx0XHRcdGNhcmRNb2RhbCA9IG5ldyBNb2RhbChjYXJkTW9kYWwpO1xuXHRcdFx0XHRcdGNhcmRNb2RhbC5zaG93KCk7XG5cdFx0XHRcdH1cblx0XHRcdH0pLmNhdGNoKChlcnJvcikgPT4ge1xuXHRcdFx0XHR0aGlzLiRzdG9yZS5kaXNwYXRjaChcIm5ld1RvYXN0XCIsIHtcblx0XHRcdFx0XHRoZWFkZXI6IFwiRXJyb3IgQWRkaW5nIExpbmtcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBgU29ycnksIGNvdWxkIG5vdCBhZGQgdGhlIGxpbmsgZm9yIHlvdS4gRXJyb3IgLSAke2Vycm9yfWAsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1kYW5nZXJcIixcblx0XHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0fSk7XG5cdFx0XHR9KTtcblx0XHR9LFxuXHR9LFxuXHR1cGRhdGVkKCkge1xuXHRcdC8vV2UgbmVlZCB0byBtYWtlIHN1cmUgYm90aCBmaWVsZHMgYXJlIG5vdCBibGFuayAmIHRvIG1ha2Ugc3VyZSB0aGUgZGVzY3JpcHRpb24gaXMgbm90IGR1cGxpY2F0ZWRcblx0XHRjb25zdCBtYXRjaCA9IHRoaXMuZXhjbHVkZURvY3VtZW50cy5maWx0ZXIoKHJvdykgPT4ge1xuXHRcdFx0cmV0dXJuIChcblx0XHRcdFx0cm93LmRvY3VtZW50X2tleV9fZG9jdW1lbnRfZGVzY3JpcHRpb24gPT09XG5cdFx0XHRcdHRoaXMuZG9jdW1lbnREZXNjcmlwdGlvbk1vZGVsXG5cdFx0XHQpO1xuXHRcdH0pO1xuXG5cdFx0Ly9Ob3RpZnkgdGhlIHVzZXIgb2YgZHVwbGljYXRlIGRlc2NyaXB0aW9ucyAoaWYgdGhlcmUgaXMgYW55KVxuXHRcdHRoaXMuZHVwbGljYXRlRGVzY3JpcHRpb24gPSBtYXRjaC5sZW5ndGggPiAwO1xuXG5cdFx0Ly8gQ2hlY2sgdGhlIHZhbGlkYXRpb25cblx0XHR0aGlzLnYkLiR0b3VjaCgpO1xuXG5cdFx0Ly9EaXNhYmxlIHRoZSBidXR0b24gKGlmIGl0IGRvZXMgbm90IG1lZXQgb3VyIHN0YW5kYXJkcylcblx0XHR0aGlzLmRpc2FibGVBZGRCdXR0b24gPSB0aGlzLnYkLiRpbnZhbGlkIHx8IG1hdGNoLmxlbmd0aCA+IDA7XG5cdH0sXG59O1xuPC9zY3JpcHQ+XG5cbjxzdHlsZSBzY29wZWQ+PC9zdHlsZT5cbiIsImltcG9ydCB7IHJlbmRlciB9IGZyb20gXCIuL0NvbmZpcm1GaWxlRGVsZXRlLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD0xNGQzOTM5Y1wiXG5pbXBvcnQgc2NyaXB0IGZyb20gXCIuL0NvbmZpcm1GaWxlRGVsZXRlLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiXG5leHBvcnQgKiBmcm9tIFwiLi9Db25maXJtRmlsZURlbGV0ZS52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIlxuXG5pbXBvcnQgZXhwb3J0Q29tcG9uZW50IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2V4cG9ydEhlbHBlci5qc1wiXG5jb25zdCBfX2V4cG9ydHNfXyA9IC8qI19fUFVSRV9fKi9leHBvcnRDb21wb25lbnQoc2NyaXB0LCBbWydyZW5kZXInLHJlbmRlcl0sWydfX2ZpbGUnLFwic3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL0NvbmZpcm1GaWxlRGVsZXRlLnZ1ZVwiXV0pXG4vKiBob3QgcmVsb2FkICovXG5pZiAobW9kdWxlLmhvdCkge1xuICBfX2V4cG9ydHNfXy5fX2htcklkID0gXCIxNGQzOTM5Y1wiXG4gIGNvbnN0IGFwaSA9IF9fVlVFX0hNUl9SVU5USU1FX19cbiAgbW9kdWxlLmhvdC5hY2NlcHQoKVxuICBpZiAoIWFwaS5jcmVhdGVSZWNvcmQoJzE0ZDM5MzljJywgX19leHBvcnRzX18pKSB7XG4gICAgYXBpLnJlbG9hZCgnMTRkMzkzOWMnLCBfX2V4cG9ydHNfXylcbiAgfVxuICBcbiAgbW9kdWxlLmhvdC5hY2NlcHQoXCIuL0NvbmZpcm1GaWxlRGVsZXRlLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD0xNGQzOTM5Y1wiLCAoKSA9PiB7XG4gICAgYXBpLnJlcmVuZGVyKCcxNGQzOTM5YycsIHJlbmRlcilcbiAgfSlcblxufVxuXG5cbmV4cG9ydCBkZWZhdWx0IF9fZXhwb3J0c19fIiwiPHRlbXBsYXRlPlxuXHQ8ZGl2XG5cdFx0Y2xhc3M9XCJtb2RhbCBmYWRlXCJcblx0XHRpZD1cImNvbmZpcm1GaWxlRGVsZXRlTW9kYWxcIlxuXHRcdHRhYmluZGV4PVwiLTFcIlxuXHRcdGRhdGEtYnMtYmFja2Ryb3A9XCJzdGF0aWNcIlxuXHRcdGRhdGEtYnMta2V5Ym9hcmQ9XCJmYWxzZVwiXG5cdFx0YXJpYS1sYWJlbGxlZGJ5PVwiY29uZmlybUZpbGVEZWxldGVcIlxuXHRcdGFyaWEtaGlkZGVuPVwidHJ1ZVwiXG5cdD5cblx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtZGlhbG9nXCI+XG5cdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtY29udGVudFwiPlxuXHRcdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtaGVhZGVyXCI+XG5cdFx0XHRcdFx0PGg1XG5cdFx0XHRcdFx0XHRjbGFzcz1cIm1vZGFsLXRpdGxlXCJcblx0XHRcdFx0XHRcdGlkPVwiY29uZmlybUZpbGVEZWxldGVcIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFBsZWFzZSBjb25maXJtIEZpbGUgRGVsZXRpb25cblx0XHRcdFx0XHQ8L2g1PlxuXHRcdFx0XHRcdDwhLS0gVEFTSyBJTkZPUk1BVElPTiAtLT5cblx0XHRcdFx0XHQ8YnV0dG9uXG5cdFx0XHRcdFx0XHR0eXBlPVwiYnV0dG9uXCJcblx0XHRcdFx0XHRcdGNsYXNzPVwiYnRuLWNsb3NlXCJcblx0XHRcdFx0XHRcdGRhdGEtYnMtZGlzbWlzcz1cIm1vZGFsXCJcblx0XHRcdFx0XHRcdGFyaWEtbGFiZWw9XCJDbG9zZVwiXG5cdFx0XHRcdFx0XHRpZD1cImNvbmZpcm1GaWxlRGVsZXRlQnV0dG9uXCJcblx0XHRcdFx0XHQ+PC9idXR0b24+XG5cdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtYm9keVwiPlxuXHRcdFx0XHRcdEFyZSB5b3Ugc3VyZSB5b3Ugd2FudCB0byBkZWxldGUgdGhlIGZpbGU/XG5cdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtZm9vdGVyXCI+XG5cdFx0XHRcdFx0PGJ1dHRvblxuXHRcdFx0XHRcdFx0dHlwZT1cImJ1dHRvblwiXG5cdFx0XHRcdFx0XHRjbGFzcz1cImJ0biBidG4tc2Vjb25kYXJ5XCJcblx0XHRcdFx0XHRcdHYtb246Y2xpY2s9XCJjbG9zZU1vZGFsXCJcblx0XHRcdFx0XHQ+XG5cdFx0XHRcdFx0XHROb1xuXHRcdFx0XHRcdDwvYnV0dG9uPlxuXHRcdFx0XHRcdDxidXR0b25cblx0XHRcdFx0XHRcdHR5cGU9XCJidXR0b25cIlxuXHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4gYnRuLXByaW1hcnlcIlxuXHRcdFx0XHRcdFx0di1vbjpjbGljaz1cImRlbGV0ZUZpbGVcIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFllc1xuXHRcdFx0XHRcdDwvYnV0dG9uPlxuXHRcdFx0XHQ8L2Rpdj5cblx0XHRcdDwvZGl2PlxuXHRcdDwvZGl2PlxuXHQ8L2Rpdj5cbjwvdGVtcGxhdGU+XG5cbjxzY3JpcHQ+XG5pbXBvcnQge21hcEdldHRlcnN9IGZyb20gXCJ2dWV4XCI7XG5pbXBvcnQge01vZGFsfSBmcm9tIFwiYm9vdHN0cmFwXCI7XG5cbmV4cG9ydCBkZWZhdWx0IHtcblx0bmFtZTogXCJDb25maXJtRmlsZURlbGV0ZVwiLFxuXHRjb21wdXRlZDoge1xuXHRcdC4uLm1hcEdldHRlcnMoe1xuXHRcdFx0ZGVzdGluYXRpb246IFwiZ2V0RGVzdGluYXRpb25cIixcblx0XHRcdGRvY3VtZW50UmVtb3ZlS2V5OiBcImdldERvY3VtZW50UmVtb3ZlS2V5XCIsXG5cdFx0XHRsb2NhdGlvbklkOiBcImdldExvY2F0aW9uSWRcIixcblx0XHRcdHJvb3RVcmw6IFwiZ2V0Um9vdFVybFwiLFxuXHRcdH0pXG5cdH0sXG5cdG1ldGhvZHM6IHtcblx0XHRkZWxldGVGaWxlKCkge1xuXHRcdFx0Ly9DaGVjayB0byBtYWtlIHN1cmUgaXQgaXNuJ3QgYmxhbmtcblx0XHRcdGlmICh0aGlzLmRvY3VtZW50UmVtb3ZlS2V5ID09PSBcIlwiKSB7XG5cdFx0XHRcdC8vV2UgZG9uJ3Qgd2FudCB0byByZW1vdmUgYSBibGFuayBmaWxlXG5cdFx0XHRcdHJldHVybjtcblx0XHRcdH1cblxuXHRcdFx0Ly9BeGlvcyBpcyBhIHByb21pc2UuIEl0IGlzIG5vdCBndWFyYW50ZWVkIHRoYXQgdGhlIGRvY3VtZW50UmVtb3ZlS2V5IHdpbGwgbm90IGJlIGJsYW5rZWQgb3V0IGJ5IHRoZSB0aW1lXG5cdFx0XHQvL2l0IGhhcyBmaW5pc2hlZCBpdCdzIHdlYiBxdWVyeS4gSGVuY2Ugd2UgY2FjaGUgdGhpcyBoZXJlLiA6KVxuXHRcdFx0Y29uc3QgY2FjaGVkX2RvY3VtZW50X3JlbW92ZV9rZXkgPSB0aGlzLmRvY3VtZW50UmVtb3ZlS2V5O1xuXG5cdFx0XHQvL0NyZWF0ZSBkYXRhX3RvX3NlbmRcblx0XHRcdGNvbnN0IGRhdGFfdG9fc2VuZCA9IG5ldyBGb3JtRGF0YSgpO1xuXHRcdFx0ZGF0YV90b19zZW5kLnNldChcImRvY3VtZW50X2tleVwiLCB0aGlzLmRvY3VtZW50UmVtb3ZlS2V5KTtcblxuXHRcdFx0dGhpcy5heGlvcy5wb3N0KFxuXHRcdFx0XHRgJHt0aGlzLnJvb3RVcmx9ZG9jdW1lbnRhdGlvbi8ke3RoaXMuZGVzdGluYXRpb259LyR7dGhpcy5sb2NhdGlvbklkfS9yZW1vdmUvYCxcblx0XHRcdFx0ZGF0YV90b19zZW5kLFxuXHRcdFx0KS50aGVuKCgpID0+IHtcblx0XHRcdFx0Ly9VcGRhdGUgVnVlWCAtIHJlbW92ZSB0aGF0IGRvY3VtZW50IGZyb20gdGhlIGxpc3Rcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJyZW1vdmVEb2N1bWVudFwiLCB7XG5cdFx0XHRcdFx0ZG9jdW1lbnRfa2V5OiBjYWNoZWRfZG9jdW1lbnRfcmVtb3ZlX2tleSxcblx0XHRcdFx0fSk7XG5cblx0XHRcdFx0Ly9DbG9zZSB0aGUgbW9kYWxcblx0XHRcdFx0dGhpcy5jbG9zZU1vZGFsKCk7XG5cdFx0XHR9KS5jYXRjaCgoZXJyb3IpID0+IHtcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdFx0aGVhZGVyOiBcIkVycm9yIHJlbW92aW5nIGZpbGVcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBgV2UgY291bGQgbm90IHJlbW92ZSB5b3VyIGZpbGUuIEVycm9yIC0gJHtlcnJvcn1gLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctZGFuZ2VyXCIsXG5cdFx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fSk7XG5cblx0XHRcdHRoaXMuY2xvc2VNb2RhbCgpO1xuXHRcdH0sXG5cdFx0Y2xvc2VNb2RhbCgpIHtcblx0XHRcdC8vWmVybyBvdXQgdGhlIGRvY3VtZW50IGtleSAoanVzdCBpbiBjYXNlKVxuXHRcdFx0dGhpcy4kc3RvcmUuY29tbWl0KHtcblx0XHRcdFx0dHlwZTogXCJ1cGRhdGVEb2N1bWVudFJlbW92ZUtleVwiLFxuXHRcdFx0XHRkb2N1bWVudFJlbW92ZUtleTogXCJcIixcblx0XHRcdH0pO1xuXG5cdFx0XHQvL0Nsb3NlIHRoZSBtb2RhbFxuXHRcdFx0ZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoXCJjb25maXJtRmlsZURlbGV0ZUJ1dHRvblwiKS5jbGljaygpO1xuXG5cdFx0XHQvL1Jlc2hvdyB0aGUgY2FyZCBpbmZvcm1hdGlvbiBtb2RhbCBpZiBleGlzdHNcblx0XHRcdGxldCBjYXJkTW9kYWwgPSBkb2N1bWVudC5nZXRFbGVtZW50QnlJZChcImNhcmRJbmZvcm1hdGlvbk1vZGFsXCIpO1xuXHRcdFx0aWYgKGNhcmRNb2RhbCAhPT0gbnVsbClcblx0XHRcdHtcblx0XHRcdFx0Y2FyZE1vZGFsID0gbmV3IE1vZGFsKGNhcmRNb2RhbCk7XG5cdFx0XHRcdGNhcmRNb2RhbC5zaG93KCk7XG5cblxuXHRcdFx0fVxuXG5cdFx0XHQvL0R1ZSB0byBhIGJ1ZyB3aXRoIGJvb3RzdHJhcCwgd2UgaGF2ZSB0d28gZGl2cyB3aXRoIGNsYXNzZXMgXCJtb2RhbC1iYWNrZHJvcCBmYWRlIHNob3dcIlxuXHRcdFx0Ly9MZXRzIHJlbW92ZSBvbmUgb2YgdGhlbVxuXHRcdFx0c2V0VGltZW91dCgoKSA9PiB7XG5cdFx0XHRcdGNvbnN0IGRpdl9tb2RhbCA9IGRvY3VtZW50LmdldEVsZW1lbnRzQnlDbGFzc05hbWUoXCJtb2RhbC1iYWNrZHJvcCBmYWRlIHNob3dcIik7XG5cdFx0XHRcdGlmIChkaXZfbW9kYWwubGVuZ3RoID4gMSkge1xuXHRcdFx0XHRcdGRpdl9tb2RhbFswXS5yZW1vdmUoKTtcblx0XHRcdFx0fVxuXHRcdFx0fSwgMjAwKTtcblx0XHR9XG5cdH0sXG59XG48L3NjcmlwdD5cbiIsImltcG9ydCB7IHJlbmRlciB9IGZyb20gXCIuL1VwbG9hZERvY3VtZW50V2l6YXJkLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD00Y2ViZjUzY1wiXG5pbXBvcnQgc2NyaXB0IGZyb20gXCIuL1VwbG9hZERvY3VtZW50V2l6YXJkLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiXG5leHBvcnQgKiBmcm9tIFwiLi9VcGxvYWREb2N1bWVudFdpemFyZC52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIlxuXG5pbXBvcnQgZXhwb3J0Q29tcG9uZW50IGZyb20gXCIuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2V4cG9ydEhlbHBlci5qc1wiXG5jb25zdCBfX2V4cG9ydHNfXyA9IC8qI19fUFVSRV9fKi9leHBvcnRDb21wb25lbnQoc2NyaXB0LCBbWydyZW5kZXInLHJlbmRlcl0sWydfX2ZpbGUnLFwic3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy93aXphcmRzL1VwbG9hZERvY3VtZW50V2l6YXJkLnZ1ZVwiXV0pXG4vKiBob3QgcmVsb2FkICovXG5pZiAobW9kdWxlLmhvdCkge1xuICBfX2V4cG9ydHNfXy5fX2htcklkID0gXCI0Y2ViZjUzY1wiXG4gIGNvbnN0IGFwaSA9IF9fVlVFX0hNUl9SVU5USU1FX19cbiAgbW9kdWxlLmhvdC5hY2NlcHQoKVxuICBpZiAoIWFwaS5jcmVhdGVSZWNvcmQoJzRjZWJmNTNjJywgX19leHBvcnRzX18pKSB7XG4gICAgYXBpLnJlbG9hZCgnNGNlYmY1M2MnLCBfX2V4cG9ydHNfXylcbiAgfVxuICBcbiAgbW9kdWxlLmhvdC5hY2NlcHQoXCIuL1VwbG9hZERvY3VtZW50V2l6YXJkLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD00Y2ViZjUzY1wiLCAoKSA9PiB7XG4gICAgYXBpLnJlcmVuZGVyKCc0Y2ViZjUzYycsIHJlbmRlcilcbiAgfSlcblxufVxuXG5cbmV4cG9ydCBkZWZhdWx0IF9fZXhwb3J0c19fIiwiPHRlbXBsYXRlPlxuXHQ8ZGl2XG5cdFx0Y2xhc3M9XCJtb2RhbCBmYWRlXCJcblx0XHRpZD1cInVwbG9hZERvY3VtZW50TW9kYWxcIlxuXHRcdGRhdGEtYnMtYmFja2Ryb3A9XCJzdGF0aWNcIlxuXHRcdGRhdGEtYnMta2V5Ym9hcmQ9XCJmYWxzZVwiXG5cdFx0dGFiaW5kZXg9XCItMVwiXG5cdFx0YXJpYS1sYWJlbGxlZGJ5PVwiZXhhbXBsZU1vZGFsTGFiZWxcIlxuXHRcdGFyaWEtaGlkZGVuPVwidHJ1ZVwiXG5cdD5cblx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtZGlhbG9nIG1vZGFsLWxnXCI+XG5cdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtY29udGVudFwiPlxuXHRcdFx0XHQ8ZGl2IGNsYXNzPVwibW9kYWwtaGVhZGVyXCI+XG5cdFx0XHRcdFx0PGgyPlxuXHRcdFx0XHRcdFx0PEljb24gdi1iaW5kOmljb249XCJpY29ucy51c2VySWNvblwiPjwvSWNvbj5cblx0XHRcdFx0XHRcdFVwbG9hZFxuXHRcdFx0XHRcdFx0RG9jdW1lbnQgV2l6YXJkXG5cdFx0XHRcdFx0PC9oMj5cblx0XHRcdFx0XHQ8YnV0dG9uXG5cdFx0XHRcdFx0XHR0eXBlPVwiYnV0dG9uXCJcblx0XHRcdFx0XHRcdGNsYXNzPVwiYnRuLWNsb3NlXCJcblx0XHRcdFx0XHRcdGRhdGEtYnMtZGlzbWlzcz1cIm1vZGFsXCJcblx0XHRcdFx0XHRcdGFyaWEtbGFiZWw9XCJDbG9zZVwiXG5cdFx0XHRcdFx0XHRpZD1cInVwbG9hZERvY3VtZW50Q2xvc2VCdXR0b25cIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdDxzcGFuIGFyaWEtaGlkZGVuPVwidHJ1ZVwiPjwvc3Bhbj5cblx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdDxkaXYgY2xhc3M9XCJtb2RhbC1ib2R5XCI+XG5cdFx0XHRcdFx0PGRpdiBjbGFzcz1cInJvd1wiPlxuXHRcdFx0XHRcdFx0PGRpdiBjbGFzcz1cImNvbC1tZC00XCI+XG5cdFx0XHRcdFx0XHRcdDxzdHJvbmc+VXBsb2FkaW5nIEZpbGU8L3N0cm9uZz5cblx0XHRcdFx0XHRcdFx0PHAgY2xhc3M9XCJ0ZXh0LWluc3RydWN0aW9uc1wiPlxuXHRcdFx0XHRcdFx0XHRcdFlvdSB3aWxsIGJlIGFibGUgdG8gdXBsb2FkIGEgZmlsZSBhZ2FpbnN0IHRoaXNcblx0XHRcdFx0XHRcdFx0XHR7eyBnZXREZXN0aW5hdGlvbiB9fS4gSXQgd2lsbCBhcHBlYXIgaW4gdGhlIGN1cnJlbnRcblx0XHRcdFx0XHRcdFx0XHRmb2xkZXIuXG5cdFx0XHRcdFx0XHRcdDwvcD5cblx0XHRcdFx0XHRcdFx0PHAgdi1pZj1cImRvY3VtZW50TW9kZWwubGVuZ3RoID09PSAwXCI+XG5cdFx0XHRcdFx0XHRcdFx0MS4gUGxlYXNlIGNsaWNrIG9uIFwiVXBsb2FkIEZpbGVcIiBidXR0b24gdG9cblx0XHRcdFx0XHRcdFx0XHR1cGxvYWQgYSBmaWxlXG5cdFx0XHRcdFx0XHRcdDwvcD5cblx0XHRcdFx0XHRcdFx0PHAgdi1lbHNlLWlmPVwidXBsb2FkUGVyY2VudGFnZSA9PT0gJydcIj5cblx0XHRcdFx0XHRcdFx0XHQyLiBQbGVhc2UgbW9kaWZ5IHRoZSBkb2N1bWVudCBkZXNjcmlwdCB0byBiZVxuXHRcdFx0XHRcdFx0XHRcdG1vcmUgaHVtYW4gcmVhZGFibGUuIE9yIGNsaWNrIHRoZSBcIlJlc2V0XCIgYnV0dG9uXG5cdFx0XHRcdFx0XHRcdFx0dG8gcmVtb3ZlIHRoZSB1cGxvYWRlZCBmaWxlLlxuXHRcdFx0XHRcdFx0XHQ8L3A+XG5cdFx0XHRcdFx0XHRcdDxwIHYtZWxzZT5cblx0XHRcdFx0XHRcdFx0XHQzLiBEb2N1bWVudCBpcyBjdXJyZW50bHkgdXBsb2FkaW5nLiBQbGVhc2UgYmVcblx0XHRcdFx0XHRcdFx0XHRwYXRpZW50LlxuXHRcdFx0XHRcdFx0XHQ8L3A+XG5cdFx0XHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0XHRcdDxkaXYgY2xhc3M9XCJjb2wtbWQtOFwiPlxuXHRcdFx0XHRcdFx0XHQ8ZGl2XG5cdFx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJmb3JtLWZpbGVcIlxuXHRcdFx0XHRcdFx0XHRcdHYtaWY9XCJkb2N1bWVudE1vZGVsLmxlbmd0aCA9PT0gMFwiXG5cdFx0XHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFx0XHQ8ZGl2IGNsYXNzPVwibWItM1wiPlxuXHRcdFx0XHRcdFx0XHRcdFx0PGxhYmVsXG5cdFx0XHRcdFx0XHRcdFx0XHRcdGZvcj1cImRvY3VtZW50XCJcblx0XHRcdFx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJmb3JtLWxhYmVsXCJcblx0XHRcdFx0XHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFx0XHRcdFx0UGxlYXNlIHVwbG9hZCBhIGZpbGU8YnIvPlxuXHRcdFx0XHRcdFx0XHRcdFx0XHR7eyBtYXhVcGxvYWRTdHJpbmcgfX1cblx0XHRcdFx0XHRcdFx0XHRcdFx0PGRpdlxuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdGNsYXNzPVwiYWxlcnQgYWxlcnQtd2FybmluZ1wiXG5cdFx0XHRcdFx0XHRcdFx0XHRcdFx0di1pZj1cIm1heFVwbG9hZFdhcm5pbmdcIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHQ+XG5cdFx0XHRcdFx0XHRcdFx0XHRcdFx0U29ycnkgLSBmaWxlIHRvbyBsYXJnZVxuXHRcdFx0XHRcdFx0XHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0XHRcdFx0XHRcdDwvbGFiZWw+XG5cdFx0XHRcdFx0XHRcdFx0XHQ8aW5wdXRcblx0XHRcdFx0XHRcdFx0XHRcdFx0dHlwZT1cImZpbGVcIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHRjbGFzcz1cImZvcm0tY29udHJvbFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRcdGlkPVwiZG9jdW1lbnRcIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHR2LWJpbmQ6YWNjZXB0PVwiYWNjZXB0ZWREb2N1bWVudHNcIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHR2LW9uOmNoYW5nZT1cIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdGhhbmRsZUZpbGVVcGxvYWRzKFxuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdFx0JGV2ZW50LnRhcmdldC5maWxlc1xuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdClcblx0XHRcdFx0XHRcdFx0XHRcdFx0XCJcblx0XHRcdFx0XHRcdFx0XHRcdC8+XG5cdFx0XHRcdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHRcdFx0XHQ8ZGl2XG5cdFx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJmb3JtLWdyb3VwXCJcblx0XHRcdFx0XHRcdFx0XHR2LWVsc2UtaWY9XCJ1cGxvYWRQZXJjZW50YWdlID09ICcnXCJcblx0XHRcdFx0XHRcdFx0PlxuXHRcdFx0XHRcdFx0XHRcdDwhLS0gRE9DVU1FTlQgREVTQ1JJUFRJT04gLS0+XG5cdFx0XHRcdFx0XHRcdFx0PGRpdiBjbGFzcz1cImZvcm0tZ3JvdXBcIj5cblx0XHRcdFx0XHRcdFx0XHRcdDxsYWJlbCBmb3I9XCJkb2N1bWVudERlc2NyaXB0aW9uXCJcblx0XHRcdFx0XHRcdFx0XHRcdD5Eb2N1bWVudCBEZXNjcmlwdGlvbjwvbGFiZWxcblx0XHRcdFx0XHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFx0XHRcdDxpbnB1dFxuXHRcdFx0XHRcdFx0XHRcdFx0XHRpZD1cImRvY3VtZW50RGVzY3JpcHRpb25cIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHR2LW1vZGVsPVwiZG9jdW1lbnREZXNjcmlwdGlvbk1vZGVsXCJcblx0XHRcdFx0XHRcdFx0XHRcdFx0dHlwZT1cInRleHRcIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHRjbGFzcz1cImZvcm0tY29udHJvbFwiXG5cdFx0XHRcdFx0XHRcdFx0XHQvPlxuXHRcdFx0XHRcdFx0XHRcdDwvZGl2PlxuXG5cdFx0XHRcdFx0XHRcdFx0PCEtLSBSRVNFVCBGT1JNIEJVVFRPTiAtLT5cblx0XHRcdFx0XHRcdFx0XHQ8YnIvPlxuXHRcdFx0XHRcdFx0XHRcdDxkaXYgY2xhc3M9XCJmb3JtLXJvd1wiPlxuXHRcdFx0XHRcdFx0XHRcdFx0PGJ1dHRvblxuXHRcdFx0XHRcdFx0XHRcdFx0XHR2LW9uOmNsaWNrPVwicmVzZXRGb3JtXCJcblx0XHRcdFx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4gYnRuLXdhcm5pbmdcIlxuXHRcdFx0XHRcdFx0XHRcdFx0PlxuXHRcdFx0XHRcdFx0XHRcdFx0XHRSZXNldCBGb3JtXG5cdFx0XHRcdFx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0XHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0XHRcdFx0PC9kaXY+XG5cdFx0XHRcdFx0XHRcdDxkaXYgdi1lbHNlPlxuXHRcdFx0XHRcdFx0XHRcdDwhLS0gVEhFIFVQTE9BRCBTUElOTkVSIC0tPlxuXHRcdFx0XHRcdFx0XHRcdDxkaXZcblx0XHRcdFx0XHRcdFx0XHRcdHYtaWY9XCJcblx0XHRcdFx0XHRcdFx0XHRcdFx0cGFyc2VGbG9hdCh1cGxvYWRQZXJjZW50YWdlKS50b0ZpeGVkKFxuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdDBcblx0XHRcdFx0XHRcdFx0XHRcdFx0KSA8IDFcblx0XHRcdFx0XHRcdFx0XHRcdFwiXG5cdFx0XHRcdFx0XHRcdFx0XHRjbGFzcz1cImFsZXJ0IGFsZXJ0LXdhcm5pbmdcIlxuXHRcdFx0XHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFx0XHRcdFVwbG9hZGluZ1xuXHRcdFx0XHRcdFx0XHRcdFx0e3tcblx0XHRcdFx0XHRcdFx0XHRcdFx0KFxuXHRcdFx0XHRcdFx0XHRcdFx0XHRcdHBhcnNlRmxvYXQodXBsb2FkUGVyY2VudGFnZSkgKiAxMDBcblx0XHRcdFx0XHRcdFx0XHRcdFx0KS50b0ZpeGVkKDIpXG5cdFx0XHRcdFx0XHRcdFx0XHR9fSVcblx0XHRcdFx0XHRcdFx0XHRcdDxkaXZcblx0XHRcdFx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJzcGlubmVyLWJvcmRlciB0ZXh0LXByaW1hcnlcIlxuXHRcdFx0XHRcdFx0XHRcdFx0XHRyb2xlPVwic3RhdHVzXCJcblx0XHRcdFx0XHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFx0XHRcdFx0PHNwYW4gY2xhc3M9XCJzci1vbmx5XCI+TG9hZGluZy4uLjwvc3Bhbj5cblx0XHRcdFx0XHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHRcdFx0XHRcdDwvZGl2PlxuXG5cdFx0XHRcdFx0XHRcdFx0PCEtLSBUSEUgRklOQUwgV1JJVElORyAtLT5cblx0XHRcdFx0XHRcdFx0XHQ8ZGl2XG5cdFx0XHRcdFx0XHRcdFx0XHR2LWVsc2Vcblx0XHRcdFx0XHRcdFx0XHRcdGNsYXNzPVwiYWxlcnQgYWxlcnQtc3VjY2Vzc1wiXG5cdFx0XHRcdFx0XHRcdFx0PlxuXHRcdFx0XHRcdFx0XHRcdFx0VGhlIGRvY3VtZW50IGhhcyBiZWVuIHVwbG9hZGVkLiBUaGUgc2VydmVyXG5cdFx0XHRcdFx0XHRcdFx0XHRpcyBjdXJyZW50bHkgd3JpdGluZyB0aGUgZmlsZSB0byBkaXNrLlxuXHRcdFx0XHRcdFx0XHRcdFx0UGxlYXNlIGJlIHBhdGllbnQgLSB0aGlzIG1vZGFsIHdpbGwgY2xvc2Vcblx0XHRcdFx0XHRcdFx0XHRcdGF1dG9tYXRpY2FsbHkuIFRoYW5rIHlvdVxuXHRcdFx0XHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHRcdDwvZGl2PlxuXHRcdFx0XHQ8L2Rpdj5cblx0XHRcdFx0PGRpdiBjbGFzcz1cIm1vZGFsLWZvb3RlclwiPlxuXHRcdFx0XHRcdDxidXR0b25cblx0XHRcdFx0XHRcdHR5cGU9XCJidXR0b25cIlxuXHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4gYnRuLXNlY29uZGFyeVwiXG5cdFx0XHRcdFx0XHRkYXRhLWJzLWRpc21pc3M9XCJtb2RhbFwiXG5cdFx0XHRcdFx0PlxuXHRcdFx0XHRcdFx0Q2xvc2Vcblx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0XHQ8YnV0dG9uXG5cdFx0XHRcdFx0XHR0eXBlPVwiYnV0dG9uXCJcblx0XHRcdFx0XHRcdGNsYXNzPVwiYnRuIGJ0bi1wcmltYXJ5XCJcblx0XHRcdFx0XHRcdHYtYmluZDpkaXNhYmxlZD1cImRpc2FibGVVcGxvYWRCdXR0b25cIlxuXHRcdFx0XHRcdFx0di1vbjpjbGljaz1cInVwbG9hZEZpbGVcIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdFVwbG9hZCBGaWxlXG5cdFx0XHRcdFx0PC9idXR0b24+XG5cdFx0XHRcdDwvZGl2PlxuXHRcdFx0PC9kaXY+XG5cdFx0PC9kaXY+XG5cdDwvZGl2PlxuPC90ZW1wbGF0ZT5cblxuPHNjcmlwdD5cbmltcG9ydCB7SWNvbn0gZnJvbSBcIkBpY29uaWZ5L3Z1ZVwiO1xuXG4vL1Z1ZVhcbmltcG9ydCB7bWFwR2V0dGVyc30gZnJvbSBcInZ1ZXhcIjtcblxuLy9NaXhpbnNcbmltcG9ydCBpY29uTWl4aW4gZnJvbSBcIi4uLy4uLy4uL21peGlucy9pY29uTWl4aW5cIjtcbmltcG9ydCB7TW9kYWx9IGZyb20gXCJib290c3RyYXBcIjtcblxuZXhwb3J0IGRlZmF1bHQge1xuXHRuYW1lOiBcIlVwbG9hZERvY3VtZW50V2l6YXJkXCIsXG5cdGNvbXBvbmVudHM6IHtcblx0XHRJY29uLFxuXHR9LFxuXHRwcm9wczoge1xuXHRcdG92ZXJyaWRlRGVzdGluYXRpb246IHtcblx0XHRcdHR5cGU6IFN0cmluZyxcblx0XHRcdGRlZmF1bHQ6IFwiXCIsXG5cdFx0fSxcblx0XHRvdmVycmlkZUxvY2F0aW9uSWQ6IHtcblx0XHRcdHR5cGU6IE51bWJlcixcblx0XHRcdGRlZmF1bHQ6IDAsXG5cdFx0fSxcblx0fSxcblx0bWl4aW5zOiBbaWNvbk1peGluXSxcblx0ZGF0YSgpIHtcblx0XHRyZXR1cm4ge1xuXHRcdFx0ZGlzYWJsZVVwbG9hZEJ1dHRvbjogdHJ1ZSxcblx0XHRcdGRvY3VtZW50TW9kZWw6IFtdLFxuXHRcdFx0ZG9jdW1lbnREZXNjcmlwdGlvbk1vZGVsOiBcIlwiLFxuXHRcdFx0dXBsb2FkUGVyY2VudGFnZTogXCJcIixcblx0XHRcdG1heFVwbG9hZFNpemU6IDAsXG5cdFx0XHRtYXhVcGxvYWRTdHJpbmc6IFwiTm8gVXBsb2FkIExpbWl0XCIsXG5cdFx0XHRtYXhVcGxvYWRXYXJuaW5nOiBmYWxzZSxcblx0XHR9O1xuXHR9LFxuXHRjb21wdXRlZDoge1xuXHRcdC4uLm1hcEdldHRlcnMoe1xuXHRcdFx0YWNjZXB0ZWREb2N1bWVudHM6IFwiZ2V0QWNjZXB0ZWREb2N1bWVudHNcIixcblx0XHRcdGN1cnJlbnRGb2xkZXI6IFwiZ2V0Q3VycmVudEZvbGRlclwiLFxuXHRcdFx0ZGVzdGluYXRpb246IFwiZ2V0RGVzdGluYXRpb25cIixcblx0XHRcdGV4Y2x1ZGVEb2N1bWVudHM6IFwiZ2V0RG9jdW1lbnRGaWx0ZXJlZExpc3RcIixcblx0XHRcdGxvY2F0aW9uSWQ6IFwiZ2V0TG9jYXRpb25JZFwiLFxuXHRcdFx0c3RhdGljVXJsOiBcImdldFN0YXRpY1VybFwiLFxuXHRcdFx0cm9vdFVybDogXCJnZXRSb290VXJsXCIsXG5cdFx0fSksXG5cdH0sXG5cdG1ldGhvZHM6IHtcblx0XHRnZXREZXN0aW5hdGlvbigpIHtcblx0XHRcdHJldHVybiB0aGlzLm92ZXJyaWRlRGVzdGluYXRpb24gIT09IFwiXCIgPyB0aGlzLm92ZXJyaWRlRGVzdGluYXRpb24gOiB0aGlzLmRlc3RpbmF0aW9uO1xuXHRcdH0sXG5cdFx0Z2V0TG9jYXRpb25JZCgpIHtcblx0XHRcdC8vSWYgdGhlcmUgaXMgYW4gb3ZlcnJpZGVEZXN0aW5hdGlvbiAtIHdlIHdhbnQgdG8gdXNlIHRoZSBvdmVycmlkZUxvY2F0aW9uSWRcblx0XHRcdHJldHVybiB0aGlzLm92ZXJyaWRlRGVzdGluYXRpb24gIT09IFwiXCIgPyB0aGlzLm92ZXJyaWRlTG9jYXRpb25JZCA6IHRoaXMubG9jYXRpb25JZDtcblx0XHR9LFxuXHRcdGhhbmRsZUZpbGVVcGxvYWRzKGZpbGVMaXN0KSB7XG5cdFx0XHQvKkNoZWNrIHRoYXQgdGhlIHNpemUgb2YgdGhlIGZpbGVMaXN0IGlzIG5vdCB0b28gYmlnXG5cdFx0XHQgIFRoZSBib29sZWFuICgwIT10aGlzLm1heFVwbG9hZFNpemUpIHdpbGwgcHJvZHVjdCBhIDAgcmVzdWx0IHdoZW4gbWF4VXBsb2FkU2l6ZSBpcyAwLiBUaHVzIG5lZ2F0aW5nXG5cdFx0XHQgIHRoZSBuZWVkIGZvciBhbiBleHRyYSBpZiBzdGF0ZW1lbnQqL1xuXHRcdFx0aWYgKFxuXHRcdFx0XHRmaWxlTGlzdFswXS5zaXplICogKHRoaXMubWF4VXBsb2FkU2l6ZSAhPT0gMCkgPlxuXHRcdFx0XHR0aGlzLm1heFVwbG9hZFNpemVcblx0XHRcdCkge1xuXHRcdFx0XHR0aGlzLm1heFVwbG9hZFdhcm5pbmcgPSB0cnVlO1xuXG5cdFx0XHRcdC8vSnVzdCByZXR1cm5cblx0XHRcdFx0cmV0dXJuO1xuXHRcdFx0fVxuXG5cdFx0XHQvL1JlbW92ZSBtYXhVcGxvYWRXYXJuaW5nXG5cdFx0XHR0aGlzLm1heFVwbG9hZFdhcm5pbmcgPSBmYWxzZTtcblxuXHRcdFx0Ly9VcGRhdGUgdGhlIGRvY3VtZW50IG1vZGFsXG5cdFx0XHR0aGlzLmRvY3VtZW50TW9kZWwgPSBmaWxlTGlzdFswXTtcblxuXHRcdFx0Ly9FeHRyYWN0IHRoZSBmaWxlIG5hbWUgYW5kIHBsYWNlIGludG8gdGhlIGRvY3VtZW50IGRlc2NyaXB0aW9uIGZvciB0aGUgdXNlclxuXHRcdFx0dGhpcy5kb2N1bWVudERlc2NyaXB0aW9uTW9kZWwgPSBmaWxlTGlzdFswXS5uYW1lO1xuXHRcdH0sXG5cdFx0cmVzZXRGb3JtKCkge1xuXHRcdFx0Ly9CbGFuayBvdXQgYWxsIHRoZSBtb2RlbHNcblx0XHRcdHRoaXMuZG9jdW1lbnRNb2RlbCA9IFwiXCI7XG5cdFx0XHR0aGlzLmRvY3VtZW50RGVzY3JpcHRpb25Nb2RlbCA9IFwiXCI7XG5cdFx0XHR0aGlzLnVwbG9hZFBlcmNlbnRhZ2UgPSBcIlwiO1xuXHRcdH0sXG5cdFx0dXBsb2FkRmlsZSgpIHtcblx0XHRcdC8vQ3JlYXRlIHRoZSBkYXRhIHRvIHNlbmRcblx0XHRcdGNvbnN0IGRhdGFfdG9fc2VuZCA9IG5ldyBGb3JtRGF0YSgpO1xuXHRcdFx0ZGF0YV90b19zZW5kLnNldChcblx0XHRcdFx0XCJkb2N1bWVudFwiLFxuXHRcdFx0XHR0aGlzLmRvY3VtZW50TW9kZWwsXG5cdFx0XHRcdHRoaXMuZG9jdW1lbnREZXNjcmlwdGlvbk1vZGVsXG5cdFx0XHQpO1xuXHRcdFx0ZGF0YV90b19zZW5kLnNldChcblx0XHRcdFx0XCJkb2N1bWVudF9kZXNjcmlwdGlvblwiLFxuXHRcdFx0XHR0aGlzLmRvY3VtZW50RGVzY3JpcHRpb25Nb2RlbFxuXHRcdFx0KTtcblxuXHRcdFx0Ly9JZiB0aGVyZSBpcyBhIGN1cnJlbnQvcGFydGVudCBmb2xkZXIgLSB0aGVuIGFkZCBpdCB0byB0aGUgZGF0YSB0byBzZW5kXG5cdFx0XHRpZiAodGhpcy5jdXJyZW50Rm9sZGVyID4gMCkge1xuXHRcdFx0XHRkYXRhX3RvX3NlbmQuc2V0KFwicGFyZW50X2ZvbGRlclwiLCB0aGlzLmN1cnJlbnRGb2xkZXIpO1xuXHRcdFx0fVxuXG5cdFx0XHQvL0NvbmZpZ3VyYXRpb24gZm9yIGF4aW9zXG5cdFx0XHRjb25zdCBjb25maWcgPSB7XG5cdFx0XHRcdG9uVXBsb2FkUHJvZ3Jlc3M6IChwcm9ncmVzc0V2ZW50KSA9PiB7XG5cdFx0XHRcdFx0Ly9BcyB0aGUgZG9jdW1lbnQgZ2V0cyB1cGxvYWRlZCAtIHdlIHdhbnQgdG8gdXBkYXRlIHRoZSB1cGxvYWQgUGVyY2VudGFnZVxuXHRcdFx0XHRcdHRoaXMudXBsb2FkUGVyY2VudGFnZSA9XG5cdFx0XHRcdFx0XHRwYXJzZUZsb2F0KHByb2dyZXNzRXZlbnQubG9hZGVkKSAvXG5cdFx0XHRcdFx0XHRwYXJzZUZsb2F0KHByb2dyZXNzRXZlbnQudG90YWwpO1xuXHRcdFx0XHR9LFxuXHRcdFx0fTtcblxuXHRcdFx0Ly9Vc2UgYXhpb3MgdG8gc2VuZCBpdCB0byB0aGUgYmFja2VuZFxuXHRcdFx0dGhpcy5heGlvcy5wb3N0KFxuXHRcdFx0XHRgJHt0aGlzLnJvb3RVcmx9ZG9jdW1lbnRhdGlvbi8ke3RoaXMuZ2V0RGVzdGluYXRpb24oKX0vJHt0aGlzLmdldExvY2F0aW9uSWQoKX0vdXBsb2FkL2AsXG5cdFx0XHRcdGRhdGFfdG9fc2VuZCxcblx0XHRcdFx0Y29uZmlnXG5cdFx0XHQpLnRoZW4oKHJlc3BvbnNlKSA9PiB7XG5cdFx0XHRcdC8vQXBwZW5kIHRoZSBuZXcgZG9jdW1lbnQgdG8gdGhlIGV4aXN0aW5nIGRvY3VtZW50IGxpc3Rcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJhcHBlbmREb2N1bWVudExpc3RcIiwge1xuXHRcdFx0XHRcdGRvY3VtZW50TGlzdDogcmVzcG9uc2UuZGF0YVswXSxcblx0XHRcdFx0fSk7XG5cblx0XHRcdFx0Ly9DbG9zZSB0aGUgbW9kYWxcblx0XHRcdFx0ZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQoXCJ1cGxvYWREb2N1bWVudENsb3NlQnV0dG9uXCIpLmNsaWNrKCk7XG5cblx0XHRcdFx0Ly9SZXNldCB0aGUgZG9jdW1lbnRcblx0XHRcdFx0dGhpcy5yZXNldEZvcm0oKTtcblxuXHRcdFx0XHQvL1Jlc2hvdyB0aGUgY2FyZCBpbmZvcm1hdGlvbiBtb2RhbCBpZiBleGlzdHNcblx0XHRcdFx0bGV0IGNhcmRNb2RhbCA9IGRvY3VtZW50LmdldEVsZW1lbnRCeUlkKFwiY2FyZEluZm9ybWF0aW9uTW9kYWxcIik7XG5cdFx0XHRcdGlmIChjYXJkTW9kYWwgIT09IG51bGwpXG5cdFx0XHRcdHtcblx0XHRcdFx0XHRjYXJkTW9kYWwgPSBuZXcgTW9kYWwoY2FyZE1vZGFsKTtcblx0XHRcdFx0XHRjYXJkTW9kYWwuc2hvdygpO1xuXHRcdFx0XHR9XG5cdFx0XHR9KS5jYXRjaCgoZXJyb3IpID0+IHtcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdFx0aGVhZGVyOiBcIkZhaWxlZCB0byB1cGxvYWQgZG9jdW1lbnRhdGlvblwiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IGBDYW4gbm90IHVwbG9hZCB0aGUgZG9jdW1lbnRhdGlvbi4gJHtlcnJvcn1gLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctZGFuZ2VyXCIsXG5cdFx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fSk7XG5cdFx0fSxcblx0fSxcblx0d2F0Y2g6IHtcblx0XHRtYXhVcGxvYWRTaXplKCkge1xuXHRcdFx0Ly9JZiB0aGUgdXNlciBoYXMgc2V0IDAgLT4ganVzdCBzYXkgXCJObyBVcGxvYWQgTGltaXRcIlxuXHRcdFx0aWYgKHRoaXMubWF4VXBsb2FkU2l6ZSA9PT0gMCkge1xuXHRcdFx0XHRyZXR1cm4gXCJObyBVcGxvYWQgTGltaXRcIjtcblx0XHRcdH1cblxuXHRcdFx0Ly9EZWZpbmUgdGhlIGNvbnN0YW50cyB3ZSB3aXNoIHRvIHVzZVxuXHRcdFx0Y29uc3QgayA9IDEwMjQ7XG5cdFx0XHRjb25zdCBzaXplcyA9IFtcblx0XHRcdFx0XCJCeXRlc1wiLFxuXHRcdFx0XHRcIktCXCIsXG5cdFx0XHRcdFwiTUJcIixcblx0XHRcdFx0XCJHQlwiLFxuXHRcdFx0XHRcIlRCXCIsXG5cdFx0XHRcdFwiUEJcIixcblx0XHRcdFx0XCJFQlwiLFxuXHRcdFx0XHRcIlpCXCIsXG5cdFx0XHRcdFwiWUJcIixcblx0XHRcdF07XG5cblx0XHRcdC8vVXNlIG1hdGggdG8gZmluZCBvdXQgd2hpY2ggYXJyYXkgc2VjdGlvbiB3ZSBhcmUgZ29pbmcgdG8gdXNlIGZyb20gc2l6ZXNcblx0XHRcdGNvbnN0IGkgPSBNYXRoLmZsb29yKFxuXHRcdFx0XHRNYXRoLmxvZyh0aGlzLm1heFVwbG9hZFNpemUpIC8gTWF0aC5sb2coaylcblx0XHRcdCk7XG5cblx0XHRcdHRoaXMubWF4VXBsb2FkU3RyaW5nID0gYE1heCBVcGxvYWQgU2l6ZTogJHtwYXJzZUZsb2F0KFxuXHRcdFx0XHQodGhpcy5tYXhVcGxvYWRTaXplIC8gTWF0aC5wb3coaywgaSkpLnRvRml4ZWQoMilcblx0XHRcdCl9ICR7c2l6ZXNbaV19YDtcblx0XHR9LFxuXHR9LFxuXHR1cGRhdGVkKCkge1xuXHRcdGNvbnN0IG1hdGNoID0gdGhpcy5leGNsdWRlRG9jdW1lbnRzLmZpbHRlcigocm93KSA9PiB7XG5cdFx0XHRyZXR1cm4gKFxuXHRcdFx0XHRyb3cuZG9jdW1lbnRfa2V5X19kb2N1bWVudF9kZXNjcmlwdGlvbiA9PT1cblx0XHRcdFx0dGhpcy5kb2N1bWVudERlc2NyaXB0aW9uTW9kZWxcblx0XHRcdCk7XG5cdFx0fSk7XG5cblx0XHR0aGlzLmRpc2FibGVVcGxvYWRCdXR0b24gPVxuXHRcdFx0dGhpcy5kb2N1bWVudE1vZGVsID09PSBcIlwiIHx8XG5cdFx0XHR0aGlzLmRvY3VtZW50RGVzY3JpcHRpb25Nb2RlbC5sZW5ndGggPT09IDAgfHxcblx0XHRcdG1hdGNoLmxlbmd0aCA+IDA7XG5cdH0sXG5cdG1vdW50ZWQoKSB7XG5cdFx0Ly9XYWl0IGEgZmV3IHNlY29uZHMgYmVmb3JlIGdldHRpbmcgdGhlIG1heCBmaWxlIHVwbG9hZCBzaXplXG5cdFx0dGhpcy4kbmV4dFRpY2soKCkgPT4ge1xuXHRcdFx0Ly9HZXQgdGhlIG1heCBmaWxlIHVwbG9hZCBzaXplXG5cdFx0XHR0aGlzLmF4aW9zLnBvc3QoXG5cdFx0XHRcdGAke3RoaXMucm9vdFVybH1kb2N1bWVudGF0aW9uL2dldC9tYXhfdXBsb2FkL2Bcblx0XHRcdCkudGhlbigocmVzcG9uc2UpID0+IHtcblx0XHRcdFx0Ly9TZXQgdGhlIHZhbHVlXG5cdFx0XHRcdHRoaXMubWF4VXBsb2FkU2l6ZSA9IHJlc3BvbnNlLmRhdGEubWF4X3VwbG9hZF9zaXplO1xuXHRcdFx0fSkuY2F0Y2goKCkgPT4ge1xuXHRcdFx0XHR0aGlzLiRzdG9yZS5kaXNwYXRjaChcIm5ld1RvYXN0XCIsIHtcblx0XHRcdFx0XHRoZWFkZXI6IFwiRmFpbGVkIHRvIGdldCB0aGUgbWF4IHVwbG9hZCBzaXplXCIsXG5cdFx0XHRcdFx0bWVzc2FnZTogYEhhZCBhbiBpc3N1ZSBnZXR0aW5nIGRhdGEgZnJvbSBiYWNrZW5kLiAke3RoaXMubWF4VXBsb2FkU3RyaW5nfWAsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1kYW5nZXJcIixcblx0XHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0fSk7XG5cdFx0XHR9KTtcblx0XHR9KTtcblx0fSxcbn07XG48L3NjcmlwdD5cblxuPHN0eWxlIHNjb3BlZD48L3N0eWxlPlxuIiwiZXhwb3J0IHsgZGVmYXVsdCB9IGZyb20gXCItIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy92dWUtbG9hZGVyL2Rpc3QvaW5kZXguanM/P3J1bGVTZXRbMV0ucnVsZXNbNl0udXNlWzBdIS4vTGlzdFB1YmxpY0xpbmtzLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiOyBleHBvcnQgKiBmcm9tIFwiLSEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2luZGV4LmpzPz9ydWxlU2V0WzFdLnJ1bGVzWzZdLnVzZVswXSEuL0xpc3RQdWJsaWNMaW5rcy52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIiIsImV4cG9ydCB7IGRlZmF1bHQgfSBmcm9tIFwiLSEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2luZGV4LmpzPz9ydWxlU2V0WzFdLnJ1bGVzWzZdLnVzZVswXSEuL0FkZEZvbGRlcldpemFyZC52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIjsgZXhwb3J0ICogZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9pbmRleC5qcz8/cnVsZVNldFsxXS5ydWxlc1s2XS51c2VbMF0hLi9BZGRGb2xkZXJXaXphcmQudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCIiLCJleHBvcnQgeyBkZWZhdWx0IH0gZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9pbmRleC5qcz8/cnVsZVNldFsxXS5ydWxlc1s2XS51c2VbMF0hLi9BZGRMaW5rV2l6YXJkLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiOyBleHBvcnQgKiBmcm9tIFwiLSEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2luZGV4LmpzPz9ydWxlU2V0WzFdLnJ1bGVzWzZdLnVzZVswXSEuL0FkZExpbmtXaXphcmQudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCIiLCJleHBvcnQgeyBkZWZhdWx0IH0gZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9pbmRleC5qcz8/cnVsZVNldFsxXS5ydWxlc1s2XS51c2VbMF0hLi9Db25maXJtRmlsZURlbGV0ZS52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIjsgZXhwb3J0ICogZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9pbmRleC5qcz8/cnVsZVNldFsxXS5ydWxlc1s2XS51c2VbMF0hLi9Db25maXJtRmlsZURlbGV0ZS52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIiIsImV4cG9ydCB7IGRlZmF1bHQgfSBmcm9tIFwiLSEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2luZGV4LmpzPz9ydWxlU2V0WzFdLnJ1bGVzWzZdLnVzZVswXSEuL1VwbG9hZERvY3VtZW50V2l6YXJkLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiOyBleHBvcnQgKiBmcm9tIFwiLSEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2luZGV4LmpzPz9ydWxlU2V0WzFdLnJ1bGVzWzZdLnVzZVswXSEuL1VwbG9hZERvY3VtZW50V2l6YXJkLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiIl0sIm5hbWVzIjpbXSwic291cmNlUm9vdCI6IiJ9