"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["src_js_components_modules_sub_modules_ListPublicLinks_vue"],{

/***/ "./src/js/components/modules/sub_modules/ListPublicLinks.vue":
/*!*******************************************************************!*\
  !*** ./src/js/components/modules/sub_modules/ListPublicLinks.vue ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ListPublicLinks.vue?vue&type=template&id=35be5da7 */ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7");
/* harmony import */ var _ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ListPublicLinks.vue?vue&type=script&lang=js */ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/modules/sub_modules/ListPublicLinks.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
/* harmony import */ var _iconify_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @iconify/vue */ "./node_modules/@iconify/vue/dist/iconify.mjs");
/* harmony import */ var _mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../mixins/iconMixin */ "./src/js/mixins/iconMixin.js");

//VueX


//Icon



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "ListPublicLinks",
	props: {
		isReadOnly: {
			type: Boolean,
			default: false,
		},
		overrideDestination: {
			type: String,
			default: "",
		},
		overrideLocationId: {
			type: Number,
			default: 0,
		},
	},
	data() {
		return {
			isFetchingData: true,
			publicLinkResults: [],
		};
	},
	watch: {
		overrideLocationId() {
			this.getPublicLinks();
		},
	},
	components: {
		Icon: _iconify_vue__WEBPACK_IMPORTED_MODULE_0__.Icon,
	},
	computed: {
		...(0,vuex__WEBPACK_IMPORTED_MODULE_2__.mapGetters)({
			destination: "getDestination",
			locationId: "getLocationId",
			rootUrl: "getRootUrl",
			userLevel: "getUserLevel",
		})
	},
	mixins: [_mixins_iconMixin__WEBPACK_IMPORTED_MODULE_1__["default"]],
	methods: {
		async copyPublicLink(public_link_id) {
			//Get the URL
			const url = `${window.location.origin}${this.rootUrl}public/${this.getDestination()}/${this.getLocationId()}/${public_link_id}/`

			//Copy to the clipboard
			try {
				await navigator.clipboard.writeText(url);

				//Notify the user
				this.$store.dispatch("newToast", {
					header: "Public Link Copied",
					message: "Public Link has successfully copied to the clipboard",
					extra_classes: "bg-success",
				});
			} catch(error) {
				this.$store.dispatch("newToast", {
					header: "Can not copy public link",
					message: "Sorry, we failed to copy the public link",
					extra_classes: "bg-danger",
					delay: 0,
				});
			}
		},
		createPublicLink() {
			//Inform user of creating new link
			this.$store.dispatch("newToast", {
				header: "Creating New Toast",
				message: "Please wait whilst we create the toast",
				extra_classes: "bg-warning text-dark",
				delay: 0,
				unique_type: "create_public_link",
			});

			//Contact backend - get public link
			this.axios.post(
				`${this.rootUrl}public_data/${this.getDestination()}/${this.getLocationId()}/create/`,
			).then((response) => {
				//Inform user of success
				this.$store.dispatch("newToast", {
					header: "Successful new Public Link",
					message: "We have been able to create a new public link",
					extra_classes: "bg-success",
					unique_type: "create_public_link",
				});

				//Replace everything
				this.publicLinkResults = response.data;
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Can not create new public link",
					message: `Sorry, we failed to create the new public link. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
					unique_type: "create_public_link",
				});
			})
		},
		deletePublicLink(public_link_id) {
			//Construct data to send
			const data_to_send = new FormData();
			data_to_send.set("public_link_id", public_link_id);

			//Notify user we are deleting the data
			this.$store.dispatch("newToast", {
				header: "Deleting Public Link",
				message: "Deleting Public Link",
				extra_classes: "bg-warning text-dark",
				delay: 0,
				unique_type: "public_link_delete",
			})

			//Use axios
			this.axios.post(
				`${this.rootUrl}public_data/${this.getDestination()}/${this.getLocationId()}/delete/`,
				data_to_send,
			).then(() => {
				//Remove the row
				this.publicLinkResults = this.publicLinkResults.filter((row) => {
					return row.public_link_id !== public_link_id;
				});

				this.$store.dispatch("newToast", {
					header: "Successfully Deleted Public Link",
					message: "Successfully Deleted Public Link",
					extra_classes: "bg-success",
					unique_type: "public_link_delete",
				});
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error Deleting Public Link",
					message: `Error - could not delete link. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
					unique_type: "public_link_delete",
				});
			});
		},
		formatUrl(public_link_id) {
			//Double check we are getting the correct URL
			if (public_link_id === "" || public_link_id === undefined) {
				return "Data error!";
			}

			//Trucate the UUID - so if someone is viewing the screen they don't get the key
			const trunc_link_id = public_link_id.slice(0,7);

			return `${window.location.origin}${this.rootUrl}public/${this.getDestination()}/${this.getLocationId()}/${trunc_link_id}...`
		},
		getDestination() {
			return this.overrideDestination !== "" ? this.overrideDestination : this.destination;
		},
		getLocationId() {
			//If there is an overrideDestination - we want to use the overrideLocationId
			return this.overrideDestination !== "" ? this.overrideLocationId : this.locationId;
		},
		getPublicLinks() {
			//Escape if there is no location id
			if (this.getLocationId() === 0) return;

			this.axios(
				`${this.rootUrl}public_data/${this.getDestination()}/${this.getLocationId()}/get_links/`,
			).then((response) => {
				//Set the data
				this.publicLinkResults = response.data;

				//Set the fetch status to false
				this.isFetchingData = false;
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error fetching Public Links",
					message: `We had an issue fetching the public links for this object. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
				});
			});
		},
		updateIsActive(event) {
			//Get the uuid
			const uuid = event.target.dataset.publicLinkId;

			//Tell the user we are updating the stats
			this.$store.dispatch("newToast", {
				header: "Updating Active Status for Private Link",
				message: "Please wait - we are updating the status",
				extra_classes: "bg-warning text-dark",
				delay: 0,
				unique_type: `is_active-${uuid}`,
			});

			//Translate the checked box
			let is_active = "False";
			if (event.target.checked) {
				is_active = "True";
			}

			//Setup data to send
			const data_to_send = new FormData();
			data_to_send.set("public_link_id", uuid);
			data_to_send.set("public_link_is_active", is_active);

			this.axios.post(
				`${this.rootUrl}public_data/${this.destination}/${this.locationId}/update_link/`,
				data_to_send,
			).then(() => {
				//Update user
				this.$store.dispatch("newToast", {
					header: "Successfully Updated",
					message: "We have updated the is active status for the link",
					extra_classes: "bg-success",
					unique_type: `is_active-${uuid}`,
				});
			}).catch((error) => {
				this.$store.dispatch("newToast", {
					header: "Error Updating Active Status for Private Link",
					message: `We are sorry, something went wrong. Error -> ${error}`,
					extra_classes: "bg-danger",
					delay: 0,
					unique_type: `is_active-${uuid}`,
				});
			})
		},
	},
	mounted() {
		this.$nextTick(() => {
			this.getPublicLinks();
		})
	},
});


/***/ }),

/***/ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js":
/*!*******************************************************************************************!*\
  !*** ./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./ListPublicLinks.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7":
/*!*************************************************************************************************!*\
  !*** ./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7 ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_ListPublicLinks_vue_vue_type_template_id_35be5da7__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./ListPublicLinks.vue?vue&type=template&id=35be5da7 */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7");


/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7":
/*!*******************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/modules/sub_modules/ListPublicLinks.vue?vue&type=template&id=35be5da7 ***!
  \*******************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = {
  key: 0,
  class: "alert alert-info"
}
const _hoisted_2 = {
  key: 1,
  class: "alert alert-info"
}
const _hoisted_3 = {
  key: 2,
  class: "table table-striped"
}
const _hoisted_4 = {
  key: 0,
  style: {"width":"10px"}
}
const _hoisted_5 = ["onClick"]
const _hoisted_6 = { style: {"text-align":"center"} }
const _hoisted_7 = ["checked", "data-public-link-id", "disabled"]
const _hoisted_8 = { key: 0 }
const _hoisted_9 = { class: "remove-link" }
const _hoisted_10 = {
  key: 3,
  class: "row submit-row"
}
const _hoisted_11 = { class: "col-md-12" }

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("Icon")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, [
    _cache[4] || (_cache[4] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, "Public Links", -1 /* HOISTED */)),
    _cache[5] || (_cache[5] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", { class: "text-instructions" }, " The following will be public links you can send to clients. The links will contain certain information of the current object. i.e. it's status and description. Becareful who you send the links too! ", -1 /* HOISTED */)),
    ($data.isFetchingData)
      ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, "Currently loading data..."))
      : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
    ($data.isFetchingData === false && $data.publicLinkResults.length === 0)
      ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_2, " Sorry. There are no public links setup for this object. "))
      : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("table", _hoisted_3, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("thead", null, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tr", null, [
              _cache[2] || (_cache[2] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, "Public Link", -1 /* HOISTED */)),
              _cache[3] || (_cache[3] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", { style: {"text-align":"center","width":"100px"} }, "Is Active", -1 /* HOISTED */)),
              (_ctx.userLevel > 1)
                ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", _hoisted_4))
                : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
            ])
          ]),
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("tbody", null, [
            ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($data.publicLinkResults, (link) => {
              return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("tr", {
                key: link.public_link_id
              }, [
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", null, [
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
                    type: "button",
                    class: "btn btn-link",
                    onClick: $event => ($options.copyPublicLink(link.public_link_id))
                  }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)($options.formatUrl(link.public_link_id)), 9 /* TEXT, PROPS */, _hoisted_5)
                ]),
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("td", _hoisted_6, [
                  (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                    class: "form-check-input",
                    type: "checkbox",
                    checked: link.public_link_is_active,
                    "data-public-link-id": link.public_link_id,
                    disabled: _ctx.userLevel<=1,
                    onChange: _cache[0] || (_cache[0] = (...args) => ($options.updateIsActive && $options.updateIsActive(...args)))
                  }, null, 40 /* PROPS, NEED_HYDRATION */, _hoisted_7)
                ]),
                (_ctx.userLevel > 1)
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("td", _hoisted_8, [
                      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("span", _hoisted_9, [
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_Icon, {
                          icon: _ctx.icons.trashCan,
                          onClick: $event => ($options.deletePublicLink(link.public_link_id))
                        }, null, 8 /* PROPS */, ["icon", "onClick"])
                      ])
                    ]))
                  : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
              ]))
            }), 128 /* KEYED_FRAGMENT */))
          ])
        ])),
    ($props.isReadOnly===false && _ctx.userLevel > 1)
      ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_10, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("button", {
              class: "btn btn-primary save-changes",
              onClick: _cache[1] || (_cache[1] = (...args) => ($options.createPublicLink && $options.createPublicLink(...args)))
            }, " Create Public Link ")
          ])
        ]))
      : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
  ], 64 /* STABLE_FRAGMENT */))
}

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoic3JjX2pzX2NvbXBvbmVudHNfbW9kdWxlc19zdWJfbW9kdWxlc19MaXN0UHVibGljTGlua3NfdnVlLm1pbi5qcyIsIm1hcHBpbmdzIjoiOzs7Ozs7Ozs7Ozs7Ozs7O0FBQTRFO0FBQ1Y7QUFDTDs7QUFFN0QsQ0FBeUY7QUFDekYsaUNBQWlDLHlGQUFlLENBQUMsb0ZBQU0sYUFBYSxzRkFBTTtBQUMxRTtBQUNBLElBQUksS0FBVSxFQUFFLEVBWWY7OztBQUdELGlFQUFlOzs7Ozs7Ozs7Ozs7Ozs7Ozs7QUNrRGYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0FBQzZCOztBQUVsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7QUFDNkI7QUFDZ0I7O0FBRWxELGlFQUFlO0NBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztDQUN2QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNYLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUNmLENBQUM7RUFDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDcEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztFQUNaLENBQUM7RUFDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0VBQ1gsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ04sQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7RUFDdEIsQ0FBQztDQUNGLENBQUM7Q0FDRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNOLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUN0QixDQUFDO0NBQ0YsQ0FBQztDQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtFQUNYLENBQUMsQ0FBQyxDQUFDLENBQUM7Q0FDTCxDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDVCxDQUFDLENBQUMsQ0FBQyxnREFBVSxDQUFDO0dBQ2IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUM3QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDM0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3JCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQzFCLENBQUM7Q0FDRixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLHlEQUFTLENBQUM7Q0FDbkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0VBQ1IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ3BDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7R0FDWixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDOztHQUUvSCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3RCLENBQUMsQ0FBQyxFQUFFO0lBQ0gsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0lBRXhDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztJQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUM1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQy9ELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUM1QixDQUFDLENBQUM7R0FDSCxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ25ELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDMUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztJQUNULENBQUMsQ0FBQztHQUNIO0VBQ0QsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2xCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDakMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDNUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3JDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbEMsQ0FBQyxDQUFDOztHQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUNsQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNkLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDdEYsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNwQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDdkIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUNwQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3hELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMzQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsQ0FBQyxDQUFDOztJQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3ZDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDNUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMxQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0tBQ1IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2xDLENBQUMsQ0FBQztHQUNILENBQUM7RUFDRixDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQztHQUN2QixDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ25DLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRWxELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUM7R0FDckMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQzlCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDL0IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ3JDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbEMsQ0FBQzs7R0FFRCxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNWLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNyRixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNiLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNaLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUM7SUFDZixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtLQUMvRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDN0MsQ0FBQyxDQUFDOztJQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDMUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDM0MsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzNCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNsQyxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ3BDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMzRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7S0FDUixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDbEMsQ0FBQyxDQUFDO0dBQ0gsQ0FBQyxDQUFDO0VBQ0gsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDekIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUM1QyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtJQUMxRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNyQjs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUM5RSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRS9DLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUM1SCxDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7RUFDckYsQ0FBQztFQUNELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0dBQ2YsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUMzRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztFQUNuRixDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtHQUNoQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0dBQ2xDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRXRDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDVCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ3pGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUU7SUFDcEIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ2IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0lBRXRDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDOUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUM1QixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRTtJQUNuQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7S0FDaEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDckMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUN2RixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzFCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7SUFDVCxDQUFDLENBQUM7R0FDSCxDQUFDLENBQUM7RUFDSCxDQUFDO0VBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7R0FDckIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0dBQ2IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQzs7R0FFOUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDeEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0lBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakQsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUNuRCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDckMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztJQUNSLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDakMsQ0FBQyxDQUFDOztHQUVGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztHQUMxQixDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDdkIsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7SUFDekIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztHQUNuQjs7R0FFQSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0dBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDbkMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7R0FDeEMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7O0dBRXBELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2hGLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0dBQ2IsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDO0lBQ1osQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFO0tBQ2hDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDOUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQzVELENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUMzQixDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0lBQ2pDLENBQUMsQ0FBQztHQUNILENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0lBQ25CLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRTtLQUNoQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztLQUN2RCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0tBQ2hFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7S0FDMUIsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQztLQUNSLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7SUFDakMsQ0FBQyxDQUFDO0dBQ0gsQ0FBQztFQUNGLENBQUM7Q0FDRixDQUFDO0NBQ0QsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUU7RUFDVCxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLEVBQUUsQ0FBQyxFQUFFO0dBQ3BCLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQyxDQUFDO0VBQ3RCLENBQUM7Q0FDRixDQUFDO0FBQ0YsQ0FBQzs7Ozs7Ozs7Ozs7Ozs7OztBQ2xUMEo7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7OztFREEzSjtFQVFHLEtBQUssRUFBQyxrQkFBa0I7OztFQVIzQjtFQVdHLEtBQUssRUFBQyxrQkFBa0I7OztFQVgzQjtFQWdCSyxLQUFLLEVBQUMscUJBQXFCOzs7RUFoQmhDO0VBc0I2QixLQUFtQixFQUFuQixnQkFBbUI7O21CQXRCaEQ7cUJBcUNRLEtBQTBCLEVBQTFCLHVCQUEwQjttQkFyQ2xDO3FCQUFBO3FCQWdEVyxLQUFLLEVBQUMsYUFBYTs7RUFoRDlCO0VBMERNLEtBQUssRUFBQyxnQkFBZ0I7O3NCQUdyQixLQUFLLEVBQUMsV0FBVzs7Ozs7NERBN0R4Qjs4QkFDQyx3REFBcUIsWUFBakIsY0FBWTs4QkFDaEIsd0RBR0ksT0FIRCxLQUFLLEVBQUMsbUJBQW1CLElBQUMseU1BRzdCO0tBRVcsb0JBQWM7MkRBQXpCLHdEQUVnQyxPQUZoQyxVQUVnQyxFQUEvQiwyQkFBeUI7UUFUM0I7S0FVWSxvQkFBYyxjQUFjLHVCQUFpQixDQUFDLE1BQU07MkRBQS9ELHdEQUlNLE9BSk4sVUFJTSxFQUZMLDJEQUVEOzJEQUNBLHdEQTBDUSxTQTFDUixVQTBDUTtVQXZDUCx3REFNUTtZQUxQLHdEQUlLO3dDQUhKLHdEQUFvQixZQUFoQixhQUFXO3dDQUNmLHdEQUF5RCxRQUFyRCxLQUFzQyxFQUF0Qyx1Q0FBc0MsSUFBQyxXQUFTO2VBQzFDQSxjQUFTO3FFQUFuQix3REFBa0QsTUFBbEQsVUFBa0Q7a0JBdEJ0RDs7O1VBeUJFLHdEQStCUTttRUE5QlAsd0RBNkJLLGlEQXZEUixnREEwQnNCLHVCQUFpQixFQTFCdkMsQ0EwQmMsSUFBSTt3RUFBZix3REE2Qks7Z0JBNUJILEdBQUcsRUFBRSxJQUFJLENBQUMsY0FBYzs7Z0JBRXpCLHdEQU9LO2tCQU5KLHdEQUtTO29CQUxELElBQUksRUFBQyxRQUFRO29CQUNuQixLQUFLLEVBQUMsY0FBYztvQkFDZixPQUFLLGFBQUUsdUJBQWMsQ0FBQyxJQUFJLENBQUMsY0FBYzswRUFFN0Msa0JBQVMsQ0FBQyxJQUFJLENBQUMsY0FBYyx5QkFsQ3JDOztnQkFxQ0ksd0RBU0ssTUFUTCxVQVNLO2tCQVJKLHdEQU9FO29CQU5ELEtBQUssRUFBQyxrQkFBa0I7b0JBQ3hCLElBQUksRUFBQyxVQUFVO29CQUNSLE9BQU8sRUFBRSxJQUFJLENBQUMscUJBQXFCO29CQUNuQyxxQkFBbUIsRUFBRSxJQUFJLENBQUMsY0FBYztvQkFDeEMsUUFBUSxFQUFFQSxjQUFTO29CQUNyQixRQUFNLDBDQUFFLDJEQUFjOzJEQTVDakM7O2lCQStDY0EsY0FBUzt1RUFBbkIsd0RBT0ssTUF0RFQ7c0JBZ0RLLHdEQUtPLFFBTFAsVUFLTzt3QkFKTixpREFHRTswQkFGTSxJQUFJLEVBQUVDLFVBQUssQ0FBQyxRQUFROzBCQUN0QixPQUFLLGFBQUUseUJBQWdCLENBQUMsSUFBSSxDQUFDLGNBQWM7Ozs7b0JBbkR2RDs7Ozs7S0EyRFMsaUJBQVUsWUFBWUQsY0FBUzsyREFEdkMsd0RBVU0sT0FWTixXQVVNO1VBUEwsd0RBTU0sT0FOTixXQU1NO1lBTEwsd0RBSVM7Y0FKRCxLQUFLLEVBQUMsOEJBQThCO2NBQ3JDLE9BQUssMENBQUUsK0RBQWdCO2VBQzdCLHNCQUVEOzs7UUFsRUgiLCJzb3VyY2VzIjpbIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9zcmMvanMvY29tcG9uZW50cy9tb2R1bGVzL3N1Yl9tb2R1bGVzL0xpc3RQdWJsaWNMaW5rcy52dWU/YTlkNyIsIndlYnBhY2s6Ly9uZWFyYmVhY2gvLi9zcmMvanMvY29tcG9uZW50cy9tb2R1bGVzL3N1Yl9tb2R1bGVzL0xpc3RQdWJsaWNMaW5rcy52dWUiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy9zdWJfbW9kdWxlcy9MaXN0UHVibGljTGlua3MudnVlPzliYmUiLCJ3ZWJwYWNrOi8vbmVhcmJlYWNoLy4vc3JjL2pzL2NvbXBvbmVudHMvbW9kdWxlcy9zdWJfbW9kdWxlcy9MaXN0UHVibGljTGlua3MudnVlP2MwMjEiXSwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgcmVuZGVyIH0gZnJvbSBcIi4vTGlzdFB1YmxpY0xpbmtzLnZ1ZT92dWUmdHlwZT10ZW1wbGF0ZSZpZD0zNWJlNWRhN1wiXG5pbXBvcnQgc2NyaXB0IGZyb20gXCIuL0xpc3RQdWJsaWNMaW5rcy52dWU/dnVlJnR5cGU9c2NyaXB0Jmxhbmc9anNcIlxuZXhwb3J0ICogZnJvbSBcIi4vTGlzdFB1YmxpY0xpbmtzLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiXG5cbmltcG9ydCBleHBvcnRDb21wb25lbnQgZnJvbSBcIi4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy92dWUtbG9hZGVyL2Rpc3QvZXhwb3J0SGVscGVyLmpzXCJcbmNvbnN0IF9fZXhwb3J0c19fID0gLyojX19QVVJFX18qL2V4cG9ydENvbXBvbmVudChzY3JpcHQsIFtbJ3JlbmRlcicscmVuZGVyXSxbJ19fZmlsZScsXCJzcmMvanMvY29tcG9uZW50cy9tb2R1bGVzL3N1Yl9tb2R1bGVzL0xpc3RQdWJsaWNMaW5rcy52dWVcIl1dKVxuLyogaG90IHJlbG9hZCAqL1xuaWYgKG1vZHVsZS5ob3QpIHtcbiAgX19leHBvcnRzX18uX19obXJJZCA9IFwiMzViZTVkYTdcIlxuICBjb25zdCBhcGkgPSBfX1ZVRV9ITVJfUlVOVElNRV9fXG4gIG1vZHVsZS5ob3QuYWNjZXB0KClcbiAgaWYgKCFhcGkuY3JlYXRlUmVjb3JkKCczNWJlNWRhNycsIF9fZXhwb3J0c19fKSkge1xuICAgIGFwaS5yZWxvYWQoJzM1YmU1ZGE3JywgX19leHBvcnRzX18pXG4gIH1cbiAgXG4gIG1vZHVsZS5ob3QuYWNjZXB0KFwiLi9MaXN0UHVibGljTGlua3MudnVlP3Z1ZSZ0eXBlPXRlbXBsYXRlJmlkPTM1YmU1ZGE3XCIsICgpID0+IHtcbiAgICBhcGkucmVyZW5kZXIoJzM1YmU1ZGE3JywgcmVuZGVyKVxuICB9KVxuXG59XG5cblxuZXhwb3J0IGRlZmF1bHQgX19leHBvcnRzX18iLCI8dGVtcGxhdGU+XG5cdDxoMj5QdWJsaWMgTGlua3M8L2gyPlxuXHQ8cCBjbGFzcz1cInRleHQtaW5zdHJ1Y3Rpb25zXCI+XG5cdFx0VGhlIGZvbGxvd2luZyB3aWxsIGJlIHB1YmxpYyBsaW5rcyB5b3UgY2FuIHNlbmQgdG8gY2xpZW50cy4gVGhlIGxpbmtzIHdpbGwgY29udGFpbiBjZXJ0YWluIGluZm9ybWF0aW9uIG9mIHRoZVxuXHRcdGN1cnJlbnQgb2JqZWN0LiBpLmUuIGl0J3Mgc3RhdHVzIGFuZCBkZXNjcmlwdGlvbi4gQmVjYXJlZnVsIHdobyB5b3Ugc2VuZCB0aGUgbGlua3MgdG9vIVxuXHQ8L3A+XG5cblx0PGRpdiB2LWlmPVwiaXNGZXRjaGluZ0RhdGFcIlxuXHRcdCBjbGFzcz1cImFsZXJ0IGFsZXJ0LWluZm9cIlxuXHQ+Q3VycmVudGx5IGxvYWRpbmcgZGF0YS4uLjwvZGl2PlxuXHQ8ZGl2IHYtaWY9XCJpc0ZldGNoaW5nRGF0YSA9PT0gZmFsc2UgJiYgcHVibGljTGlua1Jlc3VsdHMubGVuZ3RoID09PSAwXCJcblx0XHQgY2xhc3M9XCJhbGVydCBhbGVydC1pbmZvXCJcblx0PlxuXHRcdFNvcnJ5LiBUaGVyZSBhcmUgbm8gcHVibGljIGxpbmtzIHNldHVwIGZvciB0aGlzIG9iamVjdC5cblx0PC9kaXY+XG5cdDx0YWJsZSB2LWVsc2Vcblx0XHQgICBjbGFzcz1cInRhYmxlIHRhYmxlLXN0cmlwZWRcIlxuXHQ+XG5cdFx0PHRoZWFkPlxuXHRcdFx0PHRyPlxuXHRcdFx0XHQ8dGQ+UHVibGljIExpbms8L3RkPlxuXHRcdFx0XHQ8dGQgc3R5bGU9XCJ0ZXh0LWFsaWduOmNlbnRlcjt3aWR0aDoxMDBweDtcIj5JcyBBY3RpdmU8L3RkPlxuXHRcdFx0XHQ8dGQgdi1pZj1cInVzZXJMZXZlbCA+IDFcIiBzdHlsZT1cIndpZHRoOjEwcHg7XCI+PC90ZD5cblx0XHRcdDwvdHI+XG5cdFx0PC90aGVhZD5cblx0XHQ8dGJvZHk+XG5cdFx0XHQ8dHIgdi1mb3I9XCJsaW5rIGluIHB1YmxpY0xpbmtSZXN1bHRzXCJcblx0XHRcdFx0OmtleT1cImxpbmsucHVibGljX2xpbmtfaWRcIlxuXHRcdFx0PlxuXHRcdFx0XHQ8dGQ+XG5cdFx0XHRcdFx0PGJ1dHRvbiB0eXBlPVwiYnV0dG9uXCJcblx0XHRcdFx0XHRcdFx0Y2xhc3M9XCJidG4gYnRuLWxpbmtcIlxuXHRcdFx0XHRcdFx0XHR2LW9uOmNsaWNrPVwiY29weVB1YmxpY0xpbmsobGluay5wdWJsaWNfbGlua19pZClcIlxuXHRcdFx0XHRcdD5cblx0XHRcdFx0XHRcdHt7Zm9ybWF0VXJsKGxpbmsucHVibGljX2xpbmtfaWQpfX1cblx0XHRcdFx0XHQ8L2J1dHRvbj5cblx0XHRcdFx0PC90ZD5cblx0XHRcdFx0PHRkIHN0eWxlPVwidGV4dC1hbGlnbjogY2VudGVyXCI+XG5cdFx0XHRcdFx0PGlucHV0XG5cdFx0XHRcdFx0XHRjbGFzcz1cImZvcm0tY2hlY2staW5wdXRcIlxuXHRcdFx0XHRcdFx0dHlwZT1cImNoZWNrYm94XCJcblx0XHRcdFx0XHRcdHYtYmluZDpjaGVja2VkPVwibGluay5wdWJsaWNfbGlua19pc19hY3RpdmVcIlxuXHRcdFx0XHRcdFx0di1iaW5kOmRhdGEtcHVibGljLWxpbmstaWQ9XCJsaW5rLnB1YmxpY19saW5rX2lkXCJcblx0XHRcdFx0XHRcdHYtYmluZDpkaXNhYmxlZD1cInVzZXJMZXZlbDw9MVwiXG5cdFx0XHRcdFx0XHR2LW9uOmNoYW5nZT1cInVwZGF0ZUlzQWN0aXZlXCJcblx0XHRcdFx0XHQvPlxuXHRcdFx0XHQ8L3RkPlxuXHRcdFx0XHQ8dGQgdi1pZj1cInVzZXJMZXZlbCA+IDFcIj5cblx0XHRcdFx0XHQ8c3BhbiBjbGFzcz1cInJlbW92ZS1saW5rXCI+XG5cdFx0XHRcdFx0XHQ8SWNvblxuXHRcdFx0XHRcdFx0XHR2LWJpbmQ6aWNvbj1cImljb25zLnRyYXNoQ2FuXCJcblx0XHRcdFx0XHRcdFx0di1vbjpjbGljaz1cImRlbGV0ZVB1YmxpY0xpbmsobGluay5wdWJsaWNfbGlua19pZClcIlxuXHRcdFx0XHRcdFx0Lz5cblx0XHRcdFx0XHQ8L3NwYW4+XG5cdFx0XHRcdDwvdGQ+XG5cdFx0XHQ8L3RyPlxuXHRcdDwvdGJvZHk+XG5cdDwvdGFibGU+XG5cdDxkaXYgY2xhc3M9XCJyb3cgc3VibWl0LXJvd1wiXG5cdFx0IHYtaWY9XCJpc1JlYWRPbmx5PT09ZmFsc2UgJiYgdXNlckxldmVsID4gMVwiXG5cdD5cblx0XHQ8ZGl2IGNsYXNzPVwiY29sLW1kLTEyXCI+XG5cdFx0XHQ8YnV0dG9uIGNsYXNzPVwiYnRuIGJ0bi1wcmltYXJ5IHNhdmUtY2hhbmdlc1wiXG5cdFx0XHRcdFx0di1vbjpjbGljaz1cImNyZWF0ZVB1YmxpY0xpbmtcIlxuXHRcdFx0PlxuXHRcdFx0XHRDcmVhdGUgUHVibGljIExpbmtcblx0XHRcdDwvYnV0dG9uPlxuXHRcdDwvZGl2PlxuXHQ8L2Rpdj5cbjwvdGVtcGxhdGU+XG5cbjxzY3JpcHQ+XG4vL1Z1ZVhcbmltcG9ydCB7IG1hcEdldHRlcnMgfSBmcm9tIFwidnVleFwiO1xuXG4vL0ljb25cbmltcG9ydCB7SWNvbn0gZnJvbSBcIkBpY29uaWZ5L3Z1ZVwiO1xuaW1wb3J0IGljb25NaXhpbiBmcm9tIFwiLi4vLi4vLi4vbWl4aW5zL2ljb25NaXhpblwiO1xuXG5leHBvcnQgZGVmYXVsdCB7XG5cdG5hbWU6IFwiTGlzdFB1YmxpY0xpbmtzXCIsXG5cdHByb3BzOiB7XG5cdFx0aXNSZWFkT25seToge1xuXHRcdFx0dHlwZTogQm9vbGVhbixcblx0XHRcdGRlZmF1bHQ6IGZhbHNlLFxuXHRcdH0sXG5cdFx0b3ZlcnJpZGVEZXN0aW5hdGlvbjoge1xuXHRcdFx0dHlwZTogU3RyaW5nLFxuXHRcdFx0ZGVmYXVsdDogXCJcIixcblx0XHR9LFxuXHRcdG92ZXJyaWRlTG9jYXRpb25JZDoge1xuXHRcdFx0dHlwZTogTnVtYmVyLFxuXHRcdFx0ZGVmYXVsdDogMCxcblx0XHR9LFxuXHR9LFxuXHRkYXRhKCkge1xuXHRcdHJldHVybiB7XG5cdFx0XHRpc0ZldGNoaW5nRGF0YTogdHJ1ZSxcblx0XHRcdHB1YmxpY0xpbmtSZXN1bHRzOiBbXSxcblx0XHR9O1xuXHR9LFxuXHR3YXRjaDoge1xuXHRcdG92ZXJyaWRlTG9jYXRpb25JZCgpIHtcblx0XHRcdHRoaXMuZ2V0UHVibGljTGlua3MoKTtcblx0XHR9LFxuXHR9LFxuXHRjb21wb25lbnRzOiB7XG5cdFx0SWNvbixcblx0fSxcblx0Y29tcHV0ZWQ6IHtcblx0XHQuLi5tYXBHZXR0ZXJzKHtcblx0XHRcdGRlc3RpbmF0aW9uOiBcImdldERlc3RpbmF0aW9uXCIsXG5cdFx0XHRsb2NhdGlvbklkOiBcImdldExvY2F0aW9uSWRcIixcblx0XHRcdHJvb3RVcmw6IFwiZ2V0Um9vdFVybFwiLFxuXHRcdFx0dXNlckxldmVsOiBcImdldFVzZXJMZXZlbFwiLFxuXHRcdH0pXG5cdH0sXG5cdG1peGluczogW2ljb25NaXhpbl0sXG5cdG1ldGhvZHM6IHtcblx0XHRhc3luYyBjb3B5UHVibGljTGluayhwdWJsaWNfbGlua19pZCkge1xuXHRcdFx0Ly9HZXQgdGhlIFVSTFxuXHRcdFx0Y29uc3QgdXJsID0gYCR7d2luZG93LmxvY2F0aW9uLm9yaWdpbn0ke3RoaXMucm9vdFVybH1wdWJsaWMvJHt0aGlzLmdldERlc3RpbmF0aW9uKCl9LyR7dGhpcy5nZXRMb2NhdGlvbklkKCl9LyR7cHVibGljX2xpbmtfaWR9L2BcblxuXHRcdFx0Ly9Db3B5IHRvIHRoZSBjbGlwYm9hcmRcblx0XHRcdHRyeSB7XG5cdFx0XHRcdGF3YWl0IG5hdmlnYXRvci5jbGlwYm9hcmQud3JpdGVUZXh0KHVybCk7XG5cblx0XHRcdFx0Ly9Ob3RpZnkgdGhlIHVzZXJcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdFx0aGVhZGVyOiBcIlB1YmxpYyBMaW5rIENvcGllZFwiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IFwiUHVibGljIExpbmsgaGFzIHN1Y2Nlc3NmdWxseSBjb3BpZWQgdG8gdGhlIGNsaXBib2FyZFwiLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctc3VjY2Vzc1wiLFxuXHRcdFx0XHR9KTtcblx0XHRcdH0gY2F0Y2goZXJyb3IpIHtcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdFx0aGVhZGVyOiBcIkNhbiBub3QgY29weSBwdWJsaWMgbGlua1wiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IFwiU29ycnksIHdlIGZhaWxlZCB0byBjb3B5IHRoZSBwdWJsaWMgbGlua1wiLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctZGFuZ2VyXCIsXG5cdFx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fVxuXHRcdH0sXG5cdFx0Y3JlYXRlUHVibGljTGluaygpIHtcblx0XHRcdC8vSW5mb3JtIHVzZXIgb2YgY3JlYXRpbmcgbmV3IGxpbmtcblx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRoZWFkZXI6IFwiQ3JlYXRpbmcgTmV3IFRvYXN0XCIsXG5cdFx0XHRcdG1lc3NhZ2U6IFwiUGxlYXNlIHdhaXQgd2hpbHN0IHdlIGNyZWF0ZSB0aGUgdG9hc3RcIixcblx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy13YXJuaW5nIHRleHQtZGFya1wiLFxuXHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0dW5pcXVlX3R5cGU6IFwiY3JlYXRlX3B1YmxpY19saW5rXCIsXG5cdFx0XHR9KTtcblxuXHRcdFx0Ly9Db250YWN0IGJhY2tlbmQgLSBnZXQgcHVibGljIGxpbmtcblx0XHRcdHRoaXMuYXhpb3MucG9zdChcblx0XHRcdFx0YCR7dGhpcy5yb290VXJsfXB1YmxpY19kYXRhLyR7dGhpcy5nZXREZXN0aW5hdGlvbigpfS8ke3RoaXMuZ2V0TG9jYXRpb25JZCgpfS9jcmVhdGUvYCxcblx0XHRcdCkudGhlbigocmVzcG9uc2UpID0+IHtcblx0XHRcdFx0Ly9JbmZvcm0gdXNlciBvZiBzdWNjZXNzXG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJTdWNjZXNzZnVsIG5ldyBQdWJsaWMgTGlua1wiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IFwiV2UgaGF2ZSBiZWVuIGFibGUgdG8gY3JlYXRlIGEgbmV3IHB1YmxpYyBsaW5rXCIsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1zdWNjZXNzXCIsXG5cdFx0XHRcdFx0dW5pcXVlX3R5cGU6IFwiY3JlYXRlX3B1YmxpY19saW5rXCIsXG5cdFx0XHRcdH0pO1xuXG5cdFx0XHRcdC8vUmVwbGFjZSBldmVyeXRoaW5nXG5cdFx0XHRcdHRoaXMucHVibGljTGlua1Jlc3VsdHMgPSByZXNwb25zZS5kYXRhO1xuXHRcdFx0fSkuY2F0Y2goKGVycm9yKSA9PiB7XG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJDYW4gbm90IGNyZWF0ZSBuZXcgcHVibGljIGxpbmtcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBgU29ycnksIHdlIGZhaWxlZCB0byBjcmVhdGUgdGhlIG5ldyBwdWJsaWMgbGluay4gRXJyb3IgLT4gJHtlcnJvcn1gLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctZGFuZ2VyXCIsXG5cdFx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdFx0dW5pcXVlX3R5cGU6IFwiY3JlYXRlX3B1YmxpY19saW5rXCIsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fSlcblx0XHR9LFxuXHRcdGRlbGV0ZVB1YmxpY0xpbmsocHVibGljX2xpbmtfaWQpIHtcblx0XHRcdC8vQ29uc3RydWN0IGRhdGEgdG8gc2VuZFxuXHRcdFx0Y29uc3QgZGF0YV90b19zZW5kID0gbmV3IEZvcm1EYXRhKCk7XG5cdFx0XHRkYXRhX3RvX3NlbmQuc2V0KFwicHVibGljX2xpbmtfaWRcIiwgcHVibGljX2xpbmtfaWQpO1xuXG5cdFx0XHQvL05vdGlmeSB1c2VyIHdlIGFyZSBkZWxldGluZyB0aGUgZGF0YVxuXHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdGhlYWRlcjogXCJEZWxldGluZyBQdWJsaWMgTGlua1wiLFxuXHRcdFx0XHRtZXNzYWdlOiBcIkRlbGV0aW5nIFB1YmxpYyBMaW5rXCIsXG5cdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctd2FybmluZyB0ZXh0LWRhcmtcIixcblx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdHVuaXF1ZV90eXBlOiBcInB1YmxpY19saW5rX2RlbGV0ZVwiLFxuXHRcdFx0fSlcblxuXHRcdFx0Ly9Vc2UgYXhpb3Ncblx0XHRcdHRoaXMuYXhpb3MucG9zdChcblx0XHRcdFx0YCR7dGhpcy5yb290VXJsfXB1YmxpY19kYXRhLyR7dGhpcy5nZXREZXN0aW5hdGlvbigpfS8ke3RoaXMuZ2V0TG9jYXRpb25JZCgpfS9kZWxldGUvYCxcblx0XHRcdFx0ZGF0YV90b19zZW5kLFxuXHRcdFx0KS50aGVuKCgpID0+IHtcblx0XHRcdFx0Ly9SZW1vdmUgdGhlIHJvd1xuXHRcdFx0XHR0aGlzLnB1YmxpY0xpbmtSZXN1bHRzID0gdGhpcy5wdWJsaWNMaW5rUmVzdWx0cy5maWx0ZXIoKHJvdykgPT4ge1xuXHRcdFx0XHRcdHJldHVybiByb3cucHVibGljX2xpbmtfaWQgIT09IHB1YmxpY19saW5rX2lkO1xuXHRcdFx0XHR9KTtcblxuXHRcdFx0XHR0aGlzLiRzdG9yZS5kaXNwYXRjaChcIm5ld1RvYXN0XCIsIHtcblx0XHRcdFx0XHRoZWFkZXI6IFwiU3VjY2Vzc2Z1bGx5IERlbGV0ZWQgUHVibGljIExpbmtcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBcIlN1Y2Nlc3NmdWxseSBEZWxldGVkIFB1YmxpYyBMaW5rXCIsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1zdWNjZXNzXCIsXG5cdFx0XHRcdFx0dW5pcXVlX3R5cGU6IFwicHVibGljX2xpbmtfZGVsZXRlXCIsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fSkuY2F0Y2goKGVycm9yKSA9PiB7XG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJFcnJvciBEZWxldGluZyBQdWJsaWMgTGlua1wiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IGBFcnJvciAtIGNvdWxkIG5vdCBkZWxldGUgbGluay4gRXJyb3IgLT4gJHtlcnJvcn1gLFxuXHRcdFx0XHRcdGV4dHJhX2NsYXNzZXM6IFwiYmctZGFuZ2VyXCIsXG5cdFx0XHRcdFx0ZGVsYXk6IDAsXG5cdFx0XHRcdFx0dW5pcXVlX3R5cGU6IFwicHVibGljX2xpbmtfZGVsZXRlXCIsXG5cdFx0XHRcdH0pO1xuXHRcdFx0fSk7XG5cdFx0fSxcblx0XHRmb3JtYXRVcmwocHVibGljX2xpbmtfaWQpIHtcblx0XHRcdC8vRG91YmxlIGNoZWNrIHdlIGFyZSBnZXR0aW5nIHRoZSBjb3JyZWN0IFVSTFxuXHRcdFx0aWYgKHB1YmxpY19saW5rX2lkID09PSBcIlwiIHx8IHB1YmxpY19saW5rX2lkID09PSB1bmRlZmluZWQpIHtcblx0XHRcdFx0cmV0dXJuIFwiRGF0YSBlcnJvciFcIjtcblx0XHRcdH1cblxuXHRcdFx0Ly9UcnVjYXRlIHRoZSBVVUlEIC0gc28gaWYgc29tZW9uZSBpcyB2aWV3aW5nIHRoZSBzY3JlZW4gdGhleSBkb24ndCBnZXQgdGhlIGtleVxuXHRcdFx0Y29uc3QgdHJ1bmNfbGlua19pZCA9IHB1YmxpY19saW5rX2lkLnNsaWNlKDAsNyk7XG5cblx0XHRcdHJldHVybiBgJHt3aW5kb3cubG9jYXRpb24ub3JpZ2lufSR7dGhpcy5yb290VXJsfXB1YmxpYy8ke3RoaXMuZ2V0RGVzdGluYXRpb24oKX0vJHt0aGlzLmdldExvY2F0aW9uSWQoKX0vJHt0cnVuY19saW5rX2lkfS4uLmBcblx0XHR9LFxuXHRcdGdldERlc3RpbmF0aW9uKCkge1xuXHRcdFx0cmV0dXJuIHRoaXMub3ZlcnJpZGVEZXN0aW5hdGlvbiAhPT0gXCJcIiA/IHRoaXMub3ZlcnJpZGVEZXN0aW5hdGlvbiA6IHRoaXMuZGVzdGluYXRpb247XG5cdFx0fSxcblx0XHRnZXRMb2NhdGlvbklkKCkge1xuXHRcdFx0Ly9JZiB0aGVyZSBpcyBhbiBvdmVycmlkZURlc3RpbmF0aW9uIC0gd2Ugd2FudCB0byB1c2UgdGhlIG92ZXJyaWRlTG9jYXRpb25JZFxuXHRcdFx0cmV0dXJuIHRoaXMub3ZlcnJpZGVEZXN0aW5hdGlvbiAhPT0gXCJcIiA/IHRoaXMub3ZlcnJpZGVMb2NhdGlvbklkIDogdGhpcy5sb2NhdGlvbklkO1xuXHRcdH0sXG5cdFx0Z2V0UHVibGljTGlua3MoKSB7XG5cdFx0XHQvL0VzY2FwZSBpZiB0aGVyZSBpcyBubyBsb2NhdGlvbiBpZFxuXHRcdFx0aWYgKHRoaXMuZ2V0TG9jYXRpb25JZCgpID09PSAwKSByZXR1cm47XG5cblx0XHRcdHRoaXMuYXhpb3MoXG5cdFx0XHRcdGAke3RoaXMucm9vdFVybH1wdWJsaWNfZGF0YS8ke3RoaXMuZ2V0RGVzdGluYXRpb24oKX0vJHt0aGlzLmdldExvY2F0aW9uSWQoKX0vZ2V0X2xpbmtzL2AsXG5cdFx0XHQpLnRoZW4oKHJlc3BvbnNlKSA9PiB7XG5cdFx0XHRcdC8vU2V0IHRoZSBkYXRhXG5cdFx0XHRcdHRoaXMucHVibGljTGlua1Jlc3VsdHMgPSByZXNwb25zZS5kYXRhO1xuXG5cdFx0XHRcdC8vU2V0IHRoZSBmZXRjaCBzdGF0dXMgdG8gZmFsc2Vcblx0XHRcdFx0dGhpcy5pc0ZldGNoaW5nRGF0YSA9IGZhbHNlO1xuXHRcdFx0fSkuY2F0Y2goKGVycm9yKSA9PiB7XG5cdFx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRcdGhlYWRlcjogXCJFcnJvciBmZXRjaGluZyBQdWJsaWMgTGlua3NcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBgV2UgaGFkIGFuIGlzc3VlIGZldGNoaW5nIHRoZSBwdWJsaWMgbGlua3MgZm9yIHRoaXMgb2JqZWN0LiBFcnJvciAtPiAke2Vycm9yfWAsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1kYW5nZXJcIixcblx0XHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0fSk7XG5cdFx0XHR9KTtcblx0XHR9LFxuXHRcdHVwZGF0ZUlzQWN0aXZlKGV2ZW50KSB7XG5cdFx0XHQvL0dldCB0aGUgdXVpZFxuXHRcdFx0Y29uc3QgdXVpZCA9IGV2ZW50LnRhcmdldC5kYXRhc2V0LnB1YmxpY0xpbmtJZDtcblxuXHRcdFx0Ly9UZWxsIHRoZSB1c2VyIHdlIGFyZSB1cGRhdGluZyB0aGUgc3RhdHNcblx0XHRcdHRoaXMuJHN0b3JlLmRpc3BhdGNoKFwibmV3VG9hc3RcIiwge1xuXHRcdFx0XHRoZWFkZXI6IFwiVXBkYXRpbmcgQWN0aXZlIFN0YXR1cyBmb3IgUHJpdmF0ZSBMaW5rXCIsXG5cdFx0XHRcdG1lc3NhZ2U6IFwiUGxlYXNlIHdhaXQgLSB3ZSBhcmUgdXBkYXRpbmcgdGhlIHN0YXR1c1wiLFxuXHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLXdhcm5pbmcgdGV4dC1kYXJrXCIsXG5cdFx0XHRcdGRlbGF5OiAwLFxuXHRcdFx0XHR1bmlxdWVfdHlwZTogYGlzX2FjdGl2ZS0ke3V1aWR9YCxcblx0XHRcdH0pO1xuXG5cdFx0XHQvL1RyYW5zbGF0ZSB0aGUgY2hlY2tlZCBib3hcblx0XHRcdGxldCBpc19hY3RpdmUgPSBcIkZhbHNlXCI7XG5cdFx0XHRpZiAoZXZlbnQudGFyZ2V0LmNoZWNrZWQpIHtcblx0XHRcdFx0aXNfYWN0aXZlID0gXCJUcnVlXCI7XG5cdFx0XHR9XG5cblx0XHRcdC8vU2V0dXAgZGF0YSB0byBzZW5kXG5cdFx0XHRjb25zdCBkYXRhX3RvX3NlbmQgPSBuZXcgRm9ybURhdGEoKTtcblx0XHRcdGRhdGFfdG9fc2VuZC5zZXQoXCJwdWJsaWNfbGlua19pZFwiLCB1dWlkKTtcblx0XHRcdGRhdGFfdG9fc2VuZC5zZXQoXCJwdWJsaWNfbGlua19pc19hY3RpdmVcIiwgaXNfYWN0aXZlKTtcblxuXHRcdFx0dGhpcy5heGlvcy5wb3N0KFxuXHRcdFx0XHRgJHt0aGlzLnJvb3RVcmx9cHVibGljX2RhdGEvJHt0aGlzLmRlc3RpbmF0aW9ufS8ke3RoaXMubG9jYXRpb25JZH0vdXBkYXRlX2xpbmsvYCxcblx0XHRcdFx0ZGF0YV90b19zZW5kLFxuXHRcdFx0KS50aGVuKCgpID0+IHtcblx0XHRcdFx0Ly9VcGRhdGUgdXNlclxuXHRcdFx0XHR0aGlzLiRzdG9yZS5kaXNwYXRjaChcIm5ld1RvYXN0XCIsIHtcblx0XHRcdFx0XHRoZWFkZXI6IFwiU3VjY2Vzc2Z1bGx5IFVwZGF0ZWRcIixcblx0XHRcdFx0XHRtZXNzYWdlOiBcIldlIGhhdmUgdXBkYXRlZCB0aGUgaXMgYWN0aXZlIHN0YXR1cyBmb3IgdGhlIGxpbmtcIixcblx0XHRcdFx0XHRleHRyYV9jbGFzc2VzOiBcImJnLXN1Y2Nlc3NcIixcblx0XHRcdFx0XHR1bmlxdWVfdHlwZTogYGlzX2FjdGl2ZS0ke3V1aWR9YCxcblx0XHRcdFx0fSk7XG5cdFx0XHR9KS5jYXRjaCgoZXJyb3IpID0+IHtcblx0XHRcdFx0dGhpcy4kc3RvcmUuZGlzcGF0Y2goXCJuZXdUb2FzdFwiLCB7XG5cdFx0XHRcdFx0aGVhZGVyOiBcIkVycm9yIFVwZGF0aW5nIEFjdGl2ZSBTdGF0dXMgZm9yIFByaXZhdGUgTGlua1wiLFxuXHRcdFx0XHRcdG1lc3NhZ2U6IGBXZSBhcmUgc29ycnksIHNvbWV0aGluZyB3ZW50IHdyb25nLiBFcnJvciAtPiAke2Vycm9yfWAsXG5cdFx0XHRcdFx0ZXh0cmFfY2xhc3NlczogXCJiZy1kYW5nZXJcIixcblx0XHRcdFx0XHRkZWxheTogMCxcblx0XHRcdFx0XHR1bmlxdWVfdHlwZTogYGlzX2FjdGl2ZS0ke3V1aWR9YCxcblx0XHRcdFx0fSk7XG5cdFx0XHR9KVxuXHRcdH0sXG5cdH0sXG5cdG1vdW50ZWQoKSB7XG5cdFx0dGhpcy4kbmV4dFRpY2soKCkgPT4ge1xuXHRcdFx0dGhpcy5nZXRQdWJsaWNMaW5rcygpO1xuXHRcdH0pXG5cdH0sXG59XG48L3NjcmlwdD4iLCJleHBvcnQgeyBkZWZhdWx0IH0gZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC9pbmRleC5qcz8/cnVsZVNldFsxXS5ydWxlc1s2XS51c2VbMF0hLi9MaXN0UHVibGljTGlua3MudnVlP3Z1ZSZ0eXBlPXNjcmlwdCZsYW5nPWpzXCI7IGV4cG9ydCAqIGZyb20gXCItIS4uLy4uLy4uLy4uLy4uL25vZGVfbW9kdWxlcy92dWUtbG9hZGVyL2Rpc3QvaW5kZXguanM/P3J1bGVTZXRbMV0ucnVsZXNbNl0udXNlWzBdIS4vTGlzdFB1YmxpY0xpbmtzLnZ1ZT92dWUmdHlwZT1zY3JpcHQmbGFuZz1qc1wiIiwiZXhwb3J0ICogZnJvbSBcIi0hLi4vLi4vLi4vLi4vLi4vbm9kZV9tb2R1bGVzL3Z1ZS1sb2FkZXIvZGlzdC90ZW1wbGF0ZUxvYWRlci5qcz8/cnVsZVNldFsxXS5ydWxlc1sxXSEuLi8uLi8uLi8uLi8uLi9ub2RlX21vZHVsZXMvdnVlLWxvYWRlci9kaXN0L2luZGV4LmpzPz9ydWxlU2V0WzFdLnJ1bGVzWzZdLnVzZVswXSEuL0xpc3RQdWJsaWNMaW5rcy52dWU/dnVlJnR5cGU9dGVtcGxhdGUmaWQ9MzViZTVkYTdcIiJdLCJuYW1lcyI6WyJ1c2VyTGV2ZWwiLCJpY29ucyJdLCJzb3VyY2VSb290IjoiIn0=