"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["src_js_components_object_scheduler_SchedulerFrequency_vue-src_js_mixins_uploadMixin_js"],{

/***/ "./src/js/components/object_scheduler/SchedulerFrequency.vue":
/*!*******************************************************************!*\
  !*** ./src/js/components/object_scheduler/SchedulerFrequency.vue ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SchedulerFrequency_vue_vue_type_template_id_2995f54e__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SchedulerFrequency.vue?vue&type=template&id=2995f54e */ "./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=template&id=2995f54e");
/* harmony import */ var _SchedulerFrequency_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./SchedulerFrequency.vue?vue&type=script&lang=js */ "./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=script&lang=js");
/* harmony import */ var _node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../../node_modules/vue-loader/dist/exportHelper.js */ "./node_modules/vue-loader/dist/exportHelper.js");




;
const __exports__ = /*#__PURE__*/(0,_node_modules_vue_loader_dist_exportHelper_js__WEBPACK_IMPORTED_MODULE_2__["default"])(_SchedulerFrequency_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_1__["default"], [['render',_SchedulerFrequency_vue_vue_type_template_id_2995f54e__WEBPACK_IMPORTED_MODULE_0__.render],['__file',"src/js/components/object_scheduler/SchedulerFrequency.vue"]])
/* hot reload */
if (false) {}


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (__exports__);

/***/ }),

/***/ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=script&lang=js":
/*!***************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=script&lang=js ***!
  \***************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var naive_ui__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! naive-ui */ "./node_modules/naive-ui/es/date-picker/src/DatePicker.mjs");
/* harmony import */ var naive_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! naive-ui */ "./node_modules/naive-ui/es/input-number/src/InputNumber.mjs");
/* harmony import */ var naive_ui__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! naive-ui */ "./node_modules/naive-ui/es/select/src/Select.mjs");

//Components


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
	name: "SchedulerFrequency",
	components: {
		NDatePicker: naive_ui__WEBPACK_IMPORTED_MODULE_0__["default"],
		NInputNumber: naive_ui__WEBPACK_IMPORTED_MODULE_1__["default"],
		NSelect: naive_ui__WEBPACK_IMPORTED_MODULE_2__["default"],
	},
	props: {
		daysBefore: {
			type: Number,
			default: 0,
		},
		day: {
			type: Array,
			default: () => {
				return [];
			},
		},
		endDateCondition: {
			type: String,
			default: "no-end-date"
		},
		endDate: {
			type: Number,
			default: 0,
		},
		numberOfRepeats: {
			type: Number,
			default: 0,
		},
		schedulerFrequency: {
			type: String,
			default: "Set Day of the Week",
		},
		singleDay: {
			type: String,
			default: "monday",
		},
		startDate: {
			type: Number,
			default: 0,
		},
	},
	data() {
		return {
			daysBeforeModel: this.daysBefore,
			dayModel: this.day,
			dayOfTheWeekArray: [
				{ value: "monday", shortLabel: "Mon", label: "Monday" },
				{ value: "tuesday", shortLabel: "Tue", label: "Tuesday" },
				{ value: "wednesday", shortLabel: "Wed", label: "Wednesday" },
				{ value: "thursday", shortLabel: "Thur", label: "Thursday" },
				{ value: "friday", shortLabel: "Fri", label: "Friday" },
				{ value: "saturday", shortLabel: "Sat", label: "Saturday" },
				{ value: "sunday", shortLabel: "Sun", label: "Sunday" },
			],
			endDateConditionList: [
				{ value: "no-end-date", label: "No End Date" },
				{ value: "number-of-repeats", label: "Number of Repeats" },
				{ value: "end-date", label: "End Date" },
			],
			endDateConditionModel: this.endDateCondition,
			endDateModel: this.endDate,
			isFormValid: false,
			numberOfRepeatsModel: this.numberOfRepeats,
			schedulerFrequencyModel: this.schedulerFrequency,
			schedulerFrequencyOptions: [
				{ value: "Set Day of the Week", label: "Set Day of the Week" },
				{ value: "Weekly", label: "Weekly"},
				{ value: "Fortnightly", label: "Fortnightly"},
				{ value: "Monthly", label: "Monthly"},
				{ value: "Start of the Month", label: "Start of the Month"},
				{ value: "End of the Month", label: "End of the Month"},
				{ value: "X Days before End of the Month", label: "X Days before End of the Month"},
			],
			singleDayModel: this.singleDay,
			startDateModel: this.startDate,
		}
	},
	computed: {
		calendarType() {
			if (['Start of the Month', 'End of the Month'].includes(this.schedulerFrequencyModel)) {
				return "month";
			}

			return "date";
		},
		calendarFormat() {
			if (['Start of the Month', 'End of the Month'].includes(this.schedulerFrequencyModel)) {
				return "y-MMM";
			}

			return "y-MM-dd";
		},
	},
	watch: {
		dayModel() {
			this.updateIsValid();
		},
		daysBeforeModel() {
			this.updateIsValid();
		},
		endDateConditionModel() {
			this.updateIsValid();
		},
		endDateModel() {
			this.updateIsValid();
		},
		numberOfRepeatsModel() {
			this.updateIsValid();
		},
		schedulerFrequencyModel() {
			this.updateIsValid();
		},
		singleDayModel() {
			this.updateIsValid();
		},
		startDateModel() {
			this.updateIsValid();
		},
	},
	methods: {
		endDateDisabled(end_date) {
			return this.startDateModel >= end_date;
		},
		sendDataUpstream() {
			this.$emit("update_scheduler_frequency", {
				dayModel: this.dayModel,
				daysBeforeModel: this.daysBeforeModel,
				endDateConditionModel: this.endDateConditionModel,
				endDateModel: this.endDateModel,
				isFormValid: this.isFormValid,
				numberOfRepeatsModel: this.numberOfRepeatsModel,
				schedulerFrequencyModel: this.schedulerFrequencyModel,
				singleDayModel: this.singleDayModel,
				startDateModel: this.startDateModel,
			});
		},
		startDateDisabled(start_date) {
            //Get date but level the time to 23:59:59
            const date = new Date();
            date.setMilliseconds(999);
            date.setSeconds(59);
            date.setMinutes(59);
            date.setHours(23);

            //Return anything that is less than today
            return start_date <= date.getTime();
        },
		updateIsValid() {
			//Assume the best
			let is_valid = true;

			//Common
			if (this.startDateModel === null || this.startDateModel === "") {
				is_valid = false;
			}

			//Conditional Validation
			if (this.endDateConditionModel === "number-of-repeats" && this.numberOfRepeatsModel === null) {
				this.numberOfRepeatsModel = 0;
			}

			if (this.endDateConditionModel === "end-date" && this.endDateModel === null) {
				this.endDateModel = this.startDateModel;
			}

			//Specific Validation
			if (this.schedulerFrequencyModel === "Set Day of the Week" && this.dayModel.length === 0) {
				is_valid = false;
			}

			if (this.schedulerFrequencyModel === "X Days before End of the Month" && this.daysBeforeModel === null) {
				//Go default
				this.daysBeforeModel = 0;
			}

			//Update the value
			this.isFormValid = is_valid;

			//Send data upstream
			this.sendDataUpstream();
		},
	},
	mounted() {
		//Update start date
		const temp_date = new Date();
		temp_date.setHours(9);
		temp_date.setMinutes(0);
		temp_date.setSeconds(0);
		temp_date.setMilliseconds(0);

		this.startDateModel = temp_date.getTime() + (1000 * 60 * 60 * 24);
		this.endDateModel = temp_date.getTime() + (1000 * 60 * 60 * 24 * 7);
	}

});


/***/ }),

/***/ "./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=script&lang=js":
/*!*******************************************************************************************!*\
  !*** ./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=script&lang=js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* reexport safe */ _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_SchedulerFrequency_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__["default"])
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_SchedulerFrequency_vue_vue_type_script_lang_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./SchedulerFrequency.vue?vue&type=script&lang=js */ "./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=script&lang=js");
 

/***/ }),

/***/ "./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=template&id=2995f54e":
/*!*************************************************************************************************!*\
  !*** ./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=template&id=2995f54e ***!
  \*************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* reexport safe */ _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_SchedulerFrequency_vue_vue_type_template_id_2995f54e__WEBPACK_IMPORTED_MODULE_0__.render)
/* harmony export */ });
/* harmony import */ var _node_modules_vue_loader_dist_templateLoader_js_ruleSet_1_rules_1_node_modules_vue_loader_dist_index_js_ruleSet_1_rules_6_use_0_SchedulerFrequency_vue_vue_type_template_id_2995f54e__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! -!../../../../node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!../../../../node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./SchedulerFrequency.vue?vue&type=template&id=2995f54e */ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=template&id=2995f54e");


/***/ }),

/***/ "./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=template&id=2995f54e":
/*!*******************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/vue-loader/dist/templateLoader.js??ruleSet[1].rules[1]!./node_modules/vue-loader/dist/index.js??ruleSet[1].rules[6].use[0]!./src/js/components/object_scheduler/SchedulerFrequency.vue?vue&type=template&id=2995f54e ***!
  \*******************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   render: () => (/* binding */ render)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const _hoisted_1 = { class: "row" }
const _hoisted_2 = { class: "col-md-8" }
const _hoisted_3 = { class: "row mt-4" }
const _hoisted_4 = { class: "col-md-6" }
const _hoisted_5 = {
  key: 0,
  class: "error"
}
const _hoisted_6 = { class: "col-md-6" }
const _hoisted_7 = {
  key: 0,
  class: "row mt-4"
}
const _hoisted_8 = { class: "col-md-6" }
const _hoisted_9 = {
  key: 0,
  class: "error"
}
const _hoisted_10 = {
  key: 1,
  class: "row mt-4"
}
const _hoisted_11 = { class: "col-md-6" }
const _hoisted_12 = {
  key: 0,
  class: "error"
}
const _hoisted_13 = {
  key: 2,
  class: "row mt-4"
}
const _hoisted_14 = { class: "text-center col-md-1" }
const _hoisted_15 = ["for"]
const _hoisted_16 = ["value", "id"]
const _hoisted_17 = { class: "col-md-5" }
const _hoisted_18 = {
  key: 0,
  class: "error"
}
const _hoisted_19 = {
  key: 3,
  class: "row mt-4"
}
const _hoisted_20 = { class: "col-md-3" }
const _hoisted_21 = {
  key: 4,
  class: "row mt-4"
}
const _hoisted_22 = { class: "col-md-3" }
const _hoisted_23 = {
  key: 0,
  class: "error"
}

function render(_ctx, _cache, $props, $setup, $data, $options) {
  const _component_n_select = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("n-select")
  const _component_n_date_picker = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("n-date-picker")
  const _component_n_input_number = (0,vue__WEBPACK_IMPORTED_MODULE_0__.resolveComponent)("n-input-number")

  return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_1, [
    _cache[15] || (_cache[15] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", { class: "col-md-4" }, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("h2", null, "Scheduler Frequency"),
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("p", { class: "text-instructions" }, " Choose the appropriate schedule frequency. Then fill out the required data. Please take note of the fields; number of repeats. ")
    ], -1 /* HOISTED */)),
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_2, [
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", null, [
        _cache[8] || (_cache[8] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Scheduler Object Frequency", -1 /* HOISTED */)),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_select, {
          options: $data.schedulerFrequencyOptions,
          value: $data.schedulerFrequencyModel,
          "onUpdate:value": _cache[0] || (_cache[0] = $event => (($data.schedulerFrequencyModel) = $event))
        }, null, 8 /* PROPS */, ["options", "value"])
      ]),
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" START DATE "),
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_3, [
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_4, [
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, [
            _cache[9] || (_cache[9] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Start Date ")),
            ($data.startDateModel === null || $data.startDateModel === '')
              ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_5, " Please select a date "))
              : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
          ]),
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_date_picker, {
            type: $options.calendarType,
            value: $data.startDateModel,
            "onUpdate:value": _cache[1] || (_cache[1] = $event => (($data.startDateModel) = $event)),
            actions: [],
            format: $options.calendarFormat,
            "is-date-disabled": $options.startDateDisabled,
            "month-format": "MMM"
          }, null, 8 /* PROPS */, ["type", "value", "format", "is-date-disabled"])
        ]),
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_6, [
          _cache[10] || (_cache[10] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "End Date Condition", -1 /* HOISTED */)),
          (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_select, {
            options: $data.endDateConditionList,
            value: $data.endDateConditionModel,
            "onUpdate:value": _cache[2] || (_cache[2] = $event => (($data.endDateConditionModel) = $event))
          }, null, 8 /* PROPS */, ["options", "value"])
        ])
      ]),
      ($data.endDateConditionModel === 'end-date')
        ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_7, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_8, [
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, [
                _cache[11] || (_cache[11] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" End Date ")),
                ($data.endDateModel === null)
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_9, " Please select a date "))
                  : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
              ]),
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_date_picker, {
                type: $options.calendarType,
                value: $data.endDateModel,
                "onUpdate:value": _cache[3] || (_cache[3] = $event => (($data.endDateModel) = $event)),
                actions: [],
                format: $options.calendarFormat,
                "is-date-disabled": $options.endDateDisabled
              }, null, 8 /* PROPS */, ["type", "value", "format", "is-date-disabled"])
            ])
          ]))
        : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
      ($data.endDateConditionModel === 'number-of-repeats')
        ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_10, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_11, [
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, [
                _cache[12] || (_cache[12] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Number of Repeats ")),
                ($data.numberOfRepeatsModel === null)
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_12, " Please fill out "))
                  : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
              ]),
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_input_number, {
                value: $data.numberOfRepeatsModel,
                "onUpdate:value": _cache[4] || (_cache[4] = $event => (($data.numberOfRepeatsModel) = $event)),
                min: "0"
              }, null, 8 /* PROPS */, ["value"])
            ])
          ]))
        : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Day picker "),
      ($data.schedulerFrequencyModel === 'Set Day of the Week')
        ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_13, [
            ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(true), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null, (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderList)($data.dayOfTheWeekArray, (day) => {
              return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_14, [
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", {
                  for: `checkbox_${day.value}`
                }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.toDisplayString)(day.shortLabel), 9 /* TEXT, PROPS */, _hoisted_15),
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("input", {
                  type: "checkbox",
                  value: day.value,
                  id: `checkbox_${day.value}`,
                  "onUpdate:modelValue": _cache[5] || (_cache[5] = $event => (($data.dayModel) = $event))
                }, null, 8 /* PROPS */, _hoisted_16), [
                  [vue__WEBPACK_IMPORTED_MODULE_0__.vModelCheckbox, $data.dayModel]
                ])
              ]))
            }), 256 /* UNKEYED_FRAGMENT */)),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_17, [
              ($data.dayModel.length === 0)
                ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("label", _hoisted_18, " Please select at least one day. "))
                : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
            ])
          ]))
        : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" Weekly picker "),
      (['Weekly','Fortnightly'].includes($data.schedulerFrequencyModel))
        ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_19, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_20, [
              _cache[13] || (_cache[13] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, "Day of Week", -1 /* HOISTED */)),
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_select, {
                options: $data.dayOfTheWeekArray,
                value: $data.singleDayModel,
                "onUpdate:value": _cache[6] || (_cache[6] = $event => (($data.singleDayModel) = $event)),
                class: "form-group"
              }, null, 8 /* PROPS */, ["options", "value"])
            ])
          ]))
        : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true),
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)(" X Days before End of the Month "),
      ($data.schedulerFrequencyModel === 'X Days before End of the Month')
        ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("div", _hoisted_21, [
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("div", _hoisted_22, [
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementVNode)("label", null, [
                _cache[14] || (_cache[14] = (0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(" Days Before ")),
                ($data.daysBeforeModel === null)
                  ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.openBlock)(), (0,vue__WEBPACK_IMPORTED_MODULE_0__.createElementBlock)("span", _hoisted_23, " Please fill "))
                  : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
              ]),
              (0,vue__WEBPACK_IMPORTED_MODULE_0__.createVNode)(_component_n_input_number, {
                value: $data.daysBeforeModel,
                "onUpdate:value": _cache[7] || (_cache[7] = $event => (($data.daysBeforeModel) = $event)),
                min: "0",
                max: "14"
              }, null, 8 /* PROPS */, ["value"])
            ])
          ]))
        : (0,vue__WEBPACK_IMPORTED_MODULE_0__.createCommentVNode)("v-if", true)
    ])
  ]))
}

/***/ }),

/***/ "./src/js/mixins/uploadMixin.js":
/*!**************************************!*\
  !*** ./src/js/mixins/uploadMixin.js ***!
  \**************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var axios__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! axios */ "./node_modules/axios/lib/axios.js");
/* harmony import */ var vuex__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vuex */ "./node_modules/vuex/dist/vuex.esm-bundler.js");
//Axios


//VueX


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
    computed: {
        ...(0,vuex__WEBPACK_IMPORTED_MODULE_0__.mapGetters)({
            destination: "getDestination",
            locationId: "getLocationId",
            rootUrl: "getRootUrl",
        }),
    },
    methods: {
        uploadImage(blobInfo) {
            //Create the form
            const data_to_send = new FormData();
            data_to_send.set("document", blobInfo.blob(), blobInfo.filename());
            data_to_send.set("document_description", blobInfo.filename());

            //Configuration for axios
            const config = {
                onUploadProgress: () => {
                    //As the document gets uploaded - we want to update the upload Percentage
                    
                },
            };

            //Use axios to send the data
            return this.axios.post(
                `${this.rootUrl}documentation/${this.destination}/${this.locationId}/upload/`,
                data_to_send,
                config
            ).then((response) => {
                //Just send the location to the success
                return `/private/${response.data[0].document_key_id}`;
            }).catch((error) => {
                this.$store.dispatch("newToast", {
                    header: "Failed to upload image",
                    message: `Sorry, could not upload image. Error -> ${error}`,
                    extra_classes: "bg-danger",
                    delay: 0,
                });
            });
        },
        newObjectUploadImage(blobInfo) {
            //Create the form
            const data_to_send = new FormData();
            data_to_send.set("document", blobInfo.blob(), blobInfo.filename());
            data_to_send.set("document_description", blobInfo.filename());
            data_to_send.set("uuid", this.uuid);

            //Configuration for axios
            const config = {
                onUploadProgress: () => {
                    //As the document gets uploaded - we want to update the upload Percentage
                    
                },
            };

            //Use axios to send the data
            return axios__WEBPACK_IMPORTED_MODULE_1__["default"].post(
                `${this.rootUrl}documentation/new_object_upload/`,
                data_to_send,
                config
            ).then((response) => {
                //Just send the location to the success
                return `/private/${response.data[0].document_key_id}`;
            }).catch((error) => {
                this.$store.dispatch("newToast", {
                    header: "Failed to upload image",
                    message: `Sorry, could not upload image. Error -> ${error}`,
                    extra_classes: "bg-danger",
                    delay: 0,
                });
            });
        }
    },
});


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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