"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_iconify_vue_dist_iconify_mjs"],{

/***/ "./node_modules/@iconify/vue/dist/iconify.mjs":
/*!****************************************************!*\
  !*** ./node_modules/@iconify/vue/dist/iconify.mjs ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Icon: () => (/* binding */ Icon),
/* harmony export */   _api: () => (/* binding */ _api),
/* harmony export */   addAPIProvider: () => (/* binding */ addAPIProvider),
/* harmony export */   addCollection: () => (/* binding */ addCollection),
/* harmony export */   addIcon: () => (/* binding */ addIcon),
/* harmony export */   buildIcon: () => (/* binding */ buildIcon),
/* harmony export */   calculateSize: () => (/* binding */ calculateSize),
/* harmony export */   disableCache: () => (/* binding */ disableCache),
/* harmony export */   enableCache: () => (/* binding */ enableCache),
/* harmony export */   getIcon: () => (/* binding */ getIcon),
/* harmony export */   iconExists: () => (/* binding */ iconExists),
/* harmony export */   listIcons: () => (/* binding */ listIcons),
/* harmony export */   loadIcon: () => (/* binding */ loadIcon),
/* harmony export */   loadIcons: () => (/* binding */ loadIcons),
/* harmony export */   replaceIDs: () => (/* binding */ replaceIDs),
/* harmony export */   shareStorage: () => (/* binding */ shareStorage)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");


const matchName = /^[a-z0-9]+(-[a-z0-9]+)*$/;
const iconDefaults = Object.freeze({
  left: 0,
  top: 0,
  width: 16,
  height: 16,
  rotate: 0,
  vFlip: false,
  hFlip: false
});
function fullIcon(data) {
  return { ...iconDefaults, ...data };
}

const stringToIcon = (value, validate, allowSimpleName, provider = "") => {
  const colonSeparated = value.split(":");
  if (value.slice(0, 1) === "@") {
    if (colonSeparated.length < 2 || colonSeparated.length > 3) {
      return null;
    }
    provider = colonSeparated.shift().slice(1);
  }
  if (colonSeparated.length > 3 || !colonSeparated.length) {
    return null;
  }
  if (colonSeparated.length > 1) {
    const name2 = colonSeparated.pop();
    const prefix = colonSeparated.pop();
    const result = {
      provider: colonSeparated.length > 0 ? colonSeparated[0] : provider,
      prefix,
      name: name2
    };
    return validate && !validateIcon(result) ? null : result;
  }
  const name = colonSeparated[0];
  const dashSeparated = name.split("-");
  if (dashSeparated.length > 1) {
    const result = {
      provider,
      prefix: dashSeparated.shift(),
      name: dashSeparated.join("-")
    };
    return validate && !validateIcon(result) ? null : result;
  }
  if (allowSimpleName && provider === "") {
    const result = {
      provider,
      prefix: "",
      name
    };
    return validate && !validateIcon(result, allowSimpleName) ? null : result;
  }
  return null;
};
const validateIcon = (icon, allowSimpleName) => {
  if (!icon) {
    return false;
  }
  return !!((icon.provider === "" || icon.provider.match(matchName)) && (allowSimpleName && icon.prefix === "" || icon.prefix.match(matchName)) && icon.name.match(matchName));
};

function mergeIconData(icon, alias) {
  const result = { ...icon };
  for (const key in iconDefaults) {
    const prop = key;
    if (alias[prop] !== void 0) {
      const value = alias[prop];
      if (result[prop] === void 0) {
        result[prop] = value;
        continue;
      }
      switch (prop) {
        case "rotate":
          result[prop] = (result[prop] + value) % 4;
          break;
        case "hFlip":
        case "vFlip":
          result[prop] = value !== result[prop];
          break;
        default:
          result[prop] = value;
      }
    }
  }
  return result;
}

function getIconData$1(data, name, full = false) {
  function getIcon(name2, iteration) {
    if (data.icons[name2] !== void 0) {
      return Object.assign({}, data.icons[name2]);
    }
    if (iteration > 5) {
      return null;
    }
    const aliases = data.aliases;
    if (aliases && aliases[name2] !== void 0) {
      const item = aliases[name2];
      const result2 = getIcon(item.parent, iteration + 1);
      if (result2) {
        return mergeIconData(result2, item);
      }
      return result2;
    }
    const chars = data.chars;
    if (!iteration && chars && chars[name2] !== void 0) {
      return getIcon(chars[name2], iteration + 1);
    }
    return null;
  }
  const result = getIcon(name, 0);
  if (result) {
    for (const key in iconDefaults) {
      if (result[key] === void 0 && data[key] !== void 0) {
        result[key] = data[key];
      }
    }
  }
  return result && full ? fullIcon(result) : result;
}

function isVariation(item) {
  for (const key in iconDefaults) {
    if (item[key] !== void 0) {
      return true;
    }
  }
  return false;
}
function parseIconSet(data, callback, options) {
  options = options || {};
  const names = [];
  if (typeof data !== "object" || typeof data.icons !== "object") {
    return names;
  }
  if (data.not_found instanceof Array) {
    data.not_found.forEach((name) => {
      callback(name, null);
      names.push(name);
    });
  }
  const icons = data.icons;
  Object.keys(icons).forEach((name) => {
    const iconData = getIconData$1(data, name, true);
    if (iconData) {
      callback(name, iconData);
      names.push(name);
    }
  });
  const parseAliases = options.aliases || "all";
  if (parseAliases !== "none" && typeof data.aliases === "object") {
    const aliases = data.aliases;
    Object.keys(aliases).forEach((name) => {
      if (parseAliases === "variations" && isVariation(aliases[name])) {
        return;
      }
      const iconData = getIconData$1(data, name, true);
      if (iconData) {
        callback(name, iconData);
        names.push(name);
      }
    });
  }
  return names;
}

const optionalProperties = {
  provider: "string",
  aliases: "object",
  not_found: "object"
};
for (const prop in iconDefaults) {
  optionalProperties[prop] = typeof iconDefaults[prop];
}
function quicklyValidateIconSet(obj) {
  if (typeof obj !== "object" || obj === null) {
    return null;
  }
  const data = obj;
  if (typeof data.prefix !== "string" || !obj.icons || typeof obj.icons !== "object") {
    return null;
  }
  for (const prop in optionalProperties) {
    if (obj[prop] !== void 0 && typeof obj[prop] !== optionalProperties[prop]) {
      return null;
    }
  }
  const icons = data.icons;
  for (const name in icons) {
    const icon = icons[name];
    if (!name.match(matchName) || typeof icon.body !== "string") {
      return null;
    }
    for (const prop in iconDefaults) {
      if (icon[prop] !== void 0 && typeof icon[prop] !== typeof iconDefaults[prop]) {
        return null;
      }
    }
  }
  const aliases = data.aliases;
  if (aliases) {
    for (const name in aliases) {
      const icon = aliases[name];
      const parent = icon.parent;
      if (!name.match(matchName) || typeof parent !== "string" || !icons[parent] && !aliases[parent]) {
        return null;
      }
      for (const prop in iconDefaults) {
        if (icon[prop] !== void 0 && typeof icon[prop] !== typeof iconDefaults[prop]) {
          return null;
        }
      }
    }
  }
  return data;
}

const storageVersion = 1;
let storage$1 = /* @__PURE__ */ Object.create(null);
try {
  const w = window || self;
  if (w && w._iconifyStorage.version === storageVersion) {
    storage$1 = w._iconifyStorage.storage;
  }
} catch (err) {
}
function shareStorage() {
  try {
    const w = window || self;
    if (w && !w._iconifyStorage) {
      w._iconifyStorage = {
        version: storageVersion,
        storage: storage$1
      };
    }
  } catch (err) {
  }
}
function newStorage(provider, prefix) {
  return {
    provider,
    prefix,
    icons: /* @__PURE__ */ Object.create(null),
    missing: /* @__PURE__ */ Object.create(null)
  };
}
function getStorage(provider, prefix) {
  if (storage$1[provider] === void 0) {
    storage$1[provider] = /* @__PURE__ */ Object.create(null);
  }
  const providerStorage = storage$1[provider];
  if (providerStorage[prefix] === void 0) {
    providerStorage[prefix] = newStorage(provider, prefix);
  }
  return providerStorage[prefix];
}
function addIconSet(storage2, data) {
  if (!quicklyValidateIconSet(data)) {
    return [];
  }
  const t = Date.now();
  return parseIconSet(data, (name, icon) => {
    if (icon) {
      storage2.icons[name] = icon;
    } else {
      storage2.missing[name] = t;
    }
  });
}
function addIconToStorage(storage2, name, icon) {
  try {
    if (typeof icon.body === "string") {
      storage2.icons[name] = Object.freeze(fullIcon(icon));
      return true;
    }
  } catch (err) {
  }
  return false;
}
function getIconFromStorage(storage2, name) {
  const value = storage2.icons[name];
  return value === void 0 ? null : value;
}
function listIcons(provider, prefix) {
  let allIcons = [];
  let providers;
  if (typeof provider === "string") {
    providers = [provider];
  } else {
    providers = Object.keys(storage$1);
  }
  providers.forEach((provider2) => {
    let prefixes;
    if (typeof provider2 === "string" && typeof prefix === "string") {
      prefixes = [prefix];
    } else {
      prefixes = storage$1[provider2] === void 0 ? [] : Object.keys(storage$1[provider2]);
    }
    prefixes.forEach((prefix2) => {
      const storage2 = getStorage(provider2, prefix2);
      const icons = Object.keys(storage2.icons).map((name) => (provider2 !== "" ? "@" + provider2 + ":" : "") + prefix2 + ":" + name);
      allIcons = allIcons.concat(icons);
    });
  });
  return allIcons;
}

let simpleNames = false;
function allowSimpleNames(allow) {
  if (typeof allow === "boolean") {
    simpleNames = allow;
  }
  return simpleNames;
}
function getIconData(name) {
  const icon = typeof name === "string" ? stringToIcon(name, true, simpleNames) : name;
  return icon ? getIconFromStorage(getStorage(icon.provider, icon.prefix), icon.name) : null;
}
function addIcon(name, data) {
  const icon = stringToIcon(name, true, simpleNames);
  if (!icon) {
    return false;
  }
  const storage = getStorage(icon.provider, icon.prefix);
  return addIconToStorage(storage, icon.name, data);
}
function addCollection(data, provider) {
  if (typeof data !== "object") {
    return false;
  }
  if (typeof provider !== "string") {
    provider = typeof data.provider === "string" ? data.provider : "";
  }
  if (simpleNames && provider === "" && (typeof data.prefix !== "string" || data.prefix === "")) {
    let added = false;
    if (quicklyValidateIconSet(data)) {
      data.prefix = "";
      parseIconSet(data, (name, icon) => {
        if (icon && addIcon(name, icon)) {
          added = true;
        }
      });
    }
    return added;
  }
  if (typeof data.prefix !== "string" || !validateIcon({
    provider,
    prefix: data.prefix,
    name: "a"
  })) {
    return false;
  }
  const storage = getStorage(provider, data.prefix);
  return !!addIconSet(storage, data);
}
function iconExists(name) {
  return getIconData(name) !== null;
}
function getIcon(name) {
  const result = getIconData(name);
  return result ? { ...result } : null;
}

const defaults = Object.freeze({
  inline: false,
  width: null,
  height: null,
  hAlign: "center",
  vAlign: "middle",
  slice: false,
  hFlip: false,
  vFlip: false,
  rotate: 0
});
function mergeCustomisations(defaults2, item) {
  const result = {};
  for (const key in defaults2) {
    const attr = key;
    result[attr] = defaults2[attr];
    if (item[attr] === void 0) {
      continue;
    }
    const value = item[attr];
    switch (attr) {
      case "inline":
      case "slice":
        if (typeof value === "boolean") {
          result[attr] = value;
        }
        break;
      case "hFlip":
      case "vFlip":
        if (value === true) {
          result[attr] = !result[attr];
        }
        break;
      case "hAlign":
      case "vAlign":
        if (typeof value === "string" && value !== "") {
          result[attr] = value;
        }
        break;
      case "width":
      case "height":
        if (typeof value === "string" && value !== "" || typeof value === "number" && value || value === null) {
          result[attr] = value;
        }
        break;
      case "rotate":
        if (typeof value === "number") {
          result[attr] += value;
        }
        break;
    }
  }
  return result;
}

const unitsSplit = /(-?[0-9.]*[0-9]+[0-9.]*)/g;
const unitsTest = /^-?[0-9.]*[0-9]+[0-9.]*$/g;
function calculateSize(size, ratio, precision) {
  if (ratio === 1) {
    return size;
  }
  precision = precision === void 0 ? 100 : precision;
  if (typeof size === "number") {
    return Math.ceil(size * ratio * precision) / precision;
  }
  if (typeof size !== "string") {
    return size;
  }
  const oldParts = size.split(unitsSplit);
  if (oldParts === null || !oldParts.length) {
    return size;
  }
  const newParts = [];
  let code = oldParts.shift();
  let isNumber = unitsTest.test(code);
  while (true) {
    if (isNumber) {
      const num = parseFloat(code);
      if (isNaN(num)) {
        newParts.push(code);
      } else {
        newParts.push(Math.ceil(num * ratio * precision) / precision);
      }
    } else {
      newParts.push(code);
    }
    code = oldParts.shift();
    if (code === void 0) {
      return newParts.join("");
    }
    isNumber = !isNumber;
  }
}

function preserveAspectRatio(props) {
  let result = "";
  switch (props.hAlign) {
    case "left":
      result += "xMin";
      break;
    case "right":
      result += "xMax";
      break;
    default:
      result += "xMid";
  }
  switch (props.vAlign) {
    case "top":
      result += "YMin";
      break;
    case "bottom":
      result += "YMax";
      break;
    default:
      result += "YMid";
  }
  result += props.slice ? " slice" : " meet";
  return result;
}
function iconToSVG(icon, customisations) {
  const box = {
    left: icon.left,
    top: icon.top,
    width: icon.width,
    height: icon.height
  };
  let body = icon.body;
  [icon, customisations].forEach((props) => {
    const transformations = [];
    const hFlip = props.hFlip;
    const vFlip = props.vFlip;
    let rotation = props.rotate;
    if (hFlip) {
      if (vFlip) {
        rotation += 2;
      } else {
        transformations.push("translate(" + (box.width + box.left).toString() + " " + (0 - box.top).toString() + ")");
        transformations.push("scale(-1 1)");
        box.top = box.left = 0;
      }
    } else if (vFlip) {
      transformations.push("translate(" + (0 - box.left).toString() + " " + (box.height + box.top).toString() + ")");
      transformations.push("scale(1 -1)");
      box.top = box.left = 0;
    }
    let tempValue;
    if (rotation < 0) {
      rotation -= Math.floor(rotation / 4) * 4;
    }
    rotation = rotation % 4;
    switch (rotation) {
      case 1:
        tempValue = box.height / 2 + box.top;
        transformations.unshift("rotate(90 " + tempValue.toString() + " " + tempValue.toString() + ")");
        break;
      case 2:
        transformations.unshift("rotate(180 " + (box.width / 2 + box.left).toString() + " " + (box.height / 2 + box.top).toString() + ")");
        break;
      case 3:
        tempValue = box.width / 2 + box.left;
        transformations.unshift("rotate(-90 " + tempValue.toString() + " " + tempValue.toString() + ")");
        break;
    }
    if (rotation % 2 === 1) {
      if (box.left !== 0 || box.top !== 0) {
        tempValue = box.left;
        box.left = box.top;
        box.top = tempValue;
      }
      if (box.width !== box.height) {
        tempValue = box.width;
        box.width = box.height;
        box.height = tempValue;
      }
    }
    if (transformations.length) {
      body = '<g transform="' + transformations.join(" ") + '">' + body + "</g>";
    }
  });
  let width, height;
  if (customisations.width === null && customisations.height === null) {
    height = "1em";
    width = calculateSize(height, box.width / box.height);
  } else if (customisations.width !== null && customisations.height !== null) {
    width = customisations.width;
    height = customisations.height;
  } else if (customisations.height !== null) {
    height = customisations.height;
    width = calculateSize(height, box.width / box.height);
  } else {
    width = customisations.width;
    height = calculateSize(width, box.height / box.width);
  }
  if (width === "auto") {
    width = box.width;
  }
  if (height === "auto") {
    height = box.height;
  }
  width = typeof width === "string" ? width : width.toString() + "";
  height = typeof height === "string" ? height : height.toString() + "";
  const result = {
    attributes: {
      width,
      height,
      preserveAspectRatio: preserveAspectRatio(customisations),
      viewBox: box.left.toString() + " " + box.top.toString() + " " + box.width.toString() + " " + box.height.toString()
    },
    body
  };
  if (customisations.inline) {
    result.inline = true;
  }
  return result;
}

function buildIcon(icon, customisations) {
  return iconToSVG(fullIcon(icon), customisations ? mergeCustomisations(defaults, customisations) : defaults);
}

const regex = /\sid="(\S+)"/g;
const randomPrefix = "IconifyId" + Date.now().toString(16) + (Math.random() * 16777216 | 0).toString(16);
let counter = 0;
function replaceIDs(body, prefix = randomPrefix) {
  const ids = [];
  let match;
  while (match = regex.exec(body)) {
    ids.push(match[1]);
  }
  if (!ids.length) {
    return body;
  }
  ids.forEach((id) => {
    const newID = typeof prefix === "function" ? prefix(id) : prefix + (counter++).toString();
    const escapedID = id.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
    body = body.replace(new RegExp('([#;"])(' + escapedID + ')([")]|\\.[a-z])', "g"), "$1" + newID + "$3");
  });
  return body;
}

const storage = /* @__PURE__ */ Object.create(null);
function setAPIModule(provider, item) {
  storage[provider] = item;
}
function getAPIModule(provider) {
  return storage[provider] || storage[""];
}

function createAPIConfig(source) {
  let resources;
  if (typeof source.resources === "string") {
    resources = [source.resources];
  } else {
    resources = source.resources;
    if (!(resources instanceof Array) || !resources.length) {
      return null;
    }
  }
  const result = {
    resources,
    path: source.path === void 0 ? "/" : source.path,
    maxURL: source.maxURL ? source.maxURL : 500,
    rotate: source.rotate ? source.rotate : 750,
    timeout: source.timeout ? source.timeout : 5e3,
    random: source.random === true,
    index: source.index ? source.index : 0,
    dataAfterTimeout: source.dataAfterTimeout !== false
  };
  return result;
}
const configStorage = /* @__PURE__ */ Object.create(null);
const fallBackAPISources = [
  "https://api.simplesvg.com",
  "https://api.unisvg.com"
];
const fallBackAPI = [];
while (fallBackAPISources.length > 0) {
  if (fallBackAPISources.length === 1) {
    fallBackAPI.push(fallBackAPISources.shift());
  } else {
    if (Math.random() > 0.5) {
      fallBackAPI.push(fallBackAPISources.shift());
    } else {
      fallBackAPI.push(fallBackAPISources.pop());
    }
  }
}
configStorage[""] = createAPIConfig({
  resources: ["https://api.iconify.design"].concat(fallBackAPI)
});
function addAPIProvider(provider, customConfig) {
  const config = createAPIConfig(customConfig);
  if (config === null) {
    return false;
  }
  configStorage[provider] = config;
  return true;
}
function getAPIConfig(provider) {
  return configStorage[provider];
}
function listAPIProviders() {
  return Object.keys(configStorage);
}

const mergeParams = (base, params) => {
  let result = base, hasParams = result.indexOf("?") !== -1;
  function paramToString(value) {
    switch (typeof value) {
      case "boolean":
        return value ? "true" : "false";
      case "number":
        return encodeURIComponent(value);
      case "string":
        return encodeURIComponent(value);
      default:
        throw new Error("Invalid parameter");
    }
  }
  Object.keys(params).forEach((key) => {
    let value;
    try {
      value = paramToString(params[key]);
    } catch (err) {
      return;
    }
    result += (hasParams ? "&" : "?") + encodeURIComponent(key) + "=" + value;
    hasParams = true;
  });
  return result;
};

const maxLengthCache = {};
const pathCache = {};
const detectFetch = () => {
  let callback;
  try {
    callback = fetch;
    if (typeof callback === "function") {
      return callback;
    }
  } catch (err) {
  }
  return null;
};
let fetchModule = detectFetch();
function setFetch(fetch2) {
  fetchModule = fetch2;
}
function getFetch() {
  return fetchModule;
}
function calculateMaxLength(provider, prefix) {
  const config = getAPIConfig(provider);
  if (!config) {
    return 0;
  }
  let result;
  if (!config.maxURL) {
    result = 0;
  } else {
    let maxHostLength = 0;
    config.resources.forEach((item) => {
      const host = item;
      maxHostLength = Math.max(maxHostLength, host.length);
    });
    const url = mergeParams(prefix + ".json", {
      icons: ""
    });
    result = config.maxURL - maxHostLength - config.path.length - url.length;
  }
  const cacheKey = provider + ":" + prefix;
  pathCache[provider] = config.path;
  maxLengthCache[cacheKey] = result;
  return result;
}
function shouldAbort(status) {
  return status === 404;
}
const prepare = (provider, prefix, icons) => {
  const results = [];
  let maxLength = maxLengthCache[prefix];
  if (maxLength === void 0) {
    maxLength = calculateMaxLength(provider, prefix);
  }
  const type = "icons";
  let item = {
    type,
    provider,
    prefix,
    icons: []
  };
  let length = 0;
  icons.forEach((name, index) => {
    length += name.length + 1;
    if (length >= maxLength && index > 0) {
      results.push(item);
      item = {
        type,
        provider,
        prefix,
        icons: []
      };
      length = name.length;
    }
    item.icons.push(name);
  });
  results.push(item);
  return results;
};
function getPath(provider) {
  if (typeof provider === "string") {
    if (pathCache[provider] === void 0) {
      const config = getAPIConfig(provider);
      if (!config) {
        return "/";
      }
      pathCache[provider] = config.path;
    }
    return pathCache[provider];
  }
  return "/";
}
const send = (host, params, callback) => {
  if (!fetchModule) {
    callback("abort", 424);
    return;
  }
  let path = getPath(params.provider);
  switch (params.type) {
    case "icons": {
      const prefix = params.prefix;
      const icons = params.icons;
      const iconsList = icons.join(",");
      path += mergeParams(prefix + ".json", {
        icons: iconsList
      });
      break;
    }
    case "custom": {
      const uri = params.uri;
      path += uri.slice(0, 1) === "/" ? uri.slice(1) : uri;
      break;
    }
    default:
      callback("abort", 400);
      return;
  }
  let defaultError = 503;
  fetchModule(host + path).then((response) => {
    const status = response.status;
    if (status !== 200) {
      setTimeout(() => {
        callback(shouldAbort(status) ? "abort" : "next", status);
      });
      return;
    }
    defaultError = 501;
    return response.json();
  }).then((data) => {
    if (typeof data !== "object" || data === null) {
      setTimeout(() => {
        callback("next", defaultError);
      });
      return;
    }
    setTimeout(() => {
      callback("success", data);
    });
  }).catch(() => {
    callback("next", defaultError);
  });
};
const fetchAPIModule = {
  prepare,
  send
};

function sortIcons(icons) {
  const result = {
    loaded: [],
    missing: [],
    pending: []
  };
  const storage = /* @__PURE__ */ Object.create(null);
  icons.sort((a, b) => {
    if (a.provider !== b.provider) {
      return a.provider.localeCompare(b.provider);
    }
    if (a.prefix !== b.prefix) {
      return a.prefix.localeCompare(b.prefix);
    }
    return a.name.localeCompare(b.name);
  });
  let lastIcon = {
    provider: "",
    prefix: "",
    name: ""
  };
  icons.forEach((icon) => {
    if (lastIcon.name === icon.name && lastIcon.prefix === icon.prefix && lastIcon.provider === icon.provider) {
      return;
    }
    lastIcon = icon;
    const provider = icon.provider;
    const prefix = icon.prefix;
    const name = icon.name;
    if (storage[provider] === void 0) {
      storage[provider] = /* @__PURE__ */ Object.create(null);
    }
    const providerStorage = storage[provider];
    if (providerStorage[prefix] === void 0) {
      providerStorage[prefix] = getStorage(provider, prefix);
    }
    const localStorage = providerStorage[prefix];
    let list;
    if (localStorage.icons[name] !== void 0) {
      list = result.loaded;
    } else if (prefix === "" || localStorage.missing[name] !== void 0) {
      list = result.missing;
    } else {
      list = result.pending;
    }
    const item = {
      provider,
      prefix,
      name
    };
    list.push(item);
  });
  return result;
}

const callbacks = /* @__PURE__ */ Object.create(null);
const pendingUpdates = /* @__PURE__ */ Object.create(null);
function removeCallback(sources, id) {
  sources.forEach((source) => {
    const provider = source.provider;
    if (callbacks[provider] === void 0) {
      return;
    }
    const providerCallbacks = callbacks[provider];
    const prefix = source.prefix;
    const items = providerCallbacks[prefix];
    if (items) {
      providerCallbacks[prefix] = items.filter((row) => row.id !== id);
    }
  });
}
function updateCallbacks(provider, prefix) {
  if (pendingUpdates[provider] === void 0) {
    pendingUpdates[provider] = /* @__PURE__ */ Object.create(null);
  }
  const providerPendingUpdates = pendingUpdates[provider];
  if (!providerPendingUpdates[prefix]) {
    providerPendingUpdates[prefix] = true;
    setTimeout(() => {
      providerPendingUpdates[prefix] = false;
      if (callbacks[provider] === void 0 || callbacks[provider][prefix] === void 0) {
        return;
      }
      const items = callbacks[provider][prefix].slice(0);
      if (!items.length) {
        return;
      }
      const storage = getStorage(provider, prefix);
      let hasPending = false;
      items.forEach((item) => {
        const icons = item.icons;
        const oldLength = icons.pending.length;
        icons.pending = icons.pending.filter((icon) => {
          if (icon.prefix !== prefix) {
            return true;
          }
          const name = icon.name;
          if (storage.icons[name] !== void 0) {
            icons.loaded.push({
              provider,
              prefix,
              name
            });
          } else if (storage.missing[name] !== void 0) {
            icons.missing.push({
              provider,
              prefix,
              name
            });
          } else {
            hasPending = true;
            return true;
          }
          return false;
        });
        if (icons.pending.length !== oldLength) {
          if (!hasPending) {
            removeCallback([
              {
                provider,
                prefix
              }
            ], item.id);
          }
          item.callback(icons.loaded.slice(0), icons.missing.slice(0), icons.pending.slice(0), item.abort);
        }
      });
    });
  }
}
let idCounter = 0;
function storeCallback(callback, icons, pendingSources) {
  const id = idCounter++;
  const abort = removeCallback.bind(null, pendingSources, id);
  if (!icons.pending.length) {
    return abort;
  }
  const item = {
    id,
    icons,
    callback,
    abort
  };
  pendingSources.forEach((source) => {
    const provider = source.provider;
    const prefix = source.prefix;
    if (callbacks[provider] === void 0) {
      callbacks[provider] = /* @__PURE__ */ Object.create(null);
    }
    const providerCallbacks = callbacks[provider];
    if (providerCallbacks[prefix] === void 0) {
      providerCallbacks[prefix] = [];
    }
    providerCallbacks[prefix].push(item);
  });
  return abort;
}

function listToIcons(list, validate = true, simpleNames = false) {
  const result = [];
  list.forEach((item) => {
    const icon = typeof item === "string" ? stringToIcon(item, false, simpleNames) : item;
    if (!validate || validateIcon(icon, simpleNames)) {
      result.push({
        provider: icon.provider,
        prefix: icon.prefix,
        name: icon.name
      });
    }
  });
  return result;
}

// src/config.ts
var defaultConfig = {
  resources: [],
  index: 0,
  timeout: 2e3,
  rotate: 750,
  random: false,
  dataAfterTimeout: false
};

// src/query.ts
function sendQuery(config, payload, query, done) {
  const resourcesCount = config.resources.length;
  const startIndex = config.random ? Math.floor(Math.random() * resourcesCount) : config.index;
  let resources;
  if (config.random) {
    let list = config.resources.slice(0);
    resources = [];
    while (list.length > 1) {
      const nextIndex = Math.floor(Math.random() * list.length);
      resources.push(list[nextIndex]);
      list = list.slice(0, nextIndex).concat(list.slice(nextIndex + 1));
    }
    resources = resources.concat(list);
  } else {
    resources = config.resources.slice(startIndex).concat(config.resources.slice(0, startIndex));
  }
  const startTime = Date.now();
  let status = "pending";
  let queriesSent = 0;
  let lastError;
  let timer = null;
  let queue = [];
  let doneCallbacks = [];
  if (typeof done === "function") {
    doneCallbacks.push(done);
  }
  function resetTimer() {
    if (timer) {
      clearTimeout(timer);
      timer = null;
    }
  }
  function abort() {
    if (status === "pending") {
      status = "aborted";
    }
    resetTimer();
    queue.forEach((item) => {
      if (item.status === "pending") {
        item.status = "aborted";
      }
    });
    queue = [];
  }
  function subscribe(callback, overwrite) {
    if (overwrite) {
      doneCallbacks = [];
    }
    if (typeof callback === "function") {
      doneCallbacks.push(callback);
    }
  }
  function getQueryStatus() {
    return {
      startTime,
      payload,
      status,
      queriesSent,
      queriesPending: queue.length,
      subscribe,
      abort
    };
  }
  function failQuery() {
    status = "failed";
    doneCallbacks.forEach((callback) => {
      callback(void 0, lastError);
    });
  }
  function clearQueue() {
    queue.forEach((item) => {
      if (item.status === "pending") {
        item.status = "aborted";
      }
    });
    queue = [];
  }
  function moduleResponse(item, response, data) {
    const isError = response !== "success";
    queue = queue.filter((queued) => queued !== item);
    switch (status) {
      case "pending":
        break;
      case "failed":
        if (isError || !config.dataAfterTimeout) {
          return;
        }
        break;
      default:
        return;
    }
    if (response === "abort") {
      lastError = data;
      failQuery();
      return;
    }
    if (isError) {
      lastError = data;
      if (!queue.length) {
        if (!resources.length) {
          failQuery();
        } else {
          execNext();
        }
      }
      return;
    }
    resetTimer();
    clearQueue();
    if (!config.random) {
      const index = config.resources.indexOf(item.resource);
      if (index !== -1 && index !== config.index) {
        config.index = index;
      }
    }
    status = "completed";
    doneCallbacks.forEach((callback) => {
      callback(data);
    });
  }
  function execNext() {
    if (status !== "pending") {
      return;
    }
    resetTimer();
    const resource = resources.shift();
    if (resource === void 0) {
      if (queue.length) {
        timer = setTimeout(() => {
          resetTimer();
          if (status === "pending") {
            clearQueue();
            failQuery();
          }
        }, config.timeout);
        return;
      }
      failQuery();
      return;
    }
    const item = {
      status: "pending",
      resource,
      callback: (status2, data) => {
        moduleResponse(item, status2, data);
      }
    };
    queue.push(item);
    queriesSent++;
    timer = setTimeout(execNext, config.rotate);
    query(resource, payload, item.callback);
  }
  setTimeout(execNext);
  return getQueryStatus;
}

// src/index.ts
function setConfig(config) {
  if (typeof config !== "object" || typeof config.resources !== "object" || !(config.resources instanceof Array) || !config.resources.length) {
    throw new Error("Invalid Reduncancy configuration");
  }
  const newConfig = /* @__PURE__ */ Object.create(null);
  let key;
  for (key in defaultConfig) {
    if (config[key] !== void 0) {
      newConfig[key] = config[key];
    } else {
      newConfig[key] = defaultConfig[key];
    }
  }
  return newConfig;
}
function initRedundancy(cfg) {
  const config = setConfig(cfg);
  let queries = [];
  function cleanup() {
    queries = queries.filter((item) => item().status === "pending");
  }
  function query(payload, queryCallback, doneCallback) {
    const query2 = sendQuery(config, payload, queryCallback, (data, error) => {
      cleanup();
      if (doneCallback) {
        doneCallback(data, error);
      }
    });
    queries.push(query2);
    return query2;
  }
  function find(callback) {
    const result = queries.find((value) => {
      return callback(value);
    });
    return result !== void 0 ? result : null;
  }
  const instance = {
    query,
    find,
    setIndex: (index) => {
      config.index = index;
    },
    getIndex: () => config.index,
    cleanup
  };
  return instance;
}

function emptyCallback$1() {
}
const redundancyCache = /* @__PURE__ */ Object.create(null);
function getRedundancyCache(provider) {
  if (redundancyCache[provider] === void 0) {
    const config = getAPIConfig(provider);
    if (!config) {
      return;
    }
    const redundancy = initRedundancy(config);
    const cachedReundancy = {
      config,
      redundancy
    };
    redundancyCache[provider] = cachedReundancy;
  }
  return redundancyCache[provider];
}
function sendAPIQuery(target, query, callback) {
  let redundancy;
  let send;
  if (typeof target === "string") {
    const api = getAPIModule(target);
    if (!api) {
      callback(void 0, 424);
      return emptyCallback$1;
    }
    send = api.send;
    const cached = getRedundancyCache(target);
    if (cached) {
      redundancy = cached.redundancy;
    }
  } else {
    const config = createAPIConfig(target);
    if (config) {
      redundancy = initRedundancy(config);
      const moduleKey = target.resources ? target.resources[0] : "";
      const api = getAPIModule(moduleKey);
      if (api) {
        send = api.send;
      }
    }
  }
  if (!redundancy || !send) {
    callback(void 0, 424);
    return emptyCallback$1;
  }
  return redundancy.query(query, send, callback)().abort;
}

const cache = {};

function emptyCallback() {
}
const pendingIcons = /* @__PURE__ */ Object.create(null);
const iconsToLoad = /* @__PURE__ */ Object.create(null);
const loaderFlags = /* @__PURE__ */ Object.create(null);
const queueFlags = /* @__PURE__ */ Object.create(null);
function loadedNewIcons(provider, prefix) {
  if (loaderFlags[provider] === void 0) {
    loaderFlags[provider] = /* @__PURE__ */ Object.create(null);
  }
  const providerLoaderFlags = loaderFlags[provider];
  if (!providerLoaderFlags[prefix]) {
    providerLoaderFlags[prefix] = true;
    setTimeout(() => {
      providerLoaderFlags[prefix] = false;
      updateCallbacks(provider, prefix);
    });
  }
}
const errorsCache = /* @__PURE__ */ Object.create(null);
function loadNewIcons(provider, prefix, icons) {
  function err() {
    const key = (provider === "" ? "" : "@" + provider + ":") + prefix;
    const time = Math.floor(Date.now() / 6e4);
    if (errorsCache[key] < time) {
      errorsCache[key] = time;
      console.error('Unable to retrieve icons for "' + key + '" because API is not configured properly.');
    }
  }
  if (iconsToLoad[provider] === void 0) {
    iconsToLoad[provider] = /* @__PURE__ */ Object.create(null);
  }
  const providerIconsToLoad = iconsToLoad[provider];
  if (queueFlags[provider] === void 0) {
    queueFlags[provider] = /* @__PURE__ */ Object.create(null);
  }
  const providerQueueFlags = queueFlags[provider];
  if (pendingIcons[provider] === void 0) {
    pendingIcons[provider] = /* @__PURE__ */ Object.create(null);
  }
  const providerPendingIcons = pendingIcons[provider];
  if (providerIconsToLoad[prefix] === void 0) {
    providerIconsToLoad[prefix] = icons;
  } else {
    providerIconsToLoad[prefix] = providerIconsToLoad[prefix].concat(icons).sort();
  }
  if (!providerQueueFlags[prefix]) {
    providerQueueFlags[prefix] = true;
    setTimeout(() => {
      providerQueueFlags[prefix] = false;
      const icons2 = providerIconsToLoad[prefix];
      delete providerIconsToLoad[prefix];
      const api = getAPIModule(provider);
      if (!api) {
        err();
        return;
      }
      const params = api.prepare(provider, prefix, icons2);
      params.forEach((item) => {
        sendAPIQuery(provider, item, (data, error) => {
          const storage = getStorage(provider, prefix);
          if (typeof data !== "object") {
            if (error !== 404) {
              return;
            }
            const t = Date.now();
            item.icons.forEach((name) => {
              storage.missing[name] = t;
            });
          } else {
            try {
              const parsed = addIconSet(storage, data);
              if (!parsed.length) {
                return;
              }
              const pending = providerPendingIcons[prefix];
              parsed.forEach((name) => {
                delete pending[name];
              });
              if (cache.store) {
                cache.store(provider, data);
              }
            } catch (err2) {
              console.error(err2);
            }
          }
          loadedNewIcons(provider, prefix);
        });
      });
    });
  }
}
const loadIcons = (icons, callback) => {
  const cleanedIcons = listToIcons(icons, true, allowSimpleNames());
  const sortedIcons = sortIcons(cleanedIcons);
  if (!sortedIcons.pending.length) {
    let callCallback = true;
    if (callback) {
      setTimeout(() => {
        if (callCallback) {
          callback(sortedIcons.loaded, sortedIcons.missing, sortedIcons.pending, emptyCallback);
        }
      });
    }
    return () => {
      callCallback = false;
    };
  }
  const newIcons = /* @__PURE__ */ Object.create(null);
  const sources = [];
  let lastProvider, lastPrefix;
  sortedIcons.pending.forEach((icon) => {
    const provider = icon.provider;
    const prefix = icon.prefix;
    if (prefix === lastPrefix && provider === lastProvider) {
      return;
    }
    lastProvider = provider;
    lastPrefix = prefix;
    sources.push({
      provider,
      prefix
    });
    if (pendingIcons[provider] === void 0) {
      pendingIcons[provider] = /* @__PURE__ */ Object.create(null);
    }
    const providerPendingIcons = pendingIcons[provider];
    if (providerPendingIcons[prefix] === void 0) {
      providerPendingIcons[prefix] = /* @__PURE__ */ Object.create(null);
    }
    if (newIcons[provider] === void 0) {
      newIcons[provider] = /* @__PURE__ */ Object.create(null);
    }
    const providerNewIcons = newIcons[provider];
    if (providerNewIcons[prefix] === void 0) {
      providerNewIcons[prefix] = [];
    }
  });
  const time = Date.now();
  sortedIcons.pending.forEach((icon) => {
    const provider = icon.provider;
    const prefix = icon.prefix;
    const name = icon.name;
    const pendingQueue = pendingIcons[provider][prefix];
    if (pendingQueue[name] === void 0) {
      pendingQueue[name] = time;
      newIcons[provider][prefix].push(name);
    }
  });
  sources.forEach((source) => {
    const provider = source.provider;
    const prefix = source.prefix;
    if (newIcons[provider][prefix].length) {
      loadNewIcons(provider, prefix, newIcons[provider][prefix]);
    }
  });
  return callback ? storeCallback(callback, sortedIcons, sources) : emptyCallback;
};
const loadIcon = (icon) => {
  return new Promise((fulfill, reject) => {
    const iconObj = typeof icon === "string" ? stringToIcon(icon) : icon;
    loadIcons([iconObj || icon], (loaded) => {
      if (loaded.length && iconObj) {
        const storage = getStorage(iconObj.provider, iconObj.prefix);
        const data = getIconFromStorage(storage, iconObj.name);
        if (data) {
          fulfill(data);
          return;
        }
      }
      reject(icon);
    });
  });
};

const cacheVersion = "iconify2";
const cachePrefix = "iconify";
const countKey = cachePrefix + "-count";
const versionKey = cachePrefix + "-version";
const hour = 36e5;
const cacheExpiration = 168;
const config = {
  local: true,
  session: true
};
let loaded = false;
const count = {
  local: 0,
  session: 0
};
const emptyList = {
  local: [],
  session: []
};
let _window = typeof window === "undefined" ? {} : window;
function getGlobal(key) {
  const attr = key + "Storage";
  try {
    if (_window && _window[attr] && typeof _window[attr].length === "number") {
      return _window[attr];
    }
  } catch (err) {
  }
  config[key] = false;
  return null;
}
function setCount(storage, key, value) {
  try {
    storage.setItem(countKey, value.toString());
    count[key] = value;
    return true;
  } catch (err) {
    return false;
  }
}
function getCount(storage) {
  const count2 = storage.getItem(countKey);
  if (count2) {
    const total = parseInt(count2);
    return total ? total : 0;
  }
  return 0;
}
function initCache(storage, key) {
  try {
    storage.setItem(versionKey, cacheVersion);
  } catch (err) {
  }
  setCount(storage, key, 0);
}
function destroyCache(storage) {
  try {
    const total = getCount(storage);
    for (let i = 0; i < total; i++) {
      storage.removeItem(cachePrefix + i.toString());
    }
  } catch (err) {
  }
}
const loadCache = () => {
  if (loaded) {
    return;
  }
  loaded = true;
  const minTime = Math.floor(Date.now() / hour) - cacheExpiration;
  function load(key) {
    const func = getGlobal(key);
    if (!func) {
      return;
    }
    const getItem = (index) => {
      const name = cachePrefix + index.toString();
      const item = func.getItem(name);
      if (typeof item !== "string") {
        return false;
      }
      let valid = true;
      try {
        const data = JSON.parse(item);
        if (typeof data !== "object" || typeof data.cached !== "number" || data.cached < minTime || typeof data.provider !== "string" || typeof data.data !== "object" || typeof data.data.prefix !== "string") {
          valid = false;
        } else {
          const provider = data.provider;
          const prefix = data.data.prefix;
          const storage = getStorage(provider, prefix);
          valid = addIconSet(storage, data.data).length > 0;
        }
      } catch (err) {
        valid = false;
      }
      if (!valid) {
        func.removeItem(name);
      }
      return valid;
    };
    try {
      const version = func.getItem(versionKey);
      if (version !== cacheVersion) {
        if (version) {
          destroyCache(func);
        }
        initCache(func, key);
        return;
      }
      let total = getCount(func);
      for (let i = total - 1; i >= 0; i--) {
        if (!getItem(i)) {
          if (i === total - 1) {
            total--;
          } else {
            emptyList[key].push(i);
          }
        }
      }
      setCount(func, key, total);
    } catch (err) {
    }
  }
  for (const key in config) {
    load(key);
  }
};
const storeCache = (provider, data) => {
  if (!loaded) {
    loadCache();
  }
  function store(key) {
    if (!config[key]) {
      return false;
    }
    const func = getGlobal(key);
    if (!func) {
      return false;
    }
    let index = emptyList[key].shift();
    if (index === void 0) {
      index = count[key];
      if (!setCount(func, key, index + 1)) {
        return false;
      }
    }
    try {
      const item = {
        cached: Math.floor(Date.now() / hour),
        provider,
        data
      };
      func.setItem(cachePrefix + index.toString(), JSON.stringify(item));
    } catch (err) {
      return false;
    }
    return true;
  }
  if (!Object.keys(data.icons).length) {
    return;
  }
  if (data.not_found) {
    data = Object.assign({}, data);
    delete data.not_found;
  }
  if (!store("local")) {
    store("session");
  }
};

function toggleBrowserCache(storage, value) {
  switch (storage) {
    case "local":
    case "session":
      config[storage] = value;
      break;
    case "all":
      for (const key in config) {
        config[key] = value;
      }
      break;
  }
}

const separator = /[\s,]+/;
function flipFromString(custom, flip) {
  flip.split(separator).forEach((str) => {
    const value = str.trim();
    switch (value) {
      case "horizontal":
        custom.hFlip = true;
        break;
      case "vertical":
        custom.vFlip = true;
        break;
    }
  });
}
function alignmentFromString(custom, align) {
  align.split(separator).forEach((str) => {
    const value = str.trim();
    switch (value) {
      case "left":
      case "center":
      case "right":
        custom.hAlign = value;
        break;
      case "top":
      case "middle":
      case "bottom":
        custom.vAlign = value;
        break;
      case "slice":
      case "crop":
        custom.slice = true;
        break;
      case "meet":
        custom.slice = false;
    }
  });
}

function rotateFromString(value, defaultValue = 0) {
  const units = value.replace(/^-?[0-9.]*/, "");
  function cleanup(value2) {
    while (value2 < 0) {
      value2 += 4;
    }
    return value2 % 4;
  }
  if (units === "") {
    const num = parseInt(value);
    return isNaN(num) ? 0 : cleanup(num);
  } else if (units !== value) {
    let split = 0;
    switch (units) {
      case "%":
        split = 25;
        break;
      case "deg":
        split = 90;
    }
    if (split) {
      let num = parseFloat(value.slice(0, value.length - units.length));
      if (isNaN(num)) {
        return 0;
      }
      num = num / split;
      return num % 1 === 0 ? cleanup(num) : 0;
    }
  }
  return defaultValue;
}

/**
 * Default SVG attributes
 */
const svgDefaults = {
    'xmlns': 'http://www.w3.org/2000/svg',
    'xmlns:xlink': 'http://www.w3.org/1999/xlink',
    'aria-hidden': true,
    'role': 'img',
};
/**
 * Aliases for customisations.
 * In Vue 'v-' properties are reserved, so v-align and v-flip must be renamed
 */
let customisationAliases = {};
['horizontal', 'vertical'].forEach((prefix) => {
    ['Align', 'Flip'].forEach((suffix) => {
        const attr = prefix.slice(0, 1) + suffix;
        const value = {
            attr,
            boolean: suffix === 'Flip',
        };
        // vertical-align
        customisationAliases[prefix + '-' + suffix.toLowerCase()] = value;
        // v-align
        customisationAliases[prefix.slice(0, 1) + '-' + suffix.toLowerCase()] =
            value;
        // verticalAlign
        customisationAliases[prefix + suffix] = value;
    });
});
/**
 * Render icon
 */
const render = (
// Icon must be validated before calling this function
icon, 
// Partial properties
props) => {
    // Split properties
    const customisations = mergeCustomisations(defaults, props);
    const componentProps = { ...svgDefaults };
    // Copy style
    let style = typeof props.style === 'object' && !(props.style instanceof Array)
        ? { ...props.style }
        : {};
    // Get element properties
    for (let key in props) {
        const value = props[key];
        if (value === void 0) {
            continue;
        }
        switch (key) {
            // Properties to ignore
            case 'icon':
            case 'style':
            case 'onLoad':
                break;
            // Boolean attributes
            case 'inline':
            case 'hFlip':
            case 'vFlip':
                customisations[key] =
                    value === true || value === 'true' || value === 1;
                break;
            // Flip as string: 'horizontal,vertical'
            case 'flip':
                if (typeof value === 'string') {
                    flipFromString(customisations, value);
                }
                break;
            // Alignment as string
            case 'align':
                if (typeof value === 'string') {
                    alignmentFromString(customisations, value);
                }
                break;
            // Color: override style
            case 'color':
                style.color = value;
                break;
            // Rotation as string
            case 'rotate':
                if (typeof value === 'string') {
                    customisations[key] = rotateFromString(value);
                }
                else if (typeof value === 'number') {
                    customisations[key] = value;
                }
                break;
            // Remove aria-hidden
            case 'ariaHidden':
            case 'aria-hidden':
                // Vue transforms 'aria-hidden' property to 'ariaHidden'
                if (value !== true && value !== 'true') {
                    delete componentProps['aria-hidden'];
                }
                break;
            default:
                if (customisationAliases[key] !== void 0) {
                    // Aliases for customisations
                    if (customisationAliases[key].boolean &&
                        (value === true || value === 'true' || value === 1)) {
                        // Check for boolean
                        customisations[customisationAliases[key].attr] = true;
                    }
                    else if (!customisationAliases[key].boolean &&
                        typeof value === 'string' &&
                        value !== '') {
                        // String
                        customisations[customisationAliases[key].attr] = value;
                    }
                }
                else if (defaults[key] === void 0) {
                    // Copy missing property if it does not exist in customisations
                    componentProps[key] = value;
                }
        }
    }
    // Generate icon
    const item = iconToSVG(icon, customisations);
    // Add icon stuff
    for (let key in item.attributes) {
        componentProps[key] = item.attributes[key];
    }
    if (item.inline &&
        style.verticalAlign === void 0 &&
        style['vertical-align'] === void 0) {
        style.verticalAlign = '-0.125em';
    }
    // Counter for ids based on "id" property to render icons consistently on server and client
    let localCounter = 0;
    let id = props.id;
    if (typeof id === 'string') {
        // Convert '-' to '_' to avoid errors in animations
        id = id.replace(/-/g, '_');
    }
    // Add innerHTML and style to props
    componentProps['innerHTML'] = replaceIDs(item.body, id ? () => id + 'ID' + localCounter++ : 'iconifyVue');
    if (Object.keys(style).length > 0) {
        componentProps['style'] = style;
    }
    // Render icon
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('svg', componentProps);
};

/**
 * Enable cache
 */
function enableCache(storage) {
    toggleBrowserCache(storage, true);
}
/**
 * Disable cache
 */
function disableCache(storage) {
    toggleBrowserCache(storage, false);
}
/**
 * Initialise stuff
 */
// Enable short names
allowSimpleNames(true);
// Set API module
setAPIModule('', fetchAPIModule);
/**
 * Browser stuff
 */
if (typeof document !== 'undefined' && typeof window !== 'undefined') {
    // Set cache and load existing cache
    cache.store = storeCache;
    loadCache();
    const _window = window;
    // Load icons from global "IconifyPreload"
    if (_window.IconifyPreload !== void 0) {
        const preload = _window.IconifyPreload;
        const err = 'Invalid IconifyPreload syntax.';
        if (typeof preload === 'object' && preload !== null) {
            (preload instanceof Array ? preload : [preload]).forEach((item) => {
                try {
                    if (
                    // Check if item is an object and not null/array
                    typeof item !== 'object' ||
                        item === null ||
                        item instanceof Array ||
                        // Check for 'icons' and 'prefix'
                        typeof item.icons !== 'object' ||
                        typeof item.prefix !== 'string' ||
                        // Add icon set
                        !addCollection(item)) {
                        console.error(err);
                    }
                }
                catch (e) {
                    console.error(err);
                }
            });
        }
    }
    // Set API from global "IconifyProviders"
    if (_window.IconifyProviders !== void 0) {
        const providers = _window.IconifyProviders;
        if (typeof providers === 'object' && providers !== null) {
            for (let key in providers) {
                const err = 'IconifyProviders[' + key + '] is invalid.';
                try {
                    const value = providers[key];
                    if (typeof value !== 'object' ||
                        !value ||
                        value.resources === void 0) {
                        continue;
                    }
                    if (!addAPIProvider(key, value)) {
                        console.error(err);
                    }
                }
                catch (e) {
                    console.error(err);
                }
            }
        }
    }
}
/**
 * Empty icon data, rendered when icon is not available
 */
const emptyIcon = fullIcon({
    body: '',
});
const Icon = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    // Do not inherit other attributes: it is handled by render()
    inheritAttrs: false,
    // Set initial data
    data() {
        return {
            // Mounted status
            iconMounted: false,
            // Callback counter to trigger re-render
            counter: 0,
        };
    },
    mounted() {
        // Current icon name
        this._name = '';
        // Loading
        this._loadingIcon = null;
        // Mark as mounted
        this.iconMounted = true;
    },
    unmounted() {
        this.abortLoading();
    },
    methods: {
        abortLoading() {
            if (this._loadingIcon) {
                this._loadingIcon.abort();
                this._loadingIcon = null;
            }
        },
        // Get data for icon to render or null
        getIcon(icon, onload) {
            // Icon is an object
            if (typeof icon === 'object' &&
                icon !== null &&
                typeof icon.body === 'string') {
                // Stop loading
                this._name = '';
                this.abortLoading();
                return {
                    data: fullIcon(icon),
                };
            }
            // Invalid icon?
            let iconName;
            if (typeof icon !== 'string' ||
                (iconName = stringToIcon(icon, false, true)) === null) {
                this.abortLoading();
                return null;
            }
            // Load icon
            const data = getIconData(iconName);
            if (data === null) {
                // Icon needs to be loaded
                if (!this._loadingIcon || this._loadingIcon.name !== icon) {
                    // New icon to load
                    this.abortLoading();
                    this._name = '';
                    this._loadingIcon = {
                        name: icon,
                        abort: loadIcons([iconName], () => {
                            this.counter++;
                        }),
                    };
                }
                return null;
            }
            // Icon data is available
            this.abortLoading();
            if (this._name !== icon) {
                this._name = icon;
                if (onload) {
                    onload(icon);
                }
            }
            // Add classes
            const classes = ['iconify'];
            if (iconName.prefix !== '') {
                classes.push('iconify--' + iconName.prefix);
            }
            if (iconName.provider !== '') {
                classes.push('iconify--' + iconName.provider);
            }
            return { data, classes };
        },
    },
    // Render icon
    render() {
        // Re-render when counter changes
        this.counter;
        const props = this.$attrs;
        // Get icon data
        const icon = this.iconMounted
            ? this.getIcon(props.icon, props.onLoad)
            : null;
        // Validate icon object
        if (!icon) {
            return render(emptyIcon, props);
        }
        // Add classes
        let newProps = props;
        if (icon.classes) {
            newProps = {
                ...props,
                class: (typeof props['class'] === 'string'
                    ? props['class'] + ' '
                    : '') + icon.classes.join(' '),
            };
        }
        // Render icon
        return render(icon.data, newProps);
    },
});
/**
 * Internal API
 */
const _api = {
    getAPIConfig,
    setAPIModule,
    sendAPIQuery,
    setFetch,
    getFetch,
    listAPIProviders,
    mergeParams,
};




/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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