"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es__internal_icon_src_Icon_js-node_modules_naive-ui_es__interna-761e18"],{

/***/ "./node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DOMRectReadOnly: () => (/* binding */ DOMRectReadOnly)
/* harmony export */ });
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");

var DOMRectReadOnly = (function () {
    function DOMRectReadOnly(x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.top = this.y;
        this.left = this.x;
        this.bottom = this.top + this.height;
        this.right = this.left + this.width;
        return (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_0__.freeze)(this);
    }
    DOMRectReadOnly.prototype.toJSON = function () {
        var _a = this, x = _a.x, y = _a.y, top = _a.top, right = _a.right, bottom = _a.bottom, left = _a.left, width = _a.width, height = _a.height;
        return { x: x, y: y, top: top, right: right, bottom: bottom, left: left, width: width, height: height };
    };
    DOMRectReadOnly.fromRect = function (rectangle) {
        return new DOMRectReadOnly(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    };
    return DOMRectReadOnly;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObservation.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObservation.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObservation: () => (/* binding */ ResizeObservation)
/* harmony export */ });
/* harmony import */ var _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ResizeObserverBoxOptions */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js");
/* harmony import */ var _algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./algorithms/calculateBoxSize */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js");
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");



var skipNotifyOnElement = function (target) {
    return !(0,_utils_element__WEBPACK_IMPORTED_MODULE_2__.isSVG)(target)
        && !(0,_utils_element__WEBPACK_IMPORTED_MODULE_2__.isReplacedElement)(target)
        && getComputedStyle(target).display === 'inline';
};
var ResizeObservation = (function () {
    function ResizeObservation(target, observedBox) {
        this.target = target;
        this.observedBox = observedBox || _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverBoxOptions.CONTENT_BOX;
        this.lastReportedSize = {
            inlineSize: 0,
            blockSize: 0
        };
    }
    ResizeObservation.prototype.isActive = function () {
        var size = (0,_algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_1__.calculateBoxSize)(this.target, this.observedBox, true);
        if (skipNotifyOnElement(this.target)) {
            this.lastReportedSize = size;
        }
        if (this.lastReportedSize.inlineSize !== size.inlineSize
            || this.lastReportedSize.blockSize !== size.blockSize) {
            return true;
        }
        return false;
    };
    return ResizeObservation;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserver.js":
/*!********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserver.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserver: () => (/* binding */ ResizeObserver)
/* harmony export */ });
/* harmony import */ var _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ResizeObserverController */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverController.js");
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");


var ResizeObserver = (function () {
    function ResizeObserver(callback) {
        if (arguments.length === 0) {
            throw new TypeError("Failed to construct 'ResizeObserver': 1 argument required, but only 0 present.");
        }
        if (typeof callback !== 'function') {
            throw new TypeError("Failed to construct 'ResizeObserver': The callback provided as parameter 1 is not a function.");
        }
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.connect(this, callback);
    }
    ResizeObserver.prototype.observe = function (target, options) {
        if (arguments.length === 0) {
            throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': 1 argument required, but only 0 present.");
        }
        if (!(0,_utils_element__WEBPACK_IMPORTED_MODULE_1__.isElement)(target)) {
            throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': parameter 1 is not of type 'Element");
        }
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.observe(this, target, options);
    };
    ResizeObserver.prototype.unobserve = function (target) {
        if (arguments.length === 0) {
            throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': 1 argument required, but only 0 present.");
        }
        if (!(0,_utils_element__WEBPACK_IMPORTED_MODULE_1__.isElement)(target)) {
            throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': parameter 1 is not of type 'Element");
        }
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.unobserve(this, target);
    };
    ResizeObserver.prototype.disconnect = function () {
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.disconnect(this);
    };
    ResizeObserver.toString = function () {
        return 'function ResizeObserver () { [polyfill code] }';
    };
    return ResizeObserver;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverBoxOptions: () => (/* binding */ ResizeObserverBoxOptions)
/* harmony export */ });
var ResizeObserverBoxOptions;
(function (ResizeObserverBoxOptions) {
    ResizeObserverBoxOptions["BORDER_BOX"] = "border-box";
    ResizeObserverBoxOptions["CONTENT_BOX"] = "content-box";
    ResizeObserverBoxOptions["DEVICE_PIXEL_CONTENT_BOX"] = "device-pixel-content-box";
})(ResizeObserverBoxOptions || (ResizeObserverBoxOptions = {}));



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverController.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverController.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverController: () => (/* binding */ ResizeObserverController)
/* harmony export */ });
/* harmony import */ var _utils_scheduler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/scheduler */ "./node_modules/@juggle/resize-observer/lib/utils/scheduler.js");
/* harmony import */ var _ResizeObservation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ResizeObservation */ "./node_modules/@juggle/resize-observer/lib/ResizeObservation.js");
/* harmony import */ var _ResizeObserverDetail__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ResizeObserverDetail */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js");
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");




var observerMap = new WeakMap();
var getObservationIndex = function (observationTargets, target) {
    for (var i = 0; i < observationTargets.length; i += 1) {
        if (observationTargets[i].target === target) {
            return i;
        }
    }
    return -1;
};
var ResizeObserverController = (function () {
    function ResizeObserverController() {
    }
    ResizeObserverController.connect = function (resizeObserver, callback) {
        var detail = new _ResizeObserverDetail__WEBPACK_IMPORTED_MODULE_2__.ResizeObserverDetail(resizeObserver, callback);
        observerMap.set(resizeObserver, detail);
    };
    ResizeObserverController.observe = function (resizeObserver, target, options) {
        var detail = observerMap.get(resizeObserver);
        var firstObservation = detail.observationTargets.length === 0;
        if (getObservationIndex(detail.observationTargets, target) < 0) {
            firstObservation && _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__.resizeObservers.push(detail);
            detail.observationTargets.push(new _ResizeObservation__WEBPACK_IMPORTED_MODULE_1__.ResizeObservation(target, options && options.box));
            (0,_utils_scheduler__WEBPACK_IMPORTED_MODULE_0__.updateCount)(1);
            _utils_scheduler__WEBPACK_IMPORTED_MODULE_0__.scheduler.schedule();
        }
    };
    ResizeObserverController.unobserve = function (resizeObserver, target) {
        var detail = observerMap.get(resizeObserver);
        var index = getObservationIndex(detail.observationTargets, target);
        var lastObservation = detail.observationTargets.length === 1;
        if (index >= 0) {
            lastObservation && _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__.resizeObservers.splice(_utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__.resizeObservers.indexOf(detail), 1);
            detail.observationTargets.splice(index, 1);
            (0,_utils_scheduler__WEBPACK_IMPORTED_MODULE_0__.updateCount)(-1);
        }
    };
    ResizeObserverController.disconnect = function (resizeObserver) {
        var _this = this;
        var detail = observerMap.get(resizeObserver);
        detail.observationTargets.slice().forEach(function (ot) { return _this.unobserve(resizeObserver, ot.target); });
        detail.activeTargets.splice(0, detail.activeTargets.length);
    };
    return ResizeObserverController;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverDetail: () => (/* binding */ ResizeObserverDetail)
/* harmony export */ });
var ResizeObserverDetail = (function () {
    function ResizeObserverDetail(resizeObserver, callback) {
        this.activeTargets = [];
        this.skippedTargets = [];
        this.observationTargets = [];
        this.observer = resizeObserver;
        this.callback = callback;
    }
    return ResizeObserverDetail;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverEntry: () => (/* binding */ ResizeObserverEntry)
/* harmony export */ });
/* harmony import */ var _algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./algorithms/calculateBoxSize */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js");
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");


var ResizeObserverEntry = (function () {
    function ResizeObserverEntry(target) {
        var boxes = (0,_algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_0__.calculateBoxSizes)(target);
        this.target = target;
        this.contentRect = boxes.contentRect;
        this.borderBoxSize = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_1__.freeze)([boxes.borderBoxSize]);
        this.contentBoxSize = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_1__.freeze)([boxes.contentBoxSize]);
        this.devicePixelContentBoxSize = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_1__.freeze)([boxes.devicePixelContentBoxSize]);
    }
    return ResizeObserverEntry;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js":
/*!************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverSize: () => (/* binding */ ResizeObserverSize)
/* harmony export */ });
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");

var ResizeObserverSize = (function () {
    function ResizeObserverSize(inlineSize, blockSize) {
        this.inlineSize = inlineSize;
        this.blockSize = blockSize;
        (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_0__.freeze)(this);
    }
    return ResizeObserverSize;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   broadcastActiveObservations: () => (/* binding */ broadcastActiveObservations)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");
/* harmony import */ var _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ResizeObserverEntry */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js");
/* harmony import */ var _calculateDepthForNode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./calculateDepthForNode */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js");
/* harmony import */ var _calculateBoxSize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./calculateBoxSize */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js");




var broadcastActiveObservations = function () {
    var shallowestDepth = Infinity;
    var callbacks = [];
    _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.forEach(function processObserver(ro) {
        if (ro.activeTargets.length === 0) {
            return;
        }
        var entries = [];
        ro.activeTargets.forEach(function processTarget(ot) {
            var entry = new _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__.ResizeObserverEntry(ot.target);
            var targetDepth = (0,_calculateDepthForNode__WEBPACK_IMPORTED_MODULE_2__.calculateDepthForNode)(ot.target);
            entries.push(entry);
            ot.lastReportedSize = (0,_calculateBoxSize__WEBPACK_IMPORTED_MODULE_3__.calculateBoxSize)(ot.target, ot.observedBox);
            if (targetDepth < shallowestDepth) {
                shallowestDepth = targetDepth;
            }
        });
        callbacks.push(function resizeObserverCallback() {
            ro.callback.call(ro.observer, entries, ro.observer);
        });
        ro.activeTargets.splice(0, ro.activeTargets.length);
    });
    for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
        var callback = callbacks_1[_i];
        callback();
    }
    return shallowestDepth;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateBoxSize: () => (/* binding */ calculateBoxSize),
/* harmony export */   calculateBoxSizes: () => (/* binding */ calculateBoxSizes)
/* harmony export */ });
/* harmony import */ var _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../ResizeObserverBoxOptions */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js");
/* harmony import */ var _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ResizeObserverSize */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js");
/* harmony import */ var _DOMRectReadOnly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DOMRectReadOnly */ "./node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js");
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");
/* harmony import */ var _utils_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/global */ "./node_modules/@juggle/resize-observer/lib/utils/global.js");






var cache = new WeakMap();
var scrollRegexp = /auto|scroll/;
var verticalRegexp = /^tb|vertical/;
var IE = (/msie|trident/i).test(_utils_global__WEBPACK_IMPORTED_MODULE_5__.global.navigator && _utils_global__WEBPACK_IMPORTED_MODULE_5__.global.navigator.userAgent);
var parseDimension = function (pixel) { return parseFloat(pixel || '0'); };
var size = function (inlineSize, blockSize, switchSizes) {
    if (inlineSize === void 0) { inlineSize = 0; }
    if (blockSize === void 0) { blockSize = 0; }
    if (switchSizes === void 0) { switchSizes = false; }
    return new _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_1__.ResizeObserverSize((switchSizes ? blockSize : inlineSize) || 0, (switchSizes ? inlineSize : blockSize) || 0);
};
var zeroBoxes = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_4__.freeze)({
    devicePixelContentBoxSize: size(),
    borderBoxSize: size(),
    contentBoxSize: size(),
    contentRect: new _DOMRectReadOnly__WEBPACK_IMPORTED_MODULE_2__.DOMRectReadOnly(0, 0, 0, 0)
});
var calculateBoxSizes = function (target, forceRecalculation) {
    if (forceRecalculation === void 0) { forceRecalculation = false; }
    if (cache.has(target) && !forceRecalculation) {
        return cache.get(target);
    }
    if ((0,_utils_element__WEBPACK_IMPORTED_MODULE_3__.isHidden)(target)) {
        cache.set(target, zeroBoxes);
        return zeroBoxes;
    }
    var cs = getComputedStyle(target);
    var svg = (0,_utils_element__WEBPACK_IMPORTED_MODULE_3__.isSVG)(target) && target.ownerSVGElement && target.getBBox();
    var removePadding = !IE && cs.boxSizing === 'border-box';
    var switchSizes = verticalRegexp.test(cs.writingMode || '');
    var canScrollVertically = !svg && scrollRegexp.test(cs.overflowY || '');
    var canScrollHorizontally = !svg && scrollRegexp.test(cs.overflowX || '');
    var paddingTop = svg ? 0 : parseDimension(cs.paddingTop);
    var paddingRight = svg ? 0 : parseDimension(cs.paddingRight);
    var paddingBottom = svg ? 0 : parseDimension(cs.paddingBottom);
    var paddingLeft = svg ? 0 : parseDimension(cs.paddingLeft);
    var borderTop = svg ? 0 : parseDimension(cs.borderTopWidth);
    var borderRight = svg ? 0 : parseDimension(cs.borderRightWidth);
    var borderBottom = svg ? 0 : parseDimension(cs.borderBottomWidth);
    var borderLeft = svg ? 0 : parseDimension(cs.borderLeftWidth);
    var horizontalPadding = paddingLeft + paddingRight;
    var verticalPadding = paddingTop + paddingBottom;
    var horizontalBorderArea = borderLeft + borderRight;
    var verticalBorderArea = borderTop + borderBottom;
    var horizontalScrollbarThickness = !canScrollHorizontally ? 0 : target.offsetHeight - verticalBorderArea - target.clientHeight;
    var verticalScrollbarThickness = !canScrollVertically ? 0 : target.offsetWidth - horizontalBorderArea - target.clientWidth;
    var widthReduction = removePadding ? horizontalPadding + horizontalBorderArea : 0;
    var heightReduction = removePadding ? verticalPadding + verticalBorderArea : 0;
    var contentWidth = svg ? svg.width : parseDimension(cs.width) - widthReduction - verticalScrollbarThickness;
    var contentHeight = svg ? svg.height : parseDimension(cs.height) - heightReduction - horizontalScrollbarThickness;
    var borderBoxWidth = contentWidth + horizontalPadding + verticalScrollbarThickness + horizontalBorderArea;
    var borderBoxHeight = contentHeight + verticalPadding + horizontalScrollbarThickness + verticalBorderArea;
    var boxes = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_4__.freeze)({
        devicePixelContentBoxSize: size(Math.round(contentWidth * devicePixelRatio), Math.round(contentHeight * devicePixelRatio), switchSizes),
        borderBoxSize: size(borderBoxWidth, borderBoxHeight, switchSizes),
        contentBoxSize: size(contentWidth, contentHeight, switchSizes),
        contentRect: new _DOMRectReadOnly__WEBPACK_IMPORTED_MODULE_2__.DOMRectReadOnly(paddingLeft, paddingTop, contentWidth, contentHeight)
    });
    cache.set(target, boxes);
    return boxes;
};
var calculateBoxSize = function (target, observedBox, forceRecalculation) {
    var _a = calculateBoxSizes(target, forceRecalculation), borderBoxSize = _a.borderBoxSize, contentBoxSize = _a.contentBoxSize, devicePixelContentBoxSize = _a.devicePixelContentBoxSize;
    switch (observedBox) {
        case _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverBoxOptions.DEVICE_PIXEL_CONTENT_BOX:
            return devicePixelContentBoxSize;
        case _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverBoxOptions.BORDER_BOX:
            return borderBoxSize;
        default:
            return contentBoxSize;
    }
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDepthForNode: () => (/* binding */ calculateDepthForNode)
/* harmony export */ });
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");

var calculateDepthForNode = function (node) {
    if ((0,_utils_element__WEBPACK_IMPORTED_MODULE_0__.isHidden)(node)) {
        return Infinity;
    }
    var depth = 0;
    var parent = node.parentNode;
    while (parent) {
        depth += 1;
        parent = parent.parentNode;
    }
    return depth;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deliverResizeLoopError: () => (/* binding */ deliverResizeLoopError)
/* harmony export */ });
var msg = 'ResizeObserver loop completed with undelivered notifications.';
var deliverResizeLoopError = function () {
    var event;
    if (typeof ErrorEvent === 'function') {
        event = new ErrorEvent('error', {
            message: msg
        });
    }
    else {
        event = document.createEvent('Event');
        event.initEvent('error', false, false);
        event.message = msg;
    }
    window.dispatchEvent(event);
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   gatherActiveObservationsAtDepth: () => (/* binding */ gatherActiveObservationsAtDepth)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");
/* harmony import */ var _calculateDepthForNode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./calculateDepthForNode */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js");


var gatherActiveObservationsAtDepth = function (depth) {
    _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.forEach(function processObserver(ro) {
        ro.activeTargets.splice(0, ro.activeTargets.length);
        ro.skippedTargets.splice(0, ro.skippedTargets.length);
        ro.observationTargets.forEach(function processTarget(ot) {
            if (ot.isActive()) {
                if ((0,_calculateDepthForNode__WEBPACK_IMPORTED_MODULE_1__.calculateDepthForNode)(ot.target) > depth) {
                    ro.activeTargets.push(ot);
                }
                else {
                    ro.skippedTargets.push(ot);
                }
            }
        });
    });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasActiveObservations: () => (/* binding */ hasActiveObservations)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");

var hasActiveObservations = function () {
    return _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.some(function (ro) { return ro.activeTargets.length > 0; });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasSkippedObservations: () => (/* binding */ hasSkippedObservations)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");

var hasSkippedObservations = function () {
    return _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.some(function (ro) { return ro.skippedTargets.length > 0; });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/exports/resize-observer.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/exports/resize-observer.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserver: () => (/* reexport safe */ _ResizeObserver__WEBPACK_IMPORTED_MODULE_0__.ResizeObserver),
/* harmony export */   ResizeObserverEntry: () => (/* reexport safe */ _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__.ResizeObserverEntry),
/* harmony export */   ResizeObserverSize: () => (/* reexport safe */ _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_2__.ResizeObserverSize)
/* harmony export */ });
/* harmony import */ var _ResizeObserver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../ResizeObserver */ "./node_modules/@juggle/resize-observer/lib/ResizeObserver.js");
/* harmony import */ var _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ResizeObserverEntry */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js");
/* harmony import */ var _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ResizeObserverSize */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js");





/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/element.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/element.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHidden: () => (/* binding */ isHidden),
/* harmony export */   isReplacedElement: () => (/* binding */ isReplacedElement),
/* harmony export */   isSVG: () => (/* binding */ isSVG)
/* harmony export */ });
var isSVG = function (target) { return target instanceof SVGElement && 'getBBox' in target; };
var isHidden = function (target) {
    if (isSVG(target)) {
        var _a = target.getBBox(), width = _a.width, height = _a.height;
        return !width && !height;
    }
    var _b = target, offsetWidth = _b.offsetWidth, offsetHeight = _b.offsetHeight;
    return !(offsetWidth || offsetHeight || target.getClientRects().length);
};
var isElement = function (obj) {
    var _a;
    if (obj instanceof Element) {
        return true;
    }
    var scope = (_a = obj === null || obj === void 0 ? void 0 : obj.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
    return !!(scope && obj instanceof scope.Element);
};
var isReplacedElement = function (target) {
    switch (target.tagName) {
        case 'INPUT':
            if (target.type !== 'image') {
                break;
            }
        case 'VIDEO':
        case 'AUDIO':
        case 'EMBED':
        case 'OBJECT':
        case 'CANVAS':
        case 'IFRAME':
        case 'IMG':
            return true;
    }
    return false;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js":
/*!******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/freeze.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   freeze: () => (/* binding */ freeze)
/* harmony export */ });
var freeze = function (obj) { return Object.freeze(obj); };


/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/global.js":
/*!******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/global.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   global: () => (/* binding */ global)
/* harmony export */ });
var global = typeof window !== 'undefined' ? window : {};


/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/process.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/process.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   process: () => (/* binding */ process)
/* harmony export */ });
/* harmony import */ var _algorithms_hasActiveObservations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../algorithms/hasActiveObservations */ "./node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js");
/* harmony import */ var _algorithms_hasSkippedObservations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../algorithms/hasSkippedObservations */ "./node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js");
/* harmony import */ var _algorithms_deliverResizeLoopError__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../algorithms/deliverResizeLoopError */ "./node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js");
/* harmony import */ var _algorithms_broadcastActiveObservations__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../algorithms/broadcastActiveObservations */ "./node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js");
/* harmony import */ var _algorithms_gatherActiveObservationsAtDepth__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../algorithms/gatherActiveObservationsAtDepth */ "./node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js");





var process = function () {
    var depth = 0;
    (0,_algorithms_gatherActiveObservationsAtDepth__WEBPACK_IMPORTED_MODULE_4__.gatherActiveObservationsAtDepth)(depth);
    while ((0,_algorithms_hasActiveObservations__WEBPACK_IMPORTED_MODULE_0__.hasActiveObservations)()) {
        depth = (0,_algorithms_broadcastActiveObservations__WEBPACK_IMPORTED_MODULE_3__.broadcastActiveObservations)();
        (0,_algorithms_gatherActiveObservationsAtDepth__WEBPACK_IMPORTED_MODULE_4__.gatherActiveObservationsAtDepth)(depth);
    }
    if ((0,_algorithms_hasSkippedObservations__WEBPACK_IMPORTED_MODULE_1__.hasSkippedObservations)()) {
        (0,_algorithms_deliverResizeLoopError__WEBPACK_IMPORTED_MODULE_2__.deliverResizeLoopError)();
    }
    return depth > 0;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   queueMicroTask: () => (/* binding */ queueMicroTask)
/* harmony export */ });
var trigger;
var callbacks = [];
var notify = function () { return callbacks.splice(0).forEach(function (cb) { return cb(); }); };
var queueMicroTask = function (callback) {
    if (!trigger) {
        var toggle_1 = 0;
        var el_1 = document.createTextNode('');
        var config = { characterData: true };
        new MutationObserver(function () { return notify(); }).observe(el_1, config);
        trigger = function () { el_1.textContent = "".concat(toggle_1 ? toggle_1-- : toggle_1++); };
    }
    callbacks.push(callback);
    trigger();
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   queueResizeObserver: () => (/* binding */ queueResizeObserver)
/* harmony export */ });
/* harmony import */ var _queueMicroTask__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./queueMicroTask */ "./node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js");

var queueResizeObserver = function (cb) {
    (0,_queueMicroTask__WEBPACK_IMPORTED_MODULE_0__.queueMicroTask)(function ResizeObserver() {
        requestAnimationFrame(cb);
    });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   resizeObservers: () => (/* binding */ resizeObservers)
/* harmony export */ });
var resizeObservers = [];



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/scheduler.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/scheduler.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   scheduler: () => (/* binding */ scheduler),
/* harmony export */   updateCount: () => (/* binding */ updateCount)
/* harmony export */ });
/* harmony import */ var _process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./process */ "./node_modules/@juggle/resize-observer/lib/utils/process.js");
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./global */ "./node_modules/@juggle/resize-observer/lib/utils/global.js");
/* harmony import */ var _queueResizeObserver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./queueResizeObserver */ "./node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js");



var watching = 0;
var isWatching = function () { return !!watching; };
var CATCH_PERIOD = 250;
var observerConfig = { attributes: true, characterData: true, childList: true, subtree: true };
var events = [
    'resize',
    'load',
    'transitionend',
    'animationend',
    'animationstart',
    'animationiteration',
    'keyup',
    'keydown',
    'mouseup',
    'mousedown',
    'mouseover',
    'mouseout',
    'blur',
    'focus'
];
var time = function (timeout) {
    if (timeout === void 0) { timeout = 0; }
    return Date.now() + timeout;
};
var scheduled = false;
var Scheduler = (function () {
    function Scheduler() {
        var _this = this;
        this.stopped = true;
        this.listener = function () { return _this.schedule(); };
    }
    Scheduler.prototype.run = function (timeout) {
        var _this = this;
        if (timeout === void 0) { timeout = CATCH_PERIOD; }
        if (scheduled) {
            return;
        }
        scheduled = true;
        var until = time(timeout);
        (0,_queueResizeObserver__WEBPACK_IMPORTED_MODULE_2__.queueResizeObserver)(function () {
            var elementsHaveResized = false;
            try {
                elementsHaveResized = (0,_process__WEBPACK_IMPORTED_MODULE_0__.process)();
            }
            finally {
                scheduled = false;
                timeout = until - time();
                if (!isWatching()) {
                    return;
                }
                if (elementsHaveResized) {
                    _this.run(1000);
                }
                else if (timeout > 0) {
                    _this.run(timeout);
                }
                else {
                    _this.start();
                }
            }
        });
    };
    Scheduler.prototype.schedule = function () {
        this.stop();
        this.run();
    };
    Scheduler.prototype.observe = function () {
        var _this = this;
        var cb = function () { return _this.observer && _this.observer.observe(document.body, observerConfig); };
        document.body ? cb() : _global__WEBPACK_IMPORTED_MODULE_1__.global.addEventListener('DOMContentLoaded', cb);
    };
    Scheduler.prototype.start = function () {
        var _this = this;
        if (this.stopped) {
            this.stopped = false;
            this.observer = new MutationObserver(this.listener);
            this.observe();
            events.forEach(function (name) { return _global__WEBPACK_IMPORTED_MODULE_1__.global.addEventListener(name, _this.listener, true); });
        }
    };
    Scheduler.prototype.stop = function () {
        var _this = this;
        if (!this.stopped) {
            this.observer && this.observer.disconnect();
            events.forEach(function (name) { return _global__WEBPACK_IMPORTED_MODULE_1__.global.removeEventListener(name, _this.listener, true); });
            this.stopped = true;
        }
    };
    return Scheduler;
}());
var scheduler = new Scheduler();
var updateCount = function (n) {
    !watching && n > 0 && scheduler.start();
    watching += n;
    !watching && scheduler.stop();
};



/***/ }),

/***/ "./node_modules/css-render/esm/exists.js":
/*!***********************************************!*\
  !*** ./node_modules/css-render/esm/exists.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   exists: () => (/* binding */ exists)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/css-render/esm/utils.js");

function exists(id, ssr) {
    if (id === undefined)
        return false;
    if (ssr) {
        const { context: { ids } } = ssr;
        return ids.has(id);
    }
    return (0,_utils__WEBPACK_IMPORTED_MODULE_0__.queryElement)(id) !== null;
}


/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js":
/*!**************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildFormatLongFn)
/* harmony export */ });
function buildFormatLongFn(args) {
  return function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    // TODO: Remove String()
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format = args.formats[width] || args.formats[args.defaultWidth];
    return format;
  };
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js":
/*!************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildLocalizeFn)
/* harmony export */ });
function buildLocalizeFn(args) {
  return function (dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : 'standalone';
    var valuesArray;
    if (context === 'formatting' && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    // @ts-ignore: For some reason TypeScript just don't want to match it, no matter how hard we try. I challenge you to try to remove it!
    return valuesArray[index];
  };
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildMatchFn)
/* harmony export */ });
function buildMatchFn(args) {
  return function (string) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function (pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function (pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value: value,
      rest: rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return undefined;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return undefined;
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildMatchPatternFn)
/* harmony export */ });
function buildMatchPatternFn(args) {
  return function (string) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult) return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult) return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value: value,
      rest: rest
    };
  };
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: 'less than a second',
    other: 'less than {{count}} seconds'
  },
  xSeconds: {
    one: '1 second',
    other: '{{count}} seconds'
  },
  halfAMinute: 'half a minute',
  lessThanXMinutes: {
    one: 'less than a minute',
    other: 'less than {{count}} minutes'
  },
  xMinutes: {
    one: '1 minute',
    other: '{{count}} minutes'
  },
  aboutXHours: {
    one: 'about 1 hour',
    other: 'about {{count}} hours'
  },
  xHours: {
    one: '1 hour',
    other: '{{count}} hours'
  },
  xDays: {
    one: '1 day',
    other: '{{count}} days'
  },
  aboutXWeeks: {
    one: 'about 1 week',
    other: 'about {{count}} weeks'
  },
  xWeeks: {
    one: '1 week',
    other: '{{count}} weeks'
  },
  aboutXMonths: {
    one: 'about 1 month',
    other: 'about {{count}} months'
  },
  xMonths: {
    one: '1 month',
    other: '{{count}} months'
  },
  aboutXYears: {
    one: 'about 1 year',
    other: 'about {{count}} years'
  },
  xYears: {
    one: '1 year',
    other: '{{count}} years'
  },
  overXYears: {
    one: 'over 1 year',
    other: 'over {{count}} years'
  },
  almostXYears: {
    one: 'almost 1 year',
    other: 'almost {{count}} years'
  }
};
var formatDistance = function formatDistance(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === 'string') {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace('{{count}}', count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return 'in ' + result;
    } else {
      return result + ' ago';
    }
  }
  return result;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatDistance);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_lib/buildFormatLongFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js");

var dateFormats = {
  full: 'EEEE, MMMM do, y',
  long: 'MMMM do, y',
  medium: 'MMM d, y',
  short: 'MM/dd/yyyy'
};
var timeFormats = {
  full: 'h:mm:ss a zzzz',
  long: 'h:mm:ss a z',
  medium: 'h:mm:ss a',
  short: 'h:mm a'
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: '{{date}}, {{time}}',
  short: '{{date}}, {{time}}'
};
var formatLong = {
  date: (0,_lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formats: dateFormats,
    defaultWidth: 'full'
  }),
  time: (0,_lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formats: timeFormats,
    defaultWidth: 'full'
  }),
  dateTime: (0,_lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formats: dateTimeFormats,
    defaultWidth: 'full'
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatLong);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: 'P'
};
var formatRelative = function formatRelative(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatRelative);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_lib/buildLocalizeFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js");

var eraValues = {
  narrow: ['B', 'A'],
  abbreviated: ['BC', 'AD'],
  wide: ['Before Christ', 'Anno Domini']
};
var quarterValues = {
  narrow: ['1', '2', '3', '4'],
  abbreviated: ['Q1', 'Q2', 'Q3', 'Q4'],
  wide: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter']
};

// Note: in English, the names of days of the week and months are capitalized.
// If you are making a new locale based on this one, check if the same is true for the language you're working on.
// Generally, formatted dates should look like they are in the middle of a sentence,
// e.g. in Spanish language the weekdays and months should be in the lowercase.
var monthValues = {
  narrow: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  abbreviated: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  wide: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
};
var dayValues = {
  narrow: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  short: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
  abbreviated: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  wide: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
};
var dayPeriodValues = {
  narrow: {
    am: 'a',
    pm: 'p',
    midnight: 'mi',
    noon: 'n',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  },
  abbreviated: {
    am: 'AM',
    pm: 'PM',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  },
  wide: {
    am: 'a.m.',
    pm: 'p.m.',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: 'a',
    pm: 'p',
    midnight: 'mi',
    noon: 'n',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  },
  abbreviated: {
    am: 'AM',
    pm: 'PM',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  },
  wide: {
    am: 'a.m.',
    pm: 'p.m.',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  }
};
var ordinalNumber = function ordinalNumber(dirtyNumber, _options) {
  var number = Number(dirtyNumber);

  // If ordinal numbers depend on context, for example,
  // if they are different for different grammatical genders,
  // use `options.unit`.
  //
  // `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
  // 'day', 'hour', 'minute', 'second'.

  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + 'st';
      case 2:
        return number + 'nd';
      case 3:
        return number + 'rd';
    }
  }
  return number + 'th';
};
var localize = {
  ordinalNumber: ordinalNumber,
  era: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: eraValues,
    defaultWidth: 'wide'
  }),
  quarter: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: quarterValues,
    defaultWidth: 'wide',
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: monthValues,
    defaultWidth: 'wide'
  }),
  day: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: dayValues,
    defaultWidth: 'wide'
  }),
  dayPeriod: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: dayPeriodValues,
    defaultWidth: 'wide',
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: 'wide'
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (localize);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/match/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/match/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_lib/buildMatchFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js");
/* harmony import */ var _lib_buildMatchPatternFn_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_lib/buildMatchPatternFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js");


var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: (0,_lib_buildMatchPatternFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseEraPatterns,
    defaultParseWidth: 'any'
  }),
  quarter: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: 'any',
    valueCallback: function valueCallback(index) {
      return index + 1;
    }
  }),
  month: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: 'any'
  }),
  day: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseDayPatterns,
    defaultParseWidth: 'any'
  }),
  dayPeriod: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: 'any',
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: 'any'
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (match);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_formatDistance_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_lib/formatDistance/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js");
/* harmony import */ var _lib_formatLong_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_lib/formatLong/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js");
/* harmony import */ var _lib_formatRelative_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_lib/formatRelative/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js");
/* harmony import */ var _lib_localize_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_lib/localize/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js");
/* harmony import */ var _lib_match_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_lib/match/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/match/index.js");





/**
 * @type {Locale}
 * @category Locales
 * @summary English locale (United States).
 * @language English
 * @iso-639-2 eng
 * @author Sasha Koss [@kossnocorp]{@link https://github.com/kossnocorp}
 * @author Lesha Koss [@leshakoss]{@link https://github.com/leshakoss}
 */
var locale = {
  code: 'en-US',
  formatDistance: _lib_formatDistance_index_js__WEBPACK_IMPORTED_MODULE_0__["default"],
  formatLong: _lib_formatLong_index_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  formatRelative: _lib_formatRelative_index_js__WEBPACK_IMPORTED_MODULE_2__["default"],
  localize: _lib_localize_index_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  match: _lib_match_index_js__WEBPACK_IMPORTED_MODULE_4__["default"],
  options: {
    weekStartsOn: 0 /* Sunday */,
    firstWeekContainsDate: 1
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (locale);

/***/ }),

/***/ "./node_modules/evtd/es/delegate.js":
/*!******************************************!*\
  !*** ./node_modules/evtd/es/delegate.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   off: () => (/* binding */ off),
/* harmony export */   on: () => (/* binding */ on)
/* harmony export */ });
/* harmony import */ var _traps__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./traps */ "./node_modules/evtd/es/traps.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/evtd/es/utils.js");


// currently `once` and `passive` is not supported
function createDelegate() {
    if (typeof window === 'undefined') {
        return {
            on: () => { },
            off: () => { }
        };
    }
    const propagationStopped = new WeakMap();
    const immediatePropagationStopped = new WeakMap();
    function trackPropagation() {
        propagationStopped.set(this, true);
    }
    function trackImmediate() {
        propagationStopped.set(this, true);
        immediatePropagationStopped.set(this, true);
    }
    function spy(event, propName, fn) {
        const source = event[propName];
        event[propName] = function () {
            fn.apply(event, arguments);
            return source.apply(event, arguments);
        };
        return event;
    }
    function unspy(event, propName) {
        event[propName] = Event.prototype[propName];
    }
    const currentTargets = new WeakMap();
    const currentTargetDescriptor = Object.getOwnPropertyDescriptor(Event.prototype, 'currentTarget');
    function getCurrentTarget() {
        var _a;
        return (_a = currentTargets.get(this)) !== null && _a !== void 0 ? _a : null;
    }
    function defineCurrentTarget(event, getter) {
        if (currentTargetDescriptor === undefined)
            return;
        Object.defineProperty(event, 'currentTarget', {
            configurable: true,
            enumerable: true,
            get: getter !== null && getter !== void 0 ? getter : currentTargetDescriptor.get
        });
    }
    const phaseToTypeToElToHandlers = {
        bubble: {},
        capture: {}
    };
    const typeToWindowEventHandlers = {};
    function createUnifiedHandler() {
        const delegeteHandler = function (e) {
            const { type, eventPhase, bubbles } = e;
            const target = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e);
            if (eventPhase === 2)
                return;
            const phase = eventPhase === 1 ? 'capture' : 'bubble';
            let cursor = target;
            const path = [];
            // collecting bubble path
            while (true) {
                if (cursor === null)
                    cursor = window;
                path.push(cursor);
                if (cursor === window) {
                    break;
                }
                // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
                cursor = (cursor.parentNode || null);
            }
            const captureElToHandlers = phaseToTypeToElToHandlers.capture[type];
            const bubbleElToHandlers = phaseToTypeToElToHandlers.bubble[type];
            spy(e, 'stopPropagation', trackPropagation);
            spy(e, 'stopImmediatePropagation', trackImmediate);
            defineCurrentTarget(e, getCurrentTarget);
            if (phase === 'capture') {
                if (captureElToHandlers === undefined)
                    return;
                // capture
                for (let i = path.length - 1; i >= 0; --i) {
                    if (propagationStopped.has(e))
                        break;
                    const target = path[i];
                    const handlers = captureElToHandlers.get(target);
                    if (handlers !== undefined) {
                        currentTargets.set(e, target);
                        for (const handler of handlers) {
                            if (immediatePropagationStopped.has(e))
                                break;
                            handler(e);
                        }
                    }
                    if (i === 0 && !bubbles && bubbleElToHandlers !== undefined) {
                        const bubbleHandlers = bubbleElToHandlers.get(target);
                        if (bubbleHandlers !== undefined) {
                            for (const handler of bubbleHandlers) {
                                if (immediatePropagationStopped.has(e))
                                    break;
                                handler(e);
                            }
                        }
                    }
                }
            }
            else if (phase === 'bubble') {
                if (bubbleElToHandlers === undefined)
                    return;
                // bubble
                for (let i = 0; i < path.length; ++i) {
                    if (propagationStopped.has(e))
                        break;
                    const target = path[i];
                    const handlers = bubbleElToHandlers.get(target);
                    if (handlers !== undefined) {
                        currentTargets.set(e, target);
                        for (const handler of handlers) {
                            if (immediatePropagationStopped.has(e))
                                break;
                            handler(e);
                        }
                    }
                }
            }
            unspy(e, 'stopPropagation');
            unspy(e, 'stopImmediatePropagation');
            defineCurrentTarget(e);
        };
        delegeteHandler.displayName = 'evtdUnifiedHandler';
        return delegeteHandler;
    }
    function createUnifiedWindowEventHandler() {
        const delegateHandler = function (e) {
            const { type, eventPhase } = e;
            if (eventPhase !== 2)
                return;
            const handlers = typeToWindowEventHandlers[type];
            if (handlers === undefined)
                return;
            handlers.forEach((handler) => handler(e));
        };
        delegateHandler.displayName = 'evtdUnifiedWindowEventHandler';
        return delegateHandler;
    }
    const unifiedHandler = createUnifiedHandler();
    const unfiendWindowEventHandler = createUnifiedWindowEventHandler();
    function ensureElToHandlers(phase, type) {
        const phaseHandlers = phaseToTypeToElToHandlers[phase];
        if (phaseHandlers[type] === undefined) {
            phaseHandlers[type] = new Map();
            window.addEventListener(type, unifiedHandler, phase === 'capture');
        }
        return phaseHandlers[type];
    }
    function ensureWindowEventHandlers(type) {
        const windowEventHandlers = typeToWindowEventHandlers[type];
        if (windowEventHandlers === undefined) {
            typeToWindowEventHandlers[type] = new Set();
            window.addEventListener(type, unfiendWindowEventHandler);
        }
        return typeToWindowEventHandlers[type];
    }
    function ensureHandlers(elToHandlers, el) {
        let elHandlers = elToHandlers.get(el);
        if (elHandlers === undefined) {
            elToHandlers.set(el, (elHandlers = new Set()));
        }
        return elHandlers;
    }
    function handlerExist(el, phase, type, handler) {
        const elToHandlers = phaseToTypeToElToHandlers[phase][type];
        // phase ${type} event has handlers
        if (elToHandlers !== undefined) {
            const handlers = elToHandlers.get(el);
            // phase using el with ${type} event has handlers
            if (handlers !== undefined) {
                if (handlers.has(handler))
                    return true;
            }
        }
        return false;
    }
    function windowEventHandlerExist(type, handler) {
        const handlers = typeToWindowEventHandlers[type];
        if (handlers !== undefined) {
            if (handlers.has(handler)) {
                return true;
            }
        }
        return false;
    }
    function on(type, el, handler, options) {
        let mergedHandler;
        if (typeof options === 'object' && options.once === true) {
            mergedHandler = (e) => {
                off(type, el, mergedHandler, options);
                handler(e);
            };
        }
        else {
            mergedHandler = handler;
        }
        const trapped = (0,_traps__WEBPACK_IMPORTED_MODULE_1__.trapOn)(type, el, mergedHandler, options);
        if (trapped)
            return;
        const phase = options === true ||
            (typeof options === 'object' && options.capture === true)
            ? 'capture'
            : 'bubble';
        const elToHandlers = ensureElToHandlers(phase, type);
        const handlers = ensureHandlers(elToHandlers, el);
        if (!handlers.has(mergedHandler))
            handlers.add(mergedHandler);
        if (el === window) {
            const windowEventHandlers = ensureWindowEventHandlers(type);
            if (!windowEventHandlers.has(mergedHandler)) {
                windowEventHandlers.add(mergedHandler);
            }
        }
    }
    function off(type, el, handler, options) {
        const trapped = (0,_traps__WEBPACK_IMPORTED_MODULE_1__.trapOff)(type, el, handler, options);
        if (trapped)
            return;
        const capture = options === true ||
            (typeof options === 'object' && options.capture === true);
        const phase = capture ? 'capture' : 'bubble';
        const elToHandlers = ensureElToHandlers(phase, type);
        const handlers = ensureHandlers(elToHandlers, el);
        if (el === window) {
            const mirrorPhase = capture ? 'bubble' : 'capture';
            if (!handlerExist(el, mirrorPhase, type, handler) &&
                windowEventHandlerExist(type, handler)) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                const windowEventHandlers = typeToWindowEventHandlers[type];
                windowEventHandlers.delete(handler);
                if (windowEventHandlers.size === 0) {
                    window.removeEventListener(type, unfiendWindowEventHandler);
                    typeToWindowEventHandlers[type] = undefined;
                }
            }
        }
        if (handlers.has(handler))
            handlers.delete(handler);
        if (handlers.size === 0) {
            elToHandlers.delete(el);
        }
        if (elToHandlers.size === 0) {
            window.removeEventListener(type, unifiedHandler, phase === 'capture');
            phaseToTypeToElToHandlers[phase][type] = undefined;
        }
    }
    return {
        on: on,
        off: off
    };
}
const { on, off } = createDelegate();



/***/ }),

/***/ "./node_modules/evtd/es/traps.js":
/*!***************************************!*\
  !*** ./node_modules/evtd/es/traps.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   trapOff: () => (/* binding */ trapOff),
/* harmony export */   trapOn: () => (/* binding */ trapOn)
/* harmony export */ });
/* harmony import */ var _delegate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./delegate */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/evtd/es/utils.js");


const traps = {
    mousemoveoutside: new WeakMap(),
    clickoutside: new WeakMap()
};
function createTrapHandler(name, el, originalHandler) {
    if (name === 'mousemoveoutside') {
        const moveHandler = (e) => {
            if (el.contains((0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e)))
                return;
            originalHandler(e);
        };
        return {
            mousemove: moveHandler,
            touchstart: moveHandler
        };
    }
    else if (name === 'clickoutside') {
        let mouseDownOutside = false;
        const downHandler = (e) => {
            mouseDownOutside = !el.contains((0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e));
        };
        const upHanlder = (e) => {
            if (!mouseDownOutside)
                return;
            if (el.contains((0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e)))
                return;
            originalHandler(e);
        };
        return {
            mousedown: downHandler,
            mouseup: upHanlder,
            touchstart: downHandler,
            touchend: upHanlder
        };
    }
    console.error(
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    `[evtd/create-trap-handler]: name \`${name}\` is invalid. This could be a bug of evtd.`);
    return {};
}
function ensureTrapHandlers(name, el, handler) {
    const handlers = traps[name];
    let elHandlers = handlers.get(el);
    if (elHandlers === undefined) {
        handlers.set(el, (elHandlers = new WeakMap()));
    }
    let trapHandler = elHandlers.get(handler);
    if (trapHandler === undefined) {
        elHandlers.set(handler, (trapHandler = createTrapHandler(name, el, handler)));
    }
    return trapHandler;
}
function trapOn(name, el, handler, options) {
    if (name === 'mousemoveoutside' || name === 'clickoutside') {
        const trapHandlers = ensureTrapHandlers(name, el, handler);
        Object.keys(trapHandlers).forEach((key) => {
            (0,_delegate__WEBPACK_IMPORTED_MODULE_1__.on)(key, document, trapHandlers[key], options);
        });
        return true;
    }
    return false;
}
function trapOff(name, el, handler, options) {
    if (name === 'mousemoveoutside' || name === 'clickoutside') {
        const trapHandlers = ensureTrapHandlers(name, el, handler);
        Object.keys(trapHandlers).forEach((key) => {
            (0,_delegate__WEBPACK_IMPORTED_MODULE_1__.off)(key, document, trapHandlers[key], options);
        });
        return true;
    }
    return false;
}



/***/ }),

/***/ "./node_modules/evtd/es/utils.js":
/*!***************************************!*\
  !*** ./node_modules/evtd/es/utils.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getEventTarget: () => (/* binding */ getEventTarget)
/* harmony export */ });
function getEventTarget(e) {
    const path = e.composedPath();
    return path[0];
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.js":
/*!***********************************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.js ***!
  \***********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/life-cycle/use-is-mounted.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'BaseIconSwitchTransition',
    setup(_, { slots }) {
        const isMountedRef = (0,vooks__WEBPACK_IMPORTED_MODULE_1__["default"])();
        return () => ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Transition, { name: "icon-switch-transition", appear: isMountedRef.value }, slots));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icon/src/Icon.js":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icon/src/Icon.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-style.js");
/* harmony import */ var _styles_index_cssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/index.cssr */ "./node_modules/naive-ui/es/_internal/icon/src/styles/index.cssr.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'BaseIcon',
    props: {
        role: String,
        ariaLabel: String,
        ariaDisabled: {
            type: Boolean,
            default: undefined
        },
        ariaHidden: {
            type: Boolean,
            default: undefined
        },
        clsPrefix: {
            type: String,
            required: true
        },
        onClick: Function,
        onMousedown: Function,
        onMouseup: Function
    },
    setup(props) {
        (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('-base-icon', _styles_index_cssr__WEBPACK_IMPORTED_MODULE_2__["default"], (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    },
    render() {
        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("i", { class: `${this.clsPrefix}-base-icon`, onClick: this.onClick, onMousedown: this.onMousedown, onMouseup: this.onMouseup, role: this.role, "aria-label": this.ariaLabel, "aria-hidden": this.ariaHidden, "aria-disabled": this.ariaDisabled }, this.$slots));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icon/src/styles/index.cssr.js":
/*!**************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icon/src/styles/index.cssr.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 height: 1em;
 width: 1em;
 line-height: 1em;
 text-align: center;
 display: inline-block;
 position: relative;
 fill: currentColor;
 transform: translateZ(0);
`, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('svg', `
 height: 1em;
 width: 1em;
 `)]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/replaceable.js":
/*!*****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/replaceable.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   replaceable: () => (/* binding */ replaceable)
/* harmony export */ });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/upperFirst.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _config_provider_src_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../config-provider/src/context */ "./node_modules/naive-ui/es/config-provider/src/context.js");



// eslint-disable-next-line @typescript-eslint/explicit-function-return-type
function replaceable(name, icon) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
        name: (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])(name),
        setup() {
            var _a;
            const mergedIconsRef = (_a = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context__WEBPACK_IMPORTED_MODULE_2__.configProviderInjectionKey, null)) === null || _a === void 0 ? void 0 : _a.mergedIconsRef;
            return () => {
                var _a;
                const iconOverride = (_a = mergedIconsRef === null || mergedIconsRef === void 0 ? void 0 : mergedIconsRef.value) === null || _a === void 0 ? void 0 : _a[name];
                return iconOverride ? iconOverride() : icon;
            };
        }
    });
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/loading/src/Loading.js":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/loading/src/Loading.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-style.js");
/* harmony import */ var _icon_switch_transition__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../icon-switch-transition */ "./node_modules/naive-ui/es/_internal/icon-switch-transition/src/IconSwitchTransition.js");
/* harmony import */ var _styles_index_cssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/index.cssr */ "./node_modules/naive-ui/es/_internal/loading/src/styles/index.cssr.js");




const exposedLoadingProps = {
    strokeWidth: {
        type: Number,
        default: 28
    },
    stroke: {
        type: String,
        default: undefined
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'BaseLoading',
    props: Object.assign({ clsPrefix: {
            type: String,
            required: true
        }, show: {
            type: Boolean,
            default: true
        }, scale: {
            type: Number,
            default: 1
        }, radius: {
            type: Number,
            default: 100
        } }, exposedLoadingProps),
    setup(props) {
        (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('-base-loading', _styles_index_cssr__WEBPACK_IMPORTED_MODULE_2__["default"], (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    },
    render() {
        const { clsPrefix, radius, strokeWidth, stroke, scale } = this;
        const scaledRadius = radius / scale;
        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${clsPrefix}-base-loading`, role: "img", "aria-label": "loading" },
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_icon_switch_transition__WEBPACK_IMPORTED_MODULE_3__["default"], null, {
                default: () => this.show ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { key: "icon", class: `${clsPrefix}-base-loading__transition-wrapper` },
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${clsPrefix}-base-loading__container` },
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${clsPrefix}-base-loading__container-layer` },
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${clsPrefix}-base-loading__container-layer-left` },
                                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", { class: `${clsPrefix}-base-loading__svg`, viewBox: `0 0 ${2 * scaledRadius} ${2 * scaledRadius}`, xmlns: "http://www.w3.org/2000/svg", style: { color: stroke } },
                                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("circle", { fill: "none", stroke: "currentColor", "stroke-width": strokeWidth, "stroke-linecap": "round", cx: scaledRadius, cy: scaledRadius, r: radius - strokeWidth / 2, "stroke-dasharray": 4.91 * radius, "stroke-dashoffset": 2.46 * radius }))),
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${clsPrefix}-base-loading__container-layer-patch` },
                                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", { class: `${clsPrefix}-base-loading__svg`, viewBox: `0 0 ${2 * scaledRadius} ${2 * scaledRadius}`, xmlns: "http://www.w3.org/2000/svg", style: { color: stroke } },
                                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("circle", { fill: "none", stroke: "currentColor", "stroke-width": strokeWidth, "stroke-linecap": "round", cx: scaledRadius, cy: scaledRadius, r: radius - strokeWidth / 2, "stroke-dasharray": 4.91 * radius, "stroke-dashoffset": 2.46 * radius }))),
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${clsPrefix}-base-loading__container-layer-right` },
                                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", { class: `${clsPrefix}-base-loading__svg`, viewBox: `0 0 ${2 * scaledRadius} ${2 * scaledRadius}`, xmlns: "http://www.w3.org/2000/svg", style: { color: stroke } },
                                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("circle", { fill: "none", stroke: "currentColor", "stroke-width": strokeWidth, "stroke-linecap": "round", cx: scaledRadius, cy: scaledRadius, r: radius - strokeWidth / 2, "stroke-dasharray": 4.91 * radius, "stroke-dashoffset": 2.46 * radius }))))))) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { key: "placeholder", class: `${clsPrefix}-base-loading__placeholder` }, this.$slots))
            })));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/loading/src/styles/index.cssr.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/loading/src/styles/index.cssr.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _styles_transitions_icon_switch_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../_styles/transitions/icon-switch.cssr */ "./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.js");


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)([(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('@keyframes loading-container-rotate', `
 to {
 -webkit-transform: rotate(360deg);
 transform: rotate(360deg);
 }
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('@keyframes loading-layer-rotate', `
 12.5% {
 -webkit-transform: rotate(135deg);
 transform: rotate(135deg);
 }
 25% {
 -webkit-transform: rotate(270deg);
 transform: rotate(270deg);
 }
 37.5% {
 -webkit-transform: rotate(405deg);
 transform: rotate(405deg);
 }
 50% {
 -webkit-transform: rotate(540deg);
 transform: rotate(540deg);
 }
 62.5% {
 -webkit-transform: rotate(675deg);
 transform: rotate(675deg);
 }
 75% {
 -webkit-transform: rotate(810deg);
 transform: rotate(810deg);
 }
 87.5% {
 -webkit-transform: rotate(945deg);
 transform: rotate(945deg);
 }
 100% {
 -webkit-transform: rotate(1080deg);
 transform: rotate(1080deg);
 } 
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('@keyframes loading-left-spin', `
 from {
 -webkit-transform: rotate(265deg);
 transform: rotate(265deg);
 }
 50% {
 -webkit-transform: rotate(130deg);
 transform: rotate(130deg);
 }
 to {
 -webkit-transform: rotate(265deg);
 transform: rotate(265deg);
 }
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('@keyframes loading-right-spin', `
 from {
 -webkit-transform: rotate(-265deg);
 transform: rotate(-265deg);
 }
 50% {
 -webkit-transform: rotate(-130deg);
 transform: rotate(-130deg);
 }
 to {
 -webkit-transform: rotate(-265deg);
 transform: rotate(-265deg);
 }
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 position: relative;
 line-height: 0;
 width: 1em;
 height: 1em;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('transition-wrapper', `
 position: absolute;
 width: 100%;
 height: 100%;
 `, [(0,_styles_transitions_icon_switch_cssr__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)()]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('container', `
 display: inline-flex;
 position: relative;
 direction: ltr;
 line-height: 0;
 animation: loading-container-rotate 1568.2352941176ms linear infinite;
 font-size: 0;
 letter-spacing: 0;
 white-space: nowrap;
 opacity: 1;
 width: 100%;
 height: 100%;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('svg', `
 stroke: var(--n-text-color);
 fill: transparent;
 position: absolute;
 height: 100%;
 overflow: hidden;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('container-layer', `
 position: absolute;
 width: 100%;
 height: 100%;
 animation: loading-layer-rotate 5332ms cubic-bezier(0.4, 0, 0.2, 1) infinite both;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('container-layer-left', `
 display: inline-flex;
 position: relative;
 width: 50%;
 height: 100%;
 overflow: hidden;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('svg', `
 animation: loading-left-spin 1333ms cubic-bezier(0.4, 0, 0.2, 1) infinite both;
 width: 200%;
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('container-layer-patch', `
 position: absolute;
 top: 0;
 left: 47.5%;
 box-sizing: border-box;
 width: 5%;
 height: 100%;
 overflow: hidden;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('svg', `
 left: -900%;
 width: 2000%;
 transform: rotate(180deg);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('container-layer-right', `
 display: inline-flex;
 position: relative;
 width: 50%;
 height: 100%;
 overflow: hidden;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('svg', `
 animation: loading-right-spin 1333ms cubic-bezier(0.4, 0, 0.2, 1) infinite both;
 left: -100%;
 width: 200%;
 `)])])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 position: absolute;
 left: 50%;
 top: 50%;
 transform: translateX(-50%) translateY(-50%);
 `, [(0,_styles_transitions_icon_switch_cssr__WEBPACK_IMPORTED_MODULE_1__.iconSwitchTransition)({
  left: '50%',
  top: '50%',
  originalTransform: 'translateX(-50%) translateY(-50%)'
})])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.js":
/*!***********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   XScrollbar: () => (/* binding */ XScrollbar),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-is-ios.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/get-precise-event-target.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-theme.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-config.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-rtl.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../_utils */ "./node_modules/naive-ui/es/_utils/composable/use-reactivated.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../_utils */ "./node_modules/naive-ui/es/_utils/vue/wrapper.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../styles */ "./node_modules/naive-ui/es/_internal/scrollbar/styles/light.js");
/* harmony import */ var _styles_index_cssr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./styles/index.cssr */ "./node_modules/naive-ui/es/_internal/scrollbar/src/styles/index.cssr.js");









const scrollbarProps = Object.assign(Object.assign({}, _mixins__WEBPACK_IMPORTED_MODULE_1__["default"].props), { size: {
        type: Number,
        default: 5
    }, duration: {
        type: Number,
        default: 0
    }, scrollable: {
        type: Boolean,
        default: true
    }, xScrollable: Boolean, trigger: {
        type: String,
        default: 'hover'
    }, useUnifiedContainer: Boolean, triggerDisplayManually: Boolean, 
    // If container is set, resize observer won't not attached
    container: Function, content: Function, containerClass: String, containerStyle: [String, Object], contentClass: String, contentStyle: [String, Object], horizontalRailStyle: [String, Object], verticalRailStyle: [String, Object], onScroll: Function, onWheel: Function, onResize: Function, internalOnUpdateScrollLeft: Function, internalHoistYRail: Boolean });
const Scrollbar = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Scrollbar',
    props: scrollbarProps,
    inheritAttrs: false,
    setup(props) {
        const { mergedClsPrefixRef, inlineThemeDisabled, mergedRtlRef } = (0,_mixins__WEBPACK_IMPORTED_MODULE_2__["default"])(props);
        const rtlEnabledRef = (0,_mixins__WEBPACK_IMPORTED_MODULE_3__.useRtl)('Scrollbar', mergedRtlRef, mergedClsPrefixRef);
        // dom ref
        const wrapperRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const contentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const yRailRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const xRailRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        // data ref
        const contentHeightRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const contentWidthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerHeightRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerWidthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const yRailSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const xRailSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerScrollTopRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        const containerScrollLeftRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        const isShowXBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const isShowYBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        let yBarPressed = false;
        let xBarPressed = false;
        let xBarVanishTimerId;
        let yBarVanishTimerId;
        let memoYTop = 0;
        let memoXLeft = 0;
        let memoMouseX = 0;
        let memoMouseY = 0;
        const isIos = (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])();
        const yBarSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yRailSize } = yRailSizeRef;
            if (containerHeight === null ||
                contentHeight === null ||
                yRailSize === null) {
                return 0;
            }
            else {
                return Math.min(containerHeight, (yRailSize * containerHeight) / contentHeight + props.size * 1.5);
            }
        });
        const yBarSizePxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${yBarSizeRef.value}px`;
        });
        const xBarSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xRailSize } = xRailSizeRef;
            if (containerWidth === null ||
                contentWidth === null ||
                xRailSize === null) {
                return 0;
            }
            else {
                return (xRailSize * containerWidth) / contentWidth + props.size * 1.5;
            }
        });
        const xBarSizePxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${xBarSizeRef.value}px`;
        });
        const yBarTopRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: containerScrollTop } = containerScrollTopRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yRailSize } = yRailSizeRef;
            if (containerHeight === null ||
                contentHeight === null ||
                yRailSize === null) {
                return 0;
            }
            else {
                const heightDiff = contentHeight - containerHeight;
                if (!heightDiff)
                    return 0;
                return ((containerScrollTop / heightDiff) * (yRailSize - yBarSizeRef.value));
            }
        });
        const yBarTopPxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${yBarTopRef.value}px`;
        });
        const xBarLeftRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: containerScrollLeft } = containerScrollLeftRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xRailSize } = xRailSizeRef;
            if (containerWidth === null ||
                contentWidth === null ||
                xRailSize === null) {
                return 0;
            }
            else {
                const widthDiff = contentWidth - containerWidth;
                if (!widthDiff)
                    return 0;
                return ((containerScrollLeft / widthDiff) * (xRailSize - xBarSizeRef.value));
            }
        });
        const xBarLeftPxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${xBarLeftRef.value}px`;
        });
        const needYBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            return (containerHeight !== null &&
                contentHeight !== null &&
                contentHeight > containerHeight);
        });
        const needXBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            return (containerWidth !== null &&
                contentWidth !== null &&
                contentWidth > containerWidth);
        });
        const mergedShowXBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { trigger } = props;
            return trigger === 'none' || isShowXBarRef.value;
        });
        const mergedShowYBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { trigger } = props;
            return trigger === 'none' || isShowYBarRef.value;
        });
        const mergedContainerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { container } = props;
            if (container)
                return container();
            return containerRef.value;
        });
        const mergedContentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { content } = props;
            if (content)
                return content();
            return contentRef.value;
        });
        const activateState = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.useReactivated)(() => {
            // Only restore for builtin container & content
            if (!props.container) {
                // remount
                scrollTo({
                    top: containerScrollTopRef.value,
                    left: containerScrollLeftRef.value
                });
            }
        });
        // methods
        const handleContentResize = () => {
            if (activateState.isDeactivated)
                return;
            sync();
        };
        const handleContainerResize = (e) => {
            if (activateState.isDeactivated)
                return;
            const { onResize } = props;
            if (onResize)
                onResize(e);
            sync();
        };
        const scrollTo = (options, y) => {
            if (!props.scrollable)
                return;
            if (typeof options === 'number') {
                scrollToPosition(y !== null && y !== void 0 ? y : 0, options, 0, false, 'auto');
                return;
            }
            const { left, top, index, elSize, position, behavior, el, debounce = true } = options;
            if (left !== undefined || top !== undefined) {
                scrollToPosition(left !== null && left !== void 0 ? left : 0, top !== null && top !== void 0 ? top : 0, 0, false, behavior);
            }
            if (el !== undefined) {
                scrollToPosition(0, el.offsetTop, el.offsetHeight, debounce, behavior);
            }
            else if (index !== undefined && elSize !== undefined) {
                scrollToPosition(0, index * elSize, elSize, debounce, behavior);
            }
            else if (position === 'bottom') {
                scrollToPosition(0, Number.MAX_SAFE_INTEGER, 0, false, behavior);
            }
            else if (position === 'top') {
                scrollToPosition(0, 0, 0, false, behavior);
            }
        };
        const scrollBy = (options, y) => {
            if (!props.scrollable)
                return;
            const { value: container } = mergedContainerRef;
            if (!container)
                return;
            if (typeof options === 'object') {
                container.scrollBy(options);
            }
            else {
                container.scrollBy(options, y || 0);
            }
        };
        function scrollToPosition(left, top, elSize, debounce, behavior) {
            const { value: container } = mergedContainerRef;
            if (!container)
                return;
            if (debounce) {
                const { scrollTop, offsetHeight } = container;
                if (top > scrollTop) {
                    if (top + elSize <= scrollTop + offsetHeight) {
                        // do nothing
                    }
                    else {
                        container.scrollTo({
                            left,
                            top: top + elSize - offsetHeight,
                            behavior
                        });
                    }
                    return;
                }
            }
            container.scrollTo({
                left,
                top,
                behavior
            });
        }
        function handleMouseEnterWrapper() {
            showXBar();
            showYBar();
            sync();
        }
        function handleMouseLeaveWrapper() {
            hideBar();
        }
        function hideBar() {
            hideYBar();
            hideXBar();
        }
        function hideYBar() {
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            yBarVanishTimerId = window.setTimeout(() => {
                isShowYBarRef.value = false;
            }, props.duration);
        }
        function hideXBar() {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            xBarVanishTimerId = window.setTimeout(() => {
                isShowXBarRef.value = false;
            }, props.duration);
        }
        function showXBar() {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            isShowXBarRef.value = true;
        }
        function showYBar() {
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            isShowYBarRef.value = true;
        }
        function handleScroll(e) {
            const { onScroll } = props;
            if (onScroll)
                onScroll(e);
            syncScrollState();
        }
        function syncScrollState() {
            // only collect scroll state, do not trigger any dom event
            const { value: container } = mergedContainerRef;
            if (container) {
                containerScrollTopRef.value = container.scrollTop;
                containerScrollLeftRef.value =
                    container.scrollLeft * ((rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value) ? -1 : 1);
            }
        }
        function syncPositionState() {
            // only collect position state, do not trigger any dom event
            // Don't use getClientBoundingRect because element may be scale transformed
            const { value: content } = mergedContentRef;
            if (content) {
                contentHeightRef.value = content.offsetHeight;
                contentWidthRef.value = content.offsetWidth;
            }
            const { value: container } = mergedContainerRef;
            if (container) {
                containerHeightRef.value = container.offsetHeight;
                containerWidthRef.value = container.offsetWidth;
            }
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                xRailSizeRef.value = xRailEl.offsetWidth;
            }
            if (yRailEl) {
                yRailSizeRef.value = yRailEl.offsetHeight;
            }
        }
        /**
         * Sometimes there's only one element that we can scroll,
         * For example for textarea, there won't be a content element.
         */
        function syncUnifiedContainer() {
            const { value: container } = mergedContainerRef;
            if (container) {
                containerScrollTopRef.value = container.scrollTop;
                containerScrollLeftRef.value =
                    container.scrollLeft * ((rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value) ? -1 : 1);
                containerHeightRef.value = container.offsetHeight;
                containerWidthRef.value = container.offsetWidth;
                contentHeightRef.value = container.scrollHeight;
                contentWidthRef.value = container.scrollWidth;
            }
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                xRailSizeRef.value = xRailEl.offsetWidth;
            }
            if (yRailEl) {
                yRailSizeRef.value = yRailEl.offsetHeight;
            }
        }
        function sync() {
            if (!props.scrollable)
                return;
            if (props.useUnifiedContainer) {
                syncUnifiedContainer();
            }
            else {
                syncPositionState();
                syncScrollState();
            }
        }
        function isMouseUpAway(e) {
            var _a;
            return !((_a = wrapperRef.value) === null || _a === void 0 ? void 0 : _a.contains((0,seemly__WEBPACK_IMPORTED_MODULE_6__.getPreciseEventTarget)(e)));
        }
        function handleXScrollMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();
            xBarPressed = true;
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mousemove', window, handleXScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mouseup', window, handleXScrollMouseUp, true);
            memoXLeft = containerScrollLeftRef.value;
            memoMouseX = (rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value)
                ? window.innerWidth - e.clientX
                : e.clientX;
        }
        function handleXScrollMouseMove(e) {
            if (!xBarPressed)
                return;
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xBarSize } = xBarSizeRef;
            if (containerWidth === null || contentWidth === null)
                return;
            const dX = (rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value)
                ? window.innerWidth - e.clientX - memoMouseX
                : e.clientX - memoMouseX;
            const dScrollLeft = (dX * (contentWidth - containerWidth)) / (containerWidth - xBarSize);
            const toScrollLeftUpperBound = contentWidth - containerWidth;
            let toScrollLeft = memoXLeft + dScrollLeft;
            toScrollLeft = Math.min(toScrollLeftUpperBound, toScrollLeft);
            toScrollLeft = Math.max(toScrollLeft, 0);
            const { value: container } = mergedContainerRef;
            if (container) {
                container.scrollLeft = toScrollLeft * ((rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value) ? -1 : 1);
                const { internalOnUpdateScrollLeft } = props;
                if (internalOnUpdateScrollLeft)
                    internalOnUpdateScrollLeft(toScrollLeft);
            }
        }
        function handleXScrollMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mousemove', window, handleXScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mouseup', window, handleXScrollMouseUp, true);
            xBarPressed = false;
            sync();
            if (isMouseUpAway(e)) {
                hideBar();
            }
        }
        function handleYScrollMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();
            yBarPressed = true;
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mousemove', window, handleYScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mouseup', window, handleYScrollMouseUp, true);
            memoYTop = containerScrollTopRef.value;
            memoMouseY = e.clientY;
        }
        function handleYScrollMouseMove(e) {
            if (!yBarPressed)
                return;
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yBarSize } = yBarSizeRef;
            if (containerHeight === null || contentHeight === null)
                return;
            const dY = e.clientY - memoMouseY;
            const dScrollTop = (dY * (contentHeight - containerHeight)) / (containerHeight - yBarSize);
            const toScrollTopUpperBound = contentHeight - containerHeight;
            let toScrollTop = memoYTop + dScrollTop;
            toScrollTop = Math.min(toScrollTopUpperBound, toScrollTop);
            toScrollTop = Math.max(toScrollTop, 0);
            const { value: container } = mergedContainerRef;
            if (container) {
                container.scrollTop = toScrollTop;
            }
        }
        function handleYScrollMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mousemove', window, handleYScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mouseup', window, handleYScrollMouseUp, true);
            yBarPressed = false;
            sync();
            if (isMouseUpAway(e)) {
                hideBar();
            }
        }
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
            const { value: needXBar } = needXBarRef;
            const { value: needYBar } = needYBarRef;
            const { value: mergedClsPrefix } = mergedClsPrefixRef;
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                if (!needXBar) {
                    xRailEl.classList.add(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
                else {
                    xRailEl.classList.remove(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
            }
            if (yRailEl) {
                if (!needYBar) {
                    yRailEl.classList.add(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
                else {
                    yRailEl.classList.remove(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
            }
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            // if container exist, it always can't be resolved when scrollbar is mounted
            // for example:
            // - component
            //   - scrollbar
            //     - inner
            // if you pass inner to scrollbar, you may use a ref inside component
            // however, when scrollbar is mounted, ref is not ready at component
            // you need to init by yourself
            if (props.container)
                return;
            sync();
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mousemove', window, handleYScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mouseup', window, handleYScrollMouseUp, true);
        });
        const themeRef = (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('Scrollbar', '-scrollbar', _styles_index_cssr__WEBPACK_IMPORTED_MODULE_8__["default"], _styles__WEBPACK_IMPORTED_MODULE_9__["default"], props, mergedClsPrefixRef);
        const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { common: { cubicBezierEaseInOut, scrollbarBorderRadius, scrollbarHeight, scrollbarWidth }, self: { color, colorHover } } = themeRef.value;
            return {
                '--n-scrollbar-bezier': cubicBezierEaseInOut,
                '--n-scrollbar-color': color,
                '--n-scrollbar-color-hover': colorHover,
                '--n-scrollbar-border-radius': scrollbarBorderRadius,
                '--n-scrollbar-width': scrollbarWidth,
                '--n-scrollbar-height': scrollbarHeight
            };
        });
        const themeClassHandle = inlineThemeDisabled
            ? (0,_mixins__WEBPACK_IMPORTED_MODULE_10__.useThemeClass)('scrollbar', undefined, cssVarsRef, props)
            : undefined;
        const exposedMethods = {
            scrollTo,
            scrollBy,
            sync,
            syncUnifiedContainer,
            handleMouseEnterWrapper,
            handleMouseLeaveWrapper
        };
        return Object.assign(Object.assign({}, exposedMethods), { mergedClsPrefix: mergedClsPrefixRef, rtlEnabled: rtlEnabledRef, containerScrollTop: containerScrollTopRef, wrapperRef,
            containerRef,
            contentRef,
            yRailRef,
            xRailRef, needYBar: needYBarRef, needXBar: needXBarRef, yBarSizePx: yBarSizePxRef, xBarSizePx: xBarSizePxRef, yBarTopPx: yBarTopPxRef, xBarLeftPx: xBarLeftPxRef, isShowXBar: mergedShowXBarRef, isShowYBar: mergedShowYBarRef, isIos,
            handleScroll,
            handleContentResize,
            handleContainerResize,
            handleYScrollMouseDown,
            handleXScrollMouseDown, cssVars: inlineThemeDisabled ? undefined : cssVarsRef, themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass, onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender });
    },
    render() {
        var _a;
        const { $slots, mergedClsPrefix, triggerDisplayManually, rtlEnabled, internalHoistYRail } = this;
        if (!this.scrollable)
            return (_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots);
        const triggerIsNone = this.trigger === 'none';
        const createYRail = () => {
            return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "yRailRef", class: [
                    `${mergedClsPrefix}-scrollbar-rail`,
                    `${mergedClsPrefix}-scrollbar-rail--vertical`
                ], "data-scrollbar-rail": true, style: this.verticalRailStyle, "aria-hidden": true }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)((triggerIsNone ? _utils__WEBPACK_IMPORTED_MODULE_11__.Wrapper : vue__WEBPACK_IMPORTED_MODULE_0__.Transition), triggerIsNone ? null : { name: 'fade-in-transition' }, {
                default: () => this.needYBar && this.isShowYBar && !this.isIos ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-scrollbar-rail__scrollbar`, style: {
                        height: this.yBarSizePx,
                        top: this.yBarTopPx
                    }, onMousedown: this.handleYScrollMouseDown })) : null
            })));
        };
        const createChildren = () => {
            var _a, _b;
            (_a = this.onRender) === null || _a === void 0 ? void 0 : _a.call(this);
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', (0,vue__WEBPACK_IMPORTED_MODULE_0__.mergeProps)(this.$attrs, {
                role: 'none',
                ref: 'wrapperRef',
                class: [
                    `${mergedClsPrefix}-scrollbar`,
                    this.themeClass,
                    rtlEnabled && `${mergedClsPrefix}-scrollbar--rtl`
                ],
                style: this.cssVars,
                onMouseenter: triggerDisplayManually
                    ? undefined
                    : this.handleMouseEnterWrapper,
                onMouseleave: triggerDisplayManually
                    ? undefined
                    : this.handleMouseLeaveWrapper
            }), [
                this.container ? ((_b = $slots.default) === null || _b === void 0 ? void 0 : _b.call($slots)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { role: "none", ref: "containerRef", class: [
                        `${mergedClsPrefix}-scrollbar-container`,
                        this.containerClass
                    ], style: this.containerStyle, onScroll: this.handleScroll, onWheel: this.onWheel },
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_12__["default"], { onResize: this.handleContentResize }, {
                        default: () => ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "contentRef", role: "none", style: [
                                {
                                    width: this.xScrollable ? 'fit-content' : null
                                },
                                this.contentStyle
                            ], class: [
                                `${mergedClsPrefix}-scrollbar-content`,
                                this.contentClass
                            ] }, $slots))
                    }))),
                internalHoistYRail ? null : createYRail(),
                this.xScrollable && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "xRailRef", class: [
                        `${mergedClsPrefix}-scrollbar-rail`,
                        `${mergedClsPrefix}-scrollbar-rail--horizontal`
                    ], style: this.horizontalRailStyle, "data-scrollbar-rail": true, "aria-hidden": true }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)((triggerIsNone ? _utils__WEBPACK_IMPORTED_MODULE_11__.Wrapper : vue__WEBPACK_IMPORTED_MODULE_0__.Transition), triggerIsNone ? null : { name: 'fade-in-transition' }, {
                    default: () => this.needXBar && this.isShowXBar && !this.isIos ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-scrollbar-rail__scrollbar`, style: {
                            width: this.xBarSizePx,
                            right: rtlEnabled ? this.xBarLeftPx : undefined,
                            left: rtlEnabled ? undefined : this.xBarLeftPx
                        }, onMousedown: this.handleXScrollMouseDown })) : null
                })))
            ]);
        };
        const scrollbarNode = this.container ? (createChildren()) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_12__["default"], { onResize: this.handleContainerResize }, {
            default: createChildren
        }));
        if (internalHoistYRail) {
            return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                scrollbarNode,
                createYRail()));
        }
        else {
            return scrollbarNode;
        }
    }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Scrollbar);
const XScrollbar = Scrollbar;


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/scrollbar/src/styles/index.cssr.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/scrollbar/src/styles/index.cssr.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _styles_transitions_fade_in_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../_styles/transitions/fade-in.cssr */ "./node_modules/naive-ui/es/_styles/transitions/fade-in.cssr.js");


// vars:
// --n-scrollbar-bezier
// --n-scrollbar-color
// --n-scrollbar-color-hover
// --n-scrollbar-width
// --n-scrollbar-height
// --n-scrollbar-border-radius
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar', `
 overflow: hidden;
 position: relative;
 z-index: auto;
 height: 100%;
 width: 100%;
`, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar-container', `
 width: 100%;
 overflow: scroll;
 height: 100%;
 max-height: inherit;
 scrollbar-width: none;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', `
 width: 0;
 height: 0;
 display: none;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar-content', `
 box-sizing: border-box;
 min-width: 100%;
 `)])])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>, +', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar-rail', `
 position: absolute;
 pointer-events: none;
 user-select: none;
 -webkit-user-select: none;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('horizontal', `
 left: 2px;
 right: 2px;
 bottom: 4px;
 height: var(--n-scrollbar-height);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', `
 height: var(--n-scrollbar-height);
 border-radius: var(--n-scrollbar-border-radius);
 right: 0;
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('vertical', `
 right: 4px;
 top: 2px;
 bottom: 2px;
 width: var(--n-scrollbar-width);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', `
 width: var(--n-scrollbar-width);
 border-radius: var(--n-scrollbar-border-radius);
 bottom: 0;
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', {
  pointerEvents: 'none'
})])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', `
 position: absolute;
 cursor: pointer;
 pointer-events: all;
 background-color: var(--n-scrollbar-color);
 transition: background-color .2s var(--n-scrollbar-bezier);
 `, [(0,_styles_transitions_fade_in_cssr__WEBPACK_IMPORTED_MODULE_1__.fadeInTransition)(), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', {
  backgroundColor: 'var(--n-scrollbar-color-hover)'
})])])])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.js":
/*!*************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/select-menu/src/interface.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   internalSelectionMenuBodyInjectionKey: () => (/* binding */ internalSelectionMenuBodyInjectionKey),
/* harmony export */   internalSelectionMenuInjectionKey: () => (/* binding */ internalSelectionMenuInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const internalSelectionMenuInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-internal-select-menu');
const internalSelectionMenuBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-internal-select-menu-body');


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.js":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-css-vars-class.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useThemeClass: () => (/* binding */ useThemeClass)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var css_render__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! css-render */ "./node_modules/@emotion/hash/dist/hash.browser.esm.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _config_provider_src_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../config-provider/src/context */ "./node_modules/naive-ui/es/config-provider/src/context.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../_utils */ "./node_modules/naive-ui/es/_utils/naive/warn.js");
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");






function useThemeClass(componentName, hashRef, cssVarsRef, props) {
    var _a;
    if (!cssVarsRef)
        (0,_utils__WEBPACK_IMPORTED_MODULE_1__.throwError)('useThemeClass', 'cssVarsRef is not passed');
    const mergedThemeHashRef = (_a = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context__WEBPACK_IMPORTED_MODULE_2__.configProviderInjectionKey, null)) === null || _a === void 0 ? void 0 : _a.mergedThemeHashRef;
    const themeClassRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_3__.useSsrAdapter)();
    let renderCallback;
    const hashClassPrefix = `__${componentName}`;
    const mountStyle = () => {
        let finalThemeHash = hashClassPrefix;
        const hashValue = hashRef ? hashRef.value : undefined;
        const themeHash = mergedThemeHashRef === null || mergedThemeHashRef === void 0 ? void 0 : mergedThemeHashRef.value;
        if (themeHash)
            finalThemeHash += '-' + themeHash;
        if (hashValue)
            finalThemeHash += '-' + hashValue;
        const { themeOverrides, builtinThemeOverrides } = props;
        if (themeOverrides) {
            finalThemeHash += '-' + (0,css_render__WEBPACK_IMPORTED_MODULE_4__["default"])(JSON.stringify(themeOverrides));
        }
        if (builtinThemeOverrides) {
            finalThemeHash += '-' + (0,css_render__WEBPACK_IMPORTED_MODULE_4__["default"])(JSON.stringify(builtinThemeOverrides));
        }
        themeClassRef.value = finalThemeHash;
        renderCallback = () => {
            const cssVars = cssVarsRef.value;
            let style = '';
            for (const key in cssVars) {
                style += `${key}: ${cssVars[key]};`;
            }
            (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_5__.c)(`.${finalThemeHash}`, style).mount({
                id: finalThemeHash,
                ssr: ssrAdapter
            });
            renderCallback = undefined;
        };
    };
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        mountStyle();
    });
    return {
        themeClass: themeClassRef,
        onRender: () => {
            renderCallback === null || renderCallback === void 0 ? void 0 : renderCallback();
        }
    };
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-form-item.js":
/*!***********************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-form-item.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFormItem),
/* harmony export */   formItemInjectionKey: () => (/* binding */ formItemInjectionKey)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../_utils */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");


const formItemInjectionKey = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.createInjectionKey)('n-form-item');
function useFormItem(props, { defaultSize = 'medium', mergedSize, mergedDisabled } = {}) {
    const NFormItem = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(formItemInjectionKey, null);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(formItemInjectionKey, null);
    const mergedSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(mergedSize
        ? () => mergedSize(NFormItem)
        : () => {
            const { size } = props;
            if (size)
                return size;
            if (NFormItem) {
                const { mergedSize } = NFormItem;
                if (mergedSize.value !== undefined) {
                    return mergedSize.value;
                }
            }
            return defaultSize;
        });
    const mergedDisabledRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(mergedDisabled
        ? () => mergedDisabled(NFormItem)
        : () => {
            const { disabled } = props;
            if (disabled !== undefined) {
                return disabled;
            }
            if (NFormItem) {
                return NFormItem.disabled.value;
            }
            return false;
        });
    const mergedStatusRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        const { status } = props;
        if (status)
            return status;
        return NFormItem === null || NFormItem === void 0 ? void 0 : NFormItem.mergedValidationStatus.value;
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
        if (NFormItem) {
            NFormItem.restoreValidation();
        }
    });
    return {
        mergedSizeRef,
        mergedDisabledRef,
        mergedStatusRef,
        nTriggerFormBlur() {
            if (NFormItem) {
                NFormItem.handleContentBlur();
            }
        },
        nTriggerFormChange() {
            if (NFormItem) {
                NFormItem.handleContentChange();
            }
        },
        nTriggerFormFocus() {
            if (NFormItem) {
                NFormItem.handleContentFocus();
            }
        },
        nTriggerFormInput() {
            if (NFormItem) {
                NFormItem.handleContentInput();
            }
        }
    };
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-locale.js":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-locale.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useLocale)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _locales__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../locales */ "./node_modules/naive-ui/es/locales/common/enUS.js");
/* harmony import */ var _locales__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../locales */ "./node_modules/naive-ui/es/locales/date/enUS.js");
/* harmony import */ var _config_provider_src_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../config-provider/src/context */ "./node_modules/naive-ui/es/config-provider/src/context.js");



function useLocale(ns) {
    const { mergedLocaleRef, mergedDateLocaleRef } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context__WEBPACK_IMPORTED_MODULE_1__.configProviderInjectionKey, null) || {};
    const localeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        var _a, _b;
        return (_b = (_a = mergedLocaleRef === null || mergedLocaleRef === void 0 ? void 0 : mergedLocaleRef.value) === null || _a === void 0 ? void 0 : _a[ns]) !== null && _b !== void 0 ? _b : _locales__WEBPACK_IMPORTED_MODULE_2__["default"][ns];
    });
    const dateLocaleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        var _a;
        return (_a = mergedDateLocaleRef === null || mergedDateLocaleRef === void 0 ? void 0 : mergedDateLocaleRef.value) !== null && _a !== void 0 ? _a : _locales__WEBPACK_IMPORTED_MODULE_3__["default"];
    });
    return {
        dateLocaleRef,
        localeRef
    };
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-rtl.js":
/*!*****************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-rtl.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useRtl: () => (/* binding */ useRtl)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var css_render__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! css-render */ "./node_modules/css-render/esm/exists.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./common */ "./node_modules/naive-ui/es/_mixins/common.js");




function useRtl(mountId, rtlStateRef, clsPrefixRef) {
    if (!rtlStateRef)
        return undefined;
    const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_1__.useSsrAdapter)();
    const componentRtlStateRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        const { value: rtlState } = rtlStateRef;
        if (!rtlState) {
            return undefined;
        }
        const componentRtlState = rtlState[mountId];
        if (!componentRtlState) {
            return undefined;
        }
        return componentRtlState;
    });
    const mountStyle = () => {
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
            const { value: clsPrefix } = clsPrefixRef;
            const id = `${clsPrefix}${mountId}Rtl`;
            // if it already exists, we only need to watch clsPrefix, although in most
            // of time it's unnecessary... However we can at least listen less
            // handlers, which is great.
            if ((0,css_render__WEBPACK_IMPORTED_MODULE_2__.exists)(id, ssrAdapter))
                return;
            const { value: componentRtlState } = componentRtlStateRef;
            if (!componentRtlState)
                return;
            componentRtlState.style.mount({
                id,
                head: true,
                anchorMetaName: _common__WEBPACK_IMPORTED_MODULE_3__.cssrAnchorMetaName,
                props: {
                    bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
                },
                ssr: ssrAdapter
            });
        });
    };
    if (ssrAdapter) {
        mountStyle();
    }
    else {
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeMount)(mountStyle);
    }
    return componentRtlStateRef;
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-style.js":
/*!*******************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-style.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useStyle)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _config_provider_src_context__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../config-provider/src/context */ "./node_modules/naive-ui/es/config-provider/src/context.js");
/* harmony import */ var _styles_global_index_cssr__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../_styles/global/index.cssr */ "./node_modules/naive-ui/es/_styles/global/index.cssr.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../_utils */ "./node_modules/naive-ui/es/_utils/naive/warn.js");
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./common */ "./node_modules/naive-ui/es/_mixins/common.js");






function useStyle(mountId, style, clsPrefixRef) {
    if (!style) {
        if (true)
            (0,_utils__WEBPACK_IMPORTED_MODULE_1__.throwError)('use-style', 'No style is specified.');
        return;
    }
    const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_2__.useSsrAdapter)();
    const NConfigProvider = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context__WEBPACK_IMPORTED_MODULE_3__.configProviderInjectionKey, null);
    const mountStyle = () => {
        const clsPrefix = clsPrefixRef === null || clsPrefixRef === void 0 ? void 0 : clsPrefixRef.value;
        style.mount({
            id: clsPrefix === undefined ? mountId : clsPrefix + mountId,
            head: true,
            anchorMetaName: _common__WEBPACK_IMPORTED_MODULE_4__.cssrAnchorMetaName,
            props: {
                bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
            },
            ssr: ssrAdapter
        });
        if (!(NConfigProvider === null || NConfigProvider === void 0 ? void 0 : NConfigProvider.preflightStyleDisabled)) {
            _styles_global_index_cssr__WEBPACK_IMPORTED_MODULE_5__["default"].mount({
                id: 'n-global',
                head: true,
                anchorMetaName: _common__WEBPACK_IMPORTED_MODULE_4__.cssrAnchorMetaName,
                ssr: ssrAdapter
            });
        }
    };
    if (ssrAdapter) {
        mountStyle();
    }
    else {
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeMount)(mountStyle);
    }
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fadeInScaleUpTransition: () => (/* binding */ fadeInScaleUpTransition)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _common_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/_common */ "./node_modules/naive-ui/es/_styles/common/_common.js");


const {
  cubicBezierEaseIn,
  cubicBezierEaseOut
} = _common_common__WEBPACK_IMPORTED_MODULE_0__["default"];
function fadeInScaleUpTransition({
  transformOrigin = 'inherit',
  duration = '.2s',
  enterScale = '.9',
  originalTransform = '',
  originalTransition = ''
} = {}) {
  return [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-leave-active', {
    transformOrigin,
    transition: `opacity ${duration} ${cubicBezierEaseIn}, transform ${duration} ${cubicBezierEaseIn} ${originalTransition && ',' + originalTransition}`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-enter-active', {
    transformOrigin,
    transition: `opacity ${duration} ${cubicBezierEaseOut}, transform ${duration} ${cubicBezierEaseOut} ${originalTransition && ',' + originalTransition}`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-enter-from, &.fade-in-scale-up-transition-leave-to', {
    opacity: 0,
    transform: `${originalTransform} scale(${enterScale})`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-leave-from, &.fade-in-scale-up-transition-enter-to', {
    opacity: 1,
    transform: `${originalTransform} scale(1)`
  })];
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_styles/transitions/fade-in.cssr.js":
/*!**********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_styles/transitions/fade-in.cssr.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fadeInTransition: () => (/* binding */ fadeInTransition)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _common_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/_common */ "./node_modules/naive-ui/es/_styles/common/_common.js");


const {
  cubicBezierEaseInOut
} = _common_common__WEBPACK_IMPORTED_MODULE_0__["default"];
function fadeInTransition({
  name = 'fade-in',
  enterDuration = '0.2s',
  leaveDuration = '0.2s',
  enterCubicBezier = cubicBezierEaseInOut,
  leaveCubicBezier = cubicBezierEaseInOut
} = {}) {
  return [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-enter-active`, {
    transition: `all ${enterDuration} ${enterCubicBezier}!important`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-leave-active`, {
    transition: `all ${leaveDuration} ${leaveCubicBezier}!important`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-enter-from, &.${name}-transition-leave-to`, {
    opacity: 0
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-leave-from, &.${name}-transition-enter-to`, {
    opacity: 1
  })];
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.js":
/*!**************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_styles/transitions/icon-switch.cssr.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   iconSwitchTransition: () => (/* binding */ iconSwitchTransition)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _common_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/_common */ "./node_modules/naive-ui/es/_styles/common/_common.js");


const {
  cubicBezierEaseInOut
} = _common_common__WEBPACK_IMPORTED_MODULE_0__["default"];
function iconSwitchTransition({
  originalTransform = '',
  left = 0,
  top = 0,
  transition = `all .3s ${cubicBezierEaseInOut} !important`
} = {}) {
  return [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.icon-switch-transition-enter-from, &.icon-switch-transition-leave-to', {
    transform: originalTransform + ' scale(0.75)',
    left,
    top,
    opacity: 0
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.icon-switch-transition-enter-to, &.icon-switch-transition-leave-from', {
    transform: `scale(1) ${originalTransform}`,
    left,
    top,
    opacity: 1
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.icon-switch-transition-enter-active, &.icon-switch-transition-leave-active', {
    transformOrigin: 'center',
    position: 'absolute',
    left,
    top,
    transition
  })];
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.js":
/*!***********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useAdjustedTo: () => (/* binding */ useAdjustedTo)
/* harmony export */ });
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _internal_select_menu_src_interface__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_internal/select-menu/src/interface */ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.js");
/* harmony import */ var _modal_src_interface__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../modal/src/interface */ "./node_modules/naive-ui/es/modal/src/interface.js");
/* harmony import */ var _drawer_src_interface__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../drawer/src/interface */ "./node_modules/naive-ui/es/drawer/src/interface.js");
/* harmony import */ var _popover_src_interface__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../popover/src/interface */ "./node_modules/naive-ui/es/popover/src/interface.js");







const teleportDisabled = '__disabled__';
function useAdjustedTo(props) {
    const modal = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_modal_src_interface__WEBPACK_IMPORTED_MODULE_1__.modalBodyInjectionKey, null);
    const drawer = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_drawer_src_interface__WEBPACK_IMPORTED_MODULE_2__.drawerBodyInjectionKey, null);
    const popover = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_popover_src_interface__WEBPACK_IMPORTED_MODULE_3__.popoverBodyInjectionKey, null);
    const selectMenu = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_internal_select_menu_src_interface__WEBPACK_IMPORTED_MODULE_4__.internalSelectionMenuBodyInjectionKey, null);
    const fullscreenElementRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    if (typeof document !== 'undefined') {
        fullscreenElementRef.value = document.fullscreenElement;
        const handleFullscreenChange = () => {
            fullscreenElementRef.value = document.fullscreenElement;
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_5__.on)('fullscreenchange', document, handleFullscreenChange);
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_5__.off)('fullscreenchange', document, handleFullscreenChange);
        });
    }
    return (0,vooks__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
        var _a;
        const { to } = props;
        if (to !== undefined) {
            if (to === false)
                return teleportDisabled;
            if (to === true)
                return fullscreenElementRef.value || 'body';
            return to;
        }
        if (modal === null || modal === void 0 ? void 0 : modal.value) {
            return (_a = modal.value.$el) !== null && _a !== void 0 ? _a : modal.value;
        }
        if (drawer === null || drawer === void 0 ? void 0 : drawer.value)
            return drawer.value;
        if (popover === null || popover === void 0 ? void 0 : popover.value)
            return popover.value;
        if (selectMenu === null || selectMenu === void 0 ? void 0 : selectMenu.value)
            return selectMenu.value;
        return to !== null && to !== void 0 ? to : (fullscreenElementRef.value || 'body');
    });
}
// teleport disabled key
useAdjustedTo.tdkey = teleportDisabled;
useAdjustedTo.propTo = {
    type: [String, Object, Boolean],
    default: undefined
};



/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/composable/use-reactivated.js":
/*!***********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/composable/use-reactivated.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useReactivated: () => (/* binding */ useReactivated)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function useReactivated(callback) {
    const isDeactivatedRef = { isDeactivated: false };
    let activateStateInitialized = false;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onActivated)(() => {
        isDeactivatedRef.isDeactivated = false;
        if (!activateStateInitialized) {
            activateStateInitialized = true;
            return;
        }
        callback();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onDeactivated)(() => {
        isDeactivatedRef.isDeactivated = true;
        if (!activateStateInitialized) {
            activateStateInitialized = true;
        }
    });
    return isDeactivatedRef;
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/css/color-to-class.js":
/*!***************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/css/color-to-class.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   color2Class: () => (/* binding */ color2Class)
/* harmony export */ });
function color2Class(color) {
    return color.replace(/#|\(|\)|,|\s/g, '_');
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/call.js":
/*!*****************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/call.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   call: () => (/* binding */ call)
/* harmony export */ });
function call(funcs, ...args) {
    if (Array.isArray(funcs)) {
        funcs.forEach((func) => call(func, ...args));
    }
    else
        return funcs(...args);
}



/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.js":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/resolve-slot.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isSlotEmpty: () => (/* binding */ isSlotEmpty),
/* harmony export */   resolveSlot: () => (/* binding */ resolveSlot),
/* harmony export */   resolveSlotWithProps: () => (/* binding */ resolveSlotWithProps),
/* harmony export */   resolveWrappedSlot: () => (/* binding */ resolveWrappedSlot),
/* harmony export */   resolveWrappedSlotWithProps: () => (/* binding */ resolveWrappedSlotWithProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function ensureValidVNode(vnodes) {
    return vnodes.some((child) => {
        if (!(0,vue__WEBPACK_IMPORTED_MODULE_0__.isVNode)(child)) {
            return true;
        }
        if (child.type === vue__WEBPACK_IMPORTED_MODULE_0__.Comment) {
            return false;
        }
        if (child.type === vue__WEBPACK_IMPORTED_MODULE_0__.Fragment &&
            !ensureValidVNode(child.children)) {
            return false;
        }
        return true;
    })
        ? vnodes
        : null;
}
/**
 * We shouldn't use the following functions with slot flags `_: 1, 2, 3`
 */
function resolveSlot(slot, fallback) {
    return (slot && ensureValidVNode(slot())) || fallback();
}
function resolveSlotWithProps(slot, props, fallback) {
    return (slot && ensureValidVNode(slot(props))) || fallback(props);
}
/**
 * Resolve slot with wrapper if content exists, no fallback
 */
function resolveWrappedSlot(slot, wrapper) {
    const children = slot && ensureValidVNode(slot());
    return wrapper(children || null);
}
/*
 * Resolve slot with wrapper if content exists, no fallback
 */
function resolveWrappedSlotWithProps(slot, props, wrapper) {
    const children = slot && ensureValidVNode(slot(props));
    return wrapper(children || null);
}
function isSlotEmpty(slot) {
    return !(slot && ensureValidVNode(slot()));
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/wrapper.js":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/wrapper.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Wrapper: () => (/* binding */ Wrapper)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

const Wrapper = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    render() {
        var _a, _b;
        return (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a);
    }
});


/***/ }),

/***/ "./node_modules/naive-ui/es/drawer/src/interface.js":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/drawer/src/interface.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   drawerBodyInjectionKey: () => (/* binding */ drawerBodyInjectionKey),
/* harmony export */   drawerInjectionKey: () => (/* binding */ drawerInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const drawerBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-drawer-body');
const drawerInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-drawer');


/***/ }),

/***/ "./node_modules/naive-ui/es/locales/common/enUS.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/locales/common/enUS.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const enUS = {
    name: 'en-US',
    global: {
        undo: 'Undo',
        redo: 'Redo',
        confirm: 'Confirm',
        clear: 'Clear'
    },
    Popconfirm: {
        positiveText: 'Confirm',
        negativeText: 'Cancel'
    },
    Cascader: {
        placeholder: 'Please Select',
        loading: 'Loading',
        loadingRequiredMessage: (label) => `Please load all ${label}'s descendants before checking it.`
    },
    Time: {
        dateFormat: 'yyyy-MM-dd',
        dateTimeFormat: 'yyyy-MM-dd HH:mm:ss'
    },
    DatePicker: {
        yearFormat: 'yyyy',
        monthFormat: 'MMM',
        dayFormat: 'eeeeee',
        yearTypeFormat: 'yyyy',
        monthTypeFormat: 'yyyy-MM',
        dateFormat: 'yyyy-MM-dd',
        dateTimeFormat: 'yyyy-MM-dd HH:mm:ss',
        quarterFormat: 'yyyy-qqq',
        clear: 'Clear',
        now: 'Now',
        confirm: 'Confirm',
        selectTime: 'Select Time',
        selectDate: 'Select Date',
        datePlaceholder: 'Select Date',
        datetimePlaceholder: 'Select Date and Time',
        monthPlaceholder: 'Select Month',
        yearPlaceholder: 'Select Year',
        quarterPlaceholder: 'Select Quarter',
        startDatePlaceholder: 'Start Date',
        endDatePlaceholder: 'End Date',
        startDatetimePlaceholder: 'Start Date and Time',
        endDatetimePlaceholder: 'End Date and Time',
        startMonthPlaceholder: 'Start Month',
        endMonthPlaceholder: 'End Month',
        monthBeforeYear: true,
        firstDayOfWeek: 6,
        today: 'Today'
    },
    DataTable: {
        checkTableAll: 'Select all in the table',
        uncheckTableAll: 'Unselect all in the table',
        confirm: 'Confirm',
        clear: 'Clear'
    },
    LegacyTransfer: {
        sourceTitle: 'Source',
        targetTitle: 'Target'
    },
    Transfer: {
        selectAll: 'Select all',
        unselectAll: 'Unselect all',
        clearAll: 'Clear',
        total: (num) => `Total ${num} items`,
        selected: (num) => `${num} items selected`
    },
    Empty: {
        description: 'No Data'
    },
    Select: {
        placeholder: 'Please Select'
    },
    TimePicker: {
        placeholder: 'Select Time',
        positiveText: 'OK',
        negativeText: 'Cancel',
        now: 'Now'
    },
    Pagination: {
        goto: 'Goto',
        selectionSuffix: 'page'
    },
    DynamicTags: {
        add: 'Add'
    },
    Log: {
        loading: 'Loading'
    },
    Input: {
        placeholder: 'Please Input'
    },
    InputNumber: {
        placeholder: 'Please Input'
    },
    DynamicInput: {
        create: 'Create'
    },
    ThemeEditor: {
        title: 'Theme Editor',
        clearAllVars: 'Clear All Variables',
        clearSearch: 'Clear Search',
        filterCompName: 'Filter Component Name',
        filterVarName: 'Filter Variable Name',
        import: 'Import',
        export: 'Export',
        restore: 'Reset to Default'
    },
    Image: {
        tipPrevious: 'Previous picture (←)',
        tipNext: 'Next picture (→)',
        tipCounterclockwise: 'Counterclockwise',
        tipClockwise: 'Clockwise',
        tipZoomOut: 'Zoom out',
        tipZoomIn: 'Zoom in',
        tipClose: 'Close (Esc)',
        // TODO: translation
        tipOriginalSize: 'Zoom to original size'
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (enUS);


/***/ }),

/***/ "./node_modules/naive-ui/es/locales/date/enUS.js":
/*!*******************************************************!*\
  !*** ./node_modules/naive-ui/es/locales/date/enUS.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var date_fns_esm_locale_en_US__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! date-fns/esm/locale/en-US */ "./node_modules/date-fns/esm/locale/en-US/index.js");

const dateEnUs = {
    name: 'en-US',
    locale: date_fns_esm_locale_en_US__WEBPACK_IMPORTED_MODULE_0__["default"]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dateEnUs);


/***/ }),

/***/ "./node_modules/naive-ui/es/modal/src/interface.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/modal/src/interface.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   modalBodyInjectionKey: () => (/* binding */ modalBodyInjectionKey),
/* harmony export */   modalInjectionKey: () => (/* binding */ modalInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const modalBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-modal-body');
const modalInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-modal');


/***/ }),

/***/ "./node_modules/naive-ui/es/popover/src/interface.js":
/*!***********************************************************!*\
  !*** ./node_modules/naive-ui/es/popover/src/interface.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   popoverBodyInjectionKey: () => (/* binding */ popoverBodyInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const popoverBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-popover-body');


/***/ }),

/***/ "./node_modules/seemly/es/animation/next-frame-once.js":
/*!*************************************************************!*\
  !*** ./node_modules/seemly/es/animation/next-frame-once.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   beforeNextFrameOnce: () => (/* binding */ beforeNextFrameOnce)
/* harmony export */ });
let onceCbs = [];
const paramsMap = new WeakMap();
function flushOnceCallbacks() {
    onceCbs.forEach((cb) => cb(...paramsMap.get(cb)));
    onceCbs = [];
}
function beforeNextFrameOnce(cb, ...params) {
    paramsMap.set(cb, params);
    if (onceCbs.includes(cb))
        return;
    onceCbs.push(cb) === 1 && requestAnimationFrame(flushOnceCallbacks);
}



/***/ }),

/***/ "./node_modules/seemly/es/dom/get-precise-event-target.js":
/*!****************************************************************!*\
  !*** ./node_modules/seemly/es/dom/get-precise-event-target.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPreciseEventTarget: () => (/* binding */ getPreciseEventTarget)
/* harmony export */ });
function getPreciseEventTarget(event) {
    return event.composedPath()[0] || null;
}


/***/ }),

/***/ "./node_modules/vdirs/es/clickoutside.js":
/*!***********************************************!*\
  !*** ./node_modules/vdirs/es/clickoutside.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");

const ctxKey = '@@coContext';
const clickoutside = {
    mounted(el, { value, modifiers }) {
        el[ctxKey] = {
            handler: undefined
        };
        if (typeof value === 'function') {
            el[ctxKey].handler = value;
            (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('clickoutside', el, value, {
                capture: modifiers.capture
            });
        }
    },
    updated(el, { value, modifiers }) {
        const ctx = el[ctxKey];
        if (typeof value === 'function') {
            if (ctx.handler) {
                if (ctx.handler !== value) {
                    (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('clickoutside', el, ctx.handler, {
                        capture: modifiers.capture
                    });
                    ctx.handler = value;
                    (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('clickoutside', el, value, {
                        capture: modifiers.capture
                    });
                }
            }
            else {
                el[ctxKey].handler = value;
                (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('clickoutside', el, value, {
                    capture: modifiers.capture
                });
            }
        }
        else {
            if (ctx.handler) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('clickoutside', el, ctx.handler, {
                    capture: modifiers.capture
                });
                ctx.handler = undefined;
            }
        }
    },
    unmounted(el, { modifiers }) {
        const { handler } = el[ctxKey];
        if (handler) {
            (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('clickoutside', el, handler, {
                capture: modifiers.capture
            });
        }
        el[ctxKey].handler = undefined;
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (clickoutside);


/***/ }),

/***/ "./node_modules/vdirs/es/utils.js":
/*!****************************************!*\
  !*** ./node_modules/vdirs/es/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   warn: () => (/* binding */ warn),
/* harmony export */   warnOnce: () => (/* binding */ warnOnce)
/* harmony export */ });
const warnedMessages = new Set();
function warnOnce(location, message) {
    const mergedMessage = `[vdirs/${location}]: ${message}`;
    if (warnedMessages.has(mergedMessage))
        return;
    warnedMessages.add(mergedMessage);
}
function warn(location, message) {
    console.error(`[vdirs/${location}]: ${message}`);
}


/***/ }),

/***/ "./node_modules/vdirs/es/zindexable/index.js":
/*!***************************************************!*\
  !*** ./node_modules/vdirs/es/zindexable/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _z_index_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./z-index-manager */ "./node_modules/vdirs/es/zindexable/z-index-manager.js");

const ctx = '@@ziContext';
// We don't expect manually bound zindex should be changed
const zindexable = {
    mounted(el, bindings) {
        const { value = {} } = bindings;
        const { zIndex, enabled } = value;
        el[ctx] = {
            enabled: !!enabled,
            initialized: false
        };
        if (enabled) {
            _z_index_manager__WEBPACK_IMPORTED_MODULE_0__["default"].ensureZIndex(el, zIndex);
            el[ctx].initialized = true;
        }
    },
    updated(el, bindings) {
        const { value = {} } = bindings;
        const { zIndex, enabled } = value;
        const cachedEnabled = el[ctx].enabled;
        if (enabled && !cachedEnabled) {
            _z_index_manager__WEBPACK_IMPORTED_MODULE_0__["default"].ensureZIndex(el, zIndex);
            el[ctx].initialized = true;
        }
        el[ctx].enabled = !!enabled;
    },
    unmounted(el, bindings) {
        if (!el[ctx].initialized)
            return;
        const { value = {} } = bindings;
        const { zIndex } = value;
        _z_index_manager__WEBPACK_IMPORTED_MODULE_0__["default"].unregister(el, zIndex);
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (zindexable);


/***/ }),

/***/ "./node_modules/vdirs/es/zindexable/z-index-manager.js":
/*!*************************************************************!*\
  !*** ./node_modules/vdirs/es/zindexable/z-index-manager.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/vdirs/es/utils.js");

class ZIndexManager {
    constructor() {
        this.elementZIndex = new Map();
        this.nextZIndex = 2000;
    }
    get elementCount() {
        return this.elementZIndex.size;
    }
    ensureZIndex(el, zIndex) {
        const { elementZIndex } = this;
        if (zIndex !== undefined) {
            el.style.zIndex = `${zIndex}`;
            elementZIndex.delete(el);
            return;
        }
        const { nextZIndex } = this;
        if (elementZIndex.has(el)) {
            const currentZIndex = elementZIndex.get(el);
            if (currentZIndex + 1 === this.nextZIndex)
                return;
        }
        el.style.zIndex = `${nextZIndex}`;
        elementZIndex.set(el, nextZIndex);
        this.nextZIndex = nextZIndex + 1;
        this.squashState();
    }
    unregister(el, zIndex) {
        const { elementZIndex } = this;
        if (elementZIndex.has(el)) {
            elementZIndex.delete(el);
        }
        else if (zIndex === undefined) {
            (0,_utils__WEBPACK_IMPORTED_MODULE_0__.warn)('z-index-manager/unregister-element', 'Element not found when unregistering.');
        }
        this.squashState();
    }
    squashState() {
        const { elementCount } = this;
        if (!elementCount) {
            this.nextZIndex = 2000;
        }
        if (this.nextZIndex - elementCount > 2500)
            this.rearrange();
    }
    rearrange() {
        const elementZIndexPair = Array.from(this.elementZIndex.entries());
        elementZIndexPair.sort((pair1, pair2) => {
            return pair1[1] - pair2[1];
        });
        this.nextZIndex = 2000;
        elementZIndexPair.forEach((pair) => {
            const el = pair[0];
            const zIndex = this.nextZIndex++;
            if (`${zIndex}` !== el.style.zIndex)
                el.style.zIndex = `${zIndex}`;
        });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new ZIndexManager());


/***/ }),

/***/ "./node_modules/vooks/es/life-cycle/use-is-mounted.js":
/*!************************************************************!*\
  !*** ./node_modules/vooks/es/life-cycle/use-is-mounted.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ isMounted)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function isMounted() {
    const isMounted = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => { isMounted.value = true; });
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.readonly)(isMounted);
}


/***/ }),

/***/ "./node_modules/vooks/es/on-fonts-ready.js":
/*!*************************************************!*\
  !*** ./node_modules/vooks/es/on-fonts-ready.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ onFontsReady),
/* harmony export */   init: () => (/* binding */ init)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/vooks/es/utils.js");


let fontsReady;
let isFontReady;
const init = () => {
    var _a, _b;
    fontsReady = _utils__WEBPACK_IMPORTED_MODULE_1__.isBrowser ? (_b = (_a = document) === null || _a === void 0 ? void 0 : _a.fonts) === null || _b === void 0 ? void 0 : _b.ready : undefined;
    isFontReady = false;
    /* istanbul ignore if */
    if (fontsReady !== undefined) {
        void fontsReady.then(() => {
            isFontReady = true;
        });
    }
    else {
        isFontReady = true;
    }
};
init();
// For testing

/**
 * Call callback on fontsReady is resolved. If fontsReady is already resolved,
 * callback won't be called.
 */
function onFontsReady(cb) {
    /* istanbul ignore next */
    if (isFontReady)
        return;
    let deactivated = false;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
        /* istanbul ignore next */
        if (!isFontReady) {
            fontsReady === null || fontsReady === void 0 ? void 0 : fontsReady.then(() => {
                if (deactivated)
                    return;
                cb();
            });
        }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
        deactivated = true;
    });
}


/***/ }),

/***/ "./node_modules/vooks/es/use-false-until-truthy.js":
/*!*********************************************************!*\
  !*** ./node_modules/vooks/es/use-false-until-truthy.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFalseUntilTruthy)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function useFalseUntilTruthy(originalRef) {
    const currentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!!originalRef.value);
    if (currentRef.value)
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.readonly)(currentRef);
    const stop = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(originalRef, (value) => {
        if (value) {
            currentRef.value = true;
            stop();
        }
    });
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.readonly)(currentRef);
}


/***/ }),

/***/ "./node_modules/vooks/es/use-is-ios.js":
/*!*********************************************!*\
  !*** ./node_modules/vooks/es/use-is-ios.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useIsIos),
/* harmony export */   isIos: () => (/* binding */ isIos)
/* harmony export */ });
const isIos = (typeof window === 'undefined'
    ? false
    : /iPad|iPhone|iPod/.test(navigator.platform) ||
        (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1)) &&
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    !window.MSStream;
function useIsIos() {
    return isIos;
}


/***/ }),

/***/ "./node_modules/vooks/es/use-merged-state.js":
/*!***************************************************!*\
  !*** ./node_modules/vooks/es/use-merged-state.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useMergedState)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function useMergedState(controlledStateRef, uncontrolledStateRef) {
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(controlledStateRef, value => {
        if (value !== undefined) {
            uncontrolledStateRef.value = value;
        }
    });
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        if (controlledStateRef.value === undefined) {
            return uncontrolledStateRef.value;
        }
        return controlledStateRef.value;
    });
}


/***/ }),

/***/ "./node_modules/vooks/es/utils.js":
/*!****************************************!*\
  !*** ./node_modules/vooks/es/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasInstance: () => (/* binding */ hasInstance),
/* harmony export */   isBrowser: () => (/* binding */ isBrowser)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function hasInstance() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)() !== null;
}
const isBrowser = typeof window !== 'undefined';


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/Binder.js":
/*!****************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/Binder.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/animation/next-frame-once.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _shared_v_node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../shared/v-node */ "./node_modules/vueuc/es/shared/v-node.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/vueuc/es/binder/src/utils.js");
/* eslint-disable @typescript-eslint/no-non-null-assertion */





const Binder = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Binder',
    props: {
        syncTargetWithParent: Boolean,
        syncTarget: {
            type: Boolean,
            default: true
        }
    },
    setup(props) {
        var _a;
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)('VBinder', (_a = (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)()) === null || _a === void 0 ? void 0 : _a.proxy);
        const VBinder = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('VBinder', null);
        const targetRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        /**
         * If there's no nested vbinder, we can simply set the target ref.
         *
         * However, when it comes to:
         * <VBinder> <- syncTarget = false
         *
         *              Should hold target DOM ref, but can't get it directly from
         *              its VTarget. So if there are nested VBinder, we should:
         *              1. Stop setting target DOM from level-1 VTarget
         *              2. Set target DOM from level-2 VTarget
         *              For (1), we need `syncTarget` to `false`
         *              For (2), we need to set `syncTargetWithParent` to `true` on
         *              level-2 VBinder
         *   <VTarget>
         *     <VBinder> <- syncTargetWithParent = true
         *       <VTarget>target</VTarget>
         *     </VBinder>
         *     <VFollower>
         *       content1
         *     </VFollower>
         *   </VTarget>
         *   <VFollower>
         *     content2
         *   </VFollower>
         * </VBinder>
         */
        const setTargetRef = (el) => {
            targetRef.value = el;
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            if (VBinder && props.syncTargetWithParent) {
                VBinder.setTargetRef(el);
            }
        };
        // scroll related
        let scrollableNodes = [];
        const ensureScrollListener = () => {
            let cursor = targetRef.value;
            while (true) {
                cursor = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getScrollParent)(cursor);
                if (cursor === null)
                    break;
                scrollableNodes.push(cursor);
            }
            for (const el of scrollableNodes) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.on)('scroll', el, onScroll, true);
            }
        };
        const removeScrollListeners = () => {
            for (const el of scrollableNodes) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('scroll', el, onScroll, true);
            }
            scrollableNodes = [];
        };
        const followerScrollListeners = new Set();
        const addScrollListener = (listener) => {
            if (followerScrollListeners.size === 0) {
                ensureScrollListener();
            }
            if (!followerScrollListeners.has(listener)) {
                followerScrollListeners.add(listener);
            }
        };
        const removeScrollListener = (listener) => {
            if (followerScrollListeners.has(listener)) {
                followerScrollListeners.delete(listener);
            }
            if (followerScrollListeners.size === 0) {
                removeScrollListeners();
            }
        };
        const onScroll = () => {
            (0,seemly__WEBPACK_IMPORTED_MODULE_3__.beforeNextFrameOnce)(onScrollRaf);
        };
        const onScrollRaf = () => {
            followerScrollListeners.forEach((listener) => listener());
        };
        // resize related
        const followerResizeListeners = new Set();
        const addResizeListener = (listener) => {
            if (followerResizeListeners.size === 0) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.on)('resize', window, onResize);
            }
            if (!followerResizeListeners.has(listener)) {
                followerResizeListeners.add(listener);
            }
        };
        const removeResizeListener = (listener) => {
            if (followerResizeListeners.has(listener)) {
                followerResizeListeners.delete(listener);
            }
            if (followerResizeListeners.size === 0) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('resize', window, onResize);
            }
        };
        const onResize = () => {
            followerResizeListeners.forEach((listener) => listener());
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('resize', window, onResize);
            removeScrollListeners();
        });
        return {
            targetRef,
            setTargetRef,
            addScrollListener,
            removeScrollListener,
            addResizeListener,
            removeResizeListener
        };
    },
    render() {
        return (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_4__.getSlot)('binder', this.$slots);
    }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Binder);


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/Follower.js":
/*!******************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/Follower.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/zindexable/index.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/on-fonts-ready.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/life-cycle/use-is-mounted.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/cssr.js");
/* harmony import */ var _lazy_teleport_src_index__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../lazy-teleport/src/index */ "./node_modules/vueuc/es/lazy-teleport/src/index.js");
/* harmony import */ var _get_placement_style__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./get-placement-style */ "./node_modules/vueuc/es/binder/src/get-placement-style.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils */ "./node_modules/vueuc/es/binder/src/utils.js");
/* eslint-disable @typescript-eslint/no-non-null-assertion */








const style = (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)([
    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('.v-binder-follower-container', {
        position: 'absolute',
        left: '0',
        right: '0',
        top: '0',
        height: '0',
        pointerEvents: 'none',
        zIndex: 'auto'
    }),
    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('.v-binder-follower-content', {
        position: 'absolute',
        zIndex: 'auto'
    }, [
        (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('> *', {
            pointerEvents: 'all'
        })
    ])
]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Follower',
    inheritAttrs: false,
    props: {
        show: Boolean,
        enabled: {
            type: Boolean,
            default: undefined
        },
        placement: {
            type: String,
            default: 'bottom'
        },
        syncTrigger: {
            type: Array,
            default: ['resize', 'scroll']
        },
        to: [String, Object],
        flip: {
            type: Boolean,
            default: true
        },
        internalShift: Boolean,
        x: Number,
        y: Number,
        width: String,
        minWidth: String,
        containerClass: String,
        teleportDisabled: Boolean,
        zindexable: {
            type: Boolean,
            default: true
        },
        zIndex: Number,
        overlap: Boolean
    },
    setup(props) {
        const VBinder = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('VBinder');
        const mergedEnabledRef = (0,vooks__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
            return props.enabled !== undefined ? props.enabled : props.show;
        });
        const followerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const offsetContainerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const ensureListeners = () => {
            const { syncTrigger } = props;
            if (syncTrigger.includes('scroll')) {
                VBinder.addScrollListener(syncPosition);
            }
            if (syncTrigger.includes('resize')) {
                VBinder.addResizeListener(syncPosition);
            }
        };
        const removeListeners = () => {
            VBinder.removeScrollListener(syncPosition);
            VBinder.removeResizeListener(syncPosition);
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            if (mergedEnabledRef.value) {
                syncPosition();
                ensureListeners();
            }
        });
        const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_3__.useSsrAdapter)();
        style.mount({
            id: 'vueuc/binder',
            head: true,
            anchorMetaName: _shared__WEBPACK_IMPORTED_MODULE_1__.cssrAnchorMetaName,
            ssr: ssrAdapter
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            removeListeners();
        });
        (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
            if (mergedEnabledRef.value) {
                syncPosition();
            }
        });
        const syncPosition = () => {
            if (!mergedEnabledRef.value) {
                return;
            }
            const follower = followerRef.value;
            // sometimes watched props change before its dom is ready
            // for example: show=false, x=undefined, y=undefined
            //              show=true,  x=0,         y=0
            // will cause error
            // I may optimize the watch start point later
            if (follower === null)
                return;
            const target = VBinder.targetRef;
            const { x, y, overlap } = props;
            const targetRect = x !== undefined && y !== undefined
                ? (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getPointRect)(x, y)
                : (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getRect)(target);
            follower.style.setProperty('--v-target-width', `${Math.round(targetRect.width)}px`);
            follower.style.setProperty('--v-target-height', `${Math.round(targetRect.height)}px`);
            const { width, minWidth, placement, internalShift, flip } = props;
            follower.setAttribute('v-placement', placement);
            if (overlap) {
                follower.setAttribute('v-overlap', '');
            }
            else {
                follower.removeAttribute('v-overlap');
            }
            const { style } = follower;
            if (width === 'target') {
                style.width = `${targetRect.width}px`;
            }
            else if (width !== undefined) {
                style.width = width;
            }
            else {
                style.width = '';
            }
            if (minWidth === 'target') {
                style.minWidth = `${targetRect.width}px`;
            }
            else if (minWidth !== undefined) {
                style.minWidth = minWidth;
            }
            else {
                style.minWidth = '';
            }
            const followerRect = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getRect)(follower);
            const offsetContainerRect = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getRect)(offsetContainerRef.value);
            const { left: offsetLeftToStandardPlacement, top: offsetTopToStandardPlacement, placement: properPlacement } = (0,_get_placement_style__WEBPACK_IMPORTED_MODULE_6__.getPlacementAndOffsetOfFollower)(placement, targetRect, followerRect, internalShift, flip, overlap);
            const properTransformOrigin = (0,_get_placement_style__WEBPACK_IMPORTED_MODULE_6__.getProperTransformOrigin)(properPlacement, overlap);
            const { left, top, transform } = (0,_get_placement_style__WEBPACK_IMPORTED_MODULE_6__.getOffset)(properPlacement, offsetContainerRect, targetRect, offsetTopToStandardPlacement, offsetLeftToStandardPlacement, overlap);
            // we assume that the content size doesn't change after flip,
            // nor we need to make sync logic more complex
            follower.setAttribute('v-placement', properPlacement);
            follower.style.setProperty('--v-offset-left', `${Math.round(offsetLeftToStandardPlacement)}px`);
            follower.style.setProperty('--v-offset-top', `${Math.round(offsetTopToStandardPlacement)}px`);
            follower.style.transform = `translateX(${left}) translateY(${top}) ${transform}`;
            follower.style.setProperty('--v-transform-origin', properTransformOrigin);
            follower.style.transformOrigin = properTransformOrigin;
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedEnabledRef, (value) => {
            if (value) {
                ensureListeners();
                syncOnNextTick();
            }
            else {
                removeListeners();
            }
        });
        const syncOnNextTick = () => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)()
                .then(syncPosition)
                .catch((e) => console.error(e));
        };
        [
            'placement',
            'x',
            'y',
            'internalShift',
            'flip',
            'width',
            'overlap',
            'minWidth'
        ].forEach((prop) => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, prop), syncPosition);
        });
        ['teleportDisabled'].forEach((prop) => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, prop), syncOnNextTick);
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'syncTrigger'), (value) => {
            if (!value.includes('resize')) {
                VBinder.removeResizeListener(syncPosition);
            }
            else {
                VBinder.addResizeListener(syncPosition);
            }
            if (!value.includes('scroll')) {
                VBinder.removeScrollListener(syncPosition);
            }
            else {
                VBinder.addScrollListener(syncPosition);
            }
        });
        const isMountedRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])();
        const mergedToRef = (0,vooks__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
            const { to } = props;
            if (to !== undefined)
                return to;
            if (isMountedRef.value) {
                // TODO: find proper container
                return undefined;
            }
            return undefined;
        });
        return {
            VBinder,
            mergedEnabled: mergedEnabledRef,
            offsetContainerRef,
            followerRef,
            mergedTo: mergedToRef,
            syncPosition
        };
    },
    render() {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_lazy_teleport_src_index__WEBPACK_IMPORTED_MODULE_8__["default"], {
            show: this.show,
            to: this.mergedTo,
            disabled: this.teleportDisabled
        }, {
            default: () => {
                var _a, _b;
                const vNode = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                    class: ['v-binder-follower-container', this.containerClass],
                    ref: 'offsetContainerRef'
                }, [
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                        class: 'v-binder-follower-content',
                        ref: 'followerRef'
                    }, (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a))
                ]);
                if (this.zindexable) {
                    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(vNode, [
                        [
                            vdirs__WEBPACK_IMPORTED_MODULE_9__["default"],
                            {
                                enabled: this.mergedEnabled,
                                zIndex: this.zIndex
                            }
                        ]
                    ]);
                }
                return vNode;
            }
        });
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/Target.js":
/*!****************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/Target.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _shared_v_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared/v-node */ "./node_modules/vueuc/es/shared/v-node.js");
/* eslint-disable @typescript-eslint/no-non-null-assertion */


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Target',
    setup() {
        const { setTargetRef, syncTarget } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('VBinder');
        const setTargetDirective = {
            mounted: setTargetRef,
            updated: setTargetRef
        };
        return {
            syncTarget,
            setTargetDirective
        };
    },
    render() {
        const { syncTarget, setTargetDirective } = this;
        /**
         * If you are using VBinder as a child of VBinder, the children wouldn't be
         * a valid DOM or component that can be attached to by directive.
         * So we won't sync target on those kind of situation and control the
         * target sync logic manually.
         */
        if (syncTarget) {
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,_shared_v_node__WEBPACK_IMPORTED_MODULE_1__.getFirstVNode)('follower', this.$slots), [
                [setTargetDirective]
            ]);
        }
        return (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_1__.getFirstVNode)('follower', this.$slots);
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/get-placement-style.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/get-placement-style.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getOffset: () => (/* binding */ getOffset),
/* harmony export */   getPlacementAndOffsetOfFollower: () => (/* binding */ getPlacementAndOffsetOfFollower),
/* harmony export */   getProperTransformOrigin: () => (/* binding */ getProperTransformOrigin)
/* harmony export */ });
const oppositionPositions = {
    top: 'bottom',
    bottom: 'top',
    left: 'right',
    right: 'left'
};
const oppositeAligns = {
    start: 'end',
    center: 'center',
    end: 'start'
};
const propToCompare = {
    top: 'height',
    bottom: 'height',
    left: 'width',
    right: 'width'
};
const transformOrigins = {
    'bottom-start': 'top left',
    bottom: 'top center',
    'bottom-end': 'top right',
    'top-start': 'bottom left',
    top: 'bottom center',
    'top-end': 'bottom right',
    'right-start': 'top left',
    right: 'center left',
    'right-end': 'bottom left',
    'left-start': 'top right',
    left: 'center right',
    'left-end': 'bottom right'
};
const overlapTransformOrigin = {
    'bottom-start': 'bottom left',
    bottom: 'bottom center',
    'bottom-end': 'bottom right',
    'top-start': 'top left',
    top: 'top center',
    'top-end': 'top right',
    'right-start': 'top right',
    right: 'center right',
    'right-end': 'bottom right',
    'left-start': 'top left',
    left: 'center left',
    'left-end': 'bottom left'
};
const oppositeAlignCssPositionProps = {
    'bottom-start': 'right',
    'bottom-end': 'left',
    'top-start': 'right',
    'top-end': 'left',
    'right-start': 'bottom',
    'right-end': 'top',
    'left-start': 'bottom',
    'left-end': 'top'
};
const keepOffsetDirection = {
    top: true,
    bottom: false,
    left: true,
    right: false // left--
};
const cssPositionToOppositeAlign = {
    top: 'end',
    bottom: 'start',
    left: 'end',
    right: 'start'
};
function getPlacementAndOffsetOfFollower(placement, targetRect, followerRect, shift, flip, overlap) {
    if (!flip || overlap) {
        return { placement: placement, top: 0, left: 0 };
    }
    const [position, align] = placement.split('-');
    let properAlign = align !== null && align !== void 0 ? align : 'center';
    let properOffset = {
        top: 0,
        left: 0
    };
    const deriveOffset = (oppositeAlignCssSizeProp, alignCssPositionProp, offsetVertically) => {
        let left = 0;
        let top = 0;
        const diff = followerRect[oppositeAlignCssSizeProp] -
            targetRect[alignCssPositionProp] -
            targetRect[oppositeAlignCssSizeProp];
        if (diff > 0 && shift) {
            if (offsetVertically) {
                //       screen border
                // |-----------------------------------------|
                // |                    | f  |               |
                // |                    | o  |               |
                // |                    | l  |               |
                // |                    | l  |----           |
                // |                    | o  |tar |          |
                // |                    | w  |get |          |
                // |                    | e  |    |          |
                // |                    | r  |----           |
                // |                     ----                |
                // |-----------------------------------------|
                top = keepOffsetDirection[alignCssPositionProp] ? diff : -diff;
            }
            else {
                //       screen border
                // |----------------------------------------|
                // |                                        |
                // |          ----------                    |
                // |          | target |                    |
                // |       ----------------------------------
                // |       |       follower                 |
                // |       ----------------------------------
                // |                                        |
                // |----------------------------------------|
                left = keepOffsetDirection[alignCssPositionProp] ? diff : -diff;
            }
        }
        return {
            left,
            top
        };
    };
    const offsetVertically = position === 'left' || position === 'right';
    // choose proper placement for non-center align
    if (properAlign !== 'center') {
        const oppositeAlignCssPositionProp = oppositeAlignCssPositionProps[placement];
        const currentAlignCssPositionProp = oppositionPositions[oppositeAlignCssPositionProp];
        const oppositeAlignCssSizeProp = propToCompare[oppositeAlignCssPositionProp];
        // if follower rect is larger than target rect in align direction
        // ----------[ target ]---------|
        // ----------[     follower     ]
        if (followerRect[oppositeAlignCssSizeProp] >
            targetRect[oppositeAlignCssSizeProp]) {
            if (
            // current space is not enough
            // ----------[ target ]---------|
            // -------[     follower        ]
            targetRect[oppositeAlignCssPositionProp] +
                targetRect[oppositeAlignCssSizeProp] <
                followerRect[oppositeAlignCssSizeProp]) {
                const followerOverTargetSize = (followerRect[oppositeAlignCssSizeProp] -
                    targetRect[oppositeAlignCssSizeProp]) /
                    2;
                if (targetRect[oppositeAlignCssPositionProp] < followerOverTargetSize ||
                    targetRect[currentAlignCssPositionProp] < followerOverTargetSize) {
                    // opposite align has larger space
                    // -------[ target ]-----------|
                    // -------[     follower     ]-|
                    if (targetRect[oppositeAlignCssPositionProp] <
                        targetRect[currentAlignCssPositionProp]) {
                        properAlign = oppositeAligns[align];
                        properOffset = deriveOffset(oppositeAlignCssSizeProp, currentAlignCssPositionProp, offsetVertically);
                    }
                    else {
                        // ----------------[ target ]----|
                        // --------[   follower     ]----|
                        properOffset = deriveOffset(oppositeAlignCssSizeProp, oppositeAlignCssPositionProp, offsetVertically);
                    }
                }
                else {
                    // 'center' align is better
                    // ------------[ target ]--------|
                    // -------[       follower    ]--|
                    properAlign = 'center';
                }
            }
        }
        else if (followerRect[oppositeAlignCssSizeProp] <
            targetRect[oppositeAlignCssSizeProp]) {
            // TODO: maybe center is better
            if (targetRect[currentAlignCssPositionProp] < 0 &&
                // opposite align has larger space
                // ------------[   target   ]
                // ----------------[follower]
                targetRect[oppositeAlignCssPositionProp] >
                    targetRect[currentAlignCssPositionProp]) {
                properAlign = oppositeAligns[align];
            }
        }
    }
    else {
        const possibleAlternativeAlignCssPositionProp1 = position === 'bottom' || position === 'top' ? 'left' : 'top';
        const possibleAlternativeAlignCssPositionProp2 = oppositionPositions[possibleAlternativeAlignCssPositionProp1];
        const alternativeAlignCssSizeProp = propToCompare[possibleAlternativeAlignCssPositionProp1];
        const followerOverTargetSize = (followerRect[alternativeAlignCssSizeProp] -
            targetRect[alternativeAlignCssSizeProp]) /
            2;
        if (
        // center is not enough
        // ----------- [ target ]--|
        // -------[     follower     ]
        targetRect[possibleAlternativeAlignCssPositionProp1] <
            followerOverTargetSize ||
            targetRect[possibleAlternativeAlignCssPositionProp2] <
                followerOverTargetSize) {
            // alternative 2 position's space is larger
            if (targetRect[possibleAlternativeAlignCssPositionProp1] >
                targetRect[possibleAlternativeAlignCssPositionProp2]) {
                properAlign =
                    cssPositionToOppositeAlign[possibleAlternativeAlignCssPositionProp1];
                properOffset = deriveOffset(alternativeAlignCssSizeProp, possibleAlternativeAlignCssPositionProp1, offsetVertically);
            }
            else {
                // alternative 1 position's space is larger
                properAlign =
                    cssPositionToOppositeAlign[possibleAlternativeAlignCssPositionProp2];
                properOffset = deriveOffset(alternativeAlignCssSizeProp, possibleAlternativeAlignCssPositionProp2, offsetVertically);
            }
        }
    }
    let properPosition = position;
    if (
    // space is not enough
    targetRect[position] < followerRect[propToCompare[position]] &&
        // opposite position's space is larger
        targetRect[position] < targetRect[oppositionPositions[position]]) {
        properPosition = oppositionPositions[position];
    }
    return {
        placement: properAlign !== 'center'
            ? `${properPosition}-${properAlign}`
            : properPosition,
        left: properOffset.left,
        top: properOffset.top
    };
}
function getProperTransformOrigin(placement, overlap) {
    if (overlap)
        return overlapTransformOrigin[placement];
    return transformOrigins[placement];
}
// ------------
// |  offset  |
// |          |
// | [target] |
// |          |
// ------------
// TODO: refactor it to remove dup logic
function getOffset(placement, offsetRect, targetRect, offsetTopToStandardPlacement, offsetLeftToStandardPlacement, overlap) {
    if (overlap) {
        switch (placement) {
            case 'bottom-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-100%)'
                };
            case 'bottom-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-100%)'
                };
            case 'top-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: ''
                };
            case 'top-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%)'
                };
            case 'right-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%)'
                };
            case 'right-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-100%)'
                };
            case 'left-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: ''
                };
            case 'left-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-100%)'
                };
            case 'top':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                    transform: 'translateX(-50%)'
                };
            case 'right':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-50%)'
                };
            case 'left':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-50%)'
                };
            case 'bottom':
            default:
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                    transform: 'translateX(-50%) translateY(-100%)'
                };
        }
    }
    switch (placement) {
        case 'bottom-start':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: ''
            };
        case 'bottom-end':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%)'
            };
        case 'top-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-100%)'
            };
        case 'top-end':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%) translateY(-100%)'
            };
        case 'right-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: ''
            };
        case 'right-end':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-100%)'
            };
        case 'left-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%)'
            };
        case 'left-end':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%) translateY(-100%)'
            };
        case 'top':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width / 2 +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-100%) translateX(-50%)'
            };
        case 'right':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height / 2 +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-50%)'
            };
        case 'left':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height / 2 +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-50%) translateX(-100%)'
            };
        case 'bottom':
        default:
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width / 2 +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-50%)'
            };
    }
}


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/utils.js":
/*!***************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/utils.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ensureViewBoundingRect: () => (/* binding */ ensureViewBoundingRect),
/* harmony export */   getParentNode: () => (/* binding */ getParentNode),
/* harmony export */   getPointRect: () => (/* binding */ getPointRect),
/* harmony export */   getRect: () => (/* binding */ getRect),
/* harmony export */   getScrollParent: () => (/* binding */ getScrollParent)
/* harmony export */ });
let viewMeasurer = null;
function ensureViewBoundingRect() {
    if (viewMeasurer === null) {
        viewMeasurer = document.getElementById('v-binder-view-measurer');
        if (viewMeasurer === null) {
            viewMeasurer = document.createElement('div');
            viewMeasurer.id = 'v-binder-view-measurer';
            const { style } = viewMeasurer;
            style.position = 'fixed';
            style.left = '0';
            style.right = '0';
            style.top = '0';
            style.bottom = '0';
            style.pointerEvents = 'none';
            style.visibility = 'hidden';
            document.body.appendChild(viewMeasurer);
        }
    }
    return viewMeasurer.getBoundingClientRect();
}
function getPointRect(x, y) {
    const viewRect = ensureViewBoundingRect();
    return {
        top: y,
        left: x,
        height: 0,
        width: 0,
        right: viewRect.width - x,
        bottom: viewRect.height - y
    };
}
function getRect(el) {
    const elRect = el.getBoundingClientRect();
    const viewRect = ensureViewBoundingRect();
    return {
        left: elRect.left - viewRect.left,
        top: elRect.top - viewRect.top,
        bottom: viewRect.height + viewRect.top - elRect.bottom,
        right: viewRect.width + viewRect.left - elRect.right,
        width: elRect.width,
        height: elRect.height
    };
}
function getParentNode(node) {
    // document type
    if (node.nodeType === 9) {
        return null;
    }
    return node.parentNode;
}
function getScrollParent(node) {
    if (node === null)
        return null;
    const parentNode = getParentNode(node);
    if (parentNode === null) {
        return null;
    }
    // Document
    if (parentNode.nodeType === 9) {
        return document;
    }
    // Element
    if (parentNode.nodeType === 1) {
        // Firefox want us to check `-x` and `-y` variations as well
        const { overflow, overflowX, overflowY } = getComputedStyle(parentNode);
        if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
            return parentNode;
        }
    }
    return getScrollParent(parentNode);
}


/***/ }),

/***/ "./node_modules/vueuc/es/lazy-teleport/src/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/vueuc/es/lazy-teleport/src/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-false-until-truthy.js");
/* harmony import */ var _shared_v_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../shared/v-node */ "./node_modules/vueuc/es/shared/v-node.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'LazyTeleport',
    props: {
        to: {
            type: [String, Object],
            default: undefined
        },
        disabled: Boolean,
        show: {
            type: Boolean,
            required: true
        }
    },
    setup(props) {
        return {
            showTeleport: (0,vooks__WEBPACK_IMPORTED_MODULE_1__["default"])((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'show')),
            mergedTo: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
                const { to } = props;
                return to !== null && to !== void 0 ? to : 'body';
            })
        };
    },
    render() {
        return this.showTeleport
            ? this.disabled
                ? (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_2__.getSlot)('lazy-teleport', this.$slots)
                : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Teleport, {
                    disabled: this.disabled,
                    to: this.mergedTo
                }, (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_2__.getSlot)('lazy-teleport', this.$slots))
            : null;
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _delegate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./delegate */ "./node_modules/vueuc/es/resize-observer/src/delegate.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/warn.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'ResizeObserver',
    props: {
        onResize: Function
    },
    setup(props) {
        let registered = false;
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const proxy = (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)().proxy;
        function handleResize(entry) {
            const { onResize } = props;
            if (onResize !== undefined)
                onResize(entry);
        }
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            const el = proxy.$el;
            if (el === undefined) {
                (0,_shared__WEBPACK_IMPORTED_MODULE_1__.warn)('resize-observer', '$el does not exist.');
                return;
            }
            if (el.nextElementSibling !== el.nextSibling) {
                if (el.nodeType === 3 && el.nodeValue !== '') {
                    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.warn)('resize-observer', '$el can not be observed (it may be a text node).');
                    return;
                }
            }
            if (el.nextElementSibling !== null) {
                _delegate__WEBPACK_IMPORTED_MODULE_2__["default"].registerHandler(el.nextElementSibling, handleResize);
                registered = true;
            }
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            if (registered) {
                _delegate__WEBPACK_IMPORTED_MODULE_2__["default"].unregisterHandler(proxy.$el.nextElementSibling);
            }
        });
    },
    render() {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(this.$slots, 'default');
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/resize-observer/src/delegate.js":
/*!***************************************************************!*\
  !*** ./node_modules/vueuc/es/resize-observer/src/delegate.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _juggle_resize_observer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @juggle/resize-observer */ "./node_modules/@juggle/resize-observer/lib/exports/resize-observer.js");

class ResizeObserverDelegate {
    constructor() {
        this.handleResize = this.handleResize.bind(this);
        this.observer = new ((typeof window !== 'undefined' &&
            window.ResizeObserver) ||
            _juggle_resize_observer__WEBPACK_IMPORTED_MODULE_0__.ResizeObserver)(this.handleResize);
        this.elHandlersMap = new Map();
    }
    handleResize(entries) {
        for (const entry of entries) {
            const handler = this.elHandlersMap.get(entry.target);
            if (handler !== undefined) {
                handler(entry);
            }
        }
    }
    registerHandler(el, handler) {
        this.elHandlersMap.set(el, handler);
        this.observer.observe(el);
    }
    unregisterHandler(el) {
        if (!this.elHandlersMap.has(el)) {
            return;
        }
        this.elHandlersMap.delete(el);
        this.observer.unobserve(el);
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new ResizeObserverDelegate());


/***/ }),

/***/ "./node_modules/vueuc/es/shared/cssr.js":
/*!**********************************************!*\
  !*** ./node_modules/vueuc/es/shared/cssr.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: () => (/* binding */ c),
/* harmony export */   cssrAnchorMetaName: () => (/* binding */ cssrAnchorMetaName)
/* harmony export */ });
/* harmony import */ var css_render__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! css-render */ "./node_modules/css-render/esm/CssRender.js");

const { c } = (0,css_render__WEBPACK_IMPORTED_MODULE_0__.CssRender)();

const cssrAnchorMetaName = 'vueuc-style';


/***/ }),

/***/ "./node_modules/vueuc/es/shared/v-node.js":
/*!************************************************!*\
  !*** ./node_modules/vueuc/es/shared/v-node.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flatten: () => (/* binding */ flatten),
/* harmony export */   getFirstVNode: () => (/* binding */ getFirstVNode),
/* harmony export */   getSlot: () => (/* binding */ getSlot)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function getSlot(scope, slots, slotName = 'default') {
    const slot = slots[slotName];
    if (slot === undefined) {
        throw new Error(`[vueuc/${scope}]: slot[${slotName}] is empty.`);
    }
    return slot();
}
// o(n) flatten
function flatten(vNodes, filterCommentNode = true, result = []) {
    vNodes.forEach((vNode) => {
        if (vNode === null)
            return;
        if (typeof vNode !== 'object') {
            if (typeof vNode === 'string' || typeof vNode === 'number') {
                result.push((0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(String(vNode)));
            }
            return;
        }
        if (Array.isArray(vNode)) {
            flatten(vNode, filterCommentNode, result);
            return;
        }
        if (vNode.type === vue__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
            if (vNode.children === null)
                return;
            if (Array.isArray(vNode.children)) {
                flatten(vNode.children, filterCommentNode, result);
            }
            // rawSlot
        }
        else if (vNode.type !== vue__WEBPACK_IMPORTED_MODULE_0__.Comment) {
            result.push(vNode);
        }
    });
    return result;
}
function getFirstVNode(scope, slots, slotName = 'default') {
    const slot = slots[slotName];
    if (slot === undefined) {
        throw new Error(`[vueuc/${scope}]: slot[${slotName}] is empty.`);
    }
    const content = flatten(slot());
    // vue will normalize the slot, so slot must be an array
    if (content.length === 1) {
        return content[0];
    }
    else {
        throw new Error(`[vueuc/${scope}]: slot[${slotName}] should have exactly one child.`);
    }
}


/***/ }),

/***/ "./node_modules/vueuc/es/shared/warn.js":
/*!**********************************************!*\
  !*** ./node_modules/vueuc/es/shared/warn.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   warn: () => (/* binding */ warn)
/* harmony export */ });
function warn(location, message) {
    console.error(`[vueuc/${location}]: ${message}`);
}


/***/ }),

/***/ "./node_modules/lodash-es/_arrayMap.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_arrayMap.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrayMap);


/***/ }),

/***/ "./node_modules/lodash-es/_asciiToArray.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_asciiToArray.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (asciiToArray);


/***/ }),

/***/ "./node_modules/lodash-es/_baseSlice.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_baseSlice.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseSlice);


/***/ }),

/***/ "./node_modules/lodash-es/_baseToString.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_baseToString.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");
/* harmony import */ var _arrayMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_arrayMap.js */ "./node_modules/lodash-es/_arrayMap.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _isSymbol_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isSymbol.js */ "./node_modules/lodash-es/isSymbol.js");





/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return (0,_arrayMap_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value, baseToString) + '';
  }
  if ((0,_isSymbol_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseToString);


/***/ }),

/***/ "./node_modules/lodash-es/_castSlice.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_castSlice.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseSlice_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseSlice.js */ "./node_modules/lodash-es/_baseSlice.js");


/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : (0,_baseSlice_js__WEBPACK_IMPORTED_MODULE_0__["default"])(array, start, end);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (castSlice);


/***/ }),

/***/ "./node_modules/lodash-es/_createCaseFirst.js":
/*!****************************************************!*\
  !*** ./node_modules/lodash-es/_createCaseFirst.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _castSlice_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_castSlice.js */ "./node_modules/lodash-es/_castSlice.js");
/* harmony import */ var _hasUnicode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_hasUnicode.js */ "./node_modules/lodash-es/_hasUnicode.js");
/* harmony import */ var _stringToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_stringToArray.js */ "./node_modules/lodash-es/_stringToArray.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./toString.js */ "./node_modules/lodash-es/toString.js");





/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = (0,_toString_js__WEBPACK_IMPORTED_MODULE_0__["default"])(string);

    var strSymbols = (0,_hasUnicode_js__WEBPACK_IMPORTED_MODULE_1__["default"])(string)
      ? (0,_stringToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? (0,_castSlice_js__WEBPACK_IMPORTED_MODULE_3__["default"])(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createCaseFirst);


/***/ }),

/***/ "./node_modules/lodash-es/_hasUnicode.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_hasUnicode.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (hasUnicode);


/***/ }),

/***/ "./node_modules/lodash-es/_stringToArray.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash-es/_stringToArray.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _asciiToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_asciiToArray.js */ "./node_modules/lodash-es/_asciiToArray.js");
/* harmony import */ var _hasUnicode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_hasUnicode.js */ "./node_modules/lodash-es/_hasUnicode.js");
/* harmony import */ var _unicodeToArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_unicodeToArray.js */ "./node_modules/lodash-es/_unicodeToArray.js");




/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return (0,_hasUnicode_js__WEBPACK_IMPORTED_MODULE_0__["default"])(string)
    ? (0,_unicodeToArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(string)
    : (0,_asciiToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(string);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stringToArray);


/***/ }),

/***/ "./node_modules/lodash-es/_unicodeToArray.js":
/*!***************************************************!*\
  !*** ./node_modules/lodash-es/_unicodeToArray.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsAstral = '[' + rsAstralRange + ']',
    rsCombo = '[' + rsComboRange + ']',
    rsFitz = '\\ud83c[\\udffb-\\udfff]',
    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
    rsNonAstral = '[^' + rsAstralRange + ']',
    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsZWJ = '\\u200d';

/** Used to compose unicode regexes. */
var reOptMod = rsModifier + '?',
    rsOptVar = '[' + rsVarRange + ']?',
    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
    rsSeq = rsOptVar + reOptMod + rsOptJoin,
    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (unicodeToArray);


/***/ }),

/***/ "./node_modules/lodash-es/isSymbol.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/isSymbol.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseGetTag.js */ "./node_modules/lodash-es/_baseGetTag.js");
/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");



/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    ((0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) == symbolTag);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isSymbol);


/***/ }),

/***/ "./node_modules/lodash-es/toString.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/toString.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseToString.js */ "./node_modules/lodash-es/_baseToString.js");


/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : (0,_baseToString_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toString);


/***/ }),

/***/ "./node_modules/lodash-es/upperFirst.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/upperFirst.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _createCaseFirst_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_createCaseFirst.js */ "./node_modules/lodash-es/_createCaseFirst.js");


/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
var upperFirst = (0,_createCaseFirst_js__WEBPACK_IMPORTED_MODULE_0__["default"])('toUpperCase');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (upperFirst);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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