"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es__internal_icon_src_Icon_js-node_modules_naive-ui_es__interna-a748ec"],{

/***/ "./node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   DOMRectReadOnly: () => (/* binding */ DOMRectReadOnly)
/* harmony export */ });
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");

var DOMRectReadOnly = (function () {
    function DOMRectReadOnly(x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.top = this.y;
        this.left = this.x;
        this.bottom = this.top + this.height;
        this.right = this.left + this.width;
        return (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_0__.freeze)(this);
    }
    DOMRectReadOnly.prototype.toJSON = function () {
        var _a = this, x = _a.x, y = _a.y, top = _a.top, right = _a.right, bottom = _a.bottom, left = _a.left, width = _a.width, height = _a.height;
        return { x: x, y: y, top: top, right: right, bottom: bottom, left: left, width: width, height: height };
    };
    DOMRectReadOnly.fromRect = function (rectangle) {
        return new DOMRectReadOnly(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    };
    return DOMRectReadOnly;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObservation.js":
/*!***********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObservation.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObservation: () => (/* binding */ ResizeObservation)
/* harmony export */ });
/* harmony import */ var _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ResizeObserverBoxOptions */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js");
/* harmony import */ var _algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./algorithms/calculateBoxSize */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js");
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");



var skipNotifyOnElement = function (target) {
    return !(0,_utils_element__WEBPACK_IMPORTED_MODULE_2__.isSVG)(target)
        && !(0,_utils_element__WEBPACK_IMPORTED_MODULE_2__.isReplacedElement)(target)
        && getComputedStyle(target).display === 'inline';
};
var ResizeObservation = (function () {
    function ResizeObservation(target, observedBox) {
        this.target = target;
        this.observedBox = observedBox || _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverBoxOptions.CONTENT_BOX;
        this.lastReportedSize = {
            inlineSize: 0,
            blockSize: 0
        };
    }
    ResizeObservation.prototype.isActive = function () {
        var size = (0,_algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_1__.calculateBoxSize)(this.target, this.observedBox, true);
        if (skipNotifyOnElement(this.target)) {
            this.lastReportedSize = size;
        }
        if (this.lastReportedSize.inlineSize !== size.inlineSize
            || this.lastReportedSize.blockSize !== size.blockSize) {
            return true;
        }
        return false;
    };
    return ResizeObservation;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserver.js":
/*!********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserver.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserver: () => (/* binding */ ResizeObserver)
/* harmony export */ });
/* harmony import */ var _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./ResizeObserverController */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverController.js");
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");


var ResizeObserver = (function () {
    function ResizeObserver(callback) {
        if (arguments.length === 0) {
            throw new TypeError("Failed to construct 'ResizeObserver': 1 argument required, but only 0 present.");
        }
        if (typeof callback !== 'function') {
            throw new TypeError("Failed to construct 'ResizeObserver': The callback provided as parameter 1 is not a function.");
        }
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.connect(this, callback);
    }
    ResizeObserver.prototype.observe = function (target, options) {
        if (arguments.length === 0) {
            throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': 1 argument required, but only 0 present.");
        }
        if (!(0,_utils_element__WEBPACK_IMPORTED_MODULE_1__.isElement)(target)) {
            throw new TypeError("Failed to execute 'observe' on 'ResizeObserver': parameter 1 is not of type 'Element");
        }
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.observe(this, target, options);
    };
    ResizeObserver.prototype.unobserve = function (target) {
        if (arguments.length === 0) {
            throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': 1 argument required, but only 0 present.");
        }
        if (!(0,_utils_element__WEBPACK_IMPORTED_MODULE_1__.isElement)(target)) {
            throw new TypeError("Failed to execute 'unobserve' on 'ResizeObserver': parameter 1 is not of type 'Element");
        }
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.unobserve(this, target);
    };
    ResizeObserver.prototype.disconnect = function () {
        _ResizeObserverController__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverController.disconnect(this);
    };
    ResizeObserver.toString = function () {
        return 'function ResizeObserver () { [polyfill code] }';
    };
    return ResizeObserver;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverBoxOptions: () => (/* binding */ ResizeObserverBoxOptions)
/* harmony export */ });
var ResizeObserverBoxOptions;
(function (ResizeObserverBoxOptions) {
    ResizeObserverBoxOptions["BORDER_BOX"] = "border-box";
    ResizeObserverBoxOptions["CONTENT_BOX"] = "content-box";
    ResizeObserverBoxOptions["DEVICE_PIXEL_CONTENT_BOX"] = "device-pixel-content-box";
})(ResizeObserverBoxOptions || (ResizeObserverBoxOptions = {}));



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverController.js":
/*!******************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverController.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverController: () => (/* binding */ ResizeObserverController)
/* harmony export */ });
/* harmony import */ var _utils_scheduler__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/scheduler */ "./node_modules/@juggle/resize-observer/lib/utils/scheduler.js");
/* harmony import */ var _ResizeObservation__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./ResizeObservation */ "./node_modules/@juggle/resize-observer/lib/ResizeObservation.js");
/* harmony import */ var _ResizeObserverDetail__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./ResizeObserverDetail */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js");
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");




var observerMap = new WeakMap();
var getObservationIndex = function (observationTargets, target) {
    for (var i = 0; i < observationTargets.length; i += 1) {
        if (observationTargets[i].target === target) {
            return i;
        }
    }
    return -1;
};
var ResizeObserverController = (function () {
    function ResizeObserverController() {
    }
    ResizeObserverController.connect = function (resizeObserver, callback) {
        var detail = new _ResizeObserverDetail__WEBPACK_IMPORTED_MODULE_2__.ResizeObserverDetail(resizeObserver, callback);
        observerMap.set(resizeObserver, detail);
    };
    ResizeObserverController.observe = function (resizeObserver, target, options) {
        var detail = observerMap.get(resizeObserver);
        var firstObservation = detail.observationTargets.length === 0;
        if (getObservationIndex(detail.observationTargets, target) < 0) {
            firstObservation && _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__.resizeObservers.push(detail);
            detail.observationTargets.push(new _ResizeObservation__WEBPACK_IMPORTED_MODULE_1__.ResizeObservation(target, options && options.box));
            (0,_utils_scheduler__WEBPACK_IMPORTED_MODULE_0__.updateCount)(1);
            _utils_scheduler__WEBPACK_IMPORTED_MODULE_0__.scheduler.schedule();
        }
    };
    ResizeObserverController.unobserve = function (resizeObserver, target) {
        var detail = observerMap.get(resizeObserver);
        var index = getObservationIndex(detail.observationTargets, target);
        var lastObservation = detail.observationTargets.length === 1;
        if (index >= 0) {
            lastObservation && _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__.resizeObservers.splice(_utils_resizeObservers__WEBPACK_IMPORTED_MODULE_3__.resizeObservers.indexOf(detail), 1);
            detail.observationTargets.splice(index, 1);
            (0,_utils_scheduler__WEBPACK_IMPORTED_MODULE_0__.updateCount)(-1);
        }
    };
    ResizeObserverController.disconnect = function (resizeObserver) {
        var _this = this;
        var detail = observerMap.get(resizeObserver);
        detail.observationTargets.slice().forEach(function (ot) { return _this.unobserve(resizeObserver, ot.target); });
        detail.activeTargets.splice(0, detail.activeTargets.length);
    };
    return ResizeObserverController;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverDetail.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverDetail: () => (/* binding */ ResizeObserverDetail)
/* harmony export */ });
var ResizeObserverDetail = (function () {
    function ResizeObserverDetail(resizeObserver, callback) {
        this.activeTargets = [];
        this.skippedTargets = [];
        this.observationTargets = [];
        this.observer = resizeObserver;
        this.callback = callback;
    }
    return ResizeObserverDetail;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js":
/*!*************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverEntry: () => (/* binding */ ResizeObserverEntry)
/* harmony export */ });
/* harmony import */ var _algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./algorithms/calculateBoxSize */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js");
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");


var ResizeObserverEntry = (function () {
    function ResizeObserverEntry(target) {
        var boxes = (0,_algorithms_calculateBoxSize__WEBPACK_IMPORTED_MODULE_0__.calculateBoxSizes)(target);
        this.target = target;
        this.contentRect = boxes.contentRect;
        this.borderBoxSize = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_1__.freeze)([boxes.borderBoxSize]);
        this.contentBoxSize = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_1__.freeze)([boxes.contentBoxSize]);
        this.devicePixelContentBoxSize = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_1__.freeze)([boxes.devicePixelContentBoxSize]);
    }
    return ResizeObserverEntry;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js":
/*!************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserverSize: () => (/* binding */ ResizeObserverSize)
/* harmony export */ });
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");

var ResizeObserverSize = (function () {
    function ResizeObserverSize(inlineSize, blockSize) {
        this.inlineSize = inlineSize;
        this.blockSize = blockSize;
        (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_0__.freeze)(this);
    }
    return ResizeObserverSize;
}());



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js":
/*!********************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js ***!
  \********************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   broadcastActiveObservations: () => (/* binding */ broadcastActiveObservations)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");
/* harmony import */ var _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ResizeObserverEntry */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js");
/* harmony import */ var _calculateDepthForNode__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./calculateDepthForNode */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js");
/* harmony import */ var _calculateBoxSize__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./calculateBoxSize */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js");




var broadcastActiveObservations = function () {
    var shallowestDepth = Infinity;
    var callbacks = [];
    _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.forEach(function processObserver(ro) {
        if (ro.activeTargets.length === 0) {
            return;
        }
        var entries = [];
        ro.activeTargets.forEach(function processTarget(ot) {
            var entry = new _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__.ResizeObserverEntry(ot.target);
            var targetDepth = (0,_calculateDepthForNode__WEBPACK_IMPORTED_MODULE_2__.calculateDepthForNode)(ot.target);
            entries.push(entry);
            ot.lastReportedSize = (0,_calculateBoxSize__WEBPACK_IMPORTED_MODULE_3__.calculateBoxSize)(ot.target, ot.observedBox);
            if (targetDepth < shallowestDepth) {
                shallowestDepth = targetDepth;
            }
        });
        callbacks.push(function resizeObserverCallback() {
            ro.callback.call(ro.observer, entries, ro.observer);
        });
        ro.activeTargets.splice(0, ro.activeTargets.length);
    });
    for (var _i = 0, callbacks_1 = callbacks; _i < callbacks_1.length; _i++) {
        var callback = callbacks_1[_i];
        callback();
    }
    return shallowestDepth;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/calculateBoxSize.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateBoxSize: () => (/* binding */ calculateBoxSize),
/* harmony export */   calculateBoxSizes: () => (/* binding */ calculateBoxSizes)
/* harmony export */ });
/* harmony import */ var _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../ResizeObserverBoxOptions */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverBoxOptions.js");
/* harmony import */ var _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ResizeObserverSize */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js");
/* harmony import */ var _DOMRectReadOnly__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../DOMRectReadOnly */ "./node_modules/@juggle/resize-observer/lib/DOMRectReadOnly.js");
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");
/* harmony import */ var _utils_freeze__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../utils/freeze */ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js");
/* harmony import */ var _utils_global__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../utils/global */ "./node_modules/@juggle/resize-observer/lib/utils/global.js");






var cache = new WeakMap();
var scrollRegexp = /auto|scroll/;
var verticalRegexp = /^tb|vertical/;
var IE = (/msie|trident/i).test(_utils_global__WEBPACK_IMPORTED_MODULE_5__.global.navigator && _utils_global__WEBPACK_IMPORTED_MODULE_5__.global.navigator.userAgent);
var parseDimension = function (pixel) { return parseFloat(pixel || '0'); };
var size = function (inlineSize, blockSize, switchSizes) {
    if (inlineSize === void 0) { inlineSize = 0; }
    if (blockSize === void 0) { blockSize = 0; }
    if (switchSizes === void 0) { switchSizes = false; }
    return new _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_1__.ResizeObserverSize((switchSizes ? blockSize : inlineSize) || 0, (switchSizes ? inlineSize : blockSize) || 0);
};
var zeroBoxes = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_4__.freeze)({
    devicePixelContentBoxSize: size(),
    borderBoxSize: size(),
    contentBoxSize: size(),
    contentRect: new _DOMRectReadOnly__WEBPACK_IMPORTED_MODULE_2__.DOMRectReadOnly(0, 0, 0, 0)
});
var calculateBoxSizes = function (target, forceRecalculation) {
    if (forceRecalculation === void 0) { forceRecalculation = false; }
    if (cache.has(target) && !forceRecalculation) {
        return cache.get(target);
    }
    if ((0,_utils_element__WEBPACK_IMPORTED_MODULE_3__.isHidden)(target)) {
        cache.set(target, zeroBoxes);
        return zeroBoxes;
    }
    var cs = getComputedStyle(target);
    var svg = (0,_utils_element__WEBPACK_IMPORTED_MODULE_3__.isSVG)(target) && target.ownerSVGElement && target.getBBox();
    var removePadding = !IE && cs.boxSizing === 'border-box';
    var switchSizes = verticalRegexp.test(cs.writingMode || '');
    var canScrollVertically = !svg && scrollRegexp.test(cs.overflowY || '');
    var canScrollHorizontally = !svg && scrollRegexp.test(cs.overflowX || '');
    var paddingTop = svg ? 0 : parseDimension(cs.paddingTop);
    var paddingRight = svg ? 0 : parseDimension(cs.paddingRight);
    var paddingBottom = svg ? 0 : parseDimension(cs.paddingBottom);
    var paddingLeft = svg ? 0 : parseDimension(cs.paddingLeft);
    var borderTop = svg ? 0 : parseDimension(cs.borderTopWidth);
    var borderRight = svg ? 0 : parseDimension(cs.borderRightWidth);
    var borderBottom = svg ? 0 : parseDimension(cs.borderBottomWidth);
    var borderLeft = svg ? 0 : parseDimension(cs.borderLeftWidth);
    var horizontalPadding = paddingLeft + paddingRight;
    var verticalPadding = paddingTop + paddingBottom;
    var horizontalBorderArea = borderLeft + borderRight;
    var verticalBorderArea = borderTop + borderBottom;
    var horizontalScrollbarThickness = !canScrollHorizontally ? 0 : target.offsetHeight - verticalBorderArea - target.clientHeight;
    var verticalScrollbarThickness = !canScrollVertically ? 0 : target.offsetWidth - horizontalBorderArea - target.clientWidth;
    var widthReduction = removePadding ? horizontalPadding + horizontalBorderArea : 0;
    var heightReduction = removePadding ? verticalPadding + verticalBorderArea : 0;
    var contentWidth = svg ? svg.width : parseDimension(cs.width) - widthReduction - verticalScrollbarThickness;
    var contentHeight = svg ? svg.height : parseDimension(cs.height) - heightReduction - horizontalScrollbarThickness;
    var borderBoxWidth = contentWidth + horizontalPadding + verticalScrollbarThickness + horizontalBorderArea;
    var borderBoxHeight = contentHeight + verticalPadding + horizontalScrollbarThickness + verticalBorderArea;
    var boxes = (0,_utils_freeze__WEBPACK_IMPORTED_MODULE_4__.freeze)({
        devicePixelContentBoxSize: size(Math.round(contentWidth * devicePixelRatio), Math.round(contentHeight * devicePixelRatio), switchSizes),
        borderBoxSize: size(borderBoxWidth, borderBoxHeight, switchSizes),
        contentBoxSize: size(contentWidth, contentHeight, switchSizes),
        contentRect: new _DOMRectReadOnly__WEBPACK_IMPORTED_MODULE_2__.DOMRectReadOnly(paddingLeft, paddingTop, contentWidth, contentHeight)
    });
    cache.set(target, boxes);
    return boxes;
};
var calculateBoxSize = function (target, observedBox, forceRecalculation) {
    var _a = calculateBoxSizes(target, forceRecalculation), borderBoxSize = _a.borderBoxSize, contentBoxSize = _a.contentBoxSize, devicePixelContentBoxSize = _a.devicePixelContentBoxSize;
    switch (observedBox) {
        case _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverBoxOptions.DEVICE_PIXEL_CONTENT_BOX:
            return devicePixelContentBoxSize;
        case _ResizeObserverBoxOptions__WEBPACK_IMPORTED_MODULE_0__.ResizeObserverBoxOptions.BORDER_BOX:
            return borderBoxSize;
        default:
            return contentBoxSize;
    }
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   calculateDepthForNode: () => (/* binding */ calculateDepthForNode)
/* harmony export */ });
/* harmony import */ var _utils_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/element */ "./node_modules/@juggle/resize-observer/lib/utils/element.js");

var calculateDepthForNode = function (node) {
    if ((0,_utils_element__WEBPACK_IMPORTED_MODULE_0__.isHidden)(node)) {
        return Infinity;
    }
    var depth = 0;
    var parent = node.parentNode;
    while (parent) {
        depth += 1;
        parent = parent.parentNode;
    }
    return depth;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   deliverResizeLoopError: () => (/* binding */ deliverResizeLoopError)
/* harmony export */ });
var msg = 'ResizeObserver loop completed with undelivered notifications.';
var deliverResizeLoopError = function () {
    var event;
    if (typeof ErrorEvent === 'function') {
        event = new ErrorEvent('error', {
            message: msg
        });
    }
    else {
        event = document.createEvent('Event');
        event.initEvent('error', false, false);
        event.message = msg;
    }
    window.dispatchEvent(event);
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js":
/*!************************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js ***!
  \************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   gatherActiveObservationsAtDepth: () => (/* binding */ gatherActiveObservationsAtDepth)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");
/* harmony import */ var _calculateDepthForNode__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./calculateDepthForNode */ "./node_modules/@juggle/resize-observer/lib/algorithms/calculateDepthForNode.js");


var gatherActiveObservationsAtDepth = function (depth) {
    _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.forEach(function processObserver(ro) {
        ro.activeTargets.splice(0, ro.activeTargets.length);
        ro.skippedTargets.splice(0, ro.skippedTargets.length);
        ro.observationTargets.forEach(function processTarget(ot) {
            if (ot.isActive()) {
                if ((0,_calculateDepthForNode__WEBPACK_IMPORTED_MODULE_1__.calculateDepthForNode)(ot.target) > depth) {
                    ro.activeTargets.push(ot);
                }
                else {
                    ro.skippedTargets.push(ot);
                }
            }
        });
    });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasActiveObservations: () => (/* binding */ hasActiveObservations)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");

var hasActiveObservations = function () {
    return _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.some(function (ro) { return ro.activeTargets.length > 0; });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js":
/*!***************************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js ***!
  \***************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasSkippedObservations: () => (/* binding */ hasSkippedObservations)
/* harmony export */ });
/* harmony import */ var _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/resizeObservers */ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js");

var hasSkippedObservations = function () {
    return _utils_resizeObservers__WEBPACK_IMPORTED_MODULE_0__.resizeObservers.some(function (ro) { return ro.skippedTargets.length > 0; });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/exports/resize-observer.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/exports/resize-observer.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ResizeObserver: () => (/* reexport safe */ _ResizeObserver__WEBPACK_IMPORTED_MODULE_0__.ResizeObserver),
/* harmony export */   ResizeObserverEntry: () => (/* reexport safe */ _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__.ResizeObserverEntry),
/* harmony export */   ResizeObserverSize: () => (/* reexport safe */ _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_2__.ResizeObserverSize)
/* harmony export */ });
/* harmony import */ var _ResizeObserver__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../ResizeObserver */ "./node_modules/@juggle/resize-observer/lib/ResizeObserver.js");
/* harmony import */ var _ResizeObserverEntry__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../ResizeObserverEntry */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverEntry.js");
/* harmony import */ var _ResizeObserverSize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ResizeObserverSize */ "./node_modules/@juggle/resize-observer/lib/ResizeObserverSize.js");





/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/element.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/element.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isElement: () => (/* binding */ isElement),
/* harmony export */   isHidden: () => (/* binding */ isHidden),
/* harmony export */   isReplacedElement: () => (/* binding */ isReplacedElement),
/* harmony export */   isSVG: () => (/* binding */ isSVG)
/* harmony export */ });
var isSVG = function (target) { return target instanceof SVGElement && 'getBBox' in target; };
var isHidden = function (target) {
    if (isSVG(target)) {
        var _a = target.getBBox(), width = _a.width, height = _a.height;
        return !width && !height;
    }
    var _b = target, offsetWidth = _b.offsetWidth, offsetHeight = _b.offsetHeight;
    return !(offsetWidth || offsetHeight || target.getClientRects().length);
};
var isElement = function (obj) {
    var _a;
    if (obj instanceof Element) {
        return true;
    }
    var scope = (_a = obj === null || obj === void 0 ? void 0 : obj.ownerDocument) === null || _a === void 0 ? void 0 : _a.defaultView;
    return !!(scope && obj instanceof scope.Element);
};
var isReplacedElement = function (target) {
    switch (target.tagName) {
        case 'INPUT':
            if (target.type !== 'image') {
                break;
            }
        case 'VIDEO':
        case 'AUDIO':
        case 'EMBED':
        case 'OBJECT':
        case 'CANVAS':
        case 'IFRAME':
        case 'IMG':
            return true;
    }
    return false;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/freeze.js":
/*!******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/freeze.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   freeze: () => (/* binding */ freeze)
/* harmony export */ });
var freeze = function (obj) { return Object.freeze(obj); };


/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/global.js":
/*!******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/global.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   global: () => (/* binding */ global)
/* harmony export */ });
var global = typeof window !== 'undefined' ? window : {};


/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/process.js":
/*!*******************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/process.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   process: () => (/* binding */ process)
/* harmony export */ });
/* harmony import */ var _algorithms_hasActiveObservations__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../algorithms/hasActiveObservations */ "./node_modules/@juggle/resize-observer/lib/algorithms/hasActiveObservations.js");
/* harmony import */ var _algorithms_hasSkippedObservations__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../algorithms/hasSkippedObservations */ "./node_modules/@juggle/resize-observer/lib/algorithms/hasSkippedObservations.js");
/* harmony import */ var _algorithms_deliverResizeLoopError__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../algorithms/deliverResizeLoopError */ "./node_modules/@juggle/resize-observer/lib/algorithms/deliverResizeLoopError.js");
/* harmony import */ var _algorithms_broadcastActiveObservations__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../algorithms/broadcastActiveObservations */ "./node_modules/@juggle/resize-observer/lib/algorithms/broadcastActiveObservations.js");
/* harmony import */ var _algorithms_gatherActiveObservationsAtDepth__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../algorithms/gatherActiveObservationsAtDepth */ "./node_modules/@juggle/resize-observer/lib/algorithms/gatherActiveObservationsAtDepth.js");





var process = function () {
    var depth = 0;
    (0,_algorithms_gatherActiveObservationsAtDepth__WEBPACK_IMPORTED_MODULE_4__.gatherActiveObservationsAtDepth)(depth);
    while ((0,_algorithms_hasActiveObservations__WEBPACK_IMPORTED_MODULE_0__.hasActiveObservations)()) {
        depth = (0,_algorithms_broadcastActiveObservations__WEBPACK_IMPORTED_MODULE_3__.broadcastActiveObservations)();
        (0,_algorithms_gatherActiveObservationsAtDepth__WEBPACK_IMPORTED_MODULE_4__.gatherActiveObservationsAtDepth)(depth);
    }
    if ((0,_algorithms_hasSkippedObservations__WEBPACK_IMPORTED_MODULE_1__.hasSkippedObservations)()) {
        (0,_algorithms_deliverResizeLoopError__WEBPACK_IMPORTED_MODULE_2__.deliverResizeLoopError)();
    }
    return depth > 0;
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js":
/*!**************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   queueMicroTask: () => (/* binding */ queueMicroTask)
/* harmony export */ });
var trigger;
var callbacks = [];
var notify = function () { return callbacks.splice(0).forEach(function (cb) { return cb(); }); };
var queueMicroTask = function (callback) {
    if (!trigger) {
        var toggle_1 = 0;
        var el_1 = document.createTextNode('');
        var config = { characterData: true };
        new MutationObserver(function () { return notify(); }).observe(el_1, config);
        trigger = function () { el_1.textContent = "".concat(toggle_1 ? toggle_1-- : toggle_1++); };
    }
    callbacks.push(callback);
    trigger();
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   queueResizeObserver: () => (/* binding */ queueResizeObserver)
/* harmony export */ });
/* harmony import */ var _queueMicroTask__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./queueMicroTask */ "./node_modules/@juggle/resize-observer/lib/utils/queueMicroTask.js");

var queueResizeObserver = function (cb) {
    (0,_queueMicroTask__WEBPACK_IMPORTED_MODULE_0__.queueMicroTask)(function ResizeObserver() {
        requestAnimationFrame(cb);
    });
};



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js":
/*!***************************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/resizeObservers.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   resizeObservers: () => (/* binding */ resizeObservers)
/* harmony export */ });
var resizeObservers = [];



/***/ }),

/***/ "./node_modules/@juggle/resize-observer/lib/utils/scheduler.js":
/*!*********************************************************************!*\
  !*** ./node_modules/@juggle/resize-observer/lib/utils/scheduler.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   scheduler: () => (/* binding */ scheduler),
/* harmony export */   updateCount: () => (/* binding */ updateCount)
/* harmony export */ });
/* harmony import */ var _process__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./process */ "./node_modules/@juggle/resize-observer/lib/utils/process.js");
/* harmony import */ var _global__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./global */ "./node_modules/@juggle/resize-observer/lib/utils/global.js");
/* harmony import */ var _queueResizeObserver__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./queueResizeObserver */ "./node_modules/@juggle/resize-observer/lib/utils/queueResizeObserver.js");



var watching = 0;
var isWatching = function () { return !!watching; };
var CATCH_PERIOD = 250;
var observerConfig = { attributes: true, characterData: true, childList: true, subtree: true };
var events = [
    'resize',
    'load',
    'transitionend',
    'animationend',
    'animationstart',
    'animationiteration',
    'keyup',
    'keydown',
    'mouseup',
    'mousedown',
    'mouseover',
    'mouseout',
    'blur',
    'focus'
];
var time = function (timeout) {
    if (timeout === void 0) { timeout = 0; }
    return Date.now() + timeout;
};
var scheduled = false;
var Scheduler = (function () {
    function Scheduler() {
        var _this = this;
        this.stopped = true;
        this.listener = function () { return _this.schedule(); };
    }
    Scheduler.prototype.run = function (timeout) {
        var _this = this;
        if (timeout === void 0) { timeout = CATCH_PERIOD; }
        if (scheduled) {
            return;
        }
        scheduled = true;
        var until = time(timeout);
        (0,_queueResizeObserver__WEBPACK_IMPORTED_MODULE_2__.queueResizeObserver)(function () {
            var elementsHaveResized = false;
            try {
                elementsHaveResized = (0,_process__WEBPACK_IMPORTED_MODULE_0__.process)();
            }
            finally {
                scheduled = false;
                timeout = until - time();
                if (!isWatching()) {
                    return;
                }
                if (elementsHaveResized) {
                    _this.run(1000);
                }
                else if (timeout > 0) {
                    _this.run(timeout);
                }
                else {
                    _this.start();
                }
            }
        });
    };
    Scheduler.prototype.schedule = function () {
        this.stop();
        this.run();
    };
    Scheduler.prototype.observe = function () {
        var _this = this;
        var cb = function () { return _this.observer && _this.observer.observe(document.body, observerConfig); };
        document.body ? cb() : _global__WEBPACK_IMPORTED_MODULE_1__.global.addEventListener('DOMContentLoaded', cb);
    };
    Scheduler.prototype.start = function () {
        var _this = this;
        if (this.stopped) {
            this.stopped = false;
            this.observer = new MutationObserver(this.listener);
            this.observe();
            events.forEach(function (name) { return _global__WEBPACK_IMPORTED_MODULE_1__.global.addEventListener(name, _this.listener, true); });
        }
    };
    Scheduler.prototype.stop = function () {
        var _this = this;
        if (!this.stopped) {
            this.observer && this.observer.disconnect();
            events.forEach(function (name) { return _global__WEBPACK_IMPORTED_MODULE_1__.global.removeEventListener(name, _this.listener, true); });
            this.stopped = true;
        }
    };
    return Scheduler;
}());
var scheduler = new Scheduler();
var updateCount = function (n) {
    !watching && n > 0 && scheduler.start();
    watching += n;
    !watching && scheduler.stop();
};



/***/ }),

/***/ "./node_modules/css-render/esm/exists.js":
/*!***********************************************!*\
  !*** ./node_modules/css-render/esm/exists.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   exists: () => (/* binding */ exists)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/css-render/esm/utils.js");

function exists(id, ssr) {
    if (id === undefined)
        return false;
    if (ssr) {
        const { context: { ids } } = ssr;
        return ids.has(id);
    }
    return (0,_utils__WEBPACK_IMPORTED_MODULE_0__.queryElement)(id) !== null;
}


/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js":
/*!**************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildFormatLongFn)
/* harmony export */ });
function buildFormatLongFn(args) {
  return function () {
    var options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    // TODO: Remove String()
    var width = options.width ? String(options.width) : args.defaultWidth;
    var format = args.formats[width] || args.formats[args.defaultWidth];
    return format;
  };
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js":
/*!************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildLocalizeFn)
/* harmony export */ });
function buildLocalizeFn(args) {
  return function (dirtyIndex, options) {
    var context = options !== null && options !== void 0 && options.context ? String(options.context) : 'standalone';
    var valuesArray;
    if (context === 'formatting' && args.formattingValues) {
      var defaultWidth = args.defaultFormattingWidth || args.defaultWidth;
      var width = options !== null && options !== void 0 && options.width ? String(options.width) : defaultWidth;
      valuesArray = args.formattingValues[width] || args.formattingValues[defaultWidth];
    } else {
      var _defaultWidth = args.defaultWidth;
      var _width = options !== null && options !== void 0 && options.width ? String(options.width) : args.defaultWidth;
      valuesArray = args.values[_width] || args.values[_defaultWidth];
    }
    var index = args.argumentCallback ? args.argumentCallback(dirtyIndex) : dirtyIndex;
    // @ts-ignore: For some reason TypeScript just don't want to match it, no matter how hard we try. I challenge you to try to remove it!
    return valuesArray[index];
  };
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildMatchFn)
/* harmony export */ });
function buildMatchFn(args) {
  return function (string) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var width = options.width;
    var matchPattern = width && args.matchPatterns[width] || args.matchPatterns[args.defaultMatchWidth];
    var matchResult = string.match(matchPattern);
    if (!matchResult) {
      return null;
    }
    var matchedString = matchResult[0];
    var parsePatterns = width && args.parsePatterns[width] || args.parsePatterns[args.defaultParseWidth];
    var key = Array.isArray(parsePatterns) ? findIndex(parsePatterns, function (pattern) {
      return pattern.test(matchedString);
    }) : findKey(parsePatterns, function (pattern) {
      return pattern.test(matchedString);
    });
    var value;
    value = args.valueCallback ? args.valueCallback(key) : key;
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value: value,
      rest: rest
    };
  };
}
function findKey(object, predicate) {
  for (var key in object) {
    if (object.hasOwnProperty(key) && predicate(object[key])) {
      return key;
    }
  }
  return undefined;
}
function findIndex(array, predicate) {
  for (var key = 0; key < array.length; key++) {
    if (predicate(array[key])) {
      return key;
    }
  }
  return undefined;
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ buildMatchPatternFn)
/* harmony export */ });
function buildMatchPatternFn(args) {
  return function (string) {
    var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var matchResult = string.match(args.matchPattern);
    if (!matchResult) return null;
    var matchedString = matchResult[0];
    var parseResult = string.match(args.parsePattern);
    if (!parseResult) return null;
    var value = args.valueCallback ? args.valueCallback(parseResult[0]) : parseResult[0];
    value = options.valueCallback ? options.valueCallback(value) : value;
    var rest = string.slice(matchedString.length);
    return {
      value: value,
      rest: rest
    };
  };
}

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var formatDistanceLocale = {
  lessThanXSeconds: {
    one: 'less than a second',
    other: 'less than {{count}} seconds'
  },
  xSeconds: {
    one: '1 second',
    other: '{{count}} seconds'
  },
  halfAMinute: 'half a minute',
  lessThanXMinutes: {
    one: 'less than a minute',
    other: 'less than {{count}} minutes'
  },
  xMinutes: {
    one: '1 minute',
    other: '{{count}} minutes'
  },
  aboutXHours: {
    one: 'about 1 hour',
    other: 'about {{count}} hours'
  },
  xHours: {
    one: '1 hour',
    other: '{{count}} hours'
  },
  xDays: {
    one: '1 day',
    other: '{{count}} days'
  },
  aboutXWeeks: {
    one: 'about 1 week',
    other: 'about {{count}} weeks'
  },
  xWeeks: {
    one: '1 week',
    other: '{{count}} weeks'
  },
  aboutXMonths: {
    one: 'about 1 month',
    other: 'about {{count}} months'
  },
  xMonths: {
    one: '1 month',
    other: '{{count}} months'
  },
  aboutXYears: {
    one: 'about 1 year',
    other: 'about {{count}} years'
  },
  xYears: {
    one: '1 year',
    other: '{{count}} years'
  },
  overXYears: {
    one: 'over 1 year',
    other: 'over {{count}} years'
  },
  almostXYears: {
    one: 'almost 1 year',
    other: 'almost {{count}} years'
  }
};
var formatDistance = function formatDistance(token, count, options) {
  var result;
  var tokenValue = formatDistanceLocale[token];
  if (typeof tokenValue === 'string') {
    result = tokenValue;
  } else if (count === 1) {
    result = tokenValue.one;
  } else {
    result = tokenValue.other.replace('{{count}}', count.toString());
  }
  if (options !== null && options !== void 0 && options.addSuffix) {
    if (options.comparison && options.comparison > 0) {
      return 'in ' + result;
    } else {
      return result + ' ago';
    }
  }
  return result;
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatDistance);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_lib/buildFormatLongFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildFormatLongFn/index.js");

var dateFormats = {
  full: 'EEEE, MMMM do, y',
  long: 'MMMM do, y',
  medium: 'MMM d, y',
  short: 'MM/dd/yyyy'
};
var timeFormats = {
  full: 'h:mm:ss a zzzz',
  long: 'h:mm:ss a z',
  medium: 'h:mm:ss a',
  short: 'h:mm a'
};
var dateTimeFormats = {
  full: "{{date}} 'at' {{time}}",
  long: "{{date}} 'at' {{time}}",
  medium: '{{date}}, {{time}}',
  short: '{{date}}, {{time}}'
};
var formatLong = {
  date: (0,_lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formats: dateFormats,
    defaultWidth: 'full'
  }),
  time: (0,_lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formats: timeFormats,
    defaultWidth: 'full'
  }),
  dateTime: (0,_lib_buildFormatLongFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    formats: dateTimeFormats,
    defaultWidth: 'full'
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatLong);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var formatRelativeLocale = {
  lastWeek: "'last' eeee 'at' p",
  yesterday: "'yesterday at' p",
  today: "'today at' p",
  tomorrow: "'tomorrow at' p",
  nextWeek: "eeee 'at' p",
  other: 'P'
};
var formatRelative = function formatRelative(token, _date, _baseDate, _options) {
  return formatRelativeLocale[token];
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (formatRelative);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_lib/buildLocalizeFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildLocalizeFn/index.js");

var eraValues = {
  narrow: ['B', 'A'],
  abbreviated: ['BC', 'AD'],
  wide: ['Before Christ', 'Anno Domini']
};
var quarterValues = {
  narrow: ['1', '2', '3', '4'],
  abbreviated: ['Q1', 'Q2', 'Q3', 'Q4'],
  wide: ['1st quarter', '2nd quarter', '3rd quarter', '4th quarter']
};

// Note: in English, the names of days of the week and months are capitalized.
// If you are making a new locale based on this one, check if the same is true for the language you're working on.
// Generally, formatted dates should look like they are in the middle of a sentence,
// e.g. in Spanish language the weekdays and months should be in the lowercase.
var monthValues = {
  narrow: ['J', 'F', 'M', 'A', 'M', 'J', 'J', 'A', 'S', 'O', 'N', 'D'],
  abbreviated: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'],
  wide: ['January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December']
};
var dayValues = {
  narrow: ['S', 'M', 'T', 'W', 'T', 'F', 'S'],
  short: ['Su', 'Mo', 'Tu', 'We', 'Th', 'Fr', 'Sa'],
  abbreviated: ['Sun', 'Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat'],
  wide: ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday']
};
var dayPeriodValues = {
  narrow: {
    am: 'a',
    pm: 'p',
    midnight: 'mi',
    noon: 'n',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  },
  abbreviated: {
    am: 'AM',
    pm: 'PM',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  },
  wide: {
    am: 'a.m.',
    pm: 'p.m.',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'morning',
    afternoon: 'afternoon',
    evening: 'evening',
    night: 'night'
  }
};
var formattingDayPeriodValues = {
  narrow: {
    am: 'a',
    pm: 'p',
    midnight: 'mi',
    noon: 'n',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  },
  abbreviated: {
    am: 'AM',
    pm: 'PM',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  },
  wide: {
    am: 'a.m.',
    pm: 'p.m.',
    midnight: 'midnight',
    noon: 'noon',
    morning: 'in the morning',
    afternoon: 'in the afternoon',
    evening: 'in the evening',
    night: 'at night'
  }
};
var ordinalNumber = function ordinalNumber(dirtyNumber, _options) {
  var number = Number(dirtyNumber);

  // If ordinal numbers depend on context, for example,
  // if they are different for different grammatical genders,
  // use `options.unit`.
  //
  // `unit` can be 'year', 'quarter', 'month', 'week', 'date', 'dayOfYear',
  // 'day', 'hour', 'minute', 'second'.

  var rem100 = number % 100;
  if (rem100 > 20 || rem100 < 10) {
    switch (rem100 % 10) {
      case 1:
        return number + 'st';
      case 2:
        return number + 'nd';
      case 3:
        return number + 'rd';
    }
  }
  return number + 'th';
};
var localize = {
  ordinalNumber: ordinalNumber,
  era: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: eraValues,
    defaultWidth: 'wide'
  }),
  quarter: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: quarterValues,
    defaultWidth: 'wide',
    argumentCallback: function argumentCallback(quarter) {
      return quarter - 1;
    }
  }),
  month: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: monthValues,
    defaultWidth: 'wide'
  }),
  day: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: dayValues,
    defaultWidth: 'wide'
  }),
  dayPeriod: (0,_lib_buildLocalizeFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    values: dayPeriodValues,
    defaultWidth: 'wide',
    formattingValues: formattingDayPeriodValues,
    defaultFormattingWidth: 'wide'
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (localize);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/_lib/match/index.js":
/*!********************************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/_lib/match/index.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_lib/buildMatchFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildMatchFn/index.js");
/* harmony import */ var _lib_buildMatchPatternFn_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_lib/buildMatchPatternFn/index.js */ "./node_modules/date-fns/esm/locale/_lib/buildMatchPatternFn/index.js");


var matchOrdinalNumberPattern = /^(\d+)(th|st|nd|rd)?/i;
var parseOrdinalNumberPattern = /\d+/i;
var matchEraPatterns = {
  narrow: /^(b|a)/i,
  abbreviated: /^(b\.?\s?c\.?|b\.?\s?c\.?\s?e\.?|a\.?\s?d\.?|c\.?\s?e\.?)/i,
  wide: /^(before christ|before common era|anno domini|common era)/i
};
var parseEraPatterns = {
  any: [/^b/i, /^(a|c)/i]
};
var matchQuarterPatterns = {
  narrow: /^[1234]/i,
  abbreviated: /^q[1234]/i,
  wide: /^[1234](th|st|nd|rd)? quarter/i
};
var parseQuarterPatterns = {
  any: [/1/i, /2/i, /3/i, /4/i]
};
var matchMonthPatterns = {
  narrow: /^[jfmasond]/i,
  abbreviated: /^(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/i,
  wide: /^(january|february|march|april|may|june|july|august|september|october|november|december)/i
};
var parseMonthPatterns = {
  narrow: [/^j/i, /^f/i, /^m/i, /^a/i, /^m/i, /^j/i, /^j/i, /^a/i, /^s/i, /^o/i, /^n/i, /^d/i],
  any: [/^ja/i, /^f/i, /^mar/i, /^ap/i, /^may/i, /^jun/i, /^jul/i, /^au/i, /^s/i, /^o/i, /^n/i, /^d/i]
};
var matchDayPatterns = {
  narrow: /^[smtwf]/i,
  short: /^(su|mo|tu|we|th|fr|sa)/i,
  abbreviated: /^(sun|mon|tue|wed|thu|fri|sat)/i,
  wide: /^(sunday|monday|tuesday|wednesday|thursday|friday|saturday)/i
};
var parseDayPatterns = {
  narrow: [/^s/i, /^m/i, /^t/i, /^w/i, /^t/i, /^f/i, /^s/i],
  any: [/^su/i, /^m/i, /^tu/i, /^w/i, /^th/i, /^f/i, /^sa/i]
};
var matchDayPeriodPatterns = {
  narrow: /^(a|p|mi|n|(in the|at) (morning|afternoon|evening|night))/i,
  any: /^([ap]\.?\s?m\.?|midnight|noon|(in the|at) (morning|afternoon|evening|night))/i
};
var parseDayPeriodPatterns = {
  any: {
    am: /^a/i,
    pm: /^p/i,
    midnight: /^mi/i,
    noon: /^no/i,
    morning: /morning/i,
    afternoon: /afternoon/i,
    evening: /evening/i,
    night: /night/i
  }
};
var match = {
  ordinalNumber: (0,_lib_buildMatchPatternFn_index_js__WEBPACK_IMPORTED_MODULE_0__["default"])({
    matchPattern: matchOrdinalNumberPattern,
    parsePattern: parseOrdinalNumberPattern,
    valueCallback: function valueCallback(value) {
      return parseInt(value, 10);
    }
  }),
  era: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchEraPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseEraPatterns,
    defaultParseWidth: 'any'
  }),
  quarter: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchQuarterPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseQuarterPatterns,
    defaultParseWidth: 'any',
    valueCallback: function valueCallback(index) {
      return index + 1;
    }
  }),
  month: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchMonthPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseMonthPatterns,
    defaultParseWidth: 'any'
  }),
  day: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchDayPatterns,
    defaultMatchWidth: 'wide',
    parsePatterns: parseDayPatterns,
    defaultParseWidth: 'any'
  }),
  dayPeriod: (0,_lib_buildMatchFn_index_js__WEBPACK_IMPORTED_MODULE_1__["default"])({
    matchPatterns: matchDayPeriodPatterns,
    defaultMatchWidth: 'any',
    parsePatterns: parseDayPeriodPatterns,
    defaultParseWidth: 'any'
  })
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (match);

/***/ }),

/***/ "./node_modules/date-fns/esm/locale/en-US/index.js":
/*!*********************************************************!*\
  !*** ./node_modules/date-fns/esm/locale/en-US/index.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _lib_formatDistance_index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_lib/formatDistance/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/formatDistance/index.js");
/* harmony import */ var _lib_formatLong_index_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_lib/formatLong/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/formatLong/index.js");
/* harmony import */ var _lib_formatRelative_index_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_lib/formatRelative/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/formatRelative/index.js");
/* harmony import */ var _lib_localize_index_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_lib/localize/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/localize/index.js");
/* harmony import */ var _lib_match_index_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_lib/match/index.js */ "./node_modules/date-fns/esm/locale/en-US/_lib/match/index.js");





/**
 * @type {Locale}
 * @category Locales
 * @summary English locale (United States).
 * @language English
 * @iso-639-2 eng
 * @author Sasha Koss [@kossnocorp]{@link https://github.com/kossnocorp}
 * @author Lesha Koss [@leshakoss]{@link https://github.com/leshakoss}
 */
var locale = {
  code: 'en-US',
  formatDistance: _lib_formatDistance_index_js__WEBPACK_IMPORTED_MODULE_0__["default"],
  formatLong: _lib_formatLong_index_js__WEBPACK_IMPORTED_MODULE_1__["default"],
  formatRelative: _lib_formatRelative_index_js__WEBPACK_IMPORTED_MODULE_2__["default"],
  localize: _lib_localize_index_js__WEBPACK_IMPORTED_MODULE_3__["default"],
  match: _lib_match_index_js__WEBPACK_IMPORTED_MODULE_4__["default"],
  options: {
    weekStartsOn: 0 /* Sunday */,
    firstWeekContainsDate: 1
  }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (locale);

/***/ }),

/***/ "./node_modules/evtd/es/delegate.js":
/*!******************************************!*\
  !*** ./node_modules/evtd/es/delegate.js ***!
  \******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   off: () => (/* binding */ off),
/* harmony export */   on: () => (/* binding */ on)
/* harmony export */ });
/* harmony import */ var _traps__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./traps */ "./node_modules/evtd/es/traps.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/evtd/es/utils.js");


// currently `once` and `passive` is not supported
function createDelegate() {
    if (typeof window === 'undefined') {
        return {
            on: () => { },
            off: () => { }
        };
    }
    const propagationStopped = new WeakMap();
    const immediatePropagationStopped = new WeakMap();
    function trackPropagation() {
        propagationStopped.set(this, true);
    }
    function trackImmediate() {
        propagationStopped.set(this, true);
        immediatePropagationStopped.set(this, true);
    }
    function spy(event, propName, fn) {
        const source = event[propName];
        event[propName] = function () {
            fn.apply(event, arguments);
            return source.apply(event, arguments);
        };
        return event;
    }
    function unspy(event, propName) {
        event[propName] = Event.prototype[propName];
    }
    const currentTargets = new WeakMap();
    const currentTargetDescriptor = Object.getOwnPropertyDescriptor(Event.prototype, 'currentTarget');
    function getCurrentTarget() {
        var _a;
        return (_a = currentTargets.get(this)) !== null && _a !== void 0 ? _a : null;
    }
    function defineCurrentTarget(event, getter) {
        if (currentTargetDescriptor === undefined)
            return;
        Object.defineProperty(event, 'currentTarget', {
            configurable: true,
            enumerable: true,
            get: getter !== null && getter !== void 0 ? getter : currentTargetDescriptor.get
        });
    }
    const phaseToTypeToElToHandlers = {
        bubble: {},
        capture: {}
    };
    const typeToWindowEventHandlers = {};
    function createUnifiedHandler() {
        const delegeteHandler = function (e) {
            const { type, eventPhase, bubbles } = e;
            const target = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e);
            if (eventPhase === 2)
                return;
            const phase = eventPhase === 1 ? 'capture' : 'bubble';
            let cursor = target;
            const path = [];
            // collecting bubble path
            while (true) {
                if (cursor === null)
                    cursor = window;
                path.push(cursor);
                if (cursor === window) {
                    break;
                }
                // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
                cursor = (cursor.parentNode || null);
            }
            const captureElToHandlers = phaseToTypeToElToHandlers.capture[type];
            const bubbleElToHandlers = phaseToTypeToElToHandlers.bubble[type];
            spy(e, 'stopPropagation', trackPropagation);
            spy(e, 'stopImmediatePropagation', trackImmediate);
            defineCurrentTarget(e, getCurrentTarget);
            if (phase === 'capture') {
                if (captureElToHandlers === undefined)
                    return;
                // capture
                for (let i = path.length - 1; i >= 0; --i) {
                    if (propagationStopped.has(e))
                        break;
                    const target = path[i];
                    const handlers = captureElToHandlers.get(target);
                    if (handlers !== undefined) {
                        currentTargets.set(e, target);
                        for (const handler of handlers) {
                            if (immediatePropagationStopped.has(e))
                                break;
                            handler(e);
                        }
                    }
                    if (i === 0 && !bubbles && bubbleElToHandlers !== undefined) {
                        const bubbleHandlers = bubbleElToHandlers.get(target);
                        if (bubbleHandlers !== undefined) {
                            for (const handler of bubbleHandlers) {
                                if (immediatePropagationStopped.has(e))
                                    break;
                                handler(e);
                            }
                        }
                    }
                }
            }
            else if (phase === 'bubble') {
                if (bubbleElToHandlers === undefined)
                    return;
                // bubble
                for (let i = 0; i < path.length; ++i) {
                    if (propagationStopped.has(e))
                        break;
                    const target = path[i];
                    const handlers = bubbleElToHandlers.get(target);
                    if (handlers !== undefined) {
                        currentTargets.set(e, target);
                        for (const handler of handlers) {
                            if (immediatePropagationStopped.has(e))
                                break;
                            handler(e);
                        }
                    }
                }
            }
            unspy(e, 'stopPropagation');
            unspy(e, 'stopImmediatePropagation');
            defineCurrentTarget(e);
        };
        delegeteHandler.displayName = 'evtdUnifiedHandler';
        return delegeteHandler;
    }
    function createUnifiedWindowEventHandler() {
        const delegateHandler = function (e) {
            const { type, eventPhase } = e;
            if (eventPhase !== 2)
                return;
            const handlers = typeToWindowEventHandlers[type];
            if (handlers === undefined)
                return;
            handlers.forEach((handler) => handler(e));
        };
        delegateHandler.displayName = 'evtdUnifiedWindowEventHandler';
        return delegateHandler;
    }
    const unifiedHandler = createUnifiedHandler();
    const unfiendWindowEventHandler = createUnifiedWindowEventHandler();
    function ensureElToHandlers(phase, type) {
        const phaseHandlers = phaseToTypeToElToHandlers[phase];
        if (phaseHandlers[type] === undefined) {
            phaseHandlers[type] = new Map();
            window.addEventListener(type, unifiedHandler, phase === 'capture');
        }
        return phaseHandlers[type];
    }
    function ensureWindowEventHandlers(type) {
        const windowEventHandlers = typeToWindowEventHandlers[type];
        if (windowEventHandlers === undefined) {
            typeToWindowEventHandlers[type] = new Set();
            window.addEventListener(type, unfiendWindowEventHandler);
        }
        return typeToWindowEventHandlers[type];
    }
    function ensureHandlers(elToHandlers, el) {
        let elHandlers = elToHandlers.get(el);
        if (elHandlers === undefined) {
            elToHandlers.set(el, (elHandlers = new Set()));
        }
        return elHandlers;
    }
    function handlerExist(el, phase, type, handler) {
        const elToHandlers = phaseToTypeToElToHandlers[phase][type];
        // phase ${type} event has handlers
        if (elToHandlers !== undefined) {
            const handlers = elToHandlers.get(el);
            // phase using el with ${type} event has handlers
            if (handlers !== undefined) {
                if (handlers.has(handler))
                    return true;
            }
        }
        return false;
    }
    function windowEventHandlerExist(type, handler) {
        const handlers = typeToWindowEventHandlers[type];
        if (handlers !== undefined) {
            if (handlers.has(handler)) {
                return true;
            }
        }
        return false;
    }
    function on(type, el, handler, options) {
        let mergedHandler;
        if (typeof options === 'object' && options.once === true) {
            mergedHandler = (e) => {
                off(type, el, mergedHandler, options);
                handler(e);
            };
        }
        else {
            mergedHandler = handler;
        }
        const trapped = (0,_traps__WEBPACK_IMPORTED_MODULE_1__.trapOn)(type, el, mergedHandler, options);
        if (trapped)
            return;
        const phase = options === true ||
            (typeof options === 'object' && options.capture === true)
            ? 'capture'
            : 'bubble';
        const elToHandlers = ensureElToHandlers(phase, type);
        const handlers = ensureHandlers(elToHandlers, el);
        if (!handlers.has(mergedHandler))
            handlers.add(mergedHandler);
        if (el === window) {
            const windowEventHandlers = ensureWindowEventHandlers(type);
            if (!windowEventHandlers.has(mergedHandler)) {
                windowEventHandlers.add(mergedHandler);
            }
        }
    }
    function off(type, el, handler, options) {
        const trapped = (0,_traps__WEBPACK_IMPORTED_MODULE_1__.trapOff)(type, el, handler, options);
        if (trapped)
            return;
        const capture = options === true ||
            (typeof options === 'object' && options.capture === true);
        const phase = capture ? 'capture' : 'bubble';
        const elToHandlers = ensureElToHandlers(phase, type);
        const handlers = ensureHandlers(elToHandlers, el);
        if (el === window) {
            const mirrorPhase = capture ? 'bubble' : 'capture';
            if (!handlerExist(el, mirrorPhase, type, handler) &&
                windowEventHandlerExist(type, handler)) {
                // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
                const windowEventHandlers = typeToWindowEventHandlers[type];
                windowEventHandlers.delete(handler);
                if (windowEventHandlers.size === 0) {
                    window.removeEventListener(type, unfiendWindowEventHandler);
                    typeToWindowEventHandlers[type] = undefined;
                }
            }
        }
        if (handlers.has(handler))
            handlers.delete(handler);
        if (handlers.size === 0) {
            elToHandlers.delete(el);
        }
        if (elToHandlers.size === 0) {
            window.removeEventListener(type, unifiedHandler, phase === 'capture');
            phaseToTypeToElToHandlers[phase][type] = undefined;
        }
    }
    return {
        on: on,
        off: off
    };
}
const { on, off } = createDelegate();



/***/ }),

/***/ "./node_modules/evtd/es/traps.js":
/*!***************************************!*\
  !*** ./node_modules/evtd/es/traps.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   trapOff: () => (/* binding */ trapOff),
/* harmony export */   trapOn: () => (/* binding */ trapOn)
/* harmony export */ });
/* harmony import */ var _delegate__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./delegate */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils */ "./node_modules/evtd/es/utils.js");


const traps = {
    mousemoveoutside: new WeakMap(),
    clickoutside: new WeakMap()
};
function createTrapHandler(name, el, originalHandler) {
    if (name === 'mousemoveoutside') {
        const moveHandler = (e) => {
            if (el.contains((0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e)))
                return;
            originalHandler(e);
        };
        return {
            mousemove: moveHandler,
            touchstart: moveHandler
        };
    }
    else if (name === 'clickoutside') {
        let mouseDownOutside = false;
        const downHandler = (e) => {
            mouseDownOutside = !el.contains((0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e));
        };
        const upHanlder = (e) => {
            if (!mouseDownOutside)
                return;
            if (el.contains((0,_utils__WEBPACK_IMPORTED_MODULE_0__.getEventTarget)(e)))
                return;
            originalHandler(e);
        };
        return {
            mousedown: downHandler,
            mouseup: upHanlder,
            touchstart: downHandler,
            touchend: upHanlder
        };
    }
    console.error(
    // eslint-disable-next-line @typescript-eslint/restrict-template-expressions
    `[evtd/create-trap-handler]: name \`${name}\` is invalid. This could be a bug of evtd.`);
    return {};
}
function ensureTrapHandlers(name, el, handler) {
    const handlers = traps[name];
    let elHandlers = handlers.get(el);
    if (elHandlers === undefined) {
        handlers.set(el, (elHandlers = new WeakMap()));
    }
    let trapHandler = elHandlers.get(handler);
    if (trapHandler === undefined) {
        elHandlers.set(handler, (trapHandler = createTrapHandler(name, el, handler)));
    }
    return trapHandler;
}
function trapOn(name, el, handler, options) {
    if (name === 'mousemoveoutside' || name === 'clickoutside') {
        const trapHandlers = ensureTrapHandlers(name, el, handler);
        Object.keys(trapHandlers).forEach((key) => {
            (0,_delegate__WEBPACK_IMPORTED_MODULE_1__.on)(key, document, trapHandlers[key], options);
        });
        return true;
    }
    return false;
}
function trapOff(name, el, handler, options) {
    if (name === 'mousemoveoutside' || name === 'clickoutside') {
        const trapHandlers = ensureTrapHandlers(name, el, handler);
        Object.keys(trapHandlers).forEach((key) => {
            (0,_delegate__WEBPACK_IMPORTED_MODULE_1__.off)(key, document, trapHandlers[key], options);
        });
        return true;
    }
    return false;
}



/***/ }),

/***/ "./node_modules/evtd/es/utils.js":
/*!***************************************!*\
  !*** ./node_modules/evtd/es/utils.js ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getEventTarget: () => (/* binding */ getEventTarget)
/* harmony export */ });
function getEventTarget(e) {
    const path = e.composedPath();
    return path[0];
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icon/src/Icon.js":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icon/src/Icon.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-style.js");
/* harmony import */ var _styles_index_cssr__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./styles/index.cssr */ "./node_modules/naive-ui/es/_internal/icon/src/styles/index.cssr.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'BaseIcon',
    props: {
        role: String,
        ariaLabel: String,
        ariaDisabled: {
            type: Boolean,
            default: undefined
        },
        ariaHidden: {
            type: Boolean,
            default: undefined
        },
        clsPrefix: {
            type: String,
            required: true
        },
        onClick: Function,
        onMousedown: Function,
        onMouseup: Function
    },
    setup(props) {
        (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('-base-icon', _styles_index_cssr__WEBPACK_IMPORTED_MODULE_2__["default"], (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'clsPrefix'));
    },
    render() {
        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("i", { class: `${this.clsPrefix}-base-icon`, onClick: this.onClick, onMousedown: this.onMousedown, onMouseup: this.onMouseup, role: this.role, "aria-label": this.ariaLabel, "aria-hidden": this.ariaHidden, "aria-disabled": this.ariaDisabled }, this.$slots));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icon/src/styles/index.cssr.js":
/*!**************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icon/src/styles/index.cssr.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 height: 1em;
 width: 1em;
 line-height: 1em;
 text-align: center;
 display: inline-block;
 position: relative;
 fill: currentColor;
 transform: translateZ(0);
`, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('svg', `
 height: 1em;
 width: 1em;
 `)]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/replaceable.js":
/*!*****************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/replaceable.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   replaceable: () => (/* binding */ replaceable)
/* harmony export */ });
/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/upperFirst.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _config_provider_src_context__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../config-provider/src/context */ "./node_modules/naive-ui/es/config-provider/src/context.js");



// eslint-disable-next-line @typescript-eslint/explicit-function-return-type
function replaceable(name, icon) {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
        name: (0,lodash_es__WEBPACK_IMPORTED_MODULE_1__["default"])(name),
        setup() {
            var _a;
            const mergedIconsRef = (_a = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context__WEBPACK_IMPORTED_MODULE_2__.configProviderInjectionKey, null)) === null || _a === void 0 ? void 0 : _a.mergedIconsRef;
            return () => {
                var _a;
                const iconOverride = (_a = mergedIconsRef === null || mergedIconsRef === void 0 ? void 0 : mergedIconsRef.value) === null || _a === void 0 ? void 0 : _a[name];
                return iconOverride ? iconOverride() : icon;
            };
        }
    });
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.js":
/*!***********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   XScrollbar: () => (/* binding */ XScrollbar),
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-is-ios.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/dom/get-precise-event-target.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-theme.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-config.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-rtl.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../_utils */ "./node_modules/naive-ui/es/_utils/composable/use-reactivated.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../../_utils */ "./node_modules/naive-ui/es/_utils/vue/wrapper.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../styles */ "./node_modules/naive-ui/es/_internal/scrollbar/styles/light.js");
/* harmony import */ var _styles_index_cssr__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./styles/index.cssr */ "./node_modules/naive-ui/es/_internal/scrollbar/src/styles/index.cssr.js");









const scrollbarProps = Object.assign(Object.assign({}, _mixins__WEBPACK_IMPORTED_MODULE_1__["default"].props), { size: {
        type: Number,
        default: 5
    }, duration: {
        type: Number,
        default: 0
    }, scrollable: {
        type: Boolean,
        default: true
    }, xScrollable: Boolean, trigger: {
        type: String,
        default: 'hover'
    }, useUnifiedContainer: Boolean, triggerDisplayManually: Boolean, 
    // If container is set, resize observer won't not attached
    container: Function, content: Function, containerClass: String, containerStyle: [String, Object], contentClass: String, contentStyle: [String, Object], horizontalRailStyle: [String, Object], verticalRailStyle: [String, Object], onScroll: Function, onWheel: Function, onResize: Function, internalOnUpdateScrollLeft: Function, internalHoistYRail: Boolean });
const Scrollbar = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Scrollbar',
    props: scrollbarProps,
    inheritAttrs: false,
    setup(props) {
        const { mergedClsPrefixRef, inlineThemeDisabled, mergedRtlRef } = (0,_mixins__WEBPACK_IMPORTED_MODULE_2__["default"])(props);
        const rtlEnabledRef = (0,_mixins__WEBPACK_IMPORTED_MODULE_3__.useRtl)('Scrollbar', mergedRtlRef, mergedClsPrefixRef);
        // dom ref
        const wrapperRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const contentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const yRailRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const xRailRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        // data ref
        const contentHeightRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const contentWidthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerHeightRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerWidthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const yRailSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const xRailSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const containerScrollTopRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        const containerScrollLeftRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(0);
        const isShowXBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const isShowYBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        let yBarPressed = false;
        let xBarPressed = false;
        let xBarVanishTimerId;
        let yBarVanishTimerId;
        let memoYTop = 0;
        let memoXLeft = 0;
        let memoMouseX = 0;
        let memoMouseY = 0;
        const isIos = (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])();
        const yBarSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yRailSize } = yRailSizeRef;
            if (containerHeight === null ||
                contentHeight === null ||
                yRailSize === null) {
                return 0;
            }
            else {
                return Math.min(containerHeight, (yRailSize * containerHeight) / contentHeight + props.size * 1.5);
            }
        });
        const yBarSizePxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${yBarSizeRef.value}px`;
        });
        const xBarSizeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xRailSize } = xRailSizeRef;
            if (containerWidth === null ||
                contentWidth === null ||
                xRailSize === null) {
                return 0;
            }
            else {
                return (xRailSize * containerWidth) / contentWidth + props.size * 1.5;
            }
        });
        const xBarSizePxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${xBarSizeRef.value}px`;
        });
        const yBarTopRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: containerScrollTop } = containerScrollTopRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yRailSize } = yRailSizeRef;
            if (containerHeight === null ||
                contentHeight === null ||
                yRailSize === null) {
                return 0;
            }
            else {
                const heightDiff = contentHeight - containerHeight;
                if (!heightDiff)
                    return 0;
                return ((containerScrollTop / heightDiff) * (yRailSize - yBarSizeRef.value));
            }
        });
        const yBarTopPxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${yBarTopRef.value}px`;
        });
        const xBarLeftRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: containerScrollLeft } = containerScrollLeftRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xRailSize } = xRailSizeRef;
            if (containerWidth === null ||
                contentWidth === null ||
                xRailSize === null) {
                return 0;
            }
            else {
                const widthDiff = contentWidth - containerWidth;
                if (!widthDiff)
                    return 0;
                return ((containerScrollLeft / widthDiff) * (xRailSize - xBarSizeRef.value));
            }
        });
        const xBarLeftPxRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            return `${xBarLeftRef.value}px`;
        });
        const needYBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            return (containerHeight !== null &&
                contentHeight !== null &&
                contentHeight > containerHeight);
        });
        const needXBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            return (containerWidth !== null &&
                contentWidth !== null &&
                contentWidth > containerWidth);
        });
        const mergedShowXBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { trigger } = props;
            return trigger === 'none' || isShowXBarRef.value;
        });
        const mergedShowYBarRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { trigger } = props;
            return trigger === 'none' || isShowYBarRef.value;
        });
        const mergedContainerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { container } = props;
            if (container)
                return container();
            return containerRef.value;
        });
        const mergedContentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { content } = props;
            if (content)
                return content();
            return contentRef.value;
        });
        const activateState = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.useReactivated)(() => {
            // Only restore for builtin container & content
            if (!props.container) {
                // remount
                scrollTo({
                    top: containerScrollTopRef.value,
                    left: containerScrollLeftRef.value
                });
            }
        });
        // methods
        const handleContentResize = () => {
            if (activateState.isDeactivated)
                return;
            sync();
        };
        const handleContainerResize = (e) => {
            if (activateState.isDeactivated)
                return;
            const { onResize } = props;
            if (onResize)
                onResize(e);
            sync();
        };
        const scrollTo = (options, y) => {
            if (!props.scrollable)
                return;
            if (typeof options === 'number') {
                scrollToPosition(y !== null && y !== void 0 ? y : 0, options, 0, false, 'auto');
                return;
            }
            const { left, top, index, elSize, position, behavior, el, debounce = true } = options;
            if (left !== undefined || top !== undefined) {
                scrollToPosition(left !== null && left !== void 0 ? left : 0, top !== null && top !== void 0 ? top : 0, 0, false, behavior);
            }
            if (el !== undefined) {
                scrollToPosition(0, el.offsetTop, el.offsetHeight, debounce, behavior);
            }
            else if (index !== undefined && elSize !== undefined) {
                scrollToPosition(0, index * elSize, elSize, debounce, behavior);
            }
            else if (position === 'bottom') {
                scrollToPosition(0, Number.MAX_SAFE_INTEGER, 0, false, behavior);
            }
            else if (position === 'top') {
                scrollToPosition(0, 0, 0, false, behavior);
            }
        };
        const scrollBy = (options, y) => {
            if (!props.scrollable)
                return;
            const { value: container } = mergedContainerRef;
            if (!container)
                return;
            if (typeof options === 'object') {
                container.scrollBy(options);
            }
            else {
                container.scrollBy(options, y || 0);
            }
        };
        function scrollToPosition(left, top, elSize, debounce, behavior) {
            const { value: container } = mergedContainerRef;
            if (!container)
                return;
            if (debounce) {
                const { scrollTop, offsetHeight } = container;
                if (top > scrollTop) {
                    if (top + elSize <= scrollTop + offsetHeight) {
                        // do nothing
                    }
                    else {
                        container.scrollTo({
                            left,
                            top: top + elSize - offsetHeight,
                            behavior
                        });
                    }
                    return;
                }
            }
            container.scrollTo({
                left,
                top,
                behavior
            });
        }
        function handleMouseEnterWrapper() {
            showXBar();
            showYBar();
            sync();
        }
        function handleMouseLeaveWrapper() {
            hideBar();
        }
        function hideBar() {
            hideYBar();
            hideXBar();
        }
        function hideYBar() {
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            yBarVanishTimerId = window.setTimeout(() => {
                isShowYBarRef.value = false;
            }, props.duration);
        }
        function hideXBar() {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            xBarVanishTimerId = window.setTimeout(() => {
                isShowXBarRef.value = false;
            }, props.duration);
        }
        function showXBar() {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            isShowXBarRef.value = true;
        }
        function showYBar() {
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            isShowYBarRef.value = true;
        }
        function handleScroll(e) {
            const { onScroll } = props;
            if (onScroll)
                onScroll(e);
            syncScrollState();
        }
        function syncScrollState() {
            // only collect scroll state, do not trigger any dom event
            const { value: container } = mergedContainerRef;
            if (container) {
                containerScrollTopRef.value = container.scrollTop;
                containerScrollLeftRef.value =
                    container.scrollLeft * ((rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value) ? -1 : 1);
            }
        }
        function syncPositionState() {
            // only collect position state, do not trigger any dom event
            // Don't use getClientBoundingRect because element may be scale transformed
            const { value: content } = mergedContentRef;
            if (content) {
                contentHeightRef.value = content.offsetHeight;
                contentWidthRef.value = content.offsetWidth;
            }
            const { value: container } = mergedContainerRef;
            if (container) {
                containerHeightRef.value = container.offsetHeight;
                containerWidthRef.value = container.offsetWidth;
            }
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                xRailSizeRef.value = xRailEl.offsetWidth;
            }
            if (yRailEl) {
                yRailSizeRef.value = yRailEl.offsetHeight;
            }
        }
        /**
         * Sometimes there's only one element that we can scroll,
         * For example for textarea, there won't be a content element.
         */
        function syncUnifiedContainer() {
            const { value: container } = mergedContainerRef;
            if (container) {
                containerScrollTopRef.value = container.scrollTop;
                containerScrollLeftRef.value =
                    container.scrollLeft * ((rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value) ? -1 : 1);
                containerHeightRef.value = container.offsetHeight;
                containerWidthRef.value = container.offsetWidth;
                contentHeightRef.value = container.scrollHeight;
                contentWidthRef.value = container.scrollWidth;
            }
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                xRailSizeRef.value = xRailEl.offsetWidth;
            }
            if (yRailEl) {
                yRailSizeRef.value = yRailEl.offsetHeight;
            }
        }
        function sync() {
            if (!props.scrollable)
                return;
            if (props.useUnifiedContainer) {
                syncUnifiedContainer();
            }
            else {
                syncPositionState();
                syncScrollState();
            }
        }
        function isMouseUpAway(e) {
            var _a;
            return !((_a = wrapperRef.value) === null || _a === void 0 ? void 0 : _a.contains((0,seemly__WEBPACK_IMPORTED_MODULE_6__.getPreciseEventTarget)(e)));
        }
        function handleXScrollMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();
            xBarPressed = true;
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mousemove', window, handleXScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mouseup', window, handleXScrollMouseUp, true);
            memoXLeft = containerScrollLeftRef.value;
            memoMouseX = (rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value)
                ? window.innerWidth - e.clientX
                : e.clientX;
        }
        function handleXScrollMouseMove(e) {
            if (!xBarPressed)
                return;
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            const { value: containerWidth } = containerWidthRef;
            const { value: contentWidth } = contentWidthRef;
            const { value: xBarSize } = xBarSizeRef;
            if (containerWidth === null || contentWidth === null)
                return;
            const dX = (rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value)
                ? window.innerWidth - e.clientX - memoMouseX
                : e.clientX - memoMouseX;
            const dScrollLeft = (dX * (contentWidth - containerWidth)) / (containerWidth - xBarSize);
            const toScrollLeftUpperBound = contentWidth - containerWidth;
            let toScrollLeft = memoXLeft + dScrollLeft;
            toScrollLeft = Math.min(toScrollLeftUpperBound, toScrollLeft);
            toScrollLeft = Math.max(toScrollLeft, 0);
            const { value: container } = mergedContainerRef;
            if (container) {
                container.scrollLeft = toScrollLeft * ((rtlEnabledRef === null || rtlEnabledRef === void 0 ? void 0 : rtlEnabledRef.value) ? -1 : 1);
                const { internalOnUpdateScrollLeft } = props;
                if (internalOnUpdateScrollLeft)
                    internalOnUpdateScrollLeft(toScrollLeft);
            }
        }
        function handleXScrollMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mousemove', window, handleXScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mouseup', window, handleXScrollMouseUp, true);
            xBarPressed = false;
            sync();
            if (isMouseUpAway(e)) {
                hideBar();
            }
        }
        function handleYScrollMouseDown(e) {
            e.preventDefault();
            e.stopPropagation();
            yBarPressed = true;
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mousemove', window, handleYScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.on)('mouseup', window, handleYScrollMouseUp, true);
            memoYTop = containerScrollTopRef.value;
            memoMouseY = e.clientY;
        }
        function handleYScrollMouseMove(e) {
            if (!yBarPressed)
                return;
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            const { value: containerHeight } = containerHeightRef;
            const { value: contentHeight } = contentHeightRef;
            const { value: yBarSize } = yBarSizeRef;
            if (containerHeight === null || contentHeight === null)
                return;
            const dY = e.clientY - memoMouseY;
            const dScrollTop = (dY * (contentHeight - containerHeight)) / (containerHeight - yBarSize);
            const toScrollTopUpperBound = contentHeight - containerHeight;
            let toScrollTop = memoYTop + dScrollTop;
            toScrollTop = Math.min(toScrollTopUpperBound, toScrollTop);
            toScrollTop = Math.max(toScrollTop, 0);
            const { value: container } = mergedContainerRef;
            if (container) {
                container.scrollTop = toScrollTop;
            }
        }
        function handleYScrollMouseUp(e) {
            e.preventDefault();
            e.stopPropagation();
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mousemove', window, handleYScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mouseup', window, handleYScrollMouseUp, true);
            yBarPressed = false;
            sync();
            if (isMouseUpAway(e)) {
                hideBar();
            }
        }
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
            const { value: needXBar } = needXBarRef;
            const { value: needYBar } = needYBarRef;
            const { value: mergedClsPrefix } = mergedClsPrefixRef;
            const { value: xRailEl } = xRailRef;
            const { value: yRailEl } = yRailRef;
            if (xRailEl) {
                if (!needXBar) {
                    xRailEl.classList.add(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
                else {
                    xRailEl.classList.remove(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
            }
            if (yRailEl) {
                if (!needYBar) {
                    yRailEl.classList.add(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
                else {
                    yRailEl.classList.remove(`${mergedClsPrefix}-scrollbar-rail--disabled`);
                }
            }
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            // if container exist, it always can't be resolved when scrollbar is mounted
            // for example:
            // - component
            //   - scrollbar
            //     - inner
            // if you pass inner to scrollbar, you may use a ref inside component
            // however, when scrollbar is mounted, ref is not ready at component
            // you need to init by yourself
            if (props.container)
                return;
            sync();
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            if (xBarVanishTimerId !== undefined) {
                window.clearTimeout(xBarVanishTimerId);
            }
            if (yBarVanishTimerId !== undefined) {
                window.clearTimeout(yBarVanishTimerId);
            }
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mousemove', window, handleYScrollMouseMove, true);
            (0,evtd__WEBPACK_IMPORTED_MODULE_7__.off)('mouseup', window, handleYScrollMouseUp, true);
        });
        const themeRef = (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('Scrollbar', '-scrollbar', _styles_index_cssr__WEBPACK_IMPORTED_MODULE_8__["default"], _styles__WEBPACK_IMPORTED_MODULE_9__["default"], props, mergedClsPrefixRef);
        const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { common: { cubicBezierEaseInOut, scrollbarBorderRadius, scrollbarHeight, scrollbarWidth }, self: { color, colorHover } } = themeRef.value;
            return {
                '--n-scrollbar-bezier': cubicBezierEaseInOut,
                '--n-scrollbar-color': color,
                '--n-scrollbar-color-hover': colorHover,
                '--n-scrollbar-border-radius': scrollbarBorderRadius,
                '--n-scrollbar-width': scrollbarWidth,
                '--n-scrollbar-height': scrollbarHeight
            };
        });
        const themeClassHandle = inlineThemeDisabled
            ? (0,_mixins__WEBPACK_IMPORTED_MODULE_10__.useThemeClass)('scrollbar', undefined, cssVarsRef, props)
            : undefined;
        const exposedMethods = {
            scrollTo,
            scrollBy,
            sync,
            syncUnifiedContainer,
            handleMouseEnterWrapper,
            handleMouseLeaveWrapper
        };
        return Object.assign(Object.assign({}, exposedMethods), { mergedClsPrefix: mergedClsPrefixRef, rtlEnabled: rtlEnabledRef, containerScrollTop: containerScrollTopRef, wrapperRef,
            containerRef,
            contentRef,
            yRailRef,
            xRailRef, needYBar: needYBarRef, needXBar: needXBarRef, yBarSizePx: yBarSizePxRef, xBarSizePx: xBarSizePxRef, yBarTopPx: yBarTopPxRef, xBarLeftPx: xBarLeftPxRef, isShowXBar: mergedShowXBarRef, isShowYBar: mergedShowYBarRef, isIos,
            handleScroll,
            handleContentResize,
            handleContainerResize,
            handleYScrollMouseDown,
            handleXScrollMouseDown, cssVars: inlineThemeDisabled ? undefined : cssVarsRef, themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass, onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender });
    },
    render() {
        var _a;
        const { $slots, mergedClsPrefix, triggerDisplayManually, rtlEnabled, internalHoistYRail } = this;
        if (!this.scrollable)
            return (_a = $slots.default) === null || _a === void 0 ? void 0 : _a.call($slots);
        const triggerIsNone = this.trigger === 'none';
        const createYRail = () => {
            return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "yRailRef", class: [
                    `${mergedClsPrefix}-scrollbar-rail`,
                    `${mergedClsPrefix}-scrollbar-rail--vertical`
                ], "data-scrollbar-rail": true, style: this.verticalRailStyle, "aria-hidden": true }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)((triggerIsNone ? _utils__WEBPACK_IMPORTED_MODULE_11__.Wrapper : vue__WEBPACK_IMPORTED_MODULE_0__.Transition), triggerIsNone ? null : { name: 'fade-in-transition' }, {
                default: () => this.needYBar && this.isShowYBar && !this.isIos ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-scrollbar-rail__scrollbar`, style: {
                        height: this.yBarSizePx,
                        top: this.yBarTopPx
                    }, onMousedown: this.handleYScrollMouseDown })) : null
            })));
        };
        const createChildren = () => {
            var _a, _b;
            (_a = this.onRender) === null || _a === void 0 ? void 0 : _a.call(this);
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', (0,vue__WEBPACK_IMPORTED_MODULE_0__.mergeProps)(this.$attrs, {
                role: 'none',
                ref: 'wrapperRef',
                class: [
                    `${mergedClsPrefix}-scrollbar`,
                    this.themeClass,
                    rtlEnabled && `${mergedClsPrefix}-scrollbar--rtl`
                ],
                style: this.cssVars,
                onMouseenter: triggerDisplayManually
                    ? undefined
                    : this.handleMouseEnterWrapper,
                onMouseleave: triggerDisplayManually
                    ? undefined
                    : this.handleMouseLeaveWrapper
            }), [
                this.container ? ((_b = $slots.default) === null || _b === void 0 ? void 0 : _b.call($slots)) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { role: "none", ref: "containerRef", class: [
                        `${mergedClsPrefix}-scrollbar-container`,
                        this.containerClass
                    ], style: this.containerStyle, onScroll: this.handleScroll, onWheel: this.onWheel },
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_12__["default"], { onResize: this.handleContentResize }, {
                        default: () => ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "contentRef", role: "none", style: [
                                {
                                    width: this.xScrollable ? 'fit-content' : null
                                },
                                this.contentStyle
                            ], class: [
                                `${mergedClsPrefix}-scrollbar-content`,
                                this.contentClass
                            ] }, $slots))
                    }))),
                internalHoistYRail ? null : createYRail(),
                this.xScrollable && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "xRailRef", class: [
                        `${mergedClsPrefix}-scrollbar-rail`,
                        `${mergedClsPrefix}-scrollbar-rail--horizontal`
                    ], style: this.horizontalRailStyle, "data-scrollbar-rail": true, "aria-hidden": true }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)((triggerIsNone ? _utils__WEBPACK_IMPORTED_MODULE_11__.Wrapper : vue__WEBPACK_IMPORTED_MODULE_0__.Transition), triggerIsNone ? null : { name: 'fade-in-transition' }, {
                    default: () => this.needXBar && this.isShowXBar && !this.isIos ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-scrollbar-rail__scrollbar`, style: {
                            width: this.xBarSizePx,
                            right: rtlEnabled ? this.xBarLeftPx : undefined,
                            left: rtlEnabled ? undefined : this.xBarLeftPx
                        }, onMousedown: this.handleXScrollMouseDown })) : null
                })))
            ]);
        };
        const scrollbarNode = this.container ? (createChildren()) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_12__["default"], { onResize: this.handleContainerResize }, {
            default: createChildren
        }));
        if (internalHoistYRail) {
            return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                scrollbarNode,
                createYRail()));
        }
        else {
            return scrollbarNode;
        }
    }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Scrollbar);
const XScrollbar = Scrollbar;


/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/scrollbar/src/styles/index.cssr.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/scrollbar/src/styles/index.cssr.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _styles_transitions_fade_in_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../../_styles/transitions/fade-in.cssr */ "./node_modules/naive-ui/es/_styles/transitions/fade-in.cssr.js");


// vars:
// --n-scrollbar-bezier
// --n-scrollbar-color
// --n-scrollbar-color-hover
// --n-scrollbar-width
// --n-scrollbar-height
// --n-scrollbar-border-radius
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar', `
 overflow: hidden;
 position: relative;
 z-index: auto;
 height: 100%;
 width: 100%;
`, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar-container', `
 width: 100%;
 overflow: scroll;
 height: 100%;
 max-height: inherit;
 scrollbar-width: none;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', `
 width: 0;
 height: 0;
 display: none;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar-content', `
 box-sizing: border-box;
 min-width: 100%;
 `)])])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>, +', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('scrollbar-rail', `
 position: absolute;
 pointer-events: none;
 user-select: none;
 -webkit-user-select: none;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('horizontal', `
 left: 2px;
 right: 2px;
 bottom: 4px;
 height: var(--n-scrollbar-height);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', `
 height: var(--n-scrollbar-height);
 border-radius: var(--n-scrollbar-border-radius);
 right: 0;
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('vertical', `
 right: 4px;
 top: 2px;
 bottom: 2px;
 width: var(--n-scrollbar-width);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', `
 width: var(--n-scrollbar-width);
 border-radius: var(--n-scrollbar-border-radius);
 bottom: 0;
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', {
  pointerEvents: 'none'
})])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('scrollbar', `
 position: absolute;
 cursor: pointer;
 pointer-events: all;
 background-color: var(--n-scrollbar-color);
 transition: background-color .2s var(--n-scrollbar-bezier);
 `, [(0,_styles_transitions_fade_in_cssr__WEBPACK_IMPORTED_MODULE_1__.fadeInTransition)(), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', {
  backgroundColor: 'var(--n-scrollbar-color-hover)'
})])])])])]));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.js":
/*!*************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/select-menu/src/interface.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   internalSelectionMenuBodyInjectionKey: () => (/* binding */ internalSelectionMenuBodyInjectionKey),
/* harmony export */   internalSelectionMenuInjectionKey: () => (/* binding */ internalSelectionMenuInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const internalSelectionMenuInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-internal-select-menu');
const internalSelectionMenuBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-internal-select-menu-body');


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-locale.js":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-locale.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useLocale)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _locales__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../locales */ "./node_modules/naive-ui/es/locales/common/enUS.js");
/* harmony import */ var _locales__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../locales */ "./node_modules/naive-ui/es/locales/date/enUS.js");
/* harmony import */ var _config_provider_src_context__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../config-provider/src/context */ "./node_modules/naive-ui/es/config-provider/src/context.js");



function useLocale(ns) {
    const { mergedLocaleRef, mergedDateLocaleRef } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_config_provider_src_context__WEBPACK_IMPORTED_MODULE_1__.configProviderInjectionKey, null) || {};
    const localeRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        var _a, _b;
        return (_b = (_a = mergedLocaleRef === null || mergedLocaleRef === void 0 ? void 0 : mergedLocaleRef.value) === null || _a === void 0 ? void 0 : _a[ns]) !== null && _b !== void 0 ? _b : _locales__WEBPACK_IMPORTED_MODULE_2__["default"][ns];
    });
    const dateLocaleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        var _a;
        return (_a = mergedDateLocaleRef === null || mergedDateLocaleRef === void 0 ? void 0 : mergedDateLocaleRef.value) !== null && _a !== void 0 ? _a : _locales__WEBPACK_IMPORTED_MODULE_3__["default"];
    });
    return {
        dateLocaleRef,
        localeRef
    };
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_mixins/use-rtl.js":
/*!*****************************************************!*\
  !*** ./node_modules/naive-ui/es/_mixins/use-rtl.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useRtl: () => (/* binding */ useRtl)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var css_render__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! css-render */ "./node_modules/css-render/esm/exists.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _common__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./common */ "./node_modules/naive-ui/es/_mixins/common.js");




function useRtl(mountId, rtlStateRef, clsPrefixRef) {
    if (!rtlStateRef)
        return undefined;
    const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_1__.useSsrAdapter)();
    const componentRtlStateRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        const { value: rtlState } = rtlStateRef;
        if (!rtlState) {
            return undefined;
        }
        const componentRtlState = rtlState[mountId];
        if (!componentRtlState) {
            return undefined;
        }
        return componentRtlState;
    });
    const mountStyle = () => {
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
            const { value: clsPrefix } = clsPrefixRef;
            const id = `${clsPrefix}${mountId}Rtl`;
            // if it already exists, we only need to watch clsPrefix, although in most
            // of time it's unnecessary... However we can at least listen less
            // handlers, which is great.
            if ((0,css_render__WEBPACK_IMPORTED_MODULE_2__.exists)(id, ssrAdapter))
                return;
            const { value: componentRtlState } = componentRtlStateRef;
            if (!componentRtlState)
                return;
            componentRtlState.style.mount({
                id,
                head: true,
                anchorMetaName: _common__WEBPACK_IMPORTED_MODULE_3__.cssrAnchorMetaName,
                props: {
                    bPrefix: clsPrefix ? `.${clsPrefix}-` : undefined
                },
                ssr: ssrAdapter
            });
        });
    };
    if (ssrAdapter) {
        mountStyle();
    }
    else {
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeMount)(mountStyle);
    }
    return componentRtlStateRef;
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/naive-ui/es/_styles/transitions/fade-in-scale-up.cssr.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fadeInScaleUpTransition: () => (/* binding */ fadeInScaleUpTransition)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _common_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/_common */ "./node_modules/naive-ui/es/_styles/common/_common.js");


const {
  cubicBezierEaseIn,
  cubicBezierEaseOut
} = _common_common__WEBPACK_IMPORTED_MODULE_0__["default"];
function fadeInScaleUpTransition({
  transformOrigin = 'inherit',
  duration = '.2s',
  enterScale = '.9',
  originalTransform = '',
  originalTransition = ''
} = {}) {
  return [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-leave-active', {
    transformOrigin,
    transition: `opacity ${duration} ${cubicBezierEaseIn}, transform ${duration} ${cubicBezierEaseIn} ${originalTransition && ',' + originalTransition}`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-enter-active', {
    transformOrigin,
    transition: `opacity ${duration} ${cubicBezierEaseOut}, transform ${duration} ${cubicBezierEaseOut} ${originalTransition && ',' + originalTransition}`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-enter-from, &.fade-in-scale-up-transition-leave-to', {
    opacity: 0,
    transform: `${originalTransform} scale(${enterScale})`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)('&.fade-in-scale-up-transition-leave-from, &.fade-in-scale-up-transition-enter-to', {
    opacity: 1,
    transform: `${originalTransform} scale(1)`
  })];
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_styles/transitions/fade-in.cssr.js":
/*!**********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_styles/transitions/fade-in.cssr.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   fadeInTransition: () => (/* binding */ fadeInTransition)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");
/* harmony import */ var _common_common__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../common/_common */ "./node_modules/naive-ui/es/_styles/common/_common.js");


const {
  cubicBezierEaseInOut
} = _common_common__WEBPACK_IMPORTED_MODULE_0__["default"];
function fadeInTransition({
  name = 'fade-in',
  enterDuration = '0.2s',
  leaveDuration = '0.2s',
  enterCubicBezier = cubicBezierEaseInOut,
  leaveCubicBezier = cubicBezierEaseInOut
} = {}) {
  return [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-enter-active`, {
    transition: `all ${enterDuration} ${enterCubicBezier}!important`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-leave-active`, {
    transition: `all ${leaveDuration} ${leaveCubicBezier}!important`
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-enter-from, &.${name}-transition-leave-to`, {
    opacity: 0
  }), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_1__.c)(`&.${name}-transition-leave-from, &.${name}-transition-enter-to`, {
    opacity: 1
  })];
}

/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.js":
/*!***********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/composable/use-adjusted-to.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useAdjustedTo: () => (/* binding */ useAdjustedTo)
/* harmony export */ });
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _internal_select_menu_src_interface__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../_internal/select-menu/src/interface */ "./node_modules/naive-ui/es/_internal/select-menu/src/interface.js");
/* harmony import */ var _modal_src_interface__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../modal/src/interface */ "./node_modules/naive-ui/es/modal/src/interface.js");
/* harmony import */ var _drawer_src_interface__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../drawer/src/interface */ "./node_modules/naive-ui/es/drawer/src/interface.js");
/* harmony import */ var _popover_src_interface__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../popover/src/interface */ "./node_modules/naive-ui/es/popover/src/interface.js");







const teleportDisabled = '__disabled__';
function useAdjustedTo(props) {
    const modal = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_modal_src_interface__WEBPACK_IMPORTED_MODULE_1__.modalBodyInjectionKey, null);
    const drawer = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_drawer_src_interface__WEBPACK_IMPORTED_MODULE_2__.drawerBodyInjectionKey, null);
    const popover = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_popover_src_interface__WEBPACK_IMPORTED_MODULE_3__.popoverBodyInjectionKey, null);
    const selectMenu = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_internal_select_menu_src_interface__WEBPACK_IMPORTED_MODULE_4__.internalSelectionMenuBodyInjectionKey, null);
    const fullscreenElementRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)();
    if (typeof document !== 'undefined') {
        fullscreenElementRef.value = document.fullscreenElement;
        const handleFullscreenChange = () => {
            fullscreenElementRef.value = document.fullscreenElement;
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_5__.on)('fullscreenchange', document, handleFullscreenChange);
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_5__.off)('fullscreenchange', document, handleFullscreenChange);
        });
    }
    return (0,vooks__WEBPACK_IMPORTED_MODULE_6__["default"])(() => {
        var _a;
        const { to } = props;
        if (to !== undefined) {
            if (to === false)
                return teleportDisabled;
            if (to === true)
                return fullscreenElementRef.value || 'body';
            return to;
        }
        if (modal === null || modal === void 0 ? void 0 : modal.value) {
            return (_a = modal.value.$el) !== null && _a !== void 0 ? _a : modal.value;
        }
        if (drawer === null || drawer === void 0 ? void 0 : drawer.value)
            return drawer.value;
        if (popover === null || popover === void 0 ? void 0 : popover.value)
            return popover.value;
        if (selectMenu === null || selectMenu === void 0 ? void 0 : selectMenu.value)
            return selectMenu.value;
        return to !== null && to !== void 0 ? to : (fullscreenElementRef.value || 'body');
    });
}
// teleport disabled key
useAdjustedTo.tdkey = teleportDisabled;
useAdjustedTo.propTo = {
    type: [String, Object, Boolean],
    default: undefined
};



/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/composable/use-reactivated.js":
/*!***********************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/composable/use-reactivated.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   useReactivated: () => (/* binding */ useReactivated)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function useReactivated(callback) {
    const isDeactivatedRef = { isDeactivated: false };
    let activateStateInitialized = false;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onActivated)(() => {
        isDeactivatedRef.isDeactivated = false;
        if (!activateStateInitialized) {
            activateStateInitialized = true;
            return;
        }
        callback();
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onDeactivated)(() => {
        isDeactivatedRef.isDeactivated = true;
        if (!activateStateInitialized) {
            activateStateInitialized = true;
        }
    });
    return isDeactivatedRef;
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/css/color-to-class.js":
/*!***************************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/css/color-to-class.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   color2Class: () => (/* binding */ color2Class)
/* harmony export */ });
function color2Class(color) {
    return color.replace(/#|\(|\)|,|\s/g, '_');
}


/***/ }),

/***/ "./node_modules/naive-ui/es/_utils/vue/wrapper.js":
/*!********************************************************!*\
  !*** ./node_modules/naive-ui/es/_utils/vue/wrapper.js ***!
  \********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   Wrapper: () => (/* binding */ Wrapper)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

const Wrapper = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    render() {
        var _a, _b;
        return (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a);
    }
});


/***/ }),

/***/ "./node_modules/naive-ui/es/drawer/src/interface.js":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/drawer/src/interface.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   drawerBodyInjectionKey: () => (/* binding */ drawerBodyInjectionKey),
/* harmony export */   drawerInjectionKey: () => (/* binding */ drawerInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const drawerBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-drawer-body');
const drawerInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-drawer');


/***/ }),

/***/ "./node_modules/naive-ui/es/locales/common/enUS.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/locales/common/enUS.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
const enUS = {
    name: 'en-US',
    global: {
        undo: 'Undo',
        redo: 'Redo',
        confirm: 'Confirm',
        clear: 'Clear'
    },
    Popconfirm: {
        positiveText: 'Confirm',
        negativeText: 'Cancel'
    },
    Cascader: {
        placeholder: 'Please Select',
        loading: 'Loading',
        loadingRequiredMessage: (label) => `Please load all ${label}'s descendants before checking it.`
    },
    Time: {
        dateFormat: 'yyyy-MM-dd',
        dateTimeFormat: 'yyyy-MM-dd HH:mm:ss'
    },
    DatePicker: {
        yearFormat: 'yyyy',
        monthFormat: 'MMM',
        dayFormat: 'eeeeee',
        yearTypeFormat: 'yyyy',
        monthTypeFormat: 'yyyy-MM',
        dateFormat: 'yyyy-MM-dd',
        dateTimeFormat: 'yyyy-MM-dd HH:mm:ss',
        quarterFormat: 'yyyy-qqq',
        clear: 'Clear',
        now: 'Now',
        confirm: 'Confirm',
        selectTime: 'Select Time',
        selectDate: 'Select Date',
        datePlaceholder: 'Select Date',
        datetimePlaceholder: 'Select Date and Time',
        monthPlaceholder: 'Select Month',
        yearPlaceholder: 'Select Year',
        quarterPlaceholder: 'Select Quarter',
        startDatePlaceholder: 'Start Date',
        endDatePlaceholder: 'End Date',
        startDatetimePlaceholder: 'Start Date and Time',
        endDatetimePlaceholder: 'End Date and Time',
        startMonthPlaceholder: 'Start Month',
        endMonthPlaceholder: 'End Month',
        monthBeforeYear: true,
        firstDayOfWeek: 6,
        today: 'Today'
    },
    DataTable: {
        checkTableAll: 'Select all in the table',
        uncheckTableAll: 'Unselect all in the table',
        confirm: 'Confirm',
        clear: 'Clear'
    },
    LegacyTransfer: {
        sourceTitle: 'Source',
        targetTitle: 'Target'
    },
    Transfer: {
        selectAll: 'Select all',
        unselectAll: 'Unselect all',
        clearAll: 'Clear',
        total: (num) => `Total ${num} items`,
        selected: (num) => `${num} items selected`
    },
    Empty: {
        description: 'No Data'
    },
    Select: {
        placeholder: 'Please Select'
    },
    TimePicker: {
        placeholder: 'Select Time',
        positiveText: 'OK',
        negativeText: 'Cancel',
        now: 'Now'
    },
    Pagination: {
        goto: 'Goto',
        selectionSuffix: 'page'
    },
    DynamicTags: {
        add: 'Add'
    },
    Log: {
        loading: 'Loading'
    },
    Input: {
        placeholder: 'Please Input'
    },
    InputNumber: {
        placeholder: 'Please Input'
    },
    DynamicInput: {
        create: 'Create'
    },
    ThemeEditor: {
        title: 'Theme Editor',
        clearAllVars: 'Clear All Variables',
        clearSearch: 'Clear Search',
        filterCompName: 'Filter Component Name',
        filterVarName: 'Filter Variable Name',
        import: 'Import',
        export: 'Export',
        restore: 'Reset to Default'
    },
    Image: {
        tipPrevious: 'Previous picture (←)',
        tipNext: 'Next picture (→)',
        tipCounterclockwise: 'Counterclockwise',
        tipClockwise: 'Clockwise',
        tipZoomOut: 'Zoom out',
        tipZoomIn: 'Zoom in',
        tipClose: 'Close (Esc)',
        // TODO: translation
        tipOriginalSize: 'Zoom to original size'
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (enUS);


/***/ }),

/***/ "./node_modules/naive-ui/es/locales/date/enUS.js":
/*!*******************************************************!*\
  !*** ./node_modules/naive-ui/es/locales/date/enUS.js ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var date_fns_esm_locale_en_US__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! date-fns/esm/locale/en-US */ "./node_modules/date-fns/esm/locale/en-US/index.js");

const dateEnUs = {
    name: 'en-US',
    locale: date_fns_esm_locale_en_US__WEBPACK_IMPORTED_MODULE_0__["default"]
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (dateEnUs);


/***/ }),

/***/ "./node_modules/naive-ui/es/modal/src/interface.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/modal/src/interface.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   modalBodyInjectionKey: () => (/* binding */ modalBodyInjectionKey),
/* harmony export */   modalInjectionKey: () => (/* binding */ modalInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const modalBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-modal-body');
const modalInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-modal');


/***/ }),

/***/ "./node_modules/naive-ui/es/popover/src/interface.js":
/*!***********************************************************!*\
  !*** ./node_modules/naive-ui/es/popover/src/interface.js ***!
  \***********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   popoverBodyInjectionKey: () => (/* binding */ popoverBodyInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils/vue/create-injection-key */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const popoverBodyInjectionKey = (0,_utils_vue_create_injection_key__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-popover-body');


/***/ }),

/***/ "./node_modules/seemly/es/animation/next-frame-once.js":
/*!*************************************************************!*\
  !*** ./node_modules/seemly/es/animation/next-frame-once.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   beforeNextFrameOnce: () => (/* binding */ beforeNextFrameOnce)
/* harmony export */ });
let onceCbs = [];
const paramsMap = new WeakMap();
function flushOnceCallbacks() {
    onceCbs.forEach((cb) => cb(...paramsMap.get(cb)));
    onceCbs = [];
}
function beforeNextFrameOnce(cb, ...params) {
    paramsMap.set(cb, params);
    if (onceCbs.includes(cb))
        return;
    onceCbs.push(cb) === 1 && requestAnimationFrame(flushOnceCallbacks);
}



/***/ }),

/***/ "./node_modules/seemly/es/dom/get-precise-event-target.js":
/*!****************************************************************!*\
  !*** ./node_modules/seemly/es/dom/get-precise-event-target.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getPreciseEventTarget: () => (/* binding */ getPreciseEventTarget)
/* harmony export */ });
function getPreciseEventTarget(event) {
    return event.composedPath()[0] || null;
}


/***/ }),

/***/ "./node_modules/vdirs/es/clickoutside.js":
/*!***********************************************!*\
  !*** ./node_modules/vdirs/es/clickoutside.js ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");

const ctxKey = '@@coContext';
const clickoutside = {
    mounted(el, { value, modifiers }) {
        el[ctxKey] = {
            handler: undefined
        };
        if (typeof value === 'function') {
            el[ctxKey].handler = value;
            (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('clickoutside', el, value, {
                capture: modifiers.capture
            });
        }
    },
    updated(el, { value, modifiers }) {
        const ctx = el[ctxKey];
        if (typeof value === 'function') {
            if (ctx.handler) {
                if (ctx.handler !== value) {
                    (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('clickoutside', el, ctx.handler, {
                        capture: modifiers.capture
                    });
                    ctx.handler = value;
                    (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('clickoutside', el, value, {
                        capture: modifiers.capture
                    });
                }
            }
            else {
                el[ctxKey].handler = value;
                (0,evtd__WEBPACK_IMPORTED_MODULE_0__.on)('clickoutside', el, value, {
                    capture: modifiers.capture
                });
            }
        }
        else {
            if (ctx.handler) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('clickoutside', el, ctx.handler, {
                    capture: modifiers.capture
                });
                ctx.handler = undefined;
            }
        }
    },
    unmounted(el, { modifiers }) {
        const { handler } = el[ctxKey];
        if (handler) {
            (0,evtd__WEBPACK_IMPORTED_MODULE_0__.off)('clickoutside', el, handler, {
                capture: modifiers.capture
            });
        }
        el[ctxKey].handler = undefined;
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (clickoutside);


/***/ }),

/***/ "./node_modules/vdirs/es/utils.js":
/*!****************************************!*\
  !*** ./node_modules/vdirs/es/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   warn: () => (/* binding */ warn),
/* harmony export */   warnOnce: () => (/* binding */ warnOnce)
/* harmony export */ });
const warnedMessages = new Set();
function warnOnce(location, message) {
    const mergedMessage = `[vdirs/${location}]: ${message}`;
    if (warnedMessages.has(mergedMessage))
        return;
    warnedMessages.add(mergedMessage);
}
function warn(location, message) {
    console.error(`[vdirs/${location}]: ${message}`);
}


/***/ }),

/***/ "./node_modules/vdirs/es/zindexable/index.js":
/*!***************************************************!*\
  !*** ./node_modules/vdirs/es/zindexable/index.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _z_index_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./z-index-manager */ "./node_modules/vdirs/es/zindexable/z-index-manager.js");

const ctx = '@@ziContext';
// We don't expect manually bound zindex should be changed
const zindexable = {
    mounted(el, bindings) {
        const { value = {} } = bindings;
        const { zIndex, enabled } = value;
        el[ctx] = {
            enabled: !!enabled,
            initialized: false
        };
        if (enabled) {
            _z_index_manager__WEBPACK_IMPORTED_MODULE_0__["default"].ensureZIndex(el, zIndex);
            el[ctx].initialized = true;
        }
    },
    updated(el, bindings) {
        const { value = {} } = bindings;
        const { zIndex, enabled } = value;
        const cachedEnabled = el[ctx].enabled;
        if (enabled && !cachedEnabled) {
            _z_index_manager__WEBPACK_IMPORTED_MODULE_0__["default"].ensureZIndex(el, zIndex);
            el[ctx].initialized = true;
        }
        el[ctx].enabled = !!enabled;
    },
    unmounted(el, bindings) {
        if (!el[ctx].initialized)
            return;
        const { value = {} } = bindings;
        const { zIndex } = value;
        _z_index_manager__WEBPACK_IMPORTED_MODULE_0__["default"].unregister(el, zIndex);
    }
};
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (zindexable);


/***/ }),

/***/ "./node_modules/vdirs/es/zindexable/z-index-manager.js":
/*!*************************************************************!*\
  !*** ./node_modules/vdirs/es/zindexable/z-index-manager.js ***!
  \*************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils */ "./node_modules/vdirs/es/utils.js");

class ZIndexManager {
    constructor() {
        this.elementZIndex = new Map();
        this.nextZIndex = 2000;
    }
    get elementCount() {
        return this.elementZIndex.size;
    }
    ensureZIndex(el, zIndex) {
        const { elementZIndex } = this;
        if (zIndex !== undefined) {
            el.style.zIndex = `${zIndex}`;
            elementZIndex.delete(el);
            return;
        }
        const { nextZIndex } = this;
        if (elementZIndex.has(el)) {
            const currentZIndex = elementZIndex.get(el);
            if (currentZIndex + 1 === this.nextZIndex)
                return;
        }
        el.style.zIndex = `${nextZIndex}`;
        elementZIndex.set(el, nextZIndex);
        this.nextZIndex = nextZIndex + 1;
        this.squashState();
    }
    unregister(el, zIndex) {
        const { elementZIndex } = this;
        if (elementZIndex.has(el)) {
            elementZIndex.delete(el);
        }
        else if (zIndex === undefined) {
            (0,_utils__WEBPACK_IMPORTED_MODULE_0__.warn)('z-index-manager/unregister-element', 'Element not found when unregistering.');
        }
        this.squashState();
    }
    squashState() {
        const { elementCount } = this;
        if (!elementCount) {
            this.nextZIndex = 2000;
        }
        if (this.nextZIndex - elementCount > 2500)
            this.rearrange();
    }
    rearrange() {
        const elementZIndexPair = Array.from(this.elementZIndex.entries());
        elementZIndexPair.sort((pair1, pair2) => {
            return pair1[1] - pair2[1];
        });
        this.nextZIndex = 2000;
        elementZIndexPair.forEach((pair) => {
            const el = pair[0];
            const zIndex = this.nextZIndex++;
            if (`${zIndex}` !== el.style.zIndex)
                el.style.zIndex = `${zIndex}`;
        });
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new ZIndexManager());


/***/ }),

/***/ "./node_modules/vooks/es/on-fonts-ready.js":
/*!*************************************************!*\
  !*** ./node_modules/vooks/es/on-fonts-ready.js ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ onFontsReady),
/* harmony export */   init: () => (/* binding */ init)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/vooks/es/utils.js");


let fontsReady;
let isFontReady;
const init = () => {
    var _a, _b;
    fontsReady = _utils__WEBPACK_IMPORTED_MODULE_1__.isBrowser ? (_b = (_a = document) === null || _a === void 0 ? void 0 : _a.fonts) === null || _b === void 0 ? void 0 : _b.ready : undefined;
    isFontReady = false;
    /* istanbul ignore if */
    if (fontsReady !== undefined) {
        void fontsReady.then(() => {
            isFontReady = true;
        });
    }
    else {
        isFontReady = true;
    }
};
init();
// For testing

/**
 * Call callback on fontsReady is resolved. If fontsReady is already resolved,
 * callback won't be called.
 */
function onFontsReady(cb) {
    /* istanbul ignore next */
    if (isFontReady)
        return;
    let deactivated = false;
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
        /* istanbul ignore next */
        if (!isFontReady) {
            fontsReady === null || fontsReady === void 0 ? void 0 : fontsReady.then(() => {
                if (deactivated)
                    return;
                cb();
            });
        }
    });
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
        deactivated = true;
    });
}


/***/ }),

/***/ "./node_modules/vooks/es/use-false-until-truthy.js":
/*!*********************************************************!*\
  !*** ./node_modules/vooks/es/use-false-until-truthy.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useFalseUntilTruthy)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function useFalseUntilTruthy(originalRef) {
    const currentRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(!!originalRef.value);
    if (currentRef.value)
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.readonly)(currentRef);
    const stop = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(originalRef, (value) => {
        if (value) {
            currentRef.value = true;
            stop();
        }
    });
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.readonly)(currentRef);
}


/***/ }),

/***/ "./node_modules/vooks/es/use-is-ios.js":
/*!*********************************************!*\
  !*** ./node_modules/vooks/es/use-is-ios.js ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ useIsIos),
/* harmony export */   isIos: () => (/* binding */ isIos)
/* harmony export */ });
const isIos = (typeof window === 'undefined'
    ? false
    : /iPad|iPhone|iPod/.test(navigator.platform) ||
        (navigator.platform === 'MacIntel' && navigator.maxTouchPoints > 1)) &&
    // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
    !window.MSStream;
function useIsIos() {
    return isIos;
}


/***/ }),

/***/ "./node_modules/vooks/es/utils.js":
/*!****************************************!*\
  !*** ./node_modules/vooks/es/utils.js ***!
  \****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   hasInstance: () => (/* binding */ hasInstance),
/* harmony export */   isBrowser: () => (/* binding */ isBrowser)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function hasInstance() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)() !== null;
}
const isBrowser = typeof window !== 'undefined';


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/Binder.js":
/*!****************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/Binder.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/animation/next-frame-once.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _shared_v_node__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../shared/v-node */ "./node_modules/vueuc/es/shared/v-node.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./utils */ "./node_modules/vueuc/es/binder/src/utils.js");
/* eslint-disable @typescript-eslint/no-non-null-assertion */





const Binder = (0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Binder',
    props: {
        syncTargetWithParent: Boolean,
        syncTarget: {
            type: Boolean,
            default: true
        }
    },
    setup(props) {
        var _a;
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)('VBinder', (_a = (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)()) === null || _a === void 0 ? void 0 : _a.proxy);
        const VBinder = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('VBinder', null);
        const targetRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        /**
         * If there's no nested vbinder, we can simply set the target ref.
         *
         * However, when it comes to:
         * <VBinder> <- syncTarget = false
         *
         *              Should hold target DOM ref, but can't get it directly from
         *              its VTarget. So if there are nested VBinder, we should:
         *              1. Stop setting target DOM from level-1 VTarget
         *              2. Set target DOM from level-2 VTarget
         *              For (1), we need `syncTarget` to `false`
         *              For (2), we need to set `syncTargetWithParent` to `true` on
         *              level-2 VBinder
         *   <VTarget>
         *     <VBinder> <- syncTargetWithParent = true
         *       <VTarget>target</VTarget>
         *     </VBinder>
         *     <VFollower>
         *       content1
         *     </VFollower>
         *   </VTarget>
         *   <VFollower>
         *     content2
         *   </VFollower>
         * </VBinder>
         */
        const setTargetRef = (el) => {
            targetRef.value = el;
            // eslint-disable-next-line @typescript-eslint/strict-boolean-expressions
            if (VBinder && props.syncTargetWithParent) {
                VBinder.setTargetRef(el);
            }
        };
        // scroll related
        let scrollableNodes = [];
        const ensureScrollListener = () => {
            let cursor = targetRef.value;
            while (true) {
                cursor = (0,_utils__WEBPACK_IMPORTED_MODULE_1__.getScrollParent)(cursor);
                if (cursor === null)
                    break;
                scrollableNodes.push(cursor);
            }
            for (const el of scrollableNodes) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.on)('scroll', el, onScroll, true);
            }
        };
        const removeScrollListeners = () => {
            for (const el of scrollableNodes) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('scroll', el, onScroll, true);
            }
            scrollableNodes = [];
        };
        const followerScrollListeners = new Set();
        const addScrollListener = (listener) => {
            if (followerScrollListeners.size === 0) {
                ensureScrollListener();
            }
            if (!followerScrollListeners.has(listener)) {
                followerScrollListeners.add(listener);
            }
        };
        const removeScrollListener = (listener) => {
            if (followerScrollListeners.has(listener)) {
                followerScrollListeners.delete(listener);
            }
            if (followerScrollListeners.size === 0) {
                removeScrollListeners();
            }
        };
        const onScroll = () => {
            (0,seemly__WEBPACK_IMPORTED_MODULE_3__.beforeNextFrameOnce)(onScrollRaf);
        };
        const onScrollRaf = () => {
            followerScrollListeners.forEach((listener) => listener());
        };
        // resize related
        const followerResizeListeners = new Set();
        const addResizeListener = (listener) => {
            if (followerResizeListeners.size === 0) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.on)('resize', window, onResize);
            }
            if (!followerResizeListeners.has(listener)) {
                followerResizeListeners.add(listener);
            }
        };
        const removeResizeListener = (listener) => {
            if (followerResizeListeners.has(listener)) {
                followerResizeListeners.delete(listener);
            }
            if (followerResizeListeners.size === 0) {
                (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('resize', window, onResize);
            }
        };
        const onResize = () => {
            followerResizeListeners.forEach((listener) => listener());
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            (0,evtd__WEBPACK_IMPORTED_MODULE_2__.off)('resize', window, onResize);
            removeScrollListeners();
        });
        return {
            targetRef,
            setTargetRef,
            addScrollListener,
            removeScrollListener,
            addResizeListener,
            removeResizeListener
        };
    },
    render() {
        return (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_4__.getSlot)('binder', this.$slots);
    }
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (Binder);


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/Follower.js":
/*!******************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/Follower.js ***!
  \******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vdirs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! vdirs */ "./node_modules/vdirs/es/zindexable/index.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/on-fonts-ready.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/life-cycle/use-is-mounted.js");
/* harmony import */ var _css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @css-render/vue3-ssr */ "./node_modules/@css-render/vue3-ssr/esm/index.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/cssr.js");
/* harmony import */ var _lazy_teleport_src_index__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../lazy-teleport/src/index */ "./node_modules/vueuc/es/lazy-teleport/src/index.js");
/* harmony import */ var _get_placement_style__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./get-placement-style */ "./node_modules/vueuc/es/binder/src/get-placement-style.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./utils */ "./node_modules/vueuc/es/binder/src/utils.js");
/* eslint-disable @typescript-eslint/no-non-null-assertion */








const style = (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)([
    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('.v-binder-follower-container', {
        position: 'absolute',
        left: '0',
        right: '0',
        top: '0',
        height: '0',
        pointerEvents: 'none',
        zIndex: 'auto'
    }),
    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('.v-binder-follower-content', {
        position: 'absolute',
        zIndex: 'auto'
    }, [
        (0,_shared__WEBPACK_IMPORTED_MODULE_1__.c)('> *', {
            pointerEvents: 'all'
        })
    ])
]);
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Follower',
    inheritAttrs: false,
    props: {
        show: Boolean,
        enabled: {
            type: Boolean,
            default: undefined
        },
        placement: {
            type: String,
            default: 'bottom'
        },
        syncTrigger: {
            type: Array,
            default: ['resize', 'scroll']
        },
        to: [String, Object],
        flip: {
            type: Boolean,
            default: true
        },
        internalShift: Boolean,
        x: Number,
        y: Number,
        width: String,
        minWidth: String,
        containerClass: String,
        teleportDisabled: Boolean,
        zindexable: {
            type: Boolean,
            default: true
        },
        zIndex: Number,
        overlap: Boolean
    },
    setup(props) {
        const VBinder = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('VBinder');
        const mergedEnabledRef = (0,vooks__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
            return props.enabled !== undefined ? props.enabled : props.show;
        });
        const followerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const offsetContainerRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const ensureListeners = () => {
            const { syncTrigger } = props;
            if (syncTrigger.includes('scroll')) {
                VBinder.addScrollListener(syncPosition);
            }
            if (syncTrigger.includes('resize')) {
                VBinder.addResizeListener(syncPosition);
            }
        };
        const removeListeners = () => {
            VBinder.removeScrollListener(syncPosition);
            VBinder.removeResizeListener(syncPosition);
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            if (mergedEnabledRef.value) {
                syncPosition();
                ensureListeners();
            }
        });
        const ssrAdapter = (0,_css_render_vue3_ssr__WEBPACK_IMPORTED_MODULE_3__.useSsrAdapter)();
        style.mount({
            id: 'vueuc/binder',
            head: true,
            anchorMetaName: _shared__WEBPACK_IMPORTED_MODULE_1__.cssrAnchorMetaName,
            ssr: ssrAdapter
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            removeListeners();
        });
        (0,vooks__WEBPACK_IMPORTED_MODULE_4__["default"])(() => {
            if (mergedEnabledRef.value) {
                syncPosition();
            }
        });
        const syncPosition = () => {
            if (!mergedEnabledRef.value) {
                return;
            }
            const follower = followerRef.value;
            // sometimes watched props change before its dom is ready
            // for example: show=false, x=undefined, y=undefined
            //              show=true,  x=0,         y=0
            // will cause error
            // I may optimize the watch start point later
            if (follower === null)
                return;
            const target = VBinder.targetRef;
            const { x, y, overlap } = props;
            const targetRect = x !== undefined && y !== undefined
                ? (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getPointRect)(x, y)
                : (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getRect)(target);
            follower.style.setProperty('--v-target-width', `${Math.round(targetRect.width)}px`);
            follower.style.setProperty('--v-target-height', `${Math.round(targetRect.height)}px`);
            const { width, minWidth, placement, internalShift, flip } = props;
            follower.setAttribute('v-placement', placement);
            if (overlap) {
                follower.setAttribute('v-overlap', '');
            }
            else {
                follower.removeAttribute('v-overlap');
            }
            const { style } = follower;
            if (width === 'target') {
                style.width = `${targetRect.width}px`;
            }
            else if (width !== undefined) {
                style.width = width;
            }
            else {
                style.width = '';
            }
            if (minWidth === 'target') {
                style.minWidth = `${targetRect.width}px`;
            }
            else if (minWidth !== undefined) {
                style.minWidth = minWidth;
            }
            else {
                style.minWidth = '';
            }
            const followerRect = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getRect)(follower);
            const offsetContainerRect = (0,_utils__WEBPACK_IMPORTED_MODULE_5__.getRect)(offsetContainerRef.value);
            const { left: offsetLeftToStandardPlacement, top: offsetTopToStandardPlacement, placement: properPlacement } = (0,_get_placement_style__WEBPACK_IMPORTED_MODULE_6__.getPlacementAndOffsetOfFollower)(placement, targetRect, followerRect, internalShift, flip, overlap);
            const properTransformOrigin = (0,_get_placement_style__WEBPACK_IMPORTED_MODULE_6__.getProperTransformOrigin)(properPlacement, overlap);
            const { left, top, transform } = (0,_get_placement_style__WEBPACK_IMPORTED_MODULE_6__.getOffset)(properPlacement, offsetContainerRect, targetRect, offsetTopToStandardPlacement, offsetLeftToStandardPlacement, overlap);
            // we assume that the content size doesn't change after flip,
            // nor we need to make sync logic more complex
            follower.setAttribute('v-placement', properPlacement);
            follower.style.setProperty('--v-offset-left', `${Math.round(offsetLeftToStandardPlacement)}px`);
            follower.style.setProperty('--v-offset-top', `${Math.round(offsetTopToStandardPlacement)}px`);
            follower.style.transform = `translateX(${left}) translateY(${top}) ${transform}`;
            follower.style.setProperty('--v-transform-origin', properTransformOrigin);
            follower.style.transformOrigin = properTransformOrigin;
        };
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedEnabledRef, (value) => {
            if (value) {
                ensureListeners();
                syncOnNextTick();
            }
            else {
                removeListeners();
            }
        });
        const syncOnNextTick = () => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)()
                .then(syncPosition)
                .catch((e) => console.error(e));
        };
        [
            'placement',
            'x',
            'y',
            'internalShift',
            'flip',
            'width',
            'overlap',
            'minWidth'
        ].forEach((prop) => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, prop), syncPosition);
        });
        ['teleportDisabled'].forEach((prop) => {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, prop), syncOnNextTick);
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'syncTrigger'), (value) => {
            if (!value.includes('resize')) {
                VBinder.removeResizeListener(syncPosition);
            }
            else {
                VBinder.addResizeListener(syncPosition);
            }
            if (!value.includes('scroll')) {
                VBinder.removeScrollListener(syncPosition);
            }
            else {
                VBinder.addScrollListener(syncPosition);
            }
        });
        const isMountedRef = (0,vooks__WEBPACK_IMPORTED_MODULE_7__["default"])();
        const mergedToRef = (0,vooks__WEBPACK_IMPORTED_MODULE_2__["default"])(() => {
            const { to } = props;
            if (to !== undefined)
                return to;
            if (isMountedRef.value) {
                // TODO: find proper container
                return undefined;
            }
            return undefined;
        });
        return {
            VBinder,
            mergedEnabled: mergedEnabledRef,
            offsetContainerRef,
            followerRef,
            mergedTo: mergedToRef,
            syncPosition
        };
    },
    render() {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_lazy_teleport_src_index__WEBPACK_IMPORTED_MODULE_8__["default"], {
            show: this.show,
            to: this.mergedTo,
            disabled: this.teleportDisabled
        }, {
            default: () => {
                var _a, _b;
                const vNode = (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                    class: ['v-binder-follower-container', this.containerClass],
                    ref: 'offsetContainerRef'
                }, [
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)('div', {
                        class: 'v-binder-follower-content',
                        ref: 'followerRef'
                    }, (_b = (_a = this.$slots).default) === null || _b === void 0 ? void 0 : _b.call(_a))
                ]);
                if (this.zindexable) {
                    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)(vNode, [
                        [
                            vdirs__WEBPACK_IMPORTED_MODULE_9__["default"],
                            {
                                enabled: this.mergedEnabled,
                                zIndex: this.zIndex
                            }
                        ]
                    ]);
                }
                return vNode;
            }
        });
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/Target.js":
/*!****************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/Target.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _shared_v_node__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared/v-node */ "./node_modules/vueuc/es/shared/v-node.js");
/* eslint-disable @typescript-eslint/no-non-null-assertion */


/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Target',
    setup() {
        const { setTargetRef, syncTarget } = (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)('VBinder');
        const setTargetDirective = {
            mounted: setTargetRef,
            updated: setTargetRef
        };
        return {
            syncTarget,
            setTargetDirective
        };
    },
    render() {
        const { syncTarget, setTargetDirective } = this;
        /**
         * If you are using VBinder as a child of VBinder, the children wouldn't be
         * a valid DOM or component that can be attached to by directive.
         * So we won't sync target on those kind of situation and control the
         * target sync logic manually.
         */
        if (syncTarget) {
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.withDirectives)((0,_shared_v_node__WEBPACK_IMPORTED_MODULE_1__.getFirstVNode)('follower', this.$slots), [
                [setTargetDirective]
            ]);
        }
        return (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_1__.getFirstVNode)('follower', this.$slots);
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/get-placement-style.js":
/*!*****************************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/get-placement-style.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getOffset: () => (/* binding */ getOffset),
/* harmony export */   getPlacementAndOffsetOfFollower: () => (/* binding */ getPlacementAndOffsetOfFollower),
/* harmony export */   getProperTransformOrigin: () => (/* binding */ getProperTransformOrigin)
/* harmony export */ });
const oppositionPositions = {
    top: 'bottom',
    bottom: 'top',
    left: 'right',
    right: 'left'
};
const oppositeAligns = {
    start: 'end',
    center: 'center',
    end: 'start'
};
const propToCompare = {
    top: 'height',
    bottom: 'height',
    left: 'width',
    right: 'width'
};
const transformOrigins = {
    'bottom-start': 'top left',
    bottom: 'top center',
    'bottom-end': 'top right',
    'top-start': 'bottom left',
    top: 'bottom center',
    'top-end': 'bottom right',
    'right-start': 'top left',
    right: 'center left',
    'right-end': 'bottom left',
    'left-start': 'top right',
    left: 'center right',
    'left-end': 'bottom right'
};
const overlapTransformOrigin = {
    'bottom-start': 'bottom left',
    bottom: 'bottom center',
    'bottom-end': 'bottom right',
    'top-start': 'top left',
    top: 'top center',
    'top-end': 'top right',
    'right-start': 'top right',
    right: 'center right',
    'right-end': 'bottom right',
    'left-start': 'top left',
    left: 'center left',
    'left-end': 'bottom left'
};
const oppositeAlignCssPositionProps = {
    'bottom-start': 'right',
    'bottom-end': 'left',
    'top-start': 'right',
    'top-end': 'left',
    'right-start': 'bottom',
    'right-end': 'top',
    'left-start': 'bottom',
    'left-end': 'top'
};
const keepOffsetDirection = {
    top: true,
    bottom: false,
    left: true,
    right: false // left--
};
const cssPositionToOppositeAlign = {
    top: 'end',
    bottom: 'start',
    left: 'end',
    right: 'start'
};
function getPlacementAndOffsetOfFollower(placement, targetRect, followerRect, shift, flip, overlap) {
    if (!flip || overlap) {
        return { placement: placement, top: 0, left: 0 };
    }
    const [position, align] = placement.split('-');
    let properAlign = align !== null && align !== void 0 ? align : 'center';
    let properOffset = {
        top: 0,
        left: 0
    };
    const deriveOffset = (oppositeAlignCssSizeProp, alignCssPositionProp, offsetVertically) => {
        let left = 0;
        let top = 0;
        const diff = followerRect[oppositeAlignCssSizeProp] -
            targetRect[alignCssPositionProp] -
            targetRect[oppositeAlignCssSizeProp];
        if (diff > 0 && shift) {
            if (offsetVertically) {
                //       screen border
                // |-----------------------------------------|
                // |                    | f  |               |
                // |                    | o  |               |
                // |                    | l  |               |
                // |                    | l  |----           |
                // |                    | o  |tar |          |
                // |                    | w  |get |          |
                // |                    | e  |    |          |
                // |                    | r  |----           |
                // |                     ----                |
                // |-----------------------------------------|
                top = keepOffsetDirection[alignCssPositionProp] ? diff : -diff;
            }
            else {
                //       screen border
                // |----------------------------------------|
                // |                                        |
                // |          ----------                    |
                // |          | target |                    |
                // |       ----------------------------------
                // |       |       follower                 |
                // |       ----------------------------------
                // |                                        |
                // |----------------------------------------|
                left = keepOffsetDirection[alignCssPositionProp] ? diff : -diff;
            }
        }
        return {
            left,
            top
        };
    };
    const offsetVertically = position === 'left' || position === 'right';
    // choose proper placement for non-center align
    if (properAlign !== 'center') {
        const oppositeAlignCssPositionProp = oppositeAlignCssPositionProps[placement];
        const currentAlignCssPositionProp = oppositionPositions[oppositeAlignCssPositionProp];
        const oppositeAlignCssSizeProp = propToCompare[oppositeAlignCssPositionProp];
        // if follower rect is larger than target rect in align direction
        // ----------[ target ]---------|
        // ----------[     follower     ]
        if (followerRect[oppositeAlignCssSizeProp] >
            targetRect[oppositeAlignCssSizeProp]) {
            if (
            // current space is not enough
            // ----------[ target ]---------|
            // -------[     follower        ]
            targetRect[oppositeAlignCssPositionProp] +
                targetRect[oppositeAlignCssSizeProp] <
                followerRect[oppositeAlignCssSizeProp]) {
                const followerOverTargetSize = (followerRect[oppositeAlignCssSizeProp] -
                    targetRect[oppositeAlignCssSizeProp]) /
                    2;
                if (targetRect[oppositeAlignCssPositionProp] < followerOverTargetSize ||
                    targetRect[currentAlignCssPositionProp] < followerOverTargetSize) {
                    // opposite align has larger space
                    // -------[ target ]-----------|
                    // -------[     follower     ]-|
                    if (targetRect[oppositeAlignCssPositionProp] <
                        targetRect[currentAlignCssPositionProp]) {
                        properAlign = oppositeAligns[align];
                        properOffset = deriveOffset(oppositeAlignCssSizeProp, currentAlignCssPositionProp, offsetVertically);
                    }
                    else {
                        // ----------------[ target ]----|
                        // --------[   follower     ]----|
                        properOffset = deriveOffset(oppositeAlignCssSizeProp, oppositeAlignCssPositionProp, offsetVertically);
                    }
                }
                else {
                    // 'center' align is better
                    // ------------[ target ]--------|
                    // -------[       follower    ]--|
                    properAlign = 'center';
                }
            }
        }
        else if (followerRect[oppositeAlignCssSizeProp] <
            targetRect[oppositeAlignCssSizeProp]) {
            // TODO: maybe center is better
            if (targetRect[currentAlignCssPositionProp] < 0 &&
                // opposite align has larger space
                // ------------[   target   ]
                // ----------------[follower]
                targetRect[oppositeAlignCssPositionProp] >
                    targetRect[currentAlignCssPositionProp]) {
                properAlign = oppositeAligns[align];
            }
        }
    }
    else {
        const possibleAlternativeAlignCssPositionProp1 = position === 'bottom' || position === 'top' ? 'left' : 'top';
        const possibleAlternativeAlignCssPositionProp2 = oppositionPositions[possibleAlternativeAlignCssPositionProp1];
        const alternativeAlignCssSizeProp = propToCompare[possibleAlternativeAlignCssPositionProp1];
        const followerOverTargetSize = (followerRect[alternativeAlignCssSizeProp] -
            targetRect[alternativeAlignCssSizeProp]) /
            2;
        if (
        // center is not enough
        // ----------- [ target ]--|
        // -------[     follower     ]
        targetRect[possibleAlternativeAlignCssPositionProp1] <
            followerOverTargetSize ||
            targetRect[possibleAlternativeAlignCssPositionProp2] <
                followerOverTargetSize) {
            // alternative 2 position's space is larger
            if (targetRect[possibleAlternativeAlignCssPositionProp1] >
                targetRect[possibleAlternativeAlignCssPositionProp2]) {
                properAlign =
                    cssPositionToOppositeAlign[possibleAlternativeAlignCssPositionProp1];
                properOffset = deriveOffset(alternativeAlignCssSizeProp, possibleAlternativeAlignCssPositionProp1, offsetVertically);
            }
            else {
                // alternative 1 position's space is larger
                properAlign =
                    cssPositionToOppositeAlign[possibleAlternativeAlignCssPositionProp2];
                properOffset = deriveOffset(alternativeAlignCssSizeProp, possibleAlternativeAlignCssPositionProp2, offsetVertically);
            }
        }
    }
    let properPosition = position;
    if (
    // space is not enough
    targetRect[position] < followerRect[propToCompare[position]] &&
        // opposite position's space is larger
        targetRect[position] < targetRect[oppositionPositions[position]]) {
        properPosition = oppositionPositions[position];
    }
    return {
        placement: properAlign !== 'center'
            ? `${properPosition}-${properAlign}`
            : properPosition,
        left: properOffset.left,
        top: properOffset.top
    };
}
function getProperTransformOrigin(placement, overlap) {
    if (overlap)
        return overlapTransformOrigin[placement];
    return transformOrigins[placement];
}
// ------------
// |  offset  |
// |          |
// | [target] |
// |          |
// ------------
// TODO: refactor it to remove dup logic
function getOffset(placement, offsetRect, targetRect, offsetTopToStandardPlacement, offsetLeftToStandardPlacement, overlap) {
    if (overlap) {
        switch (placement) {
            case 'bottom-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-100%)'
                };
            case 'bottom-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-100%)'
                };
            case 'top-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: ''
                };
            case 'top-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%)'
                };
            case 'right-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%)'
                };
            case 'right-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-100%)'
                };
            case 'left-start':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: ''
                };
            case 'left-end':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-100%)'
                };
            case 'top':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                    transform: 'translateX(-50%)'
                };
            case 'right':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width)}px`,
                    transform: 'translateX(-100%) translateY(-50%)'
                };
            case 'left':
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height / 2)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left)}px`,
                    transform: 'translateY(-50%)'
                };
            case 'bottom':
            default:
                return {
                    top: `${Math.round(targetRect.top - offsetRect.top + targetRect.height)}px`,
                    left: `${Math.round(targetRect.left - offsetRect.left + targetRect.width / 2)}px`,
                    transform: 'translateX(-50%) translateY(-100%)'
                };
        }
    }
    switch (placement) {
        case 'bottom-start':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: ''
            };
        case 'bottom-end':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%)'
            };
        case 'top-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-100%)'
            };
        case 'top-end':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%) translateY(-100%)'
            };
        case 'right-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: ''
            };
        case 'right-end':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-100%)'
            };
        case 'left-start':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%)'
            };
        case 'left-end':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-100%) translateY(-100%)'
            };
        case 'top':
            return {
                top: `${Math.round(targetRect.top - offsetRect.top + offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width / 2 +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-100%) translateX(-50%)'
            };
        case 'right':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height / 2 +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-50%)'
            };
        case 'left':
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height / 2 +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left - offsetRect.left + offsetLeftToStandardPlacement)}px`,
                transform: 'translateY(-50%) translateX(-100%)'
            };
        case 'bottom':
        default:
            return {
                top: `${Math.round(targetRect.top -
                    offsetRect.top +
                    targetRect.height +
                    offsetTopToStandardPlacement)}px`,
                left: `${Math.round(targetRect.left -
                    offsetRect.left +
                    targetRect.width / 2 +
                    offsetLeftToStandardPlacement)}px`,
                transform: 'translateX(-50%)'
            };
    }
}


/***/ }),

/***/ "./node_modules/vueuc/es/binder/src/utils.js":
/*!***************************************************!*\
  !*** ./node_modules/vueuc/es/binder/src/utils.js ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   ensureViewBoundingRect: () => (/* binding */ ensureViewBoundingRect),
/* harmony export */   getParentNode: () => (/* binding */ getParentNode),
/* harmony export */   getPointRect: () => (/* binding */ getPointRect),
/* harmony export */   getRect: () => (/* binding */ getRect),
/* harmony export */   getScrollParent: () => (/* binding */ getScrollParent)
/* harmony export */ });
let viewMeasurer = null;
function ensureViewBoundingRect() {
    if (viewMeasurer === null) {
        viewMeasurer = document.getElementById('v-binder-view-measurer');
        if (viewMeasurer === null) {
            viewMeasurer = document.createElement('div');
            viewMeasurer.id = 'v-binder-view-measurer';
            const { style } = viewMeasurer;
            style.position = 'fixed';
            style.left = '0';
            style.right = '0';
            style.top = '0';
            style.bottom = '0';
            style.pointerEvents = 'none';
            style.visibility = 'hidden';
            document.body.appendChild(viewMeasurer);
        }
    }
    return viewMeasurer.getBoundingClientRect();
}
function getPointRect(x, y) {
    const viewRect = ensureViewBoundingRect();
    return {
        top: y,
        left: x,
        height: 0,
        width: 0,
        right: viewRect.width - x,
        bottom: viewRect.height - y
    };
}
function getRect(el) {
    const elRect = el.getBoundingClientRect();
    const viewRect = ensureViewBoundingRect();
    return {
        left: elRect.left - viewRect.left,
        top: elRect.top - viewRect.top,
        bottom: viewRect.height + viewRect.top - elRect.bottom,
        right: viewRect.width + viewRect.left - elRect.right,
        width: elRect.width,
        height: elRect.height
    };
}
function getParentNode(node) {
    // document type
    if (node.nodeType === 9) {
        return null;
    }
    return node.parentNode;
}
function getScrollParent(node) {
    if (node === null)
        return null;
    const parentNode = getParentNode(node);
    if (parentNode === null) {
        return null;
    }
    // Document
    if (parentNode.nodeType === 9) {
        return document;
    }
    // Element
    if (parentNode.nodeType === 1) {
        // Firefox want us to check `-x` and `-y` variations as well
        const { overflow, overflowX, overflowY } = getComputedStyle(parentNode);
        if (/(auto|scroll|overlay)/.test(overflow + overflowY + overflowX)) {
            return parentNode;
        }
    }
    return getScrollParent(parentNode);
}


/***/ }),

/***/ "./node_modules/vueuc/es/lazy-teleport/src/index.js":
/*!**********************************************************!*\
  !*** ./node_modules/vueuc/es/lazy-teleport/src/index.js ***!
  \**********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-false-until-truthy.js");
/* harmony import */ var _shared_v_node__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../shared/v-node */ "./node_modules/vueuc/es/shared/v-node.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'LazyTeleport',
    props: {
        to: {
            type: [String, Object],
            default: undefined
        },
        disabled: Boolean,
        show: {
            type: Boolean,
            required: true
        }
    },
    setup(props) {
        return {
            showTeleport: (0,vooks__WEBPACK_IMPORTED_MODULE_1__["default"])((0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'show')),
            mergedTo: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
                const { to } = props;
                return to !== null && to !== void 0 ? to : 'body';
            })
        };
    },
    render() {
        return this.showTeleport
            ? this.disabled
                ? (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_2__.getSlot)('lazy-teleport', this.$slots)
                : (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Teleport, {
                    disabled: this.disabled,
                    to: this.mergedTo
                }, (0,_shared_v_node__WEBPACK_IMPORTED_MODULE_2__.getSlot)('lazy-teleport', this.$slots))
            : null;
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js":
/*!**********************************************************************!*\
  !*** ./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _delegate__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./delegate */ "./node_modules/vueuc/es/resize-observer/src/delegate.js");
/* harmony import */ var _shared__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../shared */ "./node_modules/vueuc/es/shared/warn.js");



/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'ResizeObserver',
    props: {
        onResize: Function
    },
    setup(props) {
        let registered = false;
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const proxy = (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)().proxy;
        function handleResize(entry) {
            const { onResize } = props;
            if (onResize !== undefined)
                onResize(entry);
        }
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            const el = proxy.$el;
            if (el === undefined) {
                (0,_shared__WEBPACK_IMPORTED_MODULE_1__.warn)('resize-observer', '$el does not exist.');
                return;
            }
            if (el.nextElementSibling !== el.nextSibling) {
                if (el.nodeType === 3 && el.nodeValue !== '') {
                    (0,_shared__WEBPACK_IMPORTED_MODULE_1__.warn)('resize-observer', '$el can not be observed (it may be a text node).');
                    return;
                }
            }
            if (el.nextElementSibling !== null) {
                _delegate__WEBPACK_IMPORTED_MODULE_2__["default"].registerHandler(el.nextElementSibling, handleResize);
                registered = true;
            }
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onBeforeUnmount)(() => {
            if (registered) {
                _delegate__WEBPACK_IMPORTED_MODULE_2__["default"].unregisterHandler(proxy.$el.nextElementSibling);
            }
        });
    },
    render() {
        return (0,vue__WEBPACK_IMPORTED_MODULE_0__.renderSlot)(this.$slots, 'default');
    }
}));


/***/ }),

/***/ "./node_modules/vueuc/es/resize-observer/src/delegate.js":
/*!***************************************************************!*\
  !*** ./node_modules/vueuc/es/resize-observer/src/delegate.js ***!
  \***************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _juggle_resize_observer__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @juggle/resize-observer */ "./node_modules/@juggle/resize-observer/lib/exports/resize-observer.js");

class ResizeObserverDelegate {
    constructor() {
        this.handleResize = this.handleResize.bind(this);
        this.observer = new ((typeof window !== 'undefined' &&
            window.ResizeObserver) ||
            _juggle_resize_observer__WEBPACK_IMPORTED_MODULE_0__.ResizeObserver)(this.handleResize);
        this.elHandlersMap = new Map();
    }
    handleResize(entries) {
        for (const entry of entries) {
            const handler = this.elHandlersMap.get(entry.target);
            if (handler !== undefined) {
                handler(entry);
            }
        }
    }
    registerHandler(el, handler) {
        this.elHandlersMap.set(el, handler);
        this.observer.observe(el);
    }
    unregisterHandler(el) {
        if (!this.elHandlersMap.has(el)) {
            return;
        }
        this.elHandlersMap.delete(el);
        this.observer.unobserve(el);
    }
}
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new ResizeObserverDelegate());


/***/ }),

/***/ "./node_modules/vueuc/es/shared/cssr.js":
/*!**********************************************!*\
  !*** ./node_modules/vueuc/es/shared/cssr.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   c: () => (/* binding */ c),
/* harmony export */   cssrAnchorMetaName: () => (/* binding */ cssrAnchorMetaName)
/* harmony export */ });
/* harmony import */ var css_render__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! css-render */ "./node_modules/css-render/esm/CssRender.js");

const { c } = (0,css_render__WEBPACK_IMPORTED_MODULE_0__.CssRender)();

const cssrAnchorMetaName = 'vueuc-style';


/***/ }),

/***/ "./node_modules/vueuc/es/shared/v-node.js":
/*!************************************************!*\
  !*** ./node_modules/vueuc/es/shared/v-node.js ***!
  \************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   flatten: () => (/* binding */ flatten),
/* harmony export */   getFirstVNode: () => (/* binding */ getFirstVNode),
/* harmony export */   getSlot: () => (/* binding */ getSlot)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function getSlot(scope, slots, slotName = 'default') {
    const slot = slots[slotName];
    if (slot === undefined) {
        throw new Error(`[vueuc/${scope}]: slot[${slotName}] is empty.`);
    }
    return slot();
}
// o(n) flatten
function flatten(vNodes, filterCommentNode = true, result = []) {
    vNodes.forEach((vNode) => {
        if (vNode === null)
            return;
        if (typeof vNode !== 'object') {
            if (typeof vNode === 'string' || typeof vNode === 'number') {
                result.push((0,vue__WEBPACK_IMPORTED_MODULE_0__.createTextVNode)(String(vNode)));
            }
            return;
        }
        if (Array.isArray(vNode)) {
            flatten(vNode, filterCommentNode, result);
            return;
        }
        if (vNode.type === vue__WEBPACK_IMPORTED_MODULE_0__.Fragment) {
            if (vNode.children === null)
                return;
            if (Array.isArray(vNode.children)) {
                flatten(vNode.children, filterCommentNode, result);
            }
            // rawSlot
        }
        else if (vNode.type !== vue__WEBPACK_IMPORTED_MODULE_0__.Comment) {
            result.push(vNode);
        }
    });
    return result;
}
function getFirstVNode(scope, slots, slotName = 'default') {
    const slot = slots[slotName];
    if (slot === undefined) {
        throw new Error(`[vueuc/${scope}]: slot[${slotName}] is empty.`);
    }
    const content = flatten(slot());
    // vue will normalize the slot, so slot must be an array
    if (content.length === 1) {
        return content[0];
    }
    else {
        throw new Error(`[vueuc/${scope}]: slot[${slotName}] should have exactly one child.`);
    }
}


/***/ }),

/***/ "./node_modules/vueuc/es/shared/warn.js":
/*!**********************************************!*\
  !*** ./node_modules/vueuc/es/shared/warn.js ***!
  \**********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   warn: () => (/* binding */ warn)
/* harmony export */ });
function warn(location, message) {
    console.error(`[vueuc/${location}]: ${message}`);
}


/***/ }),

/***/ "./node_modules/lodash-es/_arrayMap.js":
/*!*********************************************!*\
  !*** ./node_modules/lodash-es/_arrayMap.js ***!
  \*********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * A specialized version of `_.map` for arrays without support for iteratee
 * shorthands.
 *
 * @private
 * @param {Array} [array] The array to iterate over.
 * @param {Function} iteratee The function invoked per iteration.
 * @returns {Array} Returns the new mapped array.
 */
function arrayMap(array, iteratee) {
  var index = -1,
      length = array == null ? 0 : array.length,
      result = Array(length);

  while (++index < length) {
    result[index] = iteratee(array[index], index, array);
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (arrayMap);


/***/ }),

/***/ "./node_modules/lodash-es/_asciiToArray.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_asciiToArray.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * Converts an ASCII `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function asciiToArray(string) {
  return string.split('');
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (asciiToArray);


/***/ }),

/***/ "./node_modules/lodash-es/_baseSlice.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_baseSlice.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/**
 * The base implementation of `_.slice` without an iteratee call guard.
 *
 * @private
 * @param {Array} array The array to slice.
 * @param {number} [start=0] The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the slice of `array`.
 */
function baseSlice(array, start, end) {
  var index = -1,
      length = array.length;

  if (start < 0) {
    start = -start > length ? 0 : (length + start);
  }
  end = end > length ? length : end;
  if (end < 0) {
    end += length;
  }
  length = start > end ? 0 : ((end - start) >>> 0);
  start >>>= 0;

  var result = Array(length);
  while (++index < length) {
    result[index] = array[index + start];
  }
  return result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseSlice);


/***/ }),

/***/ "./node_modules/lodash-es/_baseToString.js":
/*!*************************************************!*\
  !*** ./node_modules/lodash-es/_baseToString.js ***!
  \*************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");
/* harmony import */ var _arrayMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_arrayMap.js */ "./node_modules/lodash-es/_arrayMap.js");
/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");
/* harmony import */ var _isSymbol_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isSymbol.js */ "./node_modules/lodash-es/isSymbol.js");





/** Used as references for various `Number` constants. */
var INFINITY = 1 / 0;

/** Used to convert symbols to primitives and strings. */
var symbolProto = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype : undefined,
    symbolToString = symbolProto ? symbolProto.toString : undefined;

/**
 * The base implementation of `_.toString` which doesn't convert nullish
 * values to empty strings.
 *
 * @private
 * @param {*} value The value to process.
 * @returns {string} Returns the string.
 */
function baseToString(value) {
  // Exit early for strings to avoid a performance hit in some environments.
  if (typeof value == 'string') {
    return value;
  }
  if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {
    // Recursively convert values (susceptible to call stack limits).
    return (0,_arrayMap_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value, baseToString) + '';
  }
  if ((0,_isSymbol_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value)) {
    return symbolToString ? symbolToString.call(value) : '';
  }
  var result = (value + '');
  return (result == '0' && (1 / value) == -INFINITY) ? '-0' : result;
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (baseToString);


/***/ }),

/***/ "./node_modules/lodash-es/_castSlice.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/_castSlice.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseSlice_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseSlice.js */ "./node_modules/lodash-es/_baseSlice.js");


/**
 * Casts `array` to a slice if it's needed.
 *
 * @private
 * @param {Array} array The array to inspect.
 * @param {number} start The start position.
 * @param {number} [end=array.length] The end position.
 * @returns {Array} Returns the cast slice.
 */
function castSlice(array, start, end) {
  var length = array.length;
  end = end === undefined ? length : end;
  return (!start && end >= length) ? array : (0,_baseSlice_js__WEBPACK_IMPORTED_MODULE_0__["default"])(array, start, end);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (castSlice);


/***/ }),

/***/ "./node_modules/lodash-es/_createCaseFirst.js":
/*!****************************************************!*\
  !*** ./node_modules/lodash-es/_createCaseFirst.js ***!
  \****************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _castSlice_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_castSlice.js */ "./node_modules/lodash-es/_castSlice.js");
/* harmony import */ var _hasUnicode_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_hasUnicode.js */ "./node_modules/lodash-es/_hasUnicode.js");
/* harmony import */ var _stringToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_stringToArray.js */ "./node_modules/lodash-es/_stringToArray.js");
/* harmony import */ var _toString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./toString.js */ "./node_modules/lodash-es/toString.js");





/**
 * Creates a function like `_.lowerFirst`.
 *
 * @private
 * @param {string} methodName The name of the `String` case method to use.
 * @returns {Function} Returns the new case function.
 */
function createCaseFirst(methodName) {
  return function(string) {
    string = (0,_toString_js__WEBPACK_IMPORTED_MODULE_0__["default"])(string);

    var strSymbols = (0,_hasUnicode_js__WEBPACK_IMPORTED_MODULE_1__["default"])(string)
      ? (0,_stringToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(string)
      : undefined;

    var chr = strSymbols
      ? strSymbols[0]
      : string.charAt(0);

    var trailing = strSymbols
      ? (0,_castSlice_js__WEBPACK_IMPORTED_MODULE_3__["default"])(strSymbols, 1).join('')
      : string.slice(1);

    return chr[methodName]() + trailing;
  };
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (createCaseFirst);


/***/ }),

/***/ "./node_modules/lodash-es/_hasUnicode.js":
/*!***********************************************!*\
  !*** ./node_modules/lodash-es/_hasUnicode.js ***!
  \***********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsZWJ = '\\u200d';

/** Used to detect strings with [zero-width joiners or code points from the astral planes](http://eev.ee/blog/2015/09/12/dark-corners-of-unicode/). */
var reHasUnicode = RegExp('[' + rsZWJ + rsAstralRange  + rsComboRange + rsVarRange + ']');

/**
 * Checks if `string` contains Unicode symbols.
 *
 * @private
 * @param {string} string The string to inspect.
 * @returns {boolean} Returns `true` if a symbol is found, else `false`.
 */
function hasUnicode(string) {
  return reHasUnicode.test(string);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (hasUnicode);


/***/ }),

/***/ "./node_modules/lodash-es/_stringToArray.js":
/*!**************************************************!*\
  !*** ./node_modules/lodash-es/_stringToArray.js ***!
  \**************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _asciiToArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_asciiToArray.js */ "./node_modules/lodash-es/_asciiToArray.js");
/* harmony import */ var _hasUnicode_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_hasUnicode.js */ "./node_modules/lodash-es/_hasUnicode.js");
/* harmony import */ var _unicodeToArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_unicodeToArray.js */ "./node_modules/lodash-es/_unicodeToArray.js");




/**
 * Converts `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function stringToArray(string) {
  return (0,_hasUnicode_js__WEBPACK_IMPORTED_MODULE_0__["default"])(string)
    ? (0,_unicodeToArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(string)
    : (0,_asciiToArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(string);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (stringToArray);


/***/ }),

/***/ "./node_modules/lodash-es/_unicodeToArray.js":
/*!***************************************************!*\
  !*** ./node_modules/lodash-es/_unicodeToArray.js ***!
  \***************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/** Used to compose unicode character classes. */
var rsAstralRange = '\\ud800-\\udfff',
    rsComboMarksRange = '\\u0300-\\u036f',
    reComboHalfMarksRange = '\\ufe20-\\ufe2f',
    rsComboSymbolsRange = '\\u20d0-\\u20ff',
    rsComboRange = rsComboMarksRange + reComboHalfMarksRange + rsComboSymbolsRange,
    rsVarRange = '\\ufe0e\\ufe0f';

/** Used to compose unicode capture groups. */
var rsAstral = '[' + rsAstralRange + ']',
    rsCombo = '[' + rsComboRange + ']',
    rsFitz = '\\ud83c[\\udffb-\\udfff]',
    rsModifier = '(?:' + rsCombo + '|' + rsFitz + ')',
    rsNonAstral = '[^' + rsAstralRange + ']',
    rsRegional = '(?:\\ud83c[\\udde6-\\uddff]){2}',
    rsSurrPair = '[\\ud800-\\udbff][\\udc00-\\udfff]',
    rsZWJ = '\\u200d';

/** Used to compose unicode regexes. */
var reOptMod = rsModifier + '?',
    rsOptVar = '[' + rsVarRange + ']?',
    rsOptJoin = '(?:' + rsZWJ + '(?:' + [rsNonAstral, rsRegional, rsSurrPair].join('|') + ')' + rsOptVar + reOptMod + ')*',
    rsSeq = rsOptVar + reOptMod + rsOptJoin,
    rsSymbol = '(?:' + [rsNonAstral + rsCombo + '?', rsCombo, rsRegional, rsSurrPair, rsAstral].join('|') + ')';

/** Used to match [string symbols](https://mathiasbynens.be/notes/javascript-unicode). */
var reUnicode = RegExp(rsFitz + '(?=' + rsFitz + ')|' + rsSymbol + rsSeq, 'g');

/**
 * Converts a Unicode `string` to an array.
 *
 * @private
 * @param {string} string The string to convert.
 * @returns {Array} Returns the converted array.
 */
function unicodeToArray(string) {
  return string.match(reUnicode) || [];
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (unicodeToArray);


/***/ }),

/***/ "./node_modules/lodash-es/isSymbol.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/isSymbol.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseGetTag.js */ "./node_modules/lodash-es/_baseGetTag.js");
/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");



/** `Object#toString` result references. */
var symbolTag = '[object Symbol]';

/**
 * Checks if `value` is classified as a `Symbol` primitive or object.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to check.
 * @returns {boolean} Returns `true` if `value` is a symbol, else `false`.
 * @example
 *
 * _.isSymbol(Symbol.iterator);
 * // => true
 *
 * _.isSymbol('abc');
 * // => false
 */
function isSymbol(value) {
  return typeof value == 'symbol' ||
    ((0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) == symbolTag);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (isSymbol);


/***/ }),

/***/ "./node_modules/lodash-es/toString.js":
/*!********************************************!*\
  !*** ./node_modules/lodash-es/toString.js ***!
  \********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _baseToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseToString.js */ "./node_modules/lodash-es/_baseToString.js");


/**
 * Converts `value` to a string. An empty string is returned for `null`
 * and `undefined` values. The sign of `-0` is preserved.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category Lang
 * @param {*} value The value to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.toString(null);
 * // => ''
 *
 * _.toString(-0);
 * // => '-0'
 *
 * _.toString([1, 2, 3]);
 * // => '1,2,3'
 */
function toString(value) {
  return value == null ? '' : (0,_baseToString_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value);
}

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (toString);


/***/ }),

/***/ "./node_modules/lodash-es/upperFirst.js":
/*!**********************************************!*\
  !*** ./node_modules/lodash-es/upperFirst.js ***!
  \**********************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _createCaseFirst_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_createCaseFirst.js */ "./node_modules/lodash-es/_createCaseFirst.js");


/**
 * Converts the first character of `string` to upper case.
 *
 * @static
 * @memberOf _
 * @since 4.0.0
 * @category String
 * @param {string} [string=''] The string to convert.
 * @returns {string} Returns the converted string.
 * @example
 *
 * _.upperFirst('fred');
 * // => 'Fred'
 *
 * _.upperFirst('FRED');
 * // => 'FRED'
 */
var upperFirst = (0,_createCaseFirst_js__WEBPACK_IMPORTED_MODULE_0__["default"])('toUpperCase');

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (upperFirst);


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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