"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_input-number_src_InputNumber_mjs"],{

/***/ "./node_modules/naive-ui/es/_internal/icons/Add.mjs":
/*!**********************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Add.mjs ***!
  \**********************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Add',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      width: "512",
      height: "512",
      viewBox: "0 0 512 512",
      fill: "none",
      xmlns: "http://www.w3.org/2000/svg"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", {
      d: "M256 112V400M400 256H112",
      stroke: "currentColor",
      "stroke-width": "32",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/_internal/icons/Remove.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/Remove.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'Remove',
  render() {
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", {
      xmlns: "http://www.w3.org/2000/svg",
      viewBox: "0 0 512 512"
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("line", {
      x1: "400",
      y1: "256",
      x2: "112",
      y2: "256",
      style: "\n        fill: none;\n        stroke: currentColor;\n        stroke-linecap: round;\n        stroke-linejoin: round;\n        stroke-width: 32px;\n      "
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/input-number/src/InputNumber.mjs":
/*!*******************************************************************!*\
  !*** ./node_modules/naive-ui/es/input-number/src/InputNumber.mjs ***!
  \*******************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   inputNumberProps: () => (/* binding */ inputNumberProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/color/index.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../_internal/icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Remove.mjs");
/* harmony import */ var _internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../_internal/icons/index.mjs */ "./node_modules/naive-ui/es/_internal/icons/Add.mjs");
/* harmony import */ var _input_index_mjs__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../input/index.mjs */ "./node_modules/naive-ui/es/input/src/Input.mjs");
/* harmony import */ var _internal_index_mjs__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../_internal/index.mjs */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.mjs");
/* harmony import */ var _button_index_mjs__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../button/index.mjs */ "./node_modules/naive-ui/es/button/src/Button.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-config.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-locale.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-form-item.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/naive/warn.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/call.mjs");
/* harmony import */ var _utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../_utils/index.mjs */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.mjs");
/* harmony import */ var _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles/index.mjs */ "./node_modules/naive-ui/es/input-number/styles/light.mjs");
/* harmony import */ var _mixins_use_rtl_mjs__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_mixins/use-rtl.mjs */ "./node_modules/naive-ui/es/_mixins/use-rtl.mjs");
/* harmony import */ var _utils_mjs__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils.mjs */ "./node_modules/naive-ui/es/input-number/src/utils.mjs");
/* harmony import */ var _styles_input_number_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/input-number.cssr.mjs */ "./node_modules/naive-ui/es/input-number/src/styles/input-number.cssr.mjs");














const HOLDING_CHANGE_THRESHOLD = 800;
const HOLDING_CHANGE_INTERVAL = 100;
const inputNumberProps = Object.assign(Object.assign({}, _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"].props), {
  autofocus: Boolean,
  loading: {
    type: Boolean,
    default: undefined
  },
  placeholder: String,
  defaultValue: {
    type: Number,
    default: null
  },
  value: Number,
  step: {
    type: [Number, String],
    default: 1
  },
  min: [Number, String],
  max: [Number, String],
  size: String,
  disabled: {
    type: Boolean,
    default: undefined
  },
  validator: Function,
  bordered: {
    type: Boolean,
    default: undefined
  },
  showButton: {
    type: Boolean,
    default: true
  },
  buttonPlacement: {
    type: String,
    default: 'right'
  },
  inputProps: Object,
  readonly: Boolean,
  clearable: Boolean,
  keyboard: {
    type: Object,
    default: {}
  },
  updateValueOnInput: {
    type: Boolean,
    default: true
  },
  round: {
    type: Boolean,
    default: undefined
  },
  parse: Function,
  format: Function,
  precision: Number,
  status: String,
  'onUpdate:value': [Function, Array],
  onUpdateValue: [Function, Array],
  onFocus: [Function, Array],
  onBlur: [Function, Array],
  onClear: [Function, Array],
  // deprecated
  onChange: [Function, Array]
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
  name: 'InputNumber',
  props: inputNumberProps,
  setup(props) {
    if (true) {
      (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
        if (props.onChange !== undefined) {
          (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_2__.warnOnce)('input-number', '`on-change` is deprecated, please use `on-update:value` instead');
        }
      });
    }
    const {
      mergedBorderedRef,
      mergedClsPrefixRef,
      mergedRtlRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
    const themeRef = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"])('InputNumber', '-input-number', _styles_input_number_cssr_mjs__WEBPACK_IMPORTED_MODULE_4__["default"], _styles_index_mjs__WEBPACK_IMPORTED_MODULE_5__["default"], props, mergedClsPrefixRef);
    const {
      localeRef
    } = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_6__["default"])('InputNumber');
    const formItem = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_7__["default"])(props);
    const {
      mergedSizeRef,
      mergedDisabledRef,
      mergedStatusRef
    } = formItem;
    // dom ref
    const inputInstRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const minusButtonInstRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    const addButtonInstRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    // value
    const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultValue);
    const controlledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value');
    const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_8__["default"])(controlledValueRef, uncontrolledValueRef);
    const displayedValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)('');
    const getPrecision = value => {
      const fraction = String(value).split('.')[1];
      return fraction ? fraction.length : 0;
    };
    const getMaxPrecision = currentValue => {
      const precisions = [props.min, props.max, props.step, currentValue].map(value => {
        if (value === undefined) return 0;
        return getPrecision(value);
      });
      return Math.max(...precisions);
    };
    const mergedPlaceholderRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const {
        placeholder
      } = props;
      if (placeholder !== undefined) return placeholder;
      return localeRef.value.placeholder;
    });
    const mergedStepRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const parsedNumber = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.parseNumber)(props.step);
      if (parsedNumber !== null) {
        return parsedNumber === 0 ? 1 : Math.abs(parsedNumber);
      }
      return 1;
    });
    const mergedMinRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const parsedNumber = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.parseNumber)(props.min);
      if (parsedNumber !== null) return parsedNumber;else return null;
    });
    const mergedMaxRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const parsedNumber = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.parseNumber)(props.max);
      if (parsedNumber !== null) return parsedNumber;else return null;
    });
    const deriveDisplayedValueFromValue = () => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if ((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.validator)(mergedValue)) {
        const {
          format: formatProp,
          precision
        } = props;
        if (formatProp) {
          displayedValueRef.value = formatProp(mergedValue);
        } else {
          if (mergedValue === null || precision === undefined
          // precision overflow
          || getPrecision(mergedValue) > precision) {
            displayedValueRef.value = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.format)(mergedValue, undefined);
          } else {
            displayedValueRef.value = (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.format)(mergedValue, precision);
          }
        }
      } else {
        // null can pass the validator check
        // so mergedValue is a number
        displayedValueRef.value = String(mergedValue);
      }
    };
    deriveDisplayedValueFromValue();
    const doUpdateValue = value => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (value === mergedValue) {
        deriveDisplayedValueFromValue();
        return;
      }
      const {
        'onUpdate:value': _onUpdateValue,
        onUpdateValue,
        onChange
      } = props;
      const {
        nTriggerFormInput,
        nTriggerFormChange
      } = formItem;
      if (onChange) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.call)(onChange, value);
      if (onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.call)(onUpdateValue, value);
      if (_onUpdateValue) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.call)(_onUpdateValue, value);
      uncontrolledValueRef.value = value;
      nTriggerFormInput();
      nTriggerFormChange();
    };
    const deriveValueFromDisplayedValue = ({
      offset,
      doUpdateIfValid,
      fixPrecision,
      isInputing
    }) => {
      const {
        value: displayedValue
      } = displayedValueRef;
      if (isInputing && (0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.isWipValue)(displayedValue)) {
        return false;
      }
      const parsedValue = (props.parse || _utils_mjs__WEBPACK_IMPORTED_MODULE_10__.parse)(displayedValue);
      if (parsedValue === null) {
        if (doUpdateIfValid) doUpdateValue(null);
        return null;
      }
      if ((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.validator)(parsedValue)) {
        const currentPrecision = getPrecision(parsedValue);
        const {
          precision
        } = props;
        if (precision !== undefined && precision < currentPrecision && !fixPrecision) {
          return false;
        }
        let nextValue = Number.parseFloat((parsedValue + offset).toFixed(precision !== null && precision !== void 0 ? precision : getMaxPrecision(parsedValue)));
        if ((0,_utils_mjs__WEBPACK_IMPORTED_MODULE_10__.validator)(nextValue)) {
          const {
            value: mergedMax
          } = mergedMaxRef;
          const {
            value: mergedMin
          } = mergedMinRef;
          if (mergedMax !== null && nextValue > mergedMax) {
            if (!doUpdateIfValid || isInputing) return false;
            // if doUpdateIfValid=true, we try to make it a valid value
            nextValue = mergedMax;
          }
          if (mergedMin !== null && nextValue < mergedMin) {
            if (!doUpdateIfValid || isInputing) return false;
            // if doUpdateIfValid=true, we try to make it a valid value
            nextValue = mergedMin;
          }
          if (props.validator && !props.validator(nextValue)) return false;
          if (doUpdateIfValid) doUpdateValue(nextValue);
          return nextValue;
        }
      }
      return false;
    };
    const displayedValueInvalidRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const derivedValue = deriveValueFromDisplayedValue({
        offset: 0,
        doUpdateIfValid: false,
        isInputing: false,
        fixPrecision: false
      });
      return derivedValue === false;
    });
    const minusableRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (props.validator && mergedValue === null) {
        return false;
      }
      const {
        value: mergedStep
      } = mergedStepRef;
      const derivedNextValue = deriveValueFromDisplayedValue({
        offset: -mergedStep,
        doUpdateIfValid: false,
        isInputing: false,
        fixPrecision: false
      });
      return derivedNextValue !== false;
    });
    const addableRef = (0,vooks__WEBPACK_IMPORTED_MODULE_9__["default"])(() => {
      const {
        value: mergedValue
      } = mergedValueRef;
      if (props.validator && mergedValue === null) {
        return false;
      }
      const {
        value: mergedStep
      } = mergedStepRef;
      const derivedNextValue = deriveValueFromDisplayedValue({
        offset: +mergedStep,
        doUpdateIfValid: false,
        isInputing: false,
        fixPrecision: false
      });
      return derivedNextValue !== false;
    });
    function doFocus(e) {
      const {
        onFocus
      } = props;
      const {
        nTriggerFormFocus
      } = formItem;
      if (onFocus) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.call)(onFocus, e);
      nTriggerFormFocus();
    }
    function doBlur(e) {
      var _a, _b;
      if (e.target === ((_a = inputInstRef.value) === null || _a === void 0 ? void 0 : _a.wrapperElRef)) {
        // hit input wrapper
        // which means not activated
        return;
      }
      const value = deriveValueFromDisplayedValue({
        offset: 0,
        doUpdateIfValid: true,
        isInputing: false,
        fixPrecision: true
      });
      // If valid, update event has been emitted
      // make sure e.target.value is correct in blur callback
      if (value !== false) {
        const inputElRef = (_b = inputInstRef.value) === null || _b === void 0 ? void 0 : _b.inputElRef;
        if (inputElRef) {
          inputElRef.value = String(value || '');
        }
        // If value is not changed, the displayed value may be greater than or
        // less than the current value. The derived value is reformatted so the
        // value is not changed. We can simply derive a new displayed value
        if (mergedValueRef.value === value) {
          deriveDisplayedValueFromValue();
        }
      } else {
        // If not valid, nothing will be emitted, so derive displayed value from
        // origin value
        deriveDisplayedValueFromValue();
      }
      const {
        onBlur
      } = props;
      const {
        nTriggerFormBlur
      } = formItem;
      if (onBlur) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.call)(onBlur, e);
      nTriggerFormBlur();
      // User may change value in blur callback, we make sure it will be
      // displayed. Sometimes mergedValue won't be viewed as changed
      void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => {
        deriveDisplayedValueFromValue();
      });
    }
    function doClear(e) {
      const {
        onClear
      } = props;
      if (onClear) (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_11__.call)(onClear, e);
    }
    function doAdd() {
      const {
        value: addable
      } = addableRef;
      if (!addable) {
        clearAddHoldTimeout();
        return;
      }
      const {
        value: mergedValue
      } = mergedValueRef;
      if (mergedValue === null) {
        if (!props.validator) {
          doUpdateValue(createValidValue());
        }
      } else {
        const {
          value: mergedStep
        } = mergedStepRef;
        deriveValueFromDisplayedValue({
          offset: mergedStep,
          doUpdateIfValid: true,
          isInputing: false,
          fixPrecision: true
        });
      }
    }
    function doMinus() {
      const {
        value: minusable
      } = minusableRef;
      if (!minusable) {
        clearMinusHoldTimeout();
        return;
      }
      const {
        value: mergedValue
      } = mergedValueRef;
      if (mergedValue === null) {
        if (!props.validator) {
          doUpdateValue(createValidValue());
        }
      } else {
        const {
          value: mergedStep
        } = mergedStepRef;
        deriveValueFromDisplayedValue({
          offset: -mergedStep,
          doUpdateIfValid: true,
          isInputing: false,
          fixPrecision: true
        });
      }
    }
    const handleFocus = doFocus;
    const handleBlur = doBlur;
    function createValidValue() {
      if (props.validator) return null;
      const {
        value: mergedMin
      } = mergedMinRef;
      const {
        value: mergedMax
      } = mergedMaxRef;
      if (mergedMin !== null) {
        return Math.max(0, mergedMin);
      } else if (mergedMax !== null) {
        return Math.min(0, mergedMax);
      } else {
        return 0;
      }
    }
    function handleClear(e) {
      doClear(e);
      doUpdateValue(null);
    }
    function handleMouseDown(e) {
      var _a, _b, _c;
      if ((_a = addButtonInstRef.value) === null || _a === void 0 ? void 0 : _a.$el.contains(e.target)) {
        e.preventDefault();
      }
      if ((_b = minusButtonInstRef.value) === null || _b === void 0 ? void 0 : _b.$el.contains(e.target)) {
        e.preventDefault();
      }
      (_c = inputInstRef.value) === null || _c === void 0 ? void 0 : _c.activate();
    }
    let minusHoldStateIntervalId = null;
    let addHoldStateIntervalId = null;
    let firstMinusMousedownId = null;
    function clearMinusHoldTimeout() {
      if (firstMinusMousedownId) {
        window.clearTimeout(firstMinusMousedownId);
        firstMinusMousedownId = null;
      }
      if (minusHoldStateIntervalId) {
        window.clearInterval(minusHoldStateIntervalId);
        minusHoldStateIntervalId = null;
      }
    }
    let firstAddMousedownId = null;
    function clearAddHoldTimeout() {
      if (firstAddMousedownId) {
        window.clearTimeout(firstAddMousedownId);
        firstAddMousedownId = null;
      }
      if (addHoldStateIntervalId) {
        window.clearInterval(addHoldStateIntervalId);
        addHoldStateIntervalId = null;
      }
    }
    function handleMinusMousedown() {
      clearMinusHoldTimeout();
      firstMinusMousedownId = window.setTimeout(() => {
        minusHoldStateIntervalId = window.setInterval(() => {
          doMinus();
        }, HOLDING_CHANGE_INTERVAL);
      }, HOLDING_CHANGE_THRESHOLD);
      (0,evtd__WEBPACK_IMPORTED_MODULE_12__.on)('mouseup', document, clearMinusHoldTimeout, {
        once: true
      });
    }
    function handleAddMousedown() {
      clearAddHoldTimeout();
      firstAddMousedownId = window.setTimeout(() => {
        addHoldStateIntervalId = window.setInterval(() => {
          doAdd();
        }, HOLDING_CHANGE_INTERVAL);
      }, HOLDING_CHANGE_THRESHOLD);
      (0,evtd__WEBPACK_IMPORTED_MODULE_12__.on)('mouseup', document, clearAddHoldTimeout, {
        once: true
      });
    }
    const handleAddClick = () => {
      if (addHoldStateIntervalId) return;
      doAdd();
    };
    const handleMinusClick = () => {
      if (minusHoldStateIntervalId) return;
      doMinus();
    };
    function handleKeyDown(e) {
      var _a, _b;
      if (e.key === 'Enter') {
        if (e.target === ((_a = inputInstRef.value) === null || _a === void 0 ? void 0 : _a.wrapperElRef)) {
          // hit input wrapper
          // which means not activated
          return;
        }
        const value = deriveValueFromDisplayedValue({
          offset: 0,
          doUpdateIfValid: true,
          isInputing: false,
          fixPrecision: true
        });
        if (value !== false) {
          (_b = inputInstRef.value) === null || _b === void 0 ? void 0 : _b.deactivate();
        }
      } else if (e.key === 'ArrowUp') {
        if (!addableRef.value) return;
        if (props.keyboard.ArrowUp === false) return;
        e.preventDefault();
        const value = deriveValueFromDisplayedValue({
          offset: 0,
          doUpdateIfValid: true,
          isInputing: false,
          fixPrecision: true
        });
        if (value !== false) {
          doAdd();
        }
      } else if (e.key === 'ArrowDown') {
        if (!minusableRef.value) return;
        if (props.keyboard.ArrowDown === false) return;
        e.preventDefault();
        const value = deriveValueFromDisplayedValue({
          offset: 0,
          doUpdateIfValid: true,
          isInputing: false,
          fixPrecision: true
        });
        if (value !== false) {
          doMinus();
        }
      }
    }
    function handleUpdateDisplayedValue(value) {
      displayedValueRef.value = value;
      if (props.updateValueOnInput && !props.format && !props.parse && props.precision === undefined) {
        deriveValueFromDisplayedValue({
          offset: 0,
          doUpdateIfValid: true,
          isInputing: true,
          fixPrecision: false
        });
      }
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedValueRef, () => {
      deriveDisplayedValueFromValue();
    });
    const exposedMethods = {
      focus: () => {
        var _a;
        return (_a = inputInstRef.value) === null || _a === void 0 ? void 0 : _a.focus();
      },
      blur: () => {
        var _a;
        return (_a = inputInstRef.value) === null || _a === void 0 ? void 0 : _a.blur();
      },
      select: () => {
        var _a;
        return (_a = inputInstRef.value) === null || _a === void 0 ? void 0 : _a.select();
      }
    };
    const rtlEnabledRef = (0,_mixins_use_rtl_mjs__WEBPACK_IMPORTED_MODULE_13__.useRtl)('InputNumber', mergedRtlRef, mergedClsPrefixRef);
    return Object.assign(Object.assign({}, exposedMethods), {
      rtlEnabled: rtlEnabledRef,
      inputInstRef,
      minusButtonInstRef,
      addButtonInstRef,
      mergedClsPrefix: mergedClsPrefixRef,
      mergedBordered: mergedBorderedRef,
      uncontrolledValue: uncontrolledValueRef,
      mergedValue: mergedValueRef,
      mergedPlaceholder: mergedPlaceholderRef,
      displayedValueInvalid: displayedValueInvalidRef,
      mergedSize: mergedSizeRef,
      mergedDisabled: mergedDisabledRef,
      displayedValue: displayedValueRef,
      addable: addableRef,
      minusable: minusableRef,
      mergedStatus: mergedStatusRef,
      handleFocus,
      handleBlur,
      handleClear,
      handleMouseDown,
      handleAddClick,
      handleMinusClick,
      handleAddMousedown,
      handleMinusMousedown,
      handleKeyDown,
      handleUpdateDisplayedValue,
      // theme
      mergedTheme: themeRef,
      inputThemeOverrides: {
        paddingSmall: '0 8px 0 10px',
        paddingMedium: '0 8px 0 12px',
        paddingLarge: '0 8px 0 14px'
      },
      buttonThemeOverrides: (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
        const {
          self: {
            iconColorDisabled
          }
        } = themeRef.value;
        const [r, g, b, a] = (0,seemly__WEBPACK_IMPORTED_MODULE_14__.rgba)(iconColorDisabled);
        return {
          textColorTextDisabled: `rgb(${r}, ${g}, ${b})`,
          opacityDisabled: `${a}`
        };
      })
    });
  },
  render() {
    const {
      mergedClsPrefix,
      $slots
    } = this;
    const renderMinusButton = () => {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_button_index_mjs__WEBPACK_IMPORTED_MODULE_15__.XButton, {
        text: true,
        disabled: !this.minusable || this.mergedDisabled || this.readonly,
        focusable: false,
        theme: this.mergedTheme.peers.Button,
        themeOverrides: this.mergedTheme.peerOverrides.Button,
        builtinThemeOverrides: this.buttonThemeOverrides,
        onClick: this.handleMinusClick,
        onMousedown: this.handleMinusMousedown,
        ref: "minusButtonInstRef"
      }, {
        icon: () => (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.resolveSlot)($slots['minus-icon'], () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          clsPrefix: mergedClsPrefix
        }, {
          default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_18__["default"], null)
        })])
      });
    };
    const renderAddButton = () => {
      return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_button_index_mjs__WEBPACK_IMPORTED_MODULE_15__.XButton, {
        text: true,
        disabled: !this.addable || this.mergedDisabled || this.readonly,
        focusable: false,
        theme: this.mergedTheme.peers.Button,
        themeOverrides: this.mergedTheme.peerOverrides.Button,
        builtinThemeOverrides: this.buttonThemeOverrides,
        onClick: this.handleAddClick,
        onMousedown: this.handleAddMousedown,
        ref: "addButtonInstRef"
      }, {
        icon: () => (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.resolveSlot)($slots['add-icon'], () => [(0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_index_mjs__WEBPACK_IMPORTED_MODULE_17__["default"], {
          clsPrefix: mergedClsPrefix
        }, {
          default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons_index_mjs__WEBPACK_IMPORTED_MODULE_19__["default"], null)
        })])
      });
    };
    return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", {
      class: [`${mergedClsPrefix}-input-number`, this.rtlEnabled && `${mergedClsPrefix}-input-number--rtl`]
    }, (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_input_index_mjs__WEBPACK_IMPORTED_MODULE_20__["default"], {
      ref: "inputInstRef",
      autofocus: this.autofocus,
      status: this.mergedStatus,
      bordered: this.mergedBordered,
      loading: this.loading,
      value: this.displayedValue,
      onUpdateValue: this.handleUpdateDisplayedValue,
      theme: this.mergedTheme.peers.Input,
      themeOverrides: this.mergedTheme.peerOverrides.Input,
      builtinThemeOverrides: this.inputThemeOverrides,
      size: this.mergedSize,
      placeholder: this.mergedPlaceholder,
      disabled: this.mergedDisabled,
      readonly: this.readonly,
      round: this.round,
      textDecoration: this.displayedValueInvalid ? 'line-through' : undefined,
      onFocus: this.handleFocus,
      onBlur: this.handleBlur,
      onKeydown: this.handleKeyDown,
      onMousedown: this.handleMouseDown,
      onClear: this.handleClear,
      clearable: this.clearable,
      inputProps: this.inputProps,
      internalLoadingBeforeSuffix: true
    }, {
      prefix: () => {
        var _a;
        return this.showButton && this.buttonPlacement === 'both' ? [renderMinusButton(), (0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.resolveWrappedSlot)($slots.prefix, children => {
          if (children) {
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
              class: `${mergedClsPrefix}-input-number-prefix`
            }, children);
          }
          return null;
        })] : (_a = $slots.prefix) === null || _a === void 0 ? void 0 : _a.call($slots);
      },
      suffix: () => {
        var _a;
        return this.showButton ? [(0,_utils_index_mjs__WEBPACK_IMPORTED_MODULE_16__.resolveWrappedSlot)($slots.suffix, children => {
          if (children) {
            return (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", {
              class: `${mergedClsPrefix}-input-number-suffix`
            }, children);
          }
          return null;
        }), this.buttonPlacement === 'right' ? renderMinusButton() : null, renderAddButton()] : (_a = $slots.suffix) === null || _a === void 0 ? void 0 : _a.call($slots);
      }
    }));
  }
}));

/***/ }),

/***/ "./node_modules/naive-ui/es/input-number/src/styles/input-number.cssr.mjs":
/*!********************************************************************************!*\
  !*** ./node_modules/naive-ui/es/input-number/src/styles/input-number.cssr.mjs ***!
  \********************************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr/index.mjs */ "./node_modules/naive-ui/es/_utils/cssr/index.mjs");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.c)([(0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-number-suffix', `
 display: inline-block;
 margin-right: 10px;
 `), (0,_utils_cssr_index_mjs__WEBPACK_IMPORTED_MODULE_0__.cB)('input-number-prefix', `
 display: inline-block;
 margin-left: 10px;
 `)]));

/***/ }),

/***/ "./node_modules/naive-ui/es/input-number/src/utils.mjs":
/*!*************************************************************!*\
  !*** ./node_modules/naive-ui/es/input-number/src/utils.mjs ***!
  \*************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   format: () => (/* binding */ format),
/* harmony export */   isWipValue: () => (/* binding */ isWipValue),
/* harmony export */   parse: () => (/* binding */ parse),
/* harmony export */   parseNumber: () => (/* binding */ parseNumber),
/* harmony export */   validator: () => (/* binding */ validator)
/* harmony export */ });
// string => string (expected, not implemented)
// string => number (legacy)
function parse(value) {
  if (value === undefined || value === null || typeof value === 'string' && value.trim() === '') {
    return null;
  }
  return Number(value);
}
// can be parsed to number but shouldn't be applied when inputing
// when value includes `.`, ending with 0 and`.`, doesn't update, if 0 parse func will remove 0
function isWipValue(value) {
  return value.includes('.') && (/^(-)?\d+.*(\.|0)$/.test(value) || /^\.\d+$/.test(value));
}
// string => boolean (expected, not implemented)
// number => boolean (legacy)
function validator(value) {
  if (value === undefined || value === null) return true;
  if (Number.isNaN(value)) return false;
  return true;
}
// string => string (expected, not implemented)
// number => string (legacy)
function format(value, precision) {
  if (typeof value !== 'number') return '';
  return precision === undefined ? String(value) : value.toFixed(precision);
}
function parseNumber(number) {
  if (number === null) return null;
  if (typeof number === 'number') {
    return number;
  } else {
    const parsedNumber = Number(number);
    if (Number.isNaN(parsedNumber)) {
      return null;
    } else {
      return parsedNumber;
    }
  }
}

/***/ }),

/***/ "./node_modules/naive-ui/es/input-number/styles/light.mjs":
/*!****************************************************************!*\
  !*** ./node_modules/naive-ui/es/input-number/styles/light.mjs ***!
  \****************************************************************/
/***/ ((__unused_webpack___webpack_module__, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _button_styles_index_mjs__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../button/styles/index.mjs */ "./node_modules/naive-ui/es/button/styles/light.mjs");
/* harmony import */ var _input_styles_index_mjs__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../input/styles/index.mjs */ "./node_modules/naive-ui/es/input/styles/light.mjs");
/* harmony import */ var _styles_common_index_mjs__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_styles/common/index.mjs */ "./node_modules/naive-ui/es/_styles/common/light.mjs");
/* harmony import */ var _mixins_index_mjs__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_mixins/index.mjs */ "./node_modules/naive-ui/es/_mixins/use-theme.mjs");




function self(vars) {
  const {
    textColorDisabled
  } = vars;
  return {
    iconColorDisabled: textColorDisabled
  };
}
const inputNumberLight = (0,_mixins_index_mjs__WEBPACK_IMPORTED_MODULE_0__.createTheme)({
  name: 'InputNumber',
  common: _styles_common_index_mjs__WEBPACK_IMPORTED_MODULE_1__["default"],
  peers: {
    Button: _button_styles_index_mjs__WEBPACK_IMPORTED_MODULE_2__["default"],
    Input: _input_styles_index_mjs__WEBPACK_IMPORTED_MODULE_3__["default"]
  },
  self
});
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (inputNumberLight);

/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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