"use strict";
(self["webpackChunknearbeach"] = self["webpackChunknearbeach"] || []).push([["vendors-node_modules_naive-ui_es_input_src_Input_js"],{

/***/ "./node_modules/naive-ui/es/_internal/icons/EyeOff.js":
/*!************************************************************!*\
  !*** ./node_modules/naive-ui/es/_internal/icons/EyeOff.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'EyeOff',
    render() {
        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("svg", { xmlns: "http://www.w3.org/2000/svg", viewBox: "0 0 512 512" },
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", { d: "M432 448a15.92 15.92 0 0 1-11.31-4.69l-352-352a16 16 0 0 1 22.62-22.62l352 352A16 16 0 0 1 432 448z", fill: "currentColor" }),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", { d: "M255.66 384c-41.49 0-81.5-12.28-118.92-36.5c-34.07-22-64.74-53.51-88.7-91v-.08c19.94-28.57 41.78-52.73 65.24-72.21a2 2 0 0 0 .14-2.94L93.5 161.38a2 2 0 0 0-2.71-.12c-24.92 21-48.05 46.76-69.08 76.92a31.92 31.92 0 0 0-.64 35.54c26.41 41.33 60.4 76.14 98.28 100.65C162 402 207.9 416 255.66 416a239.13 239.13 0 0 0 75.8-12.58a2 2 0 0 0 .77-3.31l-21.58-21.58a4 4 0 0 0-3.83-1a204.8 204.8 0 0 1-51.16 6.47z", fill: "currentColor" }),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", { d: "M490.84 238.6c-26.46-40.92-60.79-75.68-99.27-100.53C349 110.55 302 96 255.66 96a227.34 227.34 0 0 0-74.89 12.83a2 2 0 0 0-.75 3.31l21.55 21.55a4 4 0 0 0 3.88 1a192.82 192.82 0 0 1 50.21-6.69c40.69 0 80.58 12.43 118.55 37c34.71 22.4 65.74 53.88 89.76 91a.13.13 0 0 1 0 .16a310.72 310.72 0 0 1-64.12 72.73a2 2 0 0 0-.15 2.95l19.9 19.89a2 2 0 0 0 2.7.13a343.49 343.49 0 0 0 68.64-78.48a32.2 32.2 0 0 0-.1-34.78z", fill: "currentColor" }),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", { d: "M256 160a95.88 95.88 0 0 0-21.37 2.4a2 2 0 0 0-1 3.38l112.59 112.56a2 2 0 0 0 3.38-1A96 96 0 0 0 256 160z", fill: "currentColor" }),
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("path", { d: "M165.78 233.66a2 2 0 0 0-3.38 1a96 96 0 0 0 115 115a2 2 0 0 0 1-3.38z", fill: "currentColor" })));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/Input.js":
/*!*****************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/Input.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   inputProps: () => (/* binding */ inputProps)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-merged-state.js");
/* harmony import */ var vooks__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! vooks */ "./node_modules/vooks/es/use-memo.js");
/* harmony import */ var seemly__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! seemly */ "./node_modules/seemly/es/css/index.js");
/* harmony import */ var vueuc__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! vueuc */ "./node_modules/vueuc/es/resize-observer/src/VResizeObserver.js");
/* harmony import */ var evtd__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! evtd */ "./node_modules/evtd/es/delegate.js");
/* harmony import */ var _utils_env_browser__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../_utils/env/browser */ "./node_modules/naive-ui/es/_utils/env/browser.js");
/* harmony import */ var _internal_icons__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../_internal/icons */ "./node_modules/naive-ui/es/_internal/icons/Eye.js");
/* harmony import */ var _internal_icons__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../_internal/icons */ "./node_modules/naive-ui/es/_internal/icons/EyeOff.js");
/* harmony import */ var _mixins_use_rtl__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../_mixins/use-rtl */ "./node_modules/naive-ui/es/_mixins/use-rtl.js");
/* harmony import */ var _internal__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../_internal */ "./node_modules/naive-ui/es/_internal/scrollbar/src/Scrollbar.js");
/* harmony import */ var _internal__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../_internal */ "./node_modules/naive-ui/es/_internal/clear/src/Clear.js");
/* harmony import */ var _internal__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../_internal */ "./node_modules/naive-ui/es/_internal/suffix/src/Suffix.js");
/* harmony import */ var _internal__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../_internal */ "./node_modules/naive-ui/es/_internal/icon/src/Icon.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-theme.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-config.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-style.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-locale.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-form-item.js");
/* harmony import */ var _mixins__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../_mixins */ "./node_modules/naive-ui/es/_mixins/use-css-vars-class.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/naive/warn.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/vue/call.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/cssr/create-key.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.js");
/* harmony import */ var _styles__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../styles */ "./node_modules/naive-ui/es/input/styles/light.js");
/* harmony import */ var _interface__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./interface */ "./node_modules/naive-ui/es/input/src/interface.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./utils */ "./node_modules/naive-ui/es/input/src/utils.js");
/* harmony import */ var _WordCount__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./WordCount */ "./node_modules/naive-ui/es/input/src/WordCount.js");
/* harmony import */ var _styles_input_cssr__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./styles/input.cssr */ "./node_modules/naive-ui/es/input/src/styles/input.cssr.js");
















const inputProps = Object.assign(Object.assign({}, _mixins__WEBPACK_IMPORTED_MODULE_1__["default"].props), { bordered: {
        type: Boolean,
        default: undefined
    }, type: {
        type: String,
        default: 'text'
    }, placeholder: [Array, String], defaultValue: {
        type: [String, Array],
        default: null
    }, value: [String, Array], disabled: {
        type: Boolean,
        default: undefined
    }, size: String, rows: {
        type: [Number, String],
        default: 3
    }, round: Boolean, minlength: [String, Number], maxlength: [String, Number], clearable: Boolean, autosize: {
        type: [Boolean, Object],
        default: false
    }, pair: Boolean, separator: String, readonly: {
        type: [String, Boolean],
        default: false
    }, passivelyActivated: Boolean, showPasswordOn: String, stateful: {
        type: Boolean,
        default: true
    }, autofocus: Boolean, inputProps: Object, resizable: {
        type: Boolean,
        default: true
    }, showCount: Boolean, loading: {
        type: Boolean,
        default: undefined
    }, allowInput: Function, renderCount: Function, onMousedown: Function, onKeydown: Function, onKeyup: Function, onInput: [Function, Array], onFocus: [Function, Array], onBlur: [Function, Array], onClick: [Function, Array], onChange: [Function, Array], onClear: [Function, Array], countGraphemes: Function, status: String, 'onUpdate:value': [Function, Array], onUpdateValue: [Function, Array], 
    /** private */
    textDecoration: [String, Array], attrSize: {
        type: Number,
        default: 20
    }, onInputBlur: [Function, Array], onInputFocus: [Function, Array], onDeactivate: [Function, Array], onActivate: [Function, Array], onWrapperFocus: [Function, Array], onWrapperBlur: [Function, Array], internalDeactivateOnEnter: Boolean, internalForceFocus: Boolean, internalLoadingBeforeSuffix: Boolean, 
    /** deprecated */
    showPasswordToggle: Boolean });
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'Input',
    props: inputProps,
    setup(props) {
        if (true) {
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
                if (props.showPasswordToggle) {
                    (0,_utils__WEBPACK_IMPORTED_MODULE_2__.warnOnce)('input', '`show-password-toggle` is deprecated, please use `showPasswordOn="click"` instead');
                }
            });
        }
        const { mergedClsPrefixRef, mergedBorderedRef, inlineThemeDisabled, mergedRtlRef } = (0,_mixins__WEBPACK_IMPORTED_MODULE_3__["default"])(props);
        const themeRef = (0,_mixins__WEBPACK_IMPORTED_MODULE_1__["default"])('Input', '-input', _styles_input_cssr__WEBPACK_IMPORTED_MODULE_4__["default"], _styles__WEBPACK_IMPORTED_MODULE_5__["default"], props, mergedClsPrefixRef);
        if (_utils_env_browser__WEBPACK_IMPORTED_MODULE_6__.isSafari) {
            (0,_mixins__WEBPACK_IMPORTED_MODULE_7__["default"])('-input-safari', _styles_input_cssr__WEBPACK_IMPORTED_MODULE_4__.safariStyle, mergedClsPrefixRef);
        }
        // dom refs
        const wrapperElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const textareaElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const textareaMirrorElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const inputMirrorElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const inputElRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const inputEl2Ref = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const currentFocusedInputRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        const focusedInputCursorControl = (0,_utils__WEBPACK_IMPORTED_MODULE_8__.useCursor)(currentFocusedInputRef);
        const textareaScrollbarInstRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
        // local
        const { localeRef } = (0,_mixins__WEBPACK_IMPORTED_MODULE_9__["default"])('Input');
        // value
        const uncontrolledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(props.defaultValue);
        const controlledValueRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'value');
        const mergedValueRef = (0,vooks__WEBPACK_IMPORTED_MODULE_10__["default"])(controlledValueRef, uncontrolledValueRef);
        // form-item
        const formItem = (0,_mixins__WEBPACK_IMPORTED_MODULE_11__["default"])(props);
        const { mergedSizeRef, mergedDisabledRef, mergedStatusRef } = formItem;
        // states
        const focusedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const hoverRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const isComposingRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        const activatedRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        let syncSource = null;
        // placeholder
        const mergedPlaceholderRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { placeholder, pair } = props;
            if (pair) {
                if (Array.isArray(placeholder)) {
                    return placeholder;
                }
                else if (placeholder === undefined) {
                    return ['', ''];
                }
                return [placeholder, placeholder];
            }
            else if (placeholder === undefined) {
                return [localeRef.value.placeholder];
            }
            else {
                return [placeholder];
            }
        });
        const showPlaceholder1Ref = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: isComposing } = isComposingRef;
            const { value: mergedValue } = mergedValueRef;
            const { value: mergedPlaceholder } = mergedPlaceholderRef;
            return (!isComposing &&
                ((0,_utils__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue) ||
                    (Array.isArray(mergedValue) && (0,_utils__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue[0]))) &&
                mergedPlaceholder[0]);
        });
        const showPlaceholder2Ref = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: isComposing } = isComposingRef;
            const { value: mergedValue } = mergedValueRef;
            const { value: mergedPlaceholder } = mergedPlaceholderRef;
            return (!isComposing &&
                mergedPlaceholder[1] &&
                ((0,_utils__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue) ||
                    (Array.isArray(mergedValue) && (0,_utils__WEBPACK_IMPORTED_MODULE_8__.isEmptyInputValue)(mergedValue[1]))));
        });
        // focus
        const mergedFocusRef = (0,vooks__WEBPACK_IMPORTED_MODULE_12__["default"])(() => {
            return props.internalForceFocus || focusedRef.value;
        });
        // clear
        const showClearButton = (0,vooks__WEBPACK_IMPORTED_MODULE_12__["default"])(() => {
            if (mergedDisabledRef.value ||
                props.readonly ||
                !props.clearable ||
                (!mergedFocusRef.value && !hoverRef.value)) {
                return false;
            }
            const { value: mergedValue } = mergedValueRef;
            const { value: mergedFocus } = mergedFocusRef;
            if (props.pair) {
                return (!!(Array.isArray(mergedValue) &&
                    (mergedValue[0] || mergedValue[1])) &&
                    (hoverRef.value || mergedFocus));
            }
            else {
                return !!mergedValue && (hoverRef.value || mergedFocus);
            }
        });
        // passwordVisible
        const mergedShowPasswordOnRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { showPasswordOn } = props;
            if (showPasswordOn) {
                return showPasswordOn;
            }
            if (props.showPasswordToggle)
                return 'click';
            return undefined;
        });
        const passwordVisibleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(false);
        // text-decoration
        const textDecorationStyleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { textDecoration } = props;
            if (!textDecoration)
                return ['', ''];
            if (Array.isArray(textDecoration)) {
                return textDecoration.map((v) => ({
                    textDecoration: v
                }));
            }
            return [
                {
                    textDecoration
                }
            ];
        });
        const textAreaScrollContainerWidthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(undefined);
        // textarea autosize
        const updateTextAreaStyle = () => {
            var _a, _b;
            if (props.type === 'textarea') {
                const { autosize } = props;
                if (autosize) {
                    textAreaScrollContainerWidthRef.value =
                        (_b = (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.$el) === null || _b === void 0 ? void 0 : _b.offsetWidth;
                }
                if (!textareaElRef.value)
                    return;
                if (typeof autosize === 'boolean')
                    return;
                const { paddingTop: stylePaddingTop, paddingBottom: stylePaddingBottom, lineHeight: styleLineHeight } = window.getComputedStyle(textareaElRef.value);
                const paddingTop = Number(stylePaddingTop.slice(0, -2));
                const paddingBottom = Number(stylePaddingBottom.slice(0, -2));
                const lineHeight = Number(styleLineHeight.slice(0, -2));
                const { value: textareaMirrorEl } = textareaMirrorElRef;
                if (!textareaMirrorEl)
                    return;
                if (autosize.minRows) {
                    const minRows = Math.max(autosize.minRows, 1);
                    const styleMinHeight = `${paddingTop + paddingBottom + lineHeight * minRows}px`;
                    textareaMirrorEl.style.minHeight = styleMinHeight;
                }
                if (autosize.maxRows) {
                    const styleMaxHeight = `${paddingTop + paddingBottom + lineHeight * autosize.maxRows}px`;
                    textareaMirrorEl.style.maxHeight = styleMaxHeight;
                }
            }
        };
        // word count
        const maxlengthRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { maxlength } = props;
            return maxlength === undefined ? undefined : Number(maxlength);
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.onMounted)(() => {
            // sync mirror if is not pair
            const { value } = mergedValueRef;
            if (!Array.isArray(value)) {
                syncMirror(value);
            }
        });
        // other methods
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        const vm = (0,vue__WEBPACK_IMPORTED_MODULE_0__.getCurrentInstance)().proxy;
        function doUpdateValue(value) {
            const { onUpdateValue, 'onUpdate:value': _onUpdateValue, onInput } = props;
            const { nTriggerFormInput } = formItem;
            if (onUpdateValue)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onUpdateValue, value);
            if (_onUpdateValue)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(_onUpdateValue, value);
            if (onInput)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onInput, value);
            uncontrolledValueRef.value = value;
            nTriggerFormInput();
        }
        function doChange(value) {
            const { onChange } = props;
            const { nTriggerFormChange } = formItem;
            if (onChange)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onChange, value);
            uncontrolledValueRef.value = value;
            nTriggerFormChange();
        }
        function doBlur(e) {
            const { onBlur } = props;
            const { nTriggerFormBlur } = formItem;
            if (onBlur)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onBlur, e);
            nTriggerFormBlur();
        }
        function doFocus(e) {
            const { onFocus } = props;
            const { nTriggerFormFocus } = formItem;
            if (onFocus)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onFocus, e);
            nTriggerFormFocus();
        }
        function doClear(e) {
            const { onClear } = props;
            if (onClear)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onClear, e);
        }
        function doUpdateValueBlur(e) {
            const { onInputBlur } = props;
            if (onInputBlur)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onInputBlur, e);
        }
        function doUpdateValueFocus(e) {
            const { onInputFocus } = props;
            if (onInputFocus)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onInputFocus, e);
        }
        function doDeactivate() {
            const { onDeactivate } = props;
            if (onDeactivate)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onDeactivate);
        }
        function doActivate() {
            const { onActivate } = props;
            if (onActivate)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onActivate);
        }
        function doClick(e) {
            const { onClick } = props;
            if (onClick)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onClick, e);
        }
        function doWrapperFocus(e) {
            const { onWrapperFocus } = props;
            if (onWrapperFocus)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onWrapperFocus, e);
        }
        function doWrapperBlur(e) {
            const { onWrapperBlur } = props;
            if (onWrapperBlur)
                (0,_utils__WEBPACK_IMPORTED_MODULE_13__.call)(onWrapperBlur, e);
        }
        // methods
        function handleCompositionStart() {
            isComposingRef.value = true;
        }
        function handleCompositionEnd(e) {
            isComposingRef.value = false;
            if (e.target === inputEl2Ref.value) {
                handleInput(e, 1);
            }
            else {
                handleInput(e, 0);
            }
        }
        function handleInput(e, index = 0, event = 'input') {
            const targetValue = e.target.value;
            syncMirror(targetValue);
            if (e instanceof InputEvent && !e.isComposing) {
                isComposingRef.value = false;
            }
            if (props.type === 'textarea') {
                const { value: textareaScrollbarInst } = textareaScrollbarInstRef;
                if (textareaScrollbarInst) {
                    textareaScrollbarInst.syncUnifiedContainer();
                }
            }
            syncSource = targetValue;
            if (isComposingRef.value)
                return;
            focusedInputCursorControl.recordCursor();
            const isIncomingValueValid = allowInput(targetValue);
            if (isIncomingValueValid) {
                if (!props.pair) {
                    event === 'input' ? doUpdateValue(targetValue) : doChange(targetValue);
                }
                else {
                    let { value } = mergedValueRef;
                    if (!Array.isArray(value)) {
                        value = ['', ''];
                    }
                    else {
                        value = [value[0], value[1]];
                    }
                    value[index] = targetValue;
                    event === 'input' ? doUpdateValue(value) : doChange(value);
                }
            }
            // force update to sync input's view with value
            // if not set, after input, input value won't sync with dom input value
            vm.$forceUpdate();
            if (!isIncomingValueValid) {
                void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(focusedInputCursorControl.restoreCursor);
            }
        }
        function allowInput(value) {
            const { countGraphemes, maxlength, minlength } = props;
            if (countGraphemes) {
                let graphemesCount;
                if (maxlength !== undefined) {
                    if (graphemesCount === undefined) {
                        graphemesCount = countGraphemes(value);
                    }
                    if (graphemesCount > Number(maxlength))
                        return false;
                }
                if (minlength !== undefined) {
                    if (graphemesCount === undefined) {
                        graphemesCount = countGraphemes(value);
                    }
                    if (graphemesCount < Number(maxlength))
                        return false;
                }
            }
            const { allowInput } = props;
            if (typeof allowInput === 'function') {
                return allowInput(value);
            }
            return true;
        }
        function handleInputBlur(e) {
            doUpdateValueBlur(e);
            if (e.relatedTarget === wrapperElRef.value) {
                doDeactivate();
            }
            if (!(e.relatedTarget !== null &&
                (e.relatedTarget === inputElRef.value ||
                    e.relatedTarget === inputEl2Ref.value ||
                    e.relatedTarget === textareaElRef.value))) {
                activatedRef.value = false;
            }
            dealWithEvent(e, 'blur');
            currentFocusedInputRef.value = null;
        }
        function handleInputFocus(e, index) {
            doUpdateValueFocus(e);
            focusedRef.value = true;
            activatedRef.value = true;
            doActivate();
            dealWithEvent(e, 'focus');
            if (index === 0) {
                currentFocusedInputRef.value = inputElRef.value;
            }
            else if (index === 1) {
                currentFocusedInputRef.value = inputEl2Ref.value;
            }
            else if (index === 2) {
                currentFocusedInputRef.value = textareaElRef.value;
            }
        }
        function handleWrapperBlur(e) {
            if (props.passivelyActivated) {
                doWrapperBlur(e);
                dealWithEvent(e, 'blur');
            }
        }
        function handleWrapperFocus(e) {
            if (props.passivelyActivated) {
                focusedRef.value = true;
                doWrapperFocus(e);
                dealWithEvent(e, 'focus');
            }
        }
        function dealWithEvent(e, type) {
            if (e.relatedTarget !== null &&
                (e.relatedTarget === inputElRef.value ||
                    e.relatedTarget === inputEl2Ref.value ||
                    e.relatedTarget === textareaElRef.value ||
                    e.relatedTarget === wrapperElRef.value)) {
                /**
                 * activeElement transfer inside the input, do nothing
                 */
            }
            else {
                if (type === 'focus') {
                    doFocus(e);
                    focusedRef.value = true;
                }
                else if (type === 'blur') {
                    doBlur(e);
                    focusedRef.value = false;
                }
            }
        }
        function handleChange(e, index) {
            handleInput(e, index, 'change');
        }
        function handleClick(e) {
            doClick(e);
        }
        function handleClear(e) {
            doClear(e);
            if (props.pair) {
                doUpdateValue(['', '']);
                doChange(['', '']);
            }
            else {
                doUpdateValue('');
                doChange('');
            }
        }
        function handleMouseDown(e) {
            const { onMousedown } = props;
            if (onMousedown)
                onMousedown(e);
            const { tagName } = e.target;
            if (tagName !== 'INPUT' && tagName !== 'TEXTAREA') {
                if (props.resizable) {
                    const { value: wrapperEl } = wrapperElRef;
                    if (wrapperEl) {
                        const { left, top, width, height } = wrapperEl.getBoundingClientRect();
                        const resizeHandleSize = 14;
                        if (left + width - resizeHandleSize < e.clientX &&
                            e.clientX < left + width &&
                            top + height - resizeHandleSize < e.clientY &&
                            e.clientY < top + height) {
                            // touching resize handle, just let it go.
                            // resize won't take focus, maybe there is a better way to do this.
                            // hope someone can figure out a better solution
                            return;
                        }
                    }
                }
                e.preventDefault();
                if (!focusedRef.value) {
                    focus();
                }
            }
        }
        function handleMouseEnter() {
            var _a;
            hoverRef.value = true;
            if (props.type === 'textarea') {
                (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.handleMouseEnterWrapper();
            }
        }
        function handleMouseLeave() {
            var _a;
            hoverRef.value = false;
            if (props.type === 'textarea') {
                (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.handleMouseLeaveWrapper();
            }
        }
        function handlePasswordToggleClick() {
            if (mergedDisabledRef.value)
                return;
            if (mergedShowPasswordOnRef.value !== 'click')
                return;
            passwordVisibleRef.value = !passwordVisibleRef.value;
        }
        function handlePasswordToggleMousedown(e) {
            if (mergedDisabledRef.value)
                return;
            e.preventDefault();
            const preventDefaultOnce = (e) => {
                e.preventDefault();
                (0,evtd__WEBPACK_IMPORTED_MODULE_14__.off)('mouseup', document, preventDefaultOnce);
            };
            (0,evtd__WEBPACK_IMPORTED_MODULE_14__.on)('mouseup', document, preventDefaultOnce);
            if (mergedShowPasswordOnRef.value !== 'mousedown')
                return;
            passwordVisibleRef.value = true;
            const hidePassword = () => {
                passwordVisibleRef.value = false;
                (0,evtd__WEBPACK_IMPORTED_MODULE_14__.off)('mouseup', document, hidePassword);
            };
            (0,evtd__WEBPACK_IMPORTED_MODULE_14__.on)('mouseup', document, hidePassword);
        }
        function handleWrapperKeydown(e) {
            var _a;
            (_a = props.onKeydown) === null || _a === void 0 ? void 0 : _a.call(props, e);
            switch (e.key) {
                case 'Escape':
                    handleWrapperKeydownEsc();
                    break;
                case 'Enter':
                    handleWrapperKeydownEnter(e);
                    break;
            }
        }
        function handleWrapperKeydownEnter(e) {
            var _a, _b;
            if (props.passivelyActivated) {
                const { value: focused } = activatedRef;
                if (focused) {
                    if (props.internalDeactivateOnEnter) {
                        handleWrapperKeydownEsc();
                    }
                    return;
                }
                e.preventDefault();
                if (props.type === 'textarea') {
                    (_a = textareaElRef.value) === null || _a === void 0 ? void 0 : _a.focus();
                }
                else {
                    (_b = inputElRef.value) === null || _b === void 0 ? void 0 : _b.focus();
                }
            }
        }
        function handleWrapperKeydownEsc() {
            if (props.passivelyActivated) {
                activatedRef.value = false;
                void (0,vue__WEBPACK_IMPORTED_MODULE_0__.nextTick)(() => {
                    var _a;
                    (_a = wrapperElRef.value) === null || _a === void 0 ? void 0 : _a.focus();
                });
            }
        }
        function focus() {
            var _a, _b, _c;
            if (mergedDisabledRef.value)
                return;
            if (props.passivelyActivated) {
                (_a = wrapperElRef.value) === null || _a === void 0 ? void 0 : _a.focus();
            }
            else {
                (_b = textareaElRef.value) === null || _b === void 0 ? void 0 : _b.focus();
                (_c = inputElRef.value) === null || _c === void 0 ? void 0 : _c.focus();
            }
        }
        function blur() {
            var _a;
            if ((_a = wrapperElRef.value) === null || _a === void 0 ? void 0 : _a.contains(document.activeElement)) {
                ;
                document.activeElement.blur();
            }
        }
        function select() {
            var _a, _b;
            (_a = textareaElRef.value) === null || _a === void 0 ? void 0 : _a.select();
            (_b = inputElRef.value) === null || _b === void 0 ? void 0 : _b.select();
        }
        function activate() {
            if (mergedDisabledRef.value)
                return;
            if (textareaElRef.value)
                textareaElRef.value.focus();
            else if (inputElRef.value)
                inputElRef.value.focus();
        }
        function deactivate() {
            const { value: wrapperEl } = wrapperElRef;
            if ((wrapperEl === null || wrapperEl === void 0 ? void 0 : wrapperEl.contains(document.activeElement)) &&
                wrapperEl !== document.activeElement) {
                handleWrapperKeydownEsc();
            }
        }
        function scrollTo(options) {
            if (props.type === 'textarea') {
                const { value: textareaEl } = textareaElRef;
                textareaEl === null || textareaEl === void 0 ? void 0 : textareaEl.scrollTo(options);
            }
            else {
                const { value: inputEl } = inputElRef;
                inputEl === null || inputEl === void 0 ? void 0 : inputEl.scrollTo(options);
            }
        }
        function syncMirror(value) {
            const { type, pair, autosize } = props;
            if (!pair && autosize) {
                if (type === 'textarea') {
                    const { value: textareaMirrorEl } = textareaMirrorElRef;
                    if (textareaMirrorEl) {
                        textareaMirrorEl.textContent = (value !== null && value !== void 0 ? value : '') + '\r\n';
                    }
                }
                else {
                    const { value: inputMirrorEl } = inputMirrorElRef;
                    if (inputMirrorEl) {
                        if (value) {
                            inputMirrorEl.textContent = value;
                        }
                        else {
                            inputMirrorEl.innerHTML = '&nbsp;';
                        }
                    }
                }
            }
        }
        function handleTextAreaMirrorResize() {
            updateTextAreaStyle();
        }
        const placeholderStyleRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)({
            top: '0'
        });
        function handleTextAreaScroll(e) {
            var _a;
            const { scrollTop } = e.target;
            placeholderStyleRef.value.top = `${-scrollTop}px`;
            (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.syncUnifiedContainer();
        }
        let stopWatchMergedValue1 = null;
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
            const { autosize, type } = props;
            if (autosize && type === 'textarea') {
                stopWatchMergedValue1 = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedValueRef, (value) => {
                    if (!Array.isArray(value) && value !== syncSource) {
                        syncMirror(value);
                    }
                });
            }
            else {
                stopWatchMergedValue1 === null || stopWatchMergedValue1 === void 0 ? void 0 : stopWatchMergedValue1();
            }
        });
        let stopWatchMergedValue2 = null;
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.watchEffect)(() => {
            if (props.type === 'textarea') {
                stopWatchMergedValue2 = (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(mergedValueRef, (value) => {
                    var _a;
                    if (!Array.isArray(value) && value !== syncSource) {
                        (_a = textareaScrollbarInstRef.value) === null || _a === void 0 ? void 0 : _a.syncUnifiedContainer();
                    }
                });
            }
            else {
                stopWatchMergedValue2 === null || stopWatchMergedValue2 === void 0 ? void 0 : stopWatchMergedValue2();
            }
        });
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.provide)(_interface__WEBPACK_IMPORTED_MODULE_15__.inputInjectionKey, {
            mergedValueRef,
            maxlengthRef,
            mergedClsPrefixRef,
            countGraphemesRef: (0,vue__WEBPACK_IMPORTED_MODULE_0__.toRef)(props, 'countGraphemes')
        });
        const exposedProps = {
            wrapperElRef,
            inputElRef,
            textareaElRef,
            isCompositing: isComposingRef,
            focus,
            blur,
            select,
            deactivate,
            activate,
            scrollTo
        };
        const rtlEnabledRef = (0,_mixins_use_rtl__WEBPACK_IMPORTED_MODULE_16__.useRtl)('Input', mergedRtlRef, mergedClsPrefixRef);
        const cssVarsRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: size } = mergedSizeRef;
            const { common: { cubicBezierEaseInOut }, self: { color, borderRadius, textColor, caretColor, caretColorError, caretColorWarning, textDecorationColor, border, borderDisabled, borderHover, borderFocus, placeholderColor, placeholderColorDisabled, lineHeightTextarea, colorDisabled, colorFocus, textColorDisabled, boxShadowFocus, iconSize, colorFocusWarning, boxShadowFocusWarning, borderWarning, borderFocusWarning, borderHoverWarning, colorFocusError, boxShadowFocusError, borderError, borderFocusError, borderHoverError, clearSize, clearColor, clearColorHover, clearColorPressed, iconColor, iconColorDisabled, suffixTextColor, countTextColor, countTextColorDisabled, iconColorHover, iconColorPressed, loadingColor, loadingColorError, loadingColorWarning, [(0,_utils__WEBPACK_IMPORTED_MODULE_17__.createKey)('padding', size)]: padding, [(0,_utils__WEBPACK_IMPORTED_MODULE_17__.createKey)('fontSize', size)]: fontSize, [(0,_utils__WEBPACK_IMPORTED_MODULE_17__.createKey)('height', size)]: height } } = themeRef.value;
            const { left: paddingLeft, right: paddingRight } = (0,seemly__WEBPACK_IMPORTED_MODULE_18__.getPadding)(padding);
            return {
                '--n-bezier': cubicBezierEaseInOut,
                '--n-count-text-color': countTextColor,
                '--n-count-text-color-disabled': countTextColorDisabled,
                '--n-color': color,
                '--n-font-size': fontSize,
                '--n-border-radius': borderRadius,
                '--n-height': height,
                '--n-padding-left': paddingLeft,
                '--n-padding-right': paddingRight,
                '--n-text-color': textColor,
                '--n-caret-color': caretColor,
                '--n-text-decoration-color': textDecorationColor,
                '--n-border': border,
                '--n-border-disabled': borderDisabled,
                '--n-border-hover': borderHover,
                '--n-border-focus': borderFocus,
                '--n-placeholder-color': placeholderColor,
                '--n-placeholder-color-disabled': placeholderColorDisabled,
                '--n-icon-size': iconSize,
                '--n-line-height-textarea': lineHeightTextarea,
                '--n-color-disabled': colorDisabled,
                '--n-color-focus': colorFocus,
                '--n-text-color-disabled': textColorDisabled,
                '--n-box-shadow-focus': boxShadowFocus,
                '--n-loading-color': loadingColor,
                // form warning
                '--n-caret-color-warning': caretColorWarning,
                '--n-color-focus-warning': colorFocusWarning,
                '--n-box-shadow-focus-warning': boxShadowFocusWarning,
                '--n-border-warning': borderWarning,
                '--n-border-focus-warning': borderFocusWarning,
                '--n-border-hover-warning': borderHoverWarning,
                '--n-loading-color-warning': loadingColorWarning,
                // form error
                '--n-caret-color-error': caretColorError,
                '--n-color-focus-error': colorFocusError,
                '--n-box-shadow-focus-error': boxShadowFocusError,
                '--n-border-error': borderError,
                '--n-border-focus-error': borderFocusError,
                '--n-border-hover-error': borderHoverError,
                '--n-loading-color-error': loadingColorError,
                // clear-button
                '--n-clear-color': clearColor,
                '--n-clear-size': clearSize,
                '--n-clear-color-hover': clearColorHover,
                '--n-clear-color-pressed': clearColorPressed,
                '--n-icon-color': iconColor,
                '--n-icon-color-hover': iconColorHover,
                '--n-icon-color-pressed': iconColorPressed,
                '--n-icon-color-disabled': iconColorDisabled,
                '--n-suffix-text-color': suffixTextColor
            };
        });
        const themeClassHandle = inlineThemeDisabled
            ? (0,_mixins__WEBPACK_IMPORTED_MODULE_19__.useThemeClass)('input', (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
                const { value: size } = mergedSizeRef;
                return size[0];
            }), cssVarsRef, props)
            : undefined;
        return Object.assign(Object.assign({}, exposedProps), { 
            // DOM ref
            wrapperElRef,
            inputElRef,
            inputMirrorElRef,
            inputEl2Ref,
            textareaElRef,
            textareaMirrorElRef,
            textareaScrollbarInstRef, 
            // value
            rtlEnabled: rtlEnabledRef, uncontrolledValue: uncontrolledValueRef, mergedValue: mergedValueRef, passwordVisible: passwordVisibleRef, mergedPlaceholder: mergedPlaceholderRef, showPlaceholder1: showPlaceholder1Ref, showPlaceholder2: showPlaceholder2Ref, mergedFocus: mergedFocusRef, isComposing: isComposingRef, activated: activatedRef, showClearButton, mergedSize: mergedSizeRef, mergedDisabled: mergedDisabledRef, textDecorationStyle: textDecorationStyleRef, mergedClsPrefix: mergedClsPrefixRef, mergedBordered: mergedBorderedRef, mergedShowPasswordOn: mergedShowPasswordOnRef, placeholderStyle: placeholderStyleRef, mergedStatus: mergedStatusRef, textAreaScrollContainerWidth: textAreaScrollContainerWidthRef, 
            // methods
            handleTextAreaScroll,
            handleCompositionStart,
            handleCompositionEnd,
            handleInput,
            handleInputBlur,
            handleInputFocus,
            handleWrapperBlur,
            handleWrapperFocus,
            handleMouseEnter,
            handleMouseLeave,
            handleMouseDown,
            handleChange,
            handleClick,
            handleClear,
            handlePasswordToggleClick,
            handlePasswordToggleMousedown,
            handleWrapperKeydown,
            handleTextAreaMirrorResize, getTextareaScrollContainer: () => {
                return textareaElRef.value;
            }, mergedTheme: themeRef, cssVars: inlineThemeDisabled ? undefined : cssVarsRef, themeClass: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.themeClass, onRender: themeClassHandle === null || themeClassHandle === void 0 ? void 0 : themeClassHandle.onRender });
    },
    render() {
        var _a, _b;
        const { mergedClsPrefix, mergedStatus, themeClass, type, countGraphemes, onRender } = this;
        const $slots = this.$slots;
        onRender === null || onRender === void 0 ? void 0 : onRender();
        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "wrapperElRef", class: [
                `${mergedClsPrefix}-input`,
                themeClass,
                mergedStatus && `${mergedClsPrefix}-input--${mergedStatus}-status`,
                {
                    [`${mergedClsPrefix}-input--rtl`]: this.rtlEnabled,
                    [`${mergedClsPrefix}-input--disabled`]: this.mergedDisabled,
                    [`${mergedClsPrefix}-input--textarea`]: type === 'textarea',
                    [`${mergedClsPrefix}-input--resizable`]: this.resizable && !this.autosize,
                    [`${mergedClsPrefix}-input--autosize`]: this.autosize,
                    [`${mergedClsPrefix}-input--round`]: this.round && !(type === 'textarea'),
                    [`${mergedClsPrefix}-input--pair`]: this.pair,
                    [`${mergedClsPrefix}-input--focus`]: this.mergedFocus,
                    [`${mergedClsPrefix}-input--stateful`]: this.stateful
                }
            ], style: this.cssVars, tabindex: !this.mergedDisabled && this.passivelyActivated && !this.activated
                ? 0
                : undefined, onFocus: this.handleWrapperFocus, onBlur: this.handleWrapperBlur, onClick: this.handleClick, onMousedown: this.handleMouseDown, onMouseenter: this.handleMouseEnter, onMouseleave: this.handleMouseLeave, onCompositionstart: this.handleCompositionStart, onCompositionend: this.handleCompositionEnd, onKeyup: this.onKeyup, onKeydown: this.handleWrapperKeydown },
            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input-wrapper` },
                (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots.prefix, (children) => children && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__prefix` }, children))),
                type === 'textarea' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_21__["default"], { ref: "textareaScrollbarInstRef", class: `${mergedClsPrefix}-input__textarea`, container: this.getTextareaScrollContainer, triggerDisplayManually: true, useUnifiedContainer: true, internalHoistYRail: true }, {
                    default: () => {
                        var _a, _b;
                        const { textAreaScrollContainerWidth } = this;
                        const scrollContainerWidthStyle = {
                            width: this.autosize &&
                                textAreaScrollContainerWidth &&
                                `${textAreaScrollContainerWidth}px`
                        };
                        return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vue__WEBPACK_IMPORTED_MODULE_0__.Fragment, null,
                            (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("textarea", Object.assign({}, this.inputProps, { ref: "textareaElRef", class: [
                                    `${mergedClsPrefix}-input__textarea-el`,
                                    (_a = this.inputProps) === null || _a === void 0 ? void 0 : _a.class
                                ], autofocus: this.autofocus, rows: Number(this.rows), placeholder: this.placeholder, value: this.mergedValue, disabled: this.mergedDisabled, maxlength: countGraphemes ? undefined : this.maxlength, minlength: countGraphemes ? undefined : this.minlength, readonly: this.readonly, tabindex: this.passivelyActivated && !this.activated
                                    ? -1
                                    : undefined, style: [
                                    this.textDecorationStyle[0],
                                    (_b = this.inputProps) === null || _b === void 0 ? void 0 : _b.style,
                                    scrollContainerWidthStyle
                                ], onBlur: this.handleInputBlur, onFocus: (e) => { this.handleInputFocus(e, 2); }, onInput: this.handleInput, onChange: this.handleChange, onScroll: this.handleTextAreaScroll })),
                            this.showPlaceholder1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__placeholder`, style: [
                                    this.placeholderStyle,
                                    scrollContainerWidthStyle
                                ], key: "placeholder" }, this.mergedPlaceholder[0])) : null,
                            this.autosize ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(vueuc__WEBPACK_IMPORTED_MODULE_22__["default"], { onResize: this.handleTextAreaMirrorResize }, {
                                default: () => ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { ref: "textareaMirrorElRef", class: `${mergedClsPrefix}-input__textarea-mirror`, key: "mirror" }))
                            })) : null));
                    }
                })) : ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__input` },
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", Object.assign({ type: type === 'password' &&
                            this.mergedShowPasswordOn &&
                            this.passwordVisible
                            ? 'text'
                            : type }, this.inputProps, { ref: "inputElRef", class: [
                            `${mergedClsPrefix}-input__input-el`,
                            (_a = this.inputProps) === null || _a === void 0 ? void 0 : _a.class
                        ], style: [
                            this.textDecorationStyle[0],
                            (_b = this.inputProps) === null || _b === void 0 ? void 0 : _b.style
                        ], tabindex: this.passivelyActivated && !this.activated ? -1 : undefined, placeholder: this.mergedPlaceholder[0], disabled: this.mergedDisabled, maxlength: countGraphemes ? undefined : this.maxlength, minlength: countGraphemes ? undefined : this.minlength, value: Array.isArray(this.mergedValue)
                            ? this.mergedValue[0]
                            : this.mergedValue, readonly: this.readonly, autofocus: this.autofocus, size: this.attrSize, onBlur: this.handleInputBlur, onFocus: (e) => { this.handleInputFocus(e, 0); }, onInput: (e) => { this.handleInput(e, 0); }, onChange: (e) => { this.handleChange(e, 0); } })),
                    this.showPlaceholder1 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__placeholder` },
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", null, this.mergedPlaceholder[0]))) : null,
                    this.autosize ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__input-mirror`, key: "mirror", ref: "inputMirrorElRef" }, "\u00A0")) : null)),
                !this.pair &&
                    (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots.suffix, (children) => {
                        return children ||
                            this.clearable ||
                            this.showCount ||
                            this.mergedShowPasswordOn ||
                            this.loading !== undefined ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__suffix` }, [
                            (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots['clear-icon-placeholder'], (children) => {
                                return ((this.clearable || children) && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_23__["default"], { clsPrefix: mergedClsPrefix, show: this.showClearButton, onClear: this.handleClear }, {
                                    placeholder: () => children,
                                    icon: () => { var _a, _b; return (_b = (_a = this.$slots)['clear-icon']) === null || _b === void 0 ? void 0 : _b.call(_a); }
                                })));
                            }),
                            !this.internalLoadingBeforeSuffix ? children : null,
                            this.loading !== undefined ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_24__["default"], { clsPrefix: mergedClsPrefix, loading: this.loading, showArrow: false, showClear: false, style: this.cssVars })) : null,
                            this.internalLoadingBeforeSuffix ? children : null,
                            this.showCount && this.type !== 'textarea' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_WordCount__WEBPACK_IMPORTED_MODULE_25__["default"], null, {
                                default: (props) => { var _a; return (_a = $slots.count) === null || _a === void 0 ? void 0 : _a.call($slots, props); }
                            })) : null,
                            this.mergedShowPasswordOn && this.type === 'password' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__eye`, onMousedown: this.handlePasswordToggleMousedown, onClick: this.handlePasswordToggleClick }, this.passwordVisible
                                ? (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveSlot)($slots['password-visible-icon'], () => [
                                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_26__["default"], { clsPrefix: mergedClsPrefix }, { default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons__WEBPACK_IMPORTED_MODULE_27__["default"], null) })
                                ])
                                : (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveSlot)($slots['password-invisible-icon'], () => [
                                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_26__["default"], { clsPrefix: mergedClsPrefix }, { default: () => (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal_icons__WEBPACK_IMPORTED_MODULE_28__["default"], null) })
                                ]))) : null
                        ])) : null;
                    })),
            this.pair ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", { class: `${mergedClsPrefix}-input__separator` }, (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveSlot)($slots.separator, () => [this.separator]))) : null,
            this.pair ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input-wrapper` },
                (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__input` },
                    (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("input", { ref: "inputEl2Ref", type: this.type, class: `${mergedClsPrefix}-input__input-el`, tabindex: this.passivelyActivated && !this.activated ? -1 : undefined, placeholder: this.mergedPlaceholder[1], disabled: this.mergedDisabled, maxlength: countGraphemes ? undefined : this.maxlength, minlength: countGraphemes ? undefined : this.minlength, value: Array.isArray(this.mergedValue)
                            ? this.mergedValue[1]
                            : undefined, readonly: this.readonly, style: this.textDecorationStyle[1], onBlur: this.handleInputBlur, onFocus: (e) => { this.handleInputFocus(e, 1); }, onInput: (e) => { this.handleInput(e, 1); }, onChange: (e) => { this.handleChange(e, 1); } }),
                    this.showPlaceholder2 ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__placeholder` },
                        (0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", null, this.mergedPlaceholder[1]))) : null),
                (0,_utils__WEBPACK_IMPORTED_MODULE_20__.resolveWrappedSlot)($slots.suffix, (children) => {
                    return ((this.clearable || children) && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__suffix` }, [
                        this.clearable && ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_internal__WEBPACK_IMPORTED_MODULE_23__["default"], { clsPrefix: mergedClsPrefix, show: this.showClearButton, onClear: this.handleClear }, {
                            icon: () => { var _a; return (_a = $slots['clear-icon']) === null || _a === void 0 ? void 0 : _a.call($slots); },
                            placeholder: () => { var _a; return (_a = $slots['clear-icon-placeholder']) === null || _a === void 0 ? void 0 : _a.call($slots); }
                        })),
                        children
                    ])));
                }))) : null,
            this.mergedBordered ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__border` })) : null,
            this.mergedBordered ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("div", { class: `${mergedClsPrefix}-input__state-border` })) : null,
            this.showCount && type === 'textarea' ? ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)(_WordCount__WEBPACK_IMPORTED_MODULE_25__["default"], null, {
                default: (props) => {
                    var _a;
                    const { renderCount } = this;
                    if (renderCount) {
                        return renderCount(props);
                    }
                    return (_a = $slots.count) === null || _a === void 0 ? void 0 : _a.call($slots, props);
                }
            })) : null));
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/WordCount.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/WordCount.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/vue/resolve-slot.js");
/* harmony import */ var _interface__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./interface */ "./node_modules/naive-ui/es/input/src/interface.js");
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils */ "./node_modules/naive-ui/es/input/src/utils.js");




/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,vue__WEBPACK_IMPORTED_MODULE_0__.defineComponent)({
    name: 'InputWordCount',
    setup(_, { slots }) {
        const { mergedValueRef, maxlengthRef, mergedClsPrefixRef, countGraphemesRef } = 
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        (0,vue__WEBPACK_IMPORTED_MODULE_0__.inject)(_interface__WEBPACK_IMPORTED_MODULE_1__.inputInjectionKey);
        const wordCountRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.computed)(() => {
            const { value: mergedValue } = mergedValueRef;
            if (mergedValue === null || Array.isArray(mergedValue))
                return 0;
            return (countGraphemesRef.value || _utils__WEBPACK_IMPORTED_MODULE_2__.len)(mergedValue);
        });
        return () => {
            const { value: maxlength } = maxlengthRef;
            const { value: mergedValue } = mergedValueRef;
            return ((0,vue__WEBPACK_IMPORTED_MODULE_0__.h)("span", { class: `${mergedClsPrefixRef.value}-input-word-count` }, (0,_utils__WEBPACK_IMPORTED_MODULE_3__.resolveSlotWithProps)(slots.default, {
                value: mergedValue === null || Array.isArray(mergedValue)
                    ? ''
                    : mergedValue
            }, () => [
                maxlength === undefined
                    ? wordCountRef.value
                    : `${wordCountRef.value} / ${maxlength}`
            ])));
        };
    }
}));


/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/interface.js":
/*!*********************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/interface.js ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   inputInjectionKey: () => (/* binding */ inputInjectionKey)
/* harmony export */ });
/* harmony import */ var _utils__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../_utils */ "./node_modules/naive-ui/es/_utils/vue/create-injection-key.js");

const inputInjectionKey = (0,_utils__WEBPACK_IMPORTED_MODULE_0__.createInjectionKey)('n-input');


/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/styles/input.cssr.js":
/*!*****************************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/styles/input.cssr.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__),
/* harmony export */   safariStyle: () => (/* binding */ safariStyle)
/* harmony export */ });
/* harmony import */ var _utils_cssr__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../_utils/cssr */ "./node_modules/naive-ui/es/_utils/cssr/index.js");

// vars:
// --n-bezier
// --n-color
// --n-font-size
// --n-border-radius
// --n-height
// --n-padding-left
// --n-padding-right
// --n-text-color
// --n-text-color-disabled
// --n-caret-color
// --n-text-decoration-color
// --n-border
// --n-border-disabled
// --n-border-hover
// --n-border-focus
// --n-placeholder-color
// --n-placeholder-color-disabled
// --n-line-height-textarea
// --n-color-disabled
// --n-color-focus
// --n-box-shadow-focus
// --n-clear-color
// --n-clear-size
// --n-clear-color-hover
// --n-clear-color-pressed
// --n-suffix-text-color
// --n-icon-color
// --n-icon-color-hover
// --n-icon-color-pressed
// --n-icon-color-disabled
// --n-count-text-color
// --n-count-text-color-disabled
// --n-loading-color
// ...form item vars
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ((0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input', `
 max-width: 100%;
 cursor: text;
 line-height: 1.5;
 z-index: auto;
 outline: none;
 box-sizing: border-box;
 position: relative;
 display: inline-flex;
 border-radius: var(--n-border-radius);
 background-color: var(--n-color);
 transition: background-color .3s var(--n-bezier);
 font-size: var(--n-font-size);
 --n-padding-vertical: calc((var(--n-height) - 1.5 * var(--n-font-size)) / 2);
`, [
// common
(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input, textarea', `
 overflow: hidden;
 flex-grow: 1;
 position: relative;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el, input-mirror, textarea-mirror, separator, placeholder', `
 box-sizing: border-box;
 font-size: inherit;
 line-height: 1.5;
 font-family: inherit;
 border: none;
 outline: none;
 background-color: #0000;
 text-align: inherit;
 transition:
 -webkit-text-fill-color .3s var(--n-bezier),
 caret-color .3s var(--n-bezier),
 color .3s var(--n-bezier),
 text-decoration-color .3s var(--n-bezier);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 -webkit-appearance: none;
 scrollbar-width: none;
 width: 100%;
 min-width: 0;
 text-decoration-color: var(--n-text-decoration-color);
 color: var(--n-text-color);
 caret-color: var(--n-caret-color);
 background-color: transparent;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&::-webkit-scrollbar, &::-webkit-scrollbar-track-piece, &::-webkit-scrollbar-thumb', `
 width: 0;
 height: 0;
 display: none;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&::placeholder', `
 color: #0000;
 -webkit-text-fill-color: transparent !important;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:-webkit-autofill ~', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'display: none;')])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('round', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('textarea', 'border-radius: calc(var(--n-height) / 2);')]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 pointer-events: none;
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 overflow: hidden;
 color: var(--n-placeholder-color);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('span', `
 width: 100%;
 display: inline-block;
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('textarea', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'overflow: visible;')]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('autosize', 'width: 100%;'), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('autosize', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('textarea-el, input-el', `
 position: absolute;
 top: 0;
 left: 0;
 height: 100%;
 `)]),
// input
(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input-wrapper', `
 overflow: hidden;
 display: inline-flex;
 flex-grow: 1;
 position: relative;
 padding-left: var(--n-padding-left);
 padding-right: var(--n-padding-right);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-mirror', `
 padding: 0;
 height: var(--n-height);
 line-height: var(--n-height);
 overflow: hidden;
 visibility: hidden;
 position: static;
 white-space: pre;
 pointer-events: none;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el', `
 padding: 0;
 height: var(--n-height);
 line-height: var(--n-height);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('+', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', `
 display: flex;
 align-items: center; 
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('textarea', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'white-space: nowrap;')]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('eye', `
 display: flex;
 align-items: center;
 justify-content: center;
 transition: color .3s var(--n-bezier);
 `),
// textarea
(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('textarea', 'width: 100%;', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input-word-count', `
 position: absolute;
 right: var(--n-padding-right);
 bottom: var(--n-padding-vertical);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('resizable', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input-wrapper', `
 resize: vertical;
 min-height: var(--n-height);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('textarea-el, textarea-mirror, placeholder', `
 height: 100%;
 padding-left: 0;
 padding-right: 0;
 padding-top: var(--n-padding-vertical);
 padding-bottom: var(--n-padding-vertical);
 word-break: break-word;
 display: inline-block;
 vertical-align: bottom;
 box-sizing: border-box;
 line-height: var(--n-line-height-textarea);
 margin: 0;
 resize: none;
 white-space: pre-wrap;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('textarea-mirror', `
 width: 100%;
 pointer-events: none;
 overflow: hidden;
 visibility: hidden;
 position: static;
 white-space: pre-wrap;
 overflow-wrap: break-word;
 `)]),
// pair
(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('pair', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, placeholder', 'text-align: center;'), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('separator', `
 display: flex;
 align-items: center;
 transition: color .3s var(--n-bezier);
 color: var(--n-text-color);
 white-space: nowrap;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 color: var(--n-icon-color);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 color: var(--n-icon-color);
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', `
 cursor: not-allowed;
 background-color: var(--n-color-disabled);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('border', 'border: var(--n-border-disabled);'), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 cursor: not-allowed;
 color: var(--n-text-color-disabled);
 text-decoration-color: var(--n-text-color-disabled);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', 'color: var(--n-placeholder-color-disabled);'), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('separator', 'color: var(--n-text-color-disabled);', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 color: var(--n-icon-color-disabled);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 color: var(--n-icon-color-disabled);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input-word-count', `
 color: var(--n-count-text-color-disabled);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('suffix, prefix', 'color: var(--n-text-color-disabled);', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 color: var(--n-icon-color-disabled);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('internal-icon', `
 color: var(--n-icon-color-disabled);
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('eye', `
 color: var(--n-icon-color);
 cursor: pointer;
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', `
 color: var(--n-icon-color-hover);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:active', `
 color: var(--n-icon-color-pressed);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', 'border: var(--n-border-hover);')]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('focus', 'background-color: var(--n-color-focus);', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border: var(--n-border-focus);
 box-shadow: var(--n-box-shadow-focus);
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('border, state-border', `
 box-sizing: border-box;
 position: absolute;
 left: 0;
 right: 0;
 top: 0;
 bottom: 0;
 pointer-events: none;
 border-radius: inherit;
 border: var(--n-border);
 transition:
 box-shadow .3s var(--n-bezier),
 border-color .3s var(--n-bezier);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border-color: #0000;
 z-index: 1;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('prefix', 'margin-right: 4px;'), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('suffix', `
 margin-left: 4px;
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('suffix, prefix', `
 transition: color .3s var(--n-bezier);
 flex-wrap: nowrap;
 flex-shrink: 0;
 line-height: var(--n-height);
 white-space: nowrap;
 display: inline-flex;
 align-items: center;
 justify-content: center;
 color: var(--n-suffix-text-color);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 font-size: var(--n-icon-size);
 margin: 0 2px;
 color: var(--n-loading-color);
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-clear', `
 font-size: var(--n-icon-size);
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('placeholder', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 transition: color .3s var(--n-bezier);
 color: var(--n-icon-color);
 font-size: var(--n-icon-size);
 `)])]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('>', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('icon', `
 transition: color .3s var(--n-bezier);
 color: var(--n-icon-color);
 font-size: var(--n-icon-size);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-icon', `
 font-size: var(--n-icon-size);
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input-word-count', `
 pointer-events: none;
 line-height: 1.5;
 font-size: .85em;
 color: var(--n-count-text-color);
 transition: color .3s var(--n-bezier);
 margin-left: 4px;
 font-variant: tabular-nums;
 `), ['warning', 'error'].map(status => (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)(`${status}-status`, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cNotM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('base-loading', `
 color: var(--n-loading-color-${status})
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 caret-color: var(--n-caret-color-${status});
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border: var(--n-border-${status});
 `), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:hover', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 border: var(--n-border-hover-${status});
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.c)('&:focus', `
 background-color: var(--n-color-focus-${status});
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-focus-${status});
 border: var(--n-border-focus-${status});
 `)]), (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('focus', `
 background-color: var(--n-color-focus-${status});
 `, [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('state-border', `
 box-shadow: var(--n-box-shadow-focus-${status});
 border: var(--n-border-focus-${status});
 `)])])]))]));
const safariStyle = (0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cB)('input', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cM)('disabled', [(0,_utils_cssr__WEBPACK_IMPORTED_MODULE_0__.cE)('input-el, textarea-el', `
 -webkit-text-fill-color: var(--n-text-color-disabled);
 `)])]);

/***/ }),

/***/ "./node_modules/naive-ui/es/input/src/utils.js":
/*!*****************************************************!*\
  !*** ./node_modules/naive-ui/es/input/src/utils.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   isEmptyInputValue: () => (/* binding */ isEmptyInputValue),
/* harmony export */   len: () => (/* binding */ len),
/* harmony export */   useCursor: () => (/* binding */ useCursor)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.runtime.esm-bundler.js");

function len(s) {
    let count = 0;
    // eslint-disable-next-line @typescript-eslint/no-unused-vars
    for (const _ of s) {
        count++;
    }
    return count;
}
function isEmptyInputValue(value) {
    return value === '' || value == null;
}
function useCursor(inputElRef) {
    const selectionRef = (0,vue__WEBPACK_IMPORTED_MODULE_0__.ref)(null);
    function recordCursor() {
        const { value: input } = inputElRef;
        if (!(input === null || input === void 0 ? void 0 : input.focus)) {
            reset();
            return;
        }
        const { selectionStart, selectionEnd, value } = input;
        if (selectionStart == null || selectionEnd == null) {
            reset();
            return;
        }
        selectionRef.value = {
            start: selectionStart,
            end: selectionEnd,
            beforeText: value.slice(0, selectionStart),
            afterText: value.slice(selectionEnd)
        };
    }
    function restoreCursor() {
        var _a;
        const { value: selection } = selectionRef;
        const { value: inputEl } = inputElRef;
        if (!selection || !inputEl) {
            return;
        }
        const { value } = inputEl;
        const { start, beforeText, afterText } = selection;
        let startPos = value.length;
        if (value.endsWith(afterText)) {
            startPos = value.length - afterText.length;
        }
        else if (value.startsWith(beforeText)) {
            startPos = beforeText.length;
        }
        else {
            const beforeLastChar = beforeText[start - 1];
            const newIndex = value.indexOf(beforeLastChar, start - 1);
            if (newIndex !== -1) {
                startPos = newIndex + 1;
            }
        }
        (_a = inputEl.setSelectionRange) === null || _a === void 0 ? void 0 : _a.call(inputEl, startPos, startPos);
    }
    function reset() {
        selectionRef.value = null;
    }
    (0,vue__WEBPACK_IMPORTED_MODULE_0__.watch)(inputElRef, reset);
    return {
        recordCursor,
        restoreCursor
    };
}


/***/ })

}]);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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